#!/usr/bin/perl -w

#$Header: /home2/cvsroot/LogTrend/Visu/NetworkNode.pm,v 1.20 2001/11/19 10:56:54 slhullier Exp $
##******************************************************************************
## Class NetworkNode  isa ArchitectureNode
##  Description  : class for network (correspond to Network XML tag)
##  Project      : LogTrend 1.0.0.0 - Atrid Systemes
##  Author       : Sylvain Lhullier s.lhullier@atrid.fr
##******************************************************************************
#$Log: NetworkNode.pm,v $
#Revision 1.20  2001/11/19 10:56:54  slhullier
#little bit stable, before big modification
#
#Revision 1.19  2001/11/14 14:13:48  slhullier
#*** empty log message ***
#
#Revision 1.18  2001/11/14 14:01:51  slhullier
#SystemsDeclaration reference communication
#
#Revision 1.17  2001/11/09 16:12:53  slhullier
#Form for report generation
#
#Revision 1.16  2001/10/29 15:38:22  slhullier
#Accent bug fixed?
#
#Revision 1.15  2001/10/26 12:33:03  slhullier
#Visu attributes are optional. Systems could not be present in report/web.
#
#Revision 1.14  2001/10/24 12:00:39  slhullier
#First version for report-generation
#
#Revision 1.13  2001/10/18 15:22:58  slhullier
#Inheritance for report/web
#
#Revision 1.12  2001/09/18 08:09:17  slhullier
#Using GetDataInRelativeTimeInterval
#
#Revision 1.11  2001/09/07 13:22:17  lsimonneau
#Add support of URL like http://myserver.com/LogTrendVisu/MyClientName/TheNetwork/
#
#Revision 1.10  2001/08/17 13:32:43  slhullier
#
#Correct accents for pictures/HTML Perl 5.005/5.6
#
#Revision 1.9  2001/07/31 07:34:51  slhullier
#
#new Image tested + delete toString
#
#Revision 1.8  2001/06/28 15:12:24  slhullier
#
#Die->die
#
#Revision 1.7  2001/06/25 16:52:23  slhullier
#
#Multi process
#
#Revision 1.6  2001/06/21 16:57:14  slhullier
#
#Ajout de liens, capture d'ecran effectuee ...
#
#Revision 1.5  2001/06/15 15:13:23  slhullier
#
#Mise en page dans les tableaux
#
#Revision 1.4  2001/06/15 07:17:16  slhullier
#
#Ajout de $ pour CVS
#

package LogTrend::Visu::NetworkNode;

use strict;

use LogTrend::Visu::ArchitectureNode;
use LogTrend::Visu::Request;
use LogTrend::Visu::Response;
use LogTrend::Visu::Utils;

use vars qw( @ISA );
@ISA = ("LogTrend::Visu::ArchitectureNode");

##******************************************************************************
## Constructor  public
##  Parameters   : the root node, an optional VisuClass
##******************************************************************************
sub new
{
   my ($classname,$rootnode,$systemsDeclaration) = @_;
   my $self = $classname->SUPER::new();
   bless($self, $classname);

   $self->{IP_ADDRESS} = $self->{NETMASK} = $self->{DESCRIPTION} = "";

   my %architectureNode = ();

   for my $kid ($rootnode->getChildNodes())
   {
      my $nodeName = $kid->getNodeName();
      if( $nodeName eq "Name" )
      { $self->{NAME} = AccentsXML2Text( $kid->getFirstChild()->getNodeValue() ); }
      elsif( $nodeName eq "IP_Address" )
      { $self->{IP_ADDRESS} = AccentsXML2Text( $kid->getFirstChild()->getNodeValue() ); }
      elsif( $nodeName eq "Netmask" )
      { $self->{NETMASK} = AccentsXML2Text( $kid->getFirstChild()->getNodeValue() ); }
      elsif( $nodeName eq "Description" )
      { $self->{DESCRIPTION} = AccentsXML2Text( $kid->getFirstChild()->getNodeValue() ); }
      elsif( $nodeName eq "Network" )
      {
         my $n = $self->newNetworkNode( $kid, $systemsDeclaration );
         if( defined($n) ) # some systems are not wanted for reports or web
         {
            $architectureNode{$n->ident()} = $n;
         }
      }
      elsif( $nodeName eq "System" )
      {
         my $s = $self->newSystemLeaf( $kid, $systemsDeclaration );
         if( defined($s) ) # some systems are not wanted for reports or web
         {
            $architectureNode{$s->ident()} = $s;
         }
      }

   }

   if( int(keys %architectureNode) == 0 )
   {                    # some systems are not wanted for reports or web
      $self = undef;
      return undef;
   }

   die("No Name in NetworkNode XML tag") if( !defined($self->{NAME}) );

   $self->{ARCHITECTURENODE} = \%architectureNode;


   return $self;
}

##******************************************************************************
## Method buildTree  public >ArchitectureNode
##  Description  : put this object in an HTML tree
##  Parameters   : the dir
##  Return value : the string
##******************************************************************************
sub buildTree
{
   my ($self,$dir) = @_;

   my $here;
   if( $dir ne "" ) { $here = $dir."/".$self->ident(); }
   else             { $here = $self->ident(); }

   my $result = $self->buildTree_header($dir);

   my $architectureNode = $self->{ARCHITECTURENODE};
   foreach my $var (sort keys %$architectureNode)
   {
      $result .= $architectureNode->{$var}->buildTree($here);
   }

   $result .= $self->buildTree_footer($dir);
   return $result;
}

##******************************************************************************
## Method buildTree_header  protected
##  Description  : called by buildTree for the header
##  Parameters   : the dir
##  Return value : a string
##******************************************************************************
sub buildTree_header
{
   # To be written in the inherit objects
}

##******************************************************************************
## Method buildTree_footer  protected
##  Description  : called by buildTree for the footer
##  Parameters   : none
##  Return value : a string
##******************************************************************************
sub buildTree_footer
{
   # To be written in the inherit objects
}

##******************************************************************************
## Method treat  public >ArchitectureNode
##  Description  : treat a request
##  Parameters   : a Request
##  Return value : a Response
##******************************************************************************
sub treat
{
}

##******************************************************************************
1;
