#!/usr/bin/perl -w

#$Header: /home2/cvsroot/LogTrend/Visu/DataBaseManager.pm,v 1.2 2001/12/05 16:32:36 slhullier Exp $
##******************************************************************************
## Class DataBaseManager
##  Description  : A package for managing databases
##  Project      : LogTrend 1.0.0.0 - Atrid Systemes
##  Author       : Sylvain Lhullier s.lhullier@atrid.fr
##******************************************************************************
#$Log: DataBaseManager.pm,v $
#Revision 1.2  2001/12/05 16:32:36  slhullier
#Error management with try/otherwise ...
#
#Revision 1.1  2001/11/15 14:42:54  slhullier
#DataBaseManager adding
#

package LogTrend::Visu::DataBaseManager;

use strict;
use LogTrend::DataBaseAccess::PostgreSQLDataBase;
use LogTrend::Visu::Utils;

##******************************************************************************
## Private global hash for database references storage
##******************************************************************************
my %databaseGlobalHash = ();

##******************************************************************************
## Class-Method getDatabase  public
##  Description  : to have an object to join a database
##  Parameters   : database, host, port, user, passwd
##  Side effect  : create a new database only if not yet existing
##  Return value : the data base
##******************************************************************************
sub getDatabase
{
   my ($class,$database,$host,$port,$user,$passwd) = @_;

   my $id = getIdentifier($database,$host,$port,$user,$passwd);
   if( !defined( $databaseGlobalHash{$id} ) )
   {
      $databaseGlobalHash{$id} = createDatabase( $id );
   }

   return $databaseGlobalHash{$id};
}

##******************************************************************************
## Class-Method reConnectDatabases  public
##  Description  : re-connect each database of the manager
##  Parameters   : none
##  Return value : none
##  Nota bene    : needed after a fork for the child
##******************************************************************************
sub reConnectDatabases
{
   my ($class) = @_;
   foreach my $id (keys %databaseGlobalHash)
   {
      $databaseGlobalHash{$id}->disconnect();
      $databaseGlobalHash{$id} = createDatabase( $id );
   }
}

##******************************************************************************
## Class-Method getIdentifier  private
##******************************************************************************
sub getIdentifier
{
   my ($database,$host,$port,$user,$passwd) = @_;
   return "$database\t$host\t$port\t$user\t$passwd";
}

##******************************************************************************
## Class-Method createDatabase  private
##******************************************************************************
sub createDatabase
{
   my ($id) = @_;

   my ($database,$host,$port,$user,$passwd) = ($id=~/(.*)\t(.*)\t(.*)\t(.*)\t(.*)/);

   $SIG{__WARN__} = sub { $Utils_WarningMessage = $_[0] };

   my $db = new LogTrend::DataBaseAccess::PostgreSQLDataBase( $database,$host,$port,
                                                              $user,$passwd) ||
      die("new PostgreSQLDataBase($database,$host,$port,$user,$passwd): $!");

   return $db;
}

##******************************************************************************
1;
