#!/usr/bin/perl -w

#$Header: /home2/cvsroot/LogTrend/Visu/ArchitectureNode.pm,v 1.11 2001/11/15 16:08:57 slhullier Exp $
##******************************************************************************
## Class ArchitectureNode  abstract
##  Description  : class from which inherit NetworkNode and SystemLeaf
##  Project      : LogTrend 1.0.0.0 - Atrid Systemes
##  Author       : Sylvain Lhullier s.lhullier@atrid.fr
##******************************************************************************
#$Log: ArchitectureNode.pm,v $
#Revision 1.11  2001/11/15 16:08:57  slhullier
#UserNode managing first version (still bugs)
#
#Revision 1.10  2001/10/29 14:06:02  slhullier
#Stable but non-realy working report via the web
#
#Revision 1.9  2001/10/24 12:00:39  slhullier
#First version for report-generation
#
#Revision 1.8  2001/09/07 13:22:17  lsimonneau
#Add support of URL like http://myserver.com/LogTrendVisu/MyClientName/TheNetwork/
#
#Revision 1.7  2001/06/25 16:52:23  slhullier
#
#Multi process
#
#Revision 1.6  2001/06/21 16:57:14  slhullier
#
#Ajout de liens, capture d'ecran effectuee ...
#
#Revision 1.5  2001/06/15 07:17:16  slhullier
#
#Ajout de $ pour CVS
#

package LogTrend::Visu::ArchitectureNode;

use strict;
use LogTrend::Visu::Request;
use LogTrend::Visu::Response;

##******************************************************************************
## Constructor  public
##  Parameters   : none
##******************************************************************************
sub new
{
   my ($classname) = @_;
   my $self = {};
   bless($self, $classname);
   $self->{IDENT} = $self->newIdent();
   return $self;
}

##******************************************************************************
## Method newIdent  protected
##  Description  : return an uniq identificator for an ArchitectureNode
##  Parameters   : none
##  Return value : the identificator
##******************************************************************************
my $ident = 0;
sub newIdent
{
   my ($self) = @_;
   my $i = $ident;
   $ident++;
   return "a".sprintf("%03d",$i);
}

##******************************************************************************
## Method ident  public
##  Description  : return the identificator value
##  Parameters   : none
##  Return value : a string
##******************************************************************************
sub ident
{
   my ($self) = @_;
   return $self->{IDENT};
}

##******************************************************************************
## Method name  public
##  Description  : returns a string to name this node
##  Parameters   : none
##  Return value : a string
##******************************************************************************
sub name
{
   my ($self) = @_;
   my $result = "$self->{NAME}";
   if( $self->{DESCRIPTION} ne "" )
   {
      $result .= " ($self->{DESCRIPTION})";
   }
   return $result;
}


##******************************************************************************
## Method getName  public
##  Description  : returns the node's name with - instead of spaces
##  Parameters   : none
##  Return value : a string
##******************************************************************************
sub getName
{
   my ($self) = @_;
   my $name = $self->{NAME};
   $name =~ s/\s/-/g;
   return $name;
}


##******************************************************************************
## Method buildTree  public
##  Description  : put this object in an HTML/docbook tree
##  Parameters   : none
##  Return value : the string
##******************************************************************************
sub buildTree
{

}

##******************************************************************************
## Method treat  public
##  Description  : treat a request
##  Parameters   : a Request object
##  Return value : a Response object
##******************************************************************************
sub treat
{

}

##******************************************************************************
1;
