#!/usr/bin/perl -w

#$Header: /home2/cvsroot/LogTrend/Agent/AgentDescriptionToDB/MailDescriptionSender.pm,v 1.10.2.2 2002/02/20 14:25:34 lsimonneau Exp $
##******************************************************************************
## Class MailDescriptionSender  isa  DescriptionSender
##  Description  : class for sending description to the server via mail
##  Project      : LogTrend 1.0.0.0 - Atrid Systemes
##  Author       : Laurent Simonneau l.simonneau@atrid.fr
##  Author       : Sylvain Lhullier s.lhullier@atrid.fr
##******************************************************************************
#$Log: MailDescriptionSender.pm,v $
#Revision 1.10.2.2  2002/02/20 14:25:34  lsimonneau
#*** empty log message ***
#
#Revision 1.15  2002/02/20 14:20:31  lsimonneau
#Use Reply-To instead of Return-Path in mails
#
#Revision 1.14  2002/02/20 14:04:48  lsimonneau
#Change Reply to instead of Return-Path in agents and MailBridge.pl.
#Major bugfixes in StorageServer GPG Key rings management.
#
#Revision 1.10.2.1  2002/02/14 15:43:30  lsimonneau
#Minor features enhancement
#Add a Sender attribut in the Mail tag of agents config file.
#Use SMTP Server when available or /usr/lib/sendmail otherwise.
#Add the -s <smtp_server> option to MailBridge.pl.
#
#Revision 1.11  2002/02/13 10:42:29  lsimonneau
#*** empty log message ***
#
#Revision 1.10  2002/01/16 14:42:45  slhullier
#sendmail -f$self->{ADMINMAIL}
#
#Revision 1.9  2002/01/08 12:42:56  lsimonneau
#Major bugfixes : Correct signature crash in daemon mode and use /usr/lib/sendmail -t -i
#to send mail insetead of MIME::Entity->smtpsend
#
#Revision 1.8  2001/11/16 10:32:28  lsimonneau
#Major feature enhancement : Implementation of authentification with RSA signatu
#re.
#
#IMPORTANT : Agents are incompatible with older version.
#
#Revision 1.7  2001/10/05 11:55:08  slhullier
#in the other case -> otherwise
#
#Revision 1.6  2001/07/27 14:41:23  lsimonneau
#Include UpdateAgentDescription in AgentDescriptionToDB.
#
#Revision 1.5  2001/06/07 14:08:54  slhullier
#
#Passage de  unshift @INC,'..';  aux packages Logtrend::....
#
#Revision 1.4  2001/03/23 17:14:35  slhullier
#
#MailBridge: todo en XML, donnees gzip
#Pas fini : gunzip description
#
#Revision 1.3  2001/02/20 17:01:27  slhullier
#
#Mise en commentaire (+tab etc)
#
#Revision 1.2  2001/02/09 13:58:45  slhullier
#
#
#MailBridge Description Ok.
#Tests en situation reelle.
#
#Revision 1.1  2001/02/09 13:25:30  slhullier
#
#
#MailBridge pour AgentDescriptionToDB
#Ok pour la connection directe.
#Ok pour le mail cote emission.
#

package LogTrend::Agent::AgentDescriptionToDB::MailDescriptionSender;

use strict;
use LogTrend::Agent::AgentDescriptionToDB::DescriptionSender;
use MIME::Entity;
use Net::SMTP;

use vars qw( @ISA );
@ISA = ("LogTrend::Agent::AgentDescriptionToDB::DescriptionSender");

##******************************************************************************
## Constructor  public  (>DescriptionSender)
##  Parameters   : informations for identicification
##******************************************************************************
sub new
{
   my ( $classname, $databasename, $host, $port, $username,
        $password, $mailforbridge, $smtp_server, $admin_mail, $sender_mail,  $ancestor_source, $ancestor_number) = @_;
   my $self = $classname->SUPER::new( $databasename, $host,
                                      $port, $username, $password,  $ancestor_source, $ancestor_number);
   $self->{MAILFORBRIDGE} = $mailforbridge;
   $self->{ADMIN_MAIL} = $admin_mail;
   $self->{SENDER_MAIL} = $admin_mail;
   $self->{SMTP_SERVER} = $smtp_server;
   bless($self, $classname);
   return $self;
}

##******************************************************************************
## Function SetData  public  (>DescriptionSender)
##  Description  : sends the agent's data and alarms to a storage server
##  Parameters   : none
##******************************************************************************
sub SendDescription
{
   my ($self, $xmldata, $signature) = @_;

   ##===========================================================================
   ## Directory creation
   ##===========================================================================
   my $tmpFilePrefix = "/tmp/logtrend-agentdescriptiontodb-";
   my $i=0;
   my $dir = $tmpFilePrefix.$$."-".$i;
   $! = 0;
   while( !mkdir( $dir, 0700 ) &&
          $!{EEXIST} )   # file exists
   {
      $i ++;
      $dir = $tmpFilePrefix.$$."-".$i;
      $! = 0;
   }

   if( $! )
   {
      return "ERROR IO mkdir $dir : $!";
   }

   ##===========================================================================
   ## Files creation
   ##===========================================================================
   if( ! open( TODO, ">$dir/todo.xml" ) ) { 
       rmdir  "$dir"; 
       return "ERROR IO open $dir/todo.xml : $!"; 
   }

   print TODO "<Description D=\"".$self->{DATABASENAME}."\" H=\"".$self->{HOST}."\" P=\"".$self->{PORT},
              "\" U=\"".$self->{USERNAME}."\" Pw=\"".$self->{PASSWORD}."\"";
   print TODO " S=\"".$self->{ANCESTOR_SOURCE}."\" N=\"".$self->{ANCESTOR_NUMBER}."\"" if defined $self->{ANCESTOR_SOURCE};
   print TODO "/>\n";
   close TODO;

   if( ! open( DESCRIPTION, "|gzip -c>$dir/description.xml.gz" )) {
       unlink "$dir/todo.xml"; 
       rmdir  "$dir"; 
       return "ERROR IO open gzip -c>$dir/description.xml.gz : $!"; 
   }

   print DESCRIPTION $xmldata;
   close( DESCRIPTION );
 
   if(! open( SIGNATURE, ">$dir/signature.asc" ) ) {
       unlink "$dir/todo.xml", "$dir/description.xml.gz"; 
       rmdir  "$dir"; 
       return "ERROR IO open $dir/signature.asc : $!"; 
   }
   
   print SIGNATURE $signature;
   close( SIGNATURE );
 
   ##===========================================================================
   ## Creating Mail
   ##===========================================================================
   my $mail = MIME::Entity->build( "Type"        => "multipart/mixed",
                                   "To"          => "$self->{MAILFORBRIDGE}",
                                   "From"        => "$self->{SENDER_MAIL}",
                                   "Reply-To" => "$self->{ADMIN_MAIL}",
                                   "Subject"     => "LogTrend: AgentDescriptionToDB" );
   if( !defined($mail) )
   {
      unlink "$dir/todo.xml", "$dir/description.xml.gz";
      rmdir  "$dir";
      return 0;
   }

   $mail->attach( Path        => "$dir/todo.xml",
                  Type        => "text/xml",
                  Encoding    => "quoted-printable" );

   $mail->attach( Path        => "$dir/description.xml.gz",
                  Type        => "application/x-gzip",
                  Encoding    => "base64" );

   $mail->attach( Path        => "$dir/signature.asc",
                  Type        => "text/plain",
                  Encoding    => "base64" );

   ##===========================================================================
   ## Sending Mail
   ##===========================================================================

    if($self->{SMTP_SERVER} eq 'localhost') {
        open(MAILER, "| /usr/lib/sendmail -t  -i -f$self->{_MAIL_SENDER}");
        $mail->print(\*MAILER);
        close(MAILER);
    }
    else {
        my $smtp = Net::SMTP->new($self->{SMTP_SERVER});
        $smtp->mail($self->{SENDER_MAIL});
        $smtp->to($self->{MAILFORBRIDGE});
        $smtp->data([ $mail->stringify ]);
        $smtp->quit;
    }

   print "Mail sent to ".$self->{MAILFORBRIDGE}."\n";

   ##===========================================================================
   ## Deleting file & directory
   ##===========================================================================
   unlink "$dir/todo.xml", "$dir/description.xml.gz", "$dir/signature.asc";
   rmdir  "$dir";
   
   return "OK";
}

##******************************************************************************
1;
