#!/usr/bin/perl -w

#$Header: /home2/cvsroot/LogTrend/Action/SMS/SMSUserAgent.pm,v 1.1 2001/10/31 16:44:53 lsimonneau Exp $
##*****************************************************************************
##  Class SMSUserAgent
##  Description  : Like UserAgent but don't automatically follow 
##                 302 Moved Temporarily
##
##  Project      : LogTrend 1.0.0.0 - Atrid Systemes
##  Author       : Laurent Simonneau l.simonneau@atrid.fr
##*****************************************************************************
#$Log: SMSUserAgent.pm,v $
#Revision 1.1  2001/10/31 16:44:53  lsimonneau
#Move Action from ComplexAlarm to LogTrend root.
#
#Revision 1.2  2001/06/21 16:07:14  lsimonneau
#Dplacement de la clause 'package' avant les 'use'
#
#Revision 1.1  2001/05/30 09:36:57  lsimonneau
#Premire version du module d'alarmes complexes dans le CVS.
#Toutes les fonctionnalits ont t testes et correctement.
#

package SMSUserAgent;

use LWP;
use strict;


@SMSUserAgent::ISA = ("LWP::UserAgent");


sub new {
    my($classname, $init) = @_;
    my $self = $classname->SUPER::new($init);
    
    bless($self, $classname);
    
    return $self;
}



sub request
{
    my($self, $request, $arg, $size, $previous) = @_;

    LWP::Debug::trace('()');

    my $response = $self->simple_request($request, $arg, $size);

    my $code = $response->code;
    $response->previous($previous) if defined $previous;

    LWP::Debug::debug('Simple response: ' .
		      (HTTP::Status::status_message($code) ||
		       "Unknown code $code"));

    if ($code == &HTTP::Status::RC_UNAUTHORIZED ||
	$code == &HTTP::Status::RC_PROXY_AUTHENTICATION_REQUIRED
	)
    {
	my $proxy = ($code == &HTTP::Status::RC_PROXY_AUTHENTICATION_REQUIRED);
	my $ch_header = $proxy ?  "Proxy-Authenticate" : "WWW-Authenticate";
	my @challenge = $response->header($ch_header);
	unless (@challenge) {
	    $response->header("Client-Warning" => 
			      "Missing Authenticate header");
	    return $response;
	}

	require HTTP::Headers::Util;
	CHALLENGE: for my $challenge (@challenge) {
	    $challenge =~ tr/,/;/;  # "," is used to separate auth-params!!
	    ($challenge) = HTTP::Headers::Util::split_header_words($challenge);
	    my $scheme = lc(shift(@$challenge));
	    shift(@$challenge); # no value
	    $challenge = { @$challenge };  # make rest into a hash
	    for (keys %$challenge) {       # make sure all keys are lower case
		$challenge->{lc $_} = delete $challenge->{$_};
	    }

	    unless ($scheme =~ /^([a-z]+(?:-[a-z]+)*)$/) {
		$response->header("Client-Warning" => 
				  "Bad authentication scheme '$scheme'");
		return $response;
	    }
	    $scheme = $1;  # untainted now
	    my $class = "LWP::Authen::\u$scheme";
	    $class =~ s/-/_/g;
	
	    no strict 'refs';
	    unless (%{"$class\::"}) {
		# try to load it
		eval "require $class";
		if ($@) {
		    if ($@ =~ /^Can\'t locate/) {
			$response->header("Client-Warning" =>
					  "Unsupported authentication scheme '$scheme'");
		    } else {
			$response->header("Client-Warning" => $@);
		    }
		    next CHALLENGE;
		}
	    }
	    return $class->authenticate($self, $proxy, $challenge, $response,
					$request, $arg, $size);
	}
	return $response;
    }
    return $response;
}
