#!/usr/bin/perl -w

#$Header: /mnt/u1/cvs/logtrend/logtrend-doc/doc/LogTrend-SimpleAgent-0.82.2/lib/LogTrend/Crypto/Signature.pm,v 1.1 2002/04/10 01:18:48 jdive Exp $
##******************************************************************************
## Signature
##  Description  : Build RSA signature of a message
##  Project      : LogTrend 1.0.0.0 - Atrid Systemes
##  Author       : Laurent Simonneau l.simonneau@atrid.fr
##
##******************************************************************************
#$Log: Signature.pm,v $
#Revision 1.1  2002/04/10 01:18:48  jdive
#fixed description, uncompressed simpleagent
#
#Revision 1.2  2001/12/10 16:58:34  lsimonneau
#Use GnuPG::Interface instead of Crypt::RSA for perl 5.005 compatibility.
#
#Revision 1.1  2001/11/16 10:28:09  lsimonneau
#First version of this modules.
#Used for RSA signature authentication.
#
package LogTrend::Crypto::Signature;

use Exporter;
use vars qw( @ISA @EXPORT );
use strict;
use IO::Handle;
use GnuPG::Interface;

@ISA = qw(Exporter);
@EXPORT = qw( &sign_message );

##*****************************************************************************
## Method sign_message  public
##  Description  : Return the RSA signature of a message
##
##  Parameters   : The Private Key file name
##                 the message.
##*****************************************************************************
sub sign_message
{
    my ($gpg_home, $message) = @_;

    ## Create a GnuPG::Interface object
    my $gpg = new GnuPG::Interface;
    $gpg->options->hash_init( armor    => 1,
                              homedir  => $gpg_home,
                              always_trust => 1);


    my ( $input, $output, $error, $status_fh ) = ( IO::Handle->new(),
                                                   IO::Handle->new(),
                                                   IO::Handle->new(),
                                                   IO::Handle->new(),
                                                   );
    
    my $handles = GnuPG::Handles->new( stdin    => $input,
                                       stdout   => $output,
                                       stderr   => $error,
                                       status   => $status_fh,
                                       );

    
    my $sign_pid = $gpg->detach_sign( handles => $handles );

    print $input $message;
    close $input;

    waitpid($sign_pid, 0);

    my $stat = <$status_fh>;
    if($stat =~ /^\[GNUPG:\] GOOD_PASSPHRASE/) {
        $stat = <$status_fh>;
    }

    if(!defined $stat or $stat !~ /\[GNUPG:\] SIG_CREATED D/) {
        my @err = <$error>;
        die "Can't create GPG signature : @err";
    }

    my $signature = <$output>;
    $signature .= $_ while <$output>;

    close $output;
    close $status_fh;
    close $error;

    return $signature;
}

1;
