#!/usr/bin/perl -w

#$Header: /mnt/u1/cvs/logtrend/logtrend-doc/doc/LogTrend-SimpleAgent-0.82.2/lib/LogTrend/Agent/TcpDataSender.pm,v 1.1 2002/04/10 01:18:46 jdive Exp $
##******************************************************************************
## Class TcpDataSender  isa  DataSender
##  Description  : class for sending data to the server via TCP
##  Project      : LogTrend 1.0.0.0 - Atrid Systemes
##  Author       : Sylvain Lhullier s.lhullier@atrid.fr
##******************************************************************************
#$Log: TcpDataSender.pm,v $
#Revision 1.1  2002/04/10 01:18:46  jdive
#fixed description, uncompressed simpleagent
#
#Revision 1.16  2001/11/16 10:32:28  lsimonneau
#Major feature enhancement : Implementation of authentification with RSA signatu
#re.
#
#IMPORTANT : Agents are incompatible with older version.
#
#Revision 1.15  2001/10/12 16:30:30  lsimonneau
#Major feature improvement in MailBridge.
#Now, queued message when execution fail, automaticaly reexecute these mail
#And send alarm mail to Agent or Server admin.
#
#Revision 1.14  2001/10/05 11:55:08  slhullier
#in the other case -> otherwise
#
#Revision 1.13  2001/07/10 12:55:16  slhullier
#*** empty log message ***
#

use IO::Socket;

package LogTrend::Agent::TcpDataSender;

use strict;
use LogTrend::Agent::DataSender;
use LogTrend::Common::LogDie;

use vars qw( @ISA );
@ISA = ("LogTrend::Agent::DataSender");

##******************************************************************************
## Constructor  public  (>DataSender)
##  Parameters   : the host and port for connection, login and password for
##                 identification
##******************************************************************************
sub new
{
   my ($classname, $host, $port) = @_;
   my $self = $classname->SUPER::new( $host, $port );
   bless($self, $classname);
   return $self;
}

##******************************************************************************
## Method SetData  public  (>DataSender)
##  Description  : sends the agent's data and alarms to a storage server
##  Parameters   : the data to send (string)
##  Return value : 0 if successfull, 1 if problem with storage server,  
##                 2 if problem with storage server login, 3 if XML data problem
##******************************************************************************
sub SendData
{
   my ($self, $xmldataandalarms, $signature) = @_;
   my $response;

   my $sock = new IO::Socket::INET( PeerAddr => $self->{HOST},
                                    PeerPort => $self->{PORT},
                                    Proto    => 'tcp' );
   $self->{SOCKET} = $sock;
   if( !defined $sock )
   {
       return "ERROR CONNECT Unable to establish a connection with the StorageServer";
   }

   print $sock "DATA ".$xmldataandalarms."\n.\n"
       or return "ERROR CONNECT The StorageServer has break the connection";

   $response = $self->ReadResponse;
   if($response !~ /^OK/) {
       return $response;
   }

   print $sock "SIGNATURE $signature\n.\n"
       or return "ERROR CONNECT The StorageServer has break the connection";

   $response = $self->ReadResponse;

   if($response !~ /^OK/) {
       return $response;
   }

   print $sock "QUIT\n.\n"
       or return "ERROR CONNECT The StorageServer has break the connection";

   $response = $self->ReadResponse;

   close $sock;

   return $response;
}

##******************************************************************************
## Method ReadResponse  private
##  Description  : Read a response from the serveur
##  Parameters   : none
##
##  Return value : the response of the server
##******************************************************************************
sub ReadResponse
{
   my $self = shift;
   my $sock = $self->{SOCKET};
   my $message = "";
   my $communicationterminated = 0;
   my $buf = undef;
   my $result;

   while( (!$communicationterminated) &&
	  ($buf = <$sock>)) {
       ## Convert cr/lf to \n
       $buf =~ s/\r\n/\n/gsm;
       my $chompedbuf = $buf;
       chomp($chompedbuf);

       if ($chompedbuf eq ".") # the message is complete
       {
	   $communicationterminated = 1;
       }
       else
       {
	   # constitution of the message
	   # we add the buffer at the end of the message
	   # while it's not the message delimiter ie the '.'
	   $message = $message.$buf;
       }
   }

   if(!$communicationterminated) {
       $message = "ERROR CONNECT The StorageServer has break the connection";
   }

   chomp($message);
   return $message;
}

##******************************************************************************
1;
