#!/usr/bin/perl -w

#$Header: /mnt/u1/cvs/logtrend/logtrend-doc/doc/LogTrend-SimpleAgent-0.82.2/lib/LogTrend/Agent/Data.pm,v 1.1 2002/04/10 01:18:46 jdive Exp $
##******************************************************************************
## Class Data
##  Description  : class to stock a data
##  Project      : LogTrend 1.0.0.0 - Atrid Systemes
##  Author       : Sylvain Lhullier s.lhullier@atrid.fr
##  Author       : David Mascle d.mascle@atrid.fr
##******************************************************************************
#$Log: Data.pm,v $
#Revision 1.1  2002/04/10 01:18:46  jdive
#fixed description, uncompressed simpleagent
#
#Revision 1.5  2001/06/07 14:08:54  slhullier
#
#Passage de  unshift @INC,'..';  aux packages Logtrend::....
#
#Revision 1.4  2001/02/22 17:02:23  slhullier
#
#Gestion des systemes de fichiers par LinuxAgent.
#Premiers tests concluants, reste a ajouter des alarmes et a faire
#des tests en situation reelle.
#
#Revision 1.3  2001/02/20 17:01:27  slhullier
#
#Mise en commentaire (+tab etc)
#
#Revision 1.2  2001/02/06 14:59:34  slhullier
#
#
#Essai pour voir
#
#Revision 1.1.1.1  2001/02/06 09:48:27  fdubuy
#
#First CVS version : all work done by D.Mascle
#
#

package LogTrend::Agent::Data;

##******************************************************************************
## Constructor  public
##  Parameters   : the data number, the data value
##******************************************************************************
sub new
{
   my ($classname, $number, $value) = @_;
   my $self = {};
   bless($self, $classname);
   $self->{NUMBER} = $number;
   $self->{VALUE} = $value;
   return $self;
}

##******************************************************************************
## Method GetType  public
##  Description  : returns the current data number
##******************************************************************************
sub GetNumber
{
   my $self = shift;
   return $self->{NUMBER};
}

##******************************************************************************
## Method ConvertToXml  public
##  Description  : formats the data in xml
##  Parameters   : none
##  Return value : an xml string representation of the data
##******************************************************************************
sub ConvertToXml
{
   my $self = shift;
   my $result = "<D N=\"".$self->{NUMBER}."\" V=\"".$self->{VALUE}."\"/>";
   return $result;
}

##******************************************************************************
1;
