#!/usr/bin/perl -w

#$Header: /mnt/u1/cvs/logtrend/logtrend-doc/doc/LogTrend-SimpleAgent-0.82.2/lib/LogTrend/Agent/AlarmDescription.pm,v 1.1 2002/04/10 01:18:46 jdive Exp $
##******************************************************************************
## Class AlarmDescription
##  Description  : class for a alarm description
##  Project      : LogTrend 1.0.0.0 - Atrid Systemes
##  Author       : Sylvain Lhullier s.lhullier@atrid.fr
##  Author       : David Mascle d.mascle@atrid.fr
##******************************************************************************
#$Log: AlarmDescription.pm,v $
#Revision 1.1  2002/04/10 01:18:46  jdive
#fixed description, uncompressed simpleagent
#
#Revision 1.7  2001/06/07 14:08:54  slhullier
#
#Passage de  unshift @INC,'..';  aux packages Logtrend::....
#
#Revision 1.6  2001/03/09 16:16:23  slhullier
#
#Les seuils ne sont plus dans linuxagentdescription.xml
#mais relus dans Configuration.xml
#Gestion de la non reponse du serveur
#
#Revision 1.5  2001/02/27 17:10:03  slhullier
#
#Ajout des quotas : nombre d'users/groups qui depassent.
#Semble fonctionner, a tester en grandeur reelle.
#
#Revision 1.4  2001/02/22 17:02:23  slhullier
#
#Gestion des systemes de fichiers par LinuxAgent.
#Premiers tests concluants, reste a ajouter des alarmes et a faire
#des tests en situation reelle.
#
#Revision 1.3  2001/02/20 17:01:27  slhullier
#
#Mise en commentaire (+tab etc)
#
#Revision 1.2  2001/02/20 10:21:55  slhullier
#
#Passage de la fonction de parsage de config XML dans Agent.pm
#Creation des tags Generic et Specific
#Fichiers agentdescription.xml plus lisibles (avec \n)
#Supression de methodes pas appellee du fichier Agent.pm
#
#Revision 1.1.1.1  2001/02/06 09:48:27  fdubuy
#
#First CVS version : all work done by D.Mascle
#
#
package LogTrend::Agent::AlarmDescription;

##******************************************************************************
## Constructor  public
##  Description  : creat a new AlarmDescription
##  Parameters   : the alarm description number, the alarm description level,
##                 an information message about the alarm, an internal-info
##******************************************************************************
sub new
{
   my ($classname, $number, $level, $message, $internal) = @_;
   my $self = {};
   bless($self, $classname);
   $self->{NUMBER} = $number;
   $self->{LEVEL} = $level;
   $self->{MESSAGE} = $message;
   if( !defined($internal) || $internal eq "" )
   { $self->{INTERNAL} = "$level"."_"."$message"; }
   else
   { $self->{INTERNAL} = $internal; }
   return $self;
}

##******************************************************************************
## Method GetNumber  public
##  Description  : returns the current alarm description number
##******************************************************************************
sub GetNumber
{
   my $self = shift;
   return $self->{NUMBER};
}

##******************************************************************************
## Method GetInternal  public
##  Description  : returns the current alarm description internal-info
##******************************************************************************
sub GetInternal
{
   my $self = shift;
   return $self->{INTERNAL};
}

##******************************************************************************
## Method GetLevel  public
##  Description  : returns the current alarm level
##******************************************************************************
sub GetLevel
{
   my $self = shift;
   return $self->{LEVEL};
}

##******************************************************************************
## Method ConvertToXml  public
##  Description  : formats the alarm description in xml
##  Parameters   : none
##  Return value : an xml string representation of the alarm description
##******************************************************************************
sub ConvertToXml
{
   my $self = shift;
   my $result;

   $result = "<Alarm><Number>".$self->{NUMBER}."</Number><Level><".$self->{LEVEL}.
             "/></Level><Message>".$self->{MESSAGE}."</Message>\n".
             "   <Internal>".$self->{INTERNAL}."</Internal></Alarm>\n";

   return $result;
}

##******************************************************************************
1;
