#!/usr/bin/perl -w

#$Header: /mnt/u1/cvs/logtrend/logtrend-doc/doc/LogTrend-SimpleAgent-0.82.2/lib/LogTrend/Agent/AgentDescriptionToDB/UpdatePostgreSQLDBLayer.pm,v 1.1 2002/04/10 01:18:46 jdive Exp $
#
#******************************************
#                                         *
# LogTrend 1.0.0.0 - Atrid Systemes       *
#                                         *
# Author : David Mascle d.mascle@atrid.fr *
#          Laurent Simonneau l.simonneau@atrid.fr
#******************************************
#
#$Log: UpdatePostgreSQLDBLayer.pm,v $
#Revision 1.1  2002/04/10 01:18:46  jdive
#fixed description, uncompressed simpleagent
#
#Revision 1.3.2.1  2002/02/12 18:28:10  lsimonneau
#Critical bug fixed with ancestor
#
#Revision 1.3  2001/11/16 10:32:28  lsimonneau
#Major feature enhancement : Implementation of authentification with RSA signatu
#re.
#
#IMPORTANT : Agents are incompatible with older version.
#
#Revision 1.2  2001/10/05 11:55:08  slhullier
#in the other case -> otherwise
#
#Revision 1.1  2001/07/27 14:46:51  lsimonneau
#Include UpdateAgentDescription in AgentDescriptionToDB.
#
#Revision 1.1  2001/07/27 11:59:37  lsimonneau
#Modification pour assurer la continuit des donnes entre deux versions d' un agent.
#
#Revision 1.7  2001/06/11 10:03:04  slhullier
#
#(Source,Number) uniq
#
#Revision 1.6  2001/06/07 14:08:54  slhullier
#
#Passage de  unshift @INC,'..';  aux packages Logtrend::....
#
#Revision 1.5  2001/03/09 16:16:23  slhullier
#
#Les seuils ne sont plus dans linuxagentdescription.xml
#mais relus dans Configuration.xml
#Gestion de la non reponse du serveur
#
#Revision 1.4  2001/03/02 09:30:50  slhullier
#
#Suppression de la table SOURCES_AGENTS
#
#Revision 1.3  2001/03/01 16:29:49  slhullier
#
#Premieres modifs sur le serveur
#
#Revision 1.2  2001/02/20 17:01:27  slhullier
#
#Mise en commentaire (+tab etc)
#
#Revision 1.1.1.1  2001/02/06 09:48:28  fdubuy
#
#First CVS version : all work done by D.Mascle
#
#

use DBI;
use strict;

package LogTrend::Agent::AgentDescriptionToDB::UpdatePostgreSQLDBLayer;

use LogTrend::Agent::AgentDescriptionToDB::PostgreSQLDBLayer;

use vars qw( @ISA );
@ISA = ("LogTrend::Agent::AgentDescriptionToDB::PostgreSQLDBLayer");

#**********************************************************************************
#                                                                                 *
# PostgreSQLDBLayer is a class inherited from DBAbstractionLayer                  *
#                                                                                 *
# it implements its superclass methods and adds several private utilities methods *
#                                                                                 *
#**********************************************************************************

#**************************************************************************
#
# status : public
#
# function : constructor
#
# parameters :
#
# databasename : the name of the database
# host : the name or the IP of the host of the database server
# port : the port on which the database server is listening for connections
# username : the name of a database user
# password : the password of a database user
#
# returns : a reference to an instance of the class
#
#**************************************************************************

sub new
  {
    my ($classname, $databasename, $host, $port, $username, $password, $ancestor_source, $ancestor_agent_number) = @_;
    my $self = $classname->SUPER::new($databasename, $host, $port, $username, $password);
    bless($self, $classname);

    $self->{ANCESTOR_SOURCE} = $ancestor_source;
    $self->{ANCESTOR_AGENT_NUMBER} = $ancestor_agent_number;

    return $self;
  }

#************************************************************
#
# status : public
#
# function : adds a description associated to an agent's data
#
# parameters :
#
# agentsource : the agent's source
# agentnumber : the agent's number
# agentversion : the agent's version
# activationdate : the agent's activation date
# number : a data's number
# type : a data's type
# unit : a data's unit
# description : a data's description
#
# returns : 1 if succesfull and 0 otherwise
#
#************************************************************

sub AddDataDescription
  {
    my ($self, $agentsource, $agentnumber, $agentversion, $activationdate, $number, $type, $unit, $description) = @_;
    my $result = 0;
    my $st_handle;
    my @row;

    my $agent_ancestor_id = $self->GetAgentAncestorID();
    my $ancestor = "NULL";

    my $agentid = $self->GetAgentID($agentsource, $agentnumber, $agentversion, $activationdate);
    
    $self->CheckDataDescriptionExistence($agentid, $number);

    $st_handle = $self->{DBHANDLE}->prepare("

SELECT id_data_description 

FROM agents_data_descriptions 

WHERE id_agent=? AND description=?

") or throw Error::DB_Request($self->{DBHANDLE}->errstr);

    $st_handle->execute($agent_ancestor_id, $description)
        or throw Error::DB_Request($st_handle->errstr);

    @row = $st_handle->fetchrow_array();

    if(defined $st_handle->err) {
        throw Error::DB_Request($st_handle->errstr);
    }
    
    $ancestor = $row[0] 
        unless $#row == -1;
	      
    $st_handle = $self->{DBHANDLE}->prepare("

INSERT INTO agents_data_descriptions(id_agent, number, type, unit, description, ancestor) 

VALUES(?, ?, ?, ?, ?, $ancestor)

") or throw Error::DB_Request($self->{DBHANDLE}->errstr);


    my $typeid = $self->GetTypeID($type);
    my $unitid = $self->GetUnitID($unit);
    
    $st_handle->execute($agentid, $number, $typeid, $unitid, $description)
        or throw Error::DB_Request($st_handle->errstr);
}


#********************************************************************
#
# status : private
#
# function : returns the id of an agent
#
# parameters :
#
# agentsource : the agent's source
# agentnumber : the agent's number
# agentversion : the agent's version
# activationdate : the agent's activation date
#
# returns : the id of an agent if successfull and 0 otherwise
#
#********************************************************************

sub GetAgentAncestorID {
    my ($self) = @_;
    my $st_handle;
    my @row;

    $st_handle = $self->{DBHANDLE}->prepare("

SELECT id_agent 

FROM agents 

WHERE (id_source = ?) AND (number = ?)

") or throw Error::DB_Request($self->{DBHANDLE}->errstr);

    $st_handle->execute($self->{ANCESTOR_SOURCE}, $self->{ANCESTOR_AGENT_NUMBER})
        or throw Error::DB_Request($st_handle->errstr);

    @row = $st_handle->fetchrow_array();
        
    if(defined $st_handle->err) {
        throw Error::DB_Request($st_handle->errstr);
    }
    
    if(! @row) {
        throw Error::DB_AgentDescription("Can' find agent id for agent number $self->{ANCESTOR_AGENT_NUMBER} on source $self->{ANCESTOR_SOURCE}" );
    }

    return $row[0];
}



1;
