#!/usr/bin/perl -w

#$Header: /mnt/u1/cvs/logtrend/logtrend-doc/doc/LogTrend-SimpleAgent-0.82.2/lib/LogTrend/Agent/AgentDescriptionToDB/DirectDescriptionSender.pm,v 1.1 2002/04/10 01:18:46 jdive Exp $
##******************************************************************************
## Class DirectDescriptionSender  isa  DescriptionSender
##  Description  : class for sending description to the server directly
##  Project      : LogTrend 1.0.0.0 - Atrid Systemes
##  Author       : Sylvain Lhullier s.lhullier@atrid.fr
##******************************************************************************
#$Log: DirectDescriptionSender.pm,v $
#Revision 1.1  2002/04/10 01:18:46  jdive
#fixed description, uncompressed simpleagent
#
#Revision 1.8  2001/11/16 10:32:28  lsimonneau
#Major feature enhancement : Implementation of authentification with RSA signatu
#re.
#
#IMPORTANT : Agents are incompatible with older version.
#
#Revision 1.7  2001/10/12 16:30:30  lsimonneau
#Major feature improvement in MailBridge.
#Now, queued message when execution fail, automaticaly reexecute these mail
#And send alarm mail to Agent or Server admin.
#
#Revision 1.6  2001/10/05 11:55:08  slhullier
#in the other case -> otherwise
#
#Revision 1.5  2001/07/27 14:41:23  lsimonneau
#Include UpdateAgentDescription in AgentDescriptionToDB.
#
#Revision 1.4  2001/06/07 14:08:54  slhullier
#
#Passage de  unshift @INC,'..';  aux packages Logtrend::....
#
#Revision 1.3  2001/02/20 17:01:27  slhullier
#
#Mise en commentaire (+tab etc)
#
#Revision 1.2  2001/02/09 13:58:45  slhullier
#
#
#MailBridge Description Ok.
#Tests en situation reelle.
#
#Revision 1.1  2001/02/09 13:25:30  slhullier
#
#
#MailBridge pour AgentDescriptionToDB
#Ok pour la connection directe.
#Ok pour le mail cote emission.
#

package LogTrend::Agent::AgentDescriptionToDB::DirectDescriptionSender;

use strict;
use Error qw(:try);
use LogTrend::Agent::AgentDescriptionToDB::ErrorDeclaration;
use LogTrend::Crypto::KeyManager;
use LogTrend::Agent::AgentDescriptionToDB::DescriptionSender;
use LogTrend::Agent::AgentDescriptionToDB::PostgreSQLDBLayer;
use LogTrend::Agent::AgentDescriptionToDB::XMLToDB;
use LogTrend::Agent::AgentDescriptionToDB::UpdatePostgreSQLDBLayer;

use vars qw( @ISA );
@ISA = ("LogTrend::Agent::AgentDescriptionToDB::DescriptionSender");

##******************************************************************************
## Constructor  public  (>DescriptionSender)
##  Parameters   : informations for identicification
##******************************************************************************
sub new
{
   my ( $classname, $databasename, $host, $port, $username,
        $password, $ancestor_source, $ancestor_number ) = @_;
   my $self = $classname->SUPER::new( $databasename, $host, $port,
                                      $username, $password,
                                      $ancestor_source, $ancestor_number );

   bless($self, $classname);

   return $self;
}


##******************************************************************************
## Function SetData  public virtual
##  Description  : sends the agent's description to a storage server
##  Parameters   : the agent description data and the signature
##  Return value : An status report string (OK or ERROR <class> <description>)
##******************************************************************************
sub SendDescription
{
   my ($self, $xmldata, $signature) = @_;
   my $pglayer;
   my $result;

   ## Try to authenticate the source 
   try {
       my $keymanager = new LogTrend::Crypto::KeyManager($self->{DATABASENAME}, $self->{HOST},
                                                         $self->{PORT}, $self->{USERNAME}, $self->{PASSWORD});


       my $verify = $keymanager->verify_signature($xmldata, $signature);
   

       if(defined $self->{ANCESTOR_SOURCE}) {
           $pglayer = 
             LogTrend::Agent::AgentDescriptionToDB::UpdatePostgreSQLDBLayer->new( $self->{DATABASENAME}, 
                                                                                  $self->{HOST},
                                                                                  $self->{PORT}, 
                                                                                  $self->{USERNAME},
                                                                                  $self->{PASSWORD}, 
                                                                                  $self->{ANCESTOR_SOURCE}, 
                                                                                  $self->{ANCESTOR_NUMBER});
       }
       else {
           $pglayer = LogTrend::Agent::AgentDescriptionToDB::PostgreSQLDBLayer->new( $self->{DATABASENAME}, $self->{HOST},
                                                                                     $self->{PORT}, $self->{USERNAME},
                                                                                     $self->{PASSWORD} );
       }
       
       my $xmltodb = LogTrend::Agent::AgentDescriptionToDB::XMLToDB->new( $pglayer );

       $xmltodb->ConvertXMLToDB($verify->{source_id}, $xmldata);

       $pglayer->commit;
       $result = "OK";
   }
   catch Error::DB_Request with {
       my $error = shift;
       $result = "ERROR DB_REQUEST ".$error->{-text}." in file $error->{-file} at line $error->{-line}";
   }
   catch Error::DB_Connection with {
       my $error = shift;
       $result = "ERROR DB_CONNECT ".$error->{-text}." in file $error->{-file} at line $error->{-line}";
   }
   catch Error::DB_AgentDescription with {
       my $error = shift;
       $result = "ERROR DB_AGENTDESCRIPTION ".$error->{-text}." in file $error->{-file} at line $error->{-line}";
   }
   catch Error::IO with {
       my $error = shift;
       $result = "ERROR IO ".$error->{-text}." in file $error->{-file} at line $error->{-line}";
   }
   catch Error::Authentication with {
       my $error = shift;
       $result = "ERROR AUTHENTICATION ".$error->{-text}." in file $error->{-file} at line $error->{-line}";
   }
   catch Error::Not_A_Signature with {
       my $error = shift;
       $result = "ERROR NOT_A_SIGNATURE ".$error->{-text}." in file $error->{-file} at line $error->{-line}";
   }
   catch Error::XML with {
       my $error = shift;
       $result = "ERROR XML ".$error->{-text}." in file $error->{-file} at line $error->{-line}";
   }
   catch Error::Permission with {
       my $error = shift;
       $result = "ERROR PERMISSION ".$error->{-text}." in file $error->{-file} at line $error->{-line}";
   };
   
   return $result;
}

##******************************************************************************
1;
