#!/usr/bin/perl -w

#$Header: /mnt/u1/cvs/logtrend/logtrend-doc/doc/LogTrend-SimpleAgent-0.82.2/lib/LogTrend/Agent/AgentDescriptionToDB/DescriptionSender.pm,v 1.1 2002/04/10 01:18:46 jdive Exp $
##******************************************************************************
## Class DescriptionSender  virtual
##  Description  : generic class for sending Description to the server
##  Project      : LogTrend 1.0.0.0 - Atrid Systemes
##  Author       : Laurent Simonneau l.simonneau@atrid.fr
##  Author       : Sylvain Lhullier s.lhullier@atrid.fr
##******************************************************************************
#$Log: DescriptionSender.pm,v $
#Revision 1.1  2002/04/10 01:18:46  jdive
#fixed description, uncompressed simpleagent
#
#Revision 1.7  2001/11/16 10:32:28  lsimonneau
#Major feature enhancement : Implementation of authentification with RSA signatu
#re.
#
#IMPORTANT : Agents are incompatible with older version.
#
#Revision 1.6  2001/10/05 11:55:08  slhullier
#in the other case -> otherwise
#
#Revision 1.5  2001/08/06 13:57:22  slhullier
#
#needed port
#
#Revision 1.4  2001/07/27 14:41:23  lsimonneau
#Include UpdateAgentDescription in AgentDescriptionToDB.
#
#Revision 1.3  2001/06/07 14:08:54  slhullier
#
#Passage de  unshift @INC,'..';  aux packages Logtrend::....
#
#Revision 1.2  2001/02/20 17:01:27  slhullier
#
#Mise en commentaire (+tab etc)
#
#Revision 1.1  2001/02/09 13:25:30  slhullier
#
#
#MailBridge pour AgentDescriptionToDB
#Ok pour la connection directe.
#Ok pour le mail cote emission.
#

package LogTrend::Agent::AgentDescriptionToDB::DescriptionSender;

use strict;

##******************************************************************************
## Constructor  public
##  Parameters   : informations for identicification
##******************************************************************************
sub new
{
   my ( $classname, $databasename, $host, $port, $username,
        $password,  $ancestor_source, $ancestor_number ) = @_;
   my $self = {};
   bless($self, $classname);
   $self->{DATABASENAME}  = $databasename;
   $self->{HOST}          = $host || "localhost";
   $self->{PORT}          = $port || 5432;
   $self->{USERNAME}      = $username;
   $self->{PASSWORD}      = $password;
   $self->{ANCESTOR_SOURCE}=$ancestor_source if defined $ancestor_source;
   $self->{ANCESTOR_NUMBER}=$ancestor_number if defined $ancestor_number;
   return $self;
}

##******************************************************************************
## Function SetData  public virtual
##  Description  : sends the agent's description to a storage server
##  Parameters   : the agent description data and the signature
##  Return value : An status report string (OK or ERROR <class> <description>)
##******************************************************************************
sub SendDescription
{
}

##******************************************************************************
1;
