#!/usr/bin/perl -w

#$Header: /mnt/u1/cvs/logtrend/logtrend-doc/doc/LogTrend-SimpleAgent-0.82.2/lib/LogTrend/Action/ActionSet.pm,v 1.1 2002/04/10 01:18:46 jdive Exp $
##*****************************************************************************
##  Class ActionSet  virtual
##  Description  : A list of Action
##
##  Project      : LogTrend 1.0.0.0 - Atrid Systemes
##  Author       : Laurent Simonneau l.simonneau@atrid.fr
##*****************************************************************************
#$Log: ActionSet.pm,v $
#Revision 1.1  2002/04/10 01:18:46  jdive
#fixed description, uncompressed simpleagent
#
#Revision 1.1  2001/11/06 09:14:37  lsimonneau
#First release of this file.
#

package LogTrend::Action::ActionSet;

use strict;
use XML::DOM;
use LogTrend::Action;

##*****************************************************************************
## Constructor  public
##  Description  : creat new Actions 
##  Parameters   : the XML::DOM node.
##*****************************************************************************
sub new 
{
    my ($classname, $rootnode) = @_;
    my $self = {};
    
    bless($self, $classname);

    $self->{ACTION_LIST} = [];

    my $action_name;
    my ($list,$node,$valueref,$attributes,$attrnode);

    $list = $rootnode->getElementsByTagName("Action") || return $self;
    
    return $self if @$list == 0;
    
    $node = $list->[0]->getFirstChild;

    my $actionset = new LogTrend::Action::ActionSet($node);

    while($node = $node->getNextSibling()) {
	if($node->getNodeType() != ELEMENT_NODE) {
	    next;
	}
	
	$action_name = $node->getNodeName();
	
	$self->LoadActionPackage($action_name);
	
	my $action =  eval "LogTrend::Action::${action_name}->new(\$node)";	

	if ($@) {
	    warn $@ ;
	}
	else {
	    push @{$self->{ACTION_LIST}}, $action;
	}	
    }
	
    return $self;
}

##*****************************************************************************
## Method LoadActionPackage private
##  Description  : Try to load an Action package
## 
##  Parameters   : A package name
##
##*****************************************************************************
sub LoadActionPackage
{
    my ($self, $pkgname) = @_;
    my $nb_func;    
    my $filename;
    
    # check if the package is allready loaded.
    return if (defined &{"LogTrend::Action::${pkgname}::Run"} && defined &{"LogTrend::Action::${pkgname}::new"});    

    my $default_path = __FILE__;
    $default_path =~ s/\/ActionSet.pm$//;

    # check if the file $pkgname.pm exist
    if(-f "$default_path/${pkgname}.pm") {
	$filename = "$default_path/${pkgname}.pm";
    }
    # check if the environment variable ACTION_PATH is set
    elsif(defined $ENV{ACTION_PATH}){
	foreach my $path (split /:/, $ENV{ACTION_PATH}) {
	    if(-f "$path/${pkgname}.pm") {
		$filename = "$path/${pkgname}.pm";
		last;
	    }
	}
    }

    if(! defined $filename) {
	die "$self->{FILENAME} : can't find package $pkgname\n";
    }
    
    # check if this package contains required functions
    open(PACKAGE_FILE, $filename);
    
    $nb_func=0;
    while(<PACKAGE_FILE>) {
      # look for '#!/usr/bin/perl'
      $_ =~ /^\s*\#!\/usr\/(local\/)?bin\/perl/ and $nb_func++;
	
      # look for 'sub Run'
      $_ =~ /^\s*sub\s+Run\s*\{?\s*$/ and $nb_func++;
	
      # look for 'sub new'
      $_ =~ /^\s*sub\s+new\s*\{?\s*$/ and $nb_func++;
    }
    
    close(PACKAGE_FILE);
    
    if($nb_func!=3){
	die "$self->{FILENAME} : $pkgname is not a valid action package\n";
    }
    
    # load this file
    require($filename);
        
    # check if the required func are loaded
    if(! defined &{"LogTrend::Action::${pkgname}::new"} && defined &{"LogTrend::Action::${pkgname}::Run"}){
	die "$self->{FILENAME} : $pkgname is not a valid action package\n";
    }        
}

##*****************************************************************************
## Method Run public
##  Description  : Run the action
##  Parameters   : the alarm level (Info, Warning or Error)
##*****************************************************************************
sub Run 
{
    my ($self, $alarm_level) = @_;

    foreach my $action (@{$self->{ACTION_LIST}}) {
	$action->Run($alarm_level);
    }
    
}

1;
