#!/usr/bin/perl -w

use LogTrend::Consolidation::ConsolidationPostgreSQLDataBase;
use LogTrend::Consolidation::DataBaseAnalyzer;
use strict;
use Getopt::Long;

sub display_help {

    print "Usage : GetListOfVariables --source source_number --agent agent_number --data data_name\n";
    print "                           [--database database_name]\n";
    print "                           [--host host_name]\n";
    print "                           [--port server_port]\n";
    print "                           [--help][-h]\n\n";
}

sub main {
    my $user = "";
    my $password = "";

    my $database;
    my $var;
    
    my %opt;

    GetOptions(\%opt, "source|s=i", "agent|a=i", "data|d=s", "database=s",
	       "host=s","port=i","help|h");
    

    if(!(defined $opt{source}) or !(defined $opt{agent}) or
       !(defined $opt{data}) or defined $opt{help}) {
	display_help();
	exit 0;
    }
    
    $opt{database} = "logtrend" unless defined $opt{database};
    $opt{host} = "localhost" unless defined $opt{host};
    $opt{port} = "5432" unless defined $opt{port};

    
    print "Login : ";
    $user = <STDIN>;
    system "stty -echo";
    print "Password : ";
    $password = <STDIN>;
    system "stty echo";
    print "\n";

    $database = LogTrend::Consolidation::ConsolidationPostgreSQLDataBase->new($opt{database}, 
									      $opt{host},
									      $opt{port},
									      $user,
									      $password);

    my $db_analyzer = new LogTrend::Consolidation::DataBaseAnalyzer($database);


    my $zone_list = $db_analyzer->GetZoneList($opt{source}, $opt{agent}, $opt{data});

    die "No Data" if $#$zone_list == -1;


    my $origin = time;
    my $max_y=0;
    open (F_PLOT1, "> /tmp/plot1");
    foreach my $zone (@$zone_list) {
	$zone->[1] = ($zone->[1] - $origin)/86400;
	$zone->[2] = ($zone->[2] - $origin)/86400;
	
  	print F_PLOT1
  	    "$zone->[2] 0\n".
  	    "$zone->[2] $zone->[0]\n".
  	    "$zone->[1] $zone->[0]\n".
  	    "$zone->[1] 0\n";
	
	$max_y = $zone->[0] if $zone->[0] > $max_y;
    }

    close F_PLOT1;

    $max_y*=1.1;

    open (F_PLOT2, "> /tmp/plot2");

    my $list = $database->GetCollectionDateInTimeInterval($opt{source}, $opt{agent}, $opt{data}, 0);

    for (my $i=1; defined $list->[$i]; $i++) {
	print F_PLOT2 (($list->[$i] - $origin)/86400)." ".($list->[$i] - $list->[$i-1])."\n";
    }

    close F_PLOT2;

    open(F_GPLOT, "| gnuplot -persist");
    
    print F_GPLOT "set yrange [0:$max_y]\n";
    print F_GPLOT "plot '/tmp/plot2' with impulses, '/tmp/plot1' with lines\n";
    
    close F_GPLOT
}

main();
