/*
 * Copyright 2003,2004 The Apache Software Foundation.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 *      http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
 
#ifndef _LOG4CXX_PROVISION_NODE_H
#define _LOG4CXX_PROVISION_NODE_H

#include <vector>
#include <log4cxx/helpers/objectptr.h>
#include <log4cxx/logger.h>

namespace log4cxx
{
    class Logger;
    typedef helpers::ObjectPtrT<Logger> LoggerPtr;

    class ProvisionNode : public std::vector<LoggerPtr>
    {
    public:
		ProvisionNode(const LoggerPtr& logger)
		{
			push_back(logger);
		}
    }; // class LogManager
}  // namespace log4cxx

#endif //_LOG4CXX_PROVISION_NODE_H
