/*
 * midi_device.h - base-class for midi-device-drivers like ALSA-driver for
 *                 midi-port, pc-keyboard-wrapper etc.
 *
 * Linux MultiMedia Studio
 * Copyright (c) 2004-2005 Tobias Doerffel <tobydox@users.sourceforge.net>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public
 * License along with this program (see COPYING); if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 *
 */


#ifndef _MIDI_DEVICE_H
#define _MIDI_DEVICE_H


#include "midi.h"
#include "note.h"
#include "tab_widget.h"


class channelTrack;
class notePlayHandle;
class knob;



const Uint8 MIDI_PARSE_BUF_SIZE = 16;



class midiDevice
{
public:
	midiDevice( channelTrack * _ct = NULL );
	virtual ~midiDevice();
	inline void setChannelTrack( channelTrack * _ct )
	{
		m_channelTrack = _ct;
	}
	inline const channelTrack * getChannelTrack( void ) const
	{
		return( m_channelTrack );
	}
	inline const knob * pitchBendKnob( void )
	{
		return( m_pitchBendKnob );
	}
	inline void setPitchBendKnob( knob * _knob )
	{
		m_pitchBendKnob = _knob;
	}

	void FASTCALL processInEvent( const midiEvent & _me );
	void FASTCALL processOutEvent( const midiEvent & _me );

	inline bool keyPressed( int _key ) const
	{
		return( m_keys[_key].m_noteForKey != NULL );
	}
	inline notePlayHandle * noteForKey( int _key )
	{
		return( m_keys[_key].m_noteForKey );
	}
	void noteOffAll( void );


	static midiDevice * openMidiDevice( void );


	class setupWidget : public tabWidget
	{
	public:
		setupWidget( const QString & _caption, QWidget * _parent ) :
			tabWidget( tabWidget::tr( "Settings for %1" ).arg(
							_caption ), _parent )
		{
		}

		virtual ~setupWidget()
		{
		}

		virtual void saveSettings( void ) = 0;

	} ;


protected:
	const midiEvent * FASTCALL parseData( Uint8 _c );

	virtual void FASTCALL sendByte( Uint8 _c );


private:
	void FASTCALL noteOn( int _key, volume _vol = DEFAULT_VOLUME );
	void FASTCALL noteOff( int _key );

	static Uint16 FASTCALL eventLength( Uint8 _event );


	struct midiParserData
	{
		Uint8 m_status;		// identifies the type of event, that
					// is currently received ('Noteon',
					// 'Pitch Bend' etc).
		Uint8 m_channel;	// The channel of the event that is
					// received (in case of a channel event)
		Uint32 m_bytes;		// How many bytes have been read for
					// the current event?
		Uint32 m_bytesTotal;	// How many bytes does the current
					// event type include?
		Uint32 m_buffer[MIDI_PARSE_BUF_SIZE];	// buffer for incoming
							// data
		midiEvent m_midiEvent;		// midi-event 
	} m_midiParseData;

	struct key
	{
		notePlayHandle * m_noteForKey;
	} m_keys[NOTES_PER_OCTAVE * OCTAVES];

	channelTrack * m_channelTrack;
	knob * m_pitchBendKnob;

} ;


#endif
