/*
 * crystal_button.h - declaration of class crystalButton
 *
 * Linux MultiMedia Studio
 * Copyright (c) 2004-2005 Tobias Doerffel <tobydox@users.sourceforge.net>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public
 * License along with this program (see COPYING); if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 *
 */


#ifndef _CRYSTAL_BUTTON_H
#define _CRYSTAL_BUTTON_H

#include "qt3support.h"

#ifdef QT4

#include <QPushButton>

#else

#include <qpushbutton.h>

#endif


class QPixmap;



class crystalButton : public QPushButton
{
	Q_OBJECT
public:
	crystalButton( const QPixmap & _bg_pm, const QPixmap & _icon_pm,
							QWidget * _parent );
	virtual ~crystalButton();
	void setButtonBg( const QPixmap & _pm );
	void setActiveButtonBg( const QPixmap & _pm );
	void setActiveBg( const QPixmap & _pm );
	void setInactiveBg( const QPixmap & _pm );
	void setHoverBg( const QPixmap & _pm );
	void setGlass( const QPixmap & _pm );
	void setIcon( const QPixmap & _pm );


protected:
	virtual void paintEvent( QPaintEvent * _pe );
	virtual void mouseMoveEvent( QMouseEvent * _me );


private:
	QPixmap * m_buttonBg;
	QPixmap * m_activeButtonBg;
	QPixmap * m_activeBg;
	QPixmap * m_inactiveBg;
	QPixmap * m_hoverBg;
	QPixmap * m_glass;
	QPixmap * m_icon;
	volatile bool m_mouseOver;

} ;

#endif
