/*
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 */

 /* (C) Marcin Kwadrans <quarter@users.sourceforge.net> */

#include "include/support.h"
#include "include/paritycommand.h"
#include "include/message.h"

class LWCommandContinue: public LWCommandSegment {

private:
LWSymbol *matchedSymbol;

public:

LWCommandContinue(): matchedSymbol(NULL) {};

LWValue *execute1 (LWContext *context, guint argc, LWValue *args[])
{
	(void) context;
	(void) argc;
	(void) args;

	enum ContinueMode {
		LW_CONTINUE_REPEAT,
		LW_CONTINUE_LOOP,
	} cm = LW_CONTINUE_LOOP;

	if (!g_ascii_strcasecmp (matchedSymbol->getName(), "repeat"))
		cm = LW_CONTINUE_REPEAT;

	for (GNode *n = context->instrPtr->parent; !G_NODE_IS_ROOT (n); n = n->parent) {
		LWPiece *piece = (LWPiece *) n->data;

		if (n->prev != NULL && !g_ascii_strcasecmp (piece->getSymbol()->getName(), "begin"))
			piece = (LWPiece *) n->prev->data;	
		
		if (matchedSymbol == piece->getSymbol()) 
			
			switch (cm) {

			case LW_CONTINUE_REPEAT:
				context->instrPtr = n->next;
				return NULL;

			case LW_CONTINUE_LOOP:
				context->instrPtr = n;
				context->resume = TRUE;
				return NULL;

			}
	}
	
	g_return_val_if_reached (NULL);
}

const gchar *getName ()
{
	return "continue";
}	

gchar *getHint ()
{
	return _("Continue the loop");
}

void checkArgc (guint n)
{
	if (n != 0) 
		throw new LWMessage (LW_ERROR_WrongNumberOfArguments);
}

gboolean matchPrevCondition (LWCommand *cmd)
{
	return (cmd->isLoop() || !g_ascii_strcasecmp (cmd->getName(), "repeat")) ? TRUE : FALSE;
}

gboolean matchWith (LWCommand *cmd)
{
	if (cmd == NULL && matchedSymbol == NULL)
			throw new LWMessage (LW_ERROR_ContinueNotInALoop);

	if (matchedSymbol == NULL) {
		matchedSymbol = (LWSymbol *) cmd;	
		match();
	}
	
	return FALSE;
}

void reset1 ()
{
	matchedSymbol = NULL;
	LWCommandSegment::reset1();
}

gboolean isSegment ()
{
	return (FALSE == isAlreadyMatched()) ? TRUE : FALSE;
}

};

LWSymbol *new_LWCommandContinue()
{
	return new LWCommandContinue();
}
