/* (C) Marcin Kwadrans <quar@vitea.pl> */

/*! \file row.h
	\brief Zarządzanie wierszem
*/

#ifndef __LW_ROW_H
#define __LW_ROW_H

#include <libxml/tree.h>

class LWBoard;
class LWPiece;

/*! \class LWRow
	\brief Zarządzanie wierszem

	W wierszu znajdują się klocki LWPiece, klasa zawiera metody operujące
	na strukturze wiersza, takie jak: dodawanie, usuwanie, wstawianie
	pobieranie klocków
*/
class LWRow {
private:
GSList *list_piece;
LWPiece *dummy_piece;
LWPiece *remark_piece;
GtkWidget *widget;
LWBoard *board;
void init (LWBoard *a_board);
public:
LWRow (LWBoard *a_board);
LWRow (const LWRow *row, LWBoard *a_board);
~LWRow ();
LWBoard *getBoard();
void restoreFromXML (xmlNode *node);
void storeToXML (xmlNode *parent_node);
void addPiece (LWPiece *piece);
void insertPieceBefore (LWPiece *piece, LWPiece *sibiling);
void removePiece (LWPiece *piece);
void splitBefore (LWPiece *piece);
gint getPieceIndex (LWPiece *piece);
LWPiece *getPieceNth (guint n);
GSList *getPieceList ();
void setWidth (guint length);
guint getWidth ();
void updatePieceSize ();
void updateGrid ();
void clear ();
void setAsRemark(LWPiece *a_piece);
void clearRemark();
GtkWidget *getWidget ();
gboolean isPieceDummy (LWPiece *piece);
};

#include "board.h"
#include "piece.h"

#endif
