#include <stdio.h>
#include <stdlib.h>
#include <memory.h>
#include "ma.h"

struct smaint
{
    int	*samples;
    int	size;
    int	nsamples;
    int	in;
    int	sma;
};

SMAINT
smaint_new(int size, int initval)
{
    SMAINT	sma;

    sma = (SMAINT) malloc(sizeof(*sma));
    if (!sma) return NULL;

    sma->samples = (int *) malloc(sizeof(int) * size);
    if (!sma->samples)
    {
	free(sma);
	return NULL;
    }
    memset(sma->samples, 0, sizeof(int) * size);

    sma->size = size;
    sma->nsamples = 0;
    sma->in = 0;
    sma->sma = initval;
    return sma;
}

int
smaint_add(SMAINT sma, int value)
{
    sma->sma += value;
    sma->sma -= sma->samples[sma->in];
    sma->samples[sma->in++] = value;
    if (++sma->nsamples >= sma->size)
	sma->nsamples = sma->size;
    if (sma->in >= sma->size)
	sma->in = 0;
    return sma->sma / sma->nsamples;
}

int
smaint(SMAINT sma)
{
    return sma->sma / sma->nsamples;
}

void
smaint_free(SMAINT sma)
{
    if (!sma)
	return;
    if (sma->samples)
	free(sma->samples);
    free(sma);
}

#ifdef UNIT_TEST
int
main(int argc, char *argv[])
{
    SMAINT	sma;
    int		i;

    sma = smaint_new(30, 0);
    for (i = 1; i <= 60; ++i)
	printf("%d: %d\n", i, smaint_add(sma, i));
    for (i = 1; i <= 30; ++i)
	printf("%d: %d\n", i+60, smaint_add(sma, 60));
    for (i = 1; i <= 30; ++i)
	printf("%d: %d\n", i+90, smaint_add(sma, 0));
    smaint_free(sma);
}
#endif
