## linum-relative.el
*display relative line number in emacs.*

---
[![License GPLv2](https://img.shields.io/badge/license-GPL_v2-green.svg)](http://www.gnu.org/licenses/gpl-2.0.html)
[![MELPA](http://melpa.org/packages/linum-relative-badge.svg)](http://melpa.org/#/linum-relative)
[![MELPA Stable](http://stable.melpa.org/packages/linum-relative-badge.svg)](http://stable.melpa.org/#/linum-relative)

![Screenshot](https://github.com/coldnew/linum-relative/raw/master/screenshot/screenshot1.jpg)

linum-relative lets you display relative line numbers for current buffer.


### Installation


If you have `melpa` and `emacs24` installed, simply type:

    M-x package-install linum-relative

And add the following to your .emacs

    (require 'linum-relative)

### Setup & Tips


The non-interactive function *linum-on* (which should already be built into recent GNU Emacs distributions), turns on side-bar line numbering:

    (linum-on)

and alternatively, by enabling `linum-mode`:

    M-x linum-mode

Relative line numbering should already be enabled by default (by installing this package), following *linum-on* or enabling *linum-mode*. One can also use the *linum-relative-toggle* interactive function to switch between relative and non-relative line numbering:

    M-x linum-relative-toggle


### Function Documentation


#### `(linum-relative-in-helm-p)`

Return non nil when in an helm session.

#### `(linum-relative-on)`

Turn ON linum-relative.

#### `(linum-relative-off)`

Turn OFF linum-relative.

#### `(linum-relative-toggle)`

Toggle between linum-relative and linum.

-----
<div style="padding-top:15px;color: #d0d0d0;">
Markdown README file generated by
<a href="https://github.com/mgalgs/make-readme-markdown">make-readme-markdown.el</a>
</div>
