/*
 *  chartdef.inc: chart definition table
 *
 *  Copyright (C) 1997-2005 John Coppens (john@jcoppens.com)
 *
 *  This program is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Library General Public License
 *  as published by the Free Software Foundation; either version 2 of
 *  the License, or (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU Library General Public
 *  License along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */


plot_definition pldef[] = {
// type value   min     max   zoom_limits pri wide
  {'R',   0.0, -999.9,  999.9,  0.0, 99.0,  5,  1},	// Outer border

  {'R',  0.02,   -0.5,    0.5,  0.0, 99.0,  5,  0},
  {'R',  0.04,   -0.5,    0.5,  0.0, 99.0,  5,  0},

  {'R',  0.05,   -1.0,   -0.5,  0.0, 99.0,  5,  0},
  {'R',  0.05,    0.5,    1.0,  0.0, 99.0,  5,  0},

  {'R',  0.06,   -0.5,    0.5,  0.0, 99.0,  5,  0},
  {'R',  0.08,   -0.5,    0.5,  0.0, 99.0,  5,  0},

  {'R',   0.1,   -1.0,    1.0,  0.0, 99.0,  5,  1},
  {'R',   0.1,   -2.0,   -1.0,  0.0, 99.0,  5,  0},
  {'R',   0.1,    1.0,    2.0,  0.0, 99.0,  5,  0},

  {'R',  0.12,   -0.5,    0.5,  0.0, 99.0,  5,  0},
  {'R',  0.14,   -0.5,    0.5,  0.0, 99.0,  5,  0},

  {'R',  0.15,   -1.0,   -0.5,  0.0, 99.0,  5,  0},
  {'R',  0.15,    0.5,    1.0,  0.0, 99.0,  5,  0},

  {'R',  0.16,   -0.5,    0.5,  0.0, 99.0,  5,  0},
  {'R',  0.18,   -0.5,    0.5,  0.0, 99.0,  5,  0},

  {'R',   0.2,   -1.0,    1.0,  0.0, 99.0,  5,  1},
  {'R',   0.2,   -5.0,   -1.0,  0.0, 99.0,  5,  0},
  {'R',   0.2,    1.0,    5.0,  0.0, 99.0,  5,  0},

  {'R',  0.22,   -0.5,    0.5,  0.0, 99.0,  5,  0},
  {'R',  0.24,   -0.5,    0.5,  0.0, 99.0,  5,  0},

  {'R',  0.25,   -1.0,   -0.5,  0.0, 99.0,  5,  0},
  {'R',  0.25,    0.5,    1.0,  0.0, 99.0,  5,  0},

  {'R',  0.26,   -0.5,    0.5,  0.0, 99.0,  5,  0},
  {'R',  0.28,   -0.5,    0.5,  0.0, 99.0,  5,  0},

  {'R',   0.3,   -1.0,    1.0,  0.0, 99.0,  5,  1},
  {'R',   0.3,   -2.0,   -1.0,  0.0, 99.0,  5,  0},
  {'R',   0.3,    1.0,    2.0,  0.0, 99.0,  5,  0},

  {'R',  0.32,   -0.5,    0.5,  0.0, 99.0,  5,  0},
  {'R',  0.34,   -0.5,    0.5,  0.0, 99.0,  5,  0},

  {'R',  0.35,   -1.0,   -0.5,  0.0, 99.0,  5,  0},
  {'R',  0.35,    0.5,    1.0,  0.0, 99.0,  5,  0},

  {'R',  0.36,   -0.5,    0.5,  0.0, 99.0,  5,  0},
  {'R',  0.38,   -0.5,    0.5,  0.0, 99.0,  5,  0},

  {'R',   0.4,   -1.0,    1.0,  0.0, 99.0,  5,  1},
  {'R',   0.4,   -5.0,   -1.0,  0.0, 99.0,  5,  0},
  {'R',   0.4,    1.0,    5.0,  0.0, 99.0,  5,  0},

  {'R',  0.42,   -0.5,    0.5,  0.0, 99.0,  5,  0},
  {'R',  0.44,   -0.5,    0.5,  0.0, 99.0,  5,  0},

  {'R',  0.45,   -1.0,   -0.5,  0.0, 99.0,  5,  0},
  {'R',  0.45,    0.5,    1.0,  0.0, 99.0,  5,  0},

  {'R',  0.46,   -0.5,    0.5,  0.0, 99.0,  5,  0},
  {'R',  0.48,   -0.5,    0.5,  0.0, 99.0,  5,  0},

  {'R',   0.5,   -2.0,    2.0,  0.0, 99.0,  5,  1},

  {'R',  0.55,   -1.0,    1.0,  0.0, 99.0,  5,  0},

  {'R',   0.6,   -1.0,    1.0,  0.0, 99.0,  5,  1},
  {'R',   0.6,   -5.0,   -1.0,  0.0, 99.0,  5,  0},
  {'R',   0.6,    1.0,    5.0,  0.0, 99.0,  5,  0},
      
  {'R',  0.65,   -1.0,    1.0,  0.0, 99.0,  5,  0},

  {'R',   0.7,   -1.0,    1.0,  0.0, 99.0,  5,  1},
  {'R',   0.7,   -2.0,   -1.0,  0.0, 99.0,  5,  0},
  {'R',   0.7,    1.0,    2.0,  0.0, 99.0,  5,  0},

  {'R',  0.75,   -1.0,    1.0,  0.0, 99.0,  5,  0},

  {'R',   0.8,   -1.0,    1.0,  0.0, 99.0,  5,  1},
  {'R',   0.8,   -5.0,   -1.0,  0.0, 99.0,  5,  0},
  {'R',   0.8,    1.0,    5.0,  0.0, 99.0,  5,  0},

  {'R',  0.85,   -1.0,    1.0,  0.0, 99.0,  5,  0},

  {'R',   0.9,   -1.0,    1.0,  0.0, 99.0,  5,  1},
  {'R',   0.9,   -2.0,   -1.0,  0.0, 99.0,  5,  0},
  {'R',   0.9,    1.0,    2.0,  0.0, 99.0,  5,  0},

  {'R',  0.95,   -1.0,    1.0,  0.0, 99.0,  5,  0},

  {'R',   1.0,  -10.0,   10.0,  0.0, 99.0,  5,  1},	// R unity

  {'R',   1.1,   -2.0,    2.0,  0.0, 99.0,  5,  0},

  {'R',   1.2,   -2.0,    2.0,  0.0, 99.0,  5,  1},
  {'R',   1.2,   -5.0,   -2.0,  0.0, 99.0,  5,  0},
  {'R',   1.2,    2.0,    5.0,  0.0, 99.0,  5,  0},

  {'R',   1.3,   -2.0,    2.0,  0.0, 99.0,  5,  0},

  {'R',   1.4,   -2.0,    2.0,  0.0, 99.0,  5,  1},
  {'R',   1.4,   -5.0,   -2.0,  0.0, 99.0,  5,  0},
  {'R',   1.4,    2.0,    5.0,  0.0, 99.0,  5,  0},

  {'R',   1.5,   -2.0,    2.0,  0.0, 99.0,  5,  0},

  {'R',   1.6,   -2.0,    2.0,  0.0, 99.0,  5,  1},
  {'R',   1.6,   -5.0,   -2.0,  0.0, 99.0,  5,  0},
  {'R',   1.6,    2.0,    5.0,  0.0, 99.0,  5,  0},

  {'R',   1.7,   -2.0,    2.0,  0.0, 99.0,  5,  0},

  {'R',   1.8,   -2.0,    2.0,  0.0, 99.0,  5,  1},
  {'R',   1.8,   -5.0,   -2.0,  0.0, 99.0,  5,  0},
  {'R',   1.8,    2.0,    5.0,  0.0, 99.0,  5,  0},

  {'R',   1.9,   -2.0,    2.0,  0.0, 99.0,  5,  0},

  {'R',   2.0,  -10.0,   10.0,  0.0, 99.0,  5,  1},
  {'R',   2.0,  -20.0,  -10.0,  0.0, 99.0,  5,  0},
  {'R',   2.0,   10.0,   20.0,  0.0, 99.0,  5,  0},

  {'R',   2.2,   -5.0,    5.0,  0.0, 99.0,  5,  0},
  {'R',   2.4,   -5.0,    5.0,  0.0, 99.0,  5,  0},
  {'R',   2.6,   -5.0,    5.0,  0.0, 99.0,  5,  0},
  {'R',   2.8,   -5.0,    5.0,  0.0, 99.0,  5,  0},

  {'R',   3.0,  -10.0,   10.0,  0.0, 99.0,  5,  1},

  {'R',   3.2,   -5.0,    5.0,  0.0, 99.0,  5,  0},
  {'R',   3.4,   -5.0,    5.0,  0.0, 99.0,  5,  0},
  {'R',   3.6,   -5.0,    5.0,  0.0, 99.0,  5,  0},
  {'R',   3.8,   -5.0,    5.0,  0.0, 99.0,  5,  0},

  {'R',   4.0,  -10.0,   10.0,  0.0, 99.0,  5,  1},
  {'R',   4.0,  -20.0,  -10.0,  0.0, 99.0,  5,  0},
  {'R',   4.0,   10.0,   20.0,  0.0, 99.0,  5,  0},

  {'R',   4.2,   -5.0,    5.0,  0.0, 99.0,  5,  0},
  {'R',   4.4,   -5.0,    5.0,  0.0, 99.0,  5,  0},
  {'R',   4.6,   -5.0,    5.0,  0.0, 99.0,  5,  0},
  {'R',   4.8,   -5.0,    5.0,  0.0, 99.0,  5,  0},

  {'R',   5.0,  -10.0,   10.0,  0.0, 99.0,  5,  1},

  {'R',   6.0,  -10.0,   10.0,  0.0, 99.0,  5,  0},
  {'R',   6.0,  -20.0,  -10.0,  0.0, 99.0,  5,  0},
  {'R',   6.0,   10.0,   20.0,  0.0, 99.0,  5,  0},

  {'R',   7.0,  -10.0,   10.0,  0.0, 99.0,  5,  0},

  {'R',   8.0,  -10.0,   10.0,  0.0, 99.0,  5,  0},
  {'R',   8.0,  -20.0,  -10.0,  0.0, 99.0,  5,  0},
  {'R',   8.0,   10.0,   20.0,  0.0, 99.0,  5,  0},

  {'R',   9.0,  -10.0,   10.0,  0.0, 99.0,  5,  0},

  {'R',  10.0, -999.0,  999.0,  0.0, 99.0,  5,  1},

  {'R',  15.0, -999.0,  999.0,  0.0, 99.0,  5,  0},

  {'R',  20.0, -999.0,  999.0,  0.0, 99.0,  5,  1},

  {'X',   0.0,    0.0,  999.9,  0.0, 99.0,  5,  1},

  {'X',  0.02,    0.0,    0.5,  0.0, 99.0,  5,  0},
  {'X',  0.04,    0.0,    0.5,  0.0, 99.0,  5,  0},

  {'X',  0.05,    0.5,    1.0,  0.0, 99.0,  5,  0},

  {'X',  0.06,    0.0,    0.5,  0.0, 99.0,  5,  0},
  {'X',  0.08,    0.0,    0.5,  0.0, 99.0,  5,  0},

  {'X',   0.1,    0.0,    1.0,  0.0, 99.0,  5,  1},
  {'X',   0.1,    1.0,    2.0,  0.0, 99.0,  5,  0},

  {'X',  0.12,    0.0,    0.5,  0.0, 99.0,  5,  0},
  {'X',  0.14,    0.0,    0.5,  0.0, 99.0,  5,  0},

  {'X',  0.15,    0.5,    1.0,  0.0, 99.0,  5,  0},

  {'X',  0.16,    0.0,    0.5,  0.0, 99.0,  5,  0},
  {'X',  0.18,    0.0,    0.5,  0.0, 99.0,  5,  0},

  {'X',   0.2,    0.0,    2.0,  0.0, 99.0,  5,  1},
  {'X',   0.2,    2.0,    5.0,  0.0, 99.0,  5,  0},

  {'X',  0.22,    0.0,    0.5,  0.0, 99.0,  5,  0},
  {'X',  0.24,    0.0,    0.5,  0.0, 99.0,  5,  0},

  {'X',  0.25,    0.5,    1.0,  0.0, 99.0,  5,  0},

  {'X',  0.26,    0.0,    0.5,  0.0, 99.0,  5,  0},
  {'X',  0.28,    0.0,    0.5,  0.0, 99.0,  5,  0},

  {'X',   0.3,    0.0,    1.0,  0.0, 99.0,  5,  1},
  {'X',   0.3,    1.0,    2.0,  0.0, 99.0,  5,  0},

  {'X',  0.32,    0.0,    0.5,  0.0, 99.0,  5,  0},
  {'X',  0.34,    0.0,    0.5,  0.0, 99.0,  5,  0},

  {'X',  0.35,    0.5,    1.0,  0.0, 99.0,  5,  0},

  {'X',  0.36,    0.0,    0.5,  0.0, 99.0,  5,  0},
  {'X',  0.38,    0.0,    0.5,  0.0, 99.0,  5,  0},

  {'X',   0.4,    0.0,    2.0,  0.0, 99.0,  5,  1},
  {'X',   0.4,    2.0,    5.0,  0.0, 99.0,  5,  0},

  {'X',  0.42,    0.0,    0.5,  0.0, 99.0,  5,  0},
  {'X',  0.44,    0.0,    0.5,  0.0, 99.0,  5,  0},

  {'X',  0.45,    0.5,    1.0,  0.0, 99.0,  5,  0},

  {'X',  0.46,    0.0,    0.5,  0.0, 99.0,  5,  0},
  {'X',  0.48,    0.0,    0.5,  0.0, 99.0,  5,  0},

  {'X',   0.5,    0.0,    1.0,  0.0, 99.0,  5,  1},
  {'X',   0.5,    1.0,    2.0,  0.0, 99.0,  5,  0},

  {'X',  0.55,    0.0,    1.0,  0.0, 99.0,  5,  0},

  {'X',   0.6,    0.0,    2.0,  0.0, 99.0,  5,  1},
  {'X',   0.6,    2.0,    5.0,  0.0, 99.0,  5,  0},

  {'X',  0.65,    0.0,    1.0,  0.0, 99.0,  5,  0},

  {'X',   0.7,    0.0,    1.0,  0.0, 99.0,  5,  1},
  {'X',   0.7,    1.0,    2.0,  0.0, 99.0,  5,  0},

  {'X',  0.75,    0.0,    1.0,  0.0, 99.0,  5,  0},

  {'X',   0.8,    0.0,    2.0,  0.0, 99.0,  5,  1},
  {'X',   0.8,    2.0,    5.0,  0.0, 99.0,  5,  0},

  {'X',  0.85,    0.0,    1.0,  0.0, 99.0,  5,  0},

  {'X',   0.9,    0.0,    1.0,  0.0, 99.0,  5,  1},
  {'X',   0.9,    1.0,    2.0,  0.0, 99.0,  5,  0},

  {'X',  0.95,    0.0,    1.0,  0.0, 99.0,  5,  0},

  {'X',   1.0,    0.0,    5.0,  0.0, 99.0,  5,  1},	// Xl unity
  {'X',   1.0,    5.0,   10.0,  0.0, 99.0,  5,  0},

  {'X',   1.1,    0.0,    2.0,  0.0, 99.0,  5,  0},

  {'X',   1.2,    0.0,    2.0,  0.0, 99.0,  5,  1},
  {'X',   1.2,    2.0,    5.0,  0.0, 99.0,  5,  0},

  {'X',   1.3,    0.0,    2.0,  0.0, 99.0,  5,  0},

  {'X',   1.4,    0.0,    2.0,  0.0, 99.0,  5,  1},
  {'X',   1.4,    2.0,    5.0,  0.0, 99.0,  5,  0},

  {'X',   1.5,    0.0,    2.0,  0.0, 99.0,  5,  0},

  {'X',   1.6,    0.0,    2.0,  0.0, 99.0,  5,  1},
  {'X',   1.6,    2.0,    5.0,  0.0, 99.0,  5,  0},

  {'X',   1.7,    0.0,    2.0,  0.0, 99.0,  5,  0},

  {'X',   1.8,    0.0,    2.0,  0.0, 99.0,  5,  1},
  {'X',   1.8,    2.0,    5.0,  0.0, 99.0,  5,  0},

  {'X',   1.9,    0.0,    2.0,  0.0, 99.0,  5,  0},

  {'X',   2.0,    0.0,    5.0,  0.0, 99.0,  5,  1},
  {'X',   2.0,    5.0,   20.0,  0.0, 99.0,  5,  0},

  {'X',   2.2,    0.0,    5.0,  0.0, 99.0,  5,  0},
  {'X',   2.4,    0.0,    5.0,  0.0, 99.0,  5,  0},
  {'X',   2.6,    0.0,    5.0,  0.0, 99.0,  5,  0},
  {'X',   2.8,    0.0,    5.0,  0.0, 99.0,  5,  0},

  {'X',   3.0,    0.0,    5.0,  0.0, 99.0,  5,  1},
  {'X',   3.0,    5.0,   10.0,  0.0, 99.0,  5,  0},

  {'X',   3.2,    0.0,    5.0,  0.0, 99.0,  5,  0},
  {'X',   3.4,    0.0,    5.0,  0.0, 99.0,  5,  0},
  {'X',   3.6,    0.0,    5.0,  0.0, 99.0,  5,  0},
  {'X',   3.8,    0.0,    5.0,  0.0, 99.0,  5,  0},

  {'X',   4.0,    0.0,    5.0,  0.0, 99.0,  5,  1},
  {'X',   4.0,    5.0,   20.0,  0.0, 99.0,  5,  0},

  {'X',   4.2,    0.0,    5.0,  0.0, 99.0,  5,  0},
  {'X',   4.4,    0.0,    5.0,  0.0, 99.0,  5,  0},
  {'X',   4.6,    0.0,    5.0,  0.0, 99.0,  5,  0},
  {'X',   4.8,    0.0,    5.0,  0.0, 99.0,  5,  0},

  {'X',   5.0,    0.0,    5.0,  0.0, 99.0,  5,  1},
  {'X',   5.0,    5.0,   10.0,  0.0, 99.0,  5,  0},

  {'X',   6.0,    0.0,   20.0,  0.0, 99.0,  5,  0},
  {'X',   7.0,    0.0,   10.0,  0.0, 99.0,  5,  0},
  {'X',   8.0,    0.0,   20.0,  0.0, 99.0,  5,  0},
  {'X',   9.0,    0.0,   10.0,  0.0, 99.0,  5,  0},

  {'X',  10.0,    0.0,  999.0,  0.0, 99.0,  5,  1},

  {'X',  15.0,    0.0,  999.0,  0.0, 99.0,  5,  0},

  {'X',  20.0,    0.0,  999.0,  0.0, 99.0,  5,  1},

  {'X', -0.02,    0.0,    0.5,  0.0, 99.0,  5,  0},
  {'X', -0.04,    0.0,    0.5,  0.0, 99.0,  5,  0},

  {'X', -0.05,    0.5,    1.0,  0.0, 99.0,  5,  0},

  {'X', -0.06,    0.0,    0.5,  0.0, 99.0,  5,  0},
  {'X', -0.08,    0.0,    0.5,  0.0, 99.0,  5,  0},

  {'X',  -0.1,    0.0,    1.0,  0.0, 99.0,  5,  1},
  {'X',  -0.1,    1.0,    2.0,  0.0, 99.0,  5,  0},

  {'X', -0.12,    0.0,    0.5,  0.0, 99.0,  5,  0},
  {'X', -0.14,    0.0,    0.5,  0.0, 99.0,  5,  0},

  {'X', -0.15,    0.5,    1.0,  0.0, 99.0,  5,  0},

  {'X', -0.16,    0.0,    0.5,  0.0, 99.0,  5,  0},
  {'X', -0.18,    0.0,    0.5,  0.0, 99.0,  5,  0},

  {'X',  -0.2,    0.0,    2.0,  0.0, 99.0,  5,  1},
  {'X',  -0.2,    2.0,    5.0,  0.0, 99.0,  5,  0},

  {'X', -0.22,    0.0,    0.5,  0.0, 99.0,  5,  0},
  {'X', -0.24,    0.0,    0.5,  0.0, 99.0,  5,  0},

  {'X', -0.25,    0.5,    1.0,  0.0, 99.0,  5,  0},

  {'X', -0.26,    0.0,    0.5,  0.0, 99.0,  5,  0},
  {'X', -0.28,    0.0,    0.5,  0.0, 99.0,  5,  0},

  {'X',  -0.3,    0.0,    1.0,  0.0, 99.0,  5,  1},
  {'X',  -0.3,    1.0,    2.0,  0.0, 99.0,  5,  0},

  {'X', -0.32,    0.0,    0.5,  0.0, 99.0,  5,  0},
  {'X', -0.34,    0.0,    0.5,  0.0, 99.0,  5,  0},

  {'X', -0.35,    0.5,    1.0,  0.0, 99.0,  5,  0},

  {'X', -0.36,    0.0,    0.5,  0.0, 99.0,  5,  0},
  {'X', -0.38,    0.0,    0.5,  0.0, 99.0,  5,  0},

  {'X',  -0.4,    0.0,    2.0,  0.0, 99.0,  5,  1},
  {'X',  -0.4,    2.0,    5.0,  0.0, 99.0,  5,  0},

  {'X', -0.42,    0.0,    0.5,  0.0, 99.0,  5,  0},
  {'X', -0.44,    0.0,    0.5,  0.0, 99.0,  5,  0},

  {'X', -0.45,    0.5,    1.0,  0.0, 99.0,  5,  0},

  {'X', -0.46,    0.0,    0.5,  0.0, 99.0,  5,  0},
  {'X', -0.48,    0.0,    0.5,  0.0, 99.0,  5,  0},

  {'X',  -0.5,    0.0,    1.0,  0.0, 99.0,  5,  1},
  {'X',  -0.5,    1.0,    2.0,  0.0, 99.0,  5,  0},

  {'X', -0.55,    0.0,    1.0,  0.0, 99.0,  5,  0},

  {'X',  -0.6,    0.0,    2.0,  0.0, 99.0,  5,  1},
  {'X',  -0.6,    2.0,    5.0,  0.0, 99.0,  5,  0},

  {'X', -0.65,    0.0,    1.0,  0.0, 99.0,  5,  0},

  {'X',  -0.7,    0.0,    1.0,  0.0, 99.0,  5,  1},
  {'X',  -0.7,    1.0,    2.0,  0.0, 99.0,  5,  0},

  {'X', -0.75,    0.0,    1.0,  0.0, 99.0,  5,  0},

  {'X',  -0.8,    0.0,    2.0,  0.0, 99.0,  5,  1},
  {'X',  -0.8,    2.0,    5.0,  0.0, 99.0,  5,  0},

  {'X', -0.85,    0.0,    1.0,  0.0, 99.0,  5,  0},

  {'X',  -0.9,    0.0,    1.0,  0.0, 99.0,  5,  1},
  {'X',  -0.9,    1.0,    2.0,  0.0, 99.0,  5,  0},

  {'X', -0.95,    0.0,    1.0,  0.0, 99.0,  5,  0},

  {'X',  -1.0,    0.0,    5.0,  0.0, 99.0,  5,  1},	// Xc unity
  {'X',  -1.0,    5.0,   10.0,  0.0, 99.0,  5,  0},

  {'X',  -1.1,    0.0,    2.0,  0.0, 99.0,  5,  0},

  {'X',  -1.2,    0.0,    2.0,  0.0, 99.0,  5,  1},
  {'X',  -1.2,    2.0,    5.0,  0.0, 99.0,  5,  0},

  {'X',  -1.3,    0.0,    2.0,  0.0, 99.0,  5,  0},

  {'X',  -1.4,    0.0,    2.0,  0.0, 99.0,  5,  1},
  {'X',  -1.4,    2.0,    5.0,  0.0, 99.0,  5,  0},

  {'X',  -1.5,    0.0,    2.0,  0.0, 99.0,  5,  0},

  {'X',  -1.6,    0.0,    2.0,  0.0, 99.0,  5,  1},
  {'X',  -1.6,    2.0,    5.0,  0.0, 99.0,  5,  0},

  {'X',  -1.7,    0.0,    2.0,  0.0, 99.0,  5,  0},

  {'X',  -1.8,    0.0,    2.0,  0.0, 99.0,  5,  1},
  {'X',  -1.8,    2.0,    5.0,  0.0, 99.0,  5,  0},

  {'X',  -1.9,    0.0,    2.0,  0.0, 99.0,  5,  0},

  {'X',  -2.0,    0.0,    5.0,  0.0, 99.0,  5,  1},
  {'X',  -2.0,    5.0,   20.0,  0.0, 99.0,  5,  0},

  {'X',  -2.2,    0.0,    5.0,  0.0, 99.0,  5,  0},
  {'X',  -2.4,    0.0,    5.0,  0.0, 99.0,  5,  0},
  {'X',  -2.6,    0.0,    5.0,  0.0, 99.0,  5,  0},
  {'X',  -2.8,    0.0,    5.0,  0.0, 99.0,  5,  0},

  {'X',  -3.0,    0.0,    5.0,  0.0, 99.0,  5,  1},
  {'X',  -3.0,    5.0,   10.0,  0.0, 99.0,  5,  0},

  {'X',  -3.2,    0.0,    5.0,  0.0, 99.0,  5,  0},
  {'X',  -3.4,    0.0,    5.0,  0.0, 99.0,  5,  0},
  {'X',  -3.6,    0.0,    5.0,  0.0, 99.0,  5,  0},
  {'X',  -3.8,    0.0,    5.0,  0.0, 99.0,  5,  0},

  {'X',  -4.0,    0.0,    5.0,  0.0, 99.0,  5,  1},
  {'X',  -4.0,    5.0,   20.0,  0.0, 99.0,  5,  0},

  {'X',  -4.2,    0.0,    5.0,  0.0, 99.0,  5,  0},
  {'X',  -4.4,    0.0,    5.0,  0.0, 99.0,  5,  0},
  {'X',  -4.6,    0.0,    5.0,  0.0, 99.0,  5,  0},
  {'X',  -4.8,    0.0,    5.0,  0.0, 99.0,  5,  0},

  {'X',  -5.0,    0.0,    5.0,  0.0, 99.0,  5,  1},
  {'X',  -5.0,    5.0,   10.0,  0.0, 99.0,  5,  0},

  {'X',  -6.0,    0.0,   20.0,  0.0, 99.0,  5,  0},
  {'X',  -7.0,    0.0,   10.0,  0.0, 99.0,  5,  0},

  {'X',  -9.0,    0.0,   10.0,  0.0, 99.0,  5,  0},

  {'X', -10.0,    0.0,  999.0,  0.0, 99.0,  5,  1},

  {'X', -15.0,    0.0,  999.0,  0.0, 99.0,  5,  0},

  {'X', -20.0,    0.0,  999.0,  0.0, 99.0,  5,  1}
};
#define nrpldefs (sizeof(pldef)/sizeof(plot_definition))

label_definition lbldef[] = {
  {'R',  0.1,   0.0,    LBL_NE},
  {'R',  0.2,   0.0,    LBL_NE},
  {'R',  0.3,   0.0,    LBL_NE},
  {'R',  0.4,   0.0,    LBL_NE},
  {'R',  0.5,   0.0,    LBL_NE},
  {'R',  0.6,   0.0,    LBL_NE},
  {'R',  0.7,   0.0,    LBL_NE},
  {'R',  0.8,   0.0,    LBL_NE},
  {'R',  0.9,   0.0,    LBL_NE},
  {'R',  1.0,   0.0,    LBL_NE},

  {'R',  1.2,   0.0,    LBL_NE},
  {'R',  1.4,   0.0,    LBL_NE},
  {'R',  1.6,   0.0,    LBL_NE},
  {'R',  1.8,   0.0,    LBL_NE},
  {'R',  2.0,   0.0,    LBL_NE},

  {'R',  3.0,   0.0,    LBL_NE},
  {'R',  4.0,   0.0,    LBL_NE},
  {'R',  5.0,   0.0,    LBL_NE},
  {'R', 10.0,   0.0,    LBL_NE},
  {'R', 20.0,   0.0,    LBL_NE},

  {'R',  0.1,   1.0,    LBL_NE},
  {'R',  0.2,   1.0,    LBL_NE},
  {'R',  0.3,   1.0,    LBL_NE},
  {'R',  0.4,   1.0,    LBL_NE},
  {'R',  0.5,   1.0,    LBL_NE},

  {'R',  0.1,  -1.0,    LBL_SE},
  {'R',  0.2,  -1.0,    LBL_SE},
  {'R',  0.3,  -1.0,    LBL_SE},
  {'R',  0.4,  -1.0,    LBL_SE},
  {'R',  0.5,  -1.0,    LBL_SE},

  {'X',  0.0,   0.0,    LBL_NE},

  {'X',  0.0,   0.1,    LBL_SE},
  {'X',  0.0,   0.2,    LBL_SE},
  {'X',  0.0,   0.3,    LBL_SE},
  {'X',  0.0,   0.4,    LBL_SE},
  {'X',  0.0,   0.5,    LBL_SE},
  {'X',  0.0,   0.6,    LBL_SE},
  {'X',  0.0,   0.7,    LBL_SE},
  {'X',  0.0,   0.8,    LBL_SE},
  {'X',  0.0,   0.9,    LBL_SE},
  {'X',  0.0,   1.0,    LBL_SE},

  {'X',  1.0,   0.2,    LBL_SE},
  {'X',  1.0,   0.4,    LBL_SE},
  {'X',  1.0,   0.6,    LBL_SE},
  {'X',  1.0,   0.8,    LBL_SE},
  {'X',  1.0,   1.0,    LBL_SE},

  {'X',  0.0,   1.2,    LBL_SE},
  {'X',  0.0,   1.4,    LBL_SE},
  {'X',  0.0,   1.6,    LBL_SE},
  {'X',  0.0,   1.8,    LBL_SE},
  {'X',  0.0,   2.0,    LBL_SE},

  {'X',  0.0,   3.0,    LBL_SE},
  {'X',  0.0,   4.0,    LBL_SE},
  {'X',  0.0,   5.0,    LBL_SE},
  {'X',  0.0,  10.0,    LBL_SE},
  {'X',  0.0,  20.0,    LBL_SE},

  {'X',  0.0,  -0.1,    LBL_NE},
  {'X',  0.0,  -0.2,    LBL_NE},
  {'X',  0.0,  -0.3,    LBL_NE},
  {'X',  0.0,  -0.4,    LBL_NE},
  {'X',  0.0,  -0.5,    LBL_NE},
  {'X',  0.0,  -0.6,    LBL_NE},
  {'X',  0.0,  -0.7,    LBL_NE},
  {'X',  0.0,  -0.8,    LBL_NE},
  {'X',  0.0,  -0.9,    LBL_NE},
  {'X',  0.0,  -1.0,    LBL_NE},

  {'X',  1.0,  -0.2,    LBL_NE},
  {'X',  1.0,  -0.4,    LBL_NE},
  {'X',  1.0,  -0.6,    LBL_NE},
  {'X',  1.0,  -0.8,    LBL_NE},
  {'X',  1.0,  -1.0,    LBL_NE},

  {'X',  0.0,  -1.2,    LBL_NE},
  {'X',  0.0,  -1.4,    LBL_NE},
  {'X',  0.0,  -1.6,    LBL_NE},
  {'X',  0.0,  -1.8,    LBL_NE},
  {'X',  0.0,  -2.0,    LBL_NE},

  {'X',  0.0,  -3.0,    LBL_NE},
  {'X',  0.0,  -4.0,    LBL_NE},
  {'X',  0.0,  -5.0,    LBL_NE},
  {'X',  0.0,  -10.0,   LBL_NE},
  {'X',  0.0,  -20.0,   LBL_NE}
};
#define nrlbldefs (sizeof(lbldef)/sizeof(label_definition))
