 /*
  The mediastreamer library aims at providing modular media processing and I/O
	for linphone, but also for any telephony application.
  Copyright (C) 2001  Simon MORLAT simon.morlat@linphone.org
  										
  This library is free software; you can redistribute it and/or
  modify it under the terms of the GNU Lesser General Public
  License as published by the Free Software Foundation; either
  version 2.1 of the License, or (at your option) any later version.

  This library is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  Lesser General Public License for more details.

  You should have received a copy of the GNU Lesser General Public
  License along with this library; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#include "ms.h"

#include "mswrite.h"
#include "msrtprecv.h"
#include "msavdecoder.h"
#include "msavencoder.h"
#include "msLPC10encoder.h"
#include "mstimer.h"
#include "msnosync.h"
#include "msvideooutput.h"

#include <signal.h>
#include <sys/types.h>
#include <unistd.h>
#include <stdio.h>

static int cond=1;

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

void stop_handler(int signum)
{
	cond=0;
}
#ifdef HAVE_AVCODEC

int main()
{
	MSFilter *play,*dec,*rec;
	MSSync *timer;	
	RtpSession *session;
	
	ms_init();
	ms_AVCodec_init();
	ortp_init();
	ortp_set_debug_file("oRTP",NULL);
	session=rtp_session_new(RTP_SESSION_RECVONLY);
	rtp_session_set_local_addr(session,"0.0.0.0",8000);
	rtp_session_set_payload_type(session,32);	/*MPV*/
	rtp_session_set_blocking_mode(session,0);
	rtp_session_set_jitter_compensation(session,30);
	
	signal(SIGINT,stop_handler);
	
	play=ms_rtp_recv_new();
	ms_rtp_recv_set_session(MS_RTP_RECV(play),session);
	rec=ms_video_output_new();
	dec=ms_mpeg_decoder_new();
	timer=ms_timer_new();
	ms_timer_set_interval(MS_TIMER(timer),20);
	ms_video_output_set_size(MS_VIDEO_OUTPUT(rec),352,288);
	
	ms_AVdecoder_set_format(MS_AVDECODER(dec),"RGB24");
	ms_filter_add_link(play,dec);
	ms_filter_add_link(dec,rec);
	ms_sync_attach(timer,play);
	
	ms_start(timer);
	
	while(cond)
	{
		sleep(1);
	}
	printf("stoping sync...\n");
	ms_stop(timer);
	printf("unlinking filters...\n");
	ms_filter_remove_links(play,dec);
	ms_filter_remove_links(dec,rec);
	printf("destroying filters...\n");
	ms_filter_destroy(play);
	ms_filter_destroy(dec);
	ms_filter_destroy(rec);
	return 0;
}
#else

int main()
{
	printf("AVcodec support is not compiled.\n");
	return 0;
}
#endif
