/*
  The osipua library is a library based on oSIP that implements CallLeg and User Agent
  level.
  Copyright (C) 2001  Simon MORLAT simon.morlat@free.fr
  											Aymeric MOIZARD jack@atosc.org
  This library is free software; you can redistribute it and/or
  modify it under the terms of the GNU Lesser General Public
  License as published by the Free Software Foundation; either
  version 2.1 of the License, or (at your option) any later version.

  This library is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  Lesser General Public License for more details.

  You should have received a copy of the GNU Lesser General Public
  License along with this library; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#ifndef REGCTX_H
#define REGCTX_H

struct _RegistrationCtxt
{
	char *registrar;   /* name or address of the registrar */
	char *address_of_record;   /* can be NULL, in which case calleg->from is used */
	char *password;
        int cseq_number;
        char *callid_number;
	int expires;
	int action; 	/* perhaps deprecated ...*/
#define REGISTER_ACTION_PROXY 0
#define REGISTER_ACTION_REDIRECT 1
#define REGISTER_ACTION_ANY 2
	int ref_count;  /* private, don 't touch it ! */
} ;

typedef  struct _RegistrationCtxt  RegistrationCtxt;
/* public API */
RegistrationCtxt *registration_ctxt_new();
void registration_ctxt_set_registrar(RegistrationCtxt *ctxt, char *registrar);
void registration_ctxt_set_password(RegistrationCtxt *ctxt, char *password);
void registration_ctxt_set_address_of_record(RegistrationCtxt *ctxt, char *addr_of_rec);
#define registration_ctxt_set_expires(r,e) 	(r)->expires=(e)
#define registration_ctxt_set_action(r,a) 	(r)->action=(a)
void registration_ctxt_destroy( RegistrationCtxt *ctx);

/* PRIVATE: */
#define registration_ctxt_ref(ctx) 	(ctx)->ref_count++
void registration_ctxt_free(RegistrationCtxt *ctx);
#endif
