/* Generated by GOB (v2.0.14)   (do not edit directly) */

/* End world hunger, donate to the World Food Programme, http://www.wfp.org */

#define GOB_VERSION_MAJOR 2
#define GOB_VERSION_MINOR 0
#define GOB_VERSION_PATCHLEVEL 14

#define selfp (self->_priv)

#include "lm-host.h"

#include "lm-host-private.h"

#ifdef G_LIKELY
#define ___GOB_LIKELY(expr) G_LIKELY(expr)
#define ___GOB_UNLIKELY(expr) G_UNLIKELY(expr)
#else /* ! G_LIKELY */
#define ___GOB_LIKELY(expr) (expr)
#define ___GOB_UNLIKELY(expr) (expr)
#endif /* G_LIKELY */

#line 44 "lm-host.gob"

#include "config.h"
#include <string.h>
#include <stdarg.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <netdb.h>
#include <glib/gi18n.h>
#include <eel/eel.h>
#include "lm-util.h"
#include "lm-applet.h"

#ifndef HAVE_REENTRANT_RESOLVER
G_LOCK_DEFINE_STATIC(resolver);
#endif

#line 41 "lm-host.c"
/* self casting macros */
#define SELF(x) LM_HOST(x)
#define SELF_CONST(x) LM_HOST_CONST(x)
#define IS_SELF(x) LM_IS_HOST(x)
#define TYPE_SELF LM_TYPE_HOST
#define SELF_CLASS(x) LM_HOST_CLASS(x)

#define SELF_GET_CLASS(x) LM_HOST_GET_CLASS(x)

/* self typedefs */
typedef LMHost Self;
typedef LMHostClass SelfClass;

/* here are local prototypes */
static void ___object_set_property (GObject *object, guint property_id, const GValue *value, GParamSpec *pspec);
static void ___object_get_property (GObject *object, guint property_id, GValue *value, GParamSpec *pspec);
static void lm_host_init (LMHost * o) G_GNUC_UNUSED;
static void lm_host_class_init (LMHostClass * c) G_GNUC_UNUSED;
static void ___8_lm_host_finalize (GObject * object) G_GNUC_UNUSED;
static GObject * ___9_lm_host_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_params) G_GNUC_UNUSED;
static void lm_host_resolve (LMHost * self) G_GNUC_UNUSED;
static gpointer lm_host_resolve_thread_cb (gpointer data) G_GNUC_UNUSED;
static void lm_host_install_resolve_timeout (LMHost * self, unsigned int delay) G_GNUC_UNUSED;
static gboolean lm_host_resolve_timeout_cb (gpointer data) G_GNUC_UNUSED;
static void lm_host_send_echo_request (LMHost * self) G_GNUC_UNUSED;
static void lm_host_install_send_timeout (LMHost * self) G_GNUC_UNUSED;
static gboolean lm_host_send_timeout_cb (gpointer data) G_GNUC_UNUSED;
static gboolean lm_host_dead_timeout_cb (gpointer data) G_GNUC_UNUSED;

enum {
	PROP_0,
	PROP_APPLET,
	PROP_NAME,
	PROP_IP,
	PROP_HOST_ID,
	PROP_ALIVE,
	PROP_ROUNDTRIP_TIME,
	PROP_ERROR,
	PROP_STATUS
};

/* pointer to the class of our parent */
static GObjectClass *parent_class = NULL;

/* Short form macros */
#define self_get_alive lm_host_get_alive
#define self_set_alive lm_host_set_alive
#define self_get_roundtrip_time lm_host_get_roundtrip_time
#define self_set_roundtrip_time lm_host_set_roundtrip_time
#define self_set_error lm_host_set_error
#define self_get_status lm_host_get_status
#define self_set_status lm_host_set_status
#define self_resolve lm_host_resolve
#define self_resolve_thread_cb lm_host_resolve_thread_cb
#define self_install_resolve_timeout lm_host_install_resolve_timeout
#define self_resolve_timeout_cb lm_host_resolve_timeout_cb
#define self_send_echo_request lm_host_send_echo_request
#define self_install_send_timeout lm_host_install_send_timeout
#define self_send_timeout_cb lm_host_send_timeout_cb
#define self_dead_timeout_cb lm_host_dead_timeout_cb
#define self_reply_received lm_host_reply_received
GType
lm_host_get_type (void)
{
	static GType type = 0;

	if ___GOB_UNLIKELY(type == 0) {
		static const GTypeInfo info = {
			sizeof (LMHostClass),
			(GBaseInitFunc) NULL,
			(GBaseFinalizeFunc) NULL,
			(GClassInitFunc) lm_host_class_init,
			(GClassFinalizeFunc) NULL,
			NULL /* class_data */,
			sizeof (LMHost),
			0 /* n_preallocs */,
			(GInstanceInitFunc) lm_host_init,
			NULL
		};

		type = g_type_register_static (G_TYPE_OBJECT, "LMHost", &info, (GTypeFlags)G_TYPE_FLAG_ABSTRACT);
	}

	return type;
}

/* a macro for creating a new object of our type */
#define GET_NEW ((LMHost *)g_object_new(lm_host_get_type(), NULL))

/* a function for creating a new object of our type */
#include <stdarg.h>
static LMHost * GET_NEW_VARG (const char *first, ...) G_GNUC_UNUSED;
static LMHost *
GET_NEW_VARG (const char *first, ...)
{
	LMHost *ret;
	va_list ap;
	va_start (ap, first);
	ret = (LMHost *)g_object_new_valist (lm_host_get_type (), first, ap);
	va_end (ap);
	return ret;
}


static void
___finalize(GObject *obj_self)
{
#define __GOB_FUNCTION__ "LM:Host::finalize"
	LMHost *self G_GNUC_UNUSED = LM_HOST (obj_self);
	gpointer priv G_GNUC_UNUSED = self->_priv;
#line 138 "lm-host.gob"
	___8_lm_host_finalize(obj_self);
#line 154 "lm-host.c"
#line 66 "lm-host.gob"
	if(self->name) { g_free ((gpointer) self->name); self->name = NULL; }
#line 157 "lm-host.c"
#line 69 "lm-host.gob"
	if(self->_priv->addrinfo) { freeaddrinfo ((gpointer) self->_priv->addrinfo); self->_priv->addrinfo = NULL; }
#line 160 "lm-host.c"
#line 73 "lm-host.gob"
	if(self->ip) { g_free ((gpointer) self->ip); self->ip = NULL; }
#line 163 "lm-host.c"
#line 104 "lm-host.gob"
	if(self->error) { g_free ((gpointer) self->error); self->error = NULL; }
#line 166 "lm-host.c"
}
#undef __GOB_FUNCTION__

static void 
lm_host_init (LMHost * o G_GNUC_UNUSED)
{
#define __GOB_FUNCTION__ "LM:Host::init"
	o->_priv = G_TYPE_INSTANCE_GET_PRIVATE(o,LM_TYPE_HOST,LMHostPrivate);
}
#undef __GOB_FUNCTION__
static void 
lm_host_class_init (LMHostClass * c G_GNUC_UNUSED)
{
#define __GOB_FUNCTION__ "LM:Host::class_init"
	GObjectClass *g_object_class G_GNUC_UNUSED = (GObjectClass*) c;

	g_type_class_add_private(c,sizeof(LMHostPrivate));

	parent_class = g_type_class_ref (G_TYPE_OBJECT);

#line 138 "lm-host.gob"
	g_object_class->finalize = ___finalize;
#line 153 "lm-host.gob"
	g_object_class->constructor = ___9_lm_host_constructor;
#line 191 "lm-host.c"
	g_object_class->get_property = ___object_get_property;
	g_object_class->set_property = ___object_set_property;
    {
	GParamSpec   *param_spec;

	param_spec = g_param_spec_pointer
		("applet" /* name */,
		 NULL /* nick */,
		 NULL /* blurb */,
		 (GParamFlags)(G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (g_object_class,
		PROP_APPLET,
		param_spec);
	param_spec = g_param_spec_string
		("name" /* name */,
		 NULL /* nick */,
		 NULL /* blurb */,
		 NULL /* default_value */,
		 (GParamFlags)(G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (g_object_class,
		PROP_NAME,
		param_spec);
	param_spec = g_param_spec_string
		("ip" /* name */,
		 NULL /* nick */,
		 NULL /* blurb */,
		 NULL /* default_value */,
		 (GParamFlags)(G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (g_object_class,
		PROP_IP,
		param_spec);
	param_spec = g_param_spec_uint
		("host_id" /* name */,
		 NULL /* nick */,
		 NULL /* blurb */,
		 0 /* minimum */,
		 G_MAXUINT /* maximum */,
		 0 /* default_value */,
		 (GParamFlags)(G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (g_object_class,
		PROP_HOST_ID,
		param_spec);
	param_spec = g_param_spec_boolean
		("alive" /* name */,
		 NULL /* nick */,
		 NULL /* blurb */,
		 FALSE /* default_value */,
		 (GParamFlags)(G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (g_object_class,
		PROP_ALIVE,
		param_spec);
	param_spec = g_param_spec_double
		("roundtrip_time" /* name */,
		 NULL /* nick */,
		 NULL /* blurb */,
		 0 /* minimum */,
		 G_MAXDOUBLE /* maximum */,
		 0.0 /* default_value */,
		 (GParamFlags)(G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (g_object_class,
		PROP_ROUNDTRIP_TIME,
		param_spec);
	param_spec = g_param_spec_string
		("error" /* name */,
		 NULL /* nick */,
		 NULL /* blurb */,
		 NULL /* default_value */,
		 (GParamFlags)(G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (g_object_class,
		PROP_ERROR,
		param_spec);
	param_spec = g_param_spec_int
		("status" /* name */,
		 NULL /* nick */,
		 NULL /* blurb */,
		 G_MININT /* minimum */,
		 G_MAXINT /* maximum */,
		 0 /* default_value */,
		 (GParamFlags)(G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (g_object_class,
		PROP_STATUS,
		param_spec);
    }
}
#undef __GOB_FUNCTION__

static void
___object_set_property (GObject *object,
	guint property_id,
	const GValue *VAL G_GNUC_UNUSED,
	GParamSpec *pspec G_GNUC_UNUSED)
#define __GOB_FUNCTION__ "LM:Host::set_property"
{
	LMHost *self G_GNUC_UNUSED;

	self = LM_HOST (object);

	switch (property_id) {
	case PROP_APPLET:
		{
#line 64 "lm-host.gob"
self->applet = g_value_get_pointer (VAL);
#line 294 "lm-host.c"
		}
		break;
	case PROP_NAME:
		{
#line 67 "lm-host.gob"
{ char *old = self->name; self->name = g_value_dup_string (VAL); g_free (old); }
#line 301 "lm-host.c"
		}
		break;
	case PROP_IP:
		{
#line 74 "lm-host.gob"
{ char *old = self->ip; self->ip = g_value_dup_string (VAL); g_free (old); }
#line 308 "lm-host.c"
		}
		break;
	case PROP_HOST_ID:
		{
#line 77 "lm-host.gob"
self->host_id = g_value_get_uint (VAL);
#line 315 "lm-host.c"
		}
		break;
	case PROP_ALIVE:
		{
#line 84 "lm-host.gob"
self->alive = g_value_get_boolean (VAL);
#line 322 "lm-host.c"
		}
		break;
	case PROP_ROUNDTRIP_TIME:
		{
#line 93 "lm-host.gob"

      self->last_received = lm_time();
      lm_source_clear(&selfp->dead_timeout_id);
      self->roundtrip_time = g_value_get_double(VAL);
      self_set_alive(self, TRUE);
    
#line 334 "lm-host.c"
		}
		break;
	case PROP_ERROR:
		{
#line 107 "lm-host.gob"

      lm_source_clear(&selfp->dead_timeout_id);
      g_free(self->error);
      self->error = g_value_dup_string(VAL);
      self_set_alive(self, FALSE);
      self_set_status(self, LM_HOST_STATUS_ERROR);
    
#line 347 "lm-host.c"
		}
		break;
	case PROP_STATUS:
		{
#line 136 "lm-host.gob"
self->status = g_value_get_int (VAL);
#line 354 "lm-host.c"
		}
		break;
	default:
/* Apparently in g++ this is needed, glib is b0rk */
#ifndef __PRETTY_FUNCTION__
#  undef G_STRLOC
#  define G_STRLOC	__FILE__ ":" G_STRINGIFY (__LINE__)
#endif
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}
#undef __GOB_FUNCTION__

static void
___object_get_property (GObject *object,
	guint property_id,
	GValue *VAL G_GNUC_UNUSED,
	GParamSpec *pspec G_GNUC_UNUSED)
#define __GOB_FUNCTION__ "LM:Host::get_property"
{
	LMHost *self G_GNUC_UNUSED;

	self = LM_HOST (object);

	switch (property_id) {
	case PROP_APPLET:
		{
#line 64 "lm-host.gob"
g_value_set_pointer (VAL, self->applet);
#line 385 "lm-host.c"
		}
		break;
	case PROP_NAME:
		{
#line 67 "lm-host.gob"
g_value_set_string (VAL, self->name);
#line 392 "lm-host.c"
		}
		break;
	case PROP_IP:
		{
#line 74 "lm-host.gob"
g_value_set_string (VAL, self->ip);
#line 399 "lm-host.c"
		}
		break;
	case PROP_HOST_ID:
		{
#line 77 "lm-host.gob"
g_value_set_uint (VAL, self->host_id);
#line 406 "lm-host.c"
		}
		break;
	case PROP_ALIVE:
		{
#line 84 "lm-host.gob"
g_value_set_boolean (VAL, self->alive);
#line 413 "lm-host.c"
		}
		break;
	case PROP_ROUNDTRIP_TIME:
		{
#line 100 "lm-host.gob"

      g_value_set_double(VAL, self->roundtrip_time);
    
#line 422 "lm-host.c"
		}
		break;
	case PROP_ERROR:
		{
#line 115 "lm-host.gob"

      g_value_set_string(VAL, self->error);
    
#line 431 "lm-host.c"
		}
		break;
	case PROP_STATUS:
		{
#line 136 "lm-host.gob"
g_value_set_int (VAL, self->status);
#line 438 "lm-host.c"
		}
		break;
	default:
/* Apparently in g++ this is needed, glib is b0rk */
#ifndef __PRETTY_FUNCTION__
#  undef G_STRLOC
#  define G_STRLOC	__FILE__ ":" G_STRINGIFY (__LINE__)
#endif
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}
#undef __GOB_FUNCTION__



#line 84 "lm-host.gob"
gboolean 
lm_host_get_alive (LMHost * self)
#line 458 "lm-host.c"
{
#define __GOB_FUNCTION__ "LM:Host::get_alive"
{
#line 84 "lm-host.gob"
		gboolean val; g_object_get (G_OBJECT (self), "alive", &val, NULL); return val;
}}
#line 465 "lm-host.c"
#undef __GOB_FUNCTION__

#line 84 "lm-host.gob"
void 
lm_host_set_alive (LMHost * self, gboolean val)
#line 471 "lm-host.c"
{
#define __GOB_FUNCTION__ "LM:Host::set_alive"
{
#line 84 "lm-host.gob"
		g_object_set (G_OBJECT (self), "alive", val, NULL);
}}
#line 478 "lm-host.c"
#undef __GOB_FUNCTION__

#line 100 "lm-host.gob"
gdouble 
lm_host_get_roundtrip_time (LMHost * self)
#line 484 "lm-host.c"
{
#define __GOB_FUNCTION__ "LM:Host::get_roundtrip_time"
{
#line 91 "lm-host.gob"
		gdouble val; g_object_get (G_OBJECT (self), "roundtrip_time", &val, NULL); return val;
}}
#line 491 "lm-host.c"
#undef __GOB_FUNCTION__

#line 93 "lm-host.gob"
void 
lm_host_set_roundtrip_time (LMHost * self, gdouble val)
#line 497 "lm-host.c"
{
#define __GOB_FUNCTION__ "LM:Host::set_roundtrip_time"
{
#line 91 "lm-host.gob"
		g_object_set (G_OBJECT (self), "roundtrip_time", val, NULL);
}}
#line 504 "lm-host.c"
#undef __GOB_FUNCTION__

#line 119 "lm-host.gob"
void 
lm_host_set_error (LMHost * self, const char * format, ...)
#line 510 "lm-host.c"
{
#define __GOB_FUNCTION__ "LM:Host::set_error"
#line 119 "lm-host.gob"
	g_return_if_fail (self != NULL);
#line 119 "lm-host.gob"
	g_return_if_fail (LM_IS_HOST (self));
#line 119 "lm-host.gob"
	g_return_if_fail (format != NULL);
#line 519 "lm-host.c"
{
#line 121 "lm-host.gob"
	
    va_list args;
    char *error;

    va_start(args, format);
    error = g_strdup_vprintf(format, args);
    va_end(args);

    g_object_set(G_OBJECT(self), LM_HOST_PROP_ERROR(error), NULL);
    g_free(error);
  }}
#line 533 "lm-host.c"
#undef __GOB_FUNCTION__

#line 136 "lm-host.gob"
LMHostStatus 
lm_host_get_status (LMHost * self)
#line 539 "lm-host.c"
{
#define __GOB_FUNCTION__ "LM:Host::get_status"
{
#line 136 "lm-host.gob"
		LMHostStatus val; g_object_get (G_OBJECT (self), "status", &val, NULL); return val;
}}
#line 546 "lm-host.c"
#undef __GOB_FUNCTION__

#line 136 "lm-host.gob"
void 
lm_host_set_status (LMHost * self, LMHostStatus val)
#line 552 "lm-host.c"
{
#define __GOB_FUNCTION__ "LM:Host::set_status"
{
#line 136 "lm-host.gob"
		g_object_set (G_OBJECT (self), "status", val, NULL);
}}
#line 559 "lm-host.c"
#undef __GOB_FUNCTION__

#line 138 "lm-host.gob"
static void 
___8_lm_host_finalize (GObject * object G_GNUC_UNUSED)
#line 565 "lm-host.c"
#define PARENT_HANDLER(___object) \
	{ if(G_OBJECT_CLASS(parent_class)->finalize) \
		(* G_OBJECT_CLASS(parent_class)->finalize)(___object); }
{
#define __GOB_FUNCTION__ "LM:Host::finalize"
#line 138 "lm-host.gob"
	g_return_if_fail (object != NULL);
#line 138 "lm-host.gob"
	g_return_if_fail (G_IS_OBJECT (object));
#line 575 "lm-host.c"
{
#line 140 "lm-host.gob"
	
    Self *self = SELF(object);

    if (selfp->resolve_timeout_id)
      g_source_remove(selfp->resolve_timeout_id);
    if (selfp->send_timeout_id)
      g_source_remove(selfp->send_timeout_id);
    if (selfp->dead_timeout_id)
      g_source_remove(selfp->dead_timeout_id);

    PARENT_HANDLER(object);
  }}
#line 590 "lm-host.c"
#undef __GOB_FUNCTION__
#undef PARENT_HANDLER

#line 153 "lm-host.gob"
static GObject * 
___9_lm_host_constructor (GType type G_GNUC_UNUSED, guint n_construct_properties, GObjectConstructParam * construct_params)
#line 597 "lm-host.c"
#define PARENT_HANDLER(___type,___n_construct_properties,___construct_params) \
	((G_OBJECT_CLASS(parent_class)->constructor)? \
		(* G_OBJECT_CLASS(parent_class)->constructor)(___type,___n_construct_properties,___construct_params): \
		((GObject * )0))
{
#define __GOB_FUNCTION__ "LM:Host::constructor"
{
#line 155 "lm-host.gob"
	
    GObject *object;
    Self *self;

    object = PARENT_HANDLER(type, n_construct_properties, construct_params);
    self = SELF(object);

    lm_g_object_connect(self, self->applet,
			"swapped-signal::notify::delay", self_install_send_timeout, self,
			NULL);

    self_resolve(self);

    return object;
  }}
#line 621 "lm-host.c"
#undef __GOB_FUNCTION__
#undef PARENT_HANDLER

#line 171 "lm-host.gob"
static void 
lm_host_resolve (LMHost * self)
#line 628 "lm-host.c"
{
#define __GOB_FUNCTION__ "LM:Host::resolve"
#line 171 "lm-host.gob"
	g_return_if_fail (self != NULL);
#line 171 "lm-host.gob"
	g_return_if_fail (LM_IS_HOST (self));
#line 635 "lm-host.c"
{
#line 173 "lm-host.gob"
	
    g_return_if_fail(selfp->resolving == FALSE);

    selfp->resolving = TRUE;
    g_object_ref(self);

    self_set_status(self, LM_HOST_STATUS_RESOLVING);
    lm_thread_create(self_resolve_thread_cb, self);
  }}
#line 647 "lm-host.c"
#undef __GOB_FUNCTION__

#line 183 "lm-host.gob"
static gpointer 
lm_host_resolve_thread_cb (gpointer data)
#line 653 "lm-host.c"
{
#define __GOB_FUNCTION__ "LM:Host::resolve_thread_cb"
{
#line 185 "lm-host.gob"
	
    Self *self = data;
    struct addrinfo hints;
    struct addrinfo *addrinfo;
    char *ip = NULL;
    int status;

    memset(&hints, 0, sizeof(hints));
#if WITH_IPV6
    hints.ai_family = PF_UNSPEC;
#else
    hints.ai_family = PF_INET;
#endif /* WITH_IPV6 */
    hints.ai_socktype = SOCK_RAW;

#ifndef HAVE_REENTRANT_RESOLVER
    G_LOCK(resolver);
#endif
    status = getaddrinfo(self->name, NULL, &hints, &addrinfo);
#ifndef HAVE_REENTRANT_RESOLVER
    G_UNLOCK(resolver);
#endif

    if (status == 0)
      {
  	char buf[NI_MAXHOST];
	int name_status;

#ifndef HAVE_REENTRANT_RESOLVER
	G_LOCK(resolver);
#endif
	name_status = getnameinfo(addrinfo->ai_addr,
				  addrinfo->ai_addrlen,
				  buf,
				  sizeof(buf),
				  NULL,
				  0,
				  NI_NUMERICHOST);
#ifndef HAVE_REENTRANT_RESOLVER
	G_UNLOCK(resolver);
#endif

	if (name_status == 0)
	  ip = g_strdup(buf);
      }
    else
      addrinfo = NULL;

    GDK_THREADS_ENTER();

    selfp->resolving = FALSE;

    if (selfp->addrinfo)
      freeaddrinfo(selfp->addrinfo);
    selfp->addrinfo = addrinfo;

    g_free(self->ip);
    self->ip = g_strdup(ip);
    g_object_notify(G_OBJECT(self), "ip");

    if (selfp->addrinfo)
      {
	selfp->sock = lm_shell_get_socket(lm_shell, selfp->addrinfo->ai_family);
	if (selfp->sock)
	  {
	    if (! selfp->sock->init_error)
	      {
		if (! selfp->send_timeout_id)
		  {
		    /* initial resolution */
		    self_send_echo_request(self);	/* send first packet */
		    self_install_send_timeout(self);	/* install send loop */
		  }
	      }
	    else
	      self_set_error(self, _("socket could not be initialized: %s"), selfp->sock->init_error);
	  }
	else
	  self_set_error(self, _("unsupported address family"));

	/* success (even if no socket), refresh in one hour */
	self_install_resolve_timeout(self, 3600 * 1000);
      }
    else
      {
	selfp->sock = NULL;
	self_set_error(self, _("unable to resolve hostname: %s"), gai_strerror(status));

	/* failure, retry in 10 seconds */
	self_install_resolve_timeout(self, 10 * 1000);
      }

    g_object_unref(self);

    /*
     * A note on gdk_flush(): as adviced in the GDK threads
     * documentation, we only call gdk_flush() from a thread other
     * than our main thread.
     */
    gdk_flush();
    GDK_THREADS_LEAVE();

    return NULL;
  }}
#line 762 "lm-host.c"
#undef __GOB_FUNCTION__

#line 290 "lm-host.gob"
static void 
lm_host_install_resolve_timeout (LMHost * self, unsigned int delay)
#line 768 "lm-host.c"
{
#define __GOB_FUNCTION__ "LM:Host::install_resolve_timeout"
#line 290 "lm-host.gob"
	g_return_if_fail (self != NULL);
#line 290 "lm-host.gob"
	g_return_if_fail (LM_IS_HOST (self));
#line 775 "lm-host.c"
{
#line 292 "lm-host.gob"
	
    g_return_if_fail(selfp->resolve_timeout_id == 0);
    selfp->resolve_timeout_id = g_timeout_add(delay, self_resolve_timeout_cb, self);
  }}
#line 782 "lm-host.c"
#undef __GOB_FUNCTION__

#line 297 "lm-host.gob"
static gboolean 
lm_host_resolve_timeout_cb (gpointer data)
#line 788 "lm-host.c"
{
#define __GOB_FUNCTION__ "LM:Host::resolve_timeout_cb"
{
#line 299 "lm-host.gob"
	
    Self *self = data;

    GDK_THREADS_ENTER();

    self_resolve(self);

    selfp->resolve_timeout_id = 0;

    GDK_THREADS_LEAVE();

    return FALSE;		/* remove source */
  }}
#line 806 "lm-host.c"
#undef __GOB_FUNCTION__

#line 313 "lm-host.gob"
static void 
lm_host_send_echo_request (LMHost * self)
#line 812 "lm-host.c"
{
#define __GOB_FUNCTION__ "LM:Host::send_echo_request"
#line 313 "lm-host.gob"
	g_return_if_fail (self != NULL);
#line 313 "lm-host.gob"
	g_return_if_fail (LM_IS_HOST (self));
#line 819 "lm-host.c"
{
#line 315 "lm-host.gob"
	
    GError *err = NULL;

    g_return_if_fail(selfp->addrinfo != NULL);

    if (lm_icmp_send_echo_request(selfp->sock, selfp->addrinfo, self->host_id, selfp->sent_seq, &err))
      {
	selfp->sent_seq++;
	self_set_status(self, LM_HOST_STATUS_RUNNING);

	if (! selfp->dead_timeout_id)
	  selfp->dead_timeout_id = g_timeout_add(self->applet->timeout, self_dead_timeout_cb, self);
      }
    else
      {
	self_set_error(self, _("unable to send echo request: %s"), err->message);
	g_error_free(err);
      }
  }}
#line 841 "lm-host.c"
#undef __GOB_FUNCTION__

#line 335 "lm-host.gob"
static void 
lm_host_install_send_timeout (LMHost * self)
#line 847 "lm-host.c"
{
#define __GOB_FUNCTION__ "LM:Host::install_send_timeout"
#line 335 "lm-host.gob"
	g_return_if_fail (self != NULL);
#line 335 "lm-host.gob"
	g_return_if_fail (LM_IS_HOST (self));
#line 854 "lm-host.c"
{
#line 337 "lm-host.gob"
	
    if (selfp->send_timeout_id)
      g_source_remove(selfp->send_timeout_id);
    selfp->send_timeout_id = g_timeout_add(self->applet->delay, self_send_timeout_cb, self);
  }}
#line 862 "lm-host.c"
#undef __GOB_FUNCTION__

#line 343 "lm-host.gob"
static gboolean 
lm_host_send_timeout_cb (gpointer data)
#line 868 "lm-host.c"
{
#define __GOB_FUNCTION__ "LM:Host::send_timeout_cb"
{
#line 345 "lm-host.gob"
	
    Self *self = data;

    GDK_THREADS_ENTER();

    if (selfp->addrinfo && selfp->sock && ! selfp->sock->init_error)
      self_send_echo_request(self);
    else
      self_set_alive(self, FALSE);

    GDK_THREADS_LEAVE();

    return TRUE;		/* keep source */
  }}
#line 887 "lm-host.c"
#undef __GOB_FUNCTION__

#line 360 "lm-host.gob"
static gboolean 
lm_host_dead_timeout_cb (gpointer data)
#line 893 "lm-host.c"
{
#define __GOB_FUNCTION__ "LM:Host::dead_timeout_cb"
{
#line 362 "lm-host.gob"
	
    Self *self = data;

    GDK_THREADS_ENTER();

    self_set_alive(self, FALSE);
    selfp->dead_timeout_id = 0;

    GDK_THREADS_LEAVE();

    return FALSE;		/* remove source */
  }}
#line 910 "lm-host.c"
#undef __GOB_FUNCTION__

#line 375 "lm-host.gob"
void 
lm_host_reply_received (LMHost * self, const LMICMPReply * reply)
#line 916 "lm-host.c"
{
#define __GOB_FUNCTION__ "LM:Host::reply_received"
#line 375 "lm-host.gob"
	g_return_if_fail (self != NULL);
#line 375 "lm-host.gob"
	g_return_if_fail (LM_IS_HOST (self));
#line 375 "lm-host.gob"
	g_return_if_fail (reply != NULL);
#line 925 "lm-host.c"
{
#line 377 "lm-host.gob"
	
    if (reply->seq <= selfp->received_seq && lm_tvcmp(&reply->received, &selfp->received_time, <=))
      return; /* older reply received out of order, ignore */

    selfp->received_seq = reply->seq;
    selfp->received_time = reply->received;

    if (lm_icmp_reply_is_echo_reply(reply, selfp->sock->domain))
      self_set_roundtrip_time(self, lm_icmp_reply_get_roundtrip_time(reply));
    else
      self_set_error(self, "%s", lm_icmp_reply_get_description(reply, selfp->sock->domain));
  }}
#line 940 "lm-host.c"
#undef __GOB_FUNCTION__
