
/*  This file is part of LingoTeach, the Language Teaching program 
 *  Copyright (C) 2001-2003 The LingoTeach Team
 *
 *  This program is free software; you can redistribute it and/or modify 
 *  it under the terms of the GNU General Public License as published by 
 *  the Free Software Foundation; either version 2 of the License, or 
 *  (at your option) any later version. 
 *
 *  This program is distributed in the hope that it will be useful, 
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the 
 *  GNU General Public License for more details. 
 * 
 *  You should have received a copy of the GNU General Public License 
 *  along with this program; if not, write to the Free Software 
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA. 
 */

#ifndef LING_UTIL_H
#define LING_UTIL_H 1

#include <gtk/gtk.h>
#include <lingoteach.h>

/* thanks for glade :-) */
#define GLADE_HOOKUP_OBJECT(component,widget,name) \
  g_object_set_data_full (G_OBJECT (component), name, \
    gtk_widget_ref (widget), (GDestroyNotify) gtk_widget_unref)

#define GLADE_HOOKUP_OBJECT_NO_REF(component,widget,name) \
  g_object_set_data (G_OBJECT (component), name, widget)

typedef void (*lingfunc)(gchar *);

GtkWidget*
util_lookup_widget (GtkWidget *widget, const gchar *widget_name);

GtkWidget*
util_create_dlg_fileselect (const gchar *title, lingfunc function);

GtkWidget*
util_get_menu (lingchar **menu_list, int entries);

gchar* 
util_get_menu_label (GtkOptionMenu *menu);

lingLesson*
util_return_lesson (lingLesson *lesson, Method type);

gboolean
util_check_settings (void);

void
util_on_btn_play_clicked (lingMeaning *meaning);

#endif /* LING_UTIL_H */
