/*  This file is part of LingoTeach, the Language Teaching program 
 *  Copyright (C) 2001-2003 The LingoTeach Team
 *
 *  This program is free software; you can redistribute it and/or modify 
 *  it under the terms of the GNU General Public License as published by 
 *  the Free Software Foundation; either version 2 of the License, or 
 *  (at your option) any later version. 
 *
 *  This program is distributed in the hope that it will be useful, 
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the 
 *  GNU General Public License for more details. 
 * 
 *  You should have received a copy of the GNU General Public License 
 *  along with this program; if not, write to the Free Software 
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA. 
 */

#ifndef LING_MODULE_H
#define LING_MODULE_H 1

#include <gtk/gtk.h>
#include <lingoteach.h>

#include "learningpref.h"

/*
 * load a dynamic module
 */
void
module_load (GtkListStore *list, char *filename);

/*
 * unloads (removes) a dynamic module
 */
lingbool
module_unload (gchar *name);

/*
 * gets the gtk stuff from the module and applies it to the box
 */
GtkWidget*
module_get_content (gchar *name);

GtkWidget*
module_get_info (gchar *name);

void
module_get_list (GtkListStore *list);

/* 
 * return the path of a module with the given name 
 */
gchar*
module_get_path (gchar *name);

#endif /* LING_MODULE_H */
