/* $Id: gtkprint.c,v 1.1 2005/05/12 07:31:19 marcusva Exp $
 *
 *  This file is part of LingoTeach, the Language Teaching program
 *  Copyright (C) 2004-2005 Marcus von Appen. All rights reserved.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include "../li18n.h"
#ifdef USE_PSLIB
#include "../print.h"
#endif
#include "hig-widgets.h"
#include "gtkdefs.h"
#include "gtkconfig.h"
#include "gtkprint.h"

extern lingGtkMainWindow *main_app;

/*
 * Creates the printing dialog in which the user can make the appropriate
 * adjustments for his document
 */
void
gtkprint_activate (void)
{
     GtkWidget *dlg_print;

     gint result = 0;

     dlg_print = gtk_dialog_new_with_buttons (_("Print"),
                                              GTK_WINDOW (main_app->window),
                                              GTK_DIALOG_MODAL |
                                              GTK_DIALOG_DESTROY_WITH_PARENT,
                                              GTK_STOCK_CANCEL,
                                              GTK_RESPONSE_CANCEL,
                                              GTK_STOCK_PRINT,
                                              GTK_RESPONSE_ACCEPT,
                                              NULL);
     gtk_dialog_set_has_separator (GTK_DIALOG (dlg_print), FALSE);
     gtk_container_set_border_width (GTK_CONTAINER (dlg_print), WIDGET_BORDER);
     gtk_window_set_resizable (GTK_WINDOW (dlg_print), FALSE);

     result = gtk_dialog_run (GTK_DIALOG (dlg_print));
     switch (result)
     {
     case GTK_RESPONSE_ACCEPT:
          /* print! */
          break;
          
     case GTK_RESPONSE_CANCEL:
     default:
          break;
     }
     gtk_widget_destroy (dlg_print);
     return;
}
