/* $Id: lingcombobox.c,v 1.2 2005/03/24 10:27:25 marcusva Exp $
 * Copyright (C) 2004-2005 Marcus von Appen <marcus@sysfault.org>
 * This code is based on the gtkgrid patch from
 * http://www.sicem.biz/personal/lgs/projects/gtkgrid/view_project
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */

#include <gtk/gtk.h>
#include "lingcombobox.h"

/* common */
static void ling_combo_box_cell_editable_init (GtkCellEditableIface *iface);
static void ling_combo_box_start_editing (GtkCellEditable *cell_editable,
                                          GdkEvent *event);

GType
ling_combo_box_get_type (void)
{
     static GType combo_box_type = 0;
     if (!combo_box_type)
     {
          static const GInterfaceInfo cell_editable_info =
               {
                    (GInterfaceInitFunc) ling_combo_box_cell_editable_init,
                    NULL, NULL 
               };
          
          combo_box_type = gtk_combo_box_get_type ();
          g_type_add_interface_static (combo_box_type,
                                       GTK_TYPE_CELL_EDITABLE,
                                       &cell_editable_info);
     }
     return combo_box_type;
}

static void
ling_combo_box_cell_editable_init (GtkCellEditableIface *iface)
{
     iface->start_editing = ling_combo_box_start_editing;
     return;
}

static void
ling_combo_box_start_editing (GtkCellEditable *cell_editable, GdkEvent *event)
{
     gtk_widget_grab_focus (GTK_WIDGET (GTK_BIN (cell_editable)->child));
     return;
}
