/* $Id: filter.c,v 1.7 2005/03/24 10:17:36 marcusva Exp $
 *
 *  This file is part of LingoTeach, the Language Teaching program
 *  Copyright (C) 2002-2005 Marcus von Appen. All rights reserved.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <libxml/xpath.h>

#include "../cfg.h"
#include "filter.h"

extern lingoteachSettings *preferences;

#define QUERY_KVOC "//e"
lingLesson*
kvoctrain_import (const char *filename, char *lang_from, char *lang_to)
{
     /* the first approach is pretty simple: select only entry elements
      * (e - entry of dictionary), then get the originals (o) and
      * translations (t):
      * <e ...>
      *   <o>original</o>
      *   <t>translation</t>
      * </e>
      */
     xmlDocPtr doc = NULL;
     xmlXPathContextPtr ctx = NULL;
     xmlXPathObjectPtr obj;
     xmlNodePtr node = NULL;
     xmlChar *text = NULL;
     int i = 0;
     int j = 0;

     lingMeaning *root = NULL;
     lingMeaning *meaning = NULL;
     lingLesson *lesson = NULL;

     xmlXPathInit ();
     doc = xmlParseFile (filename);
     if (!doc)
          return NULL;
     
     ctx = xmlXPathNewContext (doc);
     if (!ctx)
     {
          xmlFree (doc);
          return NULL;
     }

     obj = xmlXPathEvalExpression(QUERY_KVOC, ctx);
     if (!obj)
     {
          xmlXPathFreeContext (ctx);
          xmlFree (doc);
          return NULL;
     }

     for (i = 0, j = 1; i < obj->nodesetval->nodeNr; i++, j++)
     {
          if(obj->nodesetval->nodeTab[i]->type == XML_ELEMENT_NODE 
             && xmlStrcmp (obj->nodesetval->nodeTab[i]->name, "e") == 0)
          {
               /* great, we are at <e ..> now, check for its descendants! */

               /* first the <o> tag */
               node = obj->nodesetval->nodeTab[i]->children;
               text = xmlNodeGetContent (node);
               meaning = ling_meaning_new ();
               meaning->id = j;
               meaning->translation = text;
               meaning->language = xmlCharStrdup (lang_from);
               root = ling_meaning_add (root, meaning);

               /* now the <t> tag */
               node = obj->nodesetval->nodeTab[i]->children->next;
               text = xmlNodeGetContent (node);
               meaning = ling_meaning_new ();
               meaning->id = j;
               meaning->translation = text;
               meaning->language = xmlCharStrdup (lang_to);
               root = ling_meaning_add (root, meaning);
          }
     }
     lesson = ling_meaning_create_lesson (root, preferences->config,
                                          "KVoctrain import", NULL);
     if (!lesson)
          ling_meaning_free (root);

     xmlXPathFreeObject (obj);
     xmlXPathFreeContext (ctx);
     xmlFreeDoc (doc);
     return lesson;
}
