/* $Id: errors.c,v 1.4 2005/03/28 16:24:40 marcusva Exp $
 *
 *  This file is part of LingoTeach, the Language Teaching program
 *  Copyright (C) 2004-2005 Marcus von Appen. All rights reserved.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <stdio.h>
#include <stdarg.h>
#include <stdlib.h>

#include "li18n.h"
#include "errors.h"

static lingErrorCallback warning = NULL;
static lingErrorCallback critical = NULL;

void
error_connect_signal (ErrorType type, lingErrorCallback callback)
{
     switch (type)
     {
     case LING_ERR_CRITICAL:
          critical = callback;
          break;
     case LING_ERR_WARNING:
          warning = callback;
     }
     return;
}

void
error_warning_full (const char *information, const char *description,
                    const char *solution, char *file, int line)
{
     /* call the connected handler */
     if (warning)
          warning (information, description, solution, file, line);
     return;
}

void
error_critical_full (const char *information, const char *description,
                     const char *solution, char *file, int line)
{
     /* call the connected handler */
     if (critical)
          critical (information, description, solution, file, line);
     printf ("exiting....\n");
     exit (EXIT_FAILURE);
}

void
error_sigsegv (void)
{
     printf ("SIGSEGV detected, exiting...\n");
     exit (EXIT_FAILURE);
}

void
error_sigquit (void)
{
     printf ("SIGQUIT detected, exiting...\n");
     exit (EXIT_FAILURE);
}

#ifdef DEBUG
void
debug (const char *__restrict format, ...)
{
     va_list list;

     vfprintf (stdout, "DEBUG: ", NULL);
     va_start (list, format);
     vfprintf (stdout, format, list);
     va_end (list);
     return;
}
#endif /* DEBUG */
