#!/usr/bin/perl -w
#
# Simple script, takes uncompressed dict files listed in @dict and
# adds their translation to basic.xml. 
# IF HAND EDITS HAVE BEEN MADE SINCE LAST EXTRACTION, THEY WILL BE LOST!
# 
# (c) 2002 Reto Stamm
# You can use this code under GPL.

use strict;

my %trans = ("eng","english",
             "afr", "afrikaans",
             "deu", "german",
             "fra", "french",
             "hun", "hungarian",
             "iri", "gaelic",
             "ita", "italian",
             "lat", "latin",
             "nld", "dutch",
             "por", "portuguese",
             "rus", "russian",
             "scr", "serbo-croatian",
             "spa", "spanish",
             "swe", "swedish");

my @files;
push @files, "eng-afr.dict";
#push @files, "eng-deu.dict";
push @files, "eng-fra.dict";
push @files, "eng-hun.dict";
push @files, "eng-iri.dict";
push @files, "eng-ita.dict";
push @files, "eng-lat.dict";
push @files, "eng-nld.dict";
push @files, "eng-por.dict";
push @files, "eng-rus.dict";
push @files, "eng-scr.dict";
#push @files, "eng-spa.dict";
push @files, "eng-swe.dict";

#foreach my $file (`ls eng*.dict`) {
foreach my $file (@files) {
  my %eng;
  chomp  $file;
  my $from_l= $file;
  my $to_l= $file;
  $from_l =~ s/-.*//;
  $to_l   =~ s/.dict//;
  $to_l   =~ s/.*-//;
  print "Doing $from_l to $to_l\n";
  my $content = `cat $file`;
  my @chunks = split(/\n\n/, $content);
  foreach my $chunk (@chunks) {
    my ($from,@to) = split (/[\n,]/,$chunk);
    $from =~ s/\[[^\]]*\]//;
    $from =~ s/^ *//;
    $from =~ s/ *$//;
    my $to = $to[0 ];
      $to =~ s/\[[^\]]*\]//;
      $to =~ s/^ *//;
      $to =~ s/ *$//;
#      print "$from $to\n";
      $from =~ s/(.*)/\U$1/g;
        $eng{$from} = $to;
  }
  # update basic.xml
  open OUT, ">basic.xml.out";
  foreach my $line (`cat basic.xml`) {
    chomp $line;
    print OUT "$line\n";
    if ($line =~ /translation language=.english./) {
      my $word = $line;
      $word =~ s/^[^>]*>//;
      $word =~ s/<[^<]*$//;
      $word =~ s/(.*)/\U$1/g;
      #print "--$word--\n";
      if ($eng{$word}) {
        print OUT "  <translation language=\"$trans{$to_l}\">$eng{$word}</translation>\n"
      }
    }
  }
  close OUT;
  `mv basic.xml.out basic.xml`;
}
