#!/bin/sh

#
# Line6 Linux USB driver - 0.6
#
# Copyright (C) 2005, 2006 Markus Grabner (grabner@icg.tugraz.at)
#
#	This program is free software; you can redistribute it and/or
#	modify it under the terms of the GNU General Public License as
#	published by the Free Software Foundation, version 2.
#

# transfer data for all channels, effects, and amp setups from the PODxt Pro

SYSDIR=`line6_find_device.pl sysdir POD`
mkdir -p data

# channels:
for p in `seq -f "%03g" 0 127`; do
    echo $p > $SYSDIR/retrieve_channel
    name=`sed "s/ /_/g" $SYSDIR/name_buf`
    echo "dumping channel #$p: $name"
    cp $SYSDIR/dump_buf data/c${p}_${name}.pod
done

# effects setups:
for p in `seq -f "%03g" 0 63`; do
    echo $p > $SYSDIR/retrieve_effects_setup
    name=`sed "s/ /_/g" $SYSDIR/name_buf`
    echo "dumping effects setup #$p: $name"
    cp $SYSDIR/dump_buf data/e${p}_${name}.pod
done

# amp setups:
for p in `seq -f "%03g" 0 63`; do
    echo $p > $SYSDIR/retrieve_amp_setup
    name=`sed "s/ /_/g" $SYSDIR/name_buf`
    echo "dumping amp setup #$p: $name"
    cp $SYSDIR/dump_buf data/a${p}_${name}.pod
done
