/*
 * Line6 Linux USB driver - 0.7.4
 *
 * Copyright (C) 2004-2008 Markus Grabner (grabner@icg.tugraz.at)
 *
 *	This program is free software; you can redistribute it and/or
 *	modify it under the terms of the GNU General Public License as
 *	published by the Free Software Foundation, version 2.
 *
 */

#include "driver.h"

#include <sound/core.h>
#include <sound/initval.h>


static int line6_index[SNDRV_CARDS] = SNDRV_DEFAULT_IDX;
static char *line6_id[SNDRV_CARDS] = SNDRV_DEFAULT_STR;


/*
	Initialize the Line6 USB audio system.
*/
int line6_init_audio(struct usb_line6 *line6)
{
	static int dev = 0;
	struct snd_card *card;

	card = snd_card_new(line6_index[dev], line6_id[dev], THIS_MODULE, 0);

	if(card == NULL)
		return -ENOMEM;

	line6->card = card;

	strcpy(card->driver, DRIVER_NAME);
	strcpy(card->shortname, "Line6-USB");
	sprintf(card->longname, "Line6 %s at USB %s", line6->properties->name, line6->ifcdev->bus_id);  /* 80 chars - see asound.h */
	return 0;
}

/*
	Register the Line6 USB audio system.
*/
int line6_register_audio(struct usb_line6 *line6)
{
	int err;

	if((err = snd_card_register(line6->card)) < 0)
		return err;

	return 0;
}

/*
	Cleanup the Line6 USB audio system.
*/
void line6_cleanup_audio(struct usb_line6 *line6)
{
	struct snd_card *card = line6->card;

	if(card == 0)
		return;

	snd_card_disconnect(card);
	snd_card_free(card);
	line6->card = 0;
}
