/****************************************************************************
**
** $Id: lincvs.h,v 1.140 2004/05/03 14:52:39 hemer Exp $
**
** Copyright (C) 1999-2004 The LinCVS development team.
**    Tilo Riemer <riemer@lincvs.org>
**    Falk Brettschneider <gigafalk@yahoo.com>
**    Frank Hemer <frank@hemer.org>
**    Wim Delvaux <wim.delvaux@chello.be>
**    Jose Hernandez <joseh@tesco.net>
**    Helmut Koll <HelmutKoll@web.de>
**    Tom Mishima <tmishima@mail.at-m.or.jp>
**    Joerg Preiss <auba@auba.de>
**    Sven Trogisch <trogisch@iapp.de>
**
**
**----------------------------------------------------------------------------
**
**----------------------------------------------------------------------------
**
** LinCVS is available under two different licenses:
**
** If LinCVS is linked against the GPLed version of Qt 
** LinCVS is released under the terms of GPL also.
**
** If LinCVS is linked against a nonGPLed version of Qt 
** LinCVS is released under the terms of the 
** LinCVS License for non-Unix platforms (LLNU)
**
**
** LinCVS License for non-Unix platforms (LLNU):
**
** Redistribution and use in binary form, without modification, 
** are permitted provided that the following conditions are met:
**
** 1. Redistributions in binary form must reproduce the above copyright
**    notice, this list of conditions and the following disclaimer in the
**    documentation and/or other materials provided with the distribution.
** 2. It is not permitted to distribute the binary package under a name
**    different than LinCVS.
** 3. The name of the authors may not be used to endorse or promote
**    products derived from this software without specific prior written
**    permission.
** 4. The source code is the creative property of the authors.
**    Extensions and development under the terms of the Gnu Public License
**    are limited to the Unix platform. Any distribution or compilation of 
**    the source code against libraries licensed other than gpl requires 
**    the written permission of the authors.
**
**
** THIS SOFTWARE IS PROVIDED BY THE AUTHOR "AS IS" AND ANY EXPRESS OR 
** IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED 
** WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE 
** ARE DISCLAIMED. IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY 
** DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL 
** DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE 
** GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS 
** INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, 
** WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING 
** NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS 
** SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
**
**
**
** LinCVS License for Unix platforms:
**
** This program is free software; you can redistribute it and/or modify 
** it under the terms of the GNU General Public License as published by 
** the Free Software Foundation; either version 2 of the License, or 
** (at your  option) any later version.  This program is distributed in 
** the hope that it will be useful, but WITHOUT ANY WARRANTY; without 
** even the implied warranty of MERCHANTABILITY or FITNESS FOR A 
** PARTICULAR PURPOSE.
**
** See the GNU General Public License for more details.
**
** You should have received a copy of the GNU General Public License
** along with this program; if not, write to the Free Software Foundation,
** Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
**
*****************************************************************************/


#ifndef LINCVS_H_20010626
#define LINCVS_H_20010626

#include "config.h"

#include <qmenubar.h>
#include <qpopupmenu.h>
#include <qpixmap.h>
#include <qptrlist.h>

#include "globals.h"
#include "cvscontrol.h"
#include "cvstoolbar.h"
#include "CvsBuffer.h"
#include "CommitDialogImpl.h"

#include "CustomizeDialogImpl.h"
#include "StatusWidget.h"

class QTabWidget;
class QToolBar;
class QToolButton;
class QMultiLineEdit;
class QListViewItem;
class QListView;
class QPixMap;
class QString;
class QStringList;
class QDialog;
class QLabel;
class CvsDirListView;
class CvsIgnoreListView;
class NonCvsListView;
class CvsListView;
class Directory;
class ColorTabWidget;
class QSplitter;
class CPixmapTimer;

class ApplicationWindow: public CvsControl

/* class ApplicationWindow: private virtual CMainWindow, private virtual CvsControl  */

{
  Q_OBJECT

 public:
  ApplicationWindow( QString);
  ~ApplicationWindow();

  MenuItem *M_COMMIT;
  MenuItem *M_COMMITFILE;
  MenuItem *M_CUSTOMIZE;
  MenuItem *M_CUSTOMIZEFILE;
  MenuItem *M_DIFFSIDEBYSIDEFILE;
  MenuItem *M_DIFFTOCONSOLEFILE;
  MenuItem *M_DISABLEDIR;
  MenuItem *M_EDITFILE;
  MenuItem *M_EDITDIR;
  MenuItem *M_ENABLEDIR;
  MenuItem *M_EXPANDDIR;
  MenuItem *M_HISTORY;
  MenuItem *M_HISTORYFILE;
  MenuItem *M_LOGIN;
  MenuItem *M_LOGOUT;
  MenuItem *M_LOGTREEFILE;
  MenuItem *M_PROPERTIES;
  MenuItem *M_QUERYUPDATE;
  MenuItem *M_QUERYUPDATEFILE;
  MenuItem *M_RELEASE;
  MenuItem *M_RELEASEANDREMOVE;
  MenuItem *M_REMOVE;
  MenuItem *M_REMOVEFILE;
  MenuItem *M_REMOVEFROMWORKBENCH;
  MenuItem *M_RENAMEFILE;
  MenuItem *M_REREADDIR;
  MenuItem *M_SEPARATOR;
  MenuItem *M_SHOWEDITORS;
  MenuItem *M_SHOWEDITORSFILE;
  MenuItem *M_STATUS;
  MenuItem *M_STATUSFILE;
  MenuItem *M_TAG;
  MenuItem *M_TAGFILE;
  MenuItem *M_UNEDITDIR;
  MenuItem *M_UNEDITFILE;
  MenuItem *M_UPDATE;
  MenuItem *M_UPDATEFILE;
  MenuItem *M_UPDATEOTHER;
  MenuItem *M_UPDATEOTHERFILE;
  MenuItem *M_TEST;
  MenuItem *M_LOCKFILE;
  MenuItem *M_LOCKDIR;
  MenuItem *M_UNLOCKFILE;
  MenuItem *M_UNLOCKDIR;
  MenuItem *M_SHOWWATCHERSFILE;
  MenuItem *M_SHOWWATCHERSDIR;
  MenuItem *M_OPENFILE;
  MenuItem *M_BROWSEDIR;
  MenuItem *M_OPENSHELLDIR;
  MenuItem *M_UPDATEDIRBRANCHFILE;
  MenuItem *M_UPDATEDIRBRANCHDIR;
  MenuItem *M_REMOVELOCALOPTIONSFILE;
  MenuItem *M_REMOVELOCALOPTIONSDIR;
  MenuItem *M_EXPORTDIR;
  MenuItem *M_COLLAPSDIR;
  MenuItem *M_VIEWFILE;
  MenuItem *M_REPLACEFILE;
  MenuItem *M_REPLACEDIR;
  MenuItem *M_RESOLVE;
  MenuItem *M_DIFFTOCONSOLEDIR;
  MenuItem *M_ADVDIFFTOCONSOLEFILE;
  MenuItem *M_ADVDIFFTOCONSOLEDIR;
  MenuItem *M_QUERYUPDATEALL;
  MenuItem *M_REPLACEALLDIR;
  MenuItem *M_UPDATEALL;
  MenuItem *M_UPDATEVIRTUALDIR;
  MenuItem *M_REMOVEFROMDISK;
  MenuItem *M_REMOVEFROMREP;
  MenuItem *M_REMOVEFROMREPANDDISK;
  MenuItem *M_REMOVEFROMDISKDIR;
  MenuItem *M_REMOVEFROMREPANDDISKDIR;
  MenuItem *M_ADDFILE;
  MenuItem *M_ADDFOLDER;
  MenuItem *M_ADDASCIIFILE;
  MenuItem *M_ADDBINARYFILE;
  MenuItem *M_CREATENEWFILE;
  MenuItem *M_CREATENEWDIR;
  MenuItem *M_DELETENONCVSFROMDISKFILE;
  MenuItem *M_DELETEIGNOREFROMDISKFILE;
  MenuItem *M_ADDPROJECT;
  MenuItem *M_CHECKOUTPROJECT;
  MenuItem *M_IMPORTPROJECT;
  MenuItem *M_EXPORTPROJECT;
  MenuItem *M_EXITPROJECT;
  MenuItem *M_SETTINGSOPTIONS;
  MenuItem *M_PROFILESOPTIONS;
  MenuItem *M_KEYSHORTCUTSOPTIONS;
  MenuItem *M_AUTOREFRESHOPTIONS;
  MenuItem *M_REFRESHOPTIONS;
  MenuItem *M_HELP;
  MenuItem *M_ONLINEHELP;
  MenuItem *M_DEBUGLOGHELP;
  MenuItem *M_ABOUTHELP;
  MenuItem *M_ABOUTQTHELP;
  MenuItem *M_OPENFILEMAPPINGOPTIONS;
  MenuItem *M_VIEWFILEMAPPINGOPTIONS;
  MenuItem *M_RENAMEDIR;
  MenuItem *M_COPYFILE;
  MenuItem *M_PASTE;
  MenuItem *M_MERGEDIR;
  MenuItem *M_MERGEFILE;
  MenuItem *M_CREATEPATCHDIR;
  MenuItem *M_LOGTREEDIR;
  MenuItem *M_IMPORTVENDORDIR;
  MenuItem *M_RENAMENONCVSFILE;
  MenuItem *M_REMOVECVSBACKED;

  MenuItem *M_COPYOUTPUT;
  MenuItem *M_SELECTALLOUTPUT;
  MenuItem *M_TOGGLESHOWALLOUTPUT;

 public slots:

  void showFileMenu(bool show);
  void setDirMenu(bool show);
  virtual void setStatusText( const QString &, int ms=0);

  /** only for testing purpose, not for release */
  virtual void test();

 protected:

  void initMenuAndToolbar();
  void initComponents();
  void initDone();
  void customizeFileMapping(FileAppList&,QString);
  void blockGUI(bool,int=BLOCKALL);
  bool isGuiBlocked();

  QString getNamesOfSelectedFiles();
  QString getNamesOfSelectedFilesWithoutSelCheck();
  QString getNameOfFirstSelectedFile();
  void getNameAndRevOfFirstSelectedFile(QString *name, QString *rev);
  QString getRev(QString *);
  Directory* getSelectedDir();
  QStringList getSelectedFilesList();
  void checkInProgress(bool);

 protected slots:

  /** Project menu slots */
  virtual void slot_closeApp();
  virtual void slot_addProject();
  virtual void slot_dropProject(const QString);
  virtual void slot_checkOut();
  virtual void slot_import();
  virtual void slot_importVendor();
  virtual void slot_export();

  /** Dir menu slots */
  virtual void slot_tagDir();
  virtual void slot_tagFile();

  /** Options menu slots */
  virtual void slot_settings();
  virtual void slot_setFonts();
  virtual void slot_profiles();
  virtual void slot_customizeKeyShortcuts();
  virtual void slot_customizeOpenFileMapping();
  virtual void slot_customizeViewFileMapping();
  virtual void slot_toggleAutoUpdate();
  virtual void slot_refreshAll();

  /** Help menu slots */
  virtual void slot_about();
  virtual void slot_help();
  virtual void slot_aboutQt();
  /* 	virtual void slot_debug(); */
  /* 	virtual void slot_onlineHelp(); */

  void slot_renameLocalDir();
  void slot_renameNonCvsFile();
  void slot_createPatch();
  void slot_updateOtherRevisionDir();
  void slot_updateOtherRevisionFile();

  void slot_removeCvsBackedFiles();

  void showDirProperties();
  void resolveFile();
  void closeEvent( QCloseEvent *);
  void customizeDirPopupMenu();
  void customizeFilePopupMenu();
  void fillProjectMenu();
  void fillFileMenu(bool);
  void fillDirMenu(bool);
  void fillOptionsMenu();
  void fillHelpMenu();
  void fillOutputPopupMenu(int);

  void slot_copyFile();
  void slot_paste();

  void saveViewportPos(bool override=FALSE);
  void recoverViewportPos();

  void updateColor( int c);

  void showInfo(const QString&, const QString&);
  void showWarning(const QString&, const QString&);
  bool showYesNoQuestion(const QString&, const QString&);
  bool showOkCancelQuestion(const QString&, const QString&);

 private:

  /** menu entries, identified by an id */
  enum {
    MENU_PROJECT   = 0,
    MENU_DIR       = 1,
    MENU_FILE      = 2,
    MENU_OPTIONS   = 3,
    MENU_HELP      = 4
  };

  //main menus
  QPopupMenu *m_pProjectMenu;
  QPopupMenu *m_pDirMenu;
  QPopupMenu *m_pFileMenu;
  QPopupMenu *m_pOptionsMenu;
  QPopupMenu *m_pHelpMenu;

  //foreign menus
  QPopupMenu *m_pOutputMenu;
   
  //Settings
  void saveSettings();
  void writeSetup();

  //Customize PopupMenues
  void setMenuItemState(bool);
  int insertMenuItem(QPopupMenu*,MenuItem*);
  int insertMenuItem(QPopupMenu*,const MenuItem*, bool);
  QPopupMenu *dirPopupMenu;
  QPopupMenu *filePopupMenu;
  QVector<MenuItem> *dirPopupMenuItems;
  QVector<MenuItem> *filePopupMenuItems;
  QVector<MenuItem> *allDirPopupMenuItems;
  QVector<MenuItem> *allFilePopupMenuItems;
  bool isFilesAndDirsSelected();
  bool isDirsSelected();
  bool checkOnlyRemovedFilesSelected();
  bool checkOnlyVirtualDirFileItemsSelected();
  int selectCount(const int &);
   
  //MainWindow setup
  QSplitter *m_pHorzSplitter;
  QSplitter *m_pVertSplitter;
  StatusWidget * m_pProgressWidget;

  /** Auto-refresh mode flag */
  bool m_AutoRefreshEnabled;

  //set/reset ViewPort
  int m_lastHScrollBarValue;
  int m_lastVScrollBarValue;
  QStringList m_selectedList;
  QString m_selectedDir;

  //cut,copy,paste
  QStringList m_clipboardFileList;

  //status text
  QString m_statusMsg;

  //notifications
  void lockNotifications(bool);

 private slots:

  void refreshAllCvsEntries();
  void clipboardDataChanged();
  void statusMessageChanged( const QString &);
  void fillFilePopupMenu();
  void fillDirPopupMenu();
  void copyOutput();
  void selectAllOutput();
  void toggleShowAllOutput();
  void updateFileViews();
  void slot_stopStatusTimer();
  void slot_applyAutoUpdate();
};

//----------------------------------------------------------------------------

#endif   //LINCVS_H_20010626

