/****************************************************************************
**
** $Id: EditorsDialogImpl.cpp,v 1.13 2004/01/11 22:08:05 riemer Exp $
**
** Copyright (C) 2001-2004 The LinCVS development team.
**    Tilo Riemer <riemer@lincvs.org>
**    Falk Brettschneider <gigafalk@yahoo.com>
**    Frank Hemer <frank@hemer.org>
**    Wim Delvaux <wim.delvaux@chello.be>
**    Jose Hernandez <joseh@tesco.net>
**    Helmut Koll <HelmutKoll@web.de>
**    Tom Mishima <tmishima@mail.at-m.or.jp>
**    Joerg Preiss <auba@auba.de>
**    Sven Trogisch <trogisch@iapp.de>
**
**
**----------------------------------------------------------------------------
**
**----------------------------------------------------------------------------
**
** LinCVS is available under two different licenses:
**
** If LinCVS is linked against the GPLed version of Qt 
** LinCVS is released under the terms of GPL also.
**
** If LinCVS is linked against a nonGPLed version of Qt 
** LinCVS is released under the terms of the 
** LinCVS License for non-Unix platforms (LLNU)
**
**
** LinCVS License for non-Unix platforms (LLNU):
**
** Redistribution and use in binary form, without modification, 
** are permitted provided that the following conditions are met:
**
** 1. Redistributions in binary form must reproduce the above copyright
**    notice, this list of conditions and the following disclaimer in the
**    documentation and/or other materials provided with the distribution.
** 2. It is not permitted to distribute the binary package under a name
**    different than LinCVS.
** 3. The name of the authors may not be used to endorse or promote
**    products derived from this software without specific prior written
**    permission.
** 4. The source code is the creative property of the authors.
**    Extensions and development under the terms of the Gnu Public License
**    are limited to the Unix platform. Any distribution or compilation of 
**    the source code against libraries licensed other than gpl requires 
**    the written permission of the authors.
**
**
** THIS SOFTWARE IS PROVIDED BY THE AUTHOR "AS IS" AND ANY EXPRESS OR 
** IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED 
** WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE 
** ARE DISCLAIMED. IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY 
** DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL 
** DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE 
** GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS 
** INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, 
** WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING 
** NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS 
** SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
**
**
**
** LinCVS License for Unix platforms:
**
** This program is free software; you can redistribute it and/or modify 
** it under the terms of the GNU General Public License as published by 
** the Free Software Foundation; either version 2 of the License, or 
** (at your  option) any later version.  This program is distributed in 
** the hope that it will be useful, but WITHOUT ANY WARRANTY; without 
** even the implied warranty of MERCHANTABILITY or FITNESS FOR A 
** PARTICULAR PURPOSE.
**
** See the GNU General Public License for more details.
**
** You should have received a copy of the GNU General Public License
** along with this program; if not, write to the Free Software Foundation,
** Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
**
*****************************************************************************/


#include "config.h"

#include <qlistview.h>
#include <qstringlist.h>
#include <qpushbutton.h>
#include <qwhatsthis.h>

#include "globals.h"
#include "EditorsDialogImpl.h"
#include "FileListViewItem.h"


/* 
 *  Constructs a EditorsDialogImpl which is a child of 'parent', with the 
 *  name 'name' and widget flags set to 'f' 
 *
 *  The dialog will by default be modeless, unless you set 'modal' to
 *  TRUE to construct a modal dialog.
 */
EditorsDialogImpl::EditorsDialogImpl(const QIconSet &whatsThisIconSet,
				     QWidget* parent,  const char* name, 
				     bool modal, WFlags fl)
    : EditorsDialog( parent, name, modal, fl )
{
  m_pWhatsThis->setIconSet(whatsThisIconSet);
  m_pWhatsThis->setMaximumWidth(m_pWhatsThis->height());

  connect(EditorsList, SIGNAL(doubleClicked(QListViewItem *)), this, SLOT(viewFile(QListViewItem *)) );
}

/*  
 *  Destroys the object and frees any allocated resources
 */
EditorsDialogImpl::~EditorsDialogImpl()
{
    // no need to delete child widgets, Qt does it all for us
}

void EditorsDialogImpl::parseEditors ( CvsBuffer *output, QString)
{
  unsigned int len = (*output).numLines();
  QString line;

  int pos1;
  int pos2;
  QString file;
  QString user;
  QString date;
  QString client;
  QString localdir;
  int skiplines = outputLineOffset + 1;//skip first line

  for (unsigned int i = skiplines; i<len;i++) {
    line = (*output).textLine(i);
    if (line.isEmpty() || line.startsWith("?")) continue;

    pos1 = line.findRev('\t');
    localdir = line.mid(pos1+1);

    line.truncate(pos1);

    pos1 = line.findRev('\t');
    client = line.mid(pos1+1);

    line.truncate(pos1);

    pos1 = line.find('\t');
    if (pos1 > 0) {
	file = line.mid(0,pos1);
    }

    pos2 = line.find('\t',++pos1);
    user = line.mid(pos1,pos2-pos1);

    date = line.mid(pos2+1);
    date = date.left(date.findRev(" "));
    QDateTime dateTime = QDateTime::fromString(date);
    date = getAsLocal(dateTime,FALSE).toString(LookAndFeel::g_dateTimeFormat);

    FileListViewItem *item = new FileListViewItem (EditorsList);
    item->setText(0,file);
    item->setText(1,user);
    item->setDate(2,&dateTime,date);
    item->setText(3,client);
    item->setText(4,localdir);
  }
}


void EditorsDialogImpl::viewFile(QListViewItem *item) {

    if (item) {
	QString dir = item->text(6);
    }
}


void EditorsDialogImpl::enterWhatsThisMode()
{
   QWhatsThis::enterWhatsThisMode();
}
