#ifndef LFORTRAN_AST_H
#define LFORTRAN_AST_H

// Generated by grammar/asdl_cpp.py

#include <libasr/alloc.h>
#include <libasr/location.h>
#include <libasr/colors.h>
#include <libasr/containers.h>
#include <libasr/exception.h>
#include <libasr/asr_scopes.h>
#include <libasr/string_utils.h>


namespace LCompilers::LFortran::AST {

enum astType
{
    unit, mod, program_unit, unit_decl1, unit_decl2, interface_header, interface_item, import_statement, implicit_statement, implicit_none_spec, letter_spec, stmt, expr, trivia, trivia_node, procedure_decl, decl_attribute, event_attribute, team_attribute, bind, array_index, case_stmt, case_cond, rank_stmt, type_stmt, use_symbol, concurrent_control, concurrent_locality, data_stmt_set, unit_require
};

struct ast_t
{
    astType type;
    Location loc;
};


template <class T, class U>
inline bool is_a(const U &x)
{
    return T::class_type == x.type;
}

// Cast one level down

template <class T, class U>
static inline T* down_cast(const U *f)
{
    LCOMPILERS_ASSERT(f != nullptr);
    LCOMPILERS_ASSERT(is_a<T>(*f));
    return (T*)f;
}

// Cast two levels down

template <class T>
static inline T* down_cast2(const ast_t *f)
{
    typedef typename T::parent_type ptype;
    ptype *t = down_cast<ptype>(f);
    return down_cast<T>(t);
}

/******************************************************************************/
// Forward declarations

struct unit_t; // Sum
struct mod_t; // Sum
struct program_unit_t; // Sum
struct unit_decl1_t; // Sum
struct unit_decl2_t; // Sum
struct interface_header_t; // Sum
struct interface_item_t; // Sum
struct import_statement_t; // Sum
enum import_modifierType // Simple Sum
{ // Types
    ImportDefault, ImportOnly, ImportNone, ImportAll
};
struct implicit_statement_t; // Sum
struct implicit_none_spec_t; // Sum
struct letter_spec_t; // Sum
struct stmt_t; // Sum
struct expr_t; // Sum
struct trivia_t; // Sum
struct trivia_node_t; // Sum
enum boolopType // Simple Sum
{ // Types
    And, Or, Xor, Eqv, NEqv
};
enum operatorType // Simple Sum
{ // Types
    Add, Sub, Mul, Div, Pow
};
enum stroperatorType // Simple Sum
{ // Types
    Concat
};
enum unaryopType // Simple Sum
{ // Types
    Invert, Not, UAdd, USub
};
enum cmpopType // Simple Sum
{ // Types
    Eq, NotEq, Lt, LtE, Gt, GtE
};
enum intrinsicopType // Simple Sum
{ // Types
    AND, OR, XOR, EQV, NEQV, PLUS, MINUS, STAR, DIV, POW, NOT, EQ, NOTEQ, LT, LTE, GT, GTE, CONCAT
};
struct procedure_decl_t; // Sum
struct decl_attribute_t; // Sum
enum simple_attributeType // Simple Sum
{ // Types
    AttrAbstract, AttrAllocatable, AttrAsynchronous, AttrCommon, AttrContiguous, AttrDeferred, AttrElemental, AttrEnumerator, AttrExternal, AttrImpure, AttrIntrinsic, AttrKind, AttrLen, AttrModule, AttrNoPass, AttrNonDeferred, AttrNon_Intrinsic, AttrOptional, AttrParameter, AttrPointer, AttrPrivate, AttrProtected, AttrPublic, AttrPure, AttrRecursive, AttrSave, AttrSequence, AttrTarget, AttrValue, AttrVolatile
};
enum attr_intentType // Simple Sum
{ // Types
    In, Out, InOut
};
enum decl_typeType // Simple Sum
{ // Types
    TypeClass, TypeCharacter, TypeComplex, TypeDoublePrecision, TypeDoubleComplex, TypeInteger, TypeLogical, TypeProcedure, TypeReal, TypeType
};
struct event_attribute_t; // Sum
struct team_attribute_t; // Sum
struct var_sym_t; // Product
struct kind_item_t; // Product
enum kind_item_typeType // Simple Sum
{ // Types
    Star, Colon, Value
};
struct dimension_t; // Product
enum dimension_typeType // Simple Sum
{ // Types
    DimensionExpr, DimensionStar, AssumedRank
};
struct codimension_t; // Product
enum codimension_typeType // Simple Sum
{ // Types
    CodimensionExpr, CodimensionStar
};
enum symbolType // Simple Sum
{ // Types
    None, Arrow, Equal, Asterisk, DoubleAsterisk, Slash
};
struct equi_t; // Product
struct kw_argstar_t; // Product
struct argstar_t; // Product
struct arg_t; // Product
struct fnarg_t; // Product
struct coarrayarg_t; // Product
struct keyword_t; // Product
struct struct_member_t; // Product
struct bind_t; // Sum
struct array_index_t; // Sum
struct case_stmt_t; // Sum
struct case_cond_t; // Sum
struct rank_stmt_t; // Sum
struct type_stmt_t; // Sum
struct use_symbol_t; // Sum
struct concurrent_control_t; // Sum
struct concurrent_locality_t; // Sum
enum reduce_opType // Simple Sum
{ // Types
    ReduceAdd, ReduceMul, ReduceMIN, ReduceMAX
};
struct data_stmt_set_t; // Sum
enum pragma_typeType // Simple Sum
{ // Types
    LFortranPragma, OMPPragma
};
struct unit_require_t; // Sum


/******************************************************************************/
// Products declarations

struct var_sym_t // Product
{
    Location loc;
    char* m_name;
    dimension_t* m_dim; size_t n_dim; // Sequence
    codimension_t* m_codim; size_t n_codim; // Sequence
    expr_t* m_length;
    expr_t* m_initializer;
    symbolType m_sym;
    decl_attribute_t* m_spec;
};
struct kind_item_t // Product
{
    Location loc;
    char* m_id;
    expr_t* m_value;
    kind_item_typeType m_type;
};
struct dimension_t // Product
{
    Location loc;
    expr_t* m_start;
    expr_t* m_end;
    dimension_typeType m_end_star;
};
struct codimension_t // Product
{
    Location loc;
    expr_t* m_start;
    expr_t* m_end;
    codimension_typeType m_end_star;
};
struct equi_t // Product
{
    Location loc;
    expr_t** m_set_list; size_t n_set_list; // Sequence
};
struct kw_argstar_t // Product
{
    Location loc;
    char* m_arg;
    expr_t* m_value;
};
struct argstar_t // Product
{
    Location loc;
    expr_t* m_value;
};
struct arg_t // Product
{
    Location loc;
    char* m_arg;
};
struct fnarg_t // Product
{
    Location loc;
    expr_t* m_start;
    expr_t* m_end;
    expr_t* m_step;
    int64_t m_label;
};
struct coarrayarg_t // Product
{
    Location loc;
    expr_t* m_start;
    expr_t* m_end;
    expr_t* m_step;
    codimension_typeType m_star;
};
struct keyword_t // Product
{
    Location loc;
    char* m_arg;
    expr_t* m_value;
};
struct struct_member_t // Product
{
    Location loc;
    char* m_name;
    fnarg_t* m_args; size_t n_args; // Sequence
};


/******************************************************************************/
// Sums declarations

enum unitType // Types
{
    TranslationUnit
};

struct unit_t // Sum
{
    const static astType class_type = astType::unit;
    ast_t base;
    unitType type;
};

    struct TranslationUnit_t // Constructor
    {
        const static unitType class_type = unitType::TranslationUnit;
        typedef unit_t parent_type;
        unit_t base;
        ast_t** m_items; size_t n_items; // Sequence
    };
    static inline ast_t* make_TranslationUnit_t(Allocator &al, const Location &a_loc, ast_t** a_items, size_t n_items) {
        TranslationUnit_t *n;
        n = al.make_new<TranslationUnit_t>();
        n->base.type = unitType::TranslationUnit;
        n->base.base.type = astType::unit;
        n->base.base.loc = a_loc;
        n->m_items = a_items;
        n->n_items = n_items;
        return (ast_t*)n;
    }



enum modType // Types
{
    Module, Submodule, BlockData, Program
};

struct mod_t // Sum
{
    const static astType class_type = astType::mod;
    ast_t base;
    modType type;
};

    struct Module_t // Constructor
    {
        const static modType class_type = modType::Module;
        typedef mod_t parent_type;
        mod_t base;
        char* m_name;
        trivia_t* m_trivia;
        unit_decl1_t** m_use; size_t n_use; // Sequence
        implicit_statement_t** m_implicit; size_t n_implicit; // Sequence
        unit_decl2_t** m_decl; size_t n_decl; // Sequence
        program_unit_t** m_contains; size_t n_contains; // Sequence
    };
    static inline ast_t* make_Module_t(Allocator &al, const Location &a_loc, char* a_name, trivia_t* a_trivia, unit_decl1_t** a_use, size_t n_use, implicit_statement_t** a_implicit, size_t n_implicit, unit_decl2_t** a_decl, size_t n_decl, program_unit_t** a_contains, size_t n_contains) {
        Module_t *n;
        n = al.make_new<Module_t>();
        n->base.type = modType::Module;
        n->base.base.type = astType::mod;
        n->base.base.loc = a_loc;
        n->m_name = a_name;
        n->m_trivia = a_trivia;
        n->m_use = a_use;
        n->n_use = n_use;
        n->m_implicit = a_implicit;
        n->n_implicit = n_implicit;
        n->m_decl = a_decl;
        n->n_decl = n_decl;
        n->m_contains = a_contains;
        n->n_contains = n_contains;
        return (ast_t*)n;
    }

    struct Submodule_t // Constructor
    {
        const static modType class_type = modType::Submodule;
        typedef mod_t parent_type;
        mod_t base;
        char* m_id;
        char* m_parent_name;
        char* m_name;
        trivia_t* m_trivia;
        unit_decl1_t** m_use; size_t n_use; // Sequence
        implicit_statement_t** m_implicit; size_t n_implicit; // Sequence
        unit_decl2_t** m_decl; size_t n_decl; // Sequence
        program_unit_t** m_contains; size_t n_contains; // Sequence
    };
    static inline ast_t* make_Submodule_t(Allocator &al, const Location &a_loc, char* a_id, char* a_parent_name, char* a_name, trivia_t* a_trivia, unit_decl1_t** a_use, size_t n_use, implicit_statement_t** a_implicit, size_t n_implicit, unit_decl2_t** a_decl, size_t n_decl, program_unit_t** a_contains, size_t n_contains) {
        Submodule_t *n;
        n = al.make_new<Submodule_t>();
        n->base.type = modType::Submodule;
        n->base.base.type = astType::mod;
        n->base.base.loc = a_loc;
        n->m_id = a_id;
        n->m_parent_name = a_parent_name;
        n->m_name = a_name;
        n->m_trivia = a_trivia;
        n->m_use = a_use;
        n->n_use = n_use;
        n->m_implicit = a_implicit;
        n->n_implicit = n_implicit;
        n->m_decl = a_decl;
        n->n_decl = n_decl;
        n->m_contains = a_contains;
        n->n_contains = n_contains;
        return (ast_t*)n;
    }

    struct BlockData_t // Constructor
    {
        const static modType class_type = modType::BlockData;
        typedef mod_t parent_type;
        mod_t base;
        char* m_name;
        trivia_t* m_trivia;
        unit_decl1_t** m_use; size_t n_use; // Sequence
        implicit_statement_t** m_implicit; size_t n_implicit; // Sequence
        unit_decl2_t** m_decl; size_t n_decl; // Sequence
        stmt_t** m_body; size_t n_body; // Sequence
    };
    static inline ast_t* make_BlockData_t(Allocator &al, const Location &a_loc, char* a_name, trivia_t* a_trivia, unit_decl1_t** a_use, size_t n_use, implicit_statement_t** a_implicit, size_t n_implicit, unit_decl2_t** a_decl, size_t n_decl, stmt_t** a_body, size_t n_body) {
        BlockData_t *n;
        n = al.make_new<BlockData_t>();
        n->base.type = modType::BlockData;
        n->base.base.type = astType::mod;
        n->base.base.loc = a_loc;
        n->m_name = a_name;
        n->m_trivia = a_trivia;
        n->m_use = a_use;
        n->n_use = n_use;
        n->m_implicit = a_implicit;
        n->n_implicit = n_implicit;
        n->m_decl = a_decl;
        n->n_decl = n_decl;
        n->m_body = a_body;
        n->n_body = n_body;
        return (ast_t*)n;
    }

    struct Program_t // Constructor
    {
        const static modType class_type = modType::Program;
        typedef mod_t parent_type;
        mod_t base;
        char* m_name;
        trivia_t* m_trivia;
        unit_decl1_t** m_use; size_t n_use; // Sequence
        implicit_statement_t** m_implicit; size_t n_implicit; // Sequence
        unit_decl2_t** m_decl; size_t n_decl; // Sequence
        stmt_t** m_body; size_t n_body; // Sequence
        program_unit_t** m_contains; size_t n_contains; // Sequence
    };
    static inline ast_t* make_Program_t(Allocator &al, const Location &a_loc, char* a_name, trivia_t* a_trivia, unit_decl1_t** a_use, size_t n_use, implicit_statement_t** a_implicit, size_t n_implicit, unit_decl2_t** a_decl, size_t n_decl, stmt_t** a_body, size_t n_body, program_unit_t** a_contains, size_t n_contains) {
        Program_t *n;
        n = al.make_new<Program_t>();
        n->base.type = modType::Program;
        n->base.base.type = astType::mod;
        n->base.base.loc = a_loc;
        n->m_name = a_name;
        n->m_trivia = a_trivia;
        n->m_use = a_use;
        n->n_use = n_use;
        n->m_implicit = a_implicit;
        n->n_implicit = n_implicit;
        n->m_decl = a_decl;
        n->n_decl = n_decl;
        n->m_body = a_body;
        n->n_body = n_body;
        n->m_contains = a_contains;
        n->n_contains = n_contains;
        return (ast_t*)n;
    }



enum program_unitType // Types
{
    Subroutine, Procedure, Function
};

struct program_unit_t // Sum
{
    const static astType class_type = astType::program_unit;
    ast_t base;
    program_unitType type;
};

    struct Subroutine_t // Constructor
    {
        const static program_unitType class_type = program_unitType::Subroutine;
        typedef program_unit_t parent_type;
        program_unit_t base;
        char* m_name;
        arg_t* m_args; size_t n_args; // Sequence
        decl_attribute_t** m_attributes; size_t n_attributes; // Sequence
        bind_t* m_bind;
        trivia_t* m_trivia;
        unit_decl1_t** m_use; size_t n_use; // Sequence
        import_statement_t** m_import; size_t n_import; // Sequence
        implicit_statement_t** m_implicit; size_t n_implicit; // Sequence
        unit_decl2_t** m_decl; size_t n_decl; // Sequence
        stmt_t** m_body; size_t n_body; // Sequence
        program_unit_t** m_contains; size_t n_contains; // Sequence
        char** m_temp_args; size_t n_temp_args; // Sequence
    };
    static inline ast_t* make_Subroutine_t(Allocator &al, const Location &a_loc, char* a_name, arg_t* a_args, size_t n_args, decl_attribute_t** a_attributes, size_t n_attributes, bind_t* a_bind, trivia_t* a_trivia, unit_decl1_t** a_use, size_t n_use, import_statement_t** a_import, size_t n_import, implicit_statement_t** a_implicit, size_t n_implicit, unit_decl2_t** a_decl, size_t n_decl, stmt_t** a_body, size_t n_body, program_unit_t** a_contains, size_t n_contains, char** a_temp_args, size_t n_temp_args) {
        Subroutine_t *n;
        n = al.make_new<Subroutine_t>();
        n->base.type = program_unitType::Subroutine;
        n->base.base.type = astType::program_unit;
        n->base.base.loc = a_loc;
        n->m_name = a_name;
        n->m_args = a_args;
        n->n_args = n_args;
        n->m_attributes = a_attributes;
        n->n_attributes = n_attributes;
        n->m_bind = a_bind;
        n->m_trivia = a_trivia;
        n->m_use = a_use;
        n->n_use = n_use;
        n->m_import = a_import;
        n->n_import = n_import;
        n->m_implicit = a_implicit;
        n->n_implicit = n_implicit;
        n->m_decl = a_decl;
        n->n_decl = n_decl;
        n->m_body = a_body;
        n->n_body = n_body;
        n->m_contains = a_contains;
        n->n_contains = n_contains;
        n->m_temp_args = a_temp_args;
        n->n_temp_args = n_temp_args;
        return (ast_t*)n;
    }

    struct Procedure_t // Constructor
    {
        const static program_unitType class_type = program_unitType::Procedure;
        typedef program_unit_t parent_type;
        program_unit_t base;
        char* m_name;
        arg_t* m_args; size_t n_args; // Sequence
        decl_attribute_t** m_attributes; size_t n_attributes; // Sequence
        trivia_t* m_trivia;
        unit_decl1_t** m_use; size_t n_use; // Sequence
        import_statement_t** m_import; size_t n_import; // Sequence
        implicit_statement_t** m_implicit; size_t n_implicit; // Sequence
        unit_decl2_t** m_decl; size_t n_decl; // Sequence
        stmt_t** m_body; size_t n_body; // Sequence
        program_unit_t** m_contains; size_t n_contains; // Sequence
    };
    static inline ast_t* make_Procedure_t(Allocator &al, const Location &a_loc, char* a_name, arg_t* a_args, size_t n_args, decl_attribute_t** a_attributes, size_t n_attributes, trivia_t* a_trivia, unit_decl1_t** a_use, size_t n_use, import_statement_t** a_import, size_t n_import, implicit_statement_t** a_implicit, size_t n_implicit, unit_decl2_t** a_decl, size_t n_decl, stmt_t** a_body, size_t n_body, program_unit_t** a_contains, size_t n_contains) {
        Procedure_t *n;
        n = al.make_new<Procedure_t>();
        n->base.type = program_unitType::Procedure;
        n->base.base.type = astType::program_unit;
        n->base.base.loc = a_loc;
        n->m_name = a_name;
        n->m_args = a_args;
        n->n_args = n_args;
        n->m_attributes = a_attributes;
        n->n_attributes = n_attributes;
        n->m_trivia = a_trivia;
        n->m_use = a_use;
        n->n_use = n_use;
        n->m_import = a_import;
        n->n_import = n_import;
        n->m_implicit = a_implicit;
        n->n_implicit = n_implicit;
        n->m_decl = a_decl;
        n->n_decl = n_decl;
        n->m_body = a_body;
        n->n_body = n_body;
        n->m_contains = a_contains;
        n->n_contains = n_contains;
        return (ast_t*)n;
    }

    struct Function_t // Constructor
    {
        const static program_unitType class_type = program_unitType::Function;
        typedef program_unit_t parent_type;
        program_unit_t base;
        char* m_name;
        arg_t* m_args; size_t n_args; // Sequence
        decl_attribute_t** m_attributes; size_t n_attributes; // Sequence
        expr_t* m_return_var;
        bind_t* m_bind;
        trivia_t* m_trivia;
        unit_decl1_t** m_use; size_t n_use; // Sequence
        import_statement_t** m_import; size_t n_import; // Sequence
        implicit_statement_t** m_implicit; size_t n_implicit; // Sequence
        unit_decl2_t** m_decl; size_t n_decl; // Sequence
        stmt_t** m_body; size_t n_body; // Sequence
        program_unit_t** m_contains; size_t n_contains; // Sequence
        char** m_temp_args; size_t n_temp_args; // Sequence
    };
    static inline ast_t* make_Function_t(Allocator &al, const Location &a_loc, char* a_name, arg_t* a_args, size_t n_args, decl_attribute_t** a_attributes, size_t n_attributes, expr_t* a_return_var, bind_t* a_bind, trivia_t* a_trivia, unit_decl1_t** a_use, size_t n_use, import_statement_t** a_import, size_t n_import, implicit_statement_t** a_implicit, size_t n_implicit, unit_decl2_t** a_decl, size_t n_decl, stmt_t** a_body, size_t n_body, program_unit_t** a_contains, size_t n_contains, char** a_temp_args, size_t n_temp_args) {
        Function_t *n;
        n = al.make_new<Function_t>();
        n->base.type = program_unitType::Function;
        n->base.base.type = astType::program_unit;
        n->base.base.loc = a_loc;
        n->m_name = a_name;
        n->m_args = a_args;
        n->n_args = n_args;
        n->m_attributes = a_attributes;
        n->n_attributes = n_attributes;
        n->m_return_var = a_return_var;
        n->m_bind = a_bind;
        n->m_trivia = a_trivia;
        n->m_use = a_use;
        n->n_use = n_use;
        n->m_import = a_import;
        n->n_import = n_import;
        n->m_implicit = a_implicit;
        n->n_implicit = n_implicit;
        n->m_decl = a_decl;
        n->n_decl = n_decl;
        n->m_body = a_body;
        n->n_body = n_body;
        n->m_contains = a_contains;
        n->n_contains = n_contains;
        n->m_temp_args = a_temp_args;
        n->n_temp_args = n_temp_args;
        return (ast_t*)n;
    }



enum unit_decl1Type // Types
{
    Use
};

struct unit_decl1_t // Sum
{
    const static astType class_type = astType::unit_decl1;
    ast_t base;
    unit_decl1Type type;
};

    struct Use_t // Constructor
    {
        const static unit_decl1Type class_type = unit_decl1Type::Use;
        typedef unit_decl1_t parent_type;
        unit_decl1_t base;
        decl_attribute_t** m_nature; size_t n_nature; // Sequence
        char* m_module;
        use_symbol_t** m_symbols; size_t n_symbols; // Sequence
        bool m_only_present;
        trivia_t* m_trivia;
    };
    static inline ast_t* make_Use_t(Allocator &al, const Location &a_loc, decl_attribute_t** a_nature, size_t n_nature, char* a_module, use_symbol_t** a_symbols, size_t n_symbols, bool a_only_present, trivia_t* a_trivia) {
        Use_t *n;
        n = al.make_new<Use_t>();
        n->base.type = unit_decl1Type::Use;
        n->base.base.type = astType::unit_decl1;
        n->base.base.loc = a_loc;
        n->m_nature = a_nature;
        n->n_nature = n_nature;
        n->m_module = a_module;
        n->m_symbols = a_symbols;
        n->n_symbols = n_symbols;
        n->m_only_present = a_only_present;
        n->m_trivia = a_trivia;
        return (ast_t*)n;
    }



enum unit_decl2Type // Types
{
    Declaration, DeclarationPragma, Interface, DerivedType, Template, Enum, Instantiate, Requirement, Require
};

struct unit_decl2_t // Sum
{
    const static astType class_type = astType::unit_decl2;
    ast_t base;
    unit_decl2Type type;
};

    struct Declaration_t // Constructor
    {
        const static unit_decl2Type class_type = unit_decl2Type::Declaration;
        typedef unit_decl2_t parent_type;
        unit_decl2_t base;
        decl_attribute_t* m_vartype;
        decl_attribute_t** m_attributes; size_t n_attributes; // Sequence
        var_sym_t* m_syms; size_t n_syms; // Sequence
        trivia_t* m_trivia;
    };
    static inline ast_t* make_Declaration_t(Allocator &al, const Location &a_loc, decl_attribute_t* a_vartype, decl_attribute_t** a_attributes, size_t n_attributes, var_sym_t* a_syms, size_t n_syms, trivia_t* a_trivia) {
        Declaration_t *n;
        n = al.make_new<Declaration_t>();
        n->base.type = unit_decl2Type::Declaration;
        n->base.base.type = astType::unit_decl2;
        n->base.base.loc = a_loc;
        n->m_vartype = a_vartype;
        n->m_attributes = a_attributes;
        n->n_attributes = n_attributes;
        n->m_syms = a_syms;
        n->n_syms = n_syms;
        n->m_trivia = a_trivia;
        return (ast_t*)n;
    }

    struct DeclarationPragma_t // Constructor
    {
        const static unit_decl2Type class_type = unit_decl2Type::DeclarationPragma;
        typedef unit_decl2_t parent_type;
        unit_decl2_t base;
        pragma_typeType m_type;
        char* m_text;
        trivia_t* m_trivia;
    };
    static inline ast_t* make_DeclarationPragma_t(Allocator &al, const Location &a_loc, pragma_typeType a_type, char* a_text, trivia_t* a_trivia) {
        DeclarationPragma_t *n;
        n = al.make_new<DeclarationPragma_t>();
        n->base.type = unit_decl2Type::DeclarationPragma;
        n->base.base.type = astType::unit_decl2;
        n->base.base.loc = a_loc;
        n->m_type = a_type;
        n->m_text = a_text;
        n->m_trivia = a_trivia;
        return (ast_t*)n;
    }

    struct Interface_t // Constructor
    {
        const static unit_decl2Type class_type = unit_decl2Type::Interface;
        typedef unit_decl2_t parent_type;
        unit_decl2_t base;
        interface_header_t* m_header;
        trivia_t* m_trivia;
        interface_item_t** m_items; size_t n_items; // Sequence
    };
    static inline ast_t* make_Interface_t(Allocator &al, const Location &a_loc, interface_header_t* a_header, trivia_t* a_trivia, interface_item_t** a_items, size_t n_items) {
        Interface_t *n;
        n = al.make_new<Interface_t>();
        n->base.type = unit_decl2Type::Interface;
        n->base.base.type = astType::unit_decl2;
        n->base.base.loc = a_loc;
        n->m_header = a_header;
        n->m_trivia = a_trivia;
        n->m_items = a_items;
        n->n_items = n_items;
        return (ast_t*)n;
    }

    struct DerivedType_t // Constructor
    {
        const static unit_decl2Type class_type = unit_decl2Type::DerivedType;
        typedef unit_decl2_t parent_type;
        unit_decl2_t base;
        char* m_name;
        char** m_namelist; size_t n_namelist; // Sequence
        trivia_t* m_trivia;
        decl_attribute_t** m_attrtype; size_t n_attrtype; // Sequence
        unit_decl2_t** m_items; size_t n_items; // Sequence
        procedure_decl_t** m_contains; size_t n_contains; // Sequence
    };
    static inline ast_t* make_DerivedType_t(Allocator &al, const Location &a_loc, char* a_name, char** a_namelist, size_t n_namelist, trivia_t* a_trivia, decl_attribute_t** a_attrtype, size_t n_attrtype, unit_decl2_t** a_items, size_t n_items, procedure_decl_t** a_contains, size_t n_contains) {
        DerivedType_t *n;
        n = al.make_new<DerivedType_t>();
        n->base.type = unit_decl2Type::DerivedType;
        n->base.base.type = astType::unit_decl2;
        n->base.base.loc = a_loc;
        n->m_name = a_name;
        n->m_namelist = a_namelist;
        n->n_namelist = n_namelist;
        n->m_trivia = a_trivia;
        n->m_attrtype = a_attrtype;
        n->n_attrtype = n_attrtype;
        n->m_items = a_items;
        n->n_items = n_items;
        n->m_contains = a_contains;
        n->n_contains = n_contains;
        return (ast_t*)n;
    }

    struct Template_t // Constructor
    {
        const static unit_decl2Type class_type = unit_decl2Type::Template;
        typedef unit_decl2_t parent_type;
        unit_decl2_t base;
        char* m_name;
        char** m_namelist; size_t n_namelist; // Sequence
        unit_decl2_t** m_decl; size_t n_decl; // Sequence
        program_unit_t** m_contains; size_t n_contains; // Sequence
    };
    static inline ast_t* make_Template_t(Allocator &al, const Location &a_loc, char* a_name, char** a_namelist, size_t n_namelist, unit_decl2_t** a_decl, size_t n_decl, program_unit_t** a_contains, size_t n_contains) {
        Template_t *n;
        n = al.make_new<Template_t>();
        n->base.type = unit_decl2Type::Template;
        n->base.base.type = astType::unit_decl2;
        n->base.base.loc = a_loc;
        n->m_name = a_name;
        n->m_namelist = a_namelist;
        n->n_namelist = n_namelist;
        n->m_decl = a_decl;
        n->n_decl = n_decl;
        n->m_contains = a_contains;
        n->n_contains = n_contains;
        return (ast_t*)n;
    }

    struct Enum_t // Constructor
    {
        const static unit_decl2Type class_type = unit_decl2Type::Enum;
        typedef unit_decl2_t parent_type;
        unit_decl2_t base;
        decl_attribute_t** m_attr; size_t n_attr; // Sequence
        trivia_t* m_trivia;
        unit_decl2_t** m_items; size_t n_items; // Sequence
    };
    static inline ast_t* make_Enum_t(Allocator &al, const Location &a_loc, decl_attribute_t** a_attr, size_t n_attr, trivia_t* a_trivia, unit_decl2_t** a_items, size_t n_items) {
        Enum_t *n;
        n = al.make_new<Enum_t>();
        n->base.type = unit_decl2Type::Enum;
        n->base.base.type = astType::unit_decl2;
        n->base.base.loc = a_loc;
        n->m_attr = a_attr;
        n->n_attr = n_attr;
        n->m_trivia = a_trivia;
        n->m_items = a_items;
        n->n_items = n_items;
        return (ast_t*)n;
    }

    struct Instantiate_t // Constructor
    {
        const static unit_decl2Type class_type = unit_decl2Type::Instantiate;
        typedef unit_decl2_t parent_type;
        unit_decl2_t base;
        char* m_name;
        decl_attribute_t** m_args; size_t n_args; // Sequence
        use_symbol_t** m_symbols; size_t n_symbols; // Sequence
    };
    static inline ast_t* make_Instantiate_t(Allocator &al, const Location &a_loc, char* a_name, decl_attribute_t** a_args, size_t n_args, use_symbol_t** a_symbols, size_t n_symbols) {
        Instantiate_t *n;
        n = al.make_new<Instantiate_t>();
        n->base.type = unit_decl2Type::Instantiate;
        n->base.base.type = astType::unit_decl2;
        n->base.base.loc = a_loc;
        n->m_name = a_name;
        n->m_args = a_args;
        n->n_args = n_args;
        n->m_symbols = a_symbols;
        n->n_symbols = n_symbols;
        return (ast_t*)n;
    }

    struct Requirement_t // Constructor
    {
        const static unit_decl2Type class_type = unit_decl2Type::Requirement;
        typedef unit_decl2_t parent_type;
        unit_decl2_t base;
        char* m_name;
        char** m_namelist; size_t n_namelist; // Sequence
        unit_decl2_t** m_decl; size_t n_decl; // Sequence
        program_unit_t** m_funcs; size_t n_funcs; // Sequence
    };
    static inline ast_t* make_Requirement_t(Allocator &al, const Location &a_loc, char* a_name, char** a_namelist, size_t n_namelist, unit_decl2_t** a_decl, size_t n_decl, program_unit_t** a_funcs, size_t n_funcs) {
        Requirement_t *n;
        n = al.make_new<Requirement_t>();
        n->base.type = unit_decl2Type::Requirement;
        n->base.base.type = astType::unit_decl2;
        n->base.base.loc = a_loc;
        n->m_name = a_name;
        n->m_namelist = a_namelist;
        n->n_namelist = n_namelist;
        n->m_decl = a_decl;
        n->n_decl = n_decl;
        n->m_funcs = a_funcs;
        n->n_funcs = n_funcs;
        return (ast_t*)n;
    }

    struct Require_t // Constructor
    {
        const static unit_decl2Type class_type = unit_decl2Type::Require;
        typedef unit_decl2_t parent_type;
        unit_decl2_t base;
        unit_require_t** m_reqs; size_t n_reqs; // Sequence
    };
    static inline ast_t* make_Require_t(Allocator &al, const Location &a_loc, unit_require_t** a_reqs, size_t n_reqs) {
        Require_t *n;
        n = al.make_new<Require_t>();
        n->base.type = unit_decl2Type::Require;
        n->base.base.type = astType::unit_decl2;
        n->base.base.loc = a_loc;
        n->m_reqs = a_reqs;
        n->n_reqs = n_reqs;
        return (ast_t*)n;
    }



enum interface_headerType // Types
{
    InterfaceHeader, InterfaceHeaderName, InterfaceHeaderAssignment, InterfaceHeaderOperator, InterfaceHeaderDefinedOperator, AbstractInterfaceHeader, InterfaceHeaderWrite, InterfaceHeaderRead
};

struct interface_header_t // Sum
{
    const static astType class_type = astType::interface_header;
    ast_t base;
    interface_headerType type;
};

    struct InterfaceHeader_t // Constructor
    {
        const static interface_headerType class_type = interface_headerType::InterfaceHeader;
        typedef interface_header_t parent_type;
        interface_header_t base;
    };
    static inline ast_t* make_InterfaceHeader_t(Allocator &al, const Location &a_loc) {
        InterfaceHeader_t *n;
        n = al.make_new<InterfaceHeader_t>();
        n->base.type = interface_headerType::InterfaceHeader;
        n->base.base.type = astType::interface_header;
        n->base.base.loc = a_loc;
        return (ast_t*)n;
    }

    struct InterfaceHeaderName_t // Constructor
    {
        const static interface_headerType class_type = interface_headerType::InterfaceHeaderName;
        typedef interface_header_t parent_type;
        interface_header_t base;
        char* m_name;
    };
    static inline ast_t* make_InterfaceHeaderName_t(Allocator &al, const Location &a_loc, char* a_name) {
        InterfaceHeaderName_t *n;
        n = al.make_new<InterfaceHeaderName_t>();
        n->base.type = interface_headerType::InterfaceHeaderName;
        n->base.base.type = astType::interface_header;
        n->base.base.loc = a_loc;
        n->m_name = a_name;
        return (ast_t*)n;
    }

    struct InterfaceHeaderAssignment_t // Constructor
    {
        const static interface_headerType class_type = interface_headerType::InterfaceHeaderAssignment;
        typedef interface_header_t parent_type;
        interface_header_t base;
    };
    static inline ast_t* make_InterfaceHeaderAssignment_t(Allocator &al, const Location &a_loc) {
        InterfaceHeaderAssignment_t *n;
        n = al.make_new<InterfaceHeaderAssignment_t>();
        n->base.type = interface_headerType::InterfaceHeaderAssignment;
        n->base.base.type = astType::interface_header;
        n->base.base.loc = a_loc;
        return (ast_t*)n;
    }

    struct InterfaceHeaderOperator_t // Constructor
    {
        const static interface_headerType class_type = interface_headerType::InterfaceHeaderOperator;
        typedef interface_header_t parent_type;
        interface_header_t base;
        intrinsicopType m_op;
    };
    static inline ast_t* make_InterfaceHeaderOperator_t(Allocator &al, const Location &a_loc, intrinsicopType a_op) {
        InterfaceHeaderOperator_t *n;
        n = al.make_new<InterfaceHeaderOperator_t>();
        n->base.type = interface_headerType::InterfaceHeaderOperator;
        n->base.base.type = astType::interface_header;
        n->base.base.loc = a_loc;
        n->m_op = a_op;
        return (ast_t*)n;
    }

    struct InterfaceHeaderDefinedOperator_t // Constructor
    {
        const static interface_headerType class_type = interface_headerType::InterfaceHeaderDefinedOperator;
        typedef interface_header_t parent_type;
        interface_header_t base;
        char* m_operator_name;
    };
    static inline ast_t* make_InterfaceHeaderDefinedOperator_t(Allocator &al, const Location &a_loc, char* a_operator_name) {
        InterfaceHeaderDefinedOperator_t *n;
        n = al.make_new<InterfaceHeaderDefinedOperator_t>();
        n->base.type = interface_headerType::InterfaceHeaderDefinedOperator;
        n->base.base.type = astType::interface_header;
        n->base.base.loc = a_loc;
        n->m_operator_name = a_operator_name;
        return (ast_t*)n;
    }

    struct AbstractInterfaceHeader_t // Constructor
    {
        const static interface_headerType class_type = interface_headerType::AbstractInterfaceHeader;
        typedef interface_header_t parent_type;
        interface_header_t base;
    };
    static inline ast_t* make_AbstractInterfaceHeader_t(Allocator &al, const Location &a_loc) {
        AbstractInterfaceHeader_t *n;
        n = al.make_new<AbstractInterfaceHeader_t>();
        n->base.type = interface_headerType::AbstractInterfaceHeader;
        n->base.base.type = astType::interface_header;
        n->base.base.loc = a_loc;
        return (ast_t*)n;
    }

    struct InterfaceHeaderWrite_t // Constructor
    {
        const static interface_headerType class_type = interface_headerType::InterfaceHeaderWrite;
        typedef interface_header_t parent_type;
        interface_header_t base;
        char* m_id;
    };
    static inline ast_t* make_InterfaceHeaderWrite_t(Allocator &al, const Location &a_loc, char* a_id) {
        InterfaceHeaderWrite_t *n;
        n = al.make_new<InterfaceHeaderWrite_t>();
        n->base.type = interface_headerType::InterfaceHeaderWrite;
        n->base.base.type = astType::interface_header;
        n->base.base.loc = a_loc;
        n->m_id = a_id;
        return (ast_t*)n;
    }

    struct InterfaceHeaderRead_t // Constructor
    {
        const static interface_headerType class_type = interface_headerType::InterfaceHeaderRead;
        typedef interface_header_t parent_type;
        interface_header_t base;
        char* m_id;
    };
    static inline ast_t* make_InterfaceHeaderRead_t(Allocator &al, const Location &a_loc, char* a_id) {
        InterfaceHeaderRead_t *n;
        n = al.make_new<InterfaceHeaderRead_t>();
        n->base.type = interface_headerType::InterfaceHeaderRead;
        n->base.base.type = astType::interface_header;
        n->base.base.loc = a_loc;
        n->m_id = a_id;
        return (ast_t*)n;
    }



enum interface_itemType // Types
{
    InterfaceProc, InterfaceModuleProcedure
};

struct interface_item_t // Sum
{
    const static astType class_type = astType::interface_item;
    ast_t base;
    interface_itemType type;
};

    struct InterfaceProc_t // Constructor
    {
        const static interface_itemType class_type = interface_itemType::InterfaceProc;
        typedef interface_item_t parent_type;
        interface_item_t base;
        program_unit_t* m_proc;
    };
    static inline ast_t* make_InterfaceProc_t(Allocator &al, const Location &a_loc, program_unit_t* a_proc) {
        InterfaceProc_t *n;
        n = al.make_new<InterfaceProc_t>();
        n->base.type = interface_itemType::InterfaceProc;
        n->base.base.type = astType::interface_item;
        n->base.base.loc = a_loc;
        n->m_proc = a_proc;
        return (ast_t*)n;
    }

    struct InterfaceModuleProcedure_t // Constructor
    {
        const static interface_itemType class_type = interface_itemType::InterfaceModuleProcedure;
        typedef interface_item_t parent_type;
        interface_item_t base;
        char** m_names; size_t n_names; // Sequence
        decl_attribute_t** m_attributes; size_t n_attributes; // Sequence
        trivia_t* m_trivia;
    };
    static inline ast_t* make_InterfaceModuleProcedure_t(Allocator &al, const Location &a_loc, char** a_names, size_t n_names, decl_attribute_t** a_attributes, size_t n_attributes, trivia_t* a_trivia) {
        InterfaceModuleProcedure_t *n;
        n = al.make_new<InterfaceModuleProcedure_t>();
        n->base.type = interface_itemType::InterfaceModuleProcedure;
        n->base.base.type = astType::interface_item;
        n->base.base.loc = a_loc;
        n->m_names = a_names;
        n->n_names = n_names;
        n->m_attributes = a_attributes;
        n->n_attributes = n_attributes;
        n->m_trivia = a_trivia;
        return (ast_t*)n;
    }



enum import_statementType // Types
{
    Import
};

struct import_statement_t // Sum
{
    const static astType class_type = astType::import_statement;
    ast_t base;
    import_statementType type;
};

    struct Import_t // Constructor
    {
        const static import_statementType class_type = import_statementType::Import;
        typedef import_statement_t parent_type;
        import_statement_t base;
        char** m_symbols; size_t n_symbols; // Sequence
        import_modifierType m_mod;
        trivia_t* m_trivia;
    };
    static inline ast_t* make_Import_t(Allocator &al, const Location &a_loc, char** a_symbols, size_t n_symbols, import_modifierType a_mod, trivia_t* a_trivia) {
        Import_t *n;
        n = al.make_new<Import_t>();
        n->base.type = import_statementType::Import;
        n->base.base.type = astType::import_statement;
        n->base.base.loc = a_loc;
        n->m_symbols = a_symbols;
        n->n_symbols = n_symbols;
        n->m_mod = a_mod;
        n->m_trivia = a_trivia;
        return (ast_t*)n;
    }



enum implicit_statementType // Types
{
    ImplicitNone, Implicit
};

struct implicit_statement_t // Sum
{
    const static astType class_type = astType::implicit_statement;
    ast_t base;
    implicit_statementType type;
};

    struct ImplicitNone_t // Constructor
    {
        const static implicit_statementType class_type = implicit_statementType::ImplicitNone;
        typedef implicit_statement_t parent_type;
        implicit_statement_t base;
        implicit_none_spec_t** m_specs; size_t n_specs; // Sequence
        trivia_t* m_trivia;
    };
    static inline ast_t* make_ImplicitNone_t(Allocator &al, const Location &a_loc, implicit_none_spec_t** a_specs, size_t n_specs, trivia_t* a_trivia) {
        ImplicitNone_t *n;
        n = al.make_new<ImplicitNone_t>();
        n->base.type = implicit_statementType::ImplicitNone;
        n->base.base.type = astType::implicit_statement;
        n->base.base.loc = a_loc;
        n->m_specs = a_specs;
        n->n_specs = n_specs;
        n->m_trivia = a_trivia;
        return (ast_t*)n;
    }

    struct Implicit_t // Constructor
    {
        const static implicit_statementType class_type = implicit_statementType::Implicit;
        typedef implicit_statement_t parent_type;
        implicit_statement_t base;
        decl_attribute_t* m_type;
        letter_spec_t** m_kind; size_t n_kind; // Sequence
        letter_spec_t** m_specs; size_t n_specs; // Sequence
        trivia_t* m_trivia;
    };
    static inline ast_t* make_Implicit_t(Allocator &al, const Location &a_loc, decl_attribute_t* a_type, letter_spec_t** a_kind, size_t n_kind, letter_spec_t** a_specs, size_t n_specs, trivia_t* a_trivia) {
        Implicit_t *n;
        n = al.make_new<Implicit_t>();
        n->base.type = implicit_statementType::Implicit;
        n->base.base.type = astType::implicit_statement;
        n->base.base.loc = a_loc;
        n->m_type = a_type;
        n->m_kind = a_kind;
        n->n_kind = n_kind;
        n->m_specs = a_specs;
        n->n_specs = n_specs;
        n->m_trivia = a_trivia;
        return (ast_t*)n;
    }



enum implicit_none_specType // Types
{
    ImplicitNoneExternal, ImplicitNoneType
};

struct implicit_none_spec_t // Sum
{
    const static astType class_type = astType::implicit_none_spec;
    ast_t base;
    implicit_none_specType type;
};

    struct ImplicitNoneExternal_t // Constructor
    {
        const static implicit_none_specType class_type = implicit_none_specType::ImplicitNoneExternal;
        typedef implicit_none_spec_t parent_type;
        implicit_none_spec_t base;
        int64_t m_dummy;
    };
    static inline ast_t* make_ImplicitNoneExternal_t(Allocator &al, const Location &a_loc, int64_t a_dummy) {
        ImplicitNoneExternal_t *n;
        n = al.make_new<ImplicitNoneExternal_t>();
        n->base.type = implicit_none_specType::ImplicitNoneExternal;
        n->base.base.type = astType::implicit_none_spec;
        n->base.base.loc = a_loc;
        n->m_dummy = a_dummy;
        return (ast_t*)n;
    }

    struct ImplicitNoneType_t // Constructor
    {
        const static implicit_none_specType class_type = implicit_none_specType::ImplicitNoneType;
        typedef implicit_none_spec_t parent_type;
        implicit_none_spec_t base;
    };
    static inline ast_t* make_ImplicitNoneType_t(Allocator &al, const Location &a_loc) {
        ImplicitNoneType_t *n;
        n = al.make_new<ImplicitNoneType_t>();
        n->base.type = implicit_none_specType::ImplicitNoneType;
        n->base.base.type = astType::implicit_none_spec;
        n->base.base.loc = a_loc;
        return (ast_t*)n;
    }



enum letter_specType // Types
{
    LetterSpec
};

struct letter_spec_t // Sum
{
    const static astType class_type = astType::letter_spec;
    ast_t base;
    letter_specType type;
};

    struct LetterSpec_t // Constructor
    {
        const static letter_specType class_type = letter_specType::LetterSpec;
        typedef letter_spec_t parent_type;
        letter_spec_t base;
        char* m_start;
        char* m_end;
    };
    static inline ast_t* make_LetterSpec_t(Allocator &al, const Location &a_loc, char* a_start, char* a_end) {
        LetterSpec_t *n;
        n = al.make_new<LetterSpec_t>();
        n->base.type = letter_specType::LetterSpec;
        n->base.base.type = astType::letter_spec;
        n->base.base.loc = a_loc;
        n->m_start = a_start;
        n->m_end = a_end;
        return (ast_t*)n;
    }



enum stmtType // Types
{
    Allocate, Assign, Assignment, Associate, Backspace, Close, Continue, Cycle, Deallocate, Endfile, Entry, ErrorStop, EventPost, EventWait, Exit, Flush, ForAllSingle, Format, DataStmt, FormTeam, GoTo, Include, Inquire, Nullify, Open, Return, Pragma, Print, Read, Rewind, Stop, SubroutineCall, SyncAll, SyncImages, SyncMemory, SyncTeam, Write, AssociateBlock, Block, ChangeTeam, Critical, DoConcurrentLoop, DoLoop, ForAll, If, IfArithmetic, Select, SelectRank, SelectType, Where, WhileLoop
};

struct stmt_t // Sum
{
    const static astType class_type = astType::stmt;
    ast_t base;
    stmtType type;
};

    struct Allocate_t // Constructor
    {
        const static stmtType class_type = stmtType::Allocate;
        typedef stmt_t parent_type;
        stmt_t base;
        int64_t m_label;
        fnarg_t* m_args; size_t n_args; // Sequence
        keyword_t* m_keywords; size_t n_keywords; // Sequence
        trivia_t* m_trivia;
    };
    static inline ast_t* make_Allocate_t(Allocator &al, const Location &a_loc, int64_t a_label, fnarg_t* a_args, size_t n_args, keyword_t* a_keywords, size_t n_keywords, trivia_t* a_trivia) {
        Allocate_t *n;
        n = al.make_new<Allocate_t>();
        n->base.type = stmtType::Allocate;
        n->base.base.type = astType::stmt;
        n->base.base.loc = a_loc;
        n->m_label = a_label;
        n->m_args = a_args;
        n->n_args = n_args;
        n->m_keywords = a_keywords;
        n->n_keywords = n_keywords;
        n->m_trivia = a_trivia;
        return (ast_t*)n;
    }

    struct Assign_t // Constructor
    {
        const static stmtType class_type = stmtType::Assign;
        typedef stmt_t parent_type;
        stmt_t base;
        int64_t m_label;
        int64_t m_assign_label;
        char* m_variable;
        trivia_t* m_trivia;
    };
    static inline ast_t* make_Assign_t(Allocator &al, const Location &a_loc, int64_t a_label, int64_t a_assign_label, char* a_variable, trivia_t* a_trivia) {
        Assign_t *n;
        n = al.make_new<Assign_t>();
        n->base.type = stmtType::Assign;
        n->base.base.type = astType::stmt;
        n->base.base.loc = a_loc;
        n->m_label = a_label;
        n->m_assign_label = a_assign_label;
        n->m_variable = a_variable;
        n->m_trivia = a_trivia;
        return (ast_t*)n;
    }

    struct Assignment_t // Constructor
    {
        const static stmtType class_type = stmtType::Assignment;
        typedef stmt_t parent_type;
        stmt_t base;
        int64_t m_label;
        expr_t* m_target;
        expr_t* m_value;
        trivia_t* m_trivia;
    };
    static inline ast_t* make_Assignment_t(Allocator &al, const Location &a_loc, int64_t a_label, expr_t* a_target, expr_t* a_value, trivia_t* a_trivia) {
        Assignment_t *n;
        n = al.make_new<Assignment_t>();
        n->base.type = stmtType::Assignment;
        n->base.base.type = astType::stmt;
        n->base.base.loc = a_loc;
        n->m_label = a_label;
        n->m_target = a_target;
        n->m_value = a_value;
        n->m_trivia = a_trivia;
        return (ast_t*)n;
    }

    struct Associate_t // Constructor
    {
        const static stmtType class_type = stmtType::Associate;
        typedef stmt_t parent_type;
        stmt_t base;
        int64_t m_label;
        expr_t* m_target;
        expr_t* m_value;
        trivia_t* m_trivia;
    };
    static inline ast_t* make_Associate_t(Allocator &al, const Location &a_loc, int64_t a_label, expr_t* a_target, expr_t* a_value, trivia_t* a_trivia) {
        Associate_t *n;
        n = al.make_new<Associate_t>();
        n->base.type = stmtType::Associate;
        n->base.base.type = astType::stmt;
        n->base.base.loc = a_loc;
        n->m_label = a_label;
        n->m_target = a_target;
        n->m_value = a_value;
        n->m_trivia = a_trivia;
        return (ast_t*)n;
    }

    struct Backspace_t // Constructor
    {
        const static stmtType class_type = stmtType::Backspace;
        typedef stmt_t parent_type;
        stmt_t base;
        int64_t m_label;
        expr_t** m_args; size_t n_args; // Sequence
        keyword_t* m_kwargs; size_t n_kwargs; // Sequence
        trivia_t* m_trivia;
    };
    static inline ast_t* make_Backspace_t(Allocator &al, const Location &a_loc, int64_t a_label, expr_t** a_args, size_t n_args, keyword_t* a_kwargs, size_t n_kwargs, trivia_t* a_trivia) {
        Backspace_t *n;
        n = al.make_new<Backspace_t>();
        n->base.type = stmtType::Backspace;
        n->base.base.type = astType::stmt;
        n->base.base.loc = a_loc;
        n->m_label = a_label;
        n->m_args = a_args;
        n->n_args = n_args;
        n->m_kwargs = a_kwargs;
        n->n_kwargs = n_kwargs;
        n->m_trivia = a_trivia;
        return (ast_t*)n;
    }

    struct Close_t // Constructor
    {
        const static stmtType class_type = stmtType::Close;
        typedef stmt_t parent_type;
        stmt_t base;
        int64_t m_label;
        expr_t** m_args; size_t n_args; // Sequence
        keyword_t* m_kwargs; size_t n_kwargs; // Sequence
        trivia_t* m_trivia;
    };
    static inline ast_t* make_Close_t(Allocator &al, const Location &a_loc, int64_t a_label, expr_t** a_args, size_t n_args, keyword_t* a_kwargs, size_t n_kwargs, trivia_t* a_trivia) {
        Close_t *n;
        n = al.make_new<Close_t>();
        n->base.type = stmtType::Close;
        n->base.base.type = astType::stmt;
        n->base.base.loc = a_loc;
        n->m_label = a_label;
        n->m_args = a_args;
        n->n_args = n_args;
        n->m_kwargs = a_kwargs;
        n->n_kwargs = n_kwargs;
        n->m_trivia = a_trivia;
        return (ast_t*)n;
    }

    struct Continue_t // Constructor
    {
        const static stmtType class_type = stmtType::Continue;
        typedef stmt_t parent_type;
        stmt_t base;
        int64_t m_label;
        trivia_t* m_trivia;
    };
    static inline ast_t* make_Continue_t(Allocator &al, const Location &a_loc, int64_t a_label, trivia_t* a_trivia) {
        Continue_t *n;
        n = al.make_new<Continue_t>();
        n->base.type = stmtType::Continue;
        n->base.base.type = astType::stmt;
        n->base.base.loc = a_loc;
        n->m_label = a_label;
        n->m_trivia = a_trivia;
        return (ast_t*)n;
    }

    struct Cycle_t // Constructor
    {
        const static stmtType class_type = stmtType::Cycle;
        typedef stmt_t parent_type;
        stmt_t base;
        int64_t m_label;
        char* m_stmt_name;
        trivia_t* m_trivia;
    };
    static inline ast_t* make_Cycle_t(Allocator &al, const Location &a_loc, int64_t a_label, char* a_stmt_name, trivia_t* a_trivia) {
        Cycle_t *n;
        n = al.make_new<Cycle_t>();
        n->base.type = stmtType::Cycle;
        n->base.base.type = astType::stmt;
        n->base.base.loc = a_loc;
        n->m_label = a_label;
        n->m_stmt_name = a_stmt_name;
        n->m_trivia = a_trivia;
        return (ast_t*)n;
    }

    struct Deallocate_t // Constructor
    {
        const static stmtType class_type = stmtType::Deallocate;
        typedef stmt_t parent_type;
        stmt_t base;
        int64_t m_label;
        fnarg_t* m_args; size_t n_args; // Sequence
        keyword_t* m_keywords; size_t n_keywords; // Sequence
        trivia_t* m_trivia;
    };
    static inline ast_t* make_Deallocate_t(Allocator &al, const Location &a_loc, int64_t a_label, fnarg_t* a_args, size_t n_args, keyword_t* a_keywords, size_t n_keywords, trivia_t* a_trivia) {
        Deallocate_t *n;
        n = al.make_new<Deallocate_t>();
        n->base.type = stmtType::Deallocate;
        n->base.base.type = astType::stmt;
        n->base.base.loc = a_loc;
        n->m_label = a_label;
        n->m_args = a_args;
        n->n_args = n_args;
        n->m_keywords = a_keywords;
        n->n_keywords = n_keywords;
        n->m_trivia = a_trivia;
        return (ast_t*)n;
    }

    struct Endfile_t // Constructor
    {
        const static stmtType class_type = stmtType::Endfile;
        typedef stmt_t parent_type;
        stmt_t base;
        int64_t m_label;
        expr_t** m_args; size_t n_args; // Sequence
        keyword_t* m_kwargs; size_t n_kwargs; // Sequence
        trivia_t* m_trivia;
    };
    static inline ast_t* make_Endfile_t(Allocator &al, const Location &a_loc, int64_t a_label, expr_t** a_args, size_t n_args, keyword_t* a_kwargs, size_t n_kwargs, trivia_t* a_trivia) {
        Endfile_t *n;
        n = al.make_new<Endfile_t>();
        n->base.type = stmtType::Endfile;
        n->base.base.type = astType::stmt;
        n->base.base.loc = a_loc;
        n->m_label = a_label;
        n->m_args = a_args;
        n->n_args = n_args;
        n->m_kwargs = a_kwargs;
        n->n_kwargs = n_kwargs;
        n->m_trivia = a_trivia;
        return (ast_t*)n;
    }

    struct Entry_t // Constructor
    {
        const static stmtType class_type = stmtType::Entry;
        typedef stmt_t parent_type;
        stmt_t base;
        int64_t m_label;
        char* m_name;
        arg_t* m_args; size_t n_args; // Sequence
        expr_t* m_return_var;
        bind_t* m_bind;
        trivia_t* m_trivia;
    };
    static inline ast_t* make_Entry_t(Allocator &al, const Location &a_loc, int64_t a_label, char* a_name, arg_t* a_args, size_t n_args, expr_t* a_return_var, bind_t* a_bind, trivia_t* a_trivia) {
        Entry_t *n;
        n = al.make_new<Entry_t>();
        n->base.type = stmtType::Entry;
        n->base.base.type = astType::stmt;
        n->base.base.loc = a_loc;
        n->m_label = a_label;
        n->m_name = a_name;
        n->m_args = a_args;
        n->n_args = n_args;
        n->m_return_var = a_return_var;
        n->m_bind = a_bind;
        n->m_trivia = a_trivia;
        return (ast_t*)n;
    }

    struct ErrorStop_t // Constructor
    {
        const static stmtType class_type = stmtType::ErrorStop;
        typedef stmt_t parent_type;
        stmt_t base;
        int64_t m_label;
        expr_t* m_code;
        expr_t* m_quiet;
        trivia_t* m_trivia;
    };
    static inline ast_t* make_ErrorStop_t(Allocator &al, const Location &a_loc, int64_t a_label, expr_t* a_code, expr_t* a_quiet, trivia_t* a_trivia) {
        ErrorStop_t *n;
        n = al.make_new<ErrorStop_t>();
        n->base.type = stmtType::ErrorStop;
        n->base.base.type = astType::stmt;
        n->base.base.loc = a_loc;
        n->m_label = a_label;
        n->m_code = a_code;
        n->m_quiet = a_quiet;
        n->m_trivia = a_trivia;
        return (ast_t*)n;
    }

    struct EventPost_t // Constructor
    {
        const static stmtType class_type = stmtType::EventPost;
        typedef stmt_t parent_type;
        stmt_t base;
        int64_t m_label;
        expr_t* m_variable;
        event_attribute_t** m_stat; size_t n_stat; // Sequence
        trivia_t* m_trivia;
    };
    static inline ast_t* make_EventPost_t(Allocator &al, const Location &a_loc, int64_t a_label, expr_t* a_variable, event_attribute_t** a_stat, size_t n_stat, trivia_t* a_trivia) {
        EventPost_t *n;
        n = al.make_new<EventPost_t>();
        n->base.type = stmtType::EventPost;
        n->base.base.type = astType::stmt;
        n->base.base.loc = a_loc;
        n->m_label = a_label;
        n->m_variable = a_variable;
        n->m_stat = a_stat;
        n->n_stat = n_stat;
        n->m_trivia = a_trivia;
        return (ast_t*)n;
    }

    struct EventWait_t // Constructor
    {
        const static stmtType class_type = stmtType::EventWait;
        typedef stmt_t parent_type;
        stmt_t base;
        int64_t m_label;
        expr_t* m_variable;
        event_attribute_t** m_spec; size_t n_spec; // Sequence
        trivia_t* m_trivia;
    };
    static inline ast_t* make_EventWait_t(Allocator &al, const Location &a_loc, int64_t a_label, expr_t* a_variable, event_attribute_t** a_spec, size_t n_spec, trivia_t* a_trivia) {
        EventWait_t *n;
        n = al.make_new<EventWait_t>();
        n->base.type = stmtType::EventWait;
        n->base.base.type = astType::stmt;
        n->base.base.loc = a_loc;
        n->m_label = a_label;
        n->m_variable = a_variable;
        n->m_spec = a_spec;
        n->n_spec = n_spec;
        n->m_trivia = a_trivia;
        return (ast_t*)n;
    }

    struct Exit_t // Constructor
    {
        const static stmtType class_type = stmtType::Exit;
        typedef stmt_t parent_type;
        stmt_t base;
        int64_t m_label;
        char* m_stmt_name;
        trivia_t* m_trivia;
    };
    static inline ast_t* make_Exit_t(Allocator &al, const Location &a_loc, int64_t a_label, char* a_stmt_name, trivia_t* a_trivia) {
        Exit_t *n;
        n = al.make_new<Exit_t>();
        n->base.type = stmtType::Exit;
        n->base.base.type = astType::stmt;
        n->base.base.loc = a_loc;
        n->m_label = a_label;
        n->m_stmt_name = a_stmt_name;
        n->m_trivia = a_trivia;
        return (ast_t*)n;
    }

    struct Flush_t // Constructor
    {
        const static stmtType class_type = stmtType::Flush;
        typedef stmt_t parent_type;
        stmt_t base;
        int64_t m_label;
        expr_t** m_args; size_t n_args; // Sequence
        keyword_t* m_kwargs; size_t n_kwargs; // Sequence
        trivia_t* m_trivia;
    };
    static inline ast_t* make_Flush_t(Allocator &al, const Location &a_loc, int64_t a_label, expr_t** a_args, size_t n_args, keyword_t* a_kwargs, size_t n_kwargs, trivia_t* a_trivia) {
        Flush_t *n;
        n = al.make_new<Flush_t>();
        n->base.type = stmtType::Flush;
        n->base.base.type = astType::stmt;
        n->base.base.loc = a_loc;
        n->m_label = a_label;
        n->m_args = a_args;
        n->n_args = n_args;
        n->m_kwargs = a_kwargs;
        n->n_kwargs = n_kwargs;
        n->m_trivia = a_trivia;
        return (ast_t*)n;
    }

    struct ForAllSingle_t // Constructor
    {
        const static stmtType class_type = stmtType::ForAllSingle;
        typedef stmt_t parent_type;
        stmt_t base;
        int64_t m_label;
        char* m_stmt_name;
        concurrent_control_t** m_control; size_t n_control; // Sequence
        expr_t* m_mask;
        stmt_t* m_assign;
        trivia_t* m_trivia;
    };
    static inline ast_t* make_ForAllSingle_t(Allocator &al, const Location &a_loc, int64_t a_label, char* a_stmt_name, concurrent_control_t** a_control, size_t n_control, expr_t* a_mask, stmt_t* a_assign, trivia_t* a_trivia) {
        ForAllSingle_t *n;
        n = al.make_new<ForAllSingle_t>();
        n->base.type = stmtType::ForAllSingle;
        n->base.base.type = astType::stmt;
        n->base.base.loc = a_loc;
        n->m_label = a_label;
        n->m_stmt_name = a_stmt_name;
        n->m_control = a_control;
        n->n_control = n_control;
        n->m_mask = a_mask;
        n->m_assign = a_assign;
        n->m_trivia = a_trivia;
        return (ast_t*)n;
    }

    struct Format_t // Constructor
    {
        const static stmtType class_type = stmtType::Format;
        typedef stmt_t parent_type;
        stmt_t base;
        int64_t m_label;
        char* m_fmt;
        trivia_t* m_trivia;
    };
    static inline ast_t* make_Format_t(Allocator &al, const Location &a_loc, int64_t a_label, char* a_fmt, trivia_t* a_trivia) {
        Format_t *n;
        n = al.make_new<Format_t>();
        n->base.type = stmtType::Format;
        n->base.base.type = astType::stmt;
        n->base.base.loc = a_loc;
        n->m_label = a_label;
        n->m_fmt = a_fmt;
        n->m_trivia = a_trivia;
        return (ast_t*)n;
    }

    struct DataStmt_t // Constructor
    {
        const static stmtType class_type = stmtType::DataStmt;
        typedef stmt_t parent_type;
        stmt_t base;
        int64_t m_label;
        data_stmt_set_t** m_items; size_t n_items; // Sequence
        trivia_t* m_trivia;
    };
    static inline ast_t* make_DataStmt_t(Allocator &al, const Location &a_loc, int64_t a_label, data_stmt_set_t** a_items, size_t n_items, trivia_t* a_trivia) {
        DataStmt_t *n;
        n = al.make_new<DataStmt_t>();
        n->base.type = stmtType::DataStmt;
        n->base.base.type = astType::stmt;
        n->base.base.loc = a_loc;
        n->m_label = a_label;
        n->m_items = a_items;
        n->n_items = n_items;
        n->m_trivia = a_trivia;
        return (ast_t*)n;
    }

    struct FormTeam_t // Constructor
    {
        const static stmtType class_type = stmtType::FormTeam;
        typedef stmt_t parent_type;
        stmt_t base;
        int64_t m_label;
        expr_t* m_team_number;
        char* m_team_var;
        event_attribute_t** m_sync_stat; size_t n_sync_stat; // Sequence
        trivia_t* m_trivia;
    };
    static inline ast_t* make_FormTeam_t(Allocator &al, const Location &a_loc, int64_t a_label, expr_t* a_team_number, char* a_team_var, event_attribute_t** a_sync_stat, size_t n_sync_stat, trivia_t* a_trivia) {
        FormTeam_t *n;
        n = al.make_new<FormTeam_t>();
        n->base.type = stmtType::FormTeam;
        n->base.base.type = astType::stmt;
        n->base.base.loc = a_loc;
        n->m_label = a_label;
        n->m_team_number = a_team_number;
        n->m_team_var = a_team_var;
        n->m_sync_stat = a_sync_stat;
        n->n_sync_stat = n_sync_stat;
        n->m_trivia = a_trivia;
        return (ast_t*)n;
    }

    struct GoTo_t // Constructor
    {
        const static stmtType class_type = stmtType::GoTo;
        typedef stmt_t parent_type;
        stmt_t base;
        int64_t m_label;
        char* m_int_var;
        expr_t* m_goto_label;
        expr_t** m_labels; size_t n_labels; // Sequence
        trivia_t* m_trivia;
    };
    static inline ast_t* make_GoTo_t(Allocator &al, const Location &a_loc, int64_t a_label, char* a_int_var, expr_t* a_goto_label, expr_t** a_labels, size_t n_labels, trivia_t* a_trivia) {
        GoTo_t *n;
        n = al.make_new<GoTo_t>();
        n->base.type = stmtType::GoTo;
        n->base.base.type = astType::stmt;
        n->base.base.loc = a_loc;
        n->m_label = a_label;
        n->m_int_var = a_int_var;
        n->m_goto_label = a_goto_label;
        n->m_labels = a_labels;
        n->n_labels = n_labels;
        n->m_trivia = a_trivia;
        return (ast_t*)n;
    }

    struct Include_t // Constructor
    {
        const static stmtType class_type = stmtType::Include;
        typedef stmt_t parent_type;
        stmt_t base;
        int64_t m_label;
        char* m_filename;
        trivia_t* m_trivia;
    };
    static inline ast_t* make_Include_t(Allocator &al, const Location &a_loc, int64_t a_label, char* a_filename, trivia_t* a_trivia) {
        Include_t *n;
        n = al.make_new<Include_t>();
        n->base.type = stmtType::Include;
        n->base.base.type = astType::stmt;
        n->base.base.loc = a_loc;
        n->m_label = a_label;
        n->m_filename = a_filename;
        n->m_trivia = a_trivia;
        return (ast_t*)n;
    }

    struct Inquire_t // Constructor
    {
        const static stmtType class_type = stmtType::Inquire;
        typedef stmt_t parent_type;
        stmt_t base;
        int64_t m_label;
        expr_t** m_args; size_t n_args; // Sequence
        keyword_t* m_kwargs; size_t n_kwargs; // Sequence
        expr_t** m_values; size_t n_values; // Sequence
        trivia_t* m_trivia;
    };
    static inline ast_t* make_Inquire_t(Allocator &al, const Location &a_loc, int64_t a_label, expr_t** a_args, size_t n_args, keyword_t* a_kwargs, size_t n_kwargs, expr_t** a_values, size_t n_values, trivia_t* a_trivia) {
        Inquire_t *n;
        n = al.make_new<Inquire_t>();
        n->base.type = stmtType::Inquire;
        n->base.base.type = astType::stmt;
        n->base.base.loc = a_loc;
        n->m_label = a_label;
        n->m_args = a_args;
        n->n_args = n_args;
        n->m_kwargs = a_kwargs;
        n->n_kwargs = n_kwargs;
        n->m_values = a_values;
        n->n_values = n_values;
        n->m_trivia = a_trivia;
        return (ast_t*)n;
    }

    struct Nullify_t // Constructor
    {
        const static stmtType class_type = stmtType::Nullify;
        typedef stmt_t parent_type;
        stmt_t base;
        int64_t m_label;
        expr_t** m_args; size_t n_args; // Sequence
        keyword_t* m_kwargs; size_t n_kwargs; // Sequence
        trivia_t* m_trivia;
    };
    static inline ast_t* make_Nullify_t(Allocator &al, const Location &a_loc, int64_t a_label, expr_t** a_args, size_t n_args, keyword_t* a_kwargs, size_t n_kwargs, trivia_t* a_trivia) {
        Nullify_t *n;
        n = al.make_new<Nullify_t>();
        n->base.type = stmtType::Nullify;
        n->base.base.type = astType::stmt;
        n->base.base.loc = a_loc;
        n->m_label = a_label;
        n->m_args = a_args;
        n->n_args = n_args;
        n->m_kwargs = a_kwargs;
        n->n_kwargs = n_kwargs;
        n->m_trivia = a_trivia;
        return (ast_t*)n;
    }

    struct Open_t // Constructor
    {
        const static stmtType class_type = stmtType::Open;
        typedef stmt_t parent_type;
        stmt_t base;
        int64_t m_label;
        expr_t** m_args; size_t n_args; // Sequence
        keyword_t* m_kwargs; size_t n_kwargs; // Sequence
        trivia_t* m_trivia;
    };
    static inline ast_t* make_Open_t(Allocator &al, const Location &a_loc, int64_t a_label, expr_t** a_args, size_t n_args, keyword_t* a_kwargs, size_t n_kwargs, trivia_t* a_trivia) {
        Open_t *n;
        n = al.make_new<Open_t>();
        n->base.type = stmtType::Open;
        n->base.base.type = astType::stmt;
        n->base.base.loc = a_loc;
        n->m_label = a_label;
        n->m_args = a_args;
        n->n_args = n_args;
        n->m_kwargs = a_kwargs;
        n->n_kwargs = n_kwargs;
        n->m_trivia = a_trivia;
        return (ast_t*)n;
    }

    struct Return_t // Constructor
    {
        const static stmtType class_type = stmtType::Return;
        typedef stmt_t parent_type;
        stmt_t base;
        int64_t m_label;
        expr_t* m_value;
        trivia_t* m_trivia;
    };
    static inline ast_t* make_Return_t(Allocator &al, const Location &a_loc, int64_t a_label, expr_t* a_value, trivia_t* a_trivia) {
        Return_t *n;
        n = al.make_new<Return_t>();
        n->base.type = stmtType::Return;
        n->base.base.type = astType::stmt;
        n->base.base.loc = a_loc;
        n->m_label = a_label;
        n->m_value = a_value;
        n->m_trivia = a_trivia;
        return (ast_t*)n;
    }

    struct Pragma_t // Constructor
    {
        const static stmtType class_type = stmtType::Pragma;
        typedef stmt_t parent_type;
        stmt_t base;
        int64_t m_label;
        pragma_typeType m_type;
        bool m_end;
        char* m_construct_name;
        expr_t** m_clauses; size_t n_clauses; // Sequence
        trivia_t* m_trivia;
    };
    static inline ast_t* make_Pragma_t(Allocator &al, const Location &a_loc, int64_t a_label, pragma_typeType a_type, bool a_end, char* a_construct_name, expr_t** a_clauses, size_t n_clauses, trivia_t* a_trivia) {
        Pragma_t *n;
        n = al.make_new<Pragma_t>();
        n->base.type = stmtType::Pragma;
        n->base.base.type = astType::stmt;
        n->base.base.loc = a_loc;
        n->m_label = a_label;
        n->m_type = a_type;
        n->m_end = a_end;
        n->m_construct_name = a_construct_name;
        n->m_clauses = a_clauses;
        n->n_clauses = n_clauses;
        n->m_trivia = a_trivia;
        return (ast_t*)n;
    }

    struct Print_t // Constructor
    {
        const static stmtType class_type = stmtType::Print;
        typedef stmt_t parent_type;
        stmt_t base;
        int64_t m_label;
        expr_t* m_fmt;
        expr_t** m_values; size_t n_values; // Sequence
        trivia_t* m_trivia;
    };
    static inline ast_t* make_Print_t(Allocator &al, const Location &a_loc, int64_t a_label, expr_t* a_fmt, expr_t** a_values, size_t n_values, trivia_t* a_trivia) {
        Print_t *n;
        n = al.make_new<Print_t>();
        n->base.type = stmtType::Print;
        n->base.base.type = astType::stmt;
        n->base.base.loc = a_loc;
        n->m_label = a_label;
        n->m_fmt = a_fmt;
        n->m_values = a_values;
        n->n_values = n_values;
        n->m_trivia = a_trivia;
        return (ast_t*)n;
    }

    struct Read_t // Constructor
    {
        const static stmtType class_type = stmtType::Read;
        typedef stmt_t parent_type;
        stmt_t base;
        int64_t m_label;
        expr_t* m_format;
        argstar_t* m_args; size_t n_args; // Sequence
        kw_argstar_t* m_kwargs; size_t n_kwargs; // Sequence
        expr_t** m_values; size_t n_values; // Sequence
        trivia_t* m_trivia;
    };
    static inline ast_t* make_Read_t(Allocator &al, const Location &a_loc, int64_t a_label, expr_t* a_format, argstar_t* a_args, size_t n_args, kw_argstar_t* a_kwargs, size_t n_kwargs, expr_t** a_values, size_t n_values, trivia_t* a_trivia) {
        Read_t *n;
        n = al.make_new<Read_t>();
        n->base.type = stmtType::Read;
        n->base.base.type = astType::stmt;
        n->base.base.loc = a_loc;
        n->m_label = a_label;
        n->m_format = a_format;
        n->m_args = a_args;
        n->n_args = n_args;
        n->m_kwargs = a_kwargs;
        n->n_kwargs = n_kwargs;
        n->m_values = a_values;
        n->n_values = n_values;
        n->m_trivia = a_trivia;
        return (ast_t*)n;
    }

    struct Rewind_t // Constructor
    {
        const static stmtType class_type = stmtType::Rewind;
        typedef stmt_t parent_type;
        stmt_t base;
        int64_t m_label;
        expr_t** m_args; size_t n_args; // Sequence
        keyword_t* m_kwargs; size_t n_kwargs; // Sequence
        trivia_t* m_trivia;
    };
    static inline ast_t* make_Rewind_t(Allocator &al, const Location &a_loc, int64_t a_label, expr_t** a_args, size_t n_args, keyword_t* a_kwargs, size_t n_kwargs, trivia_t* a_trivia) {
        Rewind_t *n;
        n = al.make_new<Rewind_t>();
        n->base.type = stmtType::Rewind;
        n->base.base.type = astType::stmt;
        n->base.base.loc = a_loc;
        n->m_label = a_label;
        n->m_args = a_args;
        n->n_args = n_args;
        n->m_kwargs = a_kwargs;
        n->n_kwargs = n_kwargs;
        n->m_trivia = a_trivia;
        return (ast_t*)n;
    }

    struct Stop_t // Constructor
    {
        const static stmtType class_type = stmtType::Stop;
        typedef stmt_t parent_type;
        stmt_t base;
        int64_t m_label;
        expr_t* m_code;
        expr_t* m_quiet;
        trivia_t* m_trivia;
    };
    static inline ast_t* make_Stop_t(Allocator &al, const Location &a_loc, int64_t a_label, expr_t* a_code, expr_t* a_quiet, trivia_t* a_trivia) {
        Stop_t *n;
        n = al.make_new<Stop_t>();
        n->base.type = stmtType::Stop;
        n->base.base.type = astType::stmt;
        n->base.base.loc = a_loc;
        n->m_label = a_label;
        n->m_code = a_code;
        n->m_quiet = a_quiet;
        n->m_trivia = a_trivia;
        return (ast_t*)n;
    }

    struct SubroutineCall_t // Constructor
    {
        const static stmtType class_type = stmtType::SubroutineCall;
        typedef stmt_t parent_type;
        stmt_t base;
        int64_t m_label;
        char* m_name;
        struct_member_t* m_member; size_t n_member; // Sequence
        fnarg_t* m_args; size_t n_args; // Sequence
        keyword_t* m_keywords; size_t n_keywords; // Sequence
        decl_attribute_t** m_temp_args; size_t n_temp_args; // Sequence
        trivia_t* m_trivia;
    };
    static inline ast_t* make_SubroutineCall_t(Allocator &al, const Location &a_loc, int64_t a_label, char* a_name, struct_member_t* a_member, size_t n_member, fnarg_t* a_args, size_t n_args, keyword_t* a_keywords, size_t n_keywords, decl_attribute_t** a_temp_args, size_t n_temp_args, trivia_t* a_trivia) {
        SubroutineCall_t *n;
        n = al.make_new<SubroutineCall_t>();
        n->base.type = stmtType::SubroutineCall;
        n->base.base.type = astType::stmt;
        n->base.base.loc = a_loc;
        n->m_label = a_label;
        n->m_name = a_name;
        n->m_member = a_member;
        n->n_member = n_member;
        n->m_args = a_args;
        n->n_args = n_args;
        n->m_keywords = a_keywords;
        n->n_keywords = n_keywords;
        n->m_temp_args = a_temp_args;
        n->n_temp_args = n_temp_args;
        n->m_trivia = a_trivia;
        return (ast_t*)n;
    }

    struct SyncAll_t // Constructor
    {
        const static stmtType class_type = stmtType::SyncAll;
        typedef stmt_t parent_type;
        stmt_t base;
        int64_t m_label;
        event_attribute_t** m_stat; size_t n_stat; // Sequence
        trivia_t* m_trivia;
    };
    static inline ast_t* make_SyncAll_t(Allocator &al, const Location &a_loc, int64_t a_label, event_attribute_t** a_stat, size_t n_stat, trivia_t* a_trivia) {
        SyncAll_t *n;
        n = al.make_new<SyncAll_t>();
        n->base.type = stmtType::SyncAll;
        n->base.base.type = astType::stmt;
        n->base.base.loc = a_loc;
        n->m_label = a_label;
        n->m_stat = a_stat;
        n->n_stat = n_stat;
        n->m_trivia = a_trivia;
        return (ast_t*)n;
    }

    struct SyncImages_t // Constructor
    {
        const static stmtType class_type = stmtType::SyncImages;
        typedef stmt_t parent_type;
        stmt_t base;
        int64_t m_label;
        expr_t* m_image_set;
        symbolType m_sym;
        event_attribute_t** m_stat; size_t n_stat; // Sequence
        trivia_t* m_trivia;
    };
    static inline ast_t* make_SyncImages_t(Allocator &al, const Location &a_loc, int64_t a_label, expr_t* a_image_set, symbolType a_sym, event_attribute_t** a_stat, size_t n_stat, trivia_t* a_trivia) {
        SyncImages_t *n;
        n = al.make_new<SyncImages_t>();
        n->base.type = stmtType::SyncImages;
        n->base.base.type = astType::stmt;
        n->base.base.loc = a_loc;
        n->m_label = a_label;
        n->m_image_set = a_image_set;
        n->m_sym = a_sym;
        n->m_stat = a_stat;
        n->n_stat = n_stat;
        n->m_trivia = a_trivia;
        return (ast_t*)n;
    }

    struct SyncMemory_t // Constructor
    {
        const static stmtType class_type = stmtType::SyncMemory;
        typedef stmt_t parent_type;
        stmt_t base;
        int64_t m_label;
        event_attribute_t** m_stat; size_t n_stat; // Sequence
        trivia_t* m_trivia;
    };
    static inline ast_t* make_SyncMemory_t(Allocator &al, const Location &a_loc, int64_t a_label, event_attribute_t** a_stat, size_t n_stat, trivia_t* a_trivia) {
        SyncMemory_t *n;
        n = al.make_new<SyncMemory_t>();
        n->base.type = stmtType::SyncMemory;
        n->base.base.type = astType::stmt;
        n->base.base.loc = a_loc;
        n->m_label = a_label;
        n->m_stat = a_stat;
        n->n_stat = n_stat;
        n->m_trivia = a_trivia;
        return (ast_t*)n;
    }

    struct SyncTeam_t // Constructor
    {
        const static stmtType class_type = stmtType::SyncTeam;
        typedef stmt_t parent_type;
        stmt_t base;
        int64_t m_label;
        expr_t* m_value;
        event_attribute_t** m_stat; size_t n_stat; // Sequence
        trivia_t* m_trivia;
    };
    static inline ast_t* make_SyncTeam_t(Allocator &al, const Location &a_loc, int64_t a_label, expr_t* a_value, event_attribute_t** a_stat, size_t n_stat, trivia_t* a_trivia) {
        SyncTeam_t *n;
        n = al.make_new<SyncTeam_t>();
        n->base.type = stmtType::SyncTeam;
        n->base.base.type = astType::stmt;
        n->base.base.loc = a_loc;
        n->m_label = a_label;
        n->m_value = a_value;
        n->m_stat = a_stat;
        n->n_stat = n_stat;
        n->m_trivia = a_trivia;
        return (ast_t*)n;
    }

    struct Write_t // Constructor
    {
        const static stmtType class_type = stmtType::Write;
        typedef stmt_t parent_type;
        stmt_t base;
        int64_t m_label;
        argstar_t* m_args; size_t n_args; // Sequence
        kw_argstar_t* m_kwargs; size_t n_kwargs; // Sequence
        expr_t** m_values; size_t n_values; // Sequence
        trivia_t* m_trivia;
    };
    static inline ast_t* make_Write_t(Allocator &al, const Location &a_loc, int64_t a_label, argstar_t* a_args, size_t n_args, kw_argstar_t* a_kwargs, size_t n_kwargs, expr_t** a_values, size_t n_values, trivia_t* a_trivia) {
        Write_t *n;
        n = al.make_new<Write_t>();
        n->base.type = stmtType::Write;
        n->base.base.type = astType::stmt;
        n->base.base.loc = a_loc;
        n->m_label = a_label;
        n->m_args = a_args;
        n->n_args = n_args;
        n->m_kwargs = a_kwargs;
        n->n_kwargs = n_kwargs;
        n->m_values = a_values;
        n->n_values = n_values;
        n->m_trivia = a_trivia;
        return (ast_t*)n;
    }

    struct AssociateBlock_t // Constructor
    {
        const static stmtType class_type = stmtType::AssociateBlock;
        typedef stmt_t parent_type;
        stmt_t base;
        int64_t m_label;
        char* m_stmt_name;
        var_sym_t* m_syms; size_t n_syms; // Sequence
        stmt_t** m_body; size_t n_body; // Sequence
        trivia_t* m_t_inside;
        trivia_t* m_trivia;
    };
    static inline ast_t* make_AssociateBlock_t(Allocator &al, const Location &a_loc, int64_t a_label, char* a_stmt_name, var_sym_t* a_syms, size_t n_syms, stmt_t** a_body, size_t n_body, trivia_t* a_t_inside, trivia_t* a_trivia) {
        AssociateBlock_t *n;
        n = al.make_new<AssociateBlock_t>();
        n->base.type = stmtType::AssociateBlock;
        n->base.base.type = astType::stmt;
        n->base.base.loc = a_loc;
        n->m_label = a_label;
        n->m_stmt_name = a_stmt_name;
        n->m_syms = a_syms;
        n->n_syms = n_syms;
        n->m_body = a_body;
        n->n_body = n_body;
        n->m_t_inside = a_t_inside;
        n->m_trivia = a_trivia;
        return (ast_t*)n;
    }

    struct Block_t // Constructor
    {
        const static stmtType class_type = stmtType::Block;
        typedef stmt_t parent_type;
        stmt_t base;
        int64_t m_label;
        char* m_stmt_name;
        unit_decl1_t** m_use; size_t n_use; // Sequence
        import_statement_t** m_import; size_t n_import; // Sequence
        unit_decl2_t** m_decl; size_t n_decl; // Sequence
        stmt_t** m_body; size_t n_body; // Sequence
        trivia_t* m_t_inside;
        trivia_t* m_trivia;
    };
    static inline ast_t* make_Block_t(Allocator &al, const Location &a_loc, int64_t a_label, char* a_stmt_name, unit_decl1_t** a_use, size_t n_use, import_statement_t** a_import, size_t n_import, unit_decl2_t** a_decl, size_t n_decl, stmt_t** a_body, size_t n_body, trivia_t* a_t_inside, trivia_t* a_trivia) {
        Block_t *n;
        n = al.make_new<Block_t>();
        n->base.type = stmtType::Block;
        n->base.base.type = astType::stmt;
        n->base.base.loc = a_loc;
        n->m_label = a_label;
        n->m_stmt_name = a_stmt_name;
        n->m_use = a_use;
        n->n_use = n_use;
        n->m_import = a_import;
        n->n_import = n_import;
        n->m_decl = a_decl;
        n->n_decl = n_decl;
        n->m_body = a_body;
        n->n_body = n_body;
        n->m_t_inside = a_t_inside;
        n->m_trivia = a_trivia;
        return (ast_t*)n;
    }

    struct ChangeTeam_t // Constructor
    {
        const static stmtType class_type = stmtType::ChangeTeam;
        typedef stmt_t parent_type;
        stmt_t base;
        int64_t m_label;
        char* m_stmt_name;
        expr_t* m_team_value;
        team_attribute_t** m_coarray_assoc; size_t n_coarray_assoc; // Sequence
        event_attribute_t** m_sync; size_t n_sync; // Sequence
        stmt_t** m_body; size_t n_body; // Sequence
        trivia_t* m_t_inside;
        trivia_t* m_trivia;
        event_attribute_t** m_sync_stat; size_t n_sync_stat; // Sequence
    };
    static inline ast_t* make_ChangeTeam_t(Allocator &al, const Location &a_loc, int64_t a_label, char* a_stmt_name, expr_t* a_team_value, team_attribute_t** a_coarray_assoc, size_t n_coarray_assoc, event_attribute_t** a_sync, size_t n_sync, stmt_t** a_body, size_t n_body, trivia_t* a_t_inside, trivia_t* a_trivia, event_attribute_t** a_sync_stat, size_t n_sync_stat) {
        ChangeTeam_t *n;
        n = al.make_new<ChangeTeam_t>();
        n->base.type = stmtType::ChangeTeam;
        n->base.base.type = astType::stmt;
        n->base.base.loc = a_loc;
        n->m_label = a_label;
        n->m_stmt_name = a_stmt_name;
        n->m_team_value = a_team_value;
        n->m_coarray_assoc = a_coarray_assoc;
        n->n_coarray_assoc = n_coarray_assoc;
        n->m_sync = a_sync;
        n->n_sync = n_sync;
        n->m_body = a_body;
        n->n_body = n_body;
        n->m_t_inside = a_t_inside;
        n->m_trivia = a_trivia;
        n->m_sync_stat = a_sync_stat;
        n->n_sync_stat = n_sync_stat;
        return (ast_t*)n;
    }

    struct Critical_t // Constructor
    {
        const static stmtType class_type = stmtType::Critical;
        typedef stmt_t parent_type;
        stmt_t base;
        int64_t m_label;
        char* m_stmt_name;
        event_attribute_t** m_sync_stat; size_t n_sync_stat; // Sequence
        stmt_t** m_body; size_t n_body; // Sequence
        trivia_t* m_t_inside;
        trivia_t* m_trivia;
    };
    static inline ast_t* make_Critical_t(Allocator &al, const Location &a_loc, int64_t a_label, char* a_stmt_name, event_attribute_t** a_sync_stat, size_t n_sync_stat, stmt_t** a_body, size_t n_body, trivia_t* a_t_inside, trivia_t* a_trivia) {
        Critical_t *n;
        n = al.make_new<Critical_t>();
        n->base.type = stmtType::Critical;
        n->base.base.type = astType::stmt;
        n->base.base.loc = a_loc;
        n->m_label = a_label;
        n->m_stmt_name = a_stmt_name;
        n->m_sync_stat = a_sync_stat;
        n->n_sync_stat = n_sync_stat;
        n->m_body = a_body;
        n->n_body = n_body;
        n->m_t_inside = a_t_inside;
        n->m_trivia = a_trivia;
        return (ast_t*)n;
    }

    struct DoConcurrentLoop_t // Constructor
    {
        const static stmtType class_type = stmtType::DoConcurrentLoop;
        typedef stmt_t parent_type;
        stmt_t base;
        int64_t m_label;
        char* m_stmt_name;
        concurrent_control_t** m_control; size_t n_control; // Sequence
        expr_t* m_mask;
        concurrent_locality_t** m_locality; size_t n_locality; // Sequence
        stmt_t** m_body; size_t n_body; // Sequence
        trivia_t* m_t_inside;
        trivia_t* m_trivia;
    };
    static inline ast_t* make_DoConcurrentLoop_t(Allocator &al, const Location &a_loc, int64_t a_label, char* a_stmt_name, concurrent_control_t** a_control, size_t n_control, expr_t* a_mask, concurrent_locality_t** a_locality, size_t n_locality, stmt_t** a_body, size_t n_body, trivia_t* a_t_inside, trivia_t* a_trivia) {
        DoConcurrentLoop_t *n;
        n = al.make_new<DoConcurrentLoop_t>();
        n->base.type = stmtType::DoConcurrentLoop;
        n->base.base.type = astType::stmt;
        n->base.base.loc = a_loc;
        n->m_label = a_label;
        n->m_stmt_name = a_stmt_name;
        n->m_control = a_control;
        n->n_control = n_control;
        n->m_mask = a_mask;
        n->m_locality = a_locality;
        n->n_locality = n_locality;
        n->m_body = a_body;
        n->n_body = n_body;
        n->m_t_inside = a_t_inside;
        n->m_trivia = a_trivia;
        return (ast_t*)n;
    }

    struct DoLoop_t // Constructor
    {
        const static stmtType class_type = stmtType::DoLoop;
        typedef stmt_t parent_type;
        stmt_t base;
        int64_t m_label;
        char* m_stmt_name;
        int64_t m_do_label;
        char* m_var;
        expr_t* m_start;
        expr_t* m_end;
        expr_t* m_increment;
        stmt_t** m_body; size_t n_body; // Sequence
        trivia_t* m_t_inside;
        trivia_t* m_trivia;
    };
    static inline ast_t* make_DoLoop_t(Allocator &al, const Location &a_loc, int64_t a_label, char* a_stmt_name, int64_t a_do_label, char* a_var, expr_t* a_start, expr_t* a_end, expr_t* a_increment, stmt_t** a_body, size_t n_body, trivia_t* a_t_inside, trivia_t* a_trivia) {
        DoLoop_t *n;
        n = al.make_new<DoLoop_t>();
        n->base.type = stmtType::DoLoop;
        n->base.base.type = astType::stmt;
        n->base.base.loc = a_loc;
        n->m_label = a_label;
        n->m_stmt_name = a_stmt_name;
        n->m_do_label = a_do_label;
        n->m_var = a_var;
        n->m_start = a_start;
        n->m_end = a_end;
        n->m_increment = a_increment;
        n->m_body = a_body;
        n->n_body = n_body;
        n->m_t_inside = a_t_inside;
        n->m_trivia = a_trivia;
        return (ast_t*)n;
    }

    struct ForAll_t // Constructor
    {
        const static stmtType class_type = stmtType::ForAll;
        typedef stmt_t parent_type;
        stmt_t base;
        int64_t m_label;
        char* m_stmt_name;
        concurrent_control_t** m_control; size_t n_control; // Sequence
        expr_t* m_mask;
        concurrent_locality_t** m_locality; size_t n_locality; // Sequence
        stmt_t** m_body; size_t n_body; // Sequence
        trivia_t* m_t_inside;
        trivia_t* m_trivia;
    };
    static inline ast_t* make_ForAll_t(Allocator &al, const Location &a_loc, int64_t a_label, char* a_stmt_name, concurrent_control_t** a_control, size_t n_control, expr_t* a_mask, concurrent_locality_t** a_locality, size_t n_locality, stmt_t** a_body, size_t n_body, trivia_t* a_t_inside, trivia_t* a_trivia) {
        ForAll_t *n;
        n = al.make_new<ForAll_t>();
        n->base.type = stmtType::ForAll;
        n->base.base.type = astType::stmt;
        n->base.base.loc = a_loc;
        n->m_label = a_label;
        n->m_stmt_name = a_stmt_name;
        n->m_control = a_control;
        n->n_control = n_control;
        n->m_mask = a_mask;
        n->m_locality = a_locality;
        n->n_locality = n_locality;
        n->m_body = a_body;
        n->n_body = n_body;
        n->m_t_inside = a_t_inside;
        n->m_trivia = a_trivia;
        return (ast_t*)n;
    }

    struct If_t // Constructor
    {
        const static stmtType class_type = stmtType::If;
        typedef stmt_t parent_type;
        stmt_t base;
        int64_t m_label;
        char* m_stmt_name;
        expr_t* m_test;
        stmt_t** m_body; size_t n_body; // Sequence
        stmt_t** m_orelse; size_t n_orelse; // Sequence
        trivia_t* m_if_trivia;
        trivia_t* m_else_trivia;
        trivia_t* m_trivia;
    };
    static inline ast_t* make_If_t(Allocator &al, const Location &a_loc, int64_t a_label, char* a_stmt_name, expr_t* a_test, stmt_t** a_body, size_t n_body, stmt_t** a_orelse, size_t n_orelse, trivia_t* a_if_trivia, trivia_t* a_else_trivia, trivia_t* a_trivia) {
        If_t *n;
        n = al.make_new<If_t>();
        n->base.type = stmtType::If;
        n->base.base.type = astType::stmt;
        n->base.base.loc = a_loc;
        n->m_label = a_label;
        n->m_stmt_name = a_stmt_name;
        n->m_test = a_test;
        n->m_body = a_body;
        n->n_body = n_body;
        n->m_orelse = a_orelse;
        n->n_orelse = n_orelse;
        n->m_if_trivia = a_if_trivia;
        n->m_else_trivia = a_else_trivia;
        n->m_trivia = a_trivia;
        return (ast_t*)n;
    }

    struct IfArithmetic_t // Constructor
    {
        const static stmtType class_type = stmtType::IfArithmetic;
        typedef stmt_t parent_type;
        stmt_t base;
        int64_t m_label;
        char* m_stmt_name;
        expr_t* m_test;
        int64_t m_lt_label;
        int64_t m_eq_label;
        int64_t m_gt_label;
        trivia_t* m_trivia;
    };
    static inline ast_t* make_IfArithmetic_t(Allocator &al, const Location &a_loc, int64_t a_label, char* a_stmt_name, expr_t* a_test, int64_t a_lt_label, int64_t a_eq_label, int64_t a_gt_label, trivia_t* a_trivia) {
        IfArithmetic_t *n;
        n = al.make_new<IfArithmetic_t>();
        n->base.type = stmtType::IfArithmetic;
        n->base.base.type = astType::stmt;
        n->base.base.loc = a_loc;
        n->m_label = a_label;
        n->m_stmt_name = a_stmt_name;
        n->m_test = a_test;
        n->m_lt_label = a_lt_label;
        n->m_eq_label = a_eq_label;
        n->m_gt_label = a_gt_label;
        n->m_trivia = a_trivia;
        return (ast_t*)n;
    }

    struct Select_t // Constructor
    {
        const static stmtType class_type = stmtType::Select;
        typedef stmt_t parent_type;
        stmt_t base;
        int64_t m_label;
        char* m_stmt_name;
        expr_t* m_test;
        case_stmt_t** m_body; size_t n_body; // Sequence
        trivia_t* m_t_inside;
        trivia_t* m_trivia;
    };
    static inline ast_t* make_Select_t(Allocator &al, const Location &a_loc, int64_t a_label, char* a_stmt_name, expr_t* a_test, case_stmt_t** a_body, size_t n_body, trivia_t* a_t_inside, trivia_t* a_trivia) {
        Select_t *n;
        n = al.make_new<Select_t>();
        n->base.type = stmtType::Select;
        n->base.base.type = astType::stmt;
        n->base.base.loc = a_loc;
        n->m_label = a_label;
        n->m_stmt_name = a_stmt_name;
        n->m_test = a_test;
        n->m_body = a_body;
        n->n_body = n_body;
        n->m_t_inside = a_t_inside;
        n->m_trivia = a_trivia;
        return (ast_t*)n;
    }

    struct SelectRank_t // Constructor
    {
        const static stmtType class_type = stmtType::SelectRank;
        typedef stmt_t parent_type;
        stmt_t base;
        int64_t m_label;
        char* m_stmt_name;
        char* m_assoc_name;
        expr_t* m_selector;
        rank_stmt_t** m_body; size_t n_body; // Sequence
        trivia_t* m_t_inside;
        trivia_t* m_trivia;
    };
    static inline ast_t* make_SelectRank_t(Allocator &al, const Location &a_loc, int64_t a_label, char* a_stmt_name, char* a_assoc_name, expr_t* a_selector, rank_stmt_t** a_body, size_t n_body, trivia_t* a_t_inside, trivia_t* a_trivia) {
        SelectRank_t *n;
        n = al.make_new<SelectRank_t>();
        n->base.type = stmtType::SelectRank;
        n->base.base.type = astType::stmt;
        n->base.base.loc = a_loc;
        n->m_label = a_label;
        n->m_stmt_name = a_stmt_name;
        n->m_assoc_name = a_assoc_name;
        n->m_selector = a_selector;
        n->m_body = a_body;
        n->n_body = n_body;
        n->m_t_inside = a_t_inside;
        n->m_trivia = a_trivia;
        return (ast_t*)n;
    }

    struct SelectType_t // Constructor
    {
        const static stmtType class_type = stmtType::SelectType;
        typedef stmt_t parent_type;
        stmt_t base;
        int64_t m_label;
        char* m_stmt_name;
        char* m_assoc_name;
        expr_t* m_selector;
        type_stmt_t** m_body; size_t n_body; // Sequence
        trivia_t* m_t_inside;
        trivia_t* m_trivia;
    };
    static inline ast_t* make_SelectType_t(Allocator &al, const Location &a_loc, int64_t a_label, char* a_stmt_name, char* a_assoc_name, expr_t* a_selector, type_stmt_t** a_body, size_t n_body, trivia_t* a_t_inside, trivia_t* a_trivia) {
        SelectType_t *n;
        n = al.make_new<SelectType_t>();
        n->base.type = stmtType::SelectType;
        n->base.base.type = astType::stmt;
        n->base.base.loc = a_loc;
        n->m_label = a_label;
        n->m_stmt_name = a_stmt_name;
        n->m_assoc_name = a_assoc_name;
        n->m_selector = a_selector;
        n->m_body = a_body;
        n->n_body = n_body;
        n->m_t_inside = a_t_inside;
        n->m_trivia = a_trivia;
        return (ast_t*)n;
    }

    struct Where_t // Constructor
    {
        const static stmtType class_type = stmtType::Where;
        typedef stmt_t parent_type;
        stmt_t base;
        int64_t m_label;
        char* m_stmt_name;
        expr_t* m_test;
        stmt_t** m_body; size_t n_body; // Sequence
        stmt_t** m_orelse; size_t n_orelse; // Sequence
        trivia_t* m_t_inside;
        trivia_t* m_trivia;
    };
    static inline ast_t* make_Where_t(Allocator &al, const Location &a_loc, int64_t a_label, char* a_stmt_name, expr_t* a_test, stmt_t** a_body, size_t n_body, stmt_t** a_orelse, size_t n_orelse, trivia_t* a_t_inside, trivia_t* a_trivia) {
        Where_t *n;
        n = al.make_new<Where_t>();
        n->base.type = stmtType::Where;
        n->base.base.type = astType::stmt;
        n->base.base.loc = a_loc;
        n->m_label = a_label;
        n->m_stmt_name = a_stmt_name;
        n->m_test = a_test;
        n->m_body = a_body;
        n->n_body = n_body;
        n->m_orelse = a_orelse;
        n->n_orelse = n_orelse;
        n->m_t_inside = a_t_inside;
        n->m_trivia = a_trivia;
        return (ast_t*)n;
    }

    struct WhileLoop_t // Constructor
    {
        const static stmtType class_type = stmtType::WhileLoop;
        typedef stmt_t parent_type;
        stmt_t base;
        int64_t m_label;
        char* m_stmt_name;
        expr_t* m_test;
        stmt_t** m_body; size_t n_body; // Sequence
        trivia_t* m_t_inside;
        trivia_t* m_trivia;
    };
    static inline ast_t* make_WhileLoop_t(Allocator &al, const Location &a_loc, int64_t a_label, char* a_stmt_name, expr_t* a_test, stmt_t** a_body, size_t n_body, trivia_t* a_t_inside, trivia_t* a_trivia) {
        WhileLoop_t *n;
        n = al.make_new<WhileLoop_t>();
        n->base.type = stmtType::WhileLoop;
        n->base.base.type = astType::stmt;
        n->base.base.loc = a_loc;
        n->m_label = a_label;
        n->m_stmt_name = a_stmt_name;
        n->m_test = a_test;
        n->m_body = a_body;
        n->n_body = n_body;
        n->m_t_inside = a_t_inside;
        n->m_trivia = a_trivia;
        return (ast_t*)n;
    }



enum exprType // Types
{
    BoolOp, BinOp, DefBinOp, StrOp, UnaryOp, DefUnaryOp, Compare, FuncCallOrArray, CoarrayRef, ArrayInitializer, ImpliedDoLoop, Num, Real, Complex, String, Substring, BOZ, Name, Logical, DataImpliedDo, Parenthesis
};

struct expr_t // Sum
{
    const static astType class_type = astType::expr;
    ast_t base;
    exprType type;
};

    struct BoolOp_t // Constructor
    {
        const static exprType class_type = exprType::BoolOp;
        typedef expr_t parent_type;
        expr_t base;
        expr_t* m_left;
        boolopType m_op;
        expr_t* m_right;
    };
    static inline ast_t* make_BoolOp_t(Allocator &al, const Location &a_loc, expr_t* a_left, boolopType a_op, expr_t* a_right) {
        BoolOp_t *n;
        n = al.make_new<BoolOp_t>();
        n->base.type = exprType::BoolOp;
        n->base.base.type = astType::expr;
        n->base.base.loc = a_loc;
        n->m_left = a_left;
        n->m_op = a_op;
        n->m_right = a_right;
        return (ast_t*)n;
    }

    struct BinOp_t // Constructor
    {
        const static exprType class_type = exprType::BinOp;
        typedef expr_t parent_type;
        expr_t base;
        expr_t* m_left;
        operatorType m_op;
        expr_t* m_right;
    };
    static inline ast_t* make_BinOp_t(Allocator &al, const Location &a_loc, expr_t* a_left, operatorType a_op, expr_t* a_right) {
        BinOp_t *n;
        n = al.make_new<BinOp_t>();
        n->base.type = exprType::BinOp;
        n->base.base.type = astType::expr;
        n->base.base.loc = a_loc;
        n->m_left = a_left;
        n->m_op = a_op;
        n->m_right = a_right;
        return (ast_t*)n;
    }

    struct DefBinOp_t // Constructor
    {
        const static exprType class_type = exprType::DefBinOp;
        typedef expr_t parent_type;
        expr_t base;
        expr_t* m_left;
        char* m_op;
        expr_t* m_right;
    };
    static inline ast_t* make_DefBinOp_t(Allocator &al, const Location &a_loc, expr_t* a_left, char* a_op, expr_t* a_right) {
        DefBinOp_t *n;
        n = al.make_new<DefBinOp_t>();
        n->base.type = exprType::DefBinOp;
        n->base.base.type = astType::expr;
        n->base.base.loc = a_loc;
        n->m_left = a_left;
        n->m_op = a_op;
        n->m_right = a_right;
        return (ast_t*)n;
    }

    struct StrOp_t // Constructor
    {
        const static exprType class_type = exprType::StrOp;
        typedef expr_t parent_type;
        expr_t base;
        expr_t* m_left;
        stroperatorType m_op;
        expr_t* m_right;
    };
    static inline ast_t* make_StrOp_t(Allocator &al, const Location &a_loc, expr_t* a_left, stroperatorType a_op, expr_t* a_right) {
        StrOp_t *n;
        n = al.make_new<StrOp_t>();
        n->base.type = exprType::StrOp;
        n->base.base.type = astType::expr;
        n->base.base.loc = a_loc;
        n->m_left = a_left;
        n->m_op = a_op;
        n->m_right = a_right;
        return (ast_t*)n;
    }

    struct UnaryOp_t // Constructor
    {
        const static exprType class_type = exprType::UnaryOp;
        typedef expr_t parent_type;
        expr_t base;
        unaryopType m_op;
        expr_t* m_operand;
    };
    static inline ast_t* make_UnaryOp_t(Allocator &al, const Location &a_loc, unaryopType a_op, expr_t* a_operand) {
        UnaryOp_t *n;
        n = al.make_new<UnaryOp_t>();
        n->base.type = exprType::UnaryOp;
        n->base.base.type = astType::expr;
        n->base.base.loc = a_loc;
        n->m_op = a_op;
        n->m_operand = a_operand;
        return (ast_t*)n;
    }

    struct DefUnaryOp_t // Constructor
    {
        const static exprType class_type = exprType::DefUnaryOp;
        typedef expr_t parent_type;
        expr_t base;
        char* m_op;
        expr_t* m_operand;
    };
    static inline ast_t* make_DefUnaryOp_t(Allocator &al, const Location &a_loc, char* a_op, expr_t* a_operand) {
        DefUnaryOp_t *n;
        n = al.make_new<DefUnaryOp_t>();
        n->base.type = exprType::DefUnaryOp;
        n->base.base.type = astType::expr;
        n->base.base.loc = a_loc;
        n->m_op = a_op;
        n->m_operand = a_operand;
        return (ast_t*)n;
    }

    struct Compare_t // Constructor
    {
        const static exprType class_type = exprType::Compare;
        typedef expr_t parent_type;
        expr_t base;
        expr_t* m_left;
        cmpopType m_op;
        expr_t* m_right;
    };
    static inline ast_t* make_Compare_t(Allocator &al, const Location &a_loc, expr_t* a_left, cmpopType a_op, expr_t* a_right) {
        Compare_t *n;
        n = al.make_new<Compare_t>();
        n->base.type = exprType::Compare;
        n->base.base.type = astType::expr;
        n->base.base.loc = a_loc;
        n->m_left = a_left;
        n->m_op = a_op;
        n->m_right = a_right;
        return (ast_t*)n;
    }

    struct FuncCallOrArray_t // Constructor
    {
        const static exprType class_type = exprType::FuncCallOrArray;
        typedef expr_t parent_type;
        expr_t base;
        char* m_func;
        struct_member_t* m_member; size_t n_member; // Sequence
        fnarg_t* m_args; size_t n_args; // Sequence
        keyword_t* m_keywords; size_t n_keywords; // Sequence
        fnarg_t* m_subargs; size_t n_subargs; // Sequence
        decl_attribute_t** m_temp_args; size_t n_temp_args; // Sequence
    };
    static inline ast_t* make_FuncCallOrArray_t(Allocator &al, const Location &a_loc, char* a_func, struct_member_t* a_member, size_t n_member, fnarg_t* a_args, size_t n_args, keyword_t* a_keywords, size_t n_keywords, fnarg_t* a_subargs, size_t n_subargs, decl_attribute_t** a_temp_args, size_t n_temp_args) {
        FuncCallOrArray_t *n;
        n = al.make_new<FuncCallOrArray_t>();
        n->base.type = exprType::FuncCallOrArray;
        n->base.base.type = astType::expr;
        n->base.base.loc = a_loc;
        n->m_func = a_func;
        n->m_member = a_member;
        n->n_member = n_member;
        n->m_args = a_args;
        n->n_args = n_args;
        n->m_keywords = a_keywords;
        n->n_keywords = n_keywords;
        n->m_subargs = a_subargs;
        n->n_subargs = n_subargs;
        n->m_temp_args = a_temp_args;
        n->n_temp_args = n_temp_args;
        return (ast_t*)n;
    }

    struct CoarrayRef_t // Constructor
    {
        const static exprType class_type = exprType::CoarrayRef;
        typedef expr_t parent_type;
        expr_t base;
        char* m_name;
        struct_member_t* m_member; size_t n_member; // Sequence
        fnarg_t* m_args; size_t n_args; // Sequence
        keyword_t* m_fnkw; size_t n_fnkw; // Sequence
        coarrayarg_t* m_coargs; size_t n_coargs; // Sequence
        keyword_t* m_cokw; size_t n_cokw; // Sequence
    };
    static inline ast_t* make_CoarrayRef_t(Allocator &al, const Location &a_loc, char* a_name, struct_member_t* a_member, size_t n_member, fnarg_t* a_args, size_t n_args, keyword_t* a_fnkw, size_t n_fnkw, coarrayarg_t* a_coargs, size_t n_coargs, keyword_t* a_cokw, size_t n_cokw) {
        CoarrayRef_t *n;
        n = al.make_new<CoarrayRef_t>();
        n->base.type = exprType::CoarrayRef;
        n->base.base.type = astType::expr;
        n->base.base.loc = a_loc;
        n->m_name = a_name;
        n->m_member = a_member;
        n->n_member = n_member;
        n->m_args = a_args;
        n->n_args = n_args;
        n->m_fnkw = a_fnkw;
        n->n_fnkw = n_fnkw;
        n->m_coargs = a_coargs;
        n->n_coargs = n_coargs;
        n->m_cokw = a_cokw;
        n->n_cokw = n_cokw;
        return (ast_t*)n;
    }

    struct ArrayInitializer_t // Constructor
    {
        const static exprType class_type = exprType::ArrayInitializer;
        typedef expr_t parent_type;
        expr_t base;
        decl_attribute_t* m_vartype;
        char* m_classtype;
        expr_t** m_args; size_t n_args; // Sequence
    };
    static inline ast_t* make_ArrayInitializer_t(Allocator &al, const Location &a_loc, decl_attribute_t* a_vartype, char* a_classtype, expr_t** a_args, size_t n_args) {
        ArrayInitializer_t *n;
        n = al.make_new<ArrayInitializer_t>();
        n->base.type = exprType::ArrayInitializer;
        n->base.base.type = astType::expr;
        n->base.base.loc = a_loc;
        n->m_vartype = a_vartype;
        n->m_classtype = a_classtype;
        n->m_args = a_args;
        n->n_args = n_args;
        return (ast_t*)n;
    }

    struct ImpliedDoLoop_t // Constructor
    {
        const static exprType class_type = exprType::ImpliedDoLoop;
        typedef expr_t parent_type;
        expr_t base;
        expr_t** m_values; size_t n_values; // Sequence
        char* m_var;
        expr_t* m_start;
        expr_t* m_end;
        expr_t* m_increment;
    };
    static inline ast_t* make_ImpliedDoLoop_t(Allocator &al, const Location &a_loc, expr_t** a_values, size_t n_values, char* a_var, expr_t* a_start, expr_t* a_end, expr_t* a_increment) {
        ImpliedDoLoop_t *n;
        n = al.make_new<ImpliedDoLoop_t>();
        n->base.type = exprType::ImpliedDoLoop;
        n->base.base.type = astType::expr;
        n->base.base.loc = a_loc;
        n->m_values = a_values;
        n->n_values = n_values;
        n->m_var = a_var;
        n->m_start = a_start;
        n->m_end = a_end;
        n->m_increment = a_increment;
        return (ast_t*)n;
    }

    struct Num_t // Constructor
    {
        const static exprType class_type = exprType::Num;
        typedef expr_t parent_type;
        expr_t base;
        int64_t m_n;
        char* m_kind;
    };
    static inline ast_t* make_Num_t(Allocator &al, const Location &a_loc, int64_t a_n, char* a_kind) {
        Num_t *n;
        n = al.make_new<Num_t>();
        n->base.type = exprType::Num;
        n->base.base.type = astType::expr;
        n->base.base.loc = a_loc;
        n->m_n = a_n;
        n->m_kind = a_kind;
        return (ast_t*)n;
    }

    struct Real_t // Constructor
    {
        const static exprType class_type = exprType::Real;
        typedef expr_t parent_type;
        expr_t base;
        char* m_n;
    };
    static inline ast_t* make_Real_t(Allocator &al, const Location &a_loc, char* a_n) {
        Real_t *n;
        n = al.make_new<Real_t>();
        n->base.type = exprType::Real;
        n->base.base.type = astType::expr;
        n->base.base.loc = a_loc;
        n->m_n = a_n;
        return (ast_t*)n;
    }

    struct Complex_t // Constructor
    {
        const static exprType class_type = exprType::Complex;
        typedef expr_t parent_type;
        expr_t base;
        expr_t* m_re;
        expr_t* m_im;
    };
    static inline ast_t* make_Complex_t(Allocator &al, const Location &a_loc, expr_t* a_re, expr_t* a_im) {
        Complex_t *n;
        n = al.make_new<Complex_t>();
        n->base.type = exprType::Complex;
        n->base.base.type = astType::expr;
        n->base.base.loc = a_loc;
        n->m_re = a_re;
        n->m_im = a_im;
        return (ast_t*)n;
    }

    struct String_t // Constructor
    {
        const static exprType class_type = exprType::String;
        typedef expr_t parent_type;
        expr_t base;
        char* m_s;
    };
    static inline ast_t* make_String_t(Allocator &al, const Location &a_loc, char* a_s) {
        String_t *n;
        n = al.make_new<String_t>();
        n->base.type = exprType::String;
        n->base.base.type = astType::expr;
        n->base.base.loc = a_loc;
        n->m_s = a_s;
        return (ast_t*)n;
    }

    struct Substring_t // Constructor
    {
        const static exprType class_type = exprType::Substring;
        typedef expr_t parent_type;
        expr_t base;
        char* m_s;
        fnarg_t* m_args; size_t n_args; // Sequence
    };
    static inline ast_t* make_Substring_t(Allocator &al, const Location &a_loc, char* a_s, fnarg_t* a_args, size_t n_args) {
        Substring_t *n;
        n = al.make_new<Substring_t>();
        n->base.type = exprType::Substring;
        n->base.base.type = astType::expr;
        n->base.base.loc = a_loc;
        n->m_s = a_s;
        n->m_args = a_args;
        n->n_args = n_args;
        return (ast_t*)n;
    }

    struct BOZ_t // Constructor
    {
        const static exprType class_type = exprType::BOZ;
        typedef expr_t parent_type;
        expr_t base;
        char* m_s;
    };
    static inline ast_t* make_BOZ_t(Allocator &al, const Location &a_loc, char* a_s) {
        BOZ_t *n;
        n = al.make_new<BOZ_t>();
        n->base.type = exprType::BOZ;
        n->base.base.type = astType::expr;
        n->base.base.loc = a_loc;
        n->m_s = a_s;
        return (ast_t*)n;
    }

    struct Name_t // Constructor
    {
        const static exprType class_type = exprType::Name;
        typedef expr_t parent_type;
        expr_t base;
        char* m_id;
        struct_member_t* m_member; size_t n_member; // Sequence
    };
    static inline ast_t* make_Name_t(Allocator &al, const Location &a_loc, char* a_id, struct_member_t* a_member, size_t n_member) {
        Name_t *n;
        n = al.make_new<Name_t>();
        n->base.type = exprType::Name;
        n->base.base.type = astType::expr;
        n->base.base.loc = a_loc;
        n->m_id = a_id;
        n->m_member = a_member;
        n->n_member = n_member;
        return (ast_t*)n;
    }

    struct Logical_t // Constructor
    {
        const static exprType class_type = exprType::Logical;
        typedef expr_t parent_type;
        expr_t base;
        bool m_value;
    };
    static inline ast_t* make_Logical_t(Allocator &al, const Location &a_loc, bool a_value) {
        Logical_t *n;
        n = al.make_new<Logical_t>();
        n->base.type = exprType::Logical;
        n->base.base.type = astType::expr;
        n->base.base.loc = a_loc;
        n->m_value = a_value;
        return (ast_t*)n;
    }

    struct DataImpliedDo_t // Constructor
    {
        const static exprType class_type = exprType::DataImpliedDo;
        typedef expr_t parent_type;
        expr_t base;
        expr_t** m_object_list; size_t n_object_list; // Sequence
        decl_attribute_t* m_type;
        char* m_var;
        expr_t* m_start;
        expr_t* m_end;
        expr_t* m_increment;
    };
    static inline ast_t* make_DataImpliedDo_t(Allocator &al, const Location &a_loc, expr_t** a_object_list, size_t n_object_list, decl_attribute_t* a_type, char* a_var, expr_t* a_start, expr_t* a_end, expr_t* a_increment) {
        DataImpliedDo_t *n;
        n = al.make_new<DataImpliedDo_t>();
        n->base.type = exprType::DataImpliedDo;
        n->base.base.type = astType::expr;
        n->base.base.loc = a_loc;
        n->m_object_list = a_object_list;
        n->n_object_list = n_object_list;
        n->m_type = a_type;
        n->m_var = a_var;
        n->m_start = a_start;
        n->m_end = a_end;
        n->m_increment = a_increment;
        return (ast_t*)n;
    }

    struct Parenthesis_t // Constructor
    {
        const static exprType class_type = exprType::Parenthesis;
        typedef expr_t parent_type;
        expr_t base;
        expr_t* m_operand;
    };
    static inline ast_t* make_Parenthesis_t(Allocator &al, const Location &a_loc, expr_t* a_operand) {
        Parenthesis_t *n;
        n = al.make_new<Parenthesis_t>();
        n->base.type = exprType::Parenthesis;
        n->base.base.type = astType::expr;
        n->base.base.loc = a_loc;
        n->m_operand = a_operand;
        return (ast_t*)n;
    }



enum triviaType // Types
{
    TriviaNode
};

struct trivia_t // Sum
{
    const static astType class_type = astType::trivia;
    ast_t base;
    triviaType type;
};

    struct TriviaNode_t // Constructor
    {
        const static triviaType class_type = triviaType::TriviaNode;
        typedef trivia_t parent_type;
        trivia_t base;
        trivia_node_t** m_inside; size_t n_inside; // Sequence
        trivia_node_t** m_after; size_t n_after; // Sequence
    };
    static inline ast_t* make_TriviaNode_t(Allocator &al, const Location &a_loc, trivia_node_t** a_inside, size_t n_inside, trivia_node_t** a_after, size_t n_after) {
        TriviaNode_t *n;
        n = al.make_new<TriviaNode_t>();
        n->base.type = triviaType::TriviaNode;
        n->base.base.type = astType::trivia;
        n->base.base.loc = a_loc;
        n->m_inside = a_inside;
        n->n_inside = n_inside;
        n->m_after = a_after;
        n->n_after = n_after;
        return (ast_t*)n;
    }



enum trivia_nodeType // Types
{
    Comment, EOLComment, EndOfLine, Semicolon
};

struct trivia_node_t // Sum
{
    const static astType class_type = astType::trivia_node;
    ast_t base;
    trivia_nodeType type;
};

    struct Comment_t // Constructor
    {
        const static trivia_nodeType class_type = trivia_nodeType::Comment;
        typedef trivia_node_t parent_type;
        trivia_node_t base;
        char* m_comment;
    };
    static inline ast_t* make_Comment_t(Allocator &al, const Location &a_loc, char* a_comment) {
        Comment_t *n;
        n = al.make_new<Comment_t>();
        n->base.type = trivia_nodeType::Comment;
        n->base.base.type = astType::trivia_node;
        n->base.base.loc = a_loc;
        n->m_comment = a_comment;
        return (ast_t*)n;
    }

    struct EOLComment_t // Constructor
    {
        const static trivia_nodeType class_type = trivia_nodeType::EOLComment;
        typedef trivia_node_t parent_type;
        trivia_node_t base;
        char* m_comment;
    };
    static inline ast_t* make_EOLComment_t(Allocator &al, const Location &a_loc, char* a_comment) {
        EOLComment_t *n;
        n = al.make_new<EOLComment_t>();
        n->base.type = trivia_nodeType::EOLComment;
        n->base.base.type = astType::trivia_node;
        n->base.base.loc = a_loc;
        n->m_comment = a_comment;
        return (ast_t*)n;
    }

    struct EndOfLine_t // Constructor
    {
        const static trivia_nodeType class_type = trivia_nodeType::EndOfLine;
        typedef trivia_node_t parent_type;
        trivia_node_t base;
    };
    static inline ast_t* make_EndOfLine_t(Allocator &al, const Location &a_loc) {
        EndOfLine_t *n;
        n = al.make_new<EndOfLine_t>();
        n->base.type = trivia_nodeType::EndOfLine;
        n->base.base.type = astType::trivia_node;
        n->base.base.loc = a_loc;
        return (ast_t*)n;
    }

    struct Semicolon_t // Constructor
    {
        const static trivia_nodeType class_type = trivia_nodeType::Semicolon;
        typedef trivia_node_t parent_type;
        trivia_node_t base;
    };
    static inline ast_t* make_Semicolon_t(Allocator &al, const Location &a_loc) {
        Semicolon_t *n;
        n = al.make_new<Semicolon_t>();
        n->base.type = trivia_nodeType::Semicolon;
        n->base.base.type = astType::trivia_node;
        n->base.base.loc = a_loc;
        return (ast_t*)n;
    }



enum procedure_declType // Types
{
    DerivedTypeProc, GenericOperator, GenericDefinedOperator, GenericAssignment, GenericName, GenericWrite, GenericRead, FinalName, Private
};

struct procedure_decl_t // Sum
{
    const static astType class_type = astType::procedure_decl;
    ast_t base;
    procedure_declType type;
};

    struct DerivedTypeProc_t // Constructor
    {
        const static procedure_declType class_type = procedure_declType::DerivedTypeProc;
        typedef procedure_decl_t parent_type;
        procedure_decl_t base;
        char* m_name;
        decl_attribute_t** m_attr; size_t n_attr; // Sequence
        use_symbol_t** m_symbols; size_t n_symbols; // Sequence
        trivia_t* m_trivia;
    };
    static inline ast_t* make_DerivedTypeProc_t(Allocator &al, const Location &a_loc, char* a_name, decl_attribute_t** a_attr, size_t n_attr, use_symbol_t** a_symbols, size_t n_symbols, trivia_t* a_trivia) {
        DerivedTypeProc_t *n;
        n = al.make_new<DerivedTypeProc_t>();
        n->base.type = procedure_declType::DerivedTypeProc;
        n->base.base.type = astType::procedure_decl;
        n->base.base.loc = a_loc;
        n->m_name = a_name;
        n->m_attr = a_attr;
        n->n_attr = n_attr;
        n->m_symbols = a_symbols;
        n->n_symbols = n_symbols;
        n->m_trivia = a_trivia;
        return (ast_t*)n;
    }

    struct GenericOperator_t // Constructor
    {
        const static procedure_declType class_type = procedure_declType::GenericOperator;
        typedef procedure_decl_t parent_type;
        procedure_decl_t base;
        decl_attribute_t** m_attr; size_t n_attr; // Sequence
        intrinsicopType m_op;
        char** m_names; size_t n_names; // Sequence
        trivia_t* m_trivia;
    };
    static inline ast_t* make_GenericOperator_t(Allocator &al, const Location &a_loc, decl_attribute_t** a_attr, size_t n_attr, intrinsicopType a_op, char** a_names, size_t n_names, trivia_t* a_trivia) {
        GenericOperator_t *n;
        n = al.make_new<GenericOperator_t>();
        n->base.type = procedure_declType::GenericOperator;
        n->base.base.type = astType::procedure_decl;
        n->base.base.loc = a_loc;
        n->m_attr = a_attr;
        n->n_attr = n_attr;
        n->m_op = a_op;
        n->m_names = a_names;
        n->n_names = n_names;
        n->m_trivia = a_trivia;
        return (ast_t*)n;
    }

    struct GenericDefinedOperator_t // Constructor
    {
        const static procedure_declType class_type = procedure_declType::GenericDefinedOperator;
        typedef procedure_decl_t parent_type;
        procedure_decl_t base;
        decl_attribute_t** m_attr; size_t n_attr; // Sequence
        char* m_optype;
        char** m_names; size_t n_names; // Sequence
        trivia_t* m_trivia;
    };
    static inline ast_t* make_GenericDefinedOperator_t(Allocator &al, const Location &a_loc, decl_attribute_t** a_attr, size_t n_attr, char* a_optype, char** a_names, size_t n_names, trivia_t* a_trivia) {
        GenericDefinedOperator_t *n;
        n = al.make_new<GenericDefinedOperator_t>();
        n->base.type = procedure_declType::GenericDefinedOperator;
        n->base.base.type = astType::procedure_decl;
        n->base.base.loc = a_loc;
        n->m_attr = a_attr;
        n->n_attr = n_attr;
        n->m_optype = a_optype;
        n->m_names = a_names;
        n->n_names = n_names;
        n->m_trivia = a_trivia;
        return (ast_t*)n;
    }

    struct GenericAssignment_t // Constructor
    {
        const static procedure_declType class_type = procedure_declType::GenericAssignment;
        typedef procedure_decl_t parent_type;
        procedure_decl_t base;
        decl_attribute_t** m_attr; size_t n_attr; // Sequence
        char** m_names; size_t n_names; // Sequence
        trivia_t* m_trivia;
    };
    static inline ast_t* make_GenericAssignment_t(Allocator &al, const Location &a_loc, decl_attribute_t** a_attr, size_t n_attr, char** a_names, size_t n_names, trivia_t* a_trivia) {
        GenericAssignment_t *n;
        n = al.make_new<GenericAssignment_t>();
        n->base.type = procedure_declType::GenericAssignment;
        n->base.base.type = astType::procedure_decl;
        n->base.base.loc = a_loc;
        n->m_attr = a_attr;
        n->n_attr = n_attr;
        n->m_names = a_names;
        n->n_names = n_names;
        n->m_trivia = a_trivia;
        return (ast_t*)n;
    }

    struct GenericName_t // Constructor
    {
        const static procedure_declType class_type = procedure_declType::GenericName;
        typedef procedure_decl_t parent_type;
        procedure_decl_t base;
        decl_attribute_t** m_attr; size_t n_attr; // Sequence
        char* m_name;
        char** m_names; size_t n_names; // Sequence
        trivia_t* m_trivia;
    };
    static inline ast_t* make_GenericName_t(Allocator &al, const Location &a_loc, decl_attribute_t** a_attr, size_t n_attr, char* a_name, char** a_names, size_t n_names, trivia_t* a_trivia) {
        GenericName_t *n;
        n = al.make_new<GenericName_t>();
        n->base.type = procedure_declType::GenericName;
        n->base.base.type = astType::procedure_decl;
        n->base.base.loc = a_loc;
        n->m_attr = a_attr;
        n->n_attr = n_attr;
        n->m_name = a_name;
        n->m_names = a_names;
        n->n_names = n_names;
        n->m_trivia = a_trivia;
        return (ast_t*)n;
    }

    struct GenericWrite_t // Constructor
    {
        const static procedure_declType class_type = procedure_declType::GenericWrite;
        typedef procedure_decl_t parent_type;
        procedure_decl_t base;
        decl_attribute_t** m_attr; size_t n_attr; // Sequence
        char* m_id;
        char** m_names; size_t n_names; // Sequence
        trivia_t* m_trivia;
    };
    static inline ast_t* make_GenericWrite_t(Allocator &al, const Location &a_loc, decl_attribute_t** a_attr, size_t n_attr, char* a_id, char** a_names, size_t n_names, trivia_t* a_trivia) {
        GenericWrite_t *n;
        n = al.make_new<GenericWrite_t>();
        n->base.type = procedure_declType::GenericWrite;
        n->base.base.type = astType::procedure_decl;
        n->base.base.loc = a_loc;
        n->m_attr = a_attr;
        n->n_attr = n_attr;
        n->m_id = a_id;
        n->m_names = a_names;
        n->n_names = n_names;
        n->m_trivia = a_trivia;
        return (ast_t*)n;
    }

    struct GenericRead_t // Constructor
    {
        const static procedure_declType class_type = procedure_declType::GenericRead;
        typedef procedure_decl_t parent_type;
        procedure_decl_t base;
        decl_attribute_t** m_attr; size_t n_attr; // Sequence
        char* m_id;
        char** m_names; size_t n_names; // Sequence
        trivia_t* m_trivia;
    };
    static inline ast_t* make_GenericRead_t(Allocator &al, const Location &a_loc, decl_attribute_t** a_attr, size_t n_attr, char* a_id, char** a_names, size_t n_names, trivia_t* a_trivia) {
        GenericRead_t *n;
        n = al.make_new<GenericRead_t>();
        n->base.type = procedure_declType::GenericRead;
        n->base.base.type = astType::procedure_decl;
        n->base.base.loc = a_loc;
        n->m_attr = a_attr;
        n->n_attr = n_attr;
        n->m_id = a_id;
        n->m_names = a_names;
        n->n_names = n_names;
        n->m_trivia = a_trivia;
        return (ast_t*)n;
    }

    struct FinalName_t // Constructor
    {
        const static procedure_declType class_type = procedure_declType::FinalName;
        typedef procedure_decl_t parent_type;
        procedure_decl_t base;
        char* m_name;
        trivia_t* m_trivia;
    };
    static inline ast_t* make_FinalName_t(Allocator &al, const Location &a_loc, char* a_name, trivia_t* a_trivia) {
        FinalName_t *n;
        n = al.make_new<FinalName_t>();
        n->base.type = procedure_declType::FinalName;
        n->base.base.type = astType::procedure_decl;
        n->base.base.loc = a_loc;
        n->m_name = a_name;
        n->m_trivia = a_trivia;
        return (ast_t*)n;
    }

    struct Private_t // Constructor
    {
        const static procedure_declType class_type = procedure_declType::Private;
        typedef procedure_decl_t parent_type;
        procedure_decl_t base;
        trivia_t* m_trivia;
    };
    static inline ast_t* make_Private_t(Allocator &al, const Location &a_loc, trivia_t* a_trivia) {
        Private_t *n;
        n = al.make_new<Private_t>();
        n->base.type = procedure_declType::Private;
        n->base.base.type = astType::procedure_decl;
        n->base.base.loc = a_loc;
        n->m_trivia = a_trivia;
        return (ast_t*)n;
    }



enum decl_attributeType // Types
{
    AttrBind, AttrDimension, AttrCodimension, AttrEquivalence, AttrExtends, AttrIntent, AttrNamelist, AttrPass, SimpleAttribute, AttrType, AttrAssignment, AttrIntrinsicOperator, AttrDefinedOperator
};

struct decl_attribute_t // Sum
{
    const static astType class_type = astType::decl_attribute;
    ast_t base;
    decl_attributeType type;
};

    struct AttrBind_t // Constructor
    {
        const static decl_attributeType class_type = decl_attributeType::AttrBind;
        typedef decl_attribute_t parent_type;
        decl_attribute_t base;
        bind_t* m_bind;
    };
    static inline ast_t* make_AttrBind_t(Allocator &al, const Location &a_loc, bind_t* a_bind) {
        AttrBind_t *n;
        n = al.make_new<AttrBind_t>();
        n->base.type = decl_attributeType::AttrBind;
        n->base.base.type = astType::decl_attribute;
        n->base.base.loc = a_loc;
        n->m_bind = a_bind;
        return (ast_t*)n;
    }

    struct AttrDimension_t // Constructor
    {
        const static decl_attributeType class_type = decl_attributeType::AttrDimension;
        typedef decl_attribute_t parent_type;
        decl_attribute_t base;
        dimension_t* m_dim; size_t n_dim; // Sequence
    };
    static inline ast_t* make_AttrDimension_t(Allocator &al, const Location &a_loc, dimension_t* a_dim, size_t n_dim) {
        AttrDimension_t *n;
        n = al.make_new<AttrDimension_t>();
        n->base.type = decl_attributeType::AttrDimension;
        n->base.base.type = astType::decl_attribute;
        n->base.base.loc = a_loc;
        n->m_dim = a_dim;
        n->n_dim = n_dim;
        return (ast_t*)n;
    }

    struct AttrCodimension_t // Constructor
    {
        const static decl_attributeType class_type = decl_attributeType::AttrCodimension;
        typedef decl_attribute_t parent_type;
        decl_attribute_t base;
        codimension_t* m_codim; size_t n_codim; // Sequence
    };
    static inline ast_t* make_AttrCodimension_t(Allocator &al, const Location &a_loc, codimension_t* a_codim, size_t n_codim) {
        AttrCodimension_t *n;
        n = al.make_new<AttrCodimension_t>();
        n->base.type = decl_attributeType::AttrCodimension;
        n->base.base.type = astType::decl_attribute;
        n->base.base.loc = a_loc;
        n->m_codim = a_codim;
        n->n_codim = n_codim;
        return (ast_t*)n;
    }

    struct AttrEquivalence_t // Constructor
    {
        const static decl_attributeType class_type = decl_attributeType::AttrEquivalence;
        typedef decl_attribute_t parent_type;
        decl_attribute_t base;
        equi_t* m_args; size_t n_args; // Sequence
    };
    static inline ast_t* make_AttrEquivalence_t(Allocator &al, const Location &a_loc, equi_t* a_args, size_t n_args) {
        AttrEquivalence_t *n;
        n = al.make_new<AttrEquivalence_t>();
        n->base.type = decl_attributeType::AttrEquivalence;
        n->base.base.type = astType::decl_attribute;
        n->base.base.loc = a_loc;
        n->m_args = a_args;
        n->n_args = n_args;
        return (ast_t*)n;
    }

    struct AttrExtends_t // Constructor
    {
        const static decl_attributeType class_type = decl_attributeType::AttrExtends;
        typedef decl_attribute_t parent_type;
        decl_attribute_t base;
        char* m_name;
    };
    static inline ast_t* make_AttrExtends_t(Allocator &al, const Location &a_loc, char* a_name) {
        AttrExtends_t *n;
        n = al.make_new<AttrExtends_t>();
        n->base.type = decl_attributeType::AttrExtends;
        n->base.base.type = astType::decl_attribute;
        n->base.base.loc = a_loc;
        n->m_name = a_name;
        return (ast_t*)n;
    }

    struct AttrIntent_t // Constructor
    {
        const static decl_attributeType class_type = decl_attributeType::AttrIntent;
        typedef decl_attribute_t parent_type;
        decl_attribute_t base;
        attr_intentType m_intent;
    };
    static inline ast_t* make_AttrIntent_t(Allocator &al, const Location &a_loc, attr_intentType a_intent) {
        AttrIntent_t *n;
        n = al.make_new<AttrIntent_t>();
        n->base.type = decl_attributeType::AttrIntent;
        n->base.base.type = astType::decl_attribute;
        n->base.base.loc = a_loc;
        n->m_intent = a_intent;
        return (ast_t*)n;
    }

    struct AttrNamelist_t // Constructor
    {
        const static decl_attributeType class_type = decl_attributeType::AttrNamelist;
        typedef decl_attribute_t parent_type;
        decl_attribute_t base;
        char* m_name;
    };
    static inline ast_t* make_AttrNamelist_t(Allocator &al, const Location &a_loc, char* a_name) {
        AttrNamelist_t *n;
        n = al.make_new<AttrNamelist_t>();
        n->base.type = decl_attributeType::AttrNamelist;
        n->base.base.type = astType::decl_attribute;
        n->base.base.loc = a_loc;
        n->m_name = a_name;
        return (ast_t*)n;
    }

    struct AttrPass_t // Constructor
    {
        const static decl_attributeType class_type = decl_attributeType::AttrPass;
        typedef decl_attribute_t parent_type;
        decl_attribute_t base;
        char* m_name;
    };
    static inline ast_t* make_AttrPass_t(Allocator &al, const Location &a_loc, char* a_name) {
        AttrPass_t *n;
        n = al.make_new<AttrPass_t>();
        n->base.type = decl_attributeType::AttrPass;
        n->base.base.type = astType::decl_attribute;
        n->base.base.loc = a_loc;
        n->m_name = a_name;
        return (ast_t*)n;
    }

    struct SimpleAttribute_t // Constructor
    {
        const static decl_attributeType class_type = decl_attributeType::SimpleAttribute;
        typedef decl_attribute_t parent_type;
        decl_attribute_t base;
        simple_attributeType m_attr;
    };
    static inline ast_t* make_SimpleAttribute_t(Allocator &al, const Location &a_loc, simple_attributeType a_attr) {
        SimpleAttribute_t *n;
        n = al.make_new<SimpleAttribute_t>();
        n->base.type = decl_attributeType::SimpleAttribute;
        n->base.base.type = astType::decl_attribute;
        n->base.base.loc = a_loc;
        n->m_attr = a_attr;
        return (ast_t*)n;
    }

    struct AttrType_t // Constructor
    {
        const static decl_attributeType class_type = decl_attributeType::AttrType;
        typedef decl_attribute_t parent_type;
        decl_attribute_t base;
        decl_typeType m_type;
        kind_item_t* m_kind; size_t n_kind; // Sequence
        decl_attribute_t* m_attr;
        char* m_name;
        symbolType m_sym;
    };
    static inline ast_t* make_AttrType_t(Allocator &al, const Location &a_loc, decl_typeType a_type, kind_item_t* a_kind, size_t n_kind, decl_attribute_t* a_attr, char* a_name, symbolType a_sym) {
        AttrType_t *n;
        n = al.make_new<AttrType_t>();
        n->base.type = decl_attributeType::AttrType;
        n->base.base.type = astType::decl_attribute;
        n->base.base.loc = a_loc;
        n->m_type = a_type;
        n->m_kind = a_kind;
        n->n_kind = n_kind;
        n->m_attr = a_attr;
        n->m_name = a_name;
        n->m_sym = a_sym;
        return (ast_t*)n;
    }

    struct AttrAssignment_t // Constructor
    {
        const static decl_attributeType class_type = decl_attributeType::AttrAssignment;
        typedef decl_attribute_t parent_type;
        decl_attribute_t base;
    };
    static inline ast_t* make_AttrAssignment_t(Allocator &al, const Location &a_loc) {
        AttrAssignment_t *n;
        n = al.make_new<AttrAssignment_t>();
        n->base.type = decl_attributeType::AttrAssignment;
        n->base.base.type = astType::decl_attribute;
        n->base.base.loc = a_loc;
        return (ast_t*)n;
    }

    struct AttrIntrinsicOperator_t // Constructor
    {
        const static decl_attributeType class_type = decl_attributeType::AttrIntrinsicOperator;
        typedef decl_attribute_t parent_type;
        decl_attribute_t base;
        intrinsicopType m_op;
    };
    static inline ast_t* make_AttrIntrinsicOperator_t(Allocator &al, const Location &a_loc, intrinsicopType a_op) {
        AttrIntrinsicOperator_t *n;
        n = al.make_new<AttrIntrinsicOperator_t>();
        n->base.type = decl_attributeType::AttrIntrinsicOperator;
        n->base.base.type = astType::decl_attribute;
        n->base.base.loc = a_loc;
        n->m_op = a_op;
        return (ast_t*)n;
    }

    struct AttrDefinedOperator_t // Constructor
    {
        const static decl_attributeType class_type = decl_attributeType::AttrDefinedOperator;
        typedef decl_attribute_t parent_type;
        decl_attribute_t base;
        char* m_op_name;
    };
    static inline ast_t* make_AttrDefinedOperator_t(Allocator &al, const Location &a_loc, char* a_op_name) {
        AttrDefinedOperator_t *n;
        n = al.make_new<AttrDefinedOperator_t>();
        n->base.type = decl_attributeType::AttrDefinedOperator;
        n->base.base.type = astType::decl_attribute;
        n->base.base.loc = a_loc;
        n->m_op_name = a_op_name;
        return (ast_t*)n;
    }



enum event_attributeType // Types
{
    AttrStat, AttrErrmsg, AttrNewIndex, AttrEventWaitKwArg
};

struct event_attribute_t // Sum
{
    const static astType class_type = astType::event_attribute;
    ast_t base;
    event_attributeType type;
};

    struct AttrStat_t // Constructor
    {
        const static event_attributeType class_type = event_attributeType::AttrStat;
        typedef event_attribute_t parent_type;
        event_attribute_t base;
        char* m_variable;
    };
    static inline ast_t* make_AttrStat_t(Allocator &al, const Location &a_loc, char* a_variable) {
        AttrStat_t *n;
        n = al.make_new<AttrStat_t>();
        n->base.type = event_attributeType::AttrStat;
        n->base.base.type = astType::event_attribute;
        n->base.base.loc = a_loc;
        n->m_variable = a_variable;
        return (ast_t*)n;
    }

    struct AttrErrmsg_t // Constructor
    {
        const static event_attributeType class_type = event_attributeType::AttrErrmsg;
        typedef event_attribute_t parent_type;
        event_attribute_t base;
        char* m_variable;
    };
    static inline ast_t* make_AttrErrmsg_t(Allocator &al, const Location &a_loc, char* a_variable) {
        AttrErrmsg_t *n;
        n = al.make_new<AttrErrmsg_t>();
        n->base.type = event_attributeType::AttrErrmsg;
        n->base.base.type = astType::event_attribute;
        n->base.base.loc = a_loc;
        n->m_variable = a_variable;
        return (ast_t*)n;
    }

    struct AttrNewIndex_t // Constructor
    {
        const static event_attributeType class_type = event_attributeType::AttrNewIndex;
        typedef event_attribute_t parent_type;
        event_attribute_t base;
        expr_t* m_value;
    };
    static inline ast_t* make_AttrNewIndex_t(Allocator &al, const Location &a_loc, expr_t* a_value) {
        AttrNewIndex_t *n;
        n = al.make_new<AttrNewIndex_t>();
        n->base.type = event_attributeType::AttrNewIndex;
        n->base.base.type = astType::event_attribute;
        n->base.base.loc = a_loc;
        n->m_value = a_value;
        return (ast_t*)n;
    }

    struct AttrEventWaitKwArg_t // Constructor
    {
        const static event_attributeType class_type = event_attributeType::AttrEventWaitKwArg;
        typedef event_attribute_t parent_type;
        event_attribute_t base;
        char* m_id;
        expr_t* m_value;
    };
    static inline ast_t* make_AttrEventWaitKwArg_t(Allocator &al, const Location &a_loc, char* a_id, expr_t* a_value) {
        AttrEventWaitKwArg_t *n;
        n = al.make_new<AttrEventWaitKwArg_t>();
        n->base.type = event_attributeType::AttrEventWaitKwArg;
        n->base.base.type = astType::event_attribute;
        n->base.base.loc = a_loc;
        n->m_id = a_id;
        n->m_value = a_value;
        return (ast_t*)n;
    }



enum team_attributeType // Types
{
    CoarrayAssociation
};

struct team_attribute_t // Sum
{
    const static astType class_type = astType::team_attribute;
    ast_t base;
    team_attributeType type;
};

    struct CoarrayAssociation_t // Constructor
    {
        const static team_attributeType class_type = team_attributeType::CoarrayAssociation;
        typedef team_attribute_t parent_type;
        team_attribute_t base;
        expr_t* m_coarray;
        expr_t* m_selector;
    };
    static inline ast_t* make_CoarrayAssociation_t(Allocator &al, const Location &a_loc, expr_t* a_coarray, expr_t* a_selector) {
        CoarrayAssociation_t *n;
        n = al.make_new<CoarrayAssociation_t>();
        n->base.type = team_attributeType::CoarrayAssociation;
        n->base.base.type = astType::team_attribute;
        n->base.base.loc = a_loc;
        n->m_coarray = a_coarray;
        n->m_selector = a_selector;
        return (ast_t*)n;
    }



enum bindType // Types
{
    Bind
};

struct bind_t // Sum
{
    const static astType class_type = astType::bind;
    ast_t base;
    bindType type;
};

    struct Bind_t // Constructor
    {
        const static bindType class_type = bindType::Bind;
        typedef bind_t parent_type;
        bind_t base;
        expr_t** m_args; size_t n_args; // Sequence
        keyword_t* m_kwargs; size_t n_kwargs; // Sequence
    };
    static inline ast_t* make_Bind_t(Allocator &al, const Location &a_loc, expr_t** a_args, size_t n_args, keyword_t* a_kwargs, size_t n_kwargs) {
        Bind_t *n;
        n = al.make_new<Bind_t>();
        n->base.type = bindType::Bind;
        n->base.base.type = astType::bind;
        n->base.base.loc = a_loc;
        n->m_args = a_args;
        n->n_args = n_args;
        n->m_kwargs = a_kwargs;
        n->n_kwargs = n_kwargs;
        return (ast_t*)n;
    }



enum array_indexType // Types
{
    ArrayIndex
};

struct array_index_t // Sum
{
    const static astType class_type = astType::array_index;
    ast_t base;
    array_indexType type;
};

    struct ArrayIndex_t // Constructor
    {
        const static array_indexType class_type = array_indexType::ArrayIndex;
        typedef array_index_t parent_type;
        array_index_t base;
        expr_t* m_left;
        expr_t* m_right;
        expr_t* m_step;
    };
    static inline ast_t* make_ArrayIndex_t(Allocator &al, const Location &a_loc, expr_t* a_left, expr_t* a_right, expr_t* a_step) {
        ArrayIndex_t *n;
        n = al.make_new<ArrayIndex_t>();
        n->base.type = array_indexType::ArrayIndex;
        n->base.base.type = astType::array_index;
        n->base.base.loc = a_loc;
        n->m_left = a_left;
        n->m_right = a_right;
        n->m_step = a_step;
        return (ast_t*)n;
    }



enum case_stmtType // Types
{
    CaseStmt, CaseStmt_Default
};

struct case_stmt_t // Sum
{
    const static astType class_type = astType::case_stmt;
    ast_t base;
    case_stmtType type;
};

    struct CaseStmt_t // Constructor
    {
        const static case_stmtType class_type = case_stmtType::CaseStmt;
        typedef case_stmt_t parent_type;
        case_stmt_t base;
        case_cond_t** m_test; size_t n_test; // Sequence
        trivia_t* m_trivia;
        stmt_t** m_body; size_t n_body; // Sequence
    };
    static inline ast_t* make_CaseStmt_t(Allocator &al, const Location &a_loc, case_cond_t** a_test, size_t n_test, trivia_t* a_trivia, stmt_t** a_body, size_t n_body) {
        CaseStmt_t *n;
        n = al.make_new<CaseStmt_t>();
        n->base.type = case_stmtType::CaseStmt;
        n->base.base.type = astType::case_stmt;
        n->base.base.loc = a_loc;
        n->m_test = a_test;
        n->n_test = n_test;
        n->m_trivia = a_trivia;
        n->m_body = a_body;
        n->n_body = n_body;
        return (ast_t*)n;
    }

    struct CaseStmt_Default_t // Constructor
    {
        const static case_stmtType class_type = case_stmtType::CaseStmt_Default;
        typedef case_stmt_t parent_type;
        case_stmt_t base;
        trivia_t* m_trivia;
        stmt_t** m_body; size_t n_body; // Sequence
    };
    static inline ast_t* make_CaseStmt_Default_t(Allocator &al, const Location &a_loc, trivia_t* a_trivia, stmt_t** a_body, size_t n_body) {
        CaseStmt_Default_t *n;
        n = al.make_new<CaseStmt_Default_t>();
        n->base.type = case_stmtType::CaseStmt_Default;
        n->base.base.type = astType::case_stmt;
        n->base.base.loc = a_loc;
        n->m_trivia = a_trivia;
        n->m_body = a_body;
        n->n_body = n_body;
        return (ast_t*)n;
    }



enum case_condType // Types
{
    CaseCondExpr, CaseCondRange
};

struct case_cond_t // Sum
{
    const static astType class_type = astType::case_cond;
    ast_t base;
    case_condType type;
};

    struct CaseCondExpr_t // Constructor
    {
        const static case_condType class_type = case_condType::CaseCondExpr;
        typedef case_cond_t parent_type;
        case_cond_t base;
        expr_t* m_cond;
    };
    static inline ast_t* make_CaseCondExpr_t(Allocator &al, const Location &a_loc, expr_t* a_cond) {
        CaseCondExpr_t *n;
        n = al.make_new<CaseCondExpr_t>();
        n->base.type = case_condType::CaseCondExpr;
        n->base.base.type = astType::case_cond;
        n->base.base.loc = a_loc;
        n->m_cond = a_cond;
        return (ast_t*)n;
    }

    struct CaseCondRange_t // Constructor
    {
        const static case_condType class_type = case_condType::CaseCondRange;
        typedef case_cond_t parent_type;
        case_cond_t base;
        expr_t* m_start;
        expr_t* m_end;
    };
    static inline ast_t* make_CaseCondRange_t(Allocator &al, const Location &a_loc, expr_t* a_start, expr_t* a_end) {
        CaseCondRange_t *n;
        n = al.make_new<CaseCondRange_t>();
        n->base.type = case_condType::CaseCondRange;
        n->base.base.type = astType::case_cond;
        n->base.base.loc = a_loc;
        n->m_start = a_start;
        n->m_end = a_end;
        return (ast_t*)n;
    }



enum rank_stmtType // Types
{
    RankExpr, RankStar, RankDefault
};

struct rank_stmt_t // Sum
{
    const static astType class_type = astType::rank_stmt;
    ast_t base;
    rank_stmtType type;
};

    struct RankExpr_t // Constructor
    {
        const static rank_stmtType class_type = rank_stmtType::RankExpr;
        typedef rank_stmt_t parent_type;
        rank_stmt_t base;
        expr_t* m_value;
        trivia_t* m_trivia;
        stmt_t** m_body; size_t n_body; // Sequence
    };
    static inline ast_t* make_RankExpr_t(Allocator &al, const Location &a_loc, expr_t* a_value, trivia_t* a_trivia, stmt_t** a_body, size_t n_body) {
        RankExpr_t *n;
        n = al.make_new<RankExpr_t>();
        n->base.type = rank_stmtType::RankExpr;
        n->base.base.type = astType::rank_stmt;
        n->base.base.loc = a_loc;
        n->m_value = a_value;
        n->m_trivia = a_trivia;
        n->m_body = a_body;
        n->n_body = n_body;
        return (ast_t*)n;
    }

    struct RankStar_t // Constructor
    {
        const static rank_stmtType class_type = rank_stmtType::RankStar;
        typedef rank_stmt_t parent_type;
        rank_stmt_t base;
        trivia_t* m_trivia;
        stmt_t** m_body; size_t n_body; // Sequence
    };
    static inline ast_t* make_RankStar_t(Allocator &al, const Location &a_loc, trivia_t* a_trivia, stmt_t** a_body, size_t n_body) {
        RankStar_t *n;
        n = al.make_new<RankStar_t>();
        n->base.type = rank_stmtType::RankStar;
        n->base.base.type = astType::rank_stmt;
        n->base.base.loc = a_loc;
        n->m_trivia = a_trivia;
        n->m_body = a_body;
        n->n_body = n_body;
        return (ast_t*)n;
    }

    struct RankDefault_t // Constructor
    {
        const static rank_stmtType class_type = rank_stmtType::RankDefault;
        typedef rank_stmt_t parent_type;
        rank_stmt_t base;
        trivia_t* m_trivia;
        stmt_t** m_body; size_t n_body; // Sequence
    };
    static inline ast_t* make_RankDefault_t(Allocator &al, const Location &a_loc, trivia_t* a_trivia, stmt_t** a_body, size_t n_body) {
        RankDefault_t *n;
        n = al.make_new<RankDefault_t>();
        n->base.type = rank_stmtType::RankDefault;
        n->base.base.type = astType::rank_stmt;
        n->base.base.loc = a_loc;
        n->m_trivia = a_trivia;
        n->m_body = a_body;
        n->n_body = n_body;
        return (ast_t*)n;
    }



enum type_stmtType // Types
{
    TypeStmtName, TypeStmtType, ClassStmt, ClassDefault
};

struct type_stmt_t // Sum
{
    const static astType class_type = astType::type_stmt;
    ast_t base;
    type_stmtType type;
};

    struct TypeStmtName_t // Constructor
    {
        const static type_stmtType class_type = type_stmtType::TypeStmtName;
        typedef type_stmt_t parent_type;
        type_stmt_t base;
        char* m_name;
        trivia_t* m_trivia;
        stmt_t** m_body; size_t n_body; // Sequence
    };
    static inline ast_t* make_TypeStmtName_t(Allocator &al, const Location &a_loc, char* a_name, trivia_t* a_trivia, stmt_t** a_body, size_t n_body) {
        TypeStmtName_t *n;
        n = al.make_new<TypeStmtName_t>();
        n->base.type = type_stmtType::TypeStmtName;
        n->base.base.type = astType::type_stmt;
        n->base.base.loc = a_loc;
        n->m_name = a_name;
        n->m_trivia = a_trivia;
        n->m_body = a_body;
        n->n_body = n_body;
        return (ast_t*)n;
    }

    struct TypeStmtType_t // Constructor
    {
        const static type_stmtType class_type = type_stmtType::TypeStmtType;
        typedef type_stmt_t parent_type;
        type_stmt_t base;
        decl_attribute_t* m_vartype;
        trivia_t* m_trivia;
        stmt_t** m_body; size_t n_body; // Sequence
    };
    static inline ast_t* make_TypeStmtType_t(Allocator &al, const Location &a_loc, decl_attribute_t* a_vartype, trivia_t* a_trivia, stmt_t** a_body, size_t n_body) {
        TypeStmtType_t *n;
        n = al.make_new<TypeStmtType_t>();
        n->base.type = type_stmtType::TypeStmtType;
        n->base.base.type = astType::type_stmt;
        n->base.base.loc = a_loc;
        n->m_vartype = a_vartype;
        n->m_trivia = a_trivia;
        n->m_body = a_body;
        n->n_body = n_body;
        return (ast_t*)n;
    }

    struct ClassStmt_t // Constructor
    {
        const static type_stmtType class_type = type_stmtType::ClassStmt;
        typedef type_stmt_t parent_type;
        type_stmt_t base;
        char* m_id;
        trivia_t* m_trivia;
        stmt_t** m_body; size_t n_body; // Sequence
    };
    static inline ast_t* make_ClassStmt_t(Allocator &al, const Location &a_loc, char* a_id, trivia_t* a_trivia, stmt_t** a_body, size_t n_body) {
        ClassStmt_t *n;
        n = al.make_new<ClassStmt_t>();
        n->base.type = type_stmtType::ClassStmt;
        n->base.base.type = astType::type_stmt;
        n->base.base.loc = a_loc;
        n->m_id = a_id;
        n->m_trivia = a_trivia;
        n->m_body = a_body;
        n->n_body = n_body;
        return (ast_t*)n;
    }

    struct ClassDefault_t // Constructor
    {
        const static type_stmtType class_type = type_stmtType::ClassDefault;
        typedef type_stmt_t parent_type;
        type_stmt_t base;
        trivia_t* m_trivia;
        stmt_t** m_body; size_t n_body; // Sequence
    };
    static inline ast_t* make_ClassDefault_t(Allocator &al, const Location &a_loc, trivia_t* a_trivia, stmt_t** a_body, size_t n_body) {
        ClassDefault_t *n;
        n = al.make_new<ClassDefault_t>();
        n->base.type = type_stmtType::ClassDefault;
        n->base.base.type = astType::type_stmt;
        n->base.base.loc = a_loc;
        n->m_trivia = a_trivia;
        n->m_body = a_body;
        n->n_body = n_body;
        return (ast_t*)n;
    }



enum use_symbolType // Types
{
    UseSymbol, UseAssignment, IntrinsicOperator, DefinedOperator, RenameOperator, UseWrite, UseRead
};

struct use_symbol_t // Sum
{
    const static astType class_type = astType::use_symbol;
    ast_t base;
    use_symbolType type;
};

    struct UseSymbol_t // Constructor
    {
        const static use_symbolType class_type = use_symbolType::UseSymbol;
        typedef use_symbol_t parent_type;
        use_symbol_t base;
        char* m_remote_sym;
        char* m_local_rename;
    };
    static inline ast_t* make_UseSymbol_t(Allocator &al, const Location &a_loc, char* a_remote_sym, char* a_local_rename) {
        UseSymbol_t *n;
        n = al.make_new<UseSymbol_t>();
        n->base.type = use_symbolType::UseSymbol;
        n->base.base.type = astType::use_symbol;
        n->base.base.loc = a_loc;
        n->m_remote_sym = a_remote_sym;
        n->m_local_rename = a_local_rename;
        return (ast_t*)n;
    }

    struct UseAssignment_t // Constructor
    {
        const static use_symbolType class_type = use_symbolType::UseAssignment;
        typedef use_symbol_t parent_type;
        use_symbol_t base;
    };
    static inline ast_t* make_UseAssignment_t(Allocator &al, const Location &a_loc) {
        UseAssignment_t *n;
        n = al.make_new<UseAssignment_t>();
        n->base.type = use_symbolType::UseAssignment;
        n->base.base.type = astType::use_symbol;
        n->base.base.loc = a_loc;
        return (ast_t*)n;
    }

    struct IntrinsicOperator_t // Constructor
    {
        const static use_symbolType class_type = use_symbolType::IntrinsicOperator;
        typedef use_symbol_t parent_type;
        use_symbol_t base;
        intrinsicopType m_op;
    };
    static inline ast_t* make_IntrinsicOperator_t(Allocator &al, const Location &a_loc, intrinsicopType a_op) {
        IntrinsicOperator_t *n;
        n = al.make_new<IntrinsicOperator_t>();
        n->base.type = use_symbolType::IntrinsicOperator;
        n->base.base.type = astType::use_symbol;
        n->base.base.loc = a_loc;
        n->m_op = a_op;
        return (ast_t*)n;
    }

    struct DefinedOperator_t // Constructor
    {
        const static use_symbolType class_type = use_symbolType::DefinedOperator;
        typedef use_symbol_t parent_type;
        use_symbol_t base;
        char* m_opName;
    };
    static inline ast_t* make_DefinedOperator_t(Allocator &al, const Location &a_loc, char* a_opName) {
        DefinedOperator_t *n;
        n = al.make_new<DefinedOperator_t>();
        n->base.type = use_symbolType::DefinedOperator;
        n->base.base.type = astType::use_symbol;
        n->base.base.loc = a_loc;
        n->m_opName = a_opName;
        return (ast_t*)n;
    }

    struct RenameOperator_t // Constructor
    {
        const static use_symbolType class_type = use_symbolType::RenameOperator;
        typedef use_symbol_t parent_type;
        use_symbol_t base;
        char* m_local_defop;
        char* m_use_defop;
    };
    static inline ast_t* make_RenameOperator_t(Allocator &al, const Location &a_loc, char* a_local_defop, char* a_use_defop) {
        RenameOperator_t *n;
        n = al.make_new<RenameOperator_t>();
        n->base.type = use_symbolType::RenameOperator;
        n->base.base.type = astType::use_symbol;
        n->base.base.loc = a_loc;
        n->m_local_defop = a_local_defop;
        n->m_use_defop = a_use_defop;
        return (ast_t*)n;
    }

    struct UseWrite_t // Constructor
    {
        const static use_symbolType class_type = use_symbolType::UseWrite;
        typedef use_symbol_t parent_type;
        use_symbol_t base;
        char* m_id;
    };
    static inline ast_t* make_UseWrite_t(Allocator &al, const Location &a_loc, char* a_id) {
        UseWrite_t *n;
        n = al.make_new<UseWrite_t>();
        n->base.type = use_symbolType::UseWrite;
        n->base.base.type = astType::use_symbol;
        n->base.base.loc = a_loc;
        n->m_id = a_id;
        return (ast_t*)n;
    }

    struct UseRead_t // Constructor
    {
        const static use_symbolType class_type = use_symbolType::UseRead;
        typedef use_symbol_t parent_type;
        use_symbol_t base;
        char* m_id;
    };
    static inline ast_t* make_UseRead_t(Allocator &al, const Location &a_loc, char* a_id) {
        UseRead_t *n;
        n = al.make_new<UseRead_t>();
        n->base.type = use_symbolType::UseRead;
        n->base.base.type = astType::use_symbol;
        n->base.base.loc = a_loc;
        n->m_id = a_id;
        return (ast_t*)n;
    }



enum concurrent_controlType // Types
{
    ConcurrentControl
};

struct concurrent_control_t // Sum
{
    const static astType class_type = astType::concurrent_control;
    ast_t base;
    concurrent_controlType type;
};

    struct ConcurrentControl_t // Constructor
    {
        const static concurrent_controlType class_type = concurrent_controlType::ConcurrentControl;
        typedef concurrent_control_t parent_type;
        concurrent_control_t base;
        char* m_var;
        expr_t* m_start;
        expr_t* m_end;
        expr_t* m_increment;
    };
    static inline ast_t* make_ConcurrentControl_t(Allocator &al, const Location &a_loc, char* a_var, expr_t* a_start, expr_t* a_end, expr_t* a_increment) {
        ConcurrentControl_t *n;
        n = al.make_new<ConcurrentControl_t>();
        n->base.type = concurrent_controlType::ConcurrentControl;
        n->base.base.type = astType::concurrent_control;
        n->base.base.loc = a_loc;
        n->m_var = a_var;
        n->m_start = a_start;
        n->m_end = a_end;
        n->m_increment = a_increment;
        return (ast_t*)n;
    }



enum concurrent_localityType // Types
{
    ConcurrentLocal, ConcurrentLocalInit, ConcurrentShared, ConcurrentDefault, ConcurrentReduce
};

struct concurrent_locality_t // Sum
{
    const static astType class_type = astType::concurrent_locality;
    ast_t base;
    concurrent_localityType type;
};

    struct ConcurrentLocal_t // Constructor
    {
        const static concurrent_localityType class_type = concurrent_localityType::ConcurrentLocal;
        typedef concurrent_locality_t parent_type;
        concurrent_locality_t base;
        char** m_vars; size_t n_vars; // Sequence
    };
    static inline ast_t* make_ConcurrentLocal_t(Allocator &al, const Location &a_loc, char** a_vars, size_t n_vars) {
        ConcurrentLocal_t *n;
        n = al.make_new<ConcurrentLocal_t>();
        n->base.type = concurrent_localityType::ConcurrentLocal;
        n->base.base.type = astType::concurrent_locality;
        n->base.base.loc = a_loc;
        n->m_vars = a_vars;
        n->n_vars = n_vars;
        return (ast_t*)n;
    }

    struct ConcurrentLocalInit_t // Constructor
    {
        const static concurrent_localityType class_type = concurrent_localityType::ConcurrentLocalInit;
        typedef concurrent_locality_t parent_type;
        concurrent_locality_t base;
        char** m_vars; size_t n_vars; // Sequence
    };
    static inline ast_t* make_ConcurrentLocalInit_t(Allocator &al, const Location &a_loc, char** a_vars, size_t n_vars) {
        ConcurrentLocalInit_t *n;
        n = al.make_new<ConcurrentLocalInit_t>();
        n->base.type = concurrent_localityType::ConcurrentLocalInit;
        n->base.base.type = astType::concurrent_locality;
        n->base.base.loc = a_loc;
        n->m_vars = a_vars;
        n->n_vars = n_vars;
        return (ast_t*)n;
    }

    struct ConcurrentShared_t // Constructor
    {
        const static concurrent_localityType class_type = concurrent_localityType::ConcurrentShared;
        typedef concurrent_locality_t parent_type;
        concurrent_locality_t base;
        char** m_vars; size_t n_vars; // Sequence
    };
    static inline ast_t* make_ConcurrentShared_t(Allocator &al, const Location &a_loc, char** a_vars, size_t n_vars) {
        ConcurrentShared_t *n;
        n = al.make_new<ConcurrentShared_t>();
        n->base.type = concurrent_localityType::ConcurrentShared;
        n->base.base.type = astType::concurrent_locality;
        n->base.base.loc = a_loc;
        n->m_vars = a_vars;
        n->n_vars = n_vars;
        return (ast_t*)n;
    }

    struct ConcurrentDefault_t // Constructor
    {
        const static concurrent_localityType class_type = concurrent_localityType::ConcurrentDefault;
        typedef concurrent_locality_t parent_type;
        concurrent_locality_t base;
    };
    static inline ast_t* make_ConcurrentDefault_t(Allocator &al, const Location &a_loc) {
        ConcurrentDefault_t *n;
        n = al.make_new<ConcurrentDefault_t>();
        n->base.type = concurrent_localityType::ConcurrentDefault;
        n->base.base.type = astType::concurrent_locality;
        n->base.base.loc = a_loc;
        return (ast_t*)n;
    }

    struct ConcurrentReduce_t // Constructor
    {
        const static concurrent_localityType class_type = concurrent_localityType::ConcurrentReduce;
        typedef concurrent_locality_t parent_type;
        concurrent_locality_t base;
        reduce_opType m_op;
        char** m_vars; size_t n_vars; // Sequence
    };
    static inline ast_t* make_ConcurrentReduce_t(Allocator &al, const Location &a_loc, reduce_opType a_op, char** a_vars, size_t n_vars) {
        ConcurrentReduce_t *n;
        n = al.make_new<ConcurrentReduce_t>();
        n->base.type = concurrent_localityType::ConcurrentReduce;
        n->base.base.type = astType::concurrent_locality;
        n->base.base.loc = a_loc;
        n->m_op = a_op;
        n->m_vars = a_vars;
        n->n_vars = n_vars;
        return (ast_t*)n;
    }



enum data_stmt_setType // Types
{
    DataStmtSet
};

struct data_stmt_set_t // Sum
{
    const static astType class_type = astType::data_stmt_set;
    ast_t base;
    data_stmt_setType type;
};

    struct DataStmtSet_t // Constructor
    {
        const static data_stmt_setType class_type = data_stmt_setType::DataStmtSet;
        typedef data_stmt_set_t parent_type;
        data_stmt_set_t base;
        expr_t** m_object; size_t n_object; // Sequence
        expr_t** m_value; size_t n_value; // Sequence
    };
    static inline ast_t* make_DataStmtSet_t(Allocator &al, const Location &a_loc, expr_t** a_object, size_t n_object, expr_t** a_value, size_t n_value) {
        DataStmtSet_t *n;
        n = al.make_new<DataStmtSet_t>();
        n->base.type = data_stmt_setType::DataStmtSet;
        n->base.base.type = astType::data_stmt_set;
        n->base.base.loc = a_loc;
        n->m_object = a_object;
        n->n_object = n_object;
        n->m_value = a_value;
        n->n_value = n_value;
        return (ast_t*)n;
    }



enum unit_requireType // Types
{
    UnitRequire
};

struct unit_require_t // Sum
{
    const static astType class_type = astType::unit_require;
    ast_t base;
    unit_requireType type;
};

    struct UnitRequire_t // Constructor
    {
        const static unit_requireType class_type = unit_requireType::UnitRequire;
        typedef unit_require_t parent_type;
        unit_require_t base;
        char* m_name;
        decl_attribute_t** m_namelist; size_t n_namelist; // Sequence
    };
    static inline ast_t* make_UnitRequire_t(Allocator &al, const Location &a_loc, char* a_name, decl_attribute_t** a_namelist, size_t n_namelist) {
        UnitRequire_t *n;
        n = al.make_new<UnitRequire_t>();
        n->base.type = unit_requireType::UnitRequire;
        n->base.base.type = astType::unit_require;
        n->base.base.loc = a_loc;
        n->m_name = a_name;
        n->m_namelist = a_namelist;
        n->n_namelist = n_namelist;
        return (ast_t*)n;
    }





/******************************************************************************/
// Visitor functions

template <class Visitor>
static void visit_unit_t(const unit_t &x, Visitor &v) {
    LCOMPILERS_ASSERT(x.base.type == astType::unit)
    switch (x.type) {
        case unitType::TranslationUnit: { v.visit_TranslationUnit((const TranslationUnit_t &)x); return; }
    }
}

template <class Visitor>
static void visit_mod_t(const mod_t &x, Visitor &v) {
    LCOMPILERS_ASSERT(x.base.type == astType::mod)
    switch (x.type) {
        case modType::Module: { v.visit_Module((const Module_t &)x); return; }
        case modType::Submodule: { v.visit_Submodule((const Submodule_t &)x); return; }
        case modType::BlockData: { v.visit_BlockData((const BlockData_t &)x); return; }
        case modType::Program: { v.visit_Program((const Program_t &)x); return; }
    }
}

template <class Visitor>
static void visit_program_unit_t(const program_unit_t &x, Visitor &v) {
    LCOMPILERS_ASSERT(x.base.type == astType::program_unit)
    switch (x.type) {
        case program_unitType::Subroutine: { v.visit_Subroutine((const Subroutine_t &)x); return; }
        case program_unitType::Procedure: { v.visit_Procedure((const Procedure_t &)x); return; }
        case program_unitType::Function: { v.visit_Function((const Function_t &)x); return; }
    }
}

template <class Visitor>
static void visit_unit_decl1_t(const unit_decl1_t &x, Visitor &v) {
    LCOMPILERS_ASSERT(x.base.type == astType::unit_decl1)
    switch (x.type) {
        case unit_decl1Type::Use: { v.visit_Use((const Use_t &)x); return; }
    }
}

template <class Visitor>
static void visit_unit_decl2_t(const unit_decl2_t &x, Visitor &v) {
    LCOMPILERS_ASSERT(x.base.type == astType::unit_decl2)
    switch (x.type) {
        case unit_decl2Type::Declaration: { v.visit_Declaration((const Declaration_t &)x); return; }
        case unit_decl2Type::DeclarationPragma: { v.visit_DeclarationPragma((const DeclarationPragma_t &)x); return; }
        case unit_decl2Type::Interface: { v.visit_Interface((const Interface_t &)x); return; }
        case unit_decl2Type::DerivedType: { v.visit_DerivedType((const DerivedType_t &)x); return; }
        case unit_decl2Type::Template: { v.visit_Template((const Template_t &)x); return; }
        case unit_decl2Type::Enum: { v.visit_Enum((const Enum_t &)x); return; }
        case unit_decl2Type::Instantiate: { v.visit_Instantiate((const Instantiate_t &)x); return; }
        case unit_decl2Type::Requirement: { v.visit_Requirement((const Requirement_t &)x); return; }
        case unit_decl2Type::Require: { v.visit_Require((const Require_t &)x); return; }
    }
}

template <class Visitor>
static void visit_interface_header_t(const interface_header_t &x, Visitor &v) {
    LCOMPILERS_ASSERT(x.base.type == astType::interface_header)
    switch (x.type) {
        case interface_headerType::InterfaceHeader: { v.visit_InterfaceHeader((const InterfaceHeader_t &)x); return; }
        case interface_headerType::InterfaceHeaderName: { v.visit_InterfaceHeaderName((const InterfaceHeaderName_t &)x); return; }
        case interface_headerType::InterfaceHeaderAssignment: { v.visit_InterfaceHeaderAssignment((const InterfaceHeaderAssignment_t &)x); return; }
        case interface_headerType::InterfaceHeaderOperator: { v.visit_InterfaceHeaderOperator((const InterfaceHeaderOperator_t &)x); return; }
        case interface_headerType::InterfaceHeaderDefinedOperator: { v.visit_InterfaceHeaderDefinedOperator((const InterfaceHeaderDefinedOperator_t &)x); return; }
        case interface_headerType::AbstractInterfaceHeader: { v.visit_AbstractInterfaceHeader((const AbstractInterfaceHeader_t &)x); return; }
        case interface_headerType::InterfaceHeaderWrite: { v.visit_InterfaceHeaderWrite((const InterfaceHeaderWrite_t &)x); return; }
        case interface_headerType::InterfaceHeaderRead: { v.visit_InterfaceHeaderRead((const InterfaceHeaderRead_t &)x); return; }
    }
}

template <class Visitor>
static void visit_interface_item_t(const interface_item_t &x, Visitor &v) {
    LCOMPILERS_ASSERT(x.base.type == astType::interface_item)
    switch (x.type) {
        case interface_itemType::InterfaceProc: { v.visit_InterfaceProc((const InterfaceProc_t &)x); return; }
        case interface_itemType::InterfaceModuleProcedure: { v.visit_InterfaceModuleProcedure((const InterfaceModuleProcedure_t &)x); return; }
    }
}

template <class Visitor>
static void visit_import_statement_t(const import_statement_t &x, Visitor &v) {
    LCOMPILERS_ASSERT(x.base.type == astType::import_statement)
    switch (x.type) {
        case import_statementType::Import: { v.visit_Import((const Import_t &)x); return; }
    }
}

template <class Visitor>
static void visit_implicit_statement_t(const implicit_statement_t &x, Visitor &v) {
    LCOMPILERS_ASSERT(x.base.type == astType::implicit_statement)
    switch (x.type) {
        case implicit_statementType::ImplicitNone: { v.visit_ImplicitNone((const ImplicitNone_t &)x); return; }
        case implicit_statementType::Implicit: { v.visit_Implicit((const Implicit_t &)x); return; }
    }
}

template <class Visitor>
static void visit_implicit_none_spec_t(const implicit_none_spec_t &x, Visitor &v) {
    LCOMPILERS_ASSERT(x.base.type == astType::implicit_none_spec)
    switch (x.type) {
        case implicit_none_specType::ImplicitNoneExternal: { v.visit_ImplicitNoneExternal((const ImplicitNoneExternal_t &)x); return; }
        case implicit_none_specType::ImplicitNoneType: { v.visit_ImplicitNoneType((const ImplicitNoneType_t &)x); return; }
    }
}

template <class Visitor>
static void visit_letter_spec_t(const letter_spec_t &x, Visitor &v) {
    LCOMPILERS_ASSERT(x.base.type == astType::letter_spec)
    switch (x.type) {
        case letter_specType::LetterSpec: { v.visit_LetterSpec((const LetterSpec_t &)x); return; }
    }
}

template <class Visitor>
static void visit_stmt_t(const stmt_t &x, Visitor &v) {
    LCOMPILERS_ASSERT(x.base.type == astType::stmt)
    switch (x.type) {
        case stmtType::Allocate: { v.visit_Allocate((const Allocate_t &)x); return; }
        case stmtType::Assign: { v.visit_Assign((const Assign_t &)x); return; }
        case stmtType::Assignment: { v.visit_Assignment((const Assignment_t &)x); return; }
        case stmtType::Associate: { v.visit_Associate((const Associate_t &)x); return; }
        case stmtType::Backspace: { v.visit_Backspace((const Backspace_t &)x); return; }
        case stmtType::Close: { v.visit_Close((const Close_t &)x); return; }
        case stmtType::Continue: { v.visit_Continue((const Continue_t &)x); return; }
        case stmtType::Cycle: { v.visit_Cycle((const Cycle_t &)x); return; }
        case stmtType::Deallocate: { v.visit_Deallocate((const Deallocate_t &)x); return; }
        case stmtType::Endfile: { v.visit_Endfile((const Endfile_t &)x); return; }
        case stmtType::Entry: { v.visit_Entry((const Entry_t &)x); return; }
        case stmtType::ErrorStop: { v.visit_ErrorStop((const ErrorStop_t &)x); return; }
        case stmtType::EventPost: { v.visit_EventPost((const EventPost_t &)x); return; }
        case stmtType::EventWait: { v.visit_EventWait((const EventWait_t &)x); return; }
        case stmtType::Exit: { v.visit_Exit((const Exit_t &)x); return; }
        case stmtType::Flush: { v.visit_Flush((const Flush_t &)x); return; }
        case stmtType::ForAllSingle: { v.visit_ForAllSingle((const ForAllSingle_t &)x); return; }
        case stmtType::Format: { v.visit_Format((const Format_t &)x); return; }
        case stmtType::DataStmt: { v.visit_DataStmt((const DataStmt_t &)x); return; }
        case stmtType::FormTeam: { v.visit_FormTeam((const FormTeam_t &)x); return; }
        case stmtType::GoTo: { v.visit_GoTo((const GoTo_t &)x); return; }
        case stmtType::Include: { v.visit_Include((const Include_t &)x); return; }
        case stmtType::Inquire: { v.visit_Inquire((const Inquire_t &)x); return; }
        case stmtType::Nullify: { v.visit_Nullify((const Nullify_t &)x); return; }
        case stmtType::Open: { v.visit_Open((const Open_t &)x); return; }
        case stmtType::Return: { v.visit_Return((const Return_t &)x); return; }
        case stmtType::Pragma: { v.visit_Pragma((const Pragma_t &)x); return; }
        case stmtType::Print: { v.visit_Print((const Print_t &)x); return; }
        case stmtType::Read: { v.visit_Read((const Read_t &)x); return; }
        case stmtType::Rewind: { v.visit_Rewind((const Rewind_t &)x); return; }
        case stmtType::Stop: { v.visit_Stop((const Stop_t &)x); return; }
        case stmtType::SubroutineCall: { v.visit_SubroutineCall((const SubroutineCall_t &)x); return; }
        case stmtType::SyncAll: { v.visit_SyncAll((const SyncAll_t &)x); return; }
        case stmtType::SyncImages: { v.visit_SyncImages((const SyncImages_t &)x); return; }
        case stmtType::SyncMemory: { v.visit_SyncMemory((const SyncMemory_t &)x); return; }
        case stmtType::SyncTeam: { v.visit_SyncTeam((const SyncTeam_t &)x); return; }
        case stmtType::Write: { v.visit_Write((const Write_t &)x); return; }
        case stmtType::AssociateBlock: { v.visit_AssociateBlock((const AssociateBlock_t &)x); return; }
        case stmtType::Block: { v.visit_Block((const Block_t &)x); return; }
        case stmtType::ChangeTeam: { v.visit_ChangeTeam((const ChangeTeam_t &)x); return; }
        case stmtType::Critical: { v.visit_Critical((const Critical_t &)x); return; }
        case stmtType::DoConcurrentLoop: { v.visit_DoConcurrentLoop((const DoConcurrentLoop_t &)x); return; }
        case stmtType::DoLoop: { v.visit_DoLoop((const DoLoop_t &)x); return; }
        case stmtType::ForAll: { v.visit_ForAll((const ForAll_t &)x); return; }
        case stmtType::If: { v.visit_If((const If_t &)x); return; }
        case stmtType::IfArithmetic: { v.visit_IfArithmetic((const IfArithmetic_t &)x); return; }
        case stmtType::Select: { v.visit_Select((const Select_t &)x); return; }
        case stmtType::SelectRank: { v.visit_SelectRank((const SelectRank_t &)x); return; }
        case stmtType::SelectType: { v.visit_SelectType((const SelectType_t &)x); return; }
        case stmtType::Where: { v.visit_Where((const Where_t &)x); return; }
        case stmtType::WhileLoop: { v.visit_WhileLoop((const WhileLoop_t &)x); return; }
    }
}

template <class Visitor>
static void visit_expr_t(const expr_t &x, Visitor &v) {
    LCOMPILERS_ASSERT(x.base.type == astType::expr)
    switch (x.type) {
        case exprType::BoolOp: { v.visit_BoolOp((const BoolOp_t &)x); return; }
        case exprType::BinOp: { v.visit_BinOp((const BinOp_t &)x); return; }
        case exprType::DefBinOp: { v.visit_DefBinOp((const DefBinOp_t &)x); return; }
        case exprType::StrOp: { v.visit_StrOp((const StrOp_t &)x); return; }
        case exprType::UnaryOp: { v.visit_UnaryOp((const UnaryOp_t &)x); return; }
        case exprType::DefUnaryOp: { v.visit_DefUnaryOp((const DefUnaryOp_t &)x); return; }
        case exprType::Compare: { v.visit_Compare((const Compare_t &)x); return; }
        case exprType::FuncCallOrArray: { v.visit_FuncCallOrArray((const FuncCallOrArray_t &)x); return; }
        case exprType::CoarrayRef: { v.visit_CoarrayRef((const CoarrayRef_t &)x); return; }
        case exprType::ArrayInitializer: { v.visit_ArrayInitializer((const ArrayInitializer_t &)x); return; }
        case exprType::ImpliedDoLoop: { v.visit_ImpliedDoLoop((const ImpliedDoLoop_t &)x); return; }
        case exprType::Num: { v.visit_Num((const Num_t &)x); return; }
        case exprType::Real: { v.visit_Real((const Real_t &)x); return; }
        case exprType::Complex: { v.visit_Complex((const Complex_t &)x); return; }
        case exprType::String: { v.visit_String((const String_t &)x); return; }
        case exprType::Substring: { v.visit_Substring((const Substring_t &)x); return; }
        case exprType::BOZ: { v.visit_BOZ((const BOZ_t &)x); return; }
        case exprType::Name: { v.visit_Name((const Name_t &)x); return; }
        case exprType::Logical: { v.visit_Logical((const Logical_t &)x); return; }
        case exprType::DataImpliedDo: { v.visit_DataImpliedDo((const DataImpliedDo_t &)x); return; }
        case exprType::Parenthesis: { v.visit_Parenthesis((const Parenthesis_t &)x); return; }
    }
}

template <class Visitor>
static void visit_trivia_t(const trivia_t &x, Visitor &v) {
    LCOMPILERS_ASSERT(x.base.type == astType::trivia)
    switch (x.type) {
        case triviaType::TriviaNode: { v.visit_TriviaNode((const TriviaNode_t &)x); return; }
    }
}

template <class Visitor>
static void visit_trivia_node_t(const trivia_node_t &x, Visitor &v) {
    LCOMPILERS_ASSERT(x.base.type == astType::trivia_node)
    switch (x.type) {
        case trivia_nodeType::Comment: { v.visit_Comment((const Comment_t &)x); return; }
        case trivia_nodeType::EOLComment: { v.visit_EOLComment((const EOLComment_t &)x); return; }
        case trivia_nodeType::EndOfLine: { v.visit_EndOfLine((const EndOfLine_t &)x); return; }
        case trivia_nodeType::Semicolon: { v.visit_Semicolon((const Semicolon_t &)x); return; }
    }
}

template <class Visitor>
static void visit_procedure_decl_t(const procedure_decl_t &x, Visitor &v) {
    LCOMPILERS_ASSERT(x.base.type == astType::procedure_decl)
    switch (x.type) {
        case procedure_declType::DerivedTypeProc: { v.visit_DerivedTypeProc((const DerivedTypeProc_t &)x); return; }
        case procedure_declType::GenericOperator: { v.visit_GenericOperator((const GenericOperator_t &)x); return; }
        case procedure_declType::GenericDefinedOperator: { v.visit_GenericDefinedOperator((const GenericDefinedOperator_t &)x); return; }
        case procedure_declType::GenericAssignment: { v.visit_GenericAssignment((const GenericAssignment_t &)x); return; }
        case procedure_declType::GenericName: { v.visit_GenericName((const GenericName_t &)x); return; }
        case procedure_declType::GenericWrite: { v.visit_GenericWrite((const GenericWrite_t &)x); return; }
        case procedure_declType::GenericRead: { v.visit_GenericRead((const GenericRead_t &)x); return; }
        case procedure_declType::FinalName: { v.visit_FinalName((const FinalName_t &)x); return; }
        case procedure_declType::Private: { v.visit_Private((const Private_t &)x); return; }
    }
}

template <class Visitor>
static void visit_decl_attribute_t(const decl_attribute_t &x, Visitor &v) {
    LCOMPILERS_ASSERT(x.base.type == astType::decl_attribute)
    switch (x.type) {
        case decl_attributeType::AttrBind: { v.visit_AttrBind((const AttrBind_t &)x); return; }
        case decl_attributeType::AttrDimension: { v.visit_AttrDimension((const AttrDimension_t &)x); return; }
        case decl_attributeType::AttrCodimension: { v.visit_AttrCodimension((const AttrCodimension_t &)x); return; }
        case decl_attributeType::AttrEquivalence: { v.visit_AttrEquivalence((const AttrEquivalence_t &)x); return; }
        case decl_attributeType::AttrExtends: { v.visit_AttrExtends((const AttrExtends_t &)x); return; }
        case decl_attributeType::AttrIntent: { v.visit_AttrIntent((const AttrIntent_t &)x); return; }
        case decl_attributeType::AttrNamelist: { v.visit_AttrNamelist((const AttrNamelist_t &)x); return; }
        case decl_attributeType::AttrPass: { v.visit_AttrPass((const AttrPass_t &)x); return; }
        case decl_attributeType::SimpleAttribute: { v.visit_SimpleAttribute((const SimpleAttribute_t &)x); return; }
        case decl_attributeType::AttrType: { v.visit_AttrType((const AttrType_t &)x); return; }
        case decl_attributeType::AttrAssignment: { v.visit_AttrAssignment((const AttrAssignment_t &)x); return; }
        case decl_attributeType::AttrIntrinsicOperator: { v.visit_AttrIntrinsicOperator((const AttrIntrinsicOperator_t &)x); return; }
        case decl_attributeType::AttrDefinedOperator: { v.visit_AttrDefinedOperator((const AttrDefinedOperator_t &)x); return; }
    }
}

template <class Visitor>
static void visit_event_attribute_t(const event_attribute_t &x, Visitor &v) {
    LCOMPILERS_ASSERT(x.base.type == astType::event_attribute)
    switch (x.type) {
        case event_attributeType::AttrStat: { v.visit_AttrStat((const AttrStat_t &)x); return; }
        case event_attributeType::AttrErrmsg: { v.visit_AttrErrmsg((const AttrErrmsg_t &)x); return; }
        case event_attributeType::AttrNewIndex: { v.visit_AttrNewIndex((const AttrNewIndex_t &)x); return; }
        case event_attributeType::AttrEventWaitKwArg: { v.visit_AttrEventWaitKwArg((const AttrEventWaitKwArg_t &)x); return; }
    }
}

template <class Visitor>
static void visit_team_attribute_t(const team_attribute_t &x, Visitor &v) {
    LCOMPILERS_ASSERT(x.base.type == astType::team_attribute)
    switch (x.type) {
        case team_attributeType::CoarrayAssociation: { v.visit_CoarrayAssociation((const CoarrayAssociation_t &)x); return; }
    }
}

template <class Visitor>
static void visit_bind_t(const bind_t &x, Visitor &v) {
    LCOMPILERS_ASSERT(x.base.type == astType::bind)
    switch (x.type) {
        case bindType::Bind: { v.visit_Bind((const Bind_t &)x); return; }
    }
}

template <class Visitor>
static void visit_array_index_t(const array_index_t &x, Visitor &v) {
    LCOMPILERS_ASSERT(x.base.type == astType::array_index)
    switch (x.type) {
        case array_indexType::ArrayIndex: { v.visit_ArrayIndex((const ArrayIndex_t &)x); return; }
    }
}

template <class Visitor>
static void visit_case_stmt_t(const case_stmt_t &x, Visitor &v) {
    LCOMPILERS_ASSERT(x.base.type == astType::case_stmt)
    switch (x.type) {
        case case_stmtType::CaseStmt: { v.visit_CaseStmt((const CaseStmt_t &)x); return; }
        case case_stmtType::CaseStmt_Default: { v.visit_CaseStmt_Default((const CaseStmt_Default_t &)x); return; }
    }
}

template <class Visitor>
static void visit_case_cond_t(const case_cond_t &x, Visitor &v) {
    LCOMPILERS_ASSERT(x.base.type == astType::case_cond)
    switch (x.type) {
        case case_condType::CaseCondExpr: { v.visit_CaseCondExpr((const CaseCondExpr_t &)x); return; }
        case case_condType::CaseCondRange: { v.visit_CaseCondRange((const CaseCondRange_t &)x); return; }
    }
}

template <class Visitor>
static void visit_rank_stmt_t(const rank_stmt_t &x, Visitor &v) {
    LCOMPILERS_ASSERT(x.base.type == astType::rank_stmt)
    switch (x.type) {
        case rank_stmtType::RankExpr: { v.visit_RankExpr((const RankExpr_t &)x); return; }
        case rank_stmtType::RankStar: { v.visit_RankStar((const RankStar_t &)x); return; }
        case rank_stmtType::RankDefault: { v.visit_RankDefault((const RankDefault_t &)x); return; }
    }
}

template <class Visitor>
static void visit_type_stmt_t(const type_stmt_t &x, Visitor &v) {
    LCOMPILERS_ASSERT(x.base.type == astType::type_stmt)
    switch (x.type) {
        case type_stmtType::TypeStmtName: { v.visit_TypeStmtName((const TypeStmtName_t &)x); return; }
        case type_stmtType::TypeStmtType: { v.visit_TypeStmtType((const TypeStmtType_t &)x); return; }
        case type_stmtType::ClassStmt: { v.visit_ClassStmt((const ClassStmt_t &)x); return; }
        case type_stmtType::ClassDefault: { v.visit_ClassDefault((const ClassDefault_t &)x); return; }
    }
}

template <class Visitor>
static void visit_use_symbol_t(const use_symbol_t &x, Visitor &v) {
    LCOMPILERS_ASSERT(x.base.type == astType::use_symbol)
    switch (x.type) {
        case use_symbolType::UseSymbol: { v.visit_UseSymbol((const UseSymbol_t &)x); return; }
        case use_symbolType::UseAssignment: { v.visit_UseAssignment((const UseAssignment_t &)x); return; }
        case use_symbolType::IntrinsicOperator: { v.visit_IntrinsicOperator((const IntrinsicOperator_t &)x); return; }
        case use_symbolType::DefinedOperator: { v.visit_DefinedOperator((const DefinedOperator_t &)x); return; }
        case use_symbolType::RenameOperator: { v.visit_RenameOperator((const RenameOperator_t &)x); return; }
        case use_symbolType::UseWrite: { v.visit_UseWrite((const UseWrite_t &)x); return; }
        case use_symbolType::UseRead: { v.visit_UseRead((const UseRead_t &)x); return; }
    }
}

template <class Visitor>
static void visit_concurrent_control_t(const concurrent_control_t &x, Visitor &v) {
    LCOMPILERS_ASSERT(x.base.type == astType::concurrent_control)
    switch (x.type) {
        case concurrent_controlType::ConcurrentControl: { v.visit_ConcurrentControl((const ConcurrentControl_t &)x); return; }
    }
}

template <class Visitor>
static void visit_concurrent_locality_t(const concurrent_locality_t &x, Visitor &v) {
    LCOMPILERS_ASSERT(x.base.type == astType::concurrent_locality)
    switch (x.type) {
        case concurrent_localityType::ConcurrentLocal: { v.visit_ConcurrentLocal((const ConcurrentLocal_t &)x); return; }
        case concurrent_localityType::ConcurrentLocalInit: { v.visit_ConcurrentLocalInit((const ConcurrentLocalInit_t &)x); return; }
        case concurrent_localityType::ConcurrentShared: { v.visit_ConcurrentShared((const ConcurrentShared_t &)x); return; }
        case concurrent_localityType::ConcurrentDefault: { v.visit_ConcurrentDefault((const ConcurrentDefault_t &)x); return; }
        case concurrent_localityType::ConcurrentReduce: { v.visit_ConcurrentReduce((const ConcurrentReduce_t &)x); return; }
    }
}

template <class Visitor>
static void visit_data_stmt_set_t(const data_stmt_set_t &x, Visitor &v) {
    LCOMPILERS_ASSERT(x.base.type == astType::data_stmt_set)
    switch (x.type) {
        case data_stmt_setType::DataStmtSet: { v.visit_DataStmtSet((const DataStmtSet_t &)x); return; }
    }
}

template <class Visitor>
static void visit_unit_require_t(const unit_require_t &x, Visitor &v) {
    LCOMPILERS_ASSERT(x.base.type == astType::unit_require)
    switch (x.type) {
        case unit_requireType::UnitRequire: { v.visit_UnitRequire((const UnitRequire_t &)x); return; }
    }
}



template <class Visitor>
static void visit_ast_t(const ast_t &x, Visitor &v) {
    switch (x.type) {
        case astType::unit: { v.visit_unit((const unit_t &)x); return; }
        case astType::mod: { v.visit_mod((const mod_t &)x); return; }
        case astType::program_unit: { v.visit_program_unit((const program_unit_t &)x); return; }
        case astType::unit_decl1: { v.visit_unit_decl1((const unit_decl1_t &)x); return; }
        case astType::unit_decl2: { v.visit_unit_decl2((const unit_decl2_t &)x); return; }
        case astType::interface_header: { v.visit_interface_header((const interface_header_t &)x); return; }
        case astType::interface_item: { v.visit_interface_item((const interface_item_t &)x); return; }
        case astType::import_statement: { v.visit_import_statement((const import_statement_t &)x); return; }
        case astType::implicit_statement: { v.visit_implicit_statement((const implicit_statement_t &)x); return; }
        case astType::implicit_none_spec: { v.visit_implicit_none_spec((const implicit_none_spec_t &)x); return; }
        case astType::letter_spec: { v.visit_letter_spec((const letter_spec_t &)x); return; }
        case astType::stmt: { v.visit_stmt((const stmt_t &)x); return; }
        case astType::expr: { v.visit_expr((const expr_t &)x); return; }
        case astType::trivia: { v.visit_trivia((const trivia_t &)x); return; }
        case astType::trivia_node: { v.visit_trivia_node((const trivia_node_t &)x); return; }
        case astType::procedure_decl: { v.visit_procedure_decl((const procedure_decl_t &)x); return; }
        case astType::decl_attribute: { v.visit_decl_attribute((const decl_attribute_t &)x); return; }
        case astType::event_attribute: { v.visit_event_attribute((const event_attribute_t &)x); return; }
        case astType::team_attribute: { v.visit_team_attribute((const team_attribute_t &)x); return; }
        case astType::bind: { v.visit_bind((const bind_t &)x); return; }
        case astType::array_index: { v.visit_array_index((const array_index_t &)x); return; }
        case astType::case_stmt: { v.visit_case_stmt((const case_stmt_t &)x); return; }
        case astType::case_cond: { v.visit_case_cond((const case_cond_t &)x); return; }
        case astType::rank_stmt: { v.visit_rank_stmt((const rank_stmt_t &)x); return; }
        case astType::type_stmt: { v.visit_type_stmt((const type_stmt_t &)x); return; }
        case astType::use_symbol: { v.visit_use_symbol((const use_symbol_t &)x); return; }
        case astType::concurrent_control: { v.visit_concurrent_control((const concurrent_control_t &)x); return; }
        case astType::concurrent_locality: { v.visit_concurrent_locality((const concurrent_locality_t &)x); return; }
        case astType::data_stmt_set: { v.visit_data_stmt_set((const data_stmt_set_t &)x); return; }
        case astType::unit_require: { v.visit_unit_require((const unit_require_t &)x); return; }
    }
}



/******************************************************************************/
// Visitor base class

template <class Struct>
class BaseVisitor
{
private:
    Struct& self() { return static_cast<Struct&>(*this); }
public:
    void visit_ast(const ast_t &b) { visit_ast_t(b, self()); }
    void visit_unit(const unit_t &b) { visit_unit_t(b, self()); }
        void visit_TranslationUnit(const TranslationUnit_t & /* x */) { throw LCompilersException("visit_TranslationUnit() not implemented"); }
    void visit_mod(const mod_t &b) { visit_mod_t(b, self()); }
        void visit_Module(const Module_t & /* x */) { throw LCompilersException("visit_Module() not implemented"); }
        void visit_Submodule(const Submodule_t & /* x */) { throw LCompilersException("visit_Submodule() not implemented"); }
        void visit_BlockData(const BlockData_t & /* x */) { throw LCompilersException("visit_BlockData() not implemented"); }
        void visit_Program(const Program_t & /* x */) { throw LCompilersException("visit_Program() not implemented"); }
    void visit_program_unit(const program_unit_t &b) { visit_program_unit_t(b, self()); }
        void visit_Subroutine(const Subroutine_t & /* x */) { throw LCompilersException("visit_Subroutine() not implemented"); }
        void visit_Procedure(const Procedure_t & /* x */) { throw LCompilersException("visit_Procedure() not implemented"); }
        void visit_Function(const Function_t & /* x */) { throw LCompilersException("visit_Function() not implemented"); }
    void visit_unit_decl1(const unit_decl1_t &b) { visit_unit_decl1_t(b, self()); }
        void visit_Use(const Use_t & /* x */) { throw LCompilersException("visit_Use() not implemented"); }
    void visit_unit_decl2(const unit_decl2_t &b) { visit_unit_decl2_t(b, self()); }
        void visit_Declaration(const Declaration_t & /* x */) { throw LCompilersException("visit_Declaration() not implemented"); }
        void visit_DeclarationPragma(const DeclarationPragma_t & /* x */) { throw LCompilersException("visit_DeclarationPragma() not implemented"); }
        void visit_Interface(const Interface_t & /* x */) { throw LCompilersException("visit_Interface() not implemented"); }
        void visit_DerivedType(const DerivedType_t & /* x */) { throw LCompilersException("visit_DerivedType() not implemented"); }
        void visit_Template(const Template_t & /* x */) { throw LCompilersException("visit_Template() not implemented"); }
        void visit_Enum(const Enum_t & /* x */) { throw LCompilersException("visit_Enum() not implemented"); }
        void visit_Instantiate(const Instantiate_t & /* x */) { throw LCompilersException("visit_Instantiate() not implemented"); }
        void visit_Requirement(const Requirement_t & /* x */) { throw LCompilersException("visit_Requirement() not implemented"); }
        void visit_Require(const Require_t & /* x */) { throw LCompilersException("visit_Require() not implemented"); }
    void visit_interface_header(const interface_header_t &b) { visit_interface_header_t(b, self()); }
        void visit_InterfaceHeader(const InterfaceHeader_t & /* x */) { throw LCompilersException("visit_InterfaceHeader() not implemented"); }
        void visit_InterfaceHeaderName(const InterfaceHeaderName_t & /* x */) { throw LCompilersException("visit_InterfaceHeaderName() not implemented"); }
        void visit_InterfaceHeaderAssignment(const InterfaceHeaderAssignment_t & /* x */) { throw LCompilersException("visit_InterfaceHeaderAssignment() not implemented"); }
        void visit_InterfaceHeaderOperator(const InterfaceHeaderOperator_t & /* x */) { throw LCompilersException("visit_InterfaceHeaderOperator() not implemented"); }
        void visit_InterfaceHeaderDefinedOperator(const InterfaceHeaderDefinedOperator_t & /* x */) { throw LCompilersException("visit_InterfaceHeaderDefinedOperator() not implemented"); }
        void visit_AbstractInterfaceHeader(const AbstractInterfaceHeader_t & /* x */) { throw LCompilersException("visit_AbstractInterfaceHeader() not implemented"); }
        void visit_InterfaceHeaderWrite(const InterfaceHeaderWrite_t & /* x */) { throw LCompilersException("visit_InterfaceHeaderWrite() not implemented"); }
        void visit_InterfaceHeaderRead(const InterfaceHeaderRead_t & /* x */) { throw LCompilersException("visit_InterfaceHeaderRead() not implemented"); }
    void visit_interface_item(const interface_item_t &b) { visit_interface_item_t(b, self()); }
        void visit_InterfaceProc(const InterfaceProc_t & /* x */) { throw LCompilersException("visit_InterfaceProc() not implemented"); }
        void visit_InterfaceModuleProcedure(const InterfaceModuleProcedure_t & /* x */) { throw LCompilersException("visit_InterfaceModuleProcedure() not implemented"); }
    void visit_import_statement(const import_statement_t &b) { visit_import_statement_t(b, self()); }
        void visit_Import(const Import_t & /* x */) { throw LCompilersException("visit_Import() not implemented"); }
    void visit_implicit_statement(const implicit_statement_t &b) { visit_implicit_statement_t(b, self()); }
        void visit_ImplicitNone(const ImplicitNone_t & /* x */) { throw LCompilersException("visit_ImplicitNone() not implemented"); }
        void visit_Implicit(const Implicit_t & /* x */) { throw LCompilersException("visit_Implicit() not implemented"); }
    void visit_implicit_none_spec(const implicit_none_spec_t &b) { visit_implicit_none_spec_t(b, self()); }
        void visit_ImplicitNoneExternal(const ImplicitNoneExternal_t & /* x */) { throw LCompilersException("visit_ImplicitNoneExternal() not implemented"); }
        void visit_ImplicitNoneType(const ImplicitNoneType_t & /* x */) { throw LCompilersException("visit_ImplicitNoneType() not implemented"); }
    void visit_letter_spec(const letter_spec_t &b) { visit_letter_spec_t(b, self()); }
        void visit_LetterSpec(const LetterSpec_t & /* x */) { throw LCompilersException("visit_LetterSpec() not implemented"); }
    void visit_stmt(const stmt_t &b) { visit_stmt_t(b, self()); }
        void visit_Allocate(const Allocate_t & /* x */) { throw LCompilersException("visit_Allocate() not implemented"); }
        void visit_Assign(const Assign_t & /* x */) { throw LCompilersException("visit_Assign() not implemented"); }
        void visit_Assignment(const Assignment_t & /* x */) { throw LCompilersException("visit_Assignment() not implemented"); }
        void visit_Associate(const Associate_t & /* x */) { throw LCompilersException("visit_Associate() not implemented"); }
        void visit_Backspace(const Backspace_t & /* x */) { throw LCompilersException("visit_Backspace() not implemented"); }
        void visit_Close(const Close_t & /* x */) { throw LCompilersException("visit_Close() not implemented"); }
        void visit_Continue(const Continue_t & /* x */) { throw LCompilersException("visit_Continue() not implemented"); }
        void visit_Cycle(const Cycle_t & /* x */) { throw LCompilersException("visit_Cycle() not implemented"); }
        void visit_Deallocate(const Deallocate_t & /* x */) { throw LCompilersException("visit_Deallocate() not implemented"); }
        void visit_Endfile(const Endfile_t & /* x */) { throw LCompilersException("visit_Endfile() not implemented"); }
        void visit_Entry(const Entry_t & /* x */) { throw LCompilersException("visit_Entry() not implemented"); }
        void visit_ErrorStop(const ErrorStop_t & /* x */) { throw LCompilersException("visit_ErrorStop() not implemented"); }
        void visit_EventPost(const EventPost_t & /* x */) { throw LCompilersException("visit_EventPost() not implemented"); }
        void visit_EventWait(const EventWait_t & /* x */) { throw LCompilersException("visit_EventWait() not implemented"); }
        void visit_Exit(const Exit_t & /* x */) { throw LCompilersException("visit_Exit() not implemented"); }
        void visit_Flush(const Flush_t & /* x */) { throw LCompilersException("visit_Flush() not implemented"); }
        void visit_ForAllSingle(const ForAllSingle_t & /* x */) { throw LCompilersException("visit_ForAllSingle() not implemented"); }
        void visit_Format(const Format_t & /* x */) { throw LCompilersException("visit_Format() not implemented"); }
        void visit_DataStmt(const DataStmt_t & /* x */) { throw LCompilersException("visit_DataStmt() not implemented"); }
        void visit_FormTeam(const FormTeam_t & /* x */) { throw LCompilersException("visit_FormTeam() not implemented"); }
        void visit_GoTo(const GoTo_t & /* x */) { throw LCompilersException("visit_GoTo() not implemented"); }
        void visit_Include(const Include_t & /* x */) { throw LCompilersException("visit_Include() not implemented"); }
        void visit_Inquire(const Inquire_t & /* x */) { throw LCompilersException("visit_Inquire() not implemented"); }
        void visit_Nullify(const Nullify_t & /* x */) { throw LCompilersException("visit_Nullify() not implemented"); }
        void visit_Open(const Open_t & /* x */) { throw LCompilersException("visit_Open() not implemented"); }
        void visit_Return(const Return_t & /* x */) { throw LCompilersException("visit_Return() not implemented"); }
        void visit_Pragma(const Pragma_t & /* x */) { throw LCompilersException("visit_Pragma() not implemented"); }
        void visit_Print(const Print_t & /* x */) { throw LCompilersException("visit_Print() not implemented"); }
        void visit_Read(const Read_t & /* x */) { throw LCompilersException("visit_Read() not implemented"); }
        void visit_Rewind(const Rewind_t & /* x */) { throw LCompilersException("visit_Rewind() not implemented"); }
        void visit_Stop(const Stop_t & /* x */) { throw LCompilersException("visit_Stop() not implemented"); }
        void visit_SubroutineCall(const SubroutineCall_t & /* x */) { throw LCompilersException("visit_SubroutineCall() not implemented"); }
        void visit_SyncAll(const SyncAll_t & /* x */) { throw LCompilersException("visit_SyncAll() not implemented"); }
        void visit_SyncImages(const SyncImages_t & /* x */) { throw LCompilersException("visit_SyncImages() not implemented"); }
        void visit_SyncMemory(const SyncMemory_t & /* x */) { throw LCompilersException("visit_SyncMemory() not implemented"); }
        void visit_SyncTeam(const SyncTeam_t & /* x */) { throw LCompilersException("visit_SyncTeam() not implemented"); }
        void visit_Write(const Write_t & /* x */) { throw LCompilersException("visit_Write() not implemented"); }
        void visit_AssociateBlock(const AssociateBlock_t & /* x */) { throw LCompilersException("visit_AssociateBlock() not implemented"); }
        void visit_Block(const Block_t & /* x */) { throw LCompilersException("visit_Block() not implemented"); }
        void visit_ChangeTeam(const ChangeTeam_t & /* x */) { throw LCompilersException("visit_ChangeTeam() not implemented"); }
        void visit_Critical(const Critical_t & /* x */) { throw LCompilersException("visit_Critical() not implemented"); }
        void visit_DoConcurrentLoop(const DoConcurrentLoop_t & /* x */) { throw LCompilersException("visit_DoConcurrentLoop() not implemented"); }
        void visit_DoLoop(const DoLoop_t & /* x */) { throw LCompilersException("visit_DoLoop() not implemented"); }
        void visit_ForAll(const ForAll_t & /* x */) { throw LCompilersException("visit_ForAll() not implemented"); }
        void visit_If(const If_t & /* x */) { throw LCompilersException("visit_If() not implemented"); }
        void visit_IfArithmetic(const IfArithmetic_t & /* x */) { throw LCompilersException("visit_IfArithmetic() not implemented"); }
        void visit_Select(const Select_t & /* x */) { throw LCompilersException("visit_Select() not implemented"); }
        void visit_SelectRank(const SelectRank_t & /* x */) { throw LCompilersException("visit_SelectRank() not implemented"); }
        void visit_SelectType(const SelectType_t & /* x */) { throw LCompilersException("visit_SelectType() not implemented"); }
        void visit_Where(const Where_t & /* x */) { throw LCompilersException("visit_Where() not implemented"); }
        void visit_WhileLoop(const WhileLoop_t & /* x */) { throw LCompilersException("visit_WhileLoop() not implemented"); }
    void visit_expr(const expr_t &b) { visit_expr_t(b, self()); }
        void visit_BoolOp(const BoolOp_t & /* x */) { throw LCompilersException("visit_BoolOp() not implemented"); }
        void visit_BinOp(const BinOp_t & /* x */) { throw LCompilersException("visit_BinOp() not implemented"); }
        void visit_DefBinOp(const DefBinOp_t & /* x */) { throw LCompilersException("visit_DefBinOp() not implemented"); }
        void visit_StrOp(const StrOp_t & /* x */) { throw LCompilersException("visit_StrOp() not implemented"); }
        void visit_UnaryOp(const UnaryOp_t & /* x */) { throw LCompilersException("visit_UnaryOp() not implemented"); }
        void visit_DefUnaryOp(const DefUnaryOp_t & /* x */) { throw LCompilersException("visit_DefUnaryOp() not implemented"); }
        void visit_Compare(const Compare_t & /* x */) { throw LCompilersException("visit_Compare() not implemented"); }
        void visit_FuncCallOrArray(const FuncCallOrArray_t & /* x */) { throw LCompilersException("visit_FuncCallOrArray() not implemented"); }
        void visit_CoarrayRef(const CoarrayRef_t & /* x */) { throw LCompilersException("visit_CoarrayRef() not implemented"); }
        void visit_ArrayInitializer(const ArrayInitializer_t & /* x */) { throw LCompilersException("visit_ArrayInitializer() not implemented"); }
        void visit_ImpliedDoLoop(const ImpliedDoLoop_t & /* x */) { throw LCompilersException("visit_ImpliedDoLoop() not implemented"); }
        void visit_Num(const Num_t & /* x */) { throw LCompilersException("visit_Num() not implemented"); }
        void visit_Real(const Real_t & /* x */) { throw LCompilersException("visit_Real() not implemented"); }
        void visit_Complex(const Complex_t & /* x */) { throw LCompilersException("visit_Complex() not implemented"); }
        void visit_String(const String_t & /* x */) { throw LCompilersException("visit_String() not implemented"); }
        void visit_Substring(const Substring_t & /* x */) { throw LCompilersException("visit_Substring() not implemented"); }
        void visit_BOZ(const BOZ_t & /* x */) { throw LCompilersException("visit_BOZ() not implemented"); }
        void visit_Name(const Name_t & /* x */) { throw LCompilersException("visit_Name() not implemented"); }
        void visit_Logical(const Logical_t & /* x */) { throw LCompilersException("visit_Logical() not implemented"); }
        void visit_DataImpliedDo(const DataImpliedDo_t & /* x */) { throw LCompilersException("visit_DataImpliedDo() not implemented"); }
        void visit_Parenthesis(const Parenthesis_t & /* x */) { throw LCompilersException("visit_Parenthesis() not implemented"); }
    void visit_trivia(const trivia_t &b) { visit_trivia_t(b, self()); }
        void visit_TriviaNode(const TriviaNode_t & /* x */) { throw LCompilersException("visit_TriviaNode() not implemented"); }
    void visit_trivia_node(const trivia_node_t &b) { visit_trivia_node_t(b, self()); }
        void visit_Comment(const Comment_t & /* x */) { throw LCompilersException("visit_Comment() not implemented"); }
        void visit_EOLComment(const EOLComment_t & /* x */) { throw LCompilersException("visit_EOLComment() not implemented"); }
        void visit_EndOfLine(const EndOfLine_t & /* x */) { throw LCompilersException("visit_EndOfLine() not implemented"); }
        void visit_Semicolon(const Semicolon_t & /* x */) { throw LCompilersException("visit_Semicolon() not implemented"); }
    void visit_procedure_decl(const procedure_decl_t &b) { visit_procedure_decl_t(b, self()); }
        void visit_DerivedTypeProc(const DerivedTypeProc_t & /* x */) { throw LCompilersException("visit_DerivedTypeProc() not implemented"); }
        void visit_GenericOperator(const GenericOperator_t & /* x */) { throw LCompilersException("visit_GenericOperator() not implemented"); }
        void visit_GenericDefinedOperator(const GenericDefinedOperator_t & /* x */) { throw LCompilersException("visit_GenericDefinedOperator() not implemented"); }
        void visit_GenericAssignment(const GenericAssignment_t & /* x */) { throw LCompilersException("visit_GenericAssignment() not implemented"); }
        void visit_GenericName(const GenericName_t & /* x */) { throw LCompilersException("visit_GenericName() not implemented"); }
        void visit_GenericWrite(const GenericWrite_t & /* x */) { throw LCompilersException("visit_GenericWrite() not implemented"); }
        void visit_GenericRead(const GenericRead_t & /* x */) { throw LCompilersException("visit_GenericRead() not implemented"); }
        void visit_FinalName(const FinalName_t & /* x */) { throw LCompilersException("visit_FinalName() not implemented"); }
        void visit_Private(const Private_t & /* x */) { throw LCompilersException("visit_Private() not implemented"); }
    void visit_decl_attribute(const decl_attribute_t &b) { visit_decl_attribute_t(b, self()); }
        void visit_AttrBind(const AttrBind_t & /* x */) { throw LCompilersException("visit_AttrBind() not implemented"); }
        void visit_AttrDimension(const AttrDimension_t & /* x */) { throw LCompilersException("visit_AttrDimension() not implemented"); }
        void visit_AttrCodimension(const AttrCodimension_t & /* x */) { throw LCompilersException("visit_AttrCodimension() not implemented"); }
        void visit_AttrEquivalence(const AttrEquivalence_t & /* x */) { throw LCompilersException("visit_AttrEquivalence() not implemented"); }
        void visit_AttrExtends(const AttrExtends_t & /* x */) { throw LCompilersException("visit_AttrExtends() not implemented"); }
        void visit_AttrIntent(const AttrIntent_t & /* x */) { throw LCompilersException("visit_AttrIntent() not implemented"); }
        void visit_AttrNamelist(const AttrNamelist_t & /* x */) { throw LCompilersException("visit_AttrNamelist() not implemented"); }
        void visit_AttrPass(const AttrPass_t & /* x */) { throw LCompilersException("visit_AttrPass() not implemented"); }
        void visit_SimpleAttribute(const SimpleAttribute_t & /* x */) { throw LCompilersException("visit_SimpleAttribute() not implemented"); }
        void visit_AttrType(const AttrType_t & /* x */) { throw LCompilersException("visit_AttrType() not implemented"); }
        void visit_AttrAssignment(const AttrAssignment_t & /* x */) { throw LCompilersException("visit_AttrAssignment() not implemented"); }
        void visit_AttrIntrinsicOperator(const AttrIntrinsicOperator_t & /* x */) { throw LCompilersException("visit_AttrIntrinsicOperator() not implemented"); }
        void visit_AttrDefinedOperator(const AttrDefinedOperator_t & /* x */) { throw LCompilersException("visit_AttrDefinedOperator() not implemented"); }
    void visit_event_attribute(const event_attribute_t &b) { visit_event_attribute_t(b, self()); }
        void visit_AttrStat(const AttrStat_t & /* x */) { throw LCompilersException("visit_AttrStat() not implemented"); }
        void visit_AttrErrmsg(const AttrErrmsg_t & /* x */) { throw LCompilersException("visit_AttrErrmsg() not implemented"); }
        void visit_AttrNewIndex(const AttrNewIndex_t & /* x */) { throw LCompilersException("visit_AttrNewIndex() not implemented"); }
        void visit_AttrEventWaitKwArg(const AttrEventWaitKwArg_t & /* x */) { throw LCompilersException("visit_AttrEventWaitKwArg() not implemented"); }
    void visit_team_attribute(const team_attribute_t &b) { visit_team_attribute_t(b, self()); }
        void visit_CoarrayAssociation(const CoarrayAssociation_t & /* x */) { throw LCompilersException("visit_CoarrayAssociation() not implemented"); }
    void visit_bind(const bind_t &b) { visit_bind_t(b, self()); }
        void visit_Bind(const Bind_t & /* x */) { throw LCompilersException("visit_Bind() not implemented"); }
    void visit_array_index(const array_index_t &b) { visit_array_index_t(b, self()); }
        void visit_ArrayIndex(const ArrayIndex_t & /* x */) { throw LCompilersException("visit_ArrayIndex() not implemented"); }
    void visit_case_stmt(const case_stmt_t &b) { visit_case_stmt_t(b, self()); }
        void visit_CaseStmt(const CaseStmt_t & /* x */) { throw LCompilersException("visit_CaseStmt() not implemented"); }
        void visit_CaseStmt_Default(const CaseStmt_Default_t & /* x */) { throw LCompilersException("visit_CaseStmt_Default() not implemented"); }
    void visit_case_cond(const case_cond_t &b) { visit_case_cond_t(b, self()); }
        void visit_CaseCondExpr(const CaseCondExpr_t & /* x */) { throw LCompilersException("visit_CaseCondExpr() not implemented"); }
        void visit_CaseCondRange(const CaseCondRange_t & /* x */) { throw LCompilersException("visit_CaseCondRange() not implemented"); }
    void visit_rank_stmt(const rank_stmt_t &b) { visit_rank_stmt_t(b, self()); }
        void visit_RankExpr(const RankExpr_t & /* x */) { throw LCompilersException("visit_RankExpr() not implemented"); }
        void visit_RankStar(const RankStar_t & /* x */) { throw LCompilersException("visit_RankStar() not implemented"); }
        void visit_RankDefault(const RankDefault_t & /* x */) { throw LCompilersException("visit_RankDefault() not implemented"); }
    void visit_type_stmt(const type_stmt_t &b) { visit_type_stmt_t(b, self()); }
        void visit_TypeStmtName(const TypeStmtName_t & /* x */) { throw LCompilersException("visit_TypeStmtName() not implemented"); }
        void visit_TypeStmtType(const TypeStmtType_t & /* x */) { throw LCompilersException("visit_TypeStmtType() not implemented"); }
        void visit_ClassStmt(const ClassStmt_t & /* x */) { throw LCompilersException("visit_ClassStmt() not implemented"); }
        void visit_ClassDefault(const ClassDefault_t & /* x */) { throw LCompilersException("visit_ClassDefault() not implemented"); }
    void visit_use_symbol(const use_symbol_t &b) { visit_use_symbol_t(b, self()); }
        void visit_UseSymbol(const UseSymbol_t & /* x */) { throw LCompilersException("visit_UseSymbol() not implemented"); }
        void visit_UseAssignment(const UseAssignment_t & /* x */) { throw LCompilersException("visit_UseAssignment() not implemented"); }
        void visit_IntrinsicOperator(const IntrinsicOperator_t & /* x */) { throw LCompilersException("visit_IntrinsicOperator() not implemented"); }
        void visit_DefinedOperator(const DefinedOperator_t & /* x */) { throw LCompilersException("visit_DefinedOperator() not implemented"); }
        void visit_RenameOperator(const RenameOperator_t & /* x */) { throw LCompilersException("visit_RenameOperator() not implemented"); }
        void visit_UseWrite(const UseWrite_t & /* x */) { throw LCompilersException("visit_UseWrite() not implemented"); }
        void visit_UseRead(const UseRead_t & /* x */) { throw LCompilersException("visit_UseRead() not implemented"); }
    void visit_concurrent_control(const concurrent_control_t &b) { visit_concurrent_control_t(b, self()); }
        void visit_ConcurrentControl(const ConcurrentControl_t & /* x */) { throw LCompilersException("visit_ConcurrentControl() not implemented"); }
    void visit_concurrent_locality(const concurrent_locality_t &b) { visit_concurrent_locality_t(b, self()); }
        void visit_ConcurrentLocal(const ConcurrentLocal_t & /* x */) { throw LCompilersException("visit_ConcurrentLocal() not implemented"); }
        void visit_ConcurrentLocalInit(const ConcurrentLocalInit_t & /* x */) { throw LCompilersException("visit_ConcurrentLocalInit() not implemented"); }
        void visit_ConcurrentShared(const ConcurrentShared_t & /* x */) { throw LCompilersException("visit_ConcurrentShared() not implemented"); }
        void visit_ConcurrentDefault(const ConcurrentDefault_t & /* x */) { throw LCompilersException("visit_ConcurrentDefault() not implemented"); }
        void visit_ConcurrentReduce(const ConcurrentReduce_t & /* x */) { throw LCompilersException("visit_ConcurrentReduce() not implemented"); }
    void visit_data_stmt_set(const data_stmt_set_t &b) { visit_data_stmt_set_t(b, self()); }
        void visit_DataStmtSet(const DataStmtSet_t & /* x */) { throw LCompilersException("visit_DataStmtSet() not implemented"); }
    void visit_unit_require(const unit_require_t &b) { visit_unit_require_t(b, self()); }
        void visit_UnitRequire(const UnitRequire_t & /* x */) { throw LCompilersException("visit_UnitRequire() not implemented"); }
};


/******************************************************************************/
// Walk Visitor base class

template <class Struct>
class BaseWalkVisitor : public BaseVisitor<Struct>
{
private:
    Struct& self() { return static_cast<Struct&>(*this); }
public:
    void visit_TranslationUnit(const TranslationUnit_t &x) {
        if ((bool&)x) { } // Suppress unused warning
    }
    void visit_Module(const Module_t &x) {
        if (x.m_trivia)
            self().visit_trivia(*x.m_trivia);
        for (size_t i=0; i<x.n_use; i++) {
            self().visit_unit_decl1(*x.m_use[i]);
        }
        for (size_t i=0; i<x.n_implicit; i++) {
            self().visit_implicit_statement(*x.m_implicit[i]);
        }
        for (size_t i=0; i<x.n_decl; i++) {
            self().visit_unit_decl2(*x.m_decl[i]);
        }
        for (size_t i=0; i<x.n_contains; i++) {
            self().visit_program_unit(*x.m_contains[i]);
        }
    }
    void visit_Submodule(const Submodule_t &x) {
        if (x.m_trivia)
            self().visit_trivia(*x.m_trivia);
        for (size_t i=0; i<x.n_use; i++) {
            self().visit_unit_decl1(*x.m_use[i]);
        }
        for (size_t i=0; i<x.n_implicit; i++) {
            self().visit_implicit_statement(*x.m_implicit[i]);
        }
        for (size_t i=0; i<x.n_decl; i++) {
            self().visit_unit_decl2(*x.m_decl[i]);
        }
        for (size_t i=0; i<x.n_contains; i++) {
            self().visit_program_unit(*x.m_contains[i]);
        }
    }
    void visit_BlockData(const BlockData_t &x) {
        if (x.m_trivia)
            self().visit_trivia(*x.m_trivia);
        for (size_t i=0; i<x.n_use; i++) {
            self().visit_unit_decl1(*x.m_use[i]);
        }
        for (size_t i=0; i<x.n_implicit; i++) {
            self().visit_implicit_statement(*x.m_implicit[i]);
        }
        for (size_t i=0; i<x.n_decl; i++) {
            self().visit_unit_decl2(*x.m_decl[i]);
        }
        for (size_t i=0; i<x.n_body; i++) {
            self().visit_stmt(*x.m_body[i]);
        }
    }
    void visit_Program(const Program_t &x) {
        if (x.m_trivia)
            self().visit_trivia(*x.m_trivia);
        for (size_t i=0; i<x.n_use; i++) {
            self().visit_unit_decl1(*x.m_use[i]);
        }
        for (size_t i=0; i<x.n_implicit; i++) {
            self().visit_implicit_statement(*x.m_implicit[i]);
        }
        for (size_t i=0; i<x.n_decl; i++) {
            self().visit_unit_decl2(*x.m_decl[i]);
        }
        for (size_t i=0; i<x.n_body; i++) {
            self().visit_stmt(*x.m_body[i]);
        }
        for (size_t i=0; i<x.n_contains; i++) {
            self().visit_program_unit(*x.m_contains[i]);
        }
    }
    void visit_Subroutine(const Subroutine_t &x) {
        for (size_t i=0; i<x.n_args; i++) {
            self().visit_arg(x.m_args[i]);
        }
        for (size_t i=0; i<x.n_attributes; i++) {
            self().visit_decl_attribute(*x.m_attributes[i]);
        }
        if (x.m_bind)
            self().visit_bind(*x.m_bind);
        if (x.m_trivia)
            self().visit_trivia(*x.m_trivia);
        for (size_t i=0; i<x.n_use; i++) {
            self().visit_unit_decl1(*x.m_use[i]);
        }
        for (size_t i=0; i<x.n_import; i++) {
            self().visit_import_statement(*x.m_import[i]);
        }
        for (size_t i=0; i<x.n_implicit; i++) {
            self().visit_implicit_statement(*x.m_implicit[i]);
        }
        for (size_t i=0; i<x.n_decl; i++) {
            self().visit_unit_decl2(*x.m_decl[i]);
        }
        for (size_t i=0; i<x.n_body; i++) {
            self().visit_stmt(*x.m_body[i]);
        }
        for (size_t i=0; i<x.n_contains; i++) {
            self().visit_program_unit(*x.m_contains[i]);
        }
    }
    void visit_Procedure(const Procedure_t &x) {
        for (size_t i=0; i<x.n_args; i++) {
            self().visit_arg(x.m_args[i]);
        }
        for (size_t i=0; i<x.n_attributes; i++) {
            self().visit_decl_attribute(*x.m_attributes[i]);
        }
        if (x.m_trivia)
            self().visit_trivia(*x.m_trivia);
        for (size_t i=0; i<x.n_use; i++) {
            self().visit_unit_decl1(*x.m_use[i]);
        }
        for (size_t i=0; i<x.n_import; i++) {
            self().visit_import_statement(*x.m_import[i]);
        }
        for (size_t i=0; i<x.n_implicit; i++) {
            self().visit_implicit_statement(*x.m_implicit[i]);
        }
        for (size_t i=0; i<x.n_decl; i++) {
            self().visit_unit_decl2(*x.m_decl[i]);
        }
        for (size_t i=0; i<x.n_body; i++) {
            self().visit_stmt(*x.m_body[i]);
        }
        for (size_t i=0; i<x.n_contains; i++) {
            self().visit_program_unit(*x.m_contains[i]);
        }
    }
    void visit_Function(const Function_t &x) {
        for (size_t i=0; i<x.n_args; i++) {
            self().visit_arg(x.m_args[i]);
        }
        for (size_t i=0; i<x.n_attributes; i++) {
            self().visit_decl_attribute(*x.m_attributes[i]);
        }
        if (x.m_return_var)
            self().visit_expr(*x.m_return_var);
        if (x.m_bind)
            self().visit_bind(*x.m_bind);
        if (x.m_trivia)
            self().visit_trivia(*x.m_trivia);
        for (size_t i=0; i<x.n_use; i++) {
            self().visit_unit_decl1(*x.m_use[i]);
        }
        for (size_t i=0; i<x.n_import; i++) {
            self().visit_import_statement(*x.m_import[i]);
        }
        for (size_t i=0; i<x.n_implicit; i++) {
            self().visit_implicit_statement(*x.m_implicit[i]);
        }
        for (size_t i=0; i<x.n_decl; i++) {
            self().visit_unit_decl2(*x.m_decl[i]);
        }
        for (size_t i=0; i<x.n_body; i++) {
            self().visit_stmt(*x.m_body[i]);
        }
        for (size_t i=0; i<x.n_contains; i++) {
            self().visit_program_unit(*x.m_contains[i]);
        }
    }
    void visit_Use(const Use_t &x) {
        for (size_t i=0; i<x.n_nature; i++) {
            self().visit_decl_attribute(*x.m_nature[i]);
        }
        for (size_t i=0; i<x.n_symbols; i++) {
            self().visit_use_symbol(*x.m_symbols[i]);
        }
        if (x.m_trivia)
            self().visit_trivia(*x.m_trivia);
    }
    void visit_Declaration(const Declaration_t &x) {
        if (x.m_vartype)
            self().visit_decl_attribute(*x.m_vartype);
        for (size_t i=0; i<x.n_attributes; i++) {
            self().visit_decl_attribute(*x.m_attributes[i]);
        }
        for (size_t i=0; i<x.n_syms; i++) {
            self().visit_var_sym(x.m_syms[i]);
        }
        if (x.m_trivia)
            self().visit_trivia(*x.m_trivia);
    }
    void visit_DeclarationPragma(const DeclarationPragma_t &x) {
        if (x.m_trivia)
            self().visit_trivia(*x.m_trivia);
    }
    void visit_Interface(const Interface_t &x) {
        self().visit_interface_header(*x.m_header);
        if (x.m_trivia)
            self().visit_trivia(*x.m_trivia);
        for (size_t i=0; i<x.n_items; i++) {
            self().visit_interface_item(*x.m_items[i]);
        }
    }
    void visit_DerivedType(const DerivedType_t &x) {
        if (x.m_trivia)
            self().visit_trivia(*x.m_trivia);
        for (size_t i=0; i<x.n_attrtype; i++) {
            self().visit_decl_attribute(*x.m_attrtype[i]);
        }
        for (size_t i=0; i<x.n_items; i++) {
            self().visit_unit_decl2(*x.m_items[i]);
        }
        for (size_t i=0; i<x.n_contains; i++) {
            self().visit_procedure_decl(*x.m_contains[i]);
        }
    }
    void visit_Template(const Template_t &x) {
        for (size_t i=0; i<x.n_decl; i++) {
            self().visit_unit_decl2(*x.m_decl[i]);
        }
        for (size_t i=0; i<x.n_contains; i++) {
            self().visit_program_unit(*x.m_contains[i]);
        }
    }
    void visit_Enum(const Enum_t &x) {
        for (size_t i=0; i<x.n_attr; i++) {
            self().visit_decl_attribute(*x.m_attr[i]);
        }
        if (x.m_trivia)
            self().visit_trivia(*x.m_trivia);
        for (size_t i=0; i<x.n_items; i++) {
            self().visit_unit_decl2(*x.m_items[i]);
        }
    }
    void visit_Instantiate(const Instantiate_t &x) {
        for (size_t i=0; i<x.n_args; i++) {
            self().visit_decl_attribute(*x.m_args[i]);
        }
        for (size_t i=0; i<x.n_symbols; i++) {
            self().visit_use_symbol(*x.m_symbols[i]);
        }
    }
    void visit_Requirement(const Requirement_t &x) {
        for (size_t i=0; i<x.n_decl; i++) {
            self().visit_unit_decl2(*x.m_decl[i]);
        }
        for (size_t i=0; i<x.n_funcs; i++) {
            self().visit_program_unit(*x.m_funcs[i]);
        }
    }
    void visit_Require(const Require_t &x) {
        for (size_t i=0; i<x.n_reqs; i++) {
            self().visit_unit_require(*x.m_reqs[i]);
        }
    }
    void visit_InterfaceHeader(const InterfaceHeader_t &x) {
        if ((bool&)x) { } // Suppress unused warning
    }
    void visit_InterfaceHeaderName(const InterfaceHeaderName_t &x) {
        if ((bool&)x) { } // Suppress unused warning
    }
    void visit_InterfaceHeaderAssignment(const InterfaceHeaderAssignment_t &x) {
        if ((bool&)x) { } // Suppress unused warning
    }
    void visit_InterfaceHeaderOperator(const InterfaceHeaderOperator_t &x) {
        if ((bool&)x) { } // Suppress unused warning
    }
    void visit_InterfaceHeaderDefinedOperator(const InterfaceHeaderDefinedOperator_t &x) {
        if ((bool&)x) { } // Suppress unused warning
    }
    void visit_AbstractInterfaceHeader(const AbstractInterfaceHeader_t &x) {
        if ((bool&)x) { } // Suppress unused warning
    }
    void visit_InterfaceHeaderWrite(const InterfaceHeaderWrite_t &x) {
        if ((bool&)x) { } // Suppress unused warning
    }
    void visit_InterfaceHeaderRead(const InterfaceHeaderRead_t &x) {
        if ((bool&)x) { } // Suppress unused warning
    }
    void visit_InterfaceProc(const InterfaceProc_t &x) {
        self().visit_program_unit(*x.m_proc);
    }
    void visit_InterfaceModuleProcedure(const InterfaceModuleProcedure_t &x) {
        for (size_t i=0; i<x.n_attributes; i++) {
            self().visit_decl_attribute(*x.m_attributes[i]);
        }
        if (x.m_trivia)
            self().visit_trivia(*x.m_trivia);
    }
    void visit_Import(const Import_t &x) {
        if (x.m_trivia)
            self().visit_trivia(*x.m_trivia);
    }
    void visit_ImplicitNone(const ImplicitNone_t &x) {
        for (size_t i=0; i<x.n_specs; i++) {
            self().visit_implicit_none_spec(*x.m_specs[i]);
        }
        if (x.m_trivia)
            self().visit_trivia(*x.m_trivia);
    }
    void visit_Implicit(const Implicit_t &x) {
        self().visit_decl_attribute(*x.m_type);
        for (size_t i=0; i<x.n_kind; i++) {
            self().visit_letter_spec(*x.m_kind[i]);
        }
        for (size_t i=0; i<x.n_specs; i++) {
            self().visit_letter_spec(*x.m_specs[i]);
        }
        if (x.m_trivia)
            self().visit_trivia(*x.m_trivia);
    }
    void visit_ImplicitNoneExternal(const ImplicitNoneExternal_t &x) {
        if ((bool&)x) { } // Suppress unused warning
    }
    void visit_ImplicitNoneType(const ImplicitNoneType_t &x) {
        if ((bool&)x) { } // Suppress unused warning
    }
    void visit_LetterSpec(const LetterSpec_t &x) {
        if ((bool&)x) { } // Suppress unused warning
    }
    void visit_Allocate(const Allocate_t &x) {
        for (size_t i=0; i<x.n_args; i++) {
            self().visit_fnarg(x.m_args[i]);
        }
        for (size_t i=0; i<x.n_keywords; i++) {
            self().visit_keyword(x.m_keywords[i]);
        }
        if (x.m_trivia)
            self().visit_trivia(*x.m_trivia);
    }
    void visit_Assign(const Assign_t &x) {
        if (x.m_trivia)
            self().visit_trivia(*x.m_trivia);
    }
    void visit_Assignment(const Assignment_t &x) {
        self().visit_expr(*x.m_target);
        self().visit_expr(*x.m_value);
        if (x.m_trivia)
            self().visit_trivia(*x.m_trivia);
    }
    void visit_Associate(const Associate_t &x) {
        self().visit_expr(*x.m_target);
        self().visit_expr(*x.m_value);
        if (x.m_trivia)
            self().visit_trivia(*x.m_trivia);
    }
    void visit_Backspace(const Backspace_t &x) {
        for (size_t i=0; i<x.n_args; i++) {
            self().visit_expr(*x.m_args[i]);
        }
        for (size_t i=0; i<x.n_kwargs; i++) {
            self().visit_keyword(x.m_kwargs[i]);
        }
        if (x.m_trivia)
            self().visit_trivia(*x.m_trivia);
    }
    void visit_Close(const Close_t &x) {
        for (size_t i=0; i<x.n_args; i++) {
            self().visit_expr(*x.m_args[i]);
        }
        for (size_t i=0; i<x.n_kwargs; i++) {
            self().visit_keyword(x.m_kwargs[i]);
        }
        if (x.m_trivia)
            self().visit_trivia(*x.m_trivia);
    }
    void visit_Continue(const Continue_t &x) {
        if (x.m_trivia)
            self().visit_trivia(*x.m_trivia);
    }
    void visit_Cycle(const Cycle_t &x) {
        if (x.m_trivia)
            self().visit_trivia(*x.m_trivia);
    }
    void visit_Deallocate(const Deallocate_t &x) {
        for (size_t i=0; i<x.n_args; i++) {
            self().visit_fnarg(x.m_args[i]);
        }
        for (size_t i=0; i<x.n_keywords; i++) {
            self().visit_keyword(x.m_keywords[i]);
        }
        if (x.m_trivia)
            self().visit_trivia(*x.m_trivia);
    }
    void visit_Endfile(const Endfile_t &x) {
        for (size_t i=0; i<x.n_args; i++) {
            self().visit_expr(*x.m_args[i]);
        }
        for (size_t i=0; i<x.n_kwargs; i++) {
            self().visit_keyword(x.m_kwargs[i]);
        }
        if (x.m_trivia)
            self().visit_trivia(*x.m_trivia);
    }
    void visit_Entry(const Entry_t &x) {
        for (size_t i=0; i<x.n_args; i++) {
            self().visit_arg(x.m_args[i]);
        }
        if (x.m_return_var)
            self().visit_expr(*x.m_return_var);
        if (x.m_bind)
            self().visit_bind(*x.m_bind);
        if (x.m_trivia)
            self().visit_trivia(*x.m_trivia);
    }
    void visit_ErrorStop(const ErrorStop_t &x) {
        if (x.m_code)
            self().visit_expr(*x.m_code);
        if (x.m_quiet)
            self().visit_expr(*x.m_quiet);
        if (x.m_trivia)
            self().visit_trivia(*x.m_trivia);
    }
    void visit_EventPost(const EventPost_t &x) {
        self().visit_expr(*x.m_variable);
        for (size_t i=0; i<x.n_stat; i++) {
            self().visit_event_attribute(*x.m_stat[i]);
        }
        if (x.m_trivia)
            self().visit_trivia(*x.m_trivia);
    }
    void visit_EventWait(const EventWait_t &x) {
        self().visit_expr(*x.m_variable);
        for (size_t i=0; i<x.n_spec; i++) {
            self().visit_event_attribute(*x.m_spec[i]);
        }
        if (x.m_trivia)
            self().visit_trivia(*x.m_trivia);
    }
    void visit_Exit(const Exit_t &x) {
        if (x.m_trivia)
            self().visit_trivia(*x.m_trivia);
    }
    void visit_Flush(const Flush_t &x) {
        for (size_t i=0; i<x.n_args; i++) {
            self().visit_expr(*x.m_args[i]);
        }
        for (size_t i=0; i<x.n_kwargs; i++) {
            self().visit_keyword(x.m_kwargs[i]);
        }
        if (x.m_trivia)
            self().visit_trivia(*x.m_trivia);
    }
    void visit_ForAllSingle(const ForAllSingle_t &x) {
        for (size_t i=0; i<x.n_control; i++) {
            self().visit_concurrent_control(*x.m_control[i]);
        }
        if (x.m_mask)
            self().visit_expr(*x.m_mask);
        self().visit_stmt(*x.m_assign);
        if (x.m_trivia)
            self().visit_trivia(*x.m_trivia);
    }
    void visit_Format(const Format_t &x) {
        if (x.m_trivia)
            self().visit_trivia(*x.m_trivia);
    }
    void visit_DataStmt(const DataStmt_t &x) {
        for (size_t i=0; i<x.n_items; i++) {
            self().visit_data_stmt_set(*x.m_items[i]);
        }
        if (x.m_trivia)
            self().visit_trivia(*x.m_trivia);
    }
    void visit_FormTeam(const FormTeam_t &x) {
        self().visit_expr(*x.m_team_number);
        for (size_t i=0; i<x.n_sync_stat; i++) {
            self().visit_event_attribute(*x.m_sync_stat[i]);
        }
        if (x.m_trivia)
            self().visit_trivia(*x.m_trivia);
    }
    void visit_GoTo(const GoTo_t &x) {
        if (x.m_goto_label)
            self().visit_expr(*x.m_goto_label);
        for (size_t i=0; i<x.n_labels; i++) {
            self().visit_expr(*x.m_labels[i]);
        }
        if (x.m_trivia)
            self().visit_trivia(*x.m_trivia);
    }
    void visit_Include(const Include_t &x) {
        if (x.m_trivia)
            self().visit_trivia(*x.m_trivia);
    }
    void visit_Inquire(const Inquire_t &x) {
        for (size_t i=0; i<x.n_args; i++) {
            self().visit_expr(*x.m_args[i]);
        }
        for (size_t i=0; i<x.n_kwargs; i++) {
            self().visit_keyword(x.m_kwargs[i]);
        }
        for (size_t i=0; i<x.n_values; i++) {
            self().visit_expr(*x.m_values[i]);
        }
        if (x.m_trivia)
            self().visit_trivia(*x.m_trivia);
    }
    void visit_Nullify(const Nullify_t &x) {
        for (size_t i=0; i<x.n_args; i++) {
            self().visit_expr(*x.m_args[i]);
        }
        for (size_t i=0; i<x.n_kwargs; i++) {
            self().visit_keyword(x.m_kwargs[i]);
        }
        if (x.m_trivia)
            self().visit_trivia(*x.m_trivia);
    }
    void visit_Open(const Open_t &x) {
        for (size_t i=0; i<x.n_args; i++) {
            self().visit_expr(*x.m_args[i]);
        }
        for (size_t i=0; i<x.n_kwargs; i++) {
            self().visit_keyword(x.m_kwargs[i]);
        }
        if (x.m_trivia)
            self().visit_trivia(*x.m_trivia);
    }
    void visit_Return(const Return_t &x) {
        if (x.m_value)
            self().visit_expr(*x.m_value);
        if (x.m_trivia)
            self().visit_trivia(*x.m_trivia);
    }
    void visit_Pragma(const Pragma_t &x) {
        for (size_t i=0; i<x.n_clauses; i++) {
            self().visit_expr(*x.m_clauses[i]);
        }
        if (x.m_trivia)
            self().visit_trivia(*x.m_trivia);
    }
    void visit_Print(const Print_t &x) {
        if (x.m_fmt)
            self().visit_expr(*x.m_fmt);
        for (size_t i=0; i<x.n_values; i++) {
            self().visit_expr(*x.m_values[i]);
        }
        if (x.m_trivia)
            self().visit_trivia(*x.m_trivia);
    }
    void visit_Read(const Read_t &x) {
        if (x.m_format)
            self().visit_expr(*x.m_format);
        for (size_t i=0; i<x.n_args; i++) {
            self().visit_argstar(x.m_args[i]);
        }
        for (size_t i=0; i<x.n_kwargs; i++) {
            self().visit_kw_argstar(x.m_kwargs[i]);
        }
        for (size_t i=0; i<x.n_values; i++) {
            self().visit_expr(*x.m_values[i]);
        }
        if (x.m_trivia)
            self().visit_trivia(*x.m_trivia);
    }
    void visit_Rewind(const Rewind_t &x) {
        for (size_t i=0; i<x.n_args; i++) {
            self().visit_expr(*x.m_args[i]);
        }
        for (size_t i=0; i<x.n_kwargs; i++) {
            self().visit_keyword(x.m_kwargs[i]);
        }
        if (x.m_trivia)
            self().visit_trivia(*x.m_trivia);
    }
    void visit_Stop(const Stop_t &x) {
        if (x.m_code)
            self().visit_expr(*x.m_code);
        if (x.m_quiet)
            self().visit_expr(*x.m_quiet);
        if (x.m_trivia)
            self().visit_trivia(*x.m_trivia);
    }
    void visit_SubroutineCall(const SubroutineCall_t &x) {
        for (size_t i=0; i<x.n_member; i++) {
            self().visit_struct_member(x.m_member[i]);
        }
        for (size_t i=0; i<x.n_args; i++) {
            self().visit_fnarg(x.m_args[i]);
        }
        for (size_t i=0; i<x.n_keywords; i++) {
            self().visit_keyword(x.m_keywords[i]);
        }
        for (size_t i=0; i<x.n_temp_args; i++) {
            self().visit_decl_attribute(*x.m_temp_args[i]);
        }
        if (x.m_trivia)
            self().visit_trivia(*x.m_trivia);
    }
    void visit_SyncAll(const SyncAll_t &x) {
        for (size_t i=0; i<x.n_stat; i++) {
            self().visit_event_attribute(*x.m_stat[i]);
        }
        if (x.m_trivia)
            self().visit_trivia(*x.m_trivia);
    }
    void visit_SyncImages(const SyncImages_t &x) {
        if (x.m_image_set)
            self().visit_expr(*x.m_image_set);
        for (size_t i=0; i<x.n_stat; i++) {
            self().visit_event_attribute(*x.m_stat[i]);
        }
        if (x.m_trivia)
            self().visit_trivia(*x.m_trivia);
    }
    void visit_SyncMemory(const SyncMemory_t &x) {
        for (size_t i=0; i<x.n_stat; i++) {
            self().visit_event_attribute(*x.m_stat[i]);
        }
        if (x.m_trivia)
            self().visit_trivia(*x.m_trivia);
    }
    void visit_SyncTeam(const SyncTeam_t &x) {
        self().visit_expr(*x.m_value);
        for (size_t i=0; i<x.n_stat; i++) {
            self().visit_event_attribute(*x.m_stat[i]);
        }
        if (x.m_trivia)
            self().visit_trivia(*x.m_trivia);
    }
    void visit_Write(const Write_t &x) {
        for (size_t i=0; i<x.n_args; i++) {
            self().visit_argstar(x.m_args[i]);
        }
        for (size_t i=0; i<x.n_kwargs; i++) {
            self().visit_kw_argstar(x.m_kwargs[i]);
        }
        for (size_t i=0; i<x.n_values; i++) {
            self().visit_expr(*x.m_values[i]);
        }
        if (x.m_trivia)
            self().visit_trivia(*x.m_trivia);
    }
    void visit_AssociateBlock(const AssociateBlock_t &x) {
        for (size_t i=0; i<x.n_syms; i++) {
            self().visit_var_sym(x.m_syms[i]);
        }
        for (size_t i=0; i<x.n_body; i++) {
            self().visit_stmt(*x.m_body[i]);
        }
        if (x.m_t_inside)
            self().visit_trivia(*x.m_t_inside);
        if (x.m_trivia)
            self().visit_trivia(*x.m_trivia);
    }
    void visit_Block(const Block_t &x) {
        for (size_t i=0; i<x.n_use; i++) {
            self().visit_unit_decl1(*x.m_use[i]);
        }
        for (size_t i=0; i<x.n_import; i++) {
            self().visit_import_statement(*x.m_import[i]);
        }
        for (size_t i=0; i<x.n_decl; i++) {
            self().visit_unit_decl2(*x.m_decl[i]);
        }
        for (size_t i=0; i<x.n_body; i++) {
            self().visit_stmt(*x.m_body[i]);
        }
        if (x.m_t_inside)
            self().visit_trivia(*x.m_t_inside);
        if (x.m_trivia)
            self().visit_trivia(*x.m_trivia);
    }
    void visit_ChangeTeam(const ChangeTeam_t &x) {
        self().visit_expr(*x.m_team_value);
        for (size_t i=0; i<x.n_coarray_assoc; i++) {
            self().visit_team_attribute(*x.m_coarray_assoc[i]);
        }
        for (size_t i=0; i<x.n_sync; i++) {
            self().visit_event_attribute(*x.m_sync[i]);
        }
        for (size_t i=0; i<x.n_body; i++) {
            self().visit_stmt(*x.m_body[i]);
        }
        if (x.m_t_inside)
            self().visit_trivia(*x.m_t_inside);
        if (x.m_trivia)
            self().visit_trivia(*x.m_trivia);
        for (size_t i=0; i<x.n_sync_stat; i++) {
            self().visit_event_attribute(*x.m_sync_stat[i]);
        }
    }
    void visit_Critical(const Critical_t &x) {
        for (size_t i=0; i<x.n_sync_stat; i++) {
            self().visit_event_attribute(*x.m_sync_stat[i]);
        }
        for (size_t i=0; i<x.n_body; i++) {
            self().visit_stmt(*x.m_body[i]);
        }
        if (x.m_t_inside)
            self().visit_trivia(*x.m_t_inside);
        if (x.m_trivia)
            self().visit_trivia(*x.m_trivia);
    }
    void visit_DoConcurrentLoop(const DoConcurrentLoop_t &x) {
        for (size_t i=0; i<x.n_control; i++) {
            self().visit_concurrent_control(*x.m_control[i]);
        }
        if (x.m_mask)
            self().visit_expr(*x.m_mask);
        for (size_t i=0; i<x.n_locality; i++) {
            self().visit_concurrent_locality(*x.m_locality[i]);
        }
        for (size_t i=0; i<x.n_body; i++) {
            self().visit_stmt(*x.m_body[i]);
        }
        if (x.m_t_inside)
            self().visit_trivia(*x.m_t_inside);
        if (x.m_trivia)
            self().visit_trivia(*x.m_trivia);
    }
    void visit_DoLoop(const DoLoop_t &x) {
        if (x.m_start)
            self().visit_expr(*x.m_start);
        if (x.m_end)
            self().visit_expr(*x.m_end);
        if (x.m_increment)
            self().visit_expr(*x.m_increment);
        for (size_t i=0; i<x.n_body; i++) {
            self().visit_stmt(*x.m_body[i]);
        }
        if (x.m_t_inside)
            self().visit_trivia(*x.m_t_inside);
        if (x.m_trivia)
            self().visit_trivia(*x.m_trivia);
    }
    void visit_ForAll(const ForAll_t &x) {
        for (size_t i=0; i<x.n_control; i++) {
            self().visit_concurrent_control(*x.m_control[i]);
        }
        if (x.m_mask)
            self().visit_expr(*x.m_mask);
        for (size_t i=0; i<x.n_locality; i++) {
            self().visit_concurrent_locality(*x.m_locality[i]);
        }
        for (size_t i=0; i<x.n_body; i++) {
            self().visit_stmt(*x.m_body[i]);
        }
        if (x.m_t_inside)
            self().visit_trivia(*x.m_t_inside);
        if (x.m_trivia)
            self().visit_trivia(*x.m_trivia);
    }
    void visit_If(const If_t &x) {
        self().visit_expr(*x.m_test);
        for (size_t i=0; i<x.n_body; i++) {
            self().visit_stmt(*x.m_body[i]);
        }
        for (size_t i=0; i<x.n_orelse; i++) {
            self().visit_stmt(*x.m_orelse[i]);
        }
        if (x.m_if_trivia)
            self().visit_trivia(*x.m_if_trivia);
        if (x.m_else_trivia)
            self().visit_trivia(*x.m_else_trivia);
        if (x.m_trivia)
            self().visit_trivia(*x.m_trivia);
    }
    void visit_IfArithmetic(const IfArithmetic_t &x) {
        self().visit_expr(*x.m_test);
        if (x.m_trivia)
            self().visit_trivia(*x.m_trivia);
    }
    void visit_Select(const Select_t &x) {
        self().visit_expr(*x.m_test);
        for (size_t i=0; i<x.n_body; i++) {
            self().visit_case_stmt(*x.m_body[i]);
        }
        if (x.m_t_inside)
            self().visit_trivia(*x.m_t_inside);
        if (x.m_trivia)
            self().visit_trivia(*x.m_trivia);
    }
    void visit_SelectRank(const SelectRank_t &x) {
        self().visit_expr(*x.m_selector);
        for (size_t i=0; i<x.n_body; i++) {
            self().visit_rank_stmt(*x.m_body[i]);
        }
        if (x.m_t_inside)
            self().visit_trivia(*x.m_t_inside);
        if (x.m_trivia)
            self().visit_trivia(*x.m_trivia);
    }
    void visit_SelectType(const SelectType_t &x) {
        self().visit_expr(*x.m_selector);
        for (size_t i=0; i<x.n_body; i++) {
            self().visit_type_stmt(*x.m_body[i]);
        }
        if (x.m_t_inside)
            self().visit_trivia(*x.m_t_inside);
        if (x.m_trivia)
            self().visit_trivia(*x.m_trivia);
    }
    void visit_Where(const Where_t &x) {
        self().visit_expr(*x.m_test);
        for (size_t i=0; i<x.n_body; i++) {
            self().visit_stmt(*x.m_body[i]);
        }
        for (size_t i=0; i<x.n_orelse; i++) {
            self().visit_stmt(*x.m_orelse[i]);
        }
        if (x.m_t_inside)
            self().visit_trivia(*x.m_t_inside);
        if (x.m_trivia)
            self().visit_trivia(*x.m_trivia);
    }
    void visit_WhileLoop(const WhileLoop_t &x) {
        self().visit_expr(*x.m_test);
        for (size_t i=0; i<x.n_body; i++) {
            self().visit_stmt(*x.m_body[i]);
        }
        if (x.m_t_inside)
            self().visit_trivia(*x.m_t_inside);
        if (x.m_trivia)
            self().visit_trivia(*x.m_trivia);
    }
    void visit_BoolOp(const BoolOp_t &x) {
        self().visit_expr(*x.m_left);
        self().visit_expr(*x.m_right);
    }
    void visit_BinOp(const BinOp_t &x) {
        self().visit_expr(*x.m_left);
        self().visit_expr(*x.m_right);
    }
    void visit_DefBinOp(const DefBinOp_t &x) {
        self().visit_expr(*x.m_left);
        self().visit_expr(*x.m_right);
    }
    void visit_StrOp(const StrOp_t &x) {
        self().visit_expr(*x.m_left);
        self().visit_expr(*x.m_right);
    }
    void visit_UnaryOp(const UnaryOp_t &x) {
        self().visit_expr(*x.m_operand);
    }
    void visit_DefUnaryOp(const DefUnaryOp_t &x) {
        self().visit_expr(*x.m_operand);
    }
    void visit_Compare(const Compare_t &x) {
        self().visit_expr(*x.m_left);
        self().visit_expr(*x.m_right);
    }
    void visit_FuncCallOrArray(const FuncCallOrArray_t &x) {
        for (size_t i=0; i<x.n_member; i++) {
            self().visit_struct_member(x.m_member[i]);
        }
        for (size_t i=0; i<x.n_args; i++) {
            self().visit_fnarg(x.m_args[i]);
        }
        for (size_t i=0; i<x.n_keywords; i++) {
            self().visit_keyword(x.m_keywords[i]);
        }
        for (size_t i=0; i<x.n_subargs; i++) {
            self().visit_fnarg(x.m_subargs[i]);
        }
        for (size_t i=0; i<x.n_temp_args; i++) {
            self().visit_decl_attribute(*x.m_temp_args[i]);
        }
    }
    void visit_CoarrayRef(const CoarrayRef_t &x) {
        for (size_t i=0; i<x.n_member; i++) {
            self().visit_struct_member(x.m_member[i]);
        }
        for (size_t i=0; i<x.n_args; i++) {
            self().visit_fnarg(x.m_args[i]);
        }
        for (size_t i=0; i<x.n_fnkw; i++) {
            self().visit_keyword(x.m_fnkw[i]);
        }
        for (size_t i=0; i<x.n_coargs; i++) {
            self().visit_coarrayarg(x.m_coargs[i]);
        }
        for (size_t i=0; i<x.n_cokw; i++) {
            self().visit_keyword(x.m_cokw[i]);
        }
    }
    void visit_ArrayInitializer(const ArrayInitializer_t &x) {
        if (x.m_vartype)
            self().visit_decl_attribute(*x.m_vartype);
        for (size_t i=0; i<x.n_args; i++) {
            self().visit_expr(*x.m_args[i]);
        }
    }
    void visit_ImpliedDoLoop(const ImpliedDoLoop_t &x) {
        for (size_t i=0; i<x.n_values; i++) {
            self().visit_expr(*x.m_values[i]);
        }
        self().visit_expr(*x.m_start);
        self().visit_expr(*x.m_end);
        if (x.m_increment)
            self().visit_expr(*x.m_increment);
    }
    void visit_Num(const Num_t &x) {
        if ((bool&)x) { } // Suppress unused warning
    }
    void visit_Real(const Real_t &x) {
        if ((bool&)x) { } // Suppress unused warning
    }
    void visit_Complex(const Complex_t &x) {
        self().visit_expr(*x.m_re);
        self().visit_expr(*x.m_im);
    }
    void visit_String(const String_t &x) {
        if ((bool&)x) { } // Suppress unused warning
    }
    void visit_Substring(const Substring_t &x) {
        for (size_t i=0; i<x.n_args; i++) {
            self().visit_fnarg(x.m_args[i]);
        }
    }
    void visit_BOZ(const BOZ_t &x) {
        if ((bool&)x) { } // Suppress unused warning
    }
    void visit_Name(const Name_t &x) {
        for (size_t i=0; i<x.n_member; i++) {
            self().visit_struct_member(x.m_member[i]);
        }
    }
    void visit_Logical(const Logical_t &x) {
        if ((bool&)x) { } // Suppress unused warning
    }
    void visit_DataImpliedDo(const DataImpliedDo_t &x) {
        for (size_t i=0; i<x.n_object_list; i++) {
            self().visit_expr(*x.m_object_list[i]);
        }
        if (x.m_type)
            self().visit_decl_attribute(*x.m_type);
        self().visit_expr(*x.m_start);
        self().visit_expr(*x.m_end);
        if (x.m_increment)
            self().visit_expr(*x.m_increment);
    }
    void visit_Parenthesis(const Parenthesis_t &x) {
        self().visit_expr(*x.m_operand);
    }
    void visit_TriviaNode(const TriviaNode_t &x) {
        for (size_t i=0; i<x.n_inside; i++) {
            self().visit_trivia_node(*x.m_inside[i]);
        }
        for (size_t i=0; i<x.n_after; i++) {
            self().visit_trivia_node(*x.m_after[i]);
        }
    }
    void visit_Comment(const Comment_t &x) {
        if ((bool&)x) { } // Suppress unused warning
    }
    void visit_EOLComment(const EOLComment_t &x) {
        if ((bool&)x) { } // Suppress unused warning
    }
    void visit_EndOfLine(const EndOfLine_t &x) {
        if ((bool&)x) { } // Suppress unused warning
    }
    void visit_Semicolon(const Semicolon_t &x) {
        if ((bool&)x) { } // Suppress unused warning
    }
    void visit_DerivedTypeProc(const DerivedTypeProc_t &x) {
        for (size_t i=0; i<x.n_attr; i++) {
            self().visit_decl_attribute(*x.m_attr[i]);
        }
        for (size_t i=0; i<x.n_symbols; i++) {
            self().visit_use_symbol(*x.m_symbols[i]);
        }
        if (x.m_trivia)
            self().visit_trivia(*x.m_trivia);
    }
    void visit_GenericOperator(const GenericOperator_t &x) {
        for (size_t i=0; i<x.n_attr; i++) {
            self().visit_decl_attribute(*x.m_attr[i]);
        }
        if (x.m_trivia)
            self().visit_trivia(*x.m_trivia);
    }
    void visit_GenericDefinedOperator(const GenericDefinedOperator_t &x) {
        for (size_t i=0; i<x.n_attr; i++) {
            self().visit_decl_attribute(*x.m_attr[i]);
        }
        if (x.m_trivia)
            self().visit_trivia(*x.m_trivia);
    }
    void visit_GenericAssignment(const GenericAssignment_t &x) {
        for (size_t i=0; i<x.n_attr; i++) {
            self().visit_decl_attribute(*x.m_attr[i]);
        }
        if (x.m_trivia)
            self().visit_trivia(*x.m_trivia);
    }
    void visit_GenericName(const GenericName_t &x) {
        for (size_t i=0; i<x.n_attr; i++) {
            self().visit_decl_attribute(*x.m_attr[i]);
        }
        if (x.m_trivia)
            self().visit_trivia(*x.m_trivia);
    }
    void visit_GenericWrite(const GenericWrite_t &x) {
        for (size_t i=0; i<x.n_attr; i++) {
            self().visit_decl_attribute(*x.m_attr[i]);
        }
        if (x.m_trivia)
            self().visit_trivia(*x.m_trivia);
    }
    void visit_GenericRead(const GenericRead_t &x) {
        for (size_t i=0; i<x.n_attr; i++) {
            self().visit_decl_attribute(*x.m_attr[i]);
        }
        if (x.m_trivia)
            self().visit_trivia(*x.m_trivia);
    }
    void visit_FinalName(const FinalName_t &x) {
        if (x.m_trivia)
            self().visit_trivia(*x.m_trivia);
    }
    void visit_Private(const Private_t &x) {
        if (x.m_trivia)
            self().visit_trivia(*x.m_trivia);
    }
    void visit_AttrBind(const AttrBind_t &x) {
        self().visit_bind(*x.m_bind);
    }
    void visit_AttrDimension(const AttrDimension_t &x) {
        for (size_t i=0; i<x.n_dim; i++) {
            self().visit_dimension(x.m_dim[i]);
        }
    }
    void visit_AttrCodimension(const AttrCodimension_t &x) {
        for (size_t i=0; i<x.n_codim; i++) {
            self().visit_codimension(x.m_codim[i]);
        }
    }
    void visit_AttrEquivalence(const AttrEquivalence_t &x) {
        for (size_t i=0; i<x.n_args; i++) {
            self().visit_equi(x.m_args[i]);
        }
    }
    void visit_AttrExtends(const AttrExtends_t &x) {
        if ((bool&)x) { } // Suppress unused warning
    }
    void visit_AttrIntent(const AttrIntent_t &x) {
        if ((bool&)x) { } // Suppress unused warning
    }
    void visit_AttrNamelist(const AttrNamelist_t &x) {
        if ((bool&)x) { } // Suppress unused warning
    }
    void visit_AttrPass(const AttrPass_t &x) {
        if ((bool&)x) { } // Suppress unused warning
    }
    void visit_SimpleAttribute(const SimpleAttribute_t &x) {
        if ((bool&)x) { } // Suppress unused warning
    }
    void visit_AttrType(const AttrType_t &x) {
        for (size_t i=0; i<x.n_kind; i++) {
            self().visit_kind_item(x.m_kind[i]);
        }
        if (x.m_attr)
            self().visit_decl_attribute(*x.m_attr);
    }
    void visit_AttrAssignment(const AttrAssignment_t &x) {
        if ((bool&)x) { } // Suppress unused warning
    }
    void visit_AttrIntrinsicOperator(const AttrIntrinsicOperator_t &x) {
        if ((bool&)x) { } // Suppress unused warning
    }
    void visit_AttrDefinedOperator(const AttrDefinedOperator_t &x) {
        if ((bool&)x) { } // Suppress unused warning
    }
    void visit_AttrStat(const AttrStat_t &x) {
        if ((bool&)x) { } // Suppress unused warning
    }
    void visit_AttrErrmsg(const AttrErrmsg_t &x) {
        if ((bool&)x) { } // Suppress unused warning
    }
    void visit_AttrNewIndex(const AttrNewIndex_t &x) {
        self().visit_expr(*x.m_value);
    }
    void visit_AttrEventWaitKwArg(const AttrEventWaitKwArg_t &x) {
        self().visit_expr(*x.m_value);
    }
    void visit_CoarrayAssociation(const CoarrayAssociation_t &x) {
        self().visit_expr(*x.m_coarray);
        self().visit_expr(*x.m_selector);
    }
    void visit_var_sym(const var_sym_t &x) {
        for (size_t i=0; i<x.n_dim; i++) {
            self().visit_dimension(x.m_dim[i]);
        }
        for (size_t i=0; i<x.n_codim; i++) {
            self().visit_codimension(x.m_codim[i]);
        }
        if (x.m_length)
            self().visit_expr(*x.m_length);
        if (x.m_initializer)
            self().visit_expr(*x.m_initializer);
        if (x.m_spec)
            self().visit_decl_attribute(*x.m_spec);
    }
    void visit_kind_item(const kind_item_t &x) {
        if (x.m_value)
            self().visit_expr(*x.m_value);
    }
    void visit_dimension(const dimension_t &x) {
        if (x.m_start)
            self().visit_expr(*x.m_start);
        if (x.m_end)
            self().visit_expr(*x.m_end);
    }
    void visit_codimension(const codimension_t &x) {
        if (x.m_start)
            self().visit_expr(*x.m_start);
        if (x.m_end)
            self().visit_expr(*x.m_end);
    }
    void visit_equi(const equi_t &x) {
        for (size_t i=0; i<x.n_set_list; i++) {
            self().visit_expr(*x.m_set_list[i]);
        }
    }
    void visit_kw_argstar(const kw_argstar_t &x) {
        if (x.m_value)
            self().visit_expr(*x.m_value);
    }
    void visit_argstar(const argstar_t &x) {
        if (x.m_value)
            self().visit_expr(*x.m_value);
    }
    void visit_arg(const arg_t &x) {
        if ((bool&)x) { } // Suppress unused warning
    }
    void visit_fnarg(const fnarg_t &x) {
        if (x.m_start)
            self().visit_expr(*x.m_start);
        if (x.m_end)
            self().visit_expr(*x.m_end);
        if (x.m_step)
            self().visit_expr(*x.m_step);
    }
    void visit_coarrayarg(const coarrayarg_t &x) {
        if (x.m_start)
            self().visit_expr(*x.m_start);
        if (x.m_end)
            self().visit_expr(*x.m_end);
        if (x.m_step)
            self().visit_expr(*x.m_step);
    }
    void visit_keyword(const keyword_t &x) {
        self().visit_expr(*x.m_value);
    }
    void visit_struct_member(const struct_member_t &x) {
        for (size_t i=0; i<x.n_args; i++) {
            self().visit_fnarg(x.m_args[i]);
        }
    }
    void visit_Bind(const Bind_t &x) {
        for (size_t i=0; i<x.n_args; i++) {
            self().visit_expr(*x.m_args[i]);
        }
        for (size_t i=0; i<x.n_kwargs; i++) {
            self().visit_keyword(x.m_kwargs[i]);
        }
    }
    void visit_ArrayIndex(const ArrayIndex_t &x) {
        if (x.m_left)
            self().visit_expr(*x.m_left);
        if (x.m_right)
            self().visit_expr(*x.m_right);
        if (x.m_step)
            self().visit_expr(*x.m_step);
    }
    void visit_CaseStmt(const CaseStmt_t &x) {
        for (size_t i=0; i<x.n_test; i++) {
            self().visit_case_cond(*x.m_test[i]);
        }
        if (x.m_trivia)
            self().visit_trivia(*x.m_trivia);
        for (size_t i=0; i<x.n_body; i++) {
            self().visit_stmt(*x.m_body[i]);
        }
    }
    void visit_CaseStmt_Default(const CaseStmt_Default_t &x) {
        if (x.m_trivia)
            self().visit_trivia(*x.m_trivia);
        for (size_t i=0; i<x.n_body; i++) {
            self().visit_stmt(*x.m_body[i]);
        }
    }
    void visit_CaseCondExpr(const CaseCondExpr_t &x) {
        self().visit_expr(*x.m_cond);
    }
    void visit_CaseCondRange(const CaseCondRange_t &x) {
        if (x.m_start)
            self().visit_expr(*x.m_start);
        if (x.m_end)
            self().visit_expr(*x.m_end);
    }
    void visit_RankExpr(const RankExpr_t &x) {
        self().visit_expr(*x.m_value);
        if (x.m_trivia)
            self().visit_trivia(*x.m_trivia);
        for (size_t i=0; i<x.n_body; i++) {
            self().visit_stmt(*x.m_body[i]);
        }
    }
    void visit_RankStar(const RankStar_t &x) {
        if (x.m_trivia)
            self().visit_trivia(*x.m_trivia);
        for (size_t i=0; i<x.n_body; i++) {
            self().visit_stmt(*x.m_body[i]);
        }
    }
    void visit_RankDefault(const RankDefault_t &x) {
        if (x.m_trivia)
            self().visit_trivia(*x.m_trivia);
        for (size_t i=0; i<x.n_body; i++) {
            self().visit_stmt(*x.m_body[i]);
        }
    }
    void visit_TypeStmtName(const TypeStmtName_t &x) {
        if (x.m_trivia)
            self().visit_trivia(*x.m_trivia);
        for (size_t i=0; i<x.n_body; i++) {
            self().visit_stmt(*x.m_body[i]);
        }
    }
    void visit_TypeStmtType(const TypeStmtType_t &x) {
        if (x.m_vartype)
            self().visit_decl_attribute(*x.m_vartype);
        if (x.m_trivia)
            self().visit_trivia(*x.m_trivia);
        for (size_t i=0; i<x.n_body; i++) {
            self().visit_stmt(*x.m_body[i]);
        }
    }
    void visit_ClassStmt(const ClassStmt_t &x) {
        if (x.m_trivia)
            self().visit_trivia(*x.m_trivia);
        for (size_t i=0; i<x.n_body; i++) {
            self().visit_stmt(*x.m_body[i]);
        }
    }
    void visit_ClassDefault(const ClassDefault_t &x) {
        if (x.m_trivia)
            self().visit_trivia(*x.m_trivia);
        for (size_t i=0; i<x.n_body; i++) {
            self().visit_stmt(*x.m_body[i]);
        }
    }
    void visit_UseSymbol(const UseSymbol_t &x) {
        if ((bool&)x) { } // Suppress unused warning
    }
    void visit_UseAssignment(const UseAssignment_t &x) {
        if ((bool&)x) { } // Suppress unused warning
    }
    void visit_IntrinsicOperator(const IntrinsicOperator_t &x) {
        if ((bool&)x) { } // Suppress unused warning
    }
    void visit_DefinedOperator(const DefinedOperator_t &x) {
        if ((bool&)x) { } // Suppress unused warning
    }
    void visit_RenameOperator(const RenameOperator_t &x) {
        if ((bool&)x) { } // Suppress unused warning
    }
    void visit_UseWrite(const UseWrite_t &x) {
        if ((bool&)x) { } // Suppress unused warning
    }
    void visit_UseRead(const UseRead_t &x) {
        if ((bool&)x) { } // Suppress unused warning
    }
    void visit_ConcurrentControl(const ConcurrentControl_t &x) {
        if (x.m_start)
            self().visit_expr(*x.m_start);
        if (x.m_end)
            self().visit_expr(*x.m_end);
        if (x.m_increment)
            self().visit_expr(*x.m_increment);
    }
    void visit_ConcurrentLocal(const ConcurrentLocal_t &x) {
        if ((bool&)x) { } // Suppress unused warning
    }
    void visit_ConcurrentLocalInit(const ConcurrentLocalInit_t &x) {
        if ((bool&)x) { } // Suppress unused warning
    }
    void visit_ConcurrentShared(const ConcurrentShared_t &x) {
        if ((bool&)x) { } // Suppress unused warning
    }
    void visit_ConcurrentDefault(const ConcurrentDefault_t &x) {
        if ((bool&)x) { } // Suppress unused warning
    }
    void visit_ConcurrentReduce(const ConcurrentReduce_t &x) {
        if ((bool&)x) { } // Suppress unused warning
    }
    void visit_DataStmtSet(const DataStmtSet_t &x) {
        for (size_t i=0; i<x.n_object; i++) {
            self().visit_expr(*x.m_object[i]);
        }
        for (size_t i=0; i<x.n_value; i++) {
            self().visit_expr(*x.m_value[i]);
        }
    }
    void visit_UnitRequire(const UnitRequire_t &x) {
        for (size_t i=0; i<x.n_namelist; i++) {
            self().visit_decl_attribute(*x.m_namelist[i]);
        }
    }
};


/******************************************************************************/
// Tree Visitor base class

template <class Struct>
class TreeBaseVisitor : public BaseVisitor<Struct>
{
private:
    Struct& self() { return static_cast<Struct&>(*this); }
public:
    std::string s, indtd;
    bool use_colors;
    bool start_line = true;
    bool last, attached;
    int indent_level = 0, indent_spaces = 2, lvl = 0;
public:
    TreeBaseVisitor() : use_colors(false), last(true), attached(false) { s.reserve(100000); }
    void inc_indent() {
        indent_level++;
        indtd += "  ";
    }
    void inc_lindent() {
        indent_level++;
        indtd += "| ";
    }
    void dec_indent() {
        indent_level--;
        LCOMPILERS_ASSERT(indent_level >= 0);
        indtd = indtd.substr(0, indent_level*indent_spaces);
    }
    void visit_TranslationUnit(const TranslationUnit_t &x) {
        if(!attached) {
            if(start_line) {
                start_line = false;
                s.append(indtd);
            } else {
                s.append("\n"+indtd);
            }
            last ? s.append("└-") : s.append("|-");
        }
        last ? inc_indent() : inc_lindent();
        attached = true;
        last = false;
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("TranslationUnit");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        s.append("\n" + indtd + "└-" + "items=↧");
        attached = false;
        for (size_t i=0; i<x.n_items; i++) {
            inc_indent();
            last = i == x.n_items-1;
            attached = false;
            self().visit_ast(*x.m_items[i]);
            dec_indent();
        }
        dec_indent();
        if ((bool&)x) { } // Suppress unused warning
    }
    void visit_Module(const Module_t &x) {
        if(!attached) {
            if(start_line) {
                start_line = false;
                s.append(indtd);
            } else {
                s.append("\n"+indtd);
            }
            last ? s.append("└-") : s.append("|-");
        }
        last ? inc_indent() : inc_lindent();
        attached = true;
        last = false;
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("Module");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        s.append("\n" + indtd + "|-" + "name=");
        s.append(x.m_name);
        s.append("\n" + indtd + "|-" + "trivia=");
        if (x.m_trivia) {
            self().visit_trivia(*x.m_trivia);
        } else {
            s.append("()");
        last = false;
        attached = false;
        }
        s.append("\n" + indtd + "|-" + "use=↧");
        for (size_t i=0; i<x.n_use; i++) {
            inc_lindent();
            last = i == x.n_use-1;
            attached = false;
            self().visit_unit_decl1(*x.m_use[i]);
            dec_indent();
        }
        s.append("\n" + indtd + "|-" + "implicit=↧");
        for (size_t i=0; i<x.n_implicit; i++) {
            inc_lindent();
            last = i == x.n_implicit-1;
            attached = false;
            self().visit_implicit_statement(*x.m_implicit[i]);
            dec_indent();
        }
        s.append("\n" + indtd + "|-" + "decl=↧");
        for (size_t i=0; i<x.n_decl; i++) {
            inc_lindent();
            last = i == x.n_decl-1;
            attached = false;
            self().visit_unit_decl2(*x.m_decl[i]);
            dec_indent();
        }
        s.append("\n" + indtd + "└-" + "contains=↧");
        for (size_t i=0; i<x.n_contains; i++) {
            inc_indent();
            last = i == x.n_contains-1;
            attached = false;
            self().visit_program_unit(*x.m_contains[i]);
            dec_indent();
        }
        dec_indent();
    }
    void visit_Submodule(const Submodule_t &x) {
        if(!attached) {
            if(start_line) {
                start_line = false;
                s.append(indtd);
            } else {
                s.append("\n"+indtd);
            }
            last ? s.append("└-") : s.append("|-");
        }
        last ? inc_indent() : inc_lindent();
        attached = true;
        last = false;
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("Submodule");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        s.append("\n" + indtd + "|-" + "id=");
        s.append(x.m_id);
        s.append("\n" + indtd + "|-" + "parent_name=");
        if (x.m_parent_name) {
            s.append(x.m_parent_name);
        } else {
            s.append("()");
        }
        s.append("\n" + indtd + "|-" + "name=");
        s.append(x.m_name);
        s.append("\n" + indtd + "|-" + "trivia=");
        if (x.m_trivia) {
            self().visit_trivia(*x.m_trivia);
        } else {
            s.append("()");
        last = false;
        attached = false;
        }
        s.append("\n" + indtd + "|-" + "use=↧");
        for (size_t i=0; i<x.n_use; i++) {
            inc_lindent();
            last = i == x.n_use-1;
            attached = false;
            self().visit_unit_decl1(*x.m_use[i]);
            dec_indent();
        }
        s.append("\n" + indtd + "|-" + "implicit=↧");
        for (size_t i=0; i<x.n_implicit; i++) {
            inc_lindent();
            last = i == x.n_implicit-1;
            attached = false;
            self().visit_implicit_statement(*x.m_implicit[i]);
            dec_indent();
        }
        s.append("\n" + indtd + "|-" + "decl=↧");
        for (size_t i=0; i<x.n_decl; i++) {
            inc_lindent();
            last = i == x.n_decl-1;
            attached = false;
            self().visit_unit_decl2(*x.m_decl[i]);
            dec_indent();
        }
        s.append("\n" + indtd + "└-" + "contains=↧");
        for (size_t i=0; i<x.n_contains; i++) {
            inc_indent();
            last = i == x.n_contains-1;
            attached = false;
            self().visit_program_unit(*x.m_contains[i]);
            dec_indent();
        }
        dec_indent();
    }
    void visit_BlockData(const BlockData_t &x) {
        if(!attached) {
            if(start_line) {
                start_line = false;
                s.append(indtd);
            } else {
                s.append("\n"+indtd);
            }
            last ? s.append("└-") : s.append("|-");
        }
        last ? inc_indent() : inc_lindent();
        attached = true;
        last = false;
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("BlockData");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        s.append("\n" + indtd + "|-" + "name=");
        if (x.m_name) {
            s.append(x.m_name);
        } else {
            s.append("()");
        }
        s.append("\n" + indtd + "|-" + "trivia=");
        if (x.m_trivia) {
            self().visit_trivia(*x.m_trivia);
        } else {
            s.append("()");
        last = false;
        attached = false;
        }
        s.append("\n" + indtd + "|-" + "use=↧");
        for (size_t i=0; i<x.n_use; i++) {
            inc_lindent();
            last = i == x.n_use-1;
            attached = false;
            self().visit_unit_decl1(*x.m_use[i]);
            dec_indent();
        }
        s.append("\n" + indtd + "|-" + "implicit=↧");
        for (size_t i=0; i<x.n_implicit; i++) {
            inc_lindent();
            last = i == x.n_implicit-1;
            attached = false;
            self().visit_implicit_statement(*x.m_implicit[i]);
            dec_indent();
        }
        s.append("\n" + indtd + "|-" + "decl=↧");
        for (size_t i=0; i<x.n_decl; i++) {
            inc_lindent();
            last = i == x.n_decl-1;
            attached = false;
            self().visit_unit_decl2(*x.m_decl[i]);
            dec_indent();
        }
        s.append("\n" + indtd + "└-" + "body=↧");
        for (size_t i=0; i<x.n_body; i++) {
            inc_indent();
            last = i == x.n_body-1;
            attached = false;
            self().visit_stmt(*x.m_body[i]);
            dec_indent();
        }
        dec_indent();
    }
    void visit_Program(const Program_t &x) {
        if(!attached) {
            if(start_line) {
                start_line = false;
                s.append(indtd);
            } else {
                s.append("\n"+indtd);
            }
            last ? s.append("└-") : s.append("|-");
        }
        last ? inc_indent() : inc_lindent();
        attached = true;
        last = false;
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("Program");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        s.append("\n" + indtd + "|-" + "name=");
        s.append(x.m_name);
        s.append("\n" + indtd + "|-" + "trivia=");
        if (x.m_trivia) {
            self().visit_trivia(*x.m_trivia);
        } else {
            s.append("()");
        last = false;
        attached = false;
        }
        s.append("\n" + indtd + "|-" + "use=↧");
        for (size_t i=0; i<x.n_use; i++) {
            inc_lindent();
            last = i == x.n_use-1;
            attached = false;
            self().visit_unit_decl1(*x.m_use[i]);
            dec_indent();
        }
        s.append("\n" + indtd + "|-" + "implicit=↧");
        for (size_t i=0; i<x.n_implicit; i++) {
            inc_lindent();
            last = i == x.n_implicit-1;
            attached = false;
            self().visit_implicit_statement(*x.m_implicit[i]);
            dec_indent();
        }
        s.append("\n" + indtd + "|-" + "decl=↧");
        for (size_t i=0; i<x.n_decl; i++) {
            inc_lindent();
            last = i == x.n_decl-1;
            attached = false;
            self().visit_unit_decl2(*x.m_decl[i]);
            dec_indent();
        }
        s.append("\n" + indtd + "|-" + "body=↧");
        for (size_t i=0; i<x.n_body; i++) {
            inc_lindent();
            last = i == x.n_body-1;
            attached = false;
            self().visit_stmt(*x.m_body[i]);
            dec_indent();
        }
        s.append("\n" + indtd + "└-" + "contains=↧");
        for (size_t i=0; i<x.n_contains; i++) {
            inc_indent();
            last = i == x.n_contains-1;
            attached = false;
            self().visit_program_unit(*x.m_contains[i]);
            dec_indent();
        }
        dec_indent();
    }
    void visit_Subroutine(const Subroutine_t &x) {
        if(!attached) {
            if(start_line) {
                start_line = false;
                s.append(indtd);
            } else {
                s.append("\n"+indtd);
            }
            last ? s.append("└-") : s.append("|-");
        }
        last ? inc_indent() : inc_lindent();
        attached = true;
        last = false;
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("Subroutine");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        s.append("\n" + indtd + "|-" + "name=");
        s.append(x.m_name);
        s.append("\n" + indtd + "|-" + "args=↧");
        for (size_t i=0; i<x.n_args; i++) {
            inc_lindent();
            last = i == x.n_args-1;
            attached = false;
            self().visit_arg(x.m_args[i]);
            dec_indent();
        }
        s.append("\n" + indtd + "|-" + "attributes=↧");
        for (size_t i=0; i<x.n_attributes; i++) {
            inc_lindent();
            last = i == x.n_attributes-1;
            attached = false;
            self().visit_decl_attribute(*x.m_attributes[i]);
            dec_indent();
        }
        s.append("\n" + indtd + "|-" + "bind=");
        if (x.m_bind) {
            self().visit_bind(*x.m_bind);
        } else {
            s.append("()");
        last = false;
        attached = false;
        }
        s.append("\n" + indtd + "|-" + "trivia=");
        if (x.m_trivia) {
            self().visit_trivia(*x.m_trivia);
        } else {
            s.append("()");
        last = false;
        attached = false;
        }
        s.append("\n" + indtd + "|-" + "use=↧");
        for (size_t i=0; i<x.n_use; i++) {
            inc_lindent();
            last = i == x.n_use-1;
            attached = false;
            self().visit_unit_decl1(*x.m_use[i]);
            dec_indent();
        }
        s.append("\n" + indtd + "|-" + "import=↧");
        for (size_t i=0; i<x.n_import; i++) {
            inc_lindent();
            last = i == x.n_import-1;
            attached = false;
            self().visit_import_statement(*x.m_import[i]);
            dec_indent();
        }
        s.append("\n" + indtd + "|-" + "implicit=↧");
        for (size_t i=0; i<x.n_implicit; i++) {
            inc_lindent();
            last = i == x.n_implicit-1;
            attached = false;
            self().visit_implicit_statement(*x.m_implicit[i]);
            dec_indent();
        }
        s.append("\n" + indtd + "|-" + "decl=↧");
        for (size_t i=0; i<x.n_decl; i++) {
            inc_lindent();
            last = i == x.n_decl-1;
            attached = false;
            self().visit_unit_decl2(*x.m_decl[i]);
            dec_indent();
        }
        s.append("\n" + indtd + "|-" + "body=↧");
        for (size_t i=0; i<x.n_body; i++) {
            inc_lindent();
            last = i == x.n_body-1;
            attached = false;
            self().visit_stmt(*x.m_body[i]);
            dec_indent();
        }
        s.append("\n" + indtd + "|-" + "contains=↧");
        for (size_t i=0; i<x.n_contains; i++) {
            inc_lindent();
            last = i == x.n_contains-1;
            attached = false;
            self().visit_program_unit(*x.m_contains[i]);
            dec_indent();
        }
        s.append("\n" + indtd + "└-" + "temp_args=");
        for (size_t i=0; i<x.n_temp_args; i++) {
            s.append(x.m_temp_args[i]);
            if (i < x.n_temp_args-1) s.append(" ");
        }
        dec_indent();
    }
    void visit_Procedure(const Procedure_t &x) {
        if(!attached) {
            if(start_line) {
                start_line = false;
                s.append(indtd);
            } else {
                s.append("\n"+indtd);
            }
            last ? s.append("└-") : s.append("|-");
        }
        last ? inc_indent() : inc_lindent();
        attached = true;
        last = false;
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("Procedure");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        s.append("\n" + indtd + "|-" + "name=");
        s.append(x.m_name);
        s.append("\n" + indtd + "|-" + "args=↧");
        for (size_t i=0; i<x.n_args; i++) {
            inc_lindent();
            last = i == x.n_args-1;
            attached = false;
            self().visit_arg(x.m_args[i]);
            dec_indent();
        }
        s.append("\n" + indtd + "|-" + "attributes=↧");
        for (size_t i=0; i<x.n_attributes; i++) {
            inc_lindent();
            last = i == x.n_attributes-1;
            attached = false;
            self().visit_decl_attribute(*x.m_attributes[i]);
            dec_indent();
        }
        s.append("\n" + indtd + "|-" + "trivia=");
        if (x.m_trivia) {
            self().visit_trivia(*x.m_trivia);
        } else {
            s.append("()");
        last = false;
        attached = false;
        }
        s.append("\n" + indtd + "|-" + "use=↧");
        for (size_t i=0; i<x.n_use; i++) {
            inc_lindent();
            last = i == x.n_use-1;
            attached = false;
            self().visit_unit_decl1(*x.m_use[i]);
            dec_indent();
        }
        s.append("\n" + indtd + "|-" + "import=↧");
        for (size_t i=0; i<x.n_import; i++) {
            inc_lindent();
            last = i == x.n_import-1;
            attached = false;
            self().visit_import_statement(*x.m_import[i]);
            dec_indent();
        }
        s.append("\n" + indtd + "|-" + "implicit=↧");
        for (size_t i=0; i<x.n_implicit; i++) {
            inc_lindent();
            last = i == x.n_implicit-1;
            attached = false;
            self().visit_implicit_statement(*x.m_implicit[i]);
            dec_indent();
        }
        s.append("\n" + indtd + "|-" + "decl=↧");
        for (size_t i=0; i<x.n_decl; i++) {
            inc_lindent();
            last = i == x.n_decl-1;
            attached = false;
            self().visit_unit_decl2(*x.m_decl[i]);
            dec_indent();
        }
        s.append("\n" + indtd + "|-" + "body=↧");
        for (size_t i=0; i<x.n_body; i++) {
            inc_lindent();
            last = i == x.n_body-1;
            attached = false;
            self().visit_stmt(*x.m_body[i]);
            dec_indent();
        }
        s.append("\n" + indtd + "└-" + "contains=↧");
        for (size_t i=0; i<x.n_contains; i++) {
            inc_indent();
            last = i == x.n_contains-1;
            attached = false;
            self().visit_program_unit(*x.m_contains[i]);
            dec_indent();
        }
        dec_indent();
    }
    void visit_Function(const Function_t &x) {
        if(!attached) {
            if(start_line) {
                start_line = false;
                s.append(indtd);
            } else {
                s.append("\n"+indtd);
            }
            last ? s.append("└-") : s.append("|-");
        }
        last ? inc_indent() : inc_lindent();
        attached = true;
        last = false;
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("Function");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        s.append("\n" + indtd + "|-" + "name=");
        s.append(x.m_name);
        s.append("\n" + indtd + "|-" + "args=↧");
        for (size_t i=0; i<x.n_args; i++) {
            inc_lindent();
            last = i == x.n_args-1;
            attached = false;
            self().visit_arg(x.m_args[i]);
            dec_indent();
        }
        s.append("\n" + indtd + "|-" + "attributes=↧");
        for (size_t i=0; i<x.n_attributes; i++) {
            inc_lindent();
            last = i == x.n_attributes-1;
            attached = false;
            self().visit_decl_attribute(*x.m_attributes[i]);
            dec_indent();
        }
        s.append("\n" + indtd + "|-" + "return_var=");
        if (x.m_return_var) {
            self().visit_expr(*x.m_return_var);
        } else {
            s.append("()");
        last = false;
        attached = false;
        }
        s.append("\n" + indtd + "|-" + "bind=");
        if (x.m_bind) {
            self().visit_bind(*x.m_bind);
        } else {
            s.append("()");
        last = false;
        attached = false;
        }
        s.append("\n" + indtd + "|-" + "trivia=");
        if (x.m_trivia) {
            self().visit_trivia(*x.m_trivia);
        } else {
            s.append("()");
        last = false;
        attached = false;
        }
        s.append("\n" + indtd + "|-" + "use=↧");
        for (size_t i=0; i<x.n_use; i++) {
            inc_lindent();
            last = i == x.n_use-1;
            attached = false;
            self().visit_unit_decl1(*x.m_use[i]);
            dec_indent();
        }
        s.append("\n" + indtd + "|-" + "import=↧");
        for (size_t i=0; i<x.n_import; i++) {
            inc_lindent();
            last = i == x.n_import-1;
            attached = false;
            self().visit_import_statement(*x.m_import[i]);
            dec_indent();
        }
        s.append("\n" + indtd + "|-" + "implicit=↧");
        for (size_t i=0; i<x.n_implicit; i++) {
            inc_lindent();
            last = i == x.n_implicit-1;
            attached = false;
            self().visit_implicit_statement(*x.m_implicit[i]);
            dec_indent();
        }
        s.append("\n" + indtd + "|-" + "decl=↧");
        for (size_t i=0; i<x.n_decl; i++) {
            inc_lindent();
            last = i == x.n_decl-1;
            attached = false;
            self().visit_unit_decl2(*x.m_decl[i]);
            dec_indent();
        }
        s.append("\n" + indtd + "|-" + "body=↧");
        for (size_t i=0; i<x.n_body; i++) {
            inc_lindent();
            last = i == x.n_body-1;
            attached = false;
            self().visit_stmt(*x.m_body[i]);
            dec_indent();
        }
        s.append("\n" + indtd + "|-" + "contains=↧");
        for (size_t i=0; i<x.n_contains; i++) {
            inc_lindent();
            last = i == x.n_contains-1;
            attached = false;
            self().visit_program_unit(*x.m_contains[i]);
            dec_indent();
        }
        s.append("\n" + indtd + "└-" + "temp_args=");
        for (size_t i=0; i<x.n_temp_args; i++) {
            s.append(x.m_temp_args[i]);
            if (i < x.n_temp_args-1) s.append(" ");
        }
        dec_indent();
    }
    void visit_Use(const Use_t &x) {
        if(!attached) {
            if(start_line) {
                start_line = false;
                s.append(indtd);
            } else {
                s.append("\n"+indtd);
            }
            last ? s.append("└-") : s.append("|-");
        }
        last ? inc_indent() : inc_lindent();
        attached = true;
        last = false;
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("Use");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        s.append("\n" + indtd + "|-" + "nature=↧");
        for (size_t i=0; i<x.n_nature; i++) {
            inc_lindent();
            last = i == x.n_nature-1;
            attached = false;
            self().visit_decl_attribute(*x.m_nature[i]);
            dec_indent();
        }
        s.append("\n" + indtd + "|-" + "module=");
        s.append(x.m_module);
        s.append("\n" + indtd + "|-" + "symbols=↧");
        for (size_t i=0; i<x.n_symbols; i++) {
            inc_lindent();
            last = i == x.n_symbols-1;
            attached = false;
            self().visit_use_symbol(*x.m_symbols[i]);
            dec_indent();
        }
        s.append("\n" + indtd + "|-" + "only_present=");
        if (x.m_only_present) {
            s.append(".true.");
        } else {
            s.append(".false.");
        }
        s.append("\n" + indtd + "└-" + "trivia=");
        last = true;
        if (x.m_trivia) {
            self().visit_trivia(*x.m_trivia);
        } else {
            s.append("()");
        last = false;
        attached = false;
        }
        dec_indent();
    }
    void visit_Declaration(const Declaration_t &x) {
        if(!attached) {
            if(start_line) {
                start_line = false;
                s.append(indtd);
            } else {
                s.append("\n"+indtd);
            }
            last ? s.append("└-") : s.append("|-");
        }
        last ? inc_indent() : inc_lindent();
        attached = true;
        last = false;
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("Declaration");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        s.append("\n" + indtd + "|-" + "vartype=");
        if (x.m_vartype) {
            self().visit_decl_attribute(*x.m_vartype);
        } else {
            s.append("()");
        last = false;
        attached = false;
        }
        s.append("\n" + indtd + "|-" + "attributes=↧");
        for (size_t i=0; i<x.n_attributes; i++) {
            inc_lindent();
            last = i == x.n_attributes-1;
            attached = false;
            self().visit_decl_attribute(*x.m_attributes[i]);
            dec_indent();
        }
        s.append("\n" + indtd + "|-" + "syms=↧");
        for (size_t i=0; i<x.n_syms; i++) {
            inc_lindent();
            last = i == x.n_syms-1;
            attached = false;
            self().visit_var_sym(x.m_syms[i]);
            dec_indent();
        }
        s.append("\n" + indtd + "└-" + "trivia=");
        last = true;
        if (x.m_trivia) {
            self().visit_trivia(*x.m_trivia);
        } else {
            s.append("()");
        last = false;
        attached = false;
        }
        dec_indent();
    }
    void visit_DeclarationPragma(const DeclarationPragma_t &x) {
        if(!attached) {
            if(start_line) {
                start_line = false;
                s.append(indtd);
            } else {
                s.append("\n"+indtd);
            }
            last ? s.append("└-") : s.append("|-");
        }
        last ? inc_indent() : inc_lindent();
        attached = true;
        last = false;
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("DeclarationPragma");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        s.append("\n" + indtd + "|-" + "pragma_typeType=");
        visit_pragma_typeType(x.m_type);
        s.append("\n" + indtd + "|-" + "text=");
        s.append("\"" + std::string(x.m_text) + "\"");
        s.append("\n" + indtd + "└-" + "trivia=");
        last = true;
        if (x.m_trivia) {
            self().visit_trivia(*x.m_trivia);
        } else {
            s.append("()");
        last = false;
        attached = false;
        }
        dec_indent();
    }
    void visit_Interface(const Interface_t &x) {
        if(!attached) {
            if(start_line) {
                start_line = false;
                s.append(indtd);
            } else {
                s.append("\n"+indtd);
            }
            last ? s.append("└-") : s.append("|-");
        }
        last ? inc_indent() : inc_lindent();
        attached = true;
        last = false;
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("Interface");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        s.append("\n" + indtd + "|-" + "header=");
        attached = true;
        self().visit_interface_header(*x.m_header);
        s.append("\n" + indtd + "|-" + "trivia=");
        if (x.m_trivia) {
            self().visit_trivia(*x.m_trivia);
        } else {
            s.append("()");
        last = false;
        attached = false;
        }
        s.append("\n" + indtd + "└-" + "items=↧");
        for (size_t i=0; i<x.n_items; i++) {
            inc_indent();
            last = i == x.n_items-1;
            attached = false;
            self().visit_interface_item(*x.m_items[i]);
            dec_indent();
        }
        dec_indent();
    }
    void visit_DerivedType(const DerivedType_t &x) {
        if(!attached) {
            if(start_line) {
                start_line = false;
                s.append(indtd);
            } else {
                s.append("\n"+indtd);
            }
            last ? s.append("└-") : s.append("|-");
        }
        last ? inc_indent() : inc_lindent();
        attached = true;
        last = false;
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("DerivedType");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        s.append("\n" + indtd + "|-" + "name=");
        s.append(x.m_name);
        s.append("\n" + indtd + "|-" + "namelist=");
        for (size_t i=0; i<x.n_namelist; i++) {
            s.append(x.m_namelist[i]);
            if (i < x.n_namelist-1) s.append(" ");
        }
        s.append("\n" + indtd + "|-" + "trivia=");
        if (x.m_trivia) {
            self().visit_trivia(*x.m_trivia);
        } else {
            s.append("()");
        last = false;
        attached = false;
        }
        s.append("\n" + indtd + "|-" + "attrtype=↧");
        for (size_t i=0; i<x.n_attrtype; i++) {
            inc_lindent();
            last = i == x.n_attrtype-1;
            attached = false;
            self().visit_decl_attribute(*x.m_attrtype[i]);
            dec_indent();
        }
        s.append("\n" + indtd + "|-" + "items=↧");
        for (size_t i=0; i<x.n_items; i++) {
            inc_lindent();
            last = i == x.n_items-1;
            attached = false;
            self().visit_unit_decl2(*x.m_items[i]);
            dec_indent();
        }
        s.append("\n" + indtd + "└-" + "contains=↧");
        for (size_t i=0; i<x.n_contains; i++) {
            inc_indent();
            last = i == x.n_contains-1;
            attached = false;
            self().visit_procedure_decl(*x.m_contains[i]);
            dec_indent();
        }
        dec_indent();
    }
    void visit_Template(const Template_t &x) {
        if(!attached) {
            if(start_line) {
                start_line = false;
                s.append(indtd);
            } else {
                s.append("\n"+indtd);
            }
            last ? s.append("└-") : s.append("|-");
        }
        last ? inc_indent() : inc_lindent();
        attached = true;
        last = false;
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("Template");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        s.append("\n" + indtd + "|-" + "name=");
        s.append(x.m_name);
        s.append("\n" + indtd + "|-" + "namelist=");
        for (size_t i=0; i<x.n_namelist; i++) {
            s.append(x.m_namelist[i]);
            if (i < x.n_namelist-1) s.append(" ");
        }
        s.append("\n" + indtd + "|-" + "decl=↧");
        for (size_t i=0; i<x.n_decl; i++) {
            inc_lindent();
            last = i == x.n_decl-1;
            attached = false;
            self().visit_unit_decl2(*x.m_decl[i]);
            dec_indent();
        }
        s.append("\n" + indtd + "└-" + "contains=↧");
        for (size_t i=0; i<x.n_contains; i++) {
            inc_indent();
            last = i == x.n_contains-1;
            attached = false;
            self().visit_program_unit(*x.m_contains[i]);
            dec_indent();
        }
        dec_indent();
    }
    void visit_Enum(const Enum_t &x) {
        if(!attached) {
            if(start_line) {
                start_line = false;
                s.append(indtd);
            } else {
                s.append("\n"+indtd);
            }
            last ? s.append("└-") : s.append("|-");
        }
        last ? inc_indent() : inc_lindent();
        attached = true;
        last = false;
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("Enum");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        s.append("\n" + indtd + "|-" + "attr=↧");
        for (size_t i=0; i<x.n_attr; i++) {
            inc_lindent();
            last = i == x.n_attr-1;
            attached = false;
            self().visit_decl_attribute(*x.m_attr[i]);
            dec_indent();
        }
        s.append("\n" + indtd + "|-" + "trivia=");
        if (x.m_trivia) {
            self().visit_trivia(*x.m_trivia);
        } else {
            s.append("()");
        last = false;
        attached = false;
        }
        s.append("\n" + indtd + "└-" + "items=↧");
        for (size_t i=0; i<x.n_items; i++) {
            inc_indent();
            last = i == x.n_items-1;
            attached = false;
            self().visit_unit_decl2(*x.m_items[i]);
            dec_indent();
        }
        dec_indent();
    }
    void visit_Instantiate(const Instantiate_t &x) {
        if(!attached) {
            if(start_line) {
                start_line = false;
                s.append(indtd);
            } else {
                s.append("\n"+indtd);
            }
            last ? s.append("└-") : s.append("|-");
        }
        last ? inc_indent() : inc_lindent();
        attached = true;
        last = false;
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("Instantiate");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        s.append("\n" + indtd + "|-" + "name=");
        s.append(x.m_name);
        s.append("\n" + indtd + "|-" + "args=↧");
        for (size_t i=0; i<x.n_args; i++) {
            inc_lindent();
            last = i == x.n_args-1;
            attached = false;
            self().visit_decl_attribute(*x.m_args[i]);
            dec_indent();
        }
        s.append("\n" + indtd + "└-" + "symbols=↧");
        for (size_t i=0; i<x.n_symbols; i++) {
            inc_indent();
            last = i == x.n_symbols-1;
            attached = false;
            self().visit_use_symbol(*x.m_symbols[i]);
            dec_indent();
        }
        dec_indent();
    }
    void visit_Requirement(const Requirement_t &x) {
        if(!attached) {
            if(start_line) {
                start_line = false;
                s.append(indtd);
            } else {
                s.append("\n"+indtd);
            }
            last ? s.append("└-") : s.append("|-");
        }
        last ? inc_indent() : inc_lindent();
        attached = true;
        last = false;
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("Requirement");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        s.append("\n" + indtd + "|-" + "name=");
        s.append(x.m_name);
        s.append("\n" + indtd + "|-" + "namelist=");
        for (size_t i=0; i<x.n_namelist; i++) {
            s.append(x.m_namelist[i]);
            if (i < x.n_namelist-1) s.append(" ");
        }
        s.append("\n" + indtd + "|-" + "decl=↧");
        for (size_t i=0; i<x.n_decl; i++) {
            inc_lindent();
            last = i == x.n_decl-1;
            attached = false;
            self().visit_unit_decl2(*x.m_decl[i]);
            dec_indent();
        }
        s.append("\n" + indtd + "└-" + "funcs=↧");
        for (size_t i=0; i<x.n_funcs; i++) {
            inc_indent();
            last = i == x.n_funcs-1;
            attached = false;
            self().visit_program_unit(*x.m_funcs[i]);
            dec_indent();
        }
        dec_indent();
    }
    void visit_Require(const Require_t &x) {
        if(!attached) {
            if(start_line) {
                start_line = false;
                s.append(indtd);
            } else {
                s.append("\n"+indtd);
            }
            last ? s.append("└-") : s.append("|-");
        }
        last ? inc_indent() : inc_lindent();
        attached = true;
        last = false;
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("Require");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        s.append("\n" + indtd + "└-" + "reqs=↧");
        for (size_t i=0; i<x.n_reqs; i++) {
            inc_indent();
            last = i == x.n_reqs-1;
            attached = false;
            self().visit_unit_require(*x.m_reqs[i]);
            dec_indent();
        }
        dec_indent();
    }
    void visit_InterfaceHeader(const InterfaceHeader_t &x) {
        if(!attached) {
            if(start_line) {
                start_line = false;
                s.append(indtd);
            } else {
                s.append("\n"+indtd);
            }
            last ? s.append("└-") : s.append("|-");
        }
        last ? inc_indent() : inc_lindent();
        attached = true;
        last = false;
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("InterfaceHeader");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        dec_indent();
        if ((bool&)x) { } // Suppress unused warning
    }
    void visit_InterfaceHeaderName(const InterfaceHeaderName_t &x) {
        if(!attached) {
            if(start_line) {
                start_line = false;
                s.append(indtd);
            } else {
                s.append("\n"+indtd);
            }
            last ? s.append("└-") : s.append("|-");
        }
        last ? inc_indent() : inc_lindent();
        attached = true;
        last = false;
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("InterfaceHeaderName");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        s.append("\n" + indtd + "└-" + "name=");
        s.append(x.m_name);
        dec_indent();
        if ((bool&)x) { } // Suppress unused warning
    }
    void visit_InterfaceHeaderAssignment(const InterfaceHeaderAssignment_t &x) {
        if(!attached) {
            if(start_line) {
                start_line = false;
                s.append(indtd);
            } else {
                s.append("\n"+indtd);
            }
            last ? s.append("└-") : s.append("|-");
        }
        last ? inc_indent() : inc_lindent();
        attached = true;
        last = false;
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("InterfaceHeaderAssignment");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        dec_indent();
        if ((bool&)x) { } // Suppress unused warning
    }
    void visit_InterfaceHeaderOperator(const InterfaceHeaderOperator_t &x) {
        if(!attached) {
            if(start_line) {
                start_line = false;
                s.append(indtd);
            } else {
                s.append("\n"+indtd);
            }
            last ? s.append("└-") : s.append("|-");
        }
        last ? inc_indent() : inc_lindent();
        attached = true;
        last = false;
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("InterfaceHeaderOperator");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        s.append("\n" + indtd + "└-" + "intrinsicopType=");
        visit_intrinsicopType(x.m_op);
        dec_indent();
        if ((bool&)x) { } // Suppress unused warning
    }
    void visit_InterfaceHeaderDefinedOperator(const InterfaceHeaderDefinedOperator_t &x) {
        if(!attached) {
            if(start_line) {
                start_line = false;
                s.append(indtd);
            } else {
                s.append("\n"+indtd);
            }
            last ? s.append("└-") : s.append("|-");
        }
        last ? inc_indent() : inc_lindent();
        attached = true;
        last = false;
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("InterfaceHeaderDefinedOperator");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        s.append("\n" + indtd + "└-" + "operator_name=");
        s.append("\"" + std::string(x.m_operator_name) + "\"");
        dec_indent();
        if ((bool&)x) { } // Suppress unused warning
    }
    void visit_AbstractInterfaceHeader(const AbstractInterfaceHeader_t &x) {
        if(!attached) {
            if(start_line) {
                start_line = false;
                s.append(indtd);
            } else {
                s.append("\n"+indtd);
            }
            last ? s.append("└-") : s.append("|-");
        }
        last ? inc_indent() : inc_lindent();
        attached = true;
        last = false;
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("AbstractInterfaceHeader");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        dec_indent();
        if ((bool&)x) { } // Suppress unused warning
    }
    void visit_InterfaceHeaderWrite(const InterfaceHeaderWrite_t &x) {
        if(!attached) {
            if(start_line) {
                start_line = false;
                s.append(indtd);
            } else {
                s.append("\n"+indtd);
            }
            last ? s.append("└-") : s.append("|-");
        }
        last ? inc_indent() : inc_lindent();
        attached = true;
        last = false;
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("InterfaceHeaderWrite");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        s.append("\n" + indtd + "└-" + "id=");
        s.append(x.m_id);
        dec_indent();
        if ((bool&)x) { } // Suppress unused warning
    }
    void visit_InterfaceHeaderRead(const InterfaceHeaderRead_t &x) {
        if(!attached) {
            if(start_line) {
                start_line = false;
                s.append(indtd);
            } else {
                s.append("\n"+indtd);
            }
            last ? s.append("└-") : s.append("|-");
        }
        last ? inc_indent() : inc_lindent();
        attached = true;
        last = false;
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("InterfaceHeaderRead");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        s.append("\n" + indtd + "└-" + "id=");
        s.append(x.m_id);
        dec_indent();
        if ((bool&)x) { } // Suppress unused warning
    }
    void visit_InterfaceProc(const InterfaceProc_t &x) {
        if(!attached) {
            if(start_line) {
                start_line = false;
                s.append(indtd);
            } else {
                s.append("\n"+indtd);
            }
            last ? s.append("└-") : s.append("|-");
        }
        last ? inc_indent() : inc_lindent();
        attached = true;
        last = false;
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("InterfaceProc");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        s.append("\n" + indtd + "└-" + "proc=");
        last = true;
        attached = true;
        self().visit_program_unit(*x.m_proc);
        dec_indent();
    }
    void visit_InterfaceModuleProcedure(const InterfaceModuleProcedure_t &x) {
        if(!attached) {
            if(start_line) {
                start_line = false;
                s.append(indtd);
            } else {
                s.append("\n"+indtd);
            }
            last ? s.append("└-") : s.append("|-");
        }
        last ? inc_indent() : inc_lindent();
        attached = true;
        last = false;
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("InterfaceModuleProcedure");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        s.append("\n" + indtd + "|-" + "names=");
        for (size_t i=0; i<x.n_names; i++) {
            s.append(x.m_names[i]);
            if (i < x.n_names-1) s.append(" ");
        }
        s.append("\n" + indtd + "|-" + "attributes=↧");
        for (size_t i=0; i<x.n_attributes; i++) {
            inc_lindent();
            last = i == x.n_attributes-1;
            attached = false;
            self().visit_decl_attribute(*x.m_attributes[i]);
            dec_indent();
        }
        s.append("\n" + indtd + "└-" + "trivia=");
        last = true;
        if (x.m_trivia) {
            self().visit_trivia(*x.m_trivia);
        } else {
            s.append("()");
        last = false;
        attached = false;
        }
        dec_indent();
    }
    void visit_Import(const Import_t &x) {
        if(!attached) {
            if(start_line) {
                start_line = false;
                s.append(indtd);
            } else {
                s.append("\n"+indtd);
            }
            last ? s.append("└-") : s.append("|-");
        }
        last ? inc_indent() : inc_lindent();
        attached = true;
        last = false;
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("Import");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        s.append("\n" + indtd + "|-" + "symbols=");
        for (size_t i=0; i<x.n_symbols; i++) {
            s.append(x.m_symbols[i]);
            if (i < x.n_symbols-1) s.append(" ");
        }
        s.append("\n" + indtd + "|-" + "import_modifierType=");
        visit_import_modifierType(x.m_mod);
        s.append("\n" + indtd + "└-" + "trivia=");
        last = true;
        if (x.m_trivia) {
            self().visit_trivia(*x.m_trivia);
        } else {
            s.append("()");
        last = false;
        attached = false;
        }
        dec_indent();
    }
    void visit_import_modifierType(const import_modifierType &x) {
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::green));
        }
        switch (x) {
            case (import_modifierType::ImportDefault) : {
                s.append("ImportDefault");
             break; }
            case (import_modifierType::ImportOnly) : {
                s.append("ImportOnly");
             break; }
            case (import_modifierType::ImportNone) : {
                s.append("ImportNone");
             break; }
            case (import_modifierType::ImportAll) : {
                s.append("ImportAll");
             break; }
        }
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
    }
    void visit_ImplicitNone(const ImplicitNone_t &x) {
        if(!attached) {
            if(start_line) {
                start_line = false;
                s.append(indtd);
            } else {
                s.append("\n"+indtd);
            }
            last ? s.append("└-") : s.append("|-");
        }
        last ? inc_indent() : inc_lindent();
        attached = true;
        last = false;
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("ImplicitNone");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        s.append("\n" + indtd + "|-" + "specs=↧");
        for (size_t i=0; i<x.n_specs; i++) {
            inc_lindent();
            last = i == x.n_specs-1;
            attached = false;
            self().visit_implicit_none_spec(*x.m_specs[i]);
            dec_indent();
        }
        s.append("\n" + indtd + "└-" + "trivia=");
        last = true;
        if (x.m_trivia) {
            self().visit_trivia(*x.m_trivia);
        } else {
            s.append("()");
        last = false;
        attached = false;
        }
        dec_indent();
    }
    void visit_Implicit(const Implicit_t &x) {
        if(!attached) {
            if(start_line) {
                start_line = false;
                s.append(indtd);
            } else {
                s.append("\n"+indtd);
            }
            last ? s.append("└-") : s.append("|-");
        }
        last ? inc_indent() : inc_lindent();
        attached = true;
        last = false;
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("Implicit");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        s.append("\n" + indtd + "|-" + "type=");
        attached = true;
        self().visit_decl_attribute(*x.m_type);
        s.append("\n" + indtd + "|-" + "kind=↧");
        for (size_t i=0; i<x.n_kind; i++) {
            inc_lindent();
            last = i == x.n_kind-1;
            attached = false;
            self().visit_letter_spec(*x.m_kind[i]);
            dec_indent();
        }
        s.append("\n" + indtd + "|-" + "specs=↧");
        for (size_t i=0; i<x.n_specs; i++) {
            inc_lindent();
            last = i == x.n_specs-1;
            attached = false;
            self().visit_letter_spec(*x.m_specs[i]);
            dec_indent();
        }
        s.append("\n" + indtd + "└-" + "trivia=");
        last = true;
        if (x.m_trivia) {
            self().visit_trivia(*x.m_trivia);
        } else {
            s.append("()");
        last = false;
        attached = false;
        }
        dec_indent();
    }
    void visit_ImplicitNoneExternal(const ImplicitNoneExternal_t &x) {
        if(!attached) {
            if(start_line) {
                start_line = false;
                s.append(indtd);
            } else {
                s.append("\n"+indtd);
            }
            last ? s.append("└-") : s.append("|-");
        }
        last ? inc_indent() : inc_lindent();
        attached = true;
        last = false;
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("ImplicitNoneExternal");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        s.append("\n" + indtd + "└-" + "dummy=");
        s.append(std::to_string(x.m_dummy));
        dec_indent();
        if ((bool&)x) { } // Suppress unused warning
    }
    void visit_ImplicitNoneType(const ImplicitNoneType_t &x) {
        if(!attached) {
            if(start_line) {
                start_line = false;
                s.append(indtd);
            } else {
                s.append("\n"+indtd);
            }
            last ? s.append("└-") : s.append("|-");
        }
        last ? inc_indent() : inc_lindent();
        attached = true;
        last = false;
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("ImplicitNoneType");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        dec_indent();
        if ((bool&)x) { } // Suppress unused warning
    }
    void visit_LetterSpec(const LetterSpec_t &x) {
        if(!attached) {
            if(start_line) {
                start_line = false;
                s.append(indtd);
            } else {
                s.append("\n"+indtd);
            }
            last ? s.append("└-") : s.append("|-");
        }
        last ? inc_indent() : inc_lindent();
        attached = true;
        last = false;
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("LetterSpec");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        s.append("\n" + indtd + "|-" + "start=");
        if (x.m_start) {
            s.append(x.m_start);
        } else {
            s.append("()");
        }
        s.append("\n" + indtd + "└-" + "end=");
        s.append(x.m_end);
        dec_indent();
        if ((bool&)x) { } // Suppress unused warning
    }
    void visit_Allocate(const Allocate_t &x) {
        if(!attached) {
            if(start_line) {
                start_line = false;
                s.append(indtd);
            } else {
                s.append("\n"+indtd);
            }
            last ? s.append("└-") : s.append("|-");
        }
        last ? inc_indent() : inc_lindent();
        attached = true;
        last = false;
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("Allocate");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        s.append("\n" + indtd + "|-" + "label=");
        s.append(std::to_string(x.m_label));
        s.append("\n" + indtd + "|-" + "args=↧");
        for (size_t i=0; i<x.n_args; i++) {
            inc_lindent();
            last = i == x.n_args-1;
            attached = false;
            self().visit_fnarg(x.m_args[i]);
            dec_indent();
        }
        s.append("\n" + indtd + "|-" + "keywords=↧");
        for (size_t i=0; i<x.n_keywords; i++) {
            inc_lindent();
            last = i == x.n_keywords-1;
            attached = false;
            self().visit_keyword(x.m_keywords[i]);
            dec_indent();
        }
        s.append("\n" + indtd + "└-" + "trivia=");
        last = true;
        if (x.m_trivia) {
            self().visit_trivia(*x.m_trivia);
        } else {
            s.append("()");
        last = false;
        attached = false;
        }
        dec_indent();
    }
    void visit_Assign(const Assign_t &x) {
        if(!attached) {
            if(start_line) {
                start_line = false;
                s.append(indtd);
            } else {
                s.append("\n"+indtd);
            }
            last ? s.append("└-") : s.append("|-");
        }
        last ? inc_indent() : inc_lindent();
        attached = true;
        last = false;
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("Assign");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        s.append("\n" + indtd + "|-" + "label=");
        s.append(std::to_string(x.m_label));
        s.append("\n" + indtd + "|-" + "assign_label=");
        s.append(std::to_string(x.m_assign_label));
        s.append("\n" + indtd + "|-" + "variable=");
        s.append(x.m_variable);
        s.append("\n" + indtd + "└-" + "trivia=");
        last = true;
        if (x.m_trivia) {
            self().visit_trivia(*x.m_trivia);
        } else {
            s.append("()");
        last = false;
        attached = false;
        }
        dec_indent();
    }
    void visit_Assignment(const Assignment_t &x) {
        if(!attached) {
            if(start_line) {
                start_line = false;
                s.append(indtd);
            } else {
                s.append("\n"+indtd);
            }
            last ? s.append("└-") : s.append("|-");
        }
        last ? inc_indent() : inc_lindent();
        attached = true;
        last = false;
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("Assignment");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        s.append("\n" + indtd + "|-" + "label=");
        s.append(std::to_string(x.m_label));
        s.append("\n" + indtd + "|-" + "target=");
        attached = true;
        self().visit_expr(*x.m_target);
        s.append("\n" + indtd + "|-" + "value=");
        attached = true;
        self().visit_expr(*x.m_value);
        s.append("\n" + indtd + "└-" + "trivia=");
        last = true;
        if (x.m_trivia) {
            self().visit_trivia(*x.m_trivia);
        } else {
            s.append("()");
        last = false;
        attached = false;
        }
        dec_indent();
    }
    void visit_Associate(const Associate_t &x) {
        if(!attached) {
            if(start_line) {
                start_line = false;
                s.append(indtd);
            } else {
                s.append("\n"+indtd);
            }
            last ? s.append("└-") : s.append("|-");
        }
        last ? inc_indent() : inc_lindent();
        attached = true;
        last = false;
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("Associate");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        s.append("\n" + indtd + "|-" + "label=");
        s.append(std::to_string(x.m_label));
        s.append("\n" + indtd + "|-" + "target=");
        attached = true;
        self().visit_expr(*x.m_target);
        s.append("\n" + indtd + "|-" + "value=");
        attached = true;
        self().visit_expr(*x.m_value);
        s.append("\n" + indtd + "└-" + "trivia=");
        last = true;
        if (x.m_trivia) {
            self().visit_trivia(*x.m_trivia);
        } else {
            s.append("()");
        last = false;
        attached = false;
        }
        dec_indent();
    }
    void visit_Backspace(const Backspace_t &x) {
        if(!attached) {
            if(start_line) {
                start_line = false;
                s.append(indtd);
            } else {
                s.append("\n"+indtd);
            }
            last ? s.append("└-") : s.append("|-");
        }
        last ? inc_indent() : inc_lindent();
        attached = true;
        last = false;
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("Backspace");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        s.append("\n" + indtd + "|-" + "label=");
        s.append(std::to_string(x.m_label));
        s.append("\n" + indtd + "|-" + "args=↧");
        for (size_t i=0; i<x.n_args; i++) {
            inc_lindent();
            last = i == x.n_args-1;
            attached = false;
            self().visit_expr(*x.m_args[i]);
            dec_indent();
        }
        s.append("\n" + indtd + "|-" + "kwargs=↧");
        for (size_t i=0; i<x.n_kwargs; i++) {
            inc_lindent();
            last = i == x.n_kwargs-1;
            attached = false;
            self().visit_keyword(x.m_kwargs[i]);
            dec_indent();
        }
        s.append("\n" + indtd + "└-" + "trivia=");
        last = true;
        if (x.m_trivia) {
            self().visit_trivia(*x.m_trivia);
        } else {
            s.append("()");
        last = false;
        attached = false;
        }
        dec_indent();
    }
    void visit_Close(const Close_t &x) {
        if(!attached) {
            if(start_line) {
                start_line = false;
                s.append(indtd);
            } else {
                s.append("\n"+indtd);
            }
            last ? s.append("└-") : s.append("|-");
        }
        last ? inc_indent() : inc_lindent();
        attached = true;
        last = false;
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("Close");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        s.append("\n" + indtd + "|-" + "label=");
        s.append(std::to_string(x.m_label));
        s.append("\n" + indtd + "|-" + "args=↧");
        for (size_t i=0; i<x.n_args; i++) {
            inc_lindent();
            last = i == x.n_args-1;
            attached = false;
            self().visit_expr(*x.m_args[i]);
            dec_indent();
        }
        s.append("\n" + indtd + "|-" + "kwargs=↧");
        for (size_t i=0; i<x.n_kwargs; i++) {
            inc_lindent();
            last = i == x.n_kwargs-1;
            attached = false;
            self().visit_keyword(x.m_kwargs[i]);
            dec_indent();
        }
        s.append("\n" + indtd + "└-" + "trivia=");
        last = true;
        if (x.m_trivia) {
            self().visit_trivia(*x.m_trivia);
        } else {
            s.append("()");
        last = false;
        attached = false;
        }
        dec_indent();
    }
    void visit_Continue(const Continue_t &x) {
        if(!attached) {
            if(start_line) {
                start_line = false;
                s.append(indtd);
            } else {
                s.append("\n"+indtd);
            }
            last ? s.append("└-") : s.append("|-");
        }
        last ? inc_indent() : inc_lindent();
        attached = true;
        last = false;
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("Continue");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        s.append("\n" + indtd + "|-" + "label=");
        s.append(std::to_string(x.m_label));
        s.append("\n" + indtd + "└-" + "trivia=");
        last = true;
        if (x.m_trivia) {
            self().visit_trivia(*x.m_trivia);
        } else {
            s.append("()");
        last = false;
        attached = false;
        }
        dec_indent();
    }
    void visit_Cycle(const Cycle_t &x) {
        if(!attached) {
            if(start_line) {
                start_line = false;
                s.append(indtd);
            } else {
                s.append("\n"+indtd);
            }
            last ? s.append("└-") : s.append("|-");
        }
        last ? inc_indent() : inc_lindent();
        attached = true;
        last = false;
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("Cycle");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        s.append("\n" + indtd + "|-" + "label=");
        s.append(std::to_string(x.m_label));
        s.append("\n" + indtd + "|-" + "stmt_name=");
        if (x.m_stmt_name) {
            s.append(x.m_stmt_name);
        } else {
            s.append("()");
        }
        s.append("\n" + indtd + "└-" + "trivia=");
        last = true;
        if (x.m_trivia) {
            self().visit_trivia(*x.m_trivia);
        } else {
            s.append("()");
        last = false;
        attached = false;
        }
        dec_indent();
    }
    void visit_Deallocate(const Deallocate_t &x) {
        if(!attached) {
            if(start_line) {
                start_line = false;
                s.append(indtd);
            } else {
                s.append("\n"+indtd);
            }
            last ? s.append("└-") : s.append("|-");
        }
        last ? inc_indent() : inc_lindent();
        attached = true;
        last = false;
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("Deallocate");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        s.append("\n" + indtd + "|-" + "label=");
        s.append(std::to_string(x.m_label));
        s.append("\n" + indtd + "|-" + "args=↧");
        for (size_t i=0; i<x.n_args; i++) {
            inc_lindent();
            last = i == x.n_args-1;
            attached = false;
            self().visit_fnarg(x.m_args[i]);
            dec_indent();
        }
        s.append("\n" + indtd + "|-" + "keywords=↧");
        for (size_t i=0; i<x.n_keywords; i++) {
            inc_lindent();
            last = i == x.n_keywords-1;
            attached = false;
            self().visit_keyword(x.m_keywords[i]);
            dec_indent();
        }
        s.append("\n" + indtd + "└-" + "trivia=");
        last = true;
        if (x.m_trivia) {
            self().visit_trivia(*x.m_trivia);
        } else {
            s.append("()");
        last = false;
        attached = false;
        }
        dec_indent();
    }
    void visit_Endfile(const Endfile_t &x) {
        if(!attached) {
            if(start_line) {
                start_line = false;
                s.append(indtd);
            } else {
                s.append("\n"+indtd);
            }
            last ? s.append("└-") : s.append("|-");
        }
        last ? inc_indent() : inc_lindent();
        attached = true;
        last = false;
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("Endfile");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        s.append("\n" + indtd + "|-" + "label=");
        s.append(std::to_string(x.m_label));
        s.append("\n" + indtd + "|-" + "args=↧");
        for (size_t i=0; i<x.n_args; i++) {
            inc_lindent();
            last = i == x.n_args-1;
            attached = false;
            self().visit_expr(*x.m_args[i]);
            dec_indent();
        }
        s.append("\n" + indtd + "|-" + "kwargs=↧");
        for (size_t i=0; i<x.n_kwargs; i++) {
            inc_lindent();
            last = i == x.n_kwargs-1;
            attached = false;
            self().visit_keyword(x.m_kwargs[i]);
            dec_indent();
        }
        s.append("\n" + indtd + "└-" + "trivia=");
        last = true;
        if (x.m_trivia) {
            self().visit_trivia(*x.m_trivia);
        } else {
            s.append("()");
        last = false;
        attached = false;
        }
        dec_indent();
    }
    void visit_Entry(const Entry_t &x) {
        if(!attached) {
            if(start_line) {
                start_line = false;
                s.append(indtd);
            } else {
                s.append("\n"+indtd);
            }
            last ? s.append("└-") : s.append("|-");
        }
        last ? inc_indent() : inc_lindent();
        attached = true;
        last = false;
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("Entry");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        s.append("\n" + indtd + "|-" + "label=");
        s.append(std::to_string(x.m_label));
        s.append("\n" + indtd + "|-" + "name=");
        s.append(x.m_name);
        s.append("\n" + indtd + "|-" + "args=↧");
        for (size_t i=0; i<x.n_args; i++) {
            inc_lindent();
            last = i == x.n_args-1;
            attached = false;
            self().visit_arg(x.m_args[i]);
            dec_indent();
        }
        s.append("\n" + indtd + "|-" + "return_var=");
        if (x.m_return_var) {
            self().visit_expr(*x.m_return_var);
        } else {
            s.append("()");
        last = false;
        attached = false;
        }
        s.append("\n" + indtd + "|-" + "bind=");
        if (x.m_bind) {
            self().visit_bind(*x.m_bind);
        } else {
            s.append("()");
        last = false;
        attached = false;
        }
        s.append("\n" + indtd + "└-" + "trivia=");
        last = true;
        if (x.m_trivia) {
            self().visit_trivia(*x.m_trivia);
        } else {
            s.append("()");
        last = false;
        attached = false;
        }
        dec_indent();
    }
    void visit_ErrorStop(const ErrorStop_t &x) {
        if(!attached) {
            if(start_line) {
                start_line = false;
                s.append(indtd);
            } else {
                s.append("\n"+indtd);
            }
            last ? s.append("└-") : s.append("|-");
        }
        last ? inc_indent() : inc_lindent();
        attached = true;
        last = false;
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("ErrorStop");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        s.append("\n" + indtd + "|-" + "label=");
        s.append(std::to_string(x.m_label));
        s.append("\n" + indtd + "|-" + "code=");
        if (x.m_code) {
            self().visit_expr(*x.m_code);
        } else {
            s.append("()");
        last = false;
        attached = false;
        }
        s.append("\n" + indtd + "|-" + "quiet=");
        if (x.m_quiet) {
            self().visit_expr(*x.m_quiet);
        } else {
            s.append("()");
        last = false;
        attached = false;
        }
        s.append("\n" + indtd + "└-" + "trivia=");
        last = true;
        if (x.m_trivia) {
            self().visit_trivia(*x.m_trivia);
        } else {
            s.append("()");
        last = false;
        attached = false;
        }
        dec_indent();
    }
    void visit_EventPost(const EventPost_t &x) {
        if(!attached) {
            if(start_line) {
                start_line = false;
                s.append(indtd);
            } else {
                s.append("\n"+indtd);
            }
            last ? s.append("└-") : s.append("|-");
        }
        last ? inc_indent() : inc_lindent();
        attached = true;
        last = false;
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("EventPost");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        s.append("\n" + indtd + "|-" + "label=");
        s.append(std::to_string(x.m_label));
        s.append("\n" + indtd + "|-" + "variable=");
        attached = true;
        self().visit_expr(*x.m_variable);
        s.append("\n" + indtd + "|-" + "stat=↧");
        for (size_t i=0; i<x.n_stat; i++) {
            inc_lindent();
            last = i == x.n_stat-1;
            attached = false;
            self().visit_event_attribute(*x.m_stat[i]);
            dec_indent();
        }
        s.append("\n" + indtd + "└-" + "trivia=");
        last = true;
        if (x.m_trivia) {
            self().visit_trivia(*x.m_trivia);
        } else {
            s.append("()");
        last = false;
        attached = false;
        }
        dec_indent();
    }
    void visit_EventWait(const EventWait_t &x) {
        if(!attached) {
            if(start_line) {
                start_line = false;
                s.append(indtd);
            } else {
                s.append("\n"+indtd);
            }
            last ? s.append("└-") : s.append("|-");
        }
        last ? inc_indent() : inc_lindent();
        attached = true;
        last = false;
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("EventWait");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        s.append("\n" + indtd + "|-" + "label=");
        s.append(std::to_string(x.m_label));
        s.append("\n" + indtd + "|-" + "variable=");
        attached = true;
        self().visit_expr(*x.m_variable);
        s.append("\n" + indtd + "|-" + "spec=↧");
        for (size_t i=0; i<x.n_spec; i++) {
            inc_lindent();
            last = i == x.n_spec-1;
            attached = false;
            self().visit_event_attribute(*x.m_spec[i]);
            dec_indent();
        }
        s.append("\n" + indtd + "└-" + "trivia=");
        last = true;
        if (x.m_trivia) {
            self().visit_trivia(*x.m_trivia);
        } else {
            s.append("()");
        last = false;
        attached = false;
        }
        dec_indent();
    }
    void visit_Exit(const Exit_t &x) {
        if(!attached) {
            if(start_line) {
                start_line = false;
                s.append(indtd);
            } else {
                s.append("\n"+indtd);
            }
            last ? s.append("└-") : s.append("|-");
        }
        last ? inc_indent() : inc_lindent();
        attached = true;
        last = false;
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("Exit");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        s.append("\n" + indtd + "|-" + "label=");
        s.append(std::to_string(x.m_label));
        s.append("\n" + indtd + "|-" + "stmt_name=");
        if (x.m_stmt_name) {
            s.append(x.m_stmt_name);
        } else {
            s.append("()");
        }
        s.append("\n" + indtd + "└-" + "trivia=");
        last = true;
        if (x.m_trivia) {
            self().visit_trivia(*x.m_trivia);
        } else {
            s.append("()");
        last = false;
        attached = false;
        }
        dec_indent();
    }
    void visit_Flush(const Flush_t &x) {
        if(!attached) {
            if(start_line) {
                start_line = false;
                s.append(indtd);
            } else {
                s.append("\n"+indtd);
            }
            last ? s.append("└-") : s.append("|-");
        }
        last ? inc_indent() : inc_lindent();
        attached = true;
        last = false;
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("Flush");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        s.append("\n" + indtd + "|-" + "label=");
        s.append(std::to_string(x.m_label));
        s.append("\n" + indtd + "|-" + "args=↧");
        for (size_t i=0; i<x.n_args; i++) {
            inc_lindent();
            last = i == x.n_args-1;
            attached = false;
            self().visit_expr(*x.m_args[i]);
            dec_indent();
        }
        s.append("\n" + indtd + "|-" + "kwargs=↧");
        for (size_t i=0; i<x.n_kwargs; i++) {
            inc_lindent();
            last = i == x.n_kwargs-1;
            attached = false;
            self().visit_keyword(x.m_kwargs[i]);
            dec_indent();
        }
        s.append("\n" + indtd + "└-" + "trivia=");
        last = true;
        if (x.m_trivia) {
            self().visit_trivia(*x.m_trivia);
        } else {
            s.append("()");
        last = false;
        attached = false;
        }
        dec_indent();
    }
    void visit_ForAllSingle(const ForAllSingle_t &x) {
        if(!attached) {
            if(start_line) {
                start_line = false;
                s.append(indtd);
            } else {
                s.append("\n"+indtd);
            }
            last ? s.append("└-") : s.append("|-");
        }
        last ? inc_indent() : inc_lindent();
        attached = true;
        last = false;
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("ForAllSingle");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        s.append("\n" + indtd + "|-" + "label=");
        s.append(std::to_string(x.m_label));
        s.append("\n" + indtd + "|-" + "stmt_name=");
        if (x.m_stmt_name) {
            s.append(x.m_stmt_name);
        } else {
            s.append("()");
        }
        s.append("\n" + indtd + "|-" + "control=↧");
        for (size_t i=0; i<x.n_control; i++) {
            inc_lindent();
            last = i == x.n_control-1;
            attached = false;
            self().visit_concurrent_control(*x.m_control[i]);
            dec_indent();
        }
        s.append("\n" + indtd + "|-" + "mask=");
        if (x.m_mask) {
            self().visit_expr(*x.m_mask);
        } else {
            s.append("()");
        last = false;
        attached = false;
        }
        s.append("\n" + indtd + "|-" + "assign=");
        attached = true;
        self().visit_stmt(*x.m_assign);
        s.append("\n" + indtd + "└-" + "trivia=");
        last = true;
        if (x.m_trivia) {
            self().visit_trivia(*x.m_trivia);
        } else {
            s.append("()");
        last = false;
        attached = false;
        }
        dec_indent();
    }
    void visit_Format(const Format_t &x) {
        if(!attached) {
            if(start_line) {
                start_line = false;
                s.append(indtd);
            } else {
                s.append("\n"+indtd);
            }
            last ? s.append("└-") : s.append("|-");
        }
        last ? inc_indent() : inc_lindent();
        attached = true;
        last = false;
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("Format");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        s.append("\n" + indtd + "|-" + "label=");
        s.append(std::to_string(x.m_label));
        s.append("\n" + indtd + "|-" + "fmt=");
        s.append("\"" + std::string(x.m_fmt) + "\"");
        s.append("\n" + indtd + "└-" + "trivia=");
        last = true;
        if (x.m_trivia) {
            self().visit_trivia(*x.m_trivia);
        } else {
            s.append("()");
        last = false;
        attached = false;
        }
        dec_indent();
    }
    void visit_DataStmt(const DataStmt_t &x) {
        if(!attached) {
            if(start_line) {
                start_line = false;
                s.append(indtd);
            } else {
                s.append("\n"+indtd);
            }
            last ? s.append("└-") : s.append("|-");
        }
        last ? inc_indent() : inc_lindent();
        attached = true;
        last = false;
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("DataStmt");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        s.append("\n" + indtd + "|-" + "label=");
        s.append(std::to_string(x.m_label));
        s.append("\n" + indtd + "|-" + "items=↧");
        for (size_t i=0; i<x.n_items; i++) {
            inc_lindent();
            last = i == x.n_items-1;
            attached = false;
            self().visit_data_stmt_set(*x.m_items[i]);
            dec_indent();
        }
        s.append("\n" + indtd + "└-" + "trivia=");
        last = true;
        if (x.m_trivia) {
            self().visit_trivia(*x.m_trivia);
        } else {
            s.append("()");
        last = false;
        attached = false;
        }
        dec_indent();
    }
    void visit_FormTeam(const FormTeam_t &x) {
        if(!attached) {
            if(start_line) {
                start_line = false;
                s.append(indtd);
            } else {
                s.append("\n"+indtd);
            }
            last ? s.append("└-") : s.append("|-");
        }
        last ? inc_indent() : inc_lindent();
        attached = true;
        last = false;
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("FormTeam");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        s.append("\n" + indtd + "|-" + "label=");
        s.append(std::to_string(x.m_label));
        s.append("\n" + indtd + "|-" + "team_number=");
        attached = true;
        self().visit_expr(*x.m_team_number);
        s.append("\n" + indtd + "|-" + "team_var=");
        s.append(x.m_team_var);
        s.append("\n" + indtd + "|-" + "sync_stat=↧");
        for (size_t i=0; i<x.n_sync_stat; i++) {
            inc_lindent();
            last = i == x.n_sync_stat-1;
            attached = false;
            self().visit_event_attribute(*x.m_sync_stat[i]);
            dec_indent();
        }
        s.append("\n" + indtd + "└-" + "trivia=");
        last = true;
        if (x.m_trivia) {
            self().visit_trivia(*x.m_trivia);
        } else {
            s.append("()");
        last = false;
        attached = false;
        }
        dec_indent();
    }
    void visit_GoTo(const GoTo_t &x) {
        if(!attached) {
            if(start_line) {
                start_line = false;
                s.append(indtd);
            } else {
                s.append("\n"+indtd);
            }
            last ? s.append("└-") : s.append("|-");
        }
        last ? inc_indent() : inc_lindent();
        attached = true;
        last = false;
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("GoTo");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        s.append("\n" + indtd + "|-" + "label=");
        s.append(std::to_string(x.m_label));
        s.append("\n" + indtd + "|-" + "int_var=");
        if (x.m_int_var) {
            s.append(x.m_int_var);
        } else {
            s.append("()");
        }
        s.append("\n" + indtd + "|-" + "goto_label=");
        if (x.m_goto_label) {
            self().visit_expr(*x.m_goto_label);
        } else {
            s.append("()");
        last = false;
        attached = false;
        }
        s.append("\n" + indtd + "|-" + "labels=↧");
        for (size_t i=0; i<x.n_labels; i++) {
            inc_lindent();
            last = i == x.n_labels-1;
            attached = false;
            self().visit_expr(*x.m_labels[i]);
            dec_indent();
        }
        s.append("\n" + indtd + "└-" + "trivia=");
        last = true;
        if (x.m_trivia) {
            self().visit_trivia(*x.m_trivia);
        } else {
            s.append("()");
        last = false;
        attached = false;
        }
        dec_indent();
    }
    void visit_Include(const Include_t &x) {
        if(!attached) {
            if(start_line) {
                start_line = false;
                s.append(indtd);
            } else {
                s.append("\n"+indtd);
            }
            last ? s.append("└-") : s.append("|-");
        }
        last ? inc_indent() : inc_lindent();
        attached = true;
        last = false;
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("Include");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        s.append("\n" + indtd + "|-" + "label=");
        s.append(std::to_string(x.m_label));
        s.append("\n" + indtd + "|-" + "filename=");
        s.append("\"" + std::string(x.m_filename) + "\"");
        s.append("\n" + indtd + "└-" + "trivia=");
        last = true;
        if (x.m_trivia) {
            self().visit_trivia(*x.m_trivia);
        } else {
            s.append("()");
        last = false;
        attached = false;
        }
        dec_indent();
    }
    void visit_Inquire(const Inquire_t &x) {
        if(!attached) {
            if(start_line) {
                start_line = false;
                s.append(indtd);
            } else {
                s.append("\n"+indtd);
            }
            last ? s.append("└-") : s.append("|-");
        }
        last ? inc_indent() : inc_lindent();
        attached = true;
        last = false;
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("Inquire");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        s.append("\n" + indtd + "|-" + "label=");
        s.append(std::to_string(x.m_label));
        s.append("\n" + indtd + "|-" + "args=↧");
        for (size_t i=0; i<x.n_args; i++) {
            inc_lindent();
            last = i == x.n_args-1;
            attached = false;
            self().visit_expr(*x.m_args[i]);
            dec_indent();
        }
        s.append("\n" + indtd + "|-" + "kwargs=↧");
        for (size_t i=0; i<x.n_kwargs; i++) {
            inc_lindent();
            last = i == x.n_kwargs-1;
            attached = false;
            self().visit_keyword(x.m_kwargs[i]);
            dec_indent();
        }
        s.append("\n" + indtd + "|-" + "values=↧");
        for (size_t i=0; i<x.n_values; i++) {
            inc_lindent();
            last = i == x.n_values-1;
            attached = false;
            self().visit_expr(*x.m_values[i]);
            dec_indent();
        }
        s.append("\n" + indtd + "└-" + "trivia=");
        last = true;
        if (x.m_trivia) {
            self().visit_trivia(*x.m_trivia);
        } else {
            s.append("()");
        last = false;
        attached = false;
        }
        dec_indent();
    }
    void visit_Nullify(const Nullify_t &x) {
        if(!attached) {
            if(start_line) {
                start_line = false;
                s.append(indtd);
            } else {
                s.append("\n"+indtd);
            }
            last ? s.append("└-") : s.append("|-");
        }
        last ? inc_indent() : inc_lindent();
        attached = true;
        last = false;
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("Nullify");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        s.append("\n" + indtd + "|-" + "label=");
        s.append(std::to_string(x.m_label));
        s.append("\n" + indtd + "|-" + "args=↧");
        for (size_t i=0; i<x.n_args; i++) {
            inc_lindent();
            last = i == x.n_args-1;
            attached = false;
            self().visit_expr(*x.m_args[i]);
            dec_indent();
        }
        s.append("\n" + indtd + "|-" + "kwargs=↧");
        for (size_t i=0; i<x.n_kwargs; i++) {
            inc_lindent();
            last = i == x.n_kwargs-1;
            attached = false;
            self().visit_keyword(x.m_kwargs[i]);
            dec_indent();
        }
        s.append("\n" + indtd + "└-" + "trivia=");
        last = true;
        if (x.m_trivia) {
            self().visit_trivia(*x.m_trivia);
        } else {
            s.append("()");
        last = false;
        attached = false;
        }
        dec_indent();
    }
    void visit_Open(const Open_t &x) {
        if(!attached) {
            if(start_line) {
                start_line = false;
                s.append(indtd);
            } else {
                s.append("\n"+indtd);
            }
            last ? s.append("└-") : s.append("|-");
        }
        last ? inc_indent() : inc_lindent();
        attached = true;
        last = false;
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("Open");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        s.append("\n" + indtd + "|-" + "label=");
        s.append(std::to_string(x.m_label));
        s.append("\n" + indtd + "|-" + "args=↧");
        for (size_t i=0; i<x.n_args; i++) {
            inc_lindent();
            last = i == x.n_args-1;
            attached = false;
            self().visit_expr(*x.m_args[i]);
            dec_indent();
        }
        s.append("\n" + indtd + "|-" + "kwargs=↧");
        for (size_t i=0; i<x.n_kwargs; i++) {
            inc_lindent();
            last = i == x.n_kwargs-1;
            attached = false;
            self().visit_keyword(x.m_kwargs[i]);
            dec_indent();
        }
        s.append("\n" + indtd + "└-" + "trivia=");
        last = true;
        if (x.m_trivia) {
            self().visit_trivia(*x.m_trivia);
        } else {
            s.append("()");
        last = false;
        attached = false;
        }
        dec_indent();
    }
    void visit_Return(const Return_t &x) {
        if(!attached) {
            if(start_line) {
                start_line = false;
                s.append(indtd);
            } else {
                s.append("\n"+indtd);
            }
            last ? s.append("└-") : s.append("|-");
        }
        last ? inc_indent() : inc_lindent();
        attached = true;
        last = false;
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("Return");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        s.append("\n" + indtd + "|-" + "label=");
        s.append(std::to_string(x.m_label));
        s.append("\n" + indtd + "|-" + "value=");
        if (x.m_value) {
            self().visit_expr(*x.m_value);
        } else {
            s.append("()");
        last = false;
        attached = false;
        }
        s.append("\n" + indtd + "└-" + "trivia=");
        last = true;
        if (x.m_trivia) {
            self().visit_trivia(*x.m_trivia);
        } else {
            s.append("()");
        last = false;
        attached = false;
        }
        dec_indent();
    }
    void visit_Pragma(const Pragma_t &x) {
        if(!attached) {
            if(start_line) {
                start_line = false;
                s.append(indtd);
            } else {
                s.append("\n"+indtd);
            }
            last ? s.append("└-") : s.append("|-");
        }
        last ? inc_indent() : inc_lindent();
        attached = true;
        last = false;
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("Pragma");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        s.append("\n" + indtd + "|-" + "label=");
        s.append(std::to_string(x.m_label));
        s.append("\n" + indtd + "|-" + "pragma_typeType=");
        visit_pragma_typeType(x.m_type);
        s.append("\n" + indtd + "|-" + "end=");
        if (x.m_end) {
            s.append(".true.");
        } else {
            s.append(".false.");
        }
        s.append("\n" + indtd + "|-" + "construct_name=");
        s.append("\"" + std::string(x.m_construct_name) + "\"");
        s.append("\n" + indtd + "|-" + "clauses=↧");
        for (size_t i=0; i<x.n_clauses; i++) {
            inc_lindent();
            last = i == x.n_clauses-1;
            attached = false;
            self().visit_expr(*x.m_clauses[i]);
            dec_indent();
        }
        s.append("\n" + indtd + "└-" + "trivia=");
        last = true;
        if (x.m_trivia) {
            self().visit_trivia(*x.m_trivia);
        } else {
            s.append("()");
        last = false;
        attached = false;
        }
        dec_indent();
    }
    void visit_Print(const Print_t &x) {
        if(!attached) {
            if(start_line) {
                start_line = false;
                s.append(indtd);
            } else {
                s.append("\n"+indtd);
            }
            last ? s.append("└-") : s.append("|-");
        }
        last ? inc_indent() : inc_lindent();
        attached = true;
        last = false;
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("Print");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        s.append("\n" + indtd + "|-" + "label=");
        s.append(std::to_string(x.m_label));
        s.append("\n" + indtd + "|-" + "fmt=");
        if (x.m_fmt) {
            self().visit_expr(*x.m_fmt);
        } else {
            s.append("()");
        last = false;
        attached = false;
        }
        s.append("\n" + indtd + "|-" + "values=↧");
        for (size_t i=0; i<x.n_values; i++) {
            inc_lindent();
            last = i == x.n_values-1;
            attached = false;
            self().visit_expr(*x.m_values[i]);
            dec_indent();
        }
        s.append("\n" + indtd + "└-" + "trivia=");
        last = true;
        if (x.m_trivia) {
            self().visit_trivia(*x.m_trivia);
        } else {
            s.append("()");
        last = false;
        attached = false;
        }
        dec_indent();
    }
    void visit_Read(const Read_t &x) {
        if(!attached) {
            if(start_line) {
                start_line = false;
                s.append(indtd);
            } else {
                s.append("\n"+indtd);
            }
            last ? s.append("└-") : s.append("|-");
        }
        last ? inc_indent() : inc_lindent();
        attached = true;
        last = false;
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("Read");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        s.append("\n" + indtd + "|-" + "label=");
        s.append(std::to_string(x.m_label));
        s.append("\n" + indtd + "|-" + "format=");
        if (x.m_format) {
            self().visit_expr(*x.m_format);
        } else {
            s.append("()");
        last = false;
        attached = false;
        }
        s.append("\n" + indtd + "|-" + "args=↧");
        for (size_t i=0; i<x.n_args; i++) {
            inc_lindent();
            last = i == x.n_args-1;
            attached = false;
            self().visit_argstar(x.m_args[i]);
            dec_indent();
        }
        s.append("\n" + indtd + "|-" + "kwargs=↧");
        for (size_t i=0; i<x.n_kwargs; i++) {
            inc_lindent();
            last = i == x.n_kwargs-1;
            attached = false;
            self().visit_kw_argstar(x.m_kwargs[i]);
            dec_indent();
        }
        s.append("\n" + indtd + "|-" + "values=↧");
        for (size_t i=0; i<x.n_values; i++) {
            inc_lindent();
            last = i == x.n_values-1;
            attached = false;
            self().visit_expr(*x.m_values[i]);
            dec_indent();
        }
        s.append("\n" + indtd + "└-" + "trivia=");
        last = true;
        if (x.m_trivia) {
            self().visit_trivia(*x.m_trivia);
        } else {
            s.append("()");
        last = false;
        attached = false;
        }
        dec_indent();
    }
    void visit_Rewind(const Rewind_t &x) {
        if(!attached) {
            if(start_line) {
                start_line = false;
                s.append(indtd);
            } else {
                s.append("\n"+indtd);
            }
            last ? s.append("└-") : s.append("|-");
        }
        last ? inc_indent() : inc_lindent();
        attached = true;
        last = false;
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("Rewind");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        s.append("\n" + indtd + "|-" + "label=");
        s.append(std::to_string(x.m_label));
        s.append("\n" + indtd + "|-" + "args=↧");
        for (size_t i=0; i<x.n_args; i++) {
            inc_lindent();
            last = i == x.n_args-1;
            attached = false;
            self().visit_expr(*x.m_args[i]);
            dec_indent();
        }
        s.append("\n" + indtd + "|-" + "kwargs=↧");
        for (size_t i=0; i<x.n_kwargs; i++) {
            inc_lindent();
            last = i == x.n_kwargs-1;
            attached = false;
            self().visit_keyword(x.m_kwargs[i]);
            dec_indent();
        }
        s.append("\n" + indtd + "└-" + "trivia=");
        last = true;
        if (x.m_trivia) {
            self().visit_trivia(*x.m_trivia);
        } else {
            s.append("()");
        last = false;
        attached = false;
        }
        dec_indent();
    }
    void visit_Stop(const Stop_t &x) {
        if(!attached) {
            if(start_line) {
                start_line = false;
                s.append(indtd);
            } else {
                s.append("\n"+indtd);
            }
            last ? s.append("└-") : s.append("|-");
        }
        last ? inc_indent() : inc_lindent();
        attached = true;
        last = false;
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("Stop");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        s.append("\n" + indtd + "|-" + "label=");
        s.append(std::to_string(x.m_label));
        s.append("\n" + indtd + "|-" + "code=");
        if (x.m_code) {
            self().visit_expr(*x.m_code);
        } else {
            s.append("()");
        last = false;
        attached = false;
        }
        s.append("\n" + indtd + "|-" + "quiet=");
        if (x.m_quiet) {
            self().visit_expr(*x.m_quiet);
        } else {
            s.append("()");
        last = false;
        attached = false;
        }
        s.append("\n" + indtd + "└-" + "trivia=");
        last = true;
        if (x.m_trivia) {
            self().visit_trivia(*x.m_trivia);
        } else {
            s.append("()");
        last = false;
        attached = false;
        }
        dec_indent();
    }
    void visit_SubroutineCall(const SubroutineCall_t &x) {
        if(!attached) {
            if(start_line) {
                start_line = false;
                s.append(indtd);
            } else {
                s.append("\n"+indtd);
            }
            last ? s.append("└-") : s.append("|-");
        }
        last ? inc_indent() : inc_lindent();
        attached = true;
        last = false;
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("SubroutineCall");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        s.append("\n" + indtd + "|-" + "label=");
        s.append(std::to_string(x.m_label));
        s.append("\n" + indtd + "|-" + "name=");
        s.append(x.m_name);
        s.append("\n" + indtd + "|-" + "member=↧");
        for (size_t i=0; i<x.n_member; i++) {
            inc_lindent();
            last = i == x.n_member-1;
            attached = false;
            self().visit_struct_member(x.m_member[i]);
            dec_indent();
        }
        s.append("\n" + indtd + "|-" + "args=↧");
        for (size_t i=0; i<x.n_args; i++) {
            inc_lindent();
            last = i == x.n_args-1;
            attached = false;
            self().visit_fnarg(x.m_args[i]);
            dec_indent();
        }
        s.append("\n" + indtd + "|-" + "keywords=↧");
        for (size_t i=0; i<x.n_keywords; i++) {
            inc_lindent();
            last = i == x.n_keywords-1;
            attached = false;
            self().visit_keyword(x.m_keywords[i]);
            dec_indent();
        }
        s.append("\n" + indtd + "|-" + "temp_args=↧");
        for (size_t i=0; i<x.n_temp_args; i++) {
            inc_lindent();
            last = i == x.n_temp_args-1;
            attached = false;
            self().visit_decl_attribute(*x.m_temp_args[i]);
            dec_indent();
        }
        s.append("\n" + indtd + "└-" + "trivia=");
        last = true;
        if (x.m_trivia) {
            self().visit_trivia(*x.m_trivia);
        } else {
            s.append("()");
        last = false;
        attached = false;
        }
        dec_indent();
    }
    void visit_SyncAll(const SyncAll_t &x) {
        if(!attached) {
            if(start_line) {
                start_line = false;
                s.append(indtd);
            } else {
                s.append("\n"+indtd);
            }
            last ? s.append("└-") : s.append("|-");
        }
        last ? inc_indent() : inc_lindent();
        attached = true;
        last = false;
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("SyncAll");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        s.append("\n" + indtd + "|-" + "label=");
        s.append(std::to_string(x.m_label));
        s.append("\n" + indtd + "|-" + "stat=↧");
        for (size_t i=0; i<x.n_stat; i++) {
            inc_lindent();
            last = i == x.n_stat-1;
            attached = false;
            self().visit_event_attribute(*x.m_stat[i]);
            dec_indent();
        }
        s.append("\n" + indtd + "└-" + "trivia=");
        last = true;
        if (x.m_trivia) {
            self().visit_trivia(*x.m_trivia);
        } else {
            s.append("()");
        last = false;
        attached = false;
        }
        dec_indent();
    }
    void visit_SyncImages(const SyncImages_t &x) {
        if(!attached) {
            if(start_line) {
                start_line = false;
                s.append(indtd);
            } else {
                s.append("\n"+indtd);
            }
            last ? s.append("└-") : s.append("|-");
        }
        last ? inc_indent() : inc_lindent();
        attached = true;
        last = false;
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("SyncImages");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        s.append("\n" + indtd + "|-" + "label=");
        s.append(std::to_string(x.m_label));
        s.append("\n" + indtd + "|-" + "image_set=");
        if (x.m_image_set) {
            self().visit_expr(*x.m_image_set);
        } else {
            s.append("()");
        last = false;
        attached = false;
        }
        s.append("\n" + indtd + "|-" + "symbolType=");
        visit_symbolType(x.m_sym);
        s.append("\n" + indtd + "|-" + "stat=↧");
        for (size_t i=0; i<x.n_stat; i++) {
            inc_lindent();
            last = i == x.n_stat-1;
            attached = false;
            self().visit_event_attribute(*x.m_stat[i]);
            dec_indent();
        }
        s.append("\n" + indtd + "└-" + "trivia=");
        last = true;
        if (x.m_trivia) {
            self().visit_trivia(*x.m_trivia);
        } else {
            s.append("()");
        last = false;
        attached = false;
        }
        dec_indent();
    }
    void visit_SyncMemory(const SyncMemory_t &x) {
        if(!attached) {
            if(start_line) {
                start_line = false;
                s.append(indtd);
            } else {
                s.append("\n"+indtd);
            }
            last ? s.append("└-") : s.append("|-");
        }
        last ? inc_indent() : inc_lindent();
        attached = true;
        last = false;
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("SyncMemory");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        s.append("\n" + indtd + "|-" + "label=");
        s.append(std::to_string(x.m_label));
        s.append("\n" + indtd + "|-" + "stat=↧");
        for (size_t i=0; i<x.n_stat; i++) {
            inc_lindent();
            last = i == x.n_stat-1;
            attached = false;
            self().visit_event_attribute(*x.m_stat[i]);
            dec_indent();
        }
        s.append("\n" + indtd + "└-" + "trivia=");
        last = true;
        if (x.m_trivia) {
            self().visit_trivia(*x.m_trivia);
        } else {
            s.append("()");
        last = false;
        attached = false;
        }
        dec_indent();
    }
    void visit_SyncTeam(const SyncTeam_t &x) {
        if(!attached) {
            if(start_line) {
                start_line = false;
                s.append(indtd);
            } else {
                s.append("\n"+indtd);
            }
            last ? s.append("└-") : s.append("|-");
        }
        last ? inc_indent() : inc_lindent();
        attached = true;
        last = false;
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("SyncTeam");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        s.append("\n" + indtd + "|-" + "label=");
        s.append(std::to_string(x.m_label));
        s.append("\n" + indtd + "|-" + "value=");
        attached = true;
        self().visit_expr(*x.m_value);
        s.append("\n" + indtd + "|-" + "stat=↧");
        for (size_t i=0; i<x.n_stat; i++) {
            inc_lindent();
            last = i == x.n_stat-1;
            attached = false;
            self().visit_event_attribute(*x.m_stat[i]);
            dec_indent();
        }
        s.append("\n" + indtd + "└-" + "trivia=");
        last = true;
        if (x.m_trivia) {
            self().visit_trivia(*x.m_trivia);
        } else {
            s.append("()");
        last = false;
        attached = false;
        }
        dec_indent();
    }
    void visit_Write(const Write_t &x) {
        if(!attached) {
            if(start_line) {
                start_line = false;
                s.append(indtd);
            } else {
                s.append("\n"+indtd);
            }
            last ? s.append("└-") : s.append("|-");
        }
        last ? inc_indent() : inc_lindent();
        attached = true;
        last = false;
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("Write");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        s.append("\n" + indtd + "|-" + "label=");
        s.append(std::to_string(x.m_label));
        s.append("\n" + indtd + "|-" + "args=↧");
        for (size_t i=0; i<x.n_args; i++) {
            inc_lindent();
            last = i == x.n_args-1;
            attached = false;
            self().visit_argstar(x.m_args[i]);
            dec_indent();
        }
        s.append("\n" + indtd + "|-" + "kwargs=↧");
        for (size_t i=0; i<x.n_kwargs; i++) {
            inc_lindent();
            last = i == x.n_kwargs-1;
            attached = false;
            self().visit_kw_argstar(x.m_kwargs[i]);
            dec_indent();
        }
        s.append("\n" + indtd + "|-" + "values=↧");
        for (size_t i=0; i<x.n_values; i++) {
            inc_lindent();
            last = i == x.n_values-1;
            attached = false;
            self().visit_expr(*x.m_values[i]);
            dec_indent();
        }
        s.append("\n" + indtd + "└-" + "trivia=");
        last = true;
        if (x.m_trivia) {
            self().visit_trivia(*x.m_trivia);
        } else {
            s.append("()");
        last = false;
        attached = false;
        }
        dec_indent();
    }
    void visit_AssociateBlock(const AssociateBlock_t &x) {
        if(!attached) {
            if(start_line) {
                start_line = false;
                s.append(indtd);
            } else {
                s.append("\n"+indtd);
            }
            last ? s.append("└-") : s.append("|-");
        }
        last ? inc_indent() : inc_lindent();
        attached = true;
        last = false;
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("AssociateBlock");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        s.append("\n" + indtd + "|-" + "label=");
        s.append(std::to_string(x.m_label));
        s.append("\n" + indtd + "|-" + "stmt_name=");
        if (x.m_stmt_name) {
            s.append(x.m_stmt_name);
        } else {
            s.append("()");
        }
        s.append("\n" + indtd + "|-" + "syms=↧");
        for (size_t i=0; i<x.n_syms; i++) {
            inc_lindent();
            last = i == x.n_syms-1;
            attached = false;
            self().visit_var_sym(x.m_syms[i]);
            dec_indent();
        }
        s.append("\n" + indtd + "|-" + "body=↧");
        for (size_t i=0; i<x.n_body; i++) {
            inc_lindent();
            last = i == x.n_body-1;
            attached = false;
            self().visit_stmt(*x.m_body[i]);
            dec_indent();
        }
        s.append("\n" + indtd + "|-" + "t_inside=");
        if (x.m_t_inside) {
            self().visit_trivia(*x.m_t_inside);
        } else {
            s.append("()");
        last = false;
        attached = false;
        }
        s.append("\n" + indtd + "└-" + "trivia=");
        last = true;
        if (x.m_trivia) {
            self().visit_trivia(*x.m_trivia);
        } else {
            s.append("()");
        last = false;
        attached = false;
        }
        dec_indent();
    }
    void visit_Block(const Block_t &x) {
        if(!attached) {
            if(start_line) {
                start_line = false;
                s.append(indtd);
            } else {
                s.append("\n"+indtd);
            }
            last ? s.append("└-") : s.append("|-");
        }
        last ? inc_indent() : inc_lindent();
        attached = true;
        last = false;
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("Block");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        s.append("\n" + indtd + "|-" + "label=");
        s.append(std::to_string(x.m_label));
        s.append("\n" + indtd + "|-" + "stmt_name=");
        if (x.m_stmt_name) {
            s.append(x.m_stmt_name);
        } else {
            s.append("()");
        }
        s.append("\n" + indtd + "|-" + "use=↧");
        for (size_t i=0; i<x.n_use; i++) {
            inc_lindent();
            last = i == x.n_use-1;
            attached = false;
            self().visit_unit_decl1(*x.m_use[i]);
            dec_indent();
        }
        s.append("\n" + indtd + "|-" + "import=↧");
        for (size_t i=0; i<x.n_import; i++) {
            inc_lindent();
            last = i == x.n_import-1;
            attached = false;
            self().visit_import_statement(*x.m_import[i]);
            dec_indent();
        }
        s.append("\n" + indtd + "|-" + "decl=↧");
        for (size_t i=0; i<x.n_decl; i++) {
            inc_lindent();
            last = i == x.n_decl-1;
            attached = false;
            self().visit_unit_decl2(*x.m_decl[i]);
            dec_indent();
        }
        s.append("\n" + indtd + "|-" + "body=↧");
        for (size_t i=0; i<x.n_body; i++) {
            inc_lindent();
            last = i == x.n_body-1;
            attached = false;
            self().visit_stmt(*x.m_body[i]);
            dec_indent();
        }
        s.append("\n" + indtd + "|-" + "t_inside=");
        if (x.m_t_inside) {
            self().visit_trivia(*x.m_t_inside);
        } else {
            s.append("()");
        last = false;
        attached = false;
        }
        s.append("\n" + indtd + "└-" + "trivia=");
        last = true;
        if (x.m_trivia) {
            self().visit_trivia(*x.m_trivia);
        } else {
            s.append("()");
        last = false;
        attached = false;
        }
        dec_indent();
    }
    void visit_ChangeTeam(const ChangeTeam_t &x) {
        if(!attached) {
            if(start_line) {
                start_line = false;
                s.append(indtd);
            } else {
                s.append("\n"+indtd);
            }
            last ? s.append("└-") : s.append("|-");
        }
        last ? inc_indent() : inc_lindent();
        attached = true;
        last = false;
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("ChangeTeam");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        s.append("\n" + indtd + "|-" + "label=");
        s.append(std::to_string(x.m_label));
        s.append("\n" + indtd + "|-" + "stmt_name=");
        if (x.m_stmt_name) {
            s.append(x.m_stmt_name);
        } else {
            s.append("()");
        }
        s.append("\n" + indtd + "|-" + "team_value=");
        attached = true;
        self().visit_expr(*x.m_team_value);
        s.append("\n" + indtd + "|-" + "coarray_assoc=↧");
        for (size_t i=0; i<x.n_coarray_assoc; i++) {
            inc_lindent();
            last = i == x.n_coarray_assoc-1;
            attached = false;
            self().visit_team_attribute(*x.m_coarray_assoc[i]);
            dec_indent();
        }
        s.append("\n" + indtd + "|-" + "sync=↧");
        for (size_t i=0; i<x.n_sync; i++) {
            inc_lindent();
            last = i == x.n_sync-1;
            attached = false;
            self().visit_event_attribute(*x.m_sync[i]);
            dec_indent();
        }
        s.append("\n" + indtd + "|-" + "body=↧");
        for (size_t i=0; i<x.n_body; i++) {
            inc_lindent();
            last = i == x.n_body-1;
            attached = false;
            self().visit_stmt(*x.m_body[i]);
            dec_indent();
        }
        s.append("\n" + indtd + "|-" + "t_inside=");
        if (x.m_t_inside) {
            self().visit_trivia(*x.m_t_inside);
        } else {
            s.append("()");
        last = false;
        attached = false;
        }
        s.append("\n" + indtd + "|-" + "trivia=");
        if (x.m_trivia) {
            self().visit_trivia(*x.m_trivia);
        } else {
            s.append("()");
        last = false;
        attached = false;
        }
        s.append("\n" + indtd + "└-" + "sync_stat=↧");
        for (size_t i=0; i<x.n_sync_stat; i++) {
            inc_indent();
            last = i == x.n_sync_stat-1;
            attached = false;
            self().visit_event_attribute(*x.m_sync_stat[i]);
            dec_indent();
        }
        dec_indent();
    }
    void visit_Critical(const Critical_t &x) {
        if(!attached) {
            if(start_line) {
                start_line = false;
                s.append(indtd);
            } else {
                s.append("\n"+indtd);
            }
            last ? s.append("└-") : s.append("|-");
        }
        last ? inc_indent() : inc_lindent();
        attached = true;
        last = false;
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("Critical");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        s.append("\n" + indtd + "|-" + "label=");
        s.append(std::to_string(x.m_label));
        s.append("\n" + indtd + "|-" + "stmt_name=");
        if (x.m_stmt_name) {
            s.append(x.m_stmt_name);
        } else {
            s.append("()");
        }
        s.append("\n" + indtd + "|-" + "sync_stat=↧");
        for (size_t i=0; i<x.n_sync_stat; i++) {
            inc_lindent();
            last = i == x.n_sync_stat-1;
            attached = false;
            self().visit_event_attribute(*x.m_sync_stat[i]);
            dec_indent();
        }
        s.append("\n" + indtd + "|-" + "body=↧");
        for (size_t i=0; i<x.n_body; i++) {
            inc_lindent();
            last = i == x.n_body-1;
            attached = false;
            self().visit_stmt(*x.m_body[i]);
            dec_indent();
        }
        s.append("\n" + indtd + "|-" + "t_inside=");
        if (x.m_t_inside) {
            self().visit_trivia(*x.m_t_inside);
        } else {
            s.append("()");
        last = false;
        attached = false;
        }
        s.append("\n" + indtd + "└-" + "trivia=");
        last = true;
        if (x.m_trivia) {
            self().visit_trivia(*x.m_trivia);
        } else {
            s.append("()");
        last = false;
        attached = false;
        }
        dec_indent();
    }
    void visit_DoConcurrentLoop(const DoConcurrentLoop_t &x) {
        if(!attached) {
            if(start_line) {
                start_line = false;
                s.append(indtd);
            } else {
                s.append("\n"+indtd);
            }
            last ? s.append("└-") : s.append("|-");
        }
        last ? inc_indent() : inc_lindent();
        attached = true;
        last = false;
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("DoConcurrentLoop");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        s.append("\n" + indtd + "|-" + "label=");
        s.append(std::to_string(x.m_label));
        s.append("\n" + indtd + "|-" + "stmt_name=");
        if (x.m_stmt_name) {
            s.append(x.m_stmt_name);
        } else {
            s.append("()");
        }
        s.append("\n" + indtd + "|-" + "control=↧");
        for (size_t i=0; i<x.n_control; i++) {
            inc_lindent();
            last = i == x.n_control-1;
            attached = false;
            self().visit_concurrent_control(*x.m_control[i]);
            dec_indent();
        }
        s.append("\n" + indtd + "|-" + "mask=");
        if (x.m_mask) {
            self().visit_expr(*x.m_mask);
        } else {
            s.append("()");
        last = false;
        attached = false;
        }
        s.append("\n" + indtd + "|-" + "locality=↧");
        for (size_t i=0; i<x.n_locality; i++) {
            inc_lindent();
            last = i == x.n_locality-1;
            attached = false;
            self().visit_concurrent_locality(*x.m_locality[i]);
            dec_indent();
        }
        s.append("\n" + indtd + "|-" + "body=↧");
        for (size_t i=0; i<x.n_body; i++) {
            inc_lindent();
            last = i == x.n_body-1;
            attached = false;
            self().visit_stmt(*x.m_body[i]);
            dec_indent();
        }
        s.append("\n" + indtd + "|-" + "t_inside=");
        if (x.m_t_inside) {
            self().visit_trivia(*x.m_t_inside);
        } else {
            s.append("()");
        last = false;
        attached = false;
        }
        s.append("\n" + indtd + "└-" + "trivia=");
        last = true;
        if (x.m_trivia) {
            self().visit_trivia(*x.m_trivia);
        } else {
            s.append("()");
        last = false;
        attached = false;
        }
        dec_indent();
    }
    void visit_DoLoop(const DoLoop_t &x) {
        if(!attached) {
            if(start_line) {
                start_line = false;
                s.append(indtd);
            } else {
                s.append("\n"+indtd);
            }
            last ? s.append("└-") : s.append("|-");
        }
        last ? inc_indent() : inc_lindent();
        attached = true;
        last = false;
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("DoLoop");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        s.append("\n" + indtd + "|-" + "label=");
        s.append(std::to_string(x.m_label));
        s.append("\n" + indtd + "|-" + "stmt_name=");
        if (x.m_stmt_name) {
            s.append(x.m_stmt_name);
        } else {
            s.append("()");
        }
        s.append("\n" + indtd + "|-" + "do_label=");
        s.append(std::to_string(x.m_do_label));
        s.append("\n" + indtd + "|-" + "var=");
        if (x.m_var) {
            s.append(x.m_var);
        } else {
            s.append("()");
        }
        s.append("\n" + indtd + "|-" + "start=");
        if (x.m_start) {
            self().visit_expr(*x.m_start);
        } else {
            s.append("()");
        last = false;
        attached = false;
        }
        s.append("\n" + indtd + "|-" + "end=");
        if (x.m_end) {
            self().visit_expr(*x.m_end);
        } else {
            s.append("()");
        last = false;
        attached = false;
        }
        s.append("\n" + indtd + "|-" + "increment=");
        if (x.m_increment) {
            self().visit_expr(*x.m_increment);
        } else {
            s.append("()");
        last = false;
        attached = false;
        }
        s.append("\n" + indtd + "|-" + "body=↧");
        for (size_t i=0; i<x.n_body; i++) {
            inc_lindent();
            last = i == x.n_body-1;
            attached = false;
            self().visit_stmt(*x.m_body[i]);
            dec_indent();
        }
        s.append("\n" + indtd + "|-" + "t_inside=");
        if (x.m_t_inside) {
            self().visit_trivia(*x.m_t_inside);
        } else {
            s.append("()");
        last = false;
        attached = false;
        }
        s.append("\n" + indtd + "└-" + "trivia=");
        last = true;
        if (x.m_trivia) {
            self().visit_trivia(*x.m_trivia);
        } else {
            s.append("()");
        last = false;
        attached = false;
        }
        dec_indent();
    }
    void visit_ForAll(const ForAll_t &x) {
        if(!attached) {
            if(start_line) {
                start_line = false;
                s.append(indtd);
            } else {
                s.append("\n"+indtd);
            }
            last ? s.append("└-") : s.append("|-");
        }
        last ? inc_indent() : inc_lindent();
        attached = true;
        last = false;
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("ForAll");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        s.append("\n" + indtd + "|-" + "label=");
        s.append(std::to_string(x.m_label));
        s.append("\n" + indtd + "|-" + "stmt_name=");
        if (x.m_stmt_name) {
            s.append(x.m_stmt_name);
        } else {
            s.append("()");
        }
        s.append("\n" + indtd + "|-" + "control=↧");
        for (size_t i=0; i<x.n_control; i++) {
            inc_lindent();
            last = i == x.n_control-1;
            attached = false;
            self().visit_concurrent_control(*x.m_control[i]);
            dec_indent();
        }
        s.append("\n" + indtd + "|-" + "mask=");
        if (x.m_mask) {
            self().visit_expr(*x.m_mask);
        } else {
            s.append("()");
        last = false;
        attached = false;
        }
        s.append("\n" + indtd + "|-" + "locality=↧");
        for (size_t i=0; i<x.n_locality; i++) {
            inc_lindent();
            last = i == x.n_locality-1;
            attached = false;
            self().visit_concurrent_locality(*x.m_locality[i]);
            dec_indent();
        }
        s.append("\n" + indtd + "|-" + "body=↧");
        for (size_t i=0; i<x.n_body; i++) {
            inc_lindent();
            last = i == x.n_body-1;
            attached = false;
            self().visit_stmt(*x.m_body[i]);
            dec_indent();
        }
        s.append("\n" + indtd + "|-" + "t_inside=");
        if (x.m_t_inside) {
            self().visit_trivia(*x.m_t_inside);
        } else {
            s.append("()");
        last = false;
        attached = false;
        }
        s.append("\n" + indtd + "└-" + "trivia=");
        last = true;
        if (x.m_trivia) {
            self().visit_trivia(*x.m_trivia);
        } else {
            s.append("()");
        last = false;
        attached = false;
        }
        dec_indent();
    }
    void visit_If(const If_t &x) {
        if(!attached) {
            if(start_line) {
                start_line = false;
                s.append(indtd);
            } else {
                s.append("\n"+indtd);
            }
            last ? s.append("└-") : s.append("|-");
        }
        last ? inc_indent() : inc_lindent();
        attached = true;
        last = false;
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("If");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        s.append("\n" + indtd + "|-" + "label=");
        s.append(std::to_string(x.m_label));
        s.append("\n" + indtd + "|-" + "stmt_name=");
        if (x.m_stmt_name) {
            s.append(x.m_stmt_name);
        } else {
            s.append("()");
        }
        s.append("\n" + indtd + "|-" + "test=");
        attached = true;
        self().visit_expr(*x.m_test);
        s.append("\n" + indtd + "|-" + "body=↧");
        for (size_t i=0; i<x.n_body; i++) {
            inc_lindent();
            last = i == x.n_body-1;
            attached = false;
            self().visit_stmt(*x.m_body[i]);
            dec_indent();
        }
        s.append("\n" + indtd + "|-" + "orelse=↧");
        for (size_t i=0; i<x.n_orelse; i++) {
            inc_lindent();
            last = i == x.n_orelse-1;
            attached = false;
            self().visit_stmt(*x.m_orelse[i]);
            dec_indent();
        }
        s.append("\n" + indtd + "|-" + "if_trivia=");
        if (x.m_if_trivia) {
            self().visit_trivia(*x.m_if_trivia);
        } else {
            s.append("()");
        last = false;
        attached = false;
        }
        s.append("\n" + indtd + "|-" + "else_trivia=");
        if (x.m_else_trivia) {
            self().visit_trivia(*x.m_else_trivia);
        } else {
            s.append("()");
        last = false;
        attached = false;
        }
        s.append("\n" + indtd + "└-" + "trivia=");
        last = true;
        if (x.m_trivia) {
            self().visit_trivia(*x.m_trivia);
        } else {
            s.append("()");
        last = false;
        attached = false;
        }
        dec_indent();
    }
    void visit_IfArithmetic(const IfArithmetic_t &x) {
        if(!attached) {
            if(start_line) {
                start_line = false;
                s.append(indtd);
            } else {
                s.append("\n"+indtd);
            }
            last ? s.append("└-") : s.append("|-");
        }
        last ? inc_indent() : inc_lindent();
        attached = true;
        last = false;
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("IfArithmetic");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        s.append("\n" + indtd + "|-" + "label=");
        s.append(std::to_string(x.m_label));
        s.append("\n" + indtd + "|-" + "stmt_name=");
        if (x.m_stmt_name) {
            s.append(x.m_stmt_name);
        } else {
            s.append("()");
        }
        s.append("\n" + indtd + "|-" + "test=");
        attached = true;
        self().visit_expr(*x.m_test);
        s.append("\n" + indtd + "|-" + "lt_label=");
        s.append(std::to_string(x.m_lt_label));
        s.append("\n" + indtd + "|-" + "eq_label=");
        s.append(std::to_string(x.m_eq_label));
        s.append("\n" + indtd + "|-" + "gt_label=");
        s.append(std::to_string(x.m_gt_label));
        s.append("\n" + indtd + "└-" + "trivia=");
        last = true;
        if (x.m_trivia) {
            self().visit_trivia(*x.m_trivia);
        } else {
            s.append("()");
        last = false;
        attached = false;
        }
        dec_indent();
    }
    void visit_Select(const Select_t &x) {
        if(!attached) {
            if(start_line) {
                start_line = false;
                s.append(indtd);
            } else {
                s.append("\n"+indtd);
            }
            last ? s.append("└-") : s.append("|-");
        }
        last ? inc_indent() : inc_lindent();
        attached = true;
        last = false;
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("Select");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        s.append("\n" + indtd + "|-" + "label=");
        s.append(std::to_string(x.m_label));
        s.append("\n" + indtd + "|-" + "stmt_name=");
        if (x.m_stmt_name) {
            s.append(x.m_stmt_name);
        } else {
            s.append("()");
        }
        s.append("\n" + indtd + "|-" + "test=");
        attached = true;
        self().visit_expr(*x.m_test);
        s.append("\n" + indtd + "|-" + "body=↧");
        for (size_t i=0; i<x.n_body; i++) {
            inc_lindent();
            last = i == x.n_body-1;
            attached = false;
            self().visit_case_stmt(*x.m_body[i]);
            dec_indent();
        }
        s.append("\n" + indtd + "|-" + "t_inside=");
        if (x.m_t_inside) {
            self().visit_trivia(*x.m_t_inside);
        } else {
            s.append("()");
        last = false;
        attached = false;
        }
        s.append("\n" + indtd + "└-" + "trivia=");
        last = true;
        if (x.m_trivia) {
            self().visit_trivia(*x.m_trivia);
        } else {
            s.append("()");
        last = false;
        attached = false;
        }
        dec_indent();
    }
    void visit_SelectRank(const SelectRank_t &x) {
        if(!attached) {
            if(start_line) {
                start_line = false;
                s.append(indtd);
            } else {
                s.append("\n"+indtd);
            }
            last ? s.append("└-") : s.append("|-");
        }
        last ? inc_indent() : inc_lindent();
        attached = true;
        last = false;
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("SelectRank");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        s.append("\n" + indtd + "|-" + "label=");
        s.append(std::to_string(x.m_label));
        s.append("\n" + indtd + "|-" + "stmt_name=");
        if (x.m_stmt_name) {
            s.append(x.m_stmt_name);
        } else {
            s.append("()");
        }
        s.append("\n" + indtd + "|-" + "assoc_name=");
        if (x.m_assoc_name) {
            s.append(x.m_assoc_name);
        } else {
            s.append("()");
        }
        s.append("\n" + indtd + "|-" + "selector=");
        attached = true;
        self().visit_expr(*x.m_selector);
        s.append("\n" + indtd + "|-" + "body=↧");
        for (size_t i=0; i<x.n_body; i++) {
            inc_lindent();
            last = i == x.n_body-1;
            attached = false;
            self().visit_rank_stmt(*x.m_body[i]);
            dec_indent();
        }
        s.append("\n" + indtd + "|-" + "t_inside=");
        if (x.m_t_inside) {
            self().visit_trivia(*x.m_t_inside);
        } else {
            s.append("()");
        last = false;
        attached = false;
        }
        s.append("\n" + indtd + "└-" + "trivia=");
        last = true;
        if (x.m_trivia) {
            self().visit_trivia(*x.m_trivia);
        } else {
            s.append("()");
        last = false;
        attached = false;
        }
        dec_indent();
    }
    void visit_SelectType(const SelectType_t &x) {
        if(!attached) {
            if(start_line) {
                start_line = false;
                s.append(indtd);
            } else {
                s.append("\n"+indtd);
            }
            last ? s.append("└-") : s.append("|-");
        }
        last ? inc_indent() : inc_lindent();
        attached = true;
        last = false;
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("SelectType");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        s.append("\n" + indtd + "|-" + "label=");
        s.append(std::to_string(x.m_label));
        s.append("\n" + indtd + "|-" + "stmt_name=");
        if (x.m_stmt_name) {
            s.append(x.m_stmt_name);
        } else {
            s.append("()");
        }
        s.append("\n" + indtd + "|-" + "assoc_name=");
        if (x.m_assoc_name) {
            s.append(x.m_assoc_name);
        } else {
            s.append("()");
        }
        s.append("\n" + indtd + "|-" + "selector=");
        attached = true;
        self().visit_expr(*x.m_selector);
        s.append("\n" + indtd + "|-" + "body=↧");
        for (size_t i=0; i<x.n_body; i++) {
            inc_lindent();
            last = i == x.n_body-1;
            attached = false;
            self().visit_type_stmt(*x.m_body[i]);
            dec_indent();
        }
        s.append("\n" + indtd + "|-" + "t_inside=");
        if (x.m_t_inside) {
            self().visit_trivia(*x.m_t_inside);
        } else {
            s.append("()");
        last = false;
        attached = false;
        }
        s.append("\n" + indtd + "└-" + "trivia=");
        last = true;
        if (x.m_trivia) {
            self().visit_trivia(*x.m_trivia);
        } else {
            s.append("()");
        last = false;
        attached = false;
        }
        dec_indent();
    }
    void visit_Where(const Where_t &x) {
        if(!attached) {
            if(start_line) {
                start_line = false;
                s.append(indtd);
            } else {
                s.append("\n"+indtd);
            }
            last ? s.append("└-") : s.append("|-");
        }
        last ? inc_indent() : inc_lindent();
        attached = true;
        last = false;
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("Where");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        s.append("\n" + indtd + "|-" + "label=");
        s.append(std::to_string(x.m_label));
        s.append("\n" + indtd + "|-" + "stmt_name=");
        if (x.m_stmt_name) {
            s.append(x.m_stmt_name);
        } else {
            s.append("()");
        }
        s.append("\n" + indtd + "|-" + "test=");
        attached = true;
        self().visit_expr(*x.m_test);
        s.append("\n" + indtd + "|-" + "body=↧");
        for (size_t i=0; i<x.n_body; i++) {
            inc_lindent();
            last = i == x.n_body-1;
            attached = false;
            self().visit_stmt(*x.m_body[i]);
            dec_indent();
        }
        s.append("\n" + indtd + "|-" + "orelse=↧");
        for (size_t i=0; i<x.n_orelse; i++) {
            inc_lindent();
            last = i == x.n_orelse-1;
            attached = false;
            self().visit_stmt(*x.m_orelse[i]);
            dec_indent();
        }
        s.append("\n" + indtd + "|-" + "t_inside=");
        if (x.m_t_inside) {
            self().visit_trivia(*x.m_t_inside);
        } else {
            s.append("()");
        last = false;
        attached = false;
        }
        s.append("\n" + indtd + "└-" + "trivia=");
        last = true;
        if (x.m_trivia) {
            self().visit_trivia(*x.m_trivia);
        } else {
            s.append("()");
        last = false;
        attached = false;
        }
        dec_indent();
    }
    void visit_WhileLoop(const WhileLoop_t &x) {
        if(!attached) {
            if(start_line) {
                start_line = false;
                s.append(indtd);
            } else {
                s.append("\n"+indtd);
            }
            last ? s.append("└-") : s.append("|-");
        }
        last ? inc_indent() : inc_lindent();
        attached = true;
        last = false;
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("WhileLoop");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        s.append("\n" + indtd + "|-" + "label=");
        s.append(std::to_string(x.m_label));
        s.append("\n" + indtd + "|-" + "stmt_name=");
        if (x.m_stmt_name) {
            s.append(x.m_stmt_name);
        } else {
            s.append("()");
        }
        s.append("\n" + indtd + "|-" + "test=");
        attached = true;
        self().visit_expr(*x.m_test);
        s.append("\n" + indtd + "|-" + "body=↧");
        for (size_t i=0; i<x.n_body; i++) {
            inc_lindent();
            last = i == x.n_body-1;
            attached = false;
            self().visit_stmt(*x.m_body[i]);
            dec_indent();
        }
        s.append("\n" + indtd + "|-" + "t_inside=");
        if (x.m_t_inside) {
            self().visit_trivia(*x.m_t_inside);
        } else {
            s.append("()");
        last = false;
        attached = false;
        }
        s.append("\n" + indtd + "└-" + "trivia=");
        last = true;
        if (x.m_trivia) {
            self().visit_trivia(*x.m_trivia);
        } else {
            s.append("()");
        last = false;
        attached = false;
        }
        dec_indent();
    }
    void visit_BoolOp(const BoolOp_t &x) {
        if(!attached) {
            if(start_line) {
                start_line = false;
                s.append(indtd);
            } else {
                s.append("\n"+indtd);
            }
            last ? s.append("└-") : s.append("|-");
        }
        last ? inc_indent() : inc_lindent();
        attached = true;
        last = false;
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("BoolOp");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        s.append("\n" + indtd + "|-" + "left=");
        attached = true;
        self().visit_expr(*x.m_left);
        s.append("\n" + indtd + "|-" + "boolopType=");
        visit_boolopType(x.m_op);
        s.append("\n" + indtd + "└-" + "right=");
        last = true;
        attached = true;
        self().visit_expr(*x.m_right);
        dec_indent();
    }
    void visit_BinOp(const BinOp_t &x) {
        if(!attached) {
            if(start_line) {
                start_line = false;
                s.append(indtd);
            } else {
                s.append("\n"+indtd);
            }
            last ? s.append("└-") : s.append("|-");
        }
        last ? inc_indent() : inc_lindent();
        attached = true;
        last = false;
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("BinOp");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        s.append("\n" + indtd + "|-" + "left=");
        attached = true;
        self().visit_expr(*x.m_left);
        s.append("\n" + indtd + "|-" + "operatorType=");
        visit_operatorType(x.m_op);
        s.append("\n" + indtd + "└-" + "right=");
        last = true;
        attached = true;
        self().visit_expr(*x.m_right);
        dec_indent();
    }
    void visit_DefBinOp(const DefBinOp_t &x) {
        if(!attached) {
            if(start_line) {
                start_line = false;
                s.append(indtd);
            } else {
                s.append("\n"+indtd);
            }
            last ? s.append("└-") : s.append("|-");
        }
        last ? inc_indent() : inc_lindent();
        attached = true;
        last = false;
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("DefBinOp");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        s.append("\n" + indtd + "|-" + "left=");
        attached = true;
        self().visit_expr(*x.m_left);
        s.append("\n" + indtd + "|-" + "op=");
        s.append("\"" + std::string(x.m_op) + "\"");
        s.append("\n" + indtd + "└-" + "right=");
        last = true;
        attached = true;
        self().visit_expr(*x.m_right);
        dec_indent();
    }
    void visit_StrOp(const StrOp_t &x) {
        if(!attached) {
            if(start_line) {
                start_line = false;
                s.append(indtd);
            } else {
                s.append("\n"+indtd);
            }
            last ? s.append("└-") : s.append("|-");
        }
        last ? inc_indent() : inc_lindent();
        attached = true;
        last = false;
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("StrOp");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        s.append("\n" + indtd + "|-" + "left=");
        attached = true;
        self().visit_expr(*x.m_left);
        s.append("\n" + indtd + "|-" + "stroperatorType=");
        visit_stroperatorType(x.m_op);
        s.append("\n" + indtd + "└-" + "right=");
        last = true;
        attached = true;
        self().visit_expr(*x.m_right);
        dec_indent();
    }
    void visit_UnaryOp(const UnaryOp_t &x) {
        if(!attached) {
            if(start_line) {
                start_line = false;
                s.append(indtd);
            } else {
                s.append("\n"+indtd);
            }
            last ? s.append("└-") : s.append("|-");
        }
        last ? inc_indent() : inc_lindent();
        attached = true;
        last = false;
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("UnaryOp");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        s.append("\n" + indtd + "|-" + "unaryopType=");
        visit_unaryopType(x.m_op);
        s.append("\n" + indtd + "└-" + "operand=");
        last = true;
        attached = true;
        self().visit_expr(*x.m_operand);
        dec_indent();
    }
    void visit_DefUnaryOp(const DefUnaryOp_t &x) {
        if(!attached) {
            if(start_line) {
                start_line = false;
                s.append(indtd);
            } else {
                s.append("\n"+indtd);
            }
            last ? s.append("└-") : s.append("|-");
        }
        last ? inc_indent() : inc_lindent();
        attached = true;
        last = false;
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("DefUnaryOp");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        s.append("\n" + indtd + "|-" + "op=");
        s.append("\"" + std::string(x.m_op) + "\"");
        s.append("\n" + indtd + "└-" + "operand=");
        last = true;
        attached = true;
        self().visit_expr(*x.m_operand);
        dec_indent();
    }
    void visit_Compare(const Compare_t &x) {
        if(!attached) {
            if(start_line) {
                start_line = false;
                s.append(indtd);
            } else {
                s.append("\n"+indtd);
            }
            last ? s.append("└-") : s.append("|-");
        }
        last ? inc_indent() : inc_lindent();
        attached = true;
        last = false;
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("Compare");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        s.append("\n" + indtd + "|-" + "left=");
        attached = true;
        self().visit_expr(*x.m_left);
        s.append("\n" + indtd + "|-" + "cmpopType=");
        visit_cmpopType(x.m_op);
        s.append("\n" + indtd + "└-" + "right=");
        last = true;
        attached = true;
        self().visit_expr(*x.m_right);
        dec_indent();
    }
    void visit_FuncCallOrArray(const FuncCallOrArray_t &x) {
        if(!attached) {
            if(start_line) {
                start_line = false;
                s.append(indtd);
            } else {
                s.append("\n"+indtd);
            }
            last ? s.append("└-") : s.append("|-");
        }
        last ? inc_indent() : inc_lindent();
        attached = true;
        last = false;
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("FuncCallOrArray");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        s.append("\n" + indtd + "|-" + "func=");
        s.append(x.m_func);
        s.append("\n" + indtd + "|-" + "member=↧");
        for (size_t i=0; i<x.n_member; i++) {
            inc_lindent();
            last = i == x.n_member-1;
            attached = false;
            self().visit_struct_member(x.m_member[i]);
            dec_indent();
        }
        s.append("\n" + indtd + "|-" + "args=↧");
        for (size_t i=0; i<x.n_args; i++) {
            inc_lindent();
            last = i == x.n_args-1;
            attached = false;
            self().visit_fnarg(x.m_args[i]);
            dec_indent();
        }
        s.append("\n" + indtd + "|-" + "keywords=↧");
        for (size_t i=0; i<x.n_keywords; i++) {
            inc_lindent();
            last = i == x.n_keywords-1;
            attached = false;
            self().visit_keyword(x.m_keywords[i]);
            dec_indent();
        }
        s.append("\n" + indtd + "|-" + "subargs=↧");
        for (size_t i=0; i<x.n_subargs; i++) {
            inc_lindent();
            last = i == x.n_subargs-1;
            attached = false;
            self().visit_fnarg(x.m_subargs[i]);
            dec_indent();
        }
        s.append("\n" + indtd + "└-" + "temp_args=↧");
        for (size_t i=0; i<x.n_temp_args; i++) {
            inc_indent();
            last = i == x.n_temp_args-1;
            attached = false;
            self().visit_decl_attribute(*x.m_temp_args[i]);
            dec_indent();
        }
        dec_indent();
    }
    void visit_CoarrayRef(const CoarrayRef_t &x) {
        if(!attached) {
            if(start_line) {
                start_line = false;
                s.append(indtd);
            } else {
                s.append("\n"+indtd);
            }
            last ? s.append("└-") : s.append("|-");
        }
        last ? inc_indent() : inc_lindent();
        attached = true;
        last = false;
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("CoarrayRef");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        s.append("\n" + indtd + "|-" + "name=");
        s.append(x.m_name);
        s.append("\n" + indtd + "|-" + "member=↧");
        for (size_t i=0; i<x.n_member; i++) {
            inc_lindent();
            last = i == x.n_member-1;
            attached = false;
            self().visit_struct_member(x.m_member[i]);
            dec_indent();
        }
        s.append("\n" + indtd + "|-" + "args=↧");
        for (size_t i=0; i<x.n_args; i++) {
            inc_lindent();
            last = i == x.n_args-1;
            attached = false;
            self().visit_fnarg(x.m_args[i]);
            dec_indent();
        }
        s.append("\n" + indtd + "|-" + "fnkw=↧");
        for (size_t i=0; i<x.n_fnkw; i++) {
            inc_lindent();
            last = i == x.n_fnkw-1;
            attached = false;
            self().visit_keyword(x.m_fnkw[i]);
            dec_indent();
        }
        s.append("\n" + indtd + "|-" + "coargs=↧");
        for (size_t i=0; i<x.n_coargs; i++) {
            inc_lindent();
            last = i == x.n_coargs-1;
            attached = false;
            self().visit_coarrayarg(x.m_coargs[i]);
            dec_indent();
        }
        s.append("\n" + indtd + "└-" + "cokw=↧");
        for (size_t i=0; i<x.n_cokw; i++) {
            inc_indent();
            last = i == x.n_cokw-1;
            attached = false;
            self().visit_keyword(x.m_cokw[i]);
            dec_indent();
        }
        dec_indent();
    }
    void visit_ArrayInitializer(const ArrayInitializer_t &x) {
        if(!attached) {
            if(start_line) {
                start_line = false;
                s.append(indtd);
            } else {
                s.append("\n"+indtd);
            }
            last ? s.append("└-") : s.append("|-");
        }
        last ? inc_indent() : inc_lindent();
        attached = true;
        last = false;
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("ArrayInitializer");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        s.append("\n" + indtd + "|-" + "vartype=");
        if (x.m_vartype) {
            self().visit_decl_attribute(*x.m_vartype);
        } else {
            s.append("()");
        last = false;
        attached = false;
        }
        s.append("\n" + indtd + "|-" + "classtype=");
        if (x.m_classtype) {
            s.append(x.m_classtype);
        } else {
            s.append("()");
        }
        s.append("\n" + indtd + "└-" + "args=↧");
        for (size_t i=0; i<x.n_args; i++) {
            inc_indent();
            last = i == x.n_args-1;
            attached = false;
            self().visit_expr(*x.m_args[i]);
            dec_indent();
        }
        dec_indent();
    }
    void visit_ImpliedDoLoop(const ImpliedDoLoop_t &x) {
        if(!attached) {
            if(start_line) {
                start_line = false;
                s.append(indtd);
            } else {
                s.append("\n"+indtd);
            }
            last ? s.append("└-") : s.append("|-");
        }
        last ? inc_indent() : inc_lindent();
        attached = true;
        last = false;
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("ImpliedDoLoop");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        s.append("\n" + indtd + "|-" + "values=↧");
        for (size_t i=0; i<x.n_values; i++) {
            inc_lindent();
            last = i == x.n_values-1;
            attached = false;
            self().visit_expr(*x.m_values[i]);
            dec_indent();
        }
        s.append("\n" + indtd + "|-" + "var=");
        s.append(x.m_var);
        s.append("\n" + indtd + "|-" + "start=");
        attached = true;
        self().visit_expr(*x.m_start);
        s.append("\n" + indtd + "|-" + "end=");
        attached = true;
        self().visit_expr(*x.m_end);
        s.append("\n" + indtd + "└-" + "increment=");
        last = true;
        if (x.m_increment) {
            self().visit_expr(*x.m_increment);
        } else {
            s.append("()");
        last = false;
        attached = false;
        }
        dec_indent();
    }
    void visit_Num(const Num_t &x) {
        if(!attached) {
            if(start_line) {
                start_line = false;
                s.append(indtd);
            } else {
                s.append("\n"+indtd);
            }
            last ? s.append("└-") : s.append("|-");
        }
        last ? inc_indent() : inc_lindent();
        attached = true;
        last = false;
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("Num");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        s.append("\n" + indtd + "|-" + "n=");
        s.append(std::to_string(x.m_n));
        s.append("\n" + indtd + "└-" + "kind=");
        if (x.m_kind) {
            s.append("\"" + std::string(x.m_kind) + "\"");
        } else {
            s.append("()");
        }
        dec_indent();
        if ((bool&)x) { } // Suppress unused warning
    }
    void visit_Real(const Real_t &x) {
        if(!attached) {
            if(start_line) {
                start_line = false;
                s.append(indtd);
            } else {
                s.append("\n"+indtd);
            }
            last ? s.append("└-") : s.append("|-");
        }
        last ? inc_indent() : inc_lindent();
        attached = true;
        last = false;
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("Real");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        s.append("\n" + indtd + "└-" + "n=");
        s.append("\"" + std::string(x.m_n) + "\"");
        dec_indent();
        if ((bool&)x) { } // Suppress unused warning
    }
    void visit_Complex(const Complex_t &x) {
        if(!attached) {
            if(start_line) {
                start_line = false;
                s.append(indtd);
            } else {
                s.append("\n"+indtd);
            }
            last ? s.append("└-") : s.append("|-");
        }
        last ? inc_indent() : inc_lindent();
        attached = true;
        last = false;
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("Complex");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        s.append("\n" + indtd + "|-" + "re=");
        attached = true;
        self().visit_expr(*x.m_re);
        s.append("\n" + indtd + "└-" + "im=");
        last = true;
        attached = true;
        self().visit_expr(*x.m_im);
        dec_indent();
    }
    void visit_String(const String_t &x) {
        if(!attached) {
            if(start_line) {
                start_line = false;
                s.append(indtd);
            } else {
                s.append("\n"+indtd);
            }
            last ? s.append("└-") : s.append("|-");
        }
        last ? inc_indent() : inc_lindent();
        attached = true;
        last = false;
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("String");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        s.append("\n" + indtd + "└-" + "s=");
        s.append("\"" + std::string(x.m_s) + "\"");
        dec_indent();
        if ((bool&)x) { } // Suppress unused warning
    }
    void visit_Substring(const Substring_t &x) {
        if(!attached) {
            if(start_line) {
                start_line = false;
                s.append(indtd);
            } else {
                s.append("\n"+indtd);
            }
            last ? s.append("└-") : s.append("|-");
        }
        last ? inc_indent() : inc_lindent();
        attached = true;
        last = false;
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("Substring");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        s.append("\n" + indtd + "|-" + "s=");
        s.append("\"" + std::string(x.m_s) + "\"");
        s.append("\n" + indtd + "└-" + "args=↧");
        for (size_t i=0; i<x.n_args; i++) {
            inc_indent();
            last = i == x.n_args-1;
            attached = false;
            self().visit_fnarg(x.m_args[i]);
            dec_indent();
        }
        dec_indent();
    }
    void visit_BOZ(const BOZ_t &x) {
        if(!attached) {
            if(start_line) {
                start_line = false;
                s.append(indtd);
            } else {
                s.append("\n"+indtd);
            }
            last ? s.append("└-") : s.append("|-");
        }
        last ? inc_indent() : inc_lindent();
        attached = true;
        last = false;
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("BOZ");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        s.append("\n" + indtd + "└-" + "s=");
        s.append("\"" + std::string(x.m_s) + "\"");
        dec_indent();
        if ((bool&)x) { } // Suppress unused warning
    }
    void visit_Name(const Name_t &x) {
        if(!attached) {
            if(start_line) {
                start_line = false;
                s.append(indtd);
            } else {
                s.append("\n"+indtd);
            }
            last ? s.append("└-") : s.append("|-");
        }
        last ? inc_indent() : inc_lindent();
        attached = true;
        last = false;
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("Name");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        s.append("\n" + indtd + "|-" + "id=");
        s.append(x.m_id);
        s.append("\n" + indtd + "└-" + "member=↧");
        for (size_t i=0; i<x.n_member; i++) {
            inc_indent();
            last = i == x.n_member-1;
            attached = false;
            self().visit_struct_member(x.m_member[i]);
            dec_indent();
        }
        dec_indent();
    }
    void visit_Logical(const Logical_t &x) {
        if(!attached) {
            if(start_line) {
                start_line = false;
                s.append(indtd);
            } else {
                s.append("\n"+indtd);
            }
            last ? s.append("└-") : s.append("|-");
        }
        last ? inc_indent() : inc_lindent();
        attached = true;
        last = false;
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("Logical");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        s.append("\n" + indtd + "└-" + "value=");
        if (x.m_value) {
            s.append(".true.");
        } else {
            s.append(".false.");
        }
        dec_indent();
        if ((bool&)x) { } // Suppress unused warning
    }
    void visit_DataImpliedDo(const DataImpliedDo_t &x) {
        if(!attached) {
            if(start_line) {
                start_line = false;
                s.append(indtd);
            } else {
                s.append("\n"+indtd);
            }
            last ? s.append("└-") : s.append("|-");
        }
        last ? inc_indent() : inc_lindent();
        attached = true;
        last = false;
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("DataImpliedDo");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        s.append("\n" + indtd + "|-" + "object_list=↧");
        for (size_t i=0; i<x.n_object_list; i++) {
            inc_lindent();
            last = i == x.n_object_list-1;
            attached = false;
            self().visit_expr(*x.m_object_list[i]);
            dec_indent();
        }
        s.append("\n" + indtd + "|-" + "type=");
        if (x.m_type) {
            self().visit_decl_attribute(*x.m_type);
        } else {
            s.append("()");
        last = false;
        attached = false;
        }
        s.append("\n" + indtd + "|-" + "var=");
        s.append(x.m_var);
        s.append("\n" + indtd + "|-" + "start=");
        attached = true;
        self().visit_expr(*x.m_start);
        s.append("\n" + indtd + "|-" + "end=");
        attached = true;
        self().visit_expr(*x.m_end);
        s.append("\n" + indtd + "└-" + "increment=");
        last = true;
        if (x.m_increment) {
            self().visit_expr(*x.m_increment);
        } else {
            s.append("()");
        last = false;
        attached = false;
        }
        dec_indent();
    }
    void visit_Parenthesis(const Parenthesis_t &x) {
        if(!attached) {
            if(start_line) {
                start_line = false;
                s.append(indtd);
            } else {
                s.append("\n"+indtd);
            }
            last ? s.append("└-") : s.append("|-");
        }
        last ? inc_indent() : inc_lindent();
        attached = true;
        last = false;
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("Parenthesis");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        s.append("\n" + indtd + "└-" + "operand=");
        last = true;
        attached = true;
        self().visit_expr(*x.m_operand);
        dec_indent();
    }
    void visit_TriviaNode(const TriviaNode_t &x) {
        if(!attached) {
            if(start_line) {
                start_line = false;
                s.append(indtd);
            } else {
                s.append("\n"+indtd);
            }
            last ? s.append("└-") : s.append("|-");
        }
        last ? inc_indent() : inc_lindent();
        attached = true;
        last = false;
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("TriviaNode");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        s.append("\n" + indtd + "|-" + "inside=↧");
        for (size_t i=0; i<x.n_inside; i++) {
            inc_lindent();
            last = i == x.n_inside-1;
            attached = false;
            self().visit_trivia_node(*x.m_inside[i]);
            dec_indent();
        }
        s.append("\n" + indtd + "└-" + "after=↧");
        for (size_t i=0; i<x.n_after; i++) {
            inc_indent();
            last = i == x.n_after-1;
            attached = false;
            self().visit_trivia_node(*x.m_after[i]);
            dec_indent();
        }
        dec_indent();
    }
    void visit_Comment(const Comment_t &x) {
        if(!attached) {
            if(start_line) {
                start_line = false;
                s.append(indtd);
            } else {
                s.append("\n"+indtd);
            }
            last ? s.append("└-") : s.append("|-");
        }
        last ? inc_indent() : inc_lindent();
        attached = true;
        last = false;
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("Comment");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        s.append("\n" + indtd + "└-" + "comment=");
        s.append("\"" + std::string(x.m_comment) + "\"");
        dec_indent();
        if ((bool&)x) { } // Suppress unused warning
    }
    void visit_EOLComment(const EOLComment_t &x) {
        if(!attached) {
            if(start_line) {
                start_line = false;
                s.append(indtd);
            } else {
                s.append("\n"+indtd);
            }
            last ? s.append("└-") : s.append("|-");
        }
        last ? inc_indent() : inc_lindent();
        attached = true;
        last = false;
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("EOLComment");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        s.append("\n" + indtd + "└-" + "comment=");
        s.append("\"" + std::string(x.m_comment) + "\"");
        dec_indent();
        if ((bool&)x) { } // Suppress unused warning
    }
    void visit_EndOfLine(const EndOfLine_t &x) {
        if(!attached) {
            if(start_line) {
                start_line = false;
                s.append(indtd);
            } else {
                s.append("\n"+indtd);
            }
            last ? s.append("└-") : s.append("|-");
        }
        last ? inc_indent() : inc_lindent();
        attached = true;
        last = false;
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("EndOfLine");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        dec_indent();
        if ((bool&)x) { } // Suppress unused warning
    }
    void visit_Semicolon(const Semicolon_t &x) {
        if(!attached) {
            if(start_line) {
                start_line = false;
                s.append(indtd);
            } else {
                s.append("\n"+indtd);
            }
            last ? s.append("└-") : s.append("|-");
        }
        last ? inc_indent() : inc_lindent();
        attached = true;
        last = false;
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("Semicolon");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        dec_indent();
        if ((bool&)x) { } // Suppress unused warning
    }
    void visit_boolopType(const boolopType &x) {
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::green));
        }
        switch (x) {
            case (boolopType::And) : {
                s.append("And");
             break; }
            case (boolopType::Or) : {
                s.append("Or");
             break; }
            case (boolopType::Xor) : {
                s.append("Xor");
             break; }
            case (boolopType::Eqv) : {
                s.append("Eqv");
             break; }
            case (boolopType::NEqv) : {
                s.append("NEqv");
             break; }
        }
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
    }
    void visit_operatorType(const operatorType &x) {
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::green));
        }
        switch (x) {
            case (operatorType::Add) : {
                s.append("Add");
             break; }
            case (operatorType::Sub) : {
                s.append("Sub");
             break; }
            case (operatorType::Mul) : {
                s.append("Mul");
             break; }
            case (operatorType::Div) : {
                s.append("Div");
             break; }
            case (operatorType::Pow) : {
                s.append("Pow");
             break; }
        }
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
    }
    void visit_stroperatorType(const stroperatorType &x) {
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::green));
        }
        switch (x) {
            case (stroperatorType::Concat) : {
                s.append("Concat");
             break; }
        }
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
    }
    void visit_unaryopType(const unaryopType &x) {
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::green));
        }
        switch (x) {
            case (unaryopType::Invert) : {
                s.append("Invert");
             break; }
            case (unaryopType::Not) : {
                s.append("Not");
             break; }
            case (unaryopType::UAdd) : {
                s.append("UAdd");
             break; }
            case (unaryopType::USub) : {
                s.append("USub");
             break; }
        }
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
    }
    void visit_cmpopType(const cmpopType &x) {
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::green));
        }
        switch (x) {
            case (cmpopType::Eq) : {
                s.append("Eq");
             break; }
            case (cmpopType::NotEq) : {
                s.append("NotEq");
             break; }
            case (cmpopType::Lt) : {
                s.append("Lt");
             break; }
            case (cmpopType::LtE) : {
                s.append("LtE");
             break; }
            case (cmpopType::Gt) : {
                s.append("Gt");
             break; }
            case (cmpopType::GtE) : {
                s.append("GtE");
             break; }
        }
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
    }
    void visit_intrinsicopType(const intrinsicopType &x) {
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::green));
        }
        switch (x) {
            case (intrinsicopType::AND) : {
                s.append("AND");
             break; }
            case (intrinsicopType::OR) : {
                s.append("OR");
             break; }
            case (intrinsicopType::XOR) : {
                s.append("XOR");
             break; }
            case (intrinsicopType::EQV) : {
                s.append("EQV");
             break; }
            case (intrinsicopType::NEQV) : {
                s.append("NEQV");
             break; }
            case (intrinsicopType::PLUS) : {
                s.append("PLUS");
             break; }
            case (intrinsicopType::MINUS) : {
                s.append("MINUS");
             break; }
            case (intrinsicopType::STAR) : {
                s.append("STAR");
             break; }
            case (intrinsicopType::DIV) : {
                s.append("DIV");
             break; }
            case (intrinsicopType::POW) : {
                s.append("POW");
             break; }
            case (intrinsicopType::NOT) : {
                s.append("NOT");
             break; }
            case (intrinsicopType::EQ) : {
                s.append("EQ");
             break; }
            case (intrinsicopType::NOTEQ) : {
                s.append("NOTEQ");
             break; }
            case (intrinsicopType::LT) : {
                s.append("LT");
             break; }
            case (intrinsicopType::LTE) : {
                s.append("LTE");
             break; }
            case (intrinsicopType::GT) : {
                s.append("GT");
             break; }
            case (intrinsicopType::GTE) : {
                s.append("GTE");
             break; }
            case (intrinsicopType::CONCAT) : {
                s.append("CONCAT");
             break; }
        }
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
    }
    void visit_DerivedTypeProc(const DerivedTypeProc_t &x) {
        if(!attached) {
            if(start_line) {
                start_line = false;
                s.append(indtd);
            } else {
                s.append("\n"+indtd);
            }
            last ? s.append("└-") : s.append("|-");
        }
        last ? inc_indent() : inc_lindent();
        attached = true;
        last = false;
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("DerivedTypeProc");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        s.append("\n" + indtd + "|-" + "name=");
        if (x.m_name) {
            s.append(x.m_name);
        } else {
            s.append("()");
        }
        s.append("\n" + indtd + "|-" + "attr=↧");
        for (size_t i=0; i<x.n_attr; i++) {
            inc_lindent();
            last = i == x.n_attr-1;
            attached = false;
            self().visit_decl_attribute(*x.m_attr[i]);
            dec_indent();
        }
        s.append("\n" + indtd + "|-" + "symbols=↧");
        for (size_t i=0; i<x.n_symbols; i++) {
            inc_lindent();
            last = i == x.n_symbols-1;
            attached = false;
            self().visit_use_symbol(*x.m_symbols[i]);
            dec_indent();
        }
        s.append("\n" + indtd + "└-" + "trivia=");
        last = true;
        if (x.m_trivia) {
            self().visit_trivia(*x.m_trivia);
        } else {
            s.append("()");
        last = false;
        attached = false;
        }
        dec_indent();
    }
    void visit_GenericOperator(const GenericOperator_t &x) {
        if(!attached) {
            if(start_line) {
                start_line = false;
                s.append(indtd);
            } else {
                s.append("\n"+indtd);
            }
            last ? s.append("└-") : s.append("|-");
        }
        last ? inc_indent() : inc_lindent();
        attached = true;
        last = false;
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("GenericOperator");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        s.append("\n" + indtd + "|-" + "attr=↧");
        for (size_t i=0; i<x.n_attr; i++) {
            inc_lindent();
            last = i == x.n_attr-1;
            attached = false;
            self().visit_decl_attribute(*x.m_attr[i]);
            dec_indent();
        }
        s.append("\n" + indtd + "|-" + "intrinsicopType=");
        visit_intrinsicopType(x.m_op);
        s.append("\n" + indtd + "|-" + "names=");
        for (size_t i=0; i<x.n_names; i++) {
            s.append(x.m_names[i]);
            if (i < x.n_names-1) s.append(" ");
        }
        s.append("\n" + indtd + "└-" + "trivia=");
        last = true;
        if (x.m_trivia) {
            self().visit_trivia(*x.m_trivia);
        } else {
            s.append("()");
        last = false;
        attached = false;
        }
        dec_indent();
    }
    void visit_GenericDefinedOperator(const GenericDefinedOperator_t &x) {
        if(!attached) {
            if(start_line) {
                start_line = false;
                s.append(indtd);
            } else {
                s.append("\n"+indtd);
            }
            last ? s.append("└-") : s.append("|-");
        }
        last ? inc_indent() : inc_lindent();
        attached = true;
        last = false;
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("GenericDefinedOperator");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        s.append("\n" + indtd + "|-" + "attr=↧");
        for (size_t i=0; i<x.n_attr; i++) {
            inc_lindent();
            last = i == x.n_attr-1;
            attached = false;
            self().visit_decl_attribute(*x.m_attr[i]);
            dec_indent();
        }
        s.append("\n" + indtd + "|-" + "optype=");
        s.append("\"" + std::string(x.m_optype) + "\"");
        s.append("\n" + indtd + "|-" + "names=");
        for (size_t i=0; i<x.n_names; i++) {
            s.append(x.m_names[i]);
            if (i < x.n_names-1) s.append(" ");
        }
        s.append("\n" + indtd + "└-" + "trivia=");
        last = true;
        if (x.m_trivia) {
            self().visit_trivia(*x.m_trivia);
        } else {
            s.append("()");
        last = false;
        attached = false;
        }
        dec_indent();
    }
    void visit_GenericAssignment(const GenericAssignment_t &x) {
        if(!attached) {
            if(start_line) {
                start_line = false;
                s.append(indtd);
            } else {
                s.append("\n"+indtd);
            }
            last ? s.append("└-") : s.append("|-");
        }
        last ? inc_indent() : inc_lindent();
        attached = true;
        last = false;
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("GenericAssignment");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        s.append("\n" + indtd + "|-" + "attr=↧");
        for (size_t i=0; i<x.n_attr; i++) {
            inc_lindent();
            last = i == x.n_attr-1;
            attached = false;
            self().visit_decl_attribute(*x.m_attr[i]);
            dec_indent();
        }
        s.append("\n" + indtd + "|-" + "names=");
        for (size_t i=0; i<x.n_names; i++) {
            s.append(x.m_names[i]);
            if (i < x.n_names-1) s.append(" ");
        }
        s.append("\n" + indtd + "└-" + "trivia=");
        last = true;
        if (x.m_trivia) {
            self().visit_trivia(*x.m_trivia);
        } else {
            s.append("()");
        last = false;
        attached = false;
        }
        dec_indent();
    }
    void visit_GenericName(const GenericName_t &x) {
        if(!attached) {
            if(start_line) {
                start_line = false;
                s.append(indtd);
            } else {
                s.append("\n"+indtd);
            }
            last ? s.append("└-") : s.append("|-");
        }
        last ? inc_indent() : inc_lindent();
        attached = true;
        last = false;
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("GenericName");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        s.append("\n" + indtd + "|-" + "attr=↧");
        for (size_t i=0; i<x.n_attr; i++) {
            inc_lindent();
            last = i == x.n_attr-1;
            attached = false;
            self().visit_decl_attribute(*x.m_attr[i]);
            dec_indent();
        }
        s.append("\n" + indtd + "|-" + "name=");
        s.append(x.m_name);
        s.append("\n" + indtd + "|-" + "names=");
        for (size_t i=0; i<x.n_names; i++) {
            s.append(x.m_names[i]);
            if (i < x.n_names-1) s.append(" ");
        }
        s.append("\n" + indtd + "└-" + "trivia=");
        last = true;
        if (x.m_trivia) {
            self().visit_trivia(*x.m_trivia);
        } else {
            s.append("()");
        last = false;
        attached = false;
        }
        dec_indent();
    }
    void visit_GenericWrite(const GenericWrite_t &x) {
        if(!attached) {
            if(start_line) {
                start_line = false;
                s.append(indtd);
            } else {
                s.append("\n"+indtd);
            }
            last ? s.append("└-") : s.append("|-");
        }
        last ? inc_indent() : inc_lindent();
        attached = true;
        last = false;
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("GenericWrite");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        s.append("\n" + indtd + "|-" + "attr=↧");
        for (size_t i=0; i<x.n_attr; i++) {
            inc_lindent();
            last = i == x.n_attr-1;
            attached = false;
            self().visit_decl_attribute(*x.m_attr[i]);
            dec_indent();
        }
        s.append("\n" + indtd + "|-" + "id=");
        s.append(x.m_id);
        s.append("\n" + indtd + "|-" + "names=");
        for (size_t i=0; i<x.n_names; i++) {
            s.append(x.m_names[i]);
            if (i < x.n_names-1) s.append(" ");
        }
        s.append("\n" + indtd + "└-" + "trivia=");
        last = true;
        if (x.m_trivia) {
            self().visit_trivia(*x.m_trivia);
        } else {
            s.append("()");
        last = false;
        attached = false;
        }
        dec_indent();
    }
    void visit_GenericRead(const GenericRead_t &x) {
        if(!attached) {
            if(start_line) {
                start_line = false;
                s.append(indtd);
            } else {
                s.append("\n"+indtd);
            }
            last ? s.append("└-") : s.append("|-");
        }
        last ? inc_indent() : inc_lindent();
        attached = true;
        last = false;
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("GenericRead");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        s.append("\n" + indtd + "|-" + "attr=↧");
        for (size_t i=0; i<x.n_attr; i++) {
            inc_lindent();
            last = i == x.n_attr-1;
            attached = false;
            self().visit_decl_attribute(*x.m_attr[i]);
            dec_indent();
        }
        s.append("\n" + indtd + "|-" + "id=");
        s.append(x.m_id);
        s.append("\n" + indtd + "|-" + "names=");
        for (size_t i=0; i<x.n_names; i++) {
            s.append(x.m_names[i]);
            if (i < x.n_names-1) s.append(" ");
        }
        s.append("\n" + indtd + "└-" + "trivia=");
        last = true;
        if (x.m_trivia) {
            self().visit_trivia(*x.m_trivia);
        } else {
            s.append("()");
        last = false;
        attached = false;
        }
        dec_indent();
    }
    void visit_FinalName(const FinalName_t &x) {
        if(!attached) {
            if(start_line) {
                start_line = false;
                s.append(indtd);
            } else {
                s.append("\n"+indtd);
            }
            last ? s.append("└-") : s.append("|-");
        }
        last ? inc_indent() : inc_lindent();
        attached = true;
        last = false;
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("FinalName");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        s.append("\n" + indtd + "|-" + "name=");
        s.append(x.m_name);
        s.append("\n" + indtd + "└-" + "trivia=");
        last = true;
        if (x.m_trivia) {
            self().visit_trivia(*x.m_trivia);
        } else {
            s.append("()");
        last = false;
        attached = false;
        }
        dec_indent();
    }
    void visit_Private(const Private_t &x) {
        if(!attached) {
            if(start_line) {
                start_line = false;
                s.append(indtd);
            } else {
                s.append("\n"+indtd);
            }
            last ? s.append("└-") : s.append("|-");
        }
        last ? inc_indent() : inc_lindent();
        attached = true;
        last = false;
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("Private");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        s.append("\n" + indtd + "└-" + "trivia=");
        last = true;
        if (x.m_trivia) {
            self().visit_trivia(*x.m_trivia);
        } else {
            s.append("()");
        last = false;
        attached = false;
        }
        dec_indent();
    }
    void visit_AttrBind(const AttrBind_t &x) {
        if(!attached) {
            if(start_line) {
                start_line = false;
                s.append(indtd);
            } else {
                s.append("\n"+indtd);
            }
            last ? s.append("└-") : s.append("|-");
        }
        last ? inc_indent() : inc_lindent();
        attached = true;
        last = false;
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("AttrBind");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        s.append("\n" + indtd + "└-" + "bind=");
        last = true;
        attached = true;
        self().visit_bind(*x.m_bind);
        dec_indent();
    }
    void visit_AttrDimension(const AttrDimension_t &x) {
        if(!attached) {
            if(start_line) {
                start_line = false;
                s.append(indtd);
            } else {
                s.append("\n"+indtd);
            }
            last ? s.append("└-") : s.append("|-");
        }
        last ? inc_indent() : inc_lindent();
        attached = true;
        last = false;
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("AttrDimension");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        s.append("\n" + indtd + "└-" + "dim=↧");
        for (size_t i=0; i<x.n_dim; i++) {
            inc_indent();
            last = i == x.n_dim-1;
            attached = false;
            self().visit_dimension(x.m_dim[i]);
            dec_indent();
        }
        dec_indent();
    }
    void visit_AttrCodimension(const AttrCodimension_t &x) {
        if(!attached) {
            if(start_line) {
                start_line = false;
                s.append(indtd);
            } else {
                s.append("\n"+indtd);
            }
            last ? s.append("└-") : s.append("|-");
        }
        last ? inc_indent() : inc_lindent();
        attached = true;
        last = false;
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("AttrCodimension");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        s.append("\n" + indtd + "└-" + "codim=↧");
        for (size_t i=0; i<x.n_codim; i++) {
            inc_indent();
            last = i == x.n_codim-1;
            attached = false;
            self().visit_codimension(x.m_codim[i]);
            dec_indent();
        }
        dec_indent();
    }
    void visit_AttrEquivalence(const AttrEquivalence_t &x) {
        if(!attached) {
            if(start_line) {
                start_line = false;
                s.append(indtd);
            } else {
                s.append("\n"+indtd);
            }
            last ? s.append("└-") : s.append("|-");
        }
        last ? inc_indent() : inc_lindent();
        attached = true;
        last = false;
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("AttrEquivalence");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        s.append("\n" + indtd + "└-" + "args=↧");
        for (size_t i=0; i<x.n_args; i++) {
            inc_indent();
            last = i == x.n_args-1;
            attached = false;
            self().visit_equi(x.m_args[i]);
            dec_indent();
        }
        dec_indent();
    }
    void visit_AttrExtends(const AttrExtends_t &x) {
        if(!attached) {
            if(start_line) {
                start_line = false;
                s.append(indtd);
            } else {
                s.append("\n"+indtd);
            }
            last ? s.append("└-") : s.append("|-");
        }
        last ? inc_indent() : inc_lindent();
        attached = true;
        last = false;
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("AttrExtends");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        s.append("\n" + indtd + "└-" + "name=");
        s.append(x.m_name);
        dec_indent();
        if ((bool&)x) { } // Suppress unused warning
    }
    void visit_AttrIntent(const AttrIntent_t &x) {
        if(!attached) {
            if(start_line) {
                start_line = false;
                s.append(indtd);
            } else {
                s.append("\n"+indtd);
            }
            last ? s.append("└-") : s.append("|-");
        }
        last ? inc_indent() : inc_lindent();
        attached = true;
        last = false;
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("AttrIntent");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        s.append("\n" + indtd + "└-" + "attr_intentType=");
        visit_attr_intentType(x.m_intent);
        dec_indent();
        if ((bool&)x) { } // Suppress unused warning
    }
    void visit_AttrNamelist(const AttrNamelist_t &x) {
        if(!attached) {
            if(start_line) {
                start_line = false;
                s.append(indtd);
            } else {
                s.append("\n"+indtd);
            }
            last ? s.append("└-") : s.append("|-");
        }
        last ? inc_indent() : inc_lindent();
        attached = true;
        last = false;
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("AttrNamelist");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        s.append("\n" + indtd + "└-" + "name=");
        s.append(x.m_name);
        dec_indent();
        if ((bool&)x) { } // Suppress unused warning
    }
    void visit_AttrPass(const AttrPass_t &x) {
        if(!attached) {
            if(start_line) {
                start_line = false;
                s.append(indtd);
            } else {
                s.append("\n"+indtd);
            }
            last ? s.append("└-") : s.append("|-");
        }
        last ? inc_indent() : inc_lindent();
        attached = true;
        last = false;
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("AttrPass");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        s.append("\n" + indtd + "└-" + "name=");
        if (x.m_name) {
            s.append(x.m_name);
        } else {
            s.append("()");
        }
        dec_indent();
        if ((bool&)x) { } // Suppress unused warning
    }
    void visit_SimpleAttribute(const SimpleAttribute_t &x) {
        if(!attached) {
            if(start_line) {
                start_line = false;
                s.append(indtd);
            } else {
                s.append("\n"+indtd);
            }
            last ? s.append("└-") : s.append("|-");
        }
        last ? inc_indent() : inc_lindent();
        attached = true;
        last = false;
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("SimpleAttribute");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        s.append("\n" + indtd + "└-" + "simple_attributeType=");
        visit_simple_attributeType(x.m_attr);
        dec_indent();
        if ((bool&)x) { } // Suppress unused warning
    }
    void visit_AttrType(const AttrType_t &x) {
        if(!attached) {
            if(start_line) {
                start_line = false;
                s.append(indtd);
            } else {
                s.append("\n"+indtd);
            }
            last ? s.append("└-") : s.append("|-");
        }
        last ? inc_indent() : inc_lindent();
        attached = true;
        last = false;
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("AttrType");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        s.append("\n" + indtd + "|-" + "decl_typeType=");
        visit_decl_typeType(x.m_type);
        s.append("\n" + indtd + "|-" + "kind=↧");
        for (size_t i=0; i<x.n_kind; i++) {
            inc_lindent();
            last = i == x.n_kind-1;
            attached = false;
            self().visit_kind_item(x.m_kind[i]);
            dec_indent();
        }
        s.append("\n" + indtd + "|-" + "attr=");
        if (x.m_attr) {
            self().visit_decl_attribute(*x.m_attr);
        } else {
            s.append("()");
        last = false;
        attached = false;
        }
        s.append("\n" + indtd + "|-" + "name=");
        if (x.m_name) {
            s.append(x.m_name);
        } else {
            s.append("()");
        }
        s.append("\n" + indtd + "└-" + "symbolType=");
        visit_symbolType(x.m_sym);
        dec_indent();
    }
    void visit_AttrAssignment(const AttrAssignment_t &x) {
        if(!attached) {
            if(start_line) {
                start_line = false;
                s.append(indtd);
            } else {
                s.append("\n"+indtd);
            }
            last ? s.append("└-") : s.append("|-");
        }
        last ? inc_indent() : inc_lindent();
        attached = true;
        last = false;
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("AttrAssignment");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        dec_indent();
        if ((bool&)x) { } // Suppress unused warning
    }
    void visit_AttrIntrinsicOperator(const AttrIntrinsicOperator_t &x) {
        if(!attached) {
            if(start_line) {
                start_line = false;
                s.append(indtd);
            } else {
                s.append("\n"+indtd);
            }
            last ? s.append("└-") : s.append("|-");
        }
        last ? inc_indent() : inc_lindent();
        attached = true;
        last = false;
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("AttrIntrinsicOperator");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        s.append("\n" + indtd + "└-" + "intrinsicopType=");
        visit_intrinsicopType(x.m_op);
        dec_indent();
        if ((bool&)x) { } // Suppress unused warning
    }
    void visit_AttrDefinedOperator(const AttrDefinedOperator_t &x) {
        if(!attached) {
            if(start_line) {
                start_line = false;
                s.append(indtd);
            } else {
                s.append("\n"+indtd);
            }
            last ? s.append("└-") : s.append("|-");
        }
        last ? inc_indent() : inc_lindent();
        attached = true;
        last = false;
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("AttrDefinedOperator");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        s.append("\n" + indtd + "└-" + "op_name=");
        s.append("\"" + std::string(x.m_op_name) + "\"");
        dec_indent();
        if ((bool&)x) { } // Suppress unused warning
    }
    void visit_simple_attributeType(const simple_attributeType &x) {
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::green));
        }
        switch (x) {
            case (simple_attributeType::AttrAbstract) : {
                s.append("AttrAbstract");
             break; }
            case (simple_attributeType::AttrAllocatable) : {
                s.append("AttrAllocatable");
             break; }
            case (simple_attributeType::AttrAsynchronous) : {
                s.append("AttrAsynchronous");
             break; }
            case (simple_attributeType::AttrCommon) : {
                s.append("AttrCommon");
             break; }
            case (simple_attributeType::AttrContiguous) : {
                s.append("AttrContiguous");
             break; }
            case (simple_attributeType::AttrDeferred) : {
                s.append("AttrDeferred");
             break; }
            case (simple_attributeType::AttrElemental) : {
                s.append("AttrElemental");
             break; }
            case (simple_attributeType::AttrEnumerator) : {
                s.append("AttrEnumerator");
             break; }
            case (simple_attributeType::AttrExternal) : {
                s.append("AttrExternal");
             break; }
            case (simple_attributeType::AttrImpure) : {
                s.append("AttrImpure");
             break; }
            case (simple_attributeType::AttrIntrinsic) : {
                s.append("AttrIntrinsic");
             break; }
            case (simple_attributeType::AttrKind) : {
                s.append("AttrKind");
             break; }
            case (simple_attributeType::AttrLen) : {
                s.append("AttrLen");
             break; }
            case (simple_attributeType::AttrModule) : {
                s.append("AttrModule");
             break; }
            case (simple_attributeType::AttrNoPass) : {
                s.append("AttrNoPass");
             break; }
            case (simple_attributeType::AttrNonDeferred) : {
                s.append("AttrNonDeferred");
             break; }
            case (simple_attributeType::AttrNon_Intrinsic) : {
                s.append("AttrNon_Intrinsic");
             break; }
            case (simple_attributeType::AttrOptional) : {
                s.append("AttrOptional");
             break; }
            case (simple_attributeType::AttrParameter) : {
                s.append("AttrParameter");
             break; }
            case (simple_attributeType::AttrPointer) : {
                s.append("AttrPointer");
             break; }
            case (simple_attributeType::AttrPrivate) : {
                s.append("AttrPrivate");
             break; }
            case (simple_attributeType::AttrProtected) : {
                s.append("AttrProtected");
             break; }
            case (simple_attributeType::AttrPublic) : {
                s.append("AttrPublic");
             break; }
            case (simple_attributeType::AttrPure) : {
                s.append("AttrPure");
             break; }
            case (simple_attributeType::AttrRecursive) : {
                s.append("AttrRecursive");
             break; }
            case (simple_attributeType::AttrSave) : {
                s.append("AttrSave");
             break; }
            case (simple_attributeType::AttrSequence) : {
                s.append("AttrSequence");
             break; }
            case (simple_attributeType::AttrTarget) : {
                s.append("AttrTarget");
             break; }
            case (simple_attributeType::AttrValue) : {
                s.append("AttrValue");
             break; }
            case (simple_attributeType::AttrVolatile) : {
                s.append("AttrVolatile");
             break; }
        }
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
    }
    void visit_attr_intentType(const attr_intentType &x) {
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::green));
        }
        switch (x) {
            case (attr_intentType::In) : {
                s.append("In");
             break; }
            case (attr_intentType::Out) : {
                s.append("Out");
             break; }
            case (attr_intentType::InOut) : {
                s.append("InOut");
             break; }
        }
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
    }
    void visit_decl_typeType(const decl_typeType &x) {
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::green));
        }
        switch (x) {
            case (decl_typeType::TypeClass) : {
                s.append("TypeClass");
             break; }
            case (decl_typeType::TypeCharacter) : {
                s.append("TypeCharacter");
             break; }
            case (decl_typeType::TypeComplex) : {
                s.append("TypeComplex");
             break; }
            case (decl_typeType::TypeDoublePrecision) : {
                s.append("TypeDoublePrecision");
             break; }
            case (decl_typeType::TypeDoubleComplex) : {
                s.append("TypeDoubleComplex");
             break; }
            case (decl_typeType::TypeInteger) : {
                s.append("TypeInteger");
             break; }
            case (decl_typeType::TypeLogical) : {
                s.append("TypeLogical");
             break; }
            case (decl_typeType::TypeProcedure) : {
                s.append("TypeProcedure");
             break; }
            case (decl_typeType::TypeReal) : {
                s.append("TypeReal");
             break; }
            case (decl_typeType::TypeType) : {
                s.append("TypeType");
             break; }
        }
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
    }
    void visit_AttrStat(const AttrStat_t &x) {
        if(!attached) {
            if(start_line) {
                start_line = false;
                s.append(indtd);
            } else {
                s.append("\n"+indtd);
            }
            last ? s.append("└-") : s.append("|-");
        }
        last ? inc_indent() : inc_lindent();
        attached = true;
        last = false;
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("AttrStat");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        s.append("\n" + indtd + "└-" + "variable=");
        s.append(x.m_variable);
        dec_indent();
        if ((bool&)x) { } // Suppress unused warning
    }
    void visit_AttrErrmsg(const AttrErrmsg_t &x) {
        if(!attached) {
            if(start_line) {
                start_line = false;
                s.append(indtd);
            } else {
                s.append("\n"+indtd);
            }
            last ? s.append("└-") : s.append("|-");
        }
        last ? inc_indent() : inc_lindent();
        attached = true;
        last = false;
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("AttrErrmsg");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        s.append("\n" + indtd + "└-" + "variable=");
        s.append(x.m_variable);
        dec_indent();
        if ((bool&)x) { } // Suppress unused warning
    }
    void visit_AttrNewIndex(const AttrNewIndex_t &x) {
        if(!attached) {
            if(start_line) {
                start_line = false;
                s.append(indtd);
            } else {
                s.append("\n"+indtd);
            }
            last ? s.append("└-") : s.append("|-");
        }
        last ? inc_indent() : inc_lindent();
        attached = true;
        last = false;
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("AttrNewIndex");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        s.append("\n" + indtd + "└-" + "value=");
        last = true;
        attached = true;
        self().visit_expr(*x.m_value);
        dec_indent();
    }
    void visit_AttrEventWaitKwArg(const AttrEventWaitKwArg_t &x) {
        if(!attached) {
            if(start_line) {
                start_line = false;
                s.append(indtd);
            } else {
                s.append("\n"+indtd);
            }
            last ? s.append("└-") : s.append("|-");
        }
        last ? inc_indent() : inc_lindent();
        attached = true;
        last = false;
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("AttrEventWaitKwArg");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        s.append("\n" + indtd + "|-" + "id=");
        s.append(x.m_id);
        s.append("\n" + indtd + "└-" + "value=");
        last = true;
        attached = true;
        self().visit_expr(*x.m_value);
        dec_indent();
    }
    void visit_CoarrayAssociation(const CoarrayAssociation_t &x) {
        if(!attached) {
            if(start_line) {
                start_line = false;
                s.append(indtd);
            } else {
                s.append("\n"+indtd);
            }
            last ? s.append("└-") : s.append("|-");
        }
        last ? inc_indent() : inc_lindent();
        attached = true;
        last = false;
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("CoarrayAssociation");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        s.append("\n" + indtd + "|-" + "coarray=");
        attached = true;
        self().visit_expr(*x.m_coarray);
        s.append("\n" + indtd + "└-" + "selector=");
        last = true;
        attached = true;
        self().visit_expr(*x.m_selector);
        dec_indent();
    }
    void visit_var_sym(const var_sym_t &x) {
        if(!attached) {
            if(start_line) {
                start_line = false;
                s.append(indtd);
            } else {
                s.append("\n"+indtd);
            }
            last ? s.append("└-") : s.append("|-");
        }
        last ? inc_indent() : inc_lindent();
        attached = true;
        last = false;
        s.append("\n" + indtd + "|-" + "name=");
        if (x.m_name) {
            s.append(x.m_name);
        } else {
            s.append("()");
        }
        s.append("\n" + indtd + "|-" + "dim=↧");
        for (size_t i=0; i<x.n_dim; i++) {
            inc_lindent();
            last = i == x.n_dim-1;
            attached = false;
            self().visit_dimension(x.m_dim[i]);
            dec_indent();
        }
        s.append("\n" + indtd + "|-" + "codim=↧");
        for (size_t i=0; i<x.n_codim; i++) {
            inc_lindent();
            last = i == x.n_codim-1;
            attached = false;
            self().visit_codimension(x.m_codim[i]);
            dec_indent();
        }
        s.append("\n" + indtd + "|-" + "length=");
        if (x.m_length) {
            self().visit_expr(*x.m_length);
        } else {
            s.append("()");
        last = false;
        attached = false;
        }
        s.append("\n" + indtd + "|-" + "initializer=");
        if (x.m_initializer) {
            self().visit_expr(*x.m_initializer);
        } else {
            s.append("()");
        last = false;
        attached = false;
        }
        s.append("\n" + indtd + "|-" + "symbolType=");
        visit_symbolType(x.m_sym);
        s.append("\n" + indtd + "└-" + "spec=");
        last = true;
        if (x.m_spec) {
            self().visit_decl_attribute(*x.m_spec);
        } else {
            s.append("()");
        last = false;
        attached = false;
        }
        dec_indent();
    }
    void visit_kind_item(const kind_item_t &x) {
        if(!attached) {
            if(start_line) {
                start_line = false;
                s.append(indtd);
            } else {
                s.append("\n"+indtd);
            }
            last ? s.append("└-") : s.append("|-");
        }
        last ? inc_indent() : inc_lindent();
        attached = true;
        last = false;
        s.append("\n" + indtd + "|-" + "id=");
        if (x.m_id) {
            s.append(x.m_id);
        } else {
            s.append("()");
        }
        s.append("\n" + indtd + "|-" + "value=");
        if (x.m_value) {
            self().visit_expr(*x.m_value);
        } else {
            s.append("()");
        last = false;
        attached = false;
        }
        s.append("\n" + indtd + "└-" + "kind_item_typeType=");
        visit_kind_item_typeType(x.m_type);
        dec_indent();
    }
    void visit_kind_item_typeType(const kind_item_typeType &x) {
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::green));
        }
        switch (x) {
            case (kind_item_typeType::Star) : {
                s.append("Star");
             break; }
            case (kind_item_typeType::Colon) : {
                s.append("Colon");
             break; }
            case (kind_item_typeType::Value) : {
                s.append("Value");
             break; }
        }
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
    }
    void visit_dimension(const dimension_t &x) {
        if(!attached) {
            if(start_line) {
                start_line = false;
                s.append(indtd);
            } else {
                s.append("\n"+indtd);
            }
            last ? s.append("└-") : s.append("|-");
        }
        last ? inc_indent() : inc_lindent();
        attached = true;
        last = false;
        s.append("\n" + indtd + "|-" + "start=");
        if (x.m_start) {
            self().visit_expr(*x.m_start);
        } else {
            s.append("()");
        last = false;
        attached = false;
        }
        s.append("\n" + indtd + "|-" + "end=");
        if (x.m_end) {
            self().visit_expr(*x.m_end);
        } else {
            s.append("()");
        last = false;
        attached = false;
        }
        s.append("\n" + indtd + "└-" + "dimension_typeType=");
        visit_dimension_typeType(x.m_end_star);
        dec_indent();
    }
    void visit_dimension_typeType(const dimension_typeType &x) {
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::green));
        }
        switch (x) {
            case (dimension_typeType::DimensionExpr) : {
                s.append("DimensionExpr");
             break; }
            case (dimension_typeType::DimensionStar) : {
                s.append("DimensionStar");
             break; }
            case (dimension_typeType::AssumedRank) : {
                s.append("AssumedRank");
             break; }
        }
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
    }
    void visit_codimension(const codimension_t &x) {
        if(!attached) {
            if(start_line) {
                start_line = false;
                s.append(indtd);
            } else {
                s.append("\n"+indtd);
            }
            last ? s.append("└-") : s.append("|-");
        }
        last ? inc_indent() : inc_lindent();
        attached = true;
        last = false;
        s.append("\n" + indtd + "|-" + "start=");
        if (x.m_start) {
            self().visit_expr(*x.m_start);
        } else {
            s.append("()");
        last = false;
        attached = false;
        }
        s.append("\n" + indtd + "|-" + "end=");
        if (x.m_end) {
            self().visit_expr(*x.m_end);
        } else {
            s.append("()");
        last = false;
        attached = false;
        }
        s.append("\n" + indtd + "└-" + "codimension_typeType=");
        visit_codimension_typeType(x.m_end_star);
        dec_indent();
    }
    void visit_codimension_typeType(const codimension_typeType &x) {
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::green));
        }
        switch (x) {
            case (codimension_typeType::CodimensionExpr) : {
                s.append("CodimensionExpr");
             break; }
            case (codimension_typeType::CodimensionStar) : {
                s.append("CodimensionStar");
             break; }
        }
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
    }
    void visit_symbolType(const symbolType &x) {
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::green));
        }
        switch (x) {
            case (symbolType::None) : {
                s.append("None");
             break; }
            case (symbolType::Arrow) : {
                s.append("Arrow");
             break; }
            case (symbolType::Equal) : {
                s.append("Equal");
             break; }
            case (symbolType::Asterisk) : {
                s.append("Asterisk");
             break; }
            case (symbolType::DoubleAsterisk) : {
                s.append("DoubleAsterisk");
             break; }
            case (symbolType::Slash) : {
                s.append("Slash");
             break; }
        }
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
    }
    void visit_equi(const equi_t &x) {
        if(!attached) {
            if(start_line) {
                start_line = false;
                s.append(indtd);
            } else {
                s.append("\n"+indtd);
            }
            last ? s.append("└-") : s.append("|-");
        }
        last ? inc_indent() : inc_lindent();
        attached = true;
        last = false;
        s.append("\n" + indtd + "└-" + "set_list=↧");
        for (size_t i=0; i<x.n_set_list; i++) {
            inc_indent();
            last = i == x.n_set_list-1;
            attached = false;
            self().visit_expr(*x.m_set_list[i]);
            dec_indent();
        }
        dec_indent();
    }
    void visit_kw_argstar(const kw_argstar_t &x) {
        if(!attached) {
            if(start_line) {
                start_line = false;
                s.append(indtd);
            } else {
                s.append("\n"+indtd);
            }
            last ? s.append("└-") : s.append("|-");
        }
        last ? inc_indent() : inc_lindent();
        attached = true;
        last = false;
        s.append("\n" + indtd + "|-" + "arg=");
        s.append(x.m_arg);
        s.append("\n" + indtd + "└-" + "value=");
        last = true;
        if (x.m_value) {
            self().visit_expr(*x.m_value);
        } else {
            s.append("()");
        last = false;
        attached = false;
        }
        dec_indent();
    }
    void visit_argstar(const argstar_t &x) {
        if(!attached) {
            if(start_line) {
                start_line = false;
                s.append(indtd);
            } else {
                s.append("\n"+indtd);
            }
            last ? s.append("└-") : s.append("|-");
        }
        last ? inc_indent() : inc_lindent();
        attached = true;
        last = false;
        s.append("\n" + indtd + "└-" + "value=");
        last = true;
        if (x.m_value) {
            self().visit_expr(*x.m_value);
        } else {
            s.append("()");
        last = false;
        attached = false;
        }
        dec_indent();
    }
    void visit_arg(const arg_t &x) {
        if(!attached) {
            if(start_line) {
                start_line = false;
                s.append(indtd);
            } else {
                s.append("\n"+indtd);
            }
            last ? s.append("└-") : s.append("|-");
        }
        last ? inc_indent() : inc_lindent();
        attached = true;
        last = false;
        s.append("\n" + indtd + "└-" + "arg=");
        if (x.m_arg) {
            s.append(x.m_arg);
        } else {
            s.append("()");
        }
        dec_indent();
        if ((bool&)x) { } // Suppress unused warning
    }
    void visit_fnarg(const fnarg_t &x) {
        if(!attached) {
            if(start_line) {
                start_line = false;
                s.append(indtd);
            } else {
                s.append("\n"+indtd);
            }
            last ? s.append("└-") : s.append("|-");
        }
        last ? inc_indent() : inc_lindent();
        attached = true;
        last = false;
        s.append("\n" + indtd + "|-" + "start=");
        if (x.m_start) {
            self().visit_expr(*x.m_start);
        } else {
            s.append("()");
        last = false;
        attached = false;
        }
        s.append("\n" + indtd + "|-" + "end=");
        if (x.m_end) {
            self().visit_expr(*x.m_end);
        } else {
            s.append("()");
        last = false;
        attached = false;
        }
        s.append("\n" + indtd + "|-" + "step=");
        if (x.m_step) {
            self().visit_expr(*x.m_step);
        } else {
            s.append("()");
        last = false;
        attached = false;
        }
        s.append("\n" + indtd + "└-" + "label=");
        s.append(std::to_string(x.m_label));
        dec_indent();
    }
    void visit_coarrayarg(const coarrayarg_t &x) {
        if(!attached) {
            if(start_line) {
                start_line = false;
                s.append(indtd);
            } else {
                s.append("\n"+indtd);
            }
            last ? s.append("└-") : s.append("|-");
        }
        last ? inc_indent() : inc_lindent();
        attached = true;
        last = false;
        s.append("\n" + indtd + "|-" + "start=");
        if (x.m_start) {
            self().visit_expr(*x.m_start);
        } else {
            s.append("()");
        last = false;
        attached = false;
        }
        s.append("\n" + indtd + "|-" + "end=");
        if (x.m_end) {
            self().visit_expr(*x.m_end);
        } else {
            s.append("()");
        last = false;
        attached = false;
        }
        s.append("\n" + indtd + "|-" + "step=");
        if (x.m_step) {
            self().visit_expr(*x.m_step);
        } else {
            s.append("()");
        last = false;
        attached = false;
        }
        s.append("\n" + indtd + "└-" + "codimension_typeType=");
        visit_codimension_typeType(x.m_star);
        dec_indent();
    }
    void visit_keyword(const keyword_t &x) {
        if(!attached) {
            if(start_line) {
                start_line = false;
                s.append(indtd);
            } else {
                s.append("\n"+indtd);
            }
            last ? s.append("└-") : s.append("|-");
        }
        last ? inc_indent() : inc_lindent();
        attached = true;
        last = false;
        s.append("\n" + indtd + "|-" + "arg=");
        s.append(x.m_arg);
        s.append("\n" + indtd + "└-" + "value=");
        last = true;
        attached = true;
        self().visit_expr(*x.m_value);
        dec_indent();
    }
    void visit_struct_member(const struct_member_t &x) {
        if(!attached) {
            if(start_line) {
                start_line = false;
                s.append(indtd);
            } else {
                s.append("\n"+indtd);
            }
            last ? s.append("└-") : s.append("|-");
        }
        last ? inc_indent() : inc_lindent();
        attached = true;
        last = false;
        s.append("\n" + indtd + "|-" + "name=");
        s.append(x.m_name);
        s.append("\n" + indtd + "└-" + "args=↧");
        for (size_t i=0; i<x.n_args; i++) {
            inc_indent();
            last = i == x.n_args-1;
            attached = false;
            self().visit_fnarg(x.m_args[i]);
            dec_indent();
        }
        dec_indent();
    }
    void visit_Bind(const Bind_t &x) {
        if(!attached) {
            if(start_line) {
                start_line = false;
                s.append(indtd);
            } else {
                s.append("\n"+indtd);
            }
            last ? s.append("└-") : s.append("|-");
        }
        last ? inc_indent() : inc_lindent();
        attached = true;
        last = false;
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("Bind");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        s.append("\n" + indtd + "|-" + "args=↧");
        for (size_t i=0; i<x.n_args; i++) {
            inc_lindent();
            last = i == x.n_args-1;
            attached = false;
            self().visit_expr(*x.m_args[i]);
            dec_indent();
        }
        s.append("\n" + indtd + "└-" + "kwargs=↧");
        for (size_t i=0; i<x.n_kwargs; i++) {
            inc_indent();
            last = i == x.n_kwargs-1;
            attached = false;
            self().visit_keyword(x.m_kwargs[i]);
            dec_indent();
        }
        dec_indent();
    }
    void visit_ArrayIndex(const ArrayIndex_t &x) {
        if(!attached) {
            if(start_line) {
                start_line = false;
                s.append(indtd);
            } else {
                s.append("\n"+indtd);
            }
            last ? s.append("└-") : s.append("|-");
        }
        last ? inc_indent() : inc_lindent();
        attached = true;
        last = false;
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("ArrayIndex");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        s.append("\n" + indtd + "|-" + "left=");
        if (x.m_left) {
            self().visit_expr(*x.m_left);
        } else {
            s.append("()");
        last = false;
        attached = false;
        }
        s.append("\n" + indtd + "|-" + "right=");
        if (x.m_right) {
            self().visit_expr(*x.m_right);
        } else {
            s.append("()");
        last = false;
        attached = false;
        }
        s.append("\n" + indtd + "└-" + "step=");
        last = true;
        if (x.m_step) {
            self().visit_expr(*x.m_step);
        } else {
            s.append("()");
        last = false;
        attached = false;
        }
        dec_indent();
    }
    void visit_CaseStmt(const CaseStmt_t &x) {
        if(!attached) {
            if(start_line) {
                start_line = false;
                s.append(indtd);
            } else {
                s.append("\n"+indtd);
            }
            last ? s.append("└-") : s.append("|-");
        }
        last ? inc_indent() : inc_lindent();
        attached = true;
        last = false;
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("CaseStmt");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        s.append("\n" + indtd + "|-" + "test=↧");
        for (size_t i=0; i<x.n_test; i++) {
            inc_lindent();
            last = i == x.n_test-1;
            attached = false;
            self().visit_case_cond(*x.m_test[i]);
            dec_indent();
        }
        s.append("\n" + indtd + "|-" + "trivia=");
        if (x.m_trivia) {
            self().visit_trivia(*x.m_trivia);
        } else {
            s.append("()");
        last = false;
        attached = false;
        }
        s.append("\n" + indtd + "└-" + "body=↧");
        for (size_t i=0; i<x.n_body; i++) {
            inc_indent();
            last = i == x.n_body-1;
            attached = false;
            self().visit_stmt(*x.m_body[i]);
            dec_indent();
        }
        dec_indent();
    }
    void visit_CaseStmt_Default(const CaseStmt_Default_t &x) {
        if(!attached) {
            if(start_line) {
                start_line = false;
                s.append(indtd);
            } else {
                s.append("\n"+indtd);
            }
            last ? s.append("└-") : s.append("|-");
        }
        last ? inc_indent() : inc_lindent();
        attached = true;
        last = false;
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("CaseStmt_Default");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        s.append("\n" + indtd + "|-" + "trivia=");
        if (x.m_trivia) {
            self().visit_trivia(*x.m_trivia);
        } else {
            s.append("()");
        last = false;
        attached = false;
        }
        s.append("\n" + indtd + "└-" + "body=↧");
        for (size_t i=0; i<x.n_body; i++) {
            inc_indent();
            last = i == x.n_body-1;
            attached = false;
            self().visit_stmt(*x.m_body[i]);
            dec_indent();
        }
        dec_indent();
    }
    void visit_CaseCondExpr(const CaseCondExpr_t &x) {
        if(!attached) {
            if(start_line) {
                start_line = false;
                s.append(indtd);
            } else {
                s.append("\n"+indtd);
            }
            last ? s.append("└-") : s.append("|-");
        }
        last ? inc_indent() : inc_lindent();
        attached = true;
        last = false;
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("CaseCondExpr");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        s.append("\n" + indtd + "└-" + "cond=");
        last = true;
        attached = true;
        self().visit_expr(*x.m_cond);
        dec_indent();
    }
    void visit_CaseCondRange(const CaseCondRange_t &x) {
        if(!attached) {
            if(start_line) {
                start_line = false;
                s.append(indtd);
            } else {
                s.append("\n"+indtd);
            }
            last ? s.append("└-") : s.append("|-");
        }
        last ? inc_indent() : inc_lindent();
        attached = true;
        last = false;
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("CaseCondRange");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        s.append("\n" + indtd + "|-" + "start=");
        if (x.m_start) {
            self().visit_expr(*x.m_start);
        } else {
            s.append("()");
        last = false;
        attached = false;
        }
        s.append("\n" + indtd + "└-" + "end=");
        last = true;
        if (x.m_end) {
            self().visit_expr(*x.m_end);
        } else {
            s.append("()");
        last = false;
        attached = false;
        }
        dec_indent();
    }
    void visit_RankExpr(const RankExpr_t &x) {
        if(!attached) {
            if(start_line) {
                start_line = false;
                s.append(indtd);
            } else {
                s.append("\n"+indtd);
            }
            last ? s.append("└-") : s.append("|-");
        }
        last ? inc_indent() : inc_lindent();
        attached = true;
        last = false;
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("RankExpr");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        s.append("\n" + indtd + "|-" + "value=");
        attached = true;
        self().visit_expr(*x.m_value);
        s.append("\n" + indtd + "|-" + "trivia=");
        if (x.m_trivia) {
            self().visit_trivia(*x.m_trivia);
        } else {
            s.append("()");
        last = false;
        attached = false;
        }
        s.append("\n" + indtd + "└-" + "body=↧");
        for (size_t i=0; i<x.n_body; i++) {
            inc_indent();
            last = i == x.n_body-1;
            attached = false;
            self().visit_stmt(*x.m_body[i]);
            dec_indent();
        }
        dec_indent();
    }
    void visit_RankStar(const RankStar_t &x) {
        if(!attached) {
            if(start_line) {
                start_line = false;
                s.append(indtd);
            } else {
                s.append("\n"+indtd);
            }
            last ? s.append("└-") : s.append("|-");
        }
        last ? inc_indent() : inc_lindent();
        attached = true;
        last = false;
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("RankStar");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        s.append("\n" + indtd + "|-" + "trivia=");
        if (x.m_trivia) {
            self().visit_trivia(*x.m_trivia);
        } else {
            s.append("()");
        last = false;
        attached = false;
        }
        s.append("\n" + indtd + "└-" + "body=↧");
        for (size_t i=0; i<x.n_body; i++) {
            inc_indent();
            last = i == x.n_body-1;
            attached = false;
            self().visit_stmt(*x.m_body[i]);
            dec_indent();
        }
        dec_indent();
    }
    void visit_RankDefault(const RankDefault_t &x) {
        if(!attached) {
            if(start_line) {
                start_line = false;
                s.append(indtd);
            } else {
                s.append("\n"+indtd);
            }
            last ? s.append("└-") : s.append("|-");
        }
        last ? inc_indent() : inc_lindent();
        attached = true;
        last = false;
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("RankDefault");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        s.append("\n" + indtd + "|-" + "trivia=");
        if (x.m_trivia) {
            self().visit_trivia(*x.m_trivia);
        } else {
            s.append("()");
        last = false;
        attached = false;
        }
        s.append("\n" + indtd + "└-" + "body=↧");
        for (size_t i=0; i<x.n_body; i++) {
            inc_indent();
            last = i == x.n_body-1;
            attached = false;
            self().visit_stmt(*x.m_body[i]);
            dec_indent();
        }
        dec_indent();
    }
    void visit_TypeStmtName(const TypeStmtName_t &x) {
        if(!attached) {
            if(start_line) {
                start_line = false;
                s.append(indtd);
            } else {
                s.append("\n"+indtd);
            }
            last ? s.append("└-") : s.append("|-");
        }
        last ? inc_indent() : inc_lindent();
        attached = true;
        last = false;
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("TypeStmtName");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        s.append("\n" + indtd + "|-" + "name=");
        if (x.m_name) {
            s.append(x.m_name);
        } else {
            s.append("()");
        }
        s.append("\n" + indtd + "|-" + "trivia=");
        if (x.m_trivia) {
            self().visit_trivia(*x.m_trivia);
        } else {
            s.append("()");
        last = false;
        attached = false;
        }
        s.append("\n" + indtd + "└-" + "body=↧");
        for (size_t i=0; i<x.n_body; i++) {
            inc_indent();
            last = i == x.n_body-1;
            attached = false;
            self().visit_stmt(*x.m_body[i]);
            dec_indent();
        }
        dec_indent();
    }
    void visit_TypeStmtType(const TypeStmtType_t &x) {
        if(!attached) {
            if(start_line) {
                start_line = false;
                s.append(indtd);
            } else {
                s.append("\n"+indtd);
            }
            last ? s.append("└-") : s.append("|-");
        }
        last ? inc_indent() : inc_lindent();
        attached = true;
        last = false;
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("TypeStmtType");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        s.append("\n" + indtd + "|-" + "vartype=");
        if (x.m_vartype) {
            self().visit_decl_attribute(*x.m_vartype);
        } else {
            s.append("()");
        last = false;
        attached = false;
        }
        s.append("\n" + indtd + "|-" + "trivia=");
        if (x.m_trivia) {
            self().visit_trivia(*x.m_trivia);
        } else {
            s.append("()");
        last = false;
        attached = false;
        }
        s.append("\n" + indtd + "└-" + "body=↧");
        for (size_t i=0; i<x.n_body; i++) {
            inc_indent();
            last = i == x.n_body-1;
            attached = false;
            self().visit_stmt(*x.m_body[i]);
            dec_indent();
        }
        dec_indent();
    }
    void visit_ClassStmt(const ClassStmt_t &x) {
        if(!attached) {
            if(start_line) {
                start_line = false;
                s.append(indtd);
            } else {
                s.append("\n"+indtd);
            }
            last ? s.append("└-") : s.append("|-");
        }
        last ? inc_indent() : inc_lindent();
        attached = true;
        last = false;
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("ClassStmt");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        s.append("\n" + indtd + "|-" + "id=");
        if (x.m_id) {
            s.append(x.m_id);
        } else {
            s.append("()");
        }
        s.append("\n" + indtd + "|-" + "trivia=");
        if (x.m_trivia) {
            self().visit_trivia(*x.m_trivia);
        } else {
            s.append("()");
        last = false;
        attached = false;
        }
        s.append("\n" + indtd + "└-" + "body=↧");
        for (size_t i=0; i<x.n_body; i++) {
            inc_indent();
            last = i == x.n_body-1;
            attached = false;
            self().visit_stmt(*x.m_body[i]);
            dec_indent();
        }
        dec_indent();
    }
    void visit_ClassDefault(const ClassDefault_t &x) {
        if(!attached) {
            if(start_line) {
                start_line = false;
                s.append(indtd);
            } else {
                s.append("\n"+indtd);
            }
            last ? s.append("└-") : s.append("|-");
        }
        last ? inc_indent() : inc_lindent();
        attached = true;
        last = false;
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("ClassDefault");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        s.append("\n" + indtd + "|-" + "trivia=");
        if (x.m_trivia) {
            self().visit_trivia(*x.m_trivia);
        } else {
            s.append("()");
        last = false;
        attached = false;
        }
        s.append("\n" + indtd + "└-" + "body=↧");
        for (size_t i=0; i<x.n_body; i++) {
            inc_indent();
            last = i == x.n_body-1;
            attached = false;
            self().visit_stmt(*x.m_body[i]);
            dec_indent();
        }
        dec_indent();
    }
    void visit_UseSymbol(const UseSymbol_t &x) {
        if(!attached) {
            if(start_line) {
                start_line = false;
                s.append(indtd);
            } else {
                s.append("\n"+indtd);
            }
            last ? s.append("└-") : s.append("|-");
        }
        last ? inc_indent() : inc_lindent();
        attached = true;
        last = false;
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("UseSymbol");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        s.append("\n" + indtd + "|-" + "remote_sym=");
        s.append(x.m_remote_sym);
        s.append("\n" + indtd + "└-" + "local_rename=");
        if (x.m_local_rename) {
            s.append(x.m_local_rename);
        } else {
            s.append("()");
        }
        dec_indent();
        if ((bool&)x) { } // Suppress unused warning
    }
    void visit_UseAssignment(const UseAssignment_t &x) {
        if(!attached) {
            if(start_line) {
                start_line = false;
                s.append(indtd);
            } else {
                s.append("\n"+indtd);
            }
            last ? s.append("└-") : s.append("|-");
        }
        last ? inc_indent() : inc_lindent();
        attached = true;
        last = false;
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("UseAssignment");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        dec_indent();
        if ((bool&)x) { } // Suppress unused warning
    }
    void visit_IntrinsicOperator(const IntrinsicOperator_t &x) {
        if(!attached) {
            if(start_line) {
                start_line = false;
                s.append(indtd);
            } else {
                s.append("\n"+indtd);
            }
            last ? s.append("└-") : s.append("|-");
        }
        last ? inc_indent() : inc_lindent();
        attached = true;
        last = false;
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("IntrinsicOperator");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        s.append("\n" + indtd + "└-" + "intrinsicopType=");
        visit_intrinsicopType(x.m_op);
        dec_indent();
        if ((bool&)x) { } // Suppress unused warning
    }
    void visit_DefinedOperator(const DefinedOperator_t &x) {
        if(!attached) {
            if(start_line) {
                start_line = false;
                s.append(indtd);
            } else {
                s.append("\n"+indtd);
            }
            last ? s.append("└-") : s.append("|-");
        }
        last ? inc_indent() : inc_lindent();
        attached = true;
        last = false;
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("DefinedOperator");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        s.append("\n" + indtd + "└-" + "opName=");
        s.append("\"" + std::string(x.m_opName) + "\"");
        dec_indent();
        if ((bool&)x) { } // Suppress unused warning
    }
    void visit_RenameOperator(const RenameOperator_t &x) {
        if(!attached) {
            if(start_line) {
                start_line = false;
                s.append(indtd);
            } else {
                s.append("\n"+indtd);
            }
            last ? s.append("└-") : s.append("|-");
        }
        last ? inc_indent() : inc_lindent();
        attached = true;
        last = false;
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("RenameOperator");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        s.append("\n" + indtd + "|-" + "local_defop=");
        s.append("\"" + std::string(x.m_local_defop) + "\"");
        s.append("\n" + indtd + "└-" + "use_defop=");
        s.append("\"" + std::string(x.m_use_defop) + "\"");
        dec_indent();
        if ((bool&)x) { } // Suppress unused warning
    }
    void visit_UseWrite(const UseWrite_t &x) {
        if(!attached) {
            if(start_line) {
                start_line = false;
                s.append(indtd);
            } else {
                s.append("\n"+indtd);
            }
            last ? s.append("└-") : s.append("|-");
        }
        last ? inc_indent() : inc_lindent();
        attached = true;
        last = false;
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("UseWrite");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        s.append("\n" + indtd + "└-" + "id=");
        s.append(x.m_id);
        dec_indent();
        if ((bool&)x) { } // Suppress unused warning
    }
    void visit_UseRead(const UseRead_t &x) {
        if(!attached) {
            if(start_line) {
                start_line = false;
                s.append(indtd);
            } else {
                s.append("\n"+indtd);
            }
            last ? s.append("└-") : s.append("|-");
        }
        last ? inc_indent() : inc_lindent();
        attached = true;
        last = false;
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("UseRead");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        s.append("\n" + indtd + "└-" + "id=");
        s.append(x.m_id);
        dec_indent();
        if ((bool&)x) { } // Suppress unused warning
    }
    void visit_ConcurrentControl(const ConcurrentControl_t &x) {
        if(!attached) {
            if(start_line) {
                start_line = false;
                s.append(indtd);
            } else {
                s.append("\n"+indtd);
            }
            last ? s.append("└-") : s.append("|-");
        }
        last ? inc_indent() : inc_lindent();
        attached = true;
        last = false;
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("ConcurrentControl");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        s.append("\n" + indtd + "|-" + "var=");
        if (x.m_var) {
            s.append(x.m_var);
        } else {
            s.append("()");
        }
        s.append("\n" + indtd + "|-" + "start=");
        if (x.m_start) {
            self().visit_expr(*x.m_start);
        } else {
            s.append("()");
        last = false;
        attached = false;
        }
        s.append("\n" + indtd + "|-" + "end=");
        if (x.m_end) {
            self().visit_expr(*x.m_end);
        } else {
            s.append("()");
        last = false;
        attached = false;
        }
        s.append("\n" + indtd + "└-" + "increment=");
        last = true;
        if (x.m_increment) {
            self().visit_expr(*x.m_increment);
        } else {
            s.append("()");
        last = false;
        attached = false;
        }
        dec_indent();
    }
    void visit_ConcurrentLocal(const ConcurrentLocal_t &x) {
        if(!attached) {
            if(start_line) {
                start_line = false;
                s.append(indtd);
            } else {
                s.append("\n"+indtd);
            }
            last ? s.append("└-") : s.append("|-");
        }
        last ? inc_indent() : inc_lindent();
        attached = true;
        last = false;
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("ConcurrentLocal");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        s.append("\n" + indtd + "└-" + "vars=");
        for (size_t i=0; i<x.n_vars; i++) {
            s.append(x.m_vars[i]);
            if (i < x.n_vars-1) s.append(" ");
        }
        dec_indent();
        if ((bool&)x) { } // Suppress unused warning
    }
    void visit_ConcurrentLocalInit(const ConcurrentLocalInit_t &x) {
        if(!attached) {
            if(start_line) {
                start_line = false;
                s.append(indtd);
            } else {
                s.append("\n"+indtd);
            }
            last ? s.append("└-") : s.append("|-");
        }
        last ? inc_indent() : inc_lindent();
        attached = true;
        last = false;
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("ConcurrentLocalInit");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        s.append("\n" + indtd + "└-" + "vars=");
        for (size_t i=0; i<x.n_vars; i++) {
            s.append(x.m_vars[i]);
            if (i < x.n_vars-1) s.append(" ");
        }
        dec_indent();
        if ((bool&)x) { } // Suppress unused warning
    }
    void visit_ConcurrentShared(const ConcurrentShared_t &x) {
        if(!attached) {
            if(start_line) {
                start_line = false;
                s.append(indtd);
            } else {
                s.append("\n"+indtd);
            }
            last ? s.append("└-") : s.append("|-");
        }
        last ? inc_indent() : inc_lindent();
        attached = true;
        last = false;
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("ConcurrentShared");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        s.append("\n" + indtd + "└-" + "vars=");
        for (size_t i=0; i<x.n_vars; i++) {
            s.append(x.m_vars[i]);
            if (i < x.n_vars-1) s.append(" ");
        }
        dec_indent();
        if ((bool&)x) { } // Suppress unused warning
    }
    void visit_ConcurrentDefault(const ConcurrentDefault_t &x) {
        if(!attached) {
            if(start_line) {
                start_line = false;
                s.append(indtd);
            } else {
                s.append("\n"+indtd);
            }
            last ? s.append("└-") : s.append("|-");
        }
        last ? inc_indent() : inc_lindent();
        attached = true;
        last = false;
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("ConcurrentDefault");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        dec_indent();
        if ((bool&)x) { } // Suppress unused warning
    }
    void visit_ConcurrentReduce(const ConcurrentReduce_t &x) {
        if(!attached) {
            if(start_line) {
                start_line = false;
                s.append(indtd);
            } else {
                s.append("\n"+indtd);
            }
            last ? s.append("└-") : s.append("|-");
        }
        last ? inc_indent() : inc_lindent();
        attached = true;
        last = false;
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("ConcurrentReduce");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        s.append("\n" + indtd + "|-" + "reduce_opType=");
        visit_reduce_opType(x.m_op);
        s.append("\n" + indtd + "└-" + "vars=");
        for (size_t i=0; i<x.n_vars; i++) {
            s.append(x.m_vars[i]);
            if (i < x.n_vars-1) s.append(" ");
        }
        dec_indent();
        if ((bool&)x) { } // Suppress unused warning
    }
    void visit_reduce_opType(const reduce_opType &x) {
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::green));
        }
        switch (x) {
            case (reduce_opType::ReduceAdd) : {
                s.append("ReduceAdd");
             break; }
            case (reduce_opType::ReduceMul) : {
                s.append("ReduceMul");
             break; }
            case (reduce_opType::ReduceMIN) : {
                s.append("ReduceMIN");
             break; }
            case (reduce_opType::ReduceMAX) : {
                s.append("ReduceMAX");
             break; }
        }
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
    }
    void visit_DataStmtSet(const DataStmtSet_t &x) {
        if(!attached) {
            if(start_line) {
                start_line = false;
                s.append(indtd);
            } else {
                s.append("\n"+indtd);
            }
            last ? s.append("└-") : s.append("|-");
        }
        last ? inc_indent() : inc_lindent();
        attached = true;
        last = false;
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("DataStmtSet");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        s.append("\n" + indtd + "|-" + "object=↧");
        for (size_t i=0; i<x.n_object; i++) {
            inc_lindent();
            last = i == x.n_object-1;
            attached = false;
            self().visit_expr(*x.m_object[i]);
            dec_indent();
        }
        s.append("\n" + indtd + "└-" + "value=↧");
        for (size_t i=0; i<x.n_value; i++) {
            inc_indent();
            last = i == x.n_value-1;
            attached = false;
            self().visit_expr(*x.m_value[i]);
            dec_indent();
        }
        dec_indent();
    }
    void visit_pragma_typeType(const pragma_typeType &x) {
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::green));
        }
        switch (x) {
            case (pragma_typeType::LFortranPragma) : {
                s.append("LFortranPragma");
             break; }
            case (pragma_typeType::OMPPragma) : {
                s.append("OMPPragma");
             break; }
        }
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
    }
    void visit_UnitRequire(const UnitRequire_t &x) {
        if(!attached) {
            if(start_line) {
                start_line = false;
                s.append(indtd);
            } else {
                s.append("\n"+indtd);
            }
            last ? s.append("└-") : s.append("|-");
        }
        last ? inc_indent() : inc_lindent();
        attached = true;
        last = false;
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("UnitRequire");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        s.append("\n" + indtd + "|-" + "name=");
        s.append(x.m_name);
        s.append("\n" + indtd + "└-" + "namelist=↧");
        for (size_t i=0; i<x.n_namelist; i++) {
            inc_indent();
            last = i == x.n_namelist-1;
            attached = false;
            self().visit_decl_attribute(*x.m_namelist[i]);
            dec_indent();
        }
        dec_indent();
    }
};


/******************************************************************************/
// Pickle Visitor base class

template <class Struct>
class PickleBaseVisitor : public BaseVisitor<Struct>
{
private:
    Struct& self() { return static_cast<Struct&>(*this); }
public:
    std::string s, indented = "";
    bool use_colors;
    bool indent;
    int indent_level = 0, indent_spaces = 4;
public:
    PickleBaseVisitor() : use_colors(false), indent(false) { s.reserve(100000); }
    void inc_indent() {
        indent_level++;
        indented = std::string(indent_level*indent_spaces, ' ');
    }
    void dec_indent() {
        indent_level--;
        LCOMPILERS_ASSERT(indent_level >= 0);
        indented = std::string(indent_level*indent_spaces, ' ');
    }
    void visit_TranslationUnit(const TranslationUnit_t &x) {
        s.append("(");
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("TranslationUnit");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        if(indent) {
            inc_indent();
            s.append("\n" + indented);
        } else {
            s.append(" ");
        }
        s.append("[");
        for (size_t i=0; i<x.n_items; i++) {
            self().visit_ast(*x.m_items[i]);
            if (i < x.n_items-1) {
                if (indent) s.append("\n" + indented);
                else s.append(" ");
            };
        }
        s.append("]");
        if(indent) {
            dec_indent();
            s.append("\n" + indented);
        }
        s.append(")");
        if ((bool&)x) { } // Suppress unused warning
    }
    void visit_Module(const Module_t &x) {
        s.append("(");
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("Module");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        if(indent) {
            inc_indent();
            s.append("\n" + indented);
        } else {
            s.append(" ");
        }
        s.append(x.m_name);
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        if (x.m_trivia) {
            self().visit_trivia(*x.m_trivia);
        } else {
            s.append("()");
        }
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        s.append("[");
        for (size_t i=0; i<x.n_use; i++) {
            self().visit_unit_decl1(*x.m_use[i]);
            if (i < x.n_use-1) {
                if (indent) s.append("\n" + indented);
                else s.append(" ");
            };
        }
        s.append("]");
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        s.append("[");
        for (size_t i=0; i<x.n_implicit; i++) {
            self().visit_implicit_statement(*x.m_implicit[i]);
            if (i < x.n_implicit-1) {
                if (indent) s.append("\n" + indented);
                else s.append(" ");
            };
        }
        s.append("]");
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        s.append("[");
        for (size_t i=0; i<x.n_decl; i++) {
            self().visit_unit_decl2(*x.m_decl[i]);
            if (i < x.n_decl-1) {
                if (indent) s.append("\n" + indented);
                else s.append(" ");
            };
        }
        s.append("]");
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        s.append("[");
        for (size_t i=0; i<x.n_contains; i++) {
            self().visit_program_unit(*x.m_contains[i]);
            if (i < x.n_contains-1) {
                if (indent) s.append("\n" + indented);
                else s.append(" ");
            };
        }
        s.append("]");
        if(indent) {
            dec_indent();
            s.append("\n" + indented);
        }
        s.append(")");
    }
    void visit_Submodule(const Submodule_t &x) {
        s.append("(");
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("Submodule");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        if(indent) {
            inc_indent();
            s.append("\n" + indented);
        } else {
            s.append(" ");
        }
        s.append(x.m_id);
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        if (x.m_parent_name) {
            s.append(x.m_parent_name);
        } else {
            s.append("()");
        }
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        s.append(x.m_name);
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        if (x.m_trivia) {
            self().visit_trivia(*x.m_trivia);
        } else {
            s.append("()");
        }
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        s.append("[");
        for (size_t i=0; i<x.n_use; i++) {
            self().visit_unit_decl1(*x.m_use[i]);
            if (i < x.n_use-1) {
                if (indent) s.append("\n" + indented);
                else s.append(" ");
            };
        }
        s.append("]");
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        s.append("[");
        for (size_t i=0; i<x.n_implicit; i++) {
            self().visit_implicit_statement(*x.m_implicit[i]);
            if (i < x.n_implicit-1) {
                if (indent) s.append("\n" + indented);
                else s.append(" ");
            };
        }
        s.append("]");
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        s.append("[");
        for (size_t i=0; i<x.n_decl; i++) {
            self().visit_unit_decl2(*x.m_decl[i]);
            if (i < x.n_decl-1) {
                if (indent) s.append("\n" + indented);
                else s.append(" ");
            };
        }
        s.append("]");
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        s.append("[");
        for (size_t i=0; i<x.n_contains; i++) {
            self().visit_program_unit(*x.m_contains[i]);
            if (i < x.n_contains-1) {
                if (indent) s.append("\n" + indented);
                else s.append(" ");
            };
        }
        s.append("]");
        if(indent) {
            dec_indent();
            s.append("\n" + indented);
        }
        s.append(")");
    }
    void visit_BlockData(const BlockData_t &x) {
        s.append("(");
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("BlockData");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        if(indent) {
            inc_indent();
            s.append("\n" + indented);
        } else {
            s.append(" ");
        }
        if (x.m_name) {
            s.append(x.m_name);
        } else {
            s.append("()");
        }
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        if (x.m_trivia) {
            self().visit_trivia(*x.m_trivia);
        } else {
            s.append("()");
        }
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        s.append("[");
        for (size_t i=0; i<x.n_use; i++) {
            self().visit_unit_decl1(*x.m_use[i]);
            if (i < x.n_use-1) {
                if (indent) s.append("\n" + indented);
                else s.append(" ");
            };
        }
        s.append("]");
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        s.append("[");
        for (size_t i=0; i<x.n_implicit; i++) {
            self().visit_implicit_statement(*x.m_implicit[i]);
            if (i < x.n_implicit-1) {
                if (indent) s.append("\n" + indented);
                else s.append(" ");
            };
        }
        s.append("]");
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        s.append("[");
        for (size_t i=0; i<x.n_decl; i++) {
            self().visit_unit_decl2(*x.m_decl[i]);
            if (i < x.n_decl-1) {
                if (indent) s.append("\n" + indented);
                else s.append(" ");
            };
        }
        s.append("]");
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        s.append("[");
        for (size_t i=0; i<x.n_body; i++) {
            self().visit_stmt(*x.m_body[i]);
            if (i < x.n_body-1) {
                if (indent) s.append("\n" + indented);
                else s.append(" ");
            };
        }
        s.append("]");
        if(indent) {
            dec_indent();
            s.append("\n" + indented);
        }
        s.append(")");
    }
    void visit_Program(const Program_t &x) {
        s.append("(");
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("Program");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        if(indent) {
            inc_indent();
            s.append("\n" + indented);
        } else {
            s.append(" ");
        }
        s.append(x.m_name);
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        if (x.m_trivia) {
            self().visit_trivia(*x.m_trivia);
        } else {
            s.append("()");
        }
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        s.append("[");
        for (size_t i=0; i<x.n_use; i++) {
            self().visit_unit_decl1(*x.m_use[i]);
            if (i < x.n_use-1) {
                if (indent) s.append("\n" + indented);
                else s.append(" ");
            };
        }
        s.append("]");
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        s.append("[");
        for (size_t i=0; i<x.n_implicit; i++) {
            self().visit_implicit_statement(*x.m_implicit[i]);
            if (i < x.n_implicit-1) {
                if (indent) s.append("\n" + indented);
                else s.append(" ");
            };
        }
        s.append("]");
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        s.append("[");
        for (size_t i=0; i<x.n_decl; i++) {
            self().visit_unit_decl2(*x.m_decl[i]);
            if (i < x.n_decl-1) {
                if (indent) s.append("\n" + indented);
                else s.append(" ");
            };
        }
        s.append("]");
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        s.append("[");
        for (size_t i=0; i<x.n_body; i++) {
            self().visit_stmt(*x.m_body[i]);
            if (i < x.n_body-1) {
                if (indent) s.append("\n" + indented);
                else s.append(" ");
            };
        }
        s.append("]");
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        s.append("[");
        for (size_t i=0; i<x.n_contains; i++) {
            self().visit_program_unit(*x.m_contains[i]);
            if (i < x.n_contains-1) {
                if (indent) s.append("\n" + indented);
                else s.append(" ");
            };
        }
        s.append("]");
        if(indent) {
            dec_indent();
            s.append("\n" + indented);
        }
        s.append(")");
    }
    void visit_Subroutine(const Subroutine_t &x) {
        s.append("(");
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("Subroutine");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        if(indent) {
            inc_indent();
            s.append("\n" + indented);
        } else {
            s.append(" ");
        }
        s.append(x.m_name);
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        s.append("[");
        for (size_t i=0; i<x.n_args; i++) {
            self().visit_arg(x.m_args[i]);
            if (i < x.n_args-1) {
                if (indent) s.append("\n" + indented);
                else s.append(" ");
            };
        }
        s.append("]");
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        s.append("[");
        for (size_t i=0; i<x.n_attributes; i++) {
            self().visit_decl_attribute(*x.m_attributes[i]);
            if (i < x.n_attributes-1) {
                if (indent) s.append("\n" + indented);
                else s.append(" ");
            };
        }
        s.append("]");
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        if (x.m_bind) {
            self().visit_bind(*x.m_bind);
        } else {
            s.append("()");
        }
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        if (x.m_trivia) {
            self().visit_trivia(*x.m_trivia);
        } else {
            s.append("()");
        }
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        s.append("[");
        for (size_t i=0; i<x.n_use; i++) {
            self().visit_unit_decl1(*x.m_use[i]);
            if (i < x.n_use-1) {
                if (indent) s.append("\n" + indented);
                else s.append(" ");
            };
        }
        s.append("]");
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        s.append("[");
        for (size_t i=0; i<x.n_import; i++) {
            self().visit_import_statement(*x.m_import[i]);
            if (i < x.n_import-1) {
                if (indent) s.append("\n" + indented);
                else s.append(" ");
            };
        }
        s.append("]");
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        s.append("[");
        for (size_t i=0; i<x.n_implicit; i++) {
            self().visit_implicit_statement(*x.m_implicit[i]);
            if (i < x.n_implicit-1) {
                if (indent) s.append("\n" + indented);
                else s.append(" ");
            };
        }
        s.append("]");
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        s.append("[");
        for (size_t i=0; i<x.n_decl; i++) {
            self().visit_unit_decl2(*x.m_decl[i]);
            if (i < x.n_decl-1) {
                if (indent) s.append("\n" + indented);
                else s.append(" ");
            };
        }
        s.append("]");
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        s.append("[");
        for (size_t i=0; i<x.n_body; i++) {
            self().visit_stmt(*x.m_body[i]);
            if (i < x.n_body-1) {
                if (indent) s.append("\n" + indented);
                else s.append(" ");
            };
        }
        s.append("]");
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        s.append("[");
        for (size_t i=0; i<x.n_contains; i++) {
            self().visit_program_unit(*x.m_contains[i]);
            if (i < x.n_contains-1) {
                if (indent) s.append("\n" + indented);
                else s.append(" ");
            };
        }
        s.append("]");
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        s.append("[");
        for (size_t i=0; i<x.n_temp_args; i++) {
            s.append(x.m_temp_args[i]);
            if (i < x.n_temp_args-1) {
                if (indent) s.append("\n" + indented);
                else s.append(" ");
            };
        }
        s.append("]");
        if(indent) {
            dec_indent();
            s.append("\n" + indented);
        }
        s.append(")");
    }
    void visit_Procedure(const Procedure_t &x) {
        s.append("(");
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("Procedure");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        if(indent) {
            inc_indent();
            s.append("\n" + indented);
        } else {
            s.append(" ");
        }
        s.append(x.m_name);
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        s.append("[");
        for (size_t i=0; i<x.n_args; i++) {
            self().visit_arg(x.m_args[i]);
            if (i < x.n_args-1) {
                if (indent) s.append("\n" + indented);
                else s.append(" ");
            };
        }
        s.append("]");
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        s.append("[");
        for (size_t i=0; i<x.n_attributes; i++) {
            self().visit_decl_attribute(*x.m_attributes[i]);
            if (i < x.n_attributes-1) {
                if (indent) s.append("\n" + indented);
                else s.append(" ");
            };
        }
        s.append("]");
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        if (x.m_trivia) {
            self().visit_trivia(*x.m_trivia);
        } else {
            s.append("()");
        }
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        s.append("[");
        for (size_t i=0; i<x.n_use; i++) {
            self().visit_unit_decl1(*x.m_use[i]);
            if (i < x.n_use-1) {
                if (indent) s.append("\n" + indented);
                else s.append(" ");
            };
        }
        s.append("]");
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        s.append("[");
        for (size_t i=0; i<x.n_import; i++) {
            self().visit_import_statement(*x.m_import[i]);
            if (i < x.n_import-1) {
                if (indent) s.append("\n" + indented);
                else s.append(" ");
            };
        }
        s.append("]");
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        s.append("[");
        for (size_t i=0; i<x.n_implicit; i++) {
            self().visit_implicit_statement(*x.m_implicit[i]);
            if (i < x.n_implicit-1) {
                if (indent) s.append("\n" + indented);
                else s.append(" ");
            };
        }
        s.append("]");
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        s.append("[");
        for (size_t i=0; i<x.n_decl; i++) {
            self().visit_unit_decl2(*x.m_decl[i]);
            if (i < x.n_decl-1) {
                if (indent) s.append("\n" + indented);
                else s.append(" ");
            };
        }
        s.append("]");
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        s.append("[");
        for (size_t i=0; i<x.n_body; i++) {
            self().visit_stmt(*x.m_body[i]);
            if (i < x.n_body-1) {
                if (indent) s.append("\n" + indented);
                else s.append(" ");
            };
        }
        s.append("]");
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        s.append("[");
        for (size_t i=0; i<x.n_contains; i++) {
            self().visit_program_unit(*x.m_contains[i]);
            if (i < x.n_contains-1) {
                if (indent) s.append("\n" + indented);
                else s.append(" ");
            };
        }
        s.append("]");
        if(indent) {
            dec_indent();
            s.append("\n" + indented);
        }
        s.append(")");
    }
    void visit_Function(const Function_t &x) {
        s.append("(");
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("Function");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        if(indent) {
            inc_indent();
            s.append("\n" + indented);
        } else {
            s.append(" ");
        }
        s.append(x.m_name);
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        s.append("[");
        for (size_t i=0; i<x.n_args; i++) {
            self().visit_arg(x.m_args[i]);
            if (i < x.n_args-1) {
                if (indent) s.append("\n" + indented);
                else s.append(" ");
            };
        }
        s.append("]");
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        s.append("[");
        for (size_t i=0; i<x.n_attributes; i++) {
            self().visit_decl_attribute(*x.m_attributes[i]);
            if (i < x.n_attributes-1) {
                if (indent) s.append("\n" + indented);
                else s.append(" ");
            };
        }
        s.append("]");
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        if (x.m_return_var) {
            self().visit_expr(*x.m_return_var);
        } else {
            s.append("()");
        }
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        if (x.m_bind) {
            self().visit_bind(*x.m_bind);
        } else {
            s.append("()");
        }
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        if (x.m_trivia) {
            self().visit_trivia(*x.m_trivia);
        } else {
            s.append("()");
        }
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        s.append("[");
        for (size_t i=0; i<x.n_use; i++) {
            self().visit_unit_decl1(*x.m_use[i]);
            if (i < x.n_use-1) {
                if (indent) s.append("\n" + indented);
                else s.append(" ");
            };
        }
        s.append("]");
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        s.append("[");
        for (size_t i=0; i<x.n_import; i++) {
            self().visit_import_statement(*x.m_import[i]);
            if (i < x.n_import-1) {
                if (indent) s.append("\n" + indented);
                else s.append(" ");
            };
        }
        s.append("]");
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        s.append("[");
        for (size_t i=0; i<x.n_implicit; i++) {
            self().visit_implicit_statement(*x.m_implicit[i]);
            if (i < x.n_implicit-1) {
                if (indent) s.append("\n" + indented);
                else s.append(" ");
            };
        }
        s.append("]");
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        s.append("[");
        for (size_t i=0; i<x.n_decl; i++) {
            self().visit_unit_decl2(*x.m_decl[i]);
            if (i < x.n_decl-1) {
                if (indent) s.append("\n" + indented);
                else s.append(" ");
            };
        }
        s.append("]");
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        s.append("[");
        for (size_t i=0; i<x.n_body; i++) {
            self().visit_stmt(*x.m_body[i]);
            if (i < x.n_body-1) {
                if (indent) s.append("\n" + indented);
                else s.append(" ");
            };
        }
        s.append("]");
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        s.append("[");
        for (size_t i=0; i<x.n_contains; i++) {
            self().visit_program_unit(*x.m_contains[i]);
            if (i < x.n_contains-1) {
                if (indent) s.append("\n" + indented);
                else s.append(" ");
            };
        }
        s.append("]");
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        s.append("[");
        for (size_t i=0; i<x.n_temp_args; i++) {
            s.append(x.m_temp_args[i]);
            if (i < x.n_temp_args-1) {
                if (indent) s.append("\n" + indented);
                else s.append(" ");
            };
        }
        s.append("]");
        if(indent) {
            dec_indent();
            s.append("\n" + indented);
        }
        s.append(")");
    }
    void visit_Use(const Use_t &x) {
        s.append("(");
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("Use");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        if(indent) {
            inc_indent();
            s.append("\n" + indented);
        } else {
            s.append(" ");
        }
        s.append("[");
        for (size_t i=0; i<x.n_nature; i++) {
            self().visit_decl_attribute(*x.m_nature[i]);
            if (i < x.n_nature-1) {
                if (indent) s.append("\n" + indented);
                else s.append(" ");
            };
        }
        s.append("]");
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        s.append(x.m_module);
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        s.append("[");
        for (size_t i=0; i<x.n_symbols; i++) {
            self().visit_use_symbol(*x.m_symbols[i]);
            if (i < x.n_symbols-1) {
                if (indent) s.append("\n" + indented);
                else s.append(" ");
            };
        }
        s.append("]");
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        if (x.m_only_present) {
            s.append(".true.");
        } else {
            s.append(".false.");
        }
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        if (x.m_trivia) {
            self().visit_trivia(*x.m_trivia);
        } else {
            s.append("()");
        }
        if(indent) {
            dec_indent();
            s.append("\n" + indented);
        }
        s.append(")");
    }
    void visit_Declaration(const Declaration_t &x) {
        s.append("(");
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("Declaration");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        if(indent) {
            inc_indent();
            s.append("\n" + indented);
        } else {
            s.append(" ");
        }
        if (x.m_vartype) {
            self().visit_decl_attribute(*x.m_vartype);
        } else {
            s.append("()");
        }
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        s.append("[");
        for (size_t i=0; i<x.n_attributes; i++) {
            self().visit_decl_attribute(*x.m_attributes[i]);
            if (i < x.n_attributes-1) {
                if (indent) s.append("\n" + indented);
                else s.append(" ");
            };
        }
        s.append("]");
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        s.append("[");
        for (size_t i=0; i<x.n_syms; i++) {
            self().visit_var_sym(x.m_syms[i]);
            if (i < x.n_syms-1) {
                if (indent) s.append("\n" + indented);
                else s.append(" ");
            };
        }
        s.append("]");
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        if (x.m_trivia) {
            self().visit_trivia(*x.m_trivia);
        } else {
            s.append("()");
        }
        if(indent) {
            dec_indent();
            s.append("\n" + indented);
        }
        s.append(")");
    }
    void visit_DeclarationPragma(const DeclarationPragma_t &x) {
        s.append("(");
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("DeclarationPragma");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        if(indent) {
            inc_indent();
            s.append("\n" + indented);
        } else {
            s.append(" ");
        }
        visit_pragma_typeType(x.m_type);
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        s.append("\"" + str_escape_c(x.m_text) + "\"");
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        if (x.m_trivia) {
            self().visit_trivia(*x.m_trivia);
        } else {
            s.append("()");
        }
        if(indent) {
            dec_indent();
            s.append("\n" + indented);
        }
        s.append(")");
    }
    void visit_Interface(const Interface_t &x) {
        s.append("(");
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("Interface");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        if(indent) {
            inc_indent();
            s.append("\n" + indented);
        } else {
            s.append(" ");
        }
        self().visit_interface_header(*x.m_header);
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        if (x.m_trivia) {
            self().visit_trivia(*x.m_trivia);
        } else {
            s.append("()");
        }
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        s.append("[");
        for (size_t i=0; i<x.n_items; i++) {
            self().visit_interface_item(*x.m_items[i]);
            if (i < x.n_items-1) {
                if (indent) s.append("\n" + indented);
                else s.append(" ");
            };
        }
        s.append("]");
        if(indent) {
            dec_indent();
            s.append("\n" + indented);
        }
        s.append(")");
    }
    void visit_DerivedType(const DerivedType_t &x) {
        s.append("(");
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("DerivedType");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        if(indent) {
            inc_indent();
            s.append("\n" + indented);
        } else {
            s.append(" ");
        }
        s.append(x.m_name);
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        s.append("[");
        for (size_t i=0; i<x.n_namelist; i++) {
            s.append(x.m_namelist[i]);
            if (i < x.n_namelist-1) {
                if (indent) s.append("\n" + indented);
                else s.append(" ");
            };
        }
        s.append("]");
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        if (x.m_trivia) {
            self().visit_trivia(*x.m_trivia);
        } else {
            s.append("()");
        }
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        s.append("[");
        for (size_t i=0; i<x.n_attrtype; i++) {
            self().visit_decl_attribute(*x.m_attrtype[i]);
            if (i < x.n_attrtype-1) {
                if (indent) s.append("\n" + indented);
                else s.append(" ");
            };
        }
        s.append("]");
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        s.append("[");
        for (size_t i=0; i<x.n_items; i++) {
            self().visit_unit_decl2(*x.m_items[i]);
            if (i < x.n_items-1) {
                if (indent) s.append("\n" + indented);
                else s.append(" ");
            };
        }
        s.append("]");
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        s.append("[");
        for (size_t i=0; i<x.n_contains; i++) {
            self().visit_procedure_decl(*x.m_contains[i]);
            if (i < x.n_contains-1) {
                if (indent) s.append("\n" + indented);
                else s.append(" ");
            };
        }
        s.append("]");
        if(indent) {
            dec_indent();
            s.append("\n" + indented);
        }
        s.append(")");
    }
    void visit_Template(const Template_t &x) {
        s.append("(");
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("Template");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        if(indent) {
            inc_indent();
            s.append("\n" + indented);
        } else {
            s.append(" ");
        }
        s.append(x.m_name);
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        s.append("[");
        for (size_t i=0; i<x.n_namelist; i++) {
            s.append(x.m_namelist[i]);
            if (i < x.n_namelist-1) {
                if (indent) s.append("\n" + indented);
                else s.append(" ");
            };
        }
        s.append("]");
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        s.append("[");
        for (size_t i=0; i<x.n_decl; i++) {
            self().visit_unit_decl2(*x.m_decl[i]);
            if (i < x.n_decl-1) {
                if (indent) s.append("\n" + indented);
                else s.append(" ");
            };
        }
        s.append("]");
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        s.append("[");
        for (size_t i=0; i<x.n_contains; i++) {
            self().visit_program_unit(*x.m_contains[i]);
            if (i < x.n_contains-1) {
                if (indent) s.append("\n" + indented);
                else s.append(" ");
            };
        }
        s.append("]");
        if(indent) {
            dec_indent();
            s.append("\n" + indented);
        }
        s.append(")");
    }
    void visit_Enum(const Enum_t &x) {
        s.append("(");
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("Enum");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        if(indent) {
            inc_indent();
            s.append("\n" + indented);
        } else {
            s.append(" ");
        }
        s.append("[");
        for (size_t i=0; i<x.n_attr; i++) {
            self().visit_decl_attribute(*x.m_attr[i]);
            if (i < x.n_attr-1) {
                if (indent) s.append("\n" + indented);
                else s.append(" ");
            };
        }
        s.append("]");
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        if (x.m_trivia) {
            self().visit_trivia(*x.m_trivia);
        } else {
            s.append("()");
        }
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        s.append("[");
        for (size_t i=0; i<x.n_items; i++) {
            self().visit_unit_decl2(*x.m_items[i]);
            if (i < x.n_items-1) {
                if (indent) s.append("\n" + indented);
                else s.append(" ");
            };
        }
        s.append("]");
        if(indent) {
            dec_indent();
            s.append("\n" + indented);
        }
        s.append(")");
    }
    void visit_Instantiate(const Instantiate_t &x) {
        s.append("(");
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("Instantiate");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        if(indent) {
            inc_indent();
            s.append("\n" + indented);
        } else {
            s.append(" ");
        }
        s.append(x.m_name);
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        s.append("[");
        for (size_t i=0; i<x.n_args; i++) {
            self().visit_decl_attribute(*x.m_args[i]);
            if (i < x.n_args-1) {
                if (indent) s.append("\n" + indented);
                else s.append(" ");
            };
        }
        s.append("]");
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        s.append("[");
        for (size_t i=0; i<x.n_symbols; i++) {
            self().visit_use_symbol(*x.m_symbols[i]);
            if (i < x.n_symbols-1) {
                if (indent) s.append("\n" + indented);
                else s.append(" ");
            };
        }
        s.append("]");
        if(indent) {
            dec_indent();
            s.append("\n" + indented);
        }
        s.append(")");
    }
    void visit_Requirement(const Requirement_t &x) {
        s.append("(");
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("Requirement");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        if(indent) {
            inc_indent();
            s.append("\n" + indented);
        } else {
            s.append(" ");
        }
        s.append(x.m_name);
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        s.append("[");
        for (size_t i=0; i<x.n_namelist; i++) {
            s.append(x.m_namelist[i]);
            if (i < x.n_namelist-1) {
                if (indent) s.append("\n" + indented);
                else s.append(" ");
            };
        }
        s.append("]");
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        s.append("[");
        for (size_t i=0; i<x.n_decl; i++) {
            self().visit_unit_decl2(*x.m_decl[i]);
            if (i < x.n_decl-1) {
                if (indent) s.append("\n" + indented);
                else s.append(" ");
            };
        }
        s.append("]");
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        s.append("[");
        for (size_t i=0; i<x.n_funcs; i++) {
            self().visit_program_unit(*x.m_funcs[i]);
            if (i < x.n_funcs-1) {
                if (indent) s.append("\n" + indented);
                else s.append(" ");
            };
        }
        s.append("]");
        if(indent) {
            dec_indent();
            s.append("\n" + indented);
        }
        s.append(")");
    }
    void visit_Require(const Require_t &x) {
        s.append("(");
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("Require");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        if(indent) {
            inc_indent();
            s.append("\n" + indented);
        } else {
            s.append(" ");
        }
        s.append("[");
        for (size_t i=0; i<x.n_reqs; i++) {
            self().visit_unit_require(*x.m_reqs[i]);
            if (i < x.n_reqs-1) {
                if (indent) s.append("\n" + indented);
                else s.append(" ");
            };
        }
        s.append("]");
        if(indent) {
            dec_indent();
            s.append("\n" + indented);
        }
        s.append(")");
    }
    void visit_InterfaceHeader(const InterfaceHeader_t &x) {
        s.append("(");
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("InterfaceHeader");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        s.append(")");
        if ((bool&)x) { } // Suppress unused warning
    }
    void visit_InterfaceHeaderName(const InterfaceHeaderName_t &x) {
        s.append("(");
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("InterfaceHeaderName");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        if(indent) {
            inc_indent();
            s.append("\n" + indented);
        } else {
            s.append(" ");
        }
        s.append(x.m_name);
        if(indent) {
            dec_indent();
            s.append("\n" + indented);
        }
        s.append(")");
        if ((bool&)x) { } // Suppress unused warning
    }
    void visit_InterfaceHeaderAssignment(const InterfaceHeaderAssignment_t &x) {
        s.append("(");
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("InterfaceHeaderAssignment");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        s.append(")");
        if ((bool&)x) { } // Suppress unused warning
    }
    void visit_InterfaceHeaderOperator(const InterfaceHeaderOperator_t &x) {
        s.append("(");
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("InterfaceHeaderOperator");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        if(indent) {
            inc_indent();
            s.append("\n" + indented);
        } else {
            s.append(" ");
        }
        visit_intrinsicopType(x.m_op);
        if(indent) {
            dec_indent();
            s.append("\n" + indented);
        }
        s.append(")");
        if ((bool&)x) { } // Suppress unused warning
    }
    void visit_InterfaceHeaderDefinedOperator(const InterfaceHeaderDefinedOperator_t &x) {
        s.append("(");
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("InterfaceHeaderDefinedOperator");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        if(indent) {
            inc_indent();
            s.append("\n" + indented);
        } else {
            s.append(" ");
        }
        s.append("\"" + str_escape_c(x.m_operator_name) + "\"");
        if(indent) {
            dec_indent();
            s.append("\n" + indented);
        }
        s.append(")");
        if ((bool&)x) { } // Suppress unused warning
    }
    void visit_AbstractInterfaceHeader(const AbstractInterfaceHeader_t &x) {
        s.append("(");
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("AbstractInterfaceHeader");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        s.append(")");
        if ((bool&)x) { } // Suppress unused warning
    }
    void visit_InterfaceHeaderWrite(const InterfaceHeaderWrite_t &x) {
        s.append("(");
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("InterfaceHeaderWrite");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        if(indent) {
            inc_indent();
            s.append("\n" + indented);
        } else {
            s.append(" ");
        }
        s.append(x.m_id);
        if(indent) {
            dec_indent();
            s.append("\n" + indented);
        }
        s.append(")");
        if ((bool&)x) { } // Suppress unused warning
    }
    void visit_InterfaceHeaderRead(const InterfaceHeaderRead_t &x) {
        s.append("(");
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("InterfaceHeaderRead");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        if(indent) {
            inc_indent();
            s.append("\n" + indented);
        } else {
            s.append(" ");
        }
        s.append(x.m_id);
        if(indent) {
            dec_indent();
            s.append("\n" + indented);
        }
        s.append(")");
        if ((bool&)x) { } // Suppress unused warning
    }
    void visit_InterfaceProc(const InterfaceProc_t &x) {
        s.append("(");
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("InterfaceProc");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        if(indent) {
            inc_indent();
            s.append("\n" + indented);
        } else {
            s.append(" ");
        }
        self().visit_program_unit(*x.m_proc);
        if(indent) {
            dec_indent();
            s.append("\n" + indented);
        }
        s.append(")");
    }
    void visit_InterfaceModuleProcedure(const InterfaceModuleProcedure_t &x) {
        s.append("(");
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("InterfaceModuleProcedure");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        if(indent) {
            inc_indent();
            s.append("\n" + indented);
        } else {
            s.append(" ");
        }
        s.append("[");
        for (size_t i=0; i<x.n_names; i++) {
            s.append(x.m_names[i]);
            if (i < x.n_names-1) {
                if (indent) s.append("\n" + indented);
                else s.append(" ");
            };
        }
        s.append("]");
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        s.append("[");
        for (size_t i=0; i<x.n_attributes; i++) {
            self().visit_decl_attribute(*x.m_attributes[i]);
            if (i < x.n_attributes-1) {
                if (indent) s.append("\n" + indented);
                else s.append(" ");
            };
        }
        s.append("]");
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        if (x.m_trivia) {
            self().visit_trivia(*x.m_trivia);
        } else {
            s.append("()");
        }
        if(indent) {
            dec_indent();
            s.append("\n" + indented);
        }
        s.append(")");
    }
    void visit_Import(const Import_t &x) {
        s.append("(");
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("Import");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        if(indent) {
            inc_indent();
            s.append("\n" + indented);
        } else {
            s.append(" ");
        }
        s.append("[");
        for (size_t i=0; i<x.n_symbols; i++) {
            s.append(x.m_symbols[i]);
            if (i < x.n_symbols-1) {
                if (indent) s.append("\n" + indented);
                else s.append(" ");
            };
        }
        s.append("]");
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        visit_import_modifierType(x.m_mod);
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        if (x.m_trivia) {
            self().visit_trivia(*x.m_trivia);
        } else {
            s.append("()");
        }
        if(indent) {
            dec_indent();
            s.append("\n" + indented);
        }
        s.append(")");
    }
    void visit_import_modifierType(const import_modifierType &x) {
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::green));
        }
        switch (x) {
            case (import_modifierType::ImportDefault) : {
                s.append("ImportDefault");
             break; }
            case (import_modifierType::ImportOnly) : {
                s.append("ImportOnly");
             break; }
            case (import_modifierType::ImportNone) : {
                s.append("ImportNone");
             break; }
            case (import_modifierType::ImportAll) : {
                s.append("ImportAll");
             break; }
        }
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
    }
    void visit_ImplicitNone(const ImplicitNone_t &x) {
        s.append("(");
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("ImplicitNone");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        if(indent) {
            inc_indent();
            s.append("\n" + indented);
        } else {
            s.append(" ");
        }
        s.append("[");
        for (size_t i=0; i<x.n_specs; i++) {
            self().visit_implicit_none_spec(*x.m_specs[i]);
            if (i < x.n_specs-1) {
                if (indent) s.append("\n" + indented);
                else s.append(" ");
            };
        }
        s.append("]");
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        if (x.m_trivia) {
            self().visit_trivia(*x.m_trivia);
        } else {
            s.append("()");
        }
        if(indent) {
            dec_indent();
            s.append("\n" + indented);
        }
        s.append(")");
    }
    void visit_Implicit(const Implicit_t &x) {
        s.append("(");
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("Implicit");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        if(indent) {
            inc_indent();
            s.append("\n" + indented);
        } else {
            s.append(" ");
        }
        self().visit_decl_attribute(*x.m_type);
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        s.append("[");
        for (size_t i=0; i<x.n_kind; i++) {
            self().visit_letter_spec(*x.m_kind[i]);
            if (i < x.n_kind-1) {
                if (indent) s.append("\n" + indented);
                else s.append(" ");
            };
        }
        s.append("]");
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        s.append("[");
        for (size_t i=0; i<x.n_specs; i++) {
            self().visit_letter_spec(*x.m_specs[i]);
            if (i < x.n_specs-1) {
                if (indent) s.append("\n" + indented);
                else s.append(" ");
            };
        }
        s.append("]");
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        if (x.m_trivia) {
            self().visit_trivia(*x.m_trivia);
        } else {
            s.append("()");
        }
        if(indent) {
            dec_indent();
            s.append("\n" + indented);
        }
        s.append(")");
    }
    void visit_ImplicitNoneExternal(const ImplicitNoneExternal_t &x) {
        s.append("(");
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("ImplicitNoneExternal");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        if(indent) {
            inc_indent();
            s.append("\n" + indented);
        } else {
            s.append(" ");
        }
        s.append(std::to_string(x.m_dummy));
        if(indent) {
            dec_indent();
            s.append("\n" + indented);
        }
        s.append(")");
        if ((bool&)x) { } // Suppress unused warning
    }
    void visit_ImplicitNoneType(const ImplicitNoneType_t &x) {
        s.append("(");
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("ImplicitNoneType");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        s.append(")");
        if ((bool&)x) { } // Suppress unused warning
    }
    void visit_LetterSpec(const LetterSpec_t &x) {
        s.append("(");
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("LetterSpec");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        if(indent) {
            inc_indent();
            s.append("\n" + indented);
        } else {
            s.append(" ");
        }
        if (x.m_start) {
            s.append(x.m_start);
        } else {
            s.append("()");
        }
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        s.append(x.m_end);
        if(indent) {
            dec_indent();
            s.append("\n" + indented);
        }
        s.append(")");
        if ((bool&)x) { } // Suppress unused warning
    }
    void visit_Allocate(const Allocate_t &x) {
        s.append("(");
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("Allocate");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        if(indent) {
            inc_indent();
            s.append("\n" + indented);
        } else {
            s.append(" ");
        }
        s.append(std::to_string(x.m_label));
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        s.append("[");
        for (size_t i=0; i<x.n_args; i++) {
            self().visit_fnarg(x.m_args[i]);
            if (i < x.n_args-1) {
                if (indent) s.append("\n" + indented);
                else s.append(" ");
            };
        }
        s.append("]");
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        s.append("[");
        for (size_t i=0; i<x.n_keywords; i++) {
            self().visit_keyword(x.m_keywords[i]);
            if (i < x.n_keywords-1) {
                if (indent) s.append("\n" + indented);
                else s.append(" ");
            };
        }
        s.append("]");
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        if (x.m_trivia) {
            self().visit_trivia(*x.m_trivia);
        } else {
            s.append("()");
        }
        if(indent) {
            dec_indent();
            s.append("\n" + indented);
        }
        s.append(")");
    }
    void visit_Assign(const Assign_t &x) {
        s.append("(");
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("Assign");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        if(indent) {
            inc_indent();
            s.append("\n" + indented);
        } else {
            s.append(" ");
        }
        s.append(std::to_string(x.m_label));
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        s.append(std::to_string(x.m_assign_label));
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        s.append(x.m_variable);
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        if (x.m_trivia) {
            self().visit_trivia(*x.m_trivia);
        } else {
            s.append("()");
        }
        if(indent) {
            dec_indent();
            s.append("\n" + indented);
        }
        s.append(")");
    }
    void visit_Assignment(const Assignment_t &x) {
        s.append("(");
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("Assignment");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        if(indent) {
            inc_indent();
            s.append("\n" + indented);
        } else {
            s.append(" ");
        }
        s.append(std::to_string(x.m_label));
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        self().visit_expr(*x.m_target);
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        self().visit_expr(*x.m_value);
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        if (x.m_trivia) {
            self().visit_trivia(*x.m_trivia);
        } else {
            s.append("()");
        }
        if(indent) {
            dec_indent();
            s.append("\n" + indented);
        }
        s.append(")");
    }
    void visit_Associate(const Associate_t &x) {
        s.append("(");
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("Associate");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        if(indent) {
            inc_indent();
            s.append("\n" + indented);
        } else {
            s.append(" ");
        }
        s.append(std::to_string(x.m_label));
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        self().visit_expr(*x.m_target);
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        self().visit_expr(*x.m_value);
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        if (x.m_trivia) {
            self().visit_trivia(*x.m_trivia);
        } else {
            s.append("()");
        }
        if(indent) {
            dec_indent();
            s.append("\n" + indented);
        }
        s.append(")");
    }
    void visit_Backspace(const Backspace_t &x) {
        s.append("(");
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("Backspace");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        if(indent) {
            inc_indent();
            s.append("\n" + indented);
        } else {
            s.append(" ");
        }
        s.append(std::to_string(x.m_label));
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        s.append("[");
        for (size_t i=0; i<x.n_args; i++) {
            self().visit_expr(*x.m_args[i]);
            if (i < x.n_args-1) {
                if (indent) s.append("\n" + indented);
                else s.append(" ");
            };
        }
        s.append("]");
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        s.append("[");
        for (size_t i=0; i<x.n_kwargs; i++) {
            self().visit_keyword(x.m_kwargs[i]);
            if (i < x.n_kwargs-1) {
                if (indent) s.append("\n" + indented);
                else s.append(" ");
            };
        }
        s.append("]");
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        if (x.m_trivia) {
            self().visit_trivia(*x.m_trivia);
        } else {
            s.append("()");
        }
        if(indent) {
            dec_indent();
            s.append("\n" + indented);
        }
        s.append(")");
    }
    void visit_Close(const Close_t &x) {
        s.append("(");
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("Close");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        if(indent) {
            inc_indent();
            s.append("\n" + indented);
        } else {
            s.append(" ");
        }
        s.append(std::to_string(x.m_label));
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        s.append("[");
        for (size_t i=0; i<x.n_args; i++) {
            self().visit_expr(*x.m_args[i]);
            if (i < x.n_args-1) {
                if (indent) s.append("\n" + indented);
                else s.append(" ");
            };
        }
        s.append("]");
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        s.append("[");
        for (size_t i=0; i<x.n_kwargs; i++) {
            self().visit_keyword(x.m_kwargs[i]);
            if (i < x.n_kwargs-1) {
                if (indent) s.append("\n" + indented);
                else s.append(" ");
            };
        }
        s.append("]");
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        if (x.m_trivia) {
            self().visit_trivia(*x.m_trivia);
        } else {
            s.append("()");
        }
        if(indent) {
            dec_indent();
            s.append("\n" + indented);
        }
        s.append(")");
    }
    void visit_Continue(const Continue_t &x) {
        s.append("(");
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("Continue");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        if(indent) {
            inc_indent();
            s.append("\n" + indented);
        } else {
            s.append(" ");
        }
        s.append(std::to_string(x.m_label));
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        if (x.m_trivia) {
            self().visit_trivia(*x.m_trivia);
        } else {
            s.append("()");
        }
        if(indent) {
            dec_indent();
            s.append("\n" + indented);
        }
        s.append(")");
    }
    void visit_Cycle(const Cycle_t &x) {
        s.append("(");
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("Cycle");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        if(indent) {
            inc_indent();
            s.append("\n" + indented);
        } else {
            s.append(" ");
        }
        s.append(std::to_string(x.m_label));
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        if (x.m_stmt_name) {
            s.append(x.m_stmt_name);
        } else {
            s.append("()");
        }
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        if (x.m_trivia) {
            self().visit_trivia(*x.m_trivia);
        } else {
            s.append("()");
        }
        if(indent) {
            dec_indent();
            s.append("\n" + indented);
        }
        s.append(")");
    }
    void visit_Deallocate(const Deallocate_t &x) {
        s.append("(");
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("Deallocate");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        if(indent) {
            inc_indent();
            s.append("\n" + indented);
        } else {
            s.append(" ");
        }
        s.append(std::to_string(x.m_label));
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        s.append("[");
        for (size_t i=0; i<x.n_args; i++) {
            self().visit_fnarg(x.m_args[i]);
            if (i < x.n_args-1) {
                if (indent) s.append("\n" + indented);
                else s.append(" ");
            };
        }
        s.append("]");
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        s.append("[");
        for (size_t i=0; i<x.n_keywords; i++) {
            self().visit_keyword(x.m_keywords[i]);
            if (i < x.n_keywords-1) {
                if (indent) s.append("\n" + indented);
                else s.append(" ");
            };
        }
        s.append("]");
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        if (x.m_trivia) {
            self().visit_trivia(*x.m_trivia);
        } else {
            s.append("()");
        }
        if(indent) {
            dec_indent();
            s.append("\n" + indented);
        }
        s.append(")");
    }
    void visit_Endfile(const Endfile_t &x) {
        s.append("(");
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("Endfile");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        if(indent) {
            inc_indent();
            s.append("\n" + indented);
        } else {
            s.append(" ");
        }
        s.append(std::to_string(x.m_label));
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        s.append("[");
        for (size_t i=0; i<x.n_args; i++) {
            self().visit_expr(*x.m_args[i]);
            if (i < x.n_args-1) {
                if (indent) s.append("\n" + indented);
                else s.append(" ");
            };
        }
        s.append("]");
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        s.append("[");
        for (size_t i=0; i<x.n_kwargs; i++) {
            self().visit_keyword(x.m_kwargs[i]);
            if (i < x.n_kwargs-1) {
                if (indent) s.append("\n" + indented);
                else s.append(" ");
            };
        }
        s.append("]");
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        if (x.m_trivia) {
            self().visit_trivia(*x.m_trivia);
        } else {
            s.append("()");
        }
        if(indent) {
            dec_indent();
            s.append("\n" + indented);
        }
        s.append(")");
    }
    void visit_Entry(const Entry_t &x) {
        s.append("(");
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("Entry");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        if(indent) {
            inc_indent();
            s.append("\n" + indented);
        } else {
            s.append(" ");
        }
        s.append(std::to_string(x.m_label));
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        s.append(x.m_name);
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        s.append("[");
        for (size_t i=0; i<x.n_args; i++) {
            self().visit_arg(x.m_args[i]);
            if (i < x.n_args-1) {
                if (indent) s.append("\n" + indented);
                else s.append(" ");
            };
        }
        s.append("]");
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        if (x.m_return_var) {
            self().visit_expr(*x.m_return_var);
        } else {
            s.append("()");
        }
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        if (x.m_bind) {
            self().visit_bind(*x.m_bind);
        } else {
            s.append("()");
        }
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        if (x.m_trivia) {
            self().visit_trivia(*x.m_trivia);
        } else {
            s.append("()");
        }
        if(indent) {
            dec_indent();
            s.append("\n" + indented);
        }
        s.append(")");
    }
    void visit_ErrorStop(const ErrorStop_t &x) {
        s.append("(");
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("ErrorStop");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        if(indent) {
            inc_indent();
            s.append("\n" + indented);
        } else {
            s.append(" ");
        }
        s.append(std::to_string(x.m_label));
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        if (x.m_code) {
            self().visit_expr(*x.m_code);
        } else {
            s.append("()");
        }
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        if (x.m_quiet) {
            self().visit_expr(*x.m_quiet);
        } else {
            s.append("()");
        }
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        if (x.m_trivia) {
            self().visit_trivia(*x.m_trivia);
        } else {
            s.append("()");
        }
        if(indent) {
            dec_indent();
            s.append("\n" + indented);
        }
        s.append(")");
    }
    void visit_EventPost(const EventPost_t &x) {
        s.append("(");
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("EventPost");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        if(indent) {
            inc_indent();
            s.append("\n" + indented);
        } else {
            s.append(" ");
        }
        s.append(std::to_string(x.m_label));
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        self().visit_expr(*x.m_variable);
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        s.append("[");
        for (size_t i=0; i<x.n_stat; i++) {
            self().visit_event_attribute(*x.m_stat[i]);
            if (i < x.n_stat-1) {
                if (indent) s.append("\n" + indented);
                else s.append(" ");
            };
        }
        s.append("]");
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        if (x.m_trivia) {
            self().visit_trivia(*x.m_trivia);
        } else {
            s.append("()");
        }
        if(indent) {
            dec_indent();
            s.append("\n" + indented);
        }
        s.append(")");
    }
    void visit_EventWait(const EventWait_t &x) {
        s.append("(");
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("EventWait");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        if(indent) {
            inc_indent();
            s.append("\n" + indented);
        } else {
            s.append(" ");
        }
        s.append(std::to_string(x.m_label));
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        self().visit_expr(*x.m_variable);
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        s.append("[");
        for (size_t i=0; i<x.n_spec; i++) {
            self().visit_event_attribute(*x.m_spec[i]);
            if (i < x.n_spec-1) {
                if (indent) s.append("\n" + indented);
                else s.append(" ");
            };
        }
        s.append("]");
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        if (x.m_trivia) {
            self().visit_trivia(*x.m_trivia);
        } else {
            s.append("()");
        }
        if(indent) {
            dec_indent();
            s.append("\n" + indented);
        }
        s.append(")");
    }
    void visit_Exit(const Exit_t &x) {
        s.append("(");
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("Exit");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        if(indent) {
            inc_indent();
            s.append("\n" + indented);
        } else {
            s.append(" ");
        }
        s.append(std::to_string(x.m_label));
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        if (x.m_stmt_name) {
            s.append(x.m_stmt_name);
        } else {
            s.append("()");
        }
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        if (x.m_trivia) {
            self().visit_trivia(*x.m_trivia);
        } else {
            s.append("()");
        }
        if(indent) {
            dec_indent();
            s.append("\n" + indented);
        }
        s.append(")");
    }
    void visit_Flush(const Flush_t &x) {
        s.append("(");
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("Flush");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        if(indent) {
            inc_indent();
            s.append("\n" + indented);
        } else {
            s.append(" ");
        }
        s.append(std::to_string(x.m_label));
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        s.append("[");
        for (size_t i=0; i<x.n_args; i++) {
            self().visit_expr(*x.m_args[i]);
            if (i < x.n_args-1) {
                if (indent) s.append("\n" + indented);
                else s.append(" ");
            };
        }
        s.append("]");
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        s.append("[");
        for (size_t i=0; i<x.n_kwargs; i++) {
            self().visit_keyword(x.m_kwargs[i]);
            if (i < x.n_kwargs-1) {
                if (indent) s.append("\n" + indented);
                else s.append(" ");
            };
        }
        s.append("]");
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        if (x.m_trivia) {
            self().visit_trivia(*x.m_trivia);
        } else {
            s.append("()");
        }
        if(indent) {
            dec_indent();
            s.append("\n" + indented);
        }
        s.append(")");
    }
    void visit_ForAllSingle(const ForAllSingle_t &x) {
        s.append("(");
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("ForAllSingle");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        if(indent) {
            inc_indent();
            s.append("\n" + indented);
        } else {
            s.append(" ");
        }
        s.append(std::to_string(x.m_label));
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        if (x.m_stmt_name) {
            s.append(x.m_stmt_name);
        } else {
            s.append("()");
        }
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        s.append("[");
        for (size_t i=0; i<x.n_control; i++) {
            self().visit_concurrent_control(*x.m_control[i]);
            if (i < x.n_control-1) {
                if (indent) s.append("\n" + indented);
                else s.append(" ");
            };
        }
        s.append("]");
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        if (x.m_mask) {
            self().visit_expr(*x.m_mask);
        } else {
            s.append("()");
        }
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        self().visit_stmt(*x.m_assign);
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        if (x.m_trivia) {
            self().visit_trivia(*x.m_trivia);
        } else {
            s.append("()");
        }
        if(indent) {
            dec_indent();
            s.append("\n" + indented);
        }
        s.append(")");
    }
    void visit_Format(const Format_t &x) {
        s.append("(");
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("Format");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        if(indent) {
            inc_indent();
            s.append("\n" + indented);
        } else {
            s.append(" ");
        }
        s.append(std::to_string(x.m_label));
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        s.append("\"" + str_escape_c(x.m_fmt) + "\"");
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        if (x.m_trivia) {
            self().visit_trivia(*x.m_trivia);
        } else {
            s.append("()");
        }
        if(indent) {
            dec_indent();
            s.append("\n" + indented);
        }
        s.append(")");
    }
    void visit_DataStmt(const DataStmt_t &x) {
        s.append("(");
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("DataStmt");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        if(indent) {
            inc_indent();
            s.append("\n" + indented);
        } else {
            s.append(" ");
        }
        s.append(std::to_string(x.m_label));
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        s.append("[");
        for (size_t i=0; i<x.n_items; i++) {
            self().visit_data_stmt_set(*x.m_items[i]);
            if (i < x.n_items-1) {
                if (indent) s.append("\n" + indented);
                else s.append(" ");
            };
        }
        s.append("]");
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        if (x.m_trivia) {
            self().visit_trivia(*x.m_trivia);
        } else {
            s.append("()");
        }
        if(indent) {
            dec_indent();
            s.append("\n" + indented);
        }
        s.append(")");
    }
    void visit_FormTeam(const FormTeam_t &x) {
        s.append("(");
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("FormTeam");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        if(indent) {
            inc_indent();
            s.append("\n" + indented);
        } else {
            s.append(" ");
        }
        s.append(std::to_string(x.m_label));
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        self().visit_expr(*x.m_team_number);
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        s.append(x.m_team_var);
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        s.append("[");
        for (size_t i=0; i<x.n_sync_stat; i++) {
            self().visit_event_attribute(*x.m_sync_stat[i]);
            if (i < x.n_sync_stat-1) {
                if (indent) s.append("\n" + indented);
                else s.append(" ");
            };
        }
        s.append("]");
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        if (x.m_trivia) {
            self().visit_trivia(*x.m_trivia);
        } else {
            s.append("()");
        }
        if(indent) {
            dec_indent();
            s.append("\n" + indented);
        }
        s.append(")");
    }
    void visit_GoTo(const GoTo_t &x) {
        s.append("(");
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("GoTo");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        if(indent) {
            inc_indent();
            s.append("\n" + indented);
        } else {
            s.append(" ");
        }
        s.append(std::to_string(x.m_label));
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        if (x.m_int_var) {
            s.append(x.m_int_var);
        } else {
            s.append("()");
        }
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        if (x.m_goto_label) {
            self().visit_expr(*x.m_goto_label);
        } else {
            s.append("()");
        }
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        s.append("[");
        for (size_t i=0; i<x.n_labels; i++) {
            self().visit_expr(*x.m_labels[i]);
            if (i < x.n_labels-1) {
                if (indent) s.append("\n" + indented);
                else s.append(" ");
            };
        }
        s.append("]");
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        if (x.m_trivia) {
            self().visit_trivia(*x.m_trivia);
        } else {
            s.append("()");
        }
        if(indent) {
            dec_indent();
            s.append("\n" + indented);
        }
        s.append(")");
    }
    void visit_Include(const Include_t &x) {
        s.append("(");
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("Include");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        if(indent) {
            inc_indent();
            s.append("\n" + indented);
        } else {
            s.append(" ");
        }
        s.append(std::to_string(x.m_label));
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        s.append("\"" + str_escape_c(x.m_filename) + "\"");
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        if (x.m_trivia) {
            self().visit_trivia(*x.m_trivia);
        } else {
            s.append("()");
        }
        if(indent) {
            dec_indent();
            s.append("\n" + indented);
        }
        s.append(")");
    }
    void visit_Inquire(const Inquire_t &x) {
        s.append("(");
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("Inquire");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        if(indent) {
            inc_indent();
            s.append("\n" + indented);
        } else {
            s.append(" ");
        }
        s.append(std::to_string(x.m_label));
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        s.append("[");
        for (size_t i=0; i<x.n_args; i++) {
            self().visit_expr(*x.m_args[i]);
            if (i < x.n_args-1) {
                if (indent) s.append("\n" + indented);
                else s.append(" ");
            };
        }
        s.append("]");
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        s.append("[");
        for (size_t i=0; i<x.n_kwargs; i++) {
            self().visit_keyword(x.m_kwargs[i]);
            if (i < x.n_kwargs-1) {
                if (indent) s.append("\n" + indented);
                else s.append(" ");
            };
        }
        s.append("]");
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        s.append("[");
        for (size_t i=0; i<x.n_values; i++) {
            self().visit_expr(*x.m_values[i]);
            if (i < x.n_values-1) {
                if (indent) s.append("\n" + indented);
                else s.append(" ");
            };
        }
        s.append("]");
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        if (x.m_trivia) {
            self().visit_trivia(*x.m_trivia);
        } else {
            s.append("()");
        }
        if(indent) {
            dec_indent();
            s.append("\n" + indented);
        }
        s.append(")");
    }
    void visit_Nullify(const Nullify_t &x) {
        s.append("(");
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("Nullify");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        if(indent) {
            inc_indent();
            s.append("\n" + indented);
        } else {
            s.append(" ");
        }
        s.append(std::to_string(x.m_label));
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        s.append("[");
        for (size_t i=0; i<x.n_args; i++) {
            self().visit_expr(*x.m_args[i]);
            if (i < x.n_args-1) {
                if (indent) s.append("\n" + indented);
                else s.append(" ");
            };
        }
        s.append("]");
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        s.append("[");
        for (size_t i=0; i<x.n_kwargs; i++) {
            self().visit_keyword(x.m_kwargs[i]);
            if (i < x.n_kwargs-1) {
                if (indent) s.append("\n" + indented);
                else s.append(" ");
            };
        }
        s.append("]");
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        if (x.m_trivia) {
            self().visit_trivia(*x.m_trivia);
        } else {
            s.append("()");
        }
        if(indent) {
            dec_indent();
            s.append("\n" + indented);
        }
        s.append(")");
    }
    void visit_Open(const Open_t &x) {
        s.append("(");
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("Open");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        if(indent) {
            inc_indent();
            s.append("\n" + indented);
        } else {
            s.append(" ");
        }
        s.append(std::to_string(x.m_label));
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        s.append("[");
        for (size_t i=0; i<x.n_args; i++) {
            self().visit_expr(*x.m_args[i]);
            if (i < x.n_args-1) {
                if (indent) s.append("\n" + indented);
                else s.append(" ");
            };
        }
        s.append("]");
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        s.append("[");
        for (size_t i=0; i<x.n_kwargs; i++) {
            self().visit_keyword(x.m_kwargs[i]);
            if (i < x.n_kwargs-1) {
                if (indent) s.append("\n" + indented);
                else s.append(" ");
            };
        }
        s.append("]");
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        if (x.m_trivia) {
            self().visit_trivia(*x.m_trivia);
        } else {
            s.append("()");
        }
        if(indent) {
            dec_indent();
            s.append("\n" + indented);
        }
        s.append(")");
    }
    void visit_Return(const Return_t &x) {
        s.append("(");
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("Return");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        if(indent) {
            inc_indent();
            s.append("\n" + indented);
        } else {
            s.append(" ");
        }
        s.append(std::to_string(x.m_label));
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        if (x.m_value) {
            self().visit_expr(*x.m_value);
        } else {
            s.append("()");
        }
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        if (x.m_trivia) {
            self().visit_trivia(*x.m_trivia);
        } else {
            s.append("()");
        }
        if(indent) {
            dec_indent();
            s.append("\n" + indented);
        }
        s.append(")");
    }
    void visit_Pragma(const Pragma_t &x) {
        s.append("(");
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("Pragma");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        if(indent) {
            inc_indent();
            s.append("\n" + indented);
        } else {
            s.append(" ");
        }
        s.append(std::to_string(x.m_label));
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        visit_pragma_typeType(x.m_type);
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        if (x.m_end) {
            s.append(".true.");
        } else {
            s.append(".false.");
        }
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        s.append("\"" + str_escape_c(x.m_construct_name) + "\"");
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        s.append("[");
        for (size_t i=0; i<x.n_clauses; i++) {
            self().visit_expr(*x.m_clauses[i]);
            if (i < x.n_clauses-1) {
                if (indent) s.append("\n" + indented);
                else s.append(" ");
            };
        }
        s.append("]");
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        if (x.m_trivia) {
            self().visit_trivia(*x.m_trivia);
        } else {
            s.append("()");
        }
        if(indent) {
            dec_indent();
            s.append("\n" + indented);
        }
        s.append(")");
    }
    void visit_Print(const Print_t &x) {
        s.append("(");
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("Print");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        if(indent) {
            inc_indent();
            s.append("\n" + indented);
        } else {
            s.append(" ");
        }
        s.append(std::to_string(x.m_label));
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        if (x.m_fmt) {
            self().visit_expr(*x.m_fmt);
        } else {
            s.append("()");
        }
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        s.append("[");
        for (size_t i=0; i<x.n_values; i++) {
            self().visit_expr(*x.m_values[i]);
            if (i < x.n_values-1) {
                if (indent) s.append("\n" + indented);
                else s.append(" ");
            };
        }
        s.append("]");
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        if (x.m_trivia) {
            self().visit_trivia(*x.m_trivia);
        } else {
            s.append("()");
        }
        if(indent) {
            dec_indent();
            s.append("\n" + indented);
        }
        s.append(")");
    }
    void visit_Read(const Read_t &x) {
        s.append("(");
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("Read");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        if(indent) {
            inc_indent();
            s.append("\n" + indented);
        } else {
            s.append(" ");
        }
        s.append(std::to_string(x.m_label));
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        if (x.m_format) {
            self().visit_expr(*x.m_format);
        } else {
            s.append("()");
        }
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        s.append("[");
        for (size_t i=0; i<x.n_args; i++) {
            self().visit_argstar(x.m_args[i]);
            if (i < x.n_args-1) {
                if (indent) s.append("\n" + indented);
                else s.append(" ");
            };
        }
        s.append("]");
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        s.append("[");
        for (size_t i=0; i<x.n_kwargs; i++) {
            self().visit_kw_argstar(x.m_kwargs[i]);
            if (i < x.n_kwargs-1) {
                if (indent) s.append("\n" + indented);
                else s.append(" ");
            };
        }
        s.append("]");
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        s.append("[");
        for (size_t i=0; i<x.n_values; i++) {
            self().visit_expr(*x.m_values[i]);
            if (i < x.n_values-1) {
                if (indent) s.append("\n" + indented);
                else s.append(" ");
            };
        }
        s.append("]");
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        if (x.m_trivia) {
            self().visit_trivia(*x.m_trivia);
        } else {
            s.append("()");
        }
        if(indent) {
            dec_indent();
            s.append("\n" + indented);
        }
        s.append(")");
    }
    void visit_Rewind(const Rewind_t &x) {
        s.append("(");
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("Rewind");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        if(indent) {
            inc_indent();
            s.append("\n" + indented);
        } else {
            s.append(" ");
        }
        s.append(std::to_string(x.m_label));
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        s.append("[");
        for (size_t i=0; i<x.n_args; i++) {
            self().visit_expr(*x.m_args[i]);
            if (i < x.n_args-1) {
                if (indent) s.append("\n" + indented);
                else s.append(" ");
            };
        }
        s.append("]");
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        s.append("[");
        for (size_t i=0; i<x.n_kwargs; i++) {
            self().visit_keyword(x.m_kwargs[i]);
            if (i < x.n_kwargs-1) {
                if (indent) s.append("\n" + indented);
                else s.append(" ");
            };
        }
        s.append("]");
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        if (x.m_trivia) {
            self().visit_trivia(*x.m_trivia);
        } else {
            s.append("()");
        }
        if(indent) {
            dec_indent();
            s.append("\n" + indented);
        }
        s.append(")");
    }
    void visit_Stop(const Stop_t &x) {
        s.append("(");
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("Stop");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        if(indent) {
            inc_indent();
            s.append("\n" + indented);
        } else {
            s.append(" ");
        }
        s.append(std::to_string(x.m_label));
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        if (x.m_code) {
            self().visit_expr(*x.m_code);
        } else {
            s.append("()");
        }
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        if (x.m_quiet) {
            self().visit_expr(*x.m_quiet);
        } else {
            s.append("()");
        }
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        if (x.m_trivia) {
            self().visit_trivia(*x.m_trivia);
        } else {
            s.append("()");
        }
        if(indent) {
            dec_indent();
            s.append("\n" + indented);
        }
        s.append(")");
    }
    void visit_SubroutineCall(const SubroutineCall_t &x) {
        s.append("(");
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("SubroutineCall");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        if(indent) {
            inc_indent();
            s.append("\n" + indented);
        } else {
            s.append(" ");
        }
        s.append(std::to_string(x.m_label));
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        s.append(x.m_name);
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        s.append("[");
        for (size_t i=0; i<x.n_member; i++) {
            self().visit_struct_member(x.m_member[i]);
            if (i < x.n_member-1) {
                if (indent) s.append("\n" + indented);
                else s.append(" ");
            };
        }
        s.append("]");
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        s.append("[");
        for (size_t i=0; i<x.n_args; i++) {
            self().visit_fnarg(x.m_args[i]);
            if (i < x.n_args-1) {
                if (indent) s.append("\n" + indented);
                else s.append(" ");
            };
        }
        s.append("]");
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        s.append("[");
        for (size_t i=0; i<x.n_keywords; i++) {
            self().visit_keyword(x.m_keywords[i]);
            if (i < x.n_keywords-1) {
                if (indent) s.append("\n" + indented);
                else s.append(" ");
            };
        }
        s.append("]");
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        s.append("[");
        for (size_t i=0; i<x.n_temp_args; i++) {
            self().visit_decl_attribute(*x.m_temp_args[i]);
            if (i < x.n_temp_args-1) {
                if (indent) s.append("\n" + indented);
                else s.append(" ");
            };
        }
        s.append("]");
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        if (x.m_trivia) {
            self().visit_trivia(*x.m_trivia);
        } else {
            s.append("()");
        }
        if(indent) {
            dec_indent();
            s.append("\n" + indented);
        }
        s.append(")");
    }
    void visit_SyncAll(const SyncAll_t &x) {
        s.append("(");
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("SyncAll");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        if(indent) {
            inc_indent();
            s.append("\n" + indented);
        } else {
            s.append(" ");
        }
        s.append(std::to_string(x.m_label));
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        s.append("[");
        for (size_t i=0; i<x.n_stat; i++) {
            self().visit_event_attribute(*x.m_stat[i]);
            if (i < x.n_stat-1) {
                if (indent) s.append("\n" + indented);
                else s.append(" ");
            };
        }
        s.append("]");
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        if (x.m_trivia) {
            self().visit_trivia(*x.m_trivia);
        } else {
            s.append("()");
        }
        if(indent) {
            dec_indent();
            s.append("\n" + indented);
        }
        s.append(")");
    }
    void visit_SyncImages(const SyncImages_t &x) {
        s.append("(");
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("SyncImages");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        if(indent) {
            inc_indent();
            s.append("\n" + indented);
        } else {
            s.append(" ");
        }
        s.append(std::to_string(x.m_label));
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        if (x.m_image_set) {
            self().visit_expr(*x.m_image_set);
        } else {
            s.append("()");
        }
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        visit_symbolType(x.m_sym);
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        s.append("[");
        for (size_t i=0; i<x.n_stat; i++) {
            self().visit_event_attribute(*x.m_stat[i]);
            if (i < x.n_stat-1) {
                if (indent) s.append("\n" + indented);
                else s.append(" ");
            };
        }
        s.append("]");
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        if (x.m_trivia) {
            self().visit_trivia(*x.m_trivia);
        } else {
            s.append("()");
        }
        if(indent) {
            dec_indent();
            s.append("\n" + indented);
        }
        s.append(")");
    }
    void visit_SyncMemory(const SyncMemory_t &x) {
        s.append("(");
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("SyncMemory");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        if(indent) {
            inc_indent();
            s.append("\n" + indented);
        } else {
            s.append(" ");
        }
        s.append(std::to_string(x.m_label));
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        s.append("[");
        for (size_t i=0; i<x.n_stat; i++) {
            self().visit_event_attribute(*x.m_stat[i]);
            if (i < x.n_stat-1) {
                if (indent) s.append("\n" + indented);
                else s.append(" ");
            };
        }
        s.append("]");
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        if (x.m_trivia) {
            self().visit_trivia(*x.m_trivia);
        } else {
            s.append("()");
        }
        if(indent) {
            dec_indent();
            s.append("\n" + indented);
        }
        s.append(")");
    }
    void visit_SyncTeam(const SyncTeam_t &x) {
        s.append("(");
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("SyncTeam");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        if(indent) {
            inc_indent();
            s.append("\n" + indented);
        } else {
            s.append(" ");
        }
        s.append(std::to_string(x.m_label));
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        self().visit_expr(*x.m_value);
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        s.append("[");
        for (size_t i=0; i<x.n_stat; i++) {
            self().visit_event_attribute(*x.m_stat[i]);
            if (i < x.n_stat-1) {
                if (indent) s.append("\n" + indented);
                else s.append(" ");
            };
        }
        s.append("]");
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        if (x.m_trivia) {
            self().visit_trivia(*x.m_trivia);
        } else {
            s.append("()");
        }
        if(indent) {
            dec_indent();
            s.append("\n" + indented);
        }
        s.append(")");
    }
    void visit_Write(const Write_t &x) {
        s.append("(");
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("Write");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        if(indent) {
            inc_indent();
            s.append("\n" + indented);
        } else {
            s.append(" ");
        }
        s.append(std::to_string(x.m_label));
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        s.append("[");
        for (size_t i=0; i<x.n_args; i++) {
            self().visit_argstar(x.m_args[i]);
            if (i < x.n_args-1) {
                if (indent) s.append("\n" + indented);
                else s.append(" ");
            };
        }
        s.append("]");
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        s.append("[");
        for (size_t i=0; i<x.n_kwargs; i++) {
            self().visit_kw_argstar(x.m_kwargs[i]);
            if (i < x.n_kwargs-1) {
                if (indent) s.append("\n" + indented);
                else s.append(" ");
            };
        }
        s.append("]");
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        s.append("[");
        for (size_t i=0; i<x.n_values; i++) {
            self().visit_expr(*x.m_values[i]);
            if (i < x.n_values-1) {
                if (indent) s.append("\n" + indented);
                else s.append(" ");
            };
        }
        s.append("]");
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        if (x.m_trivia) {
            self().visit_trivia(*x.m_trivia);
        } else {
            s.append("()");
        }
        if(indent) {
            dec_indent();
            s.append("\n" + indented);
        }
        s.append(")");
    }
    void visit_AssociateBlock(const AssociateBlock_t &x) {
        s.append("(");
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("AssociateBlock");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        if(indent) {
            inc_indent();
            s.append("\n" + indented);
        } else {
            s.append(" ");
        }
        s.append(std::to_string(x.m_label));
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        if (x.m_stmt_name) {
            s.append(x.m_stmt_name);
        } else {
            s.append("()");
        }
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        s.append("[");
        for (size_t i=0; i<x.n_syms; i++) {
            self().visit_var_sym(x.m_syms[i]);
            if (i < x.n_syms-1) {
                if (indent) s.append("\n" + indented);
                else s.append(" ");
            };
        }
        s.append("]");
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        s.append("[");
        for (size_t i=0; i<x.n_body; i++) {
            self().visit_stmt(*x.m_body[i]);
            if (i < x.n_body-1) {
                if (indent) s.append("\n" + indented);
                else s.append(" ");
            };
        }
        s.append("]");
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        if (x.m_t_inside) {
            self().visit_trivia(*x.m_t_inside);
        } else {
            s.append("()");
        }
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        if (x.m_trivia) {
            self().visit_trivia(*x.m_trivia);
        } else {
            s.append("()");
        }
        if(indent) {
            dec_indent();
            s.append("\n" + indented);
        }
        s.append(")");
    }
    void visit_Block(const Block_t &x) {
        s.append("(");
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("Block");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        if(indent) {
            inc_indent();
            s.append("\n" + indented);
        } else {
            s.append(" ");
        }
        s.append(std::to_string(x.m_label));
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        if (x.m_stmt_name) {
            s.append(x.m_stmt_name);
        } else {
            s.append("()");
        }
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        s.append("[");
        for (size_t i=0; i<x.n_use; i++) {
            self().visit_unit_decl1(*x.m_use[i]);
            if (i < x.n_use-1) {
                if (indent) s.append("\n" + indented);
                else s.append(" ");
            };
        }
        s.append("]");
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        s.append("[");
        for (size_t i=0; i<x.n_import; i++) {
            self().visit_import_statement(*x.m_import[i]);
            if (i < x.n_import-1) {
                if (indent) s.append("\n" + indented);
                else s.append(" ");
            };
        }
        s.append("]");
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        s.append("[");
        for (size_t i=0; i<x.n_decl; i++) {
            self().visit_unit_decl2(*x.m_decl[i]);
            if (i < x.n_decl-1) {
                if (indent) s.append("\n" + indented);
                else s.append(" ");
            };
        }
        s.append("]");
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        s.append("[");
        for (size_t i=0; i<x.n_body; i++) {
            self().visit_stmt(*x.m_body[i]);
            if (i < x.n_body-1) {
                if (indent) s.append("\n" + indented);
                else s.append(" ");
            };
        }
        s.append("]");
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        if (x.m_t_inside) {
            self().visit_trivia(*x.m_t_inside);
        } else {
            s.append("()");
        }
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        if (x.m_trivia) {
            self().visit_trivia(*x.m_trivia);
        } else {
            s.append("()");
        }
        if(indent) {
            dec_indent();
            s.append("\n" + indented);
        }
        s.append(")");
    }
    void visit_ChangeTeam(const ChangeTeam_t &x) {
        s.append("(");
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("ChangeTeam");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        if(indent) {
            inc_indent();
            s.append("\n" + indented);
        } else {
            s.append(" ");
        }
        s.append(std::to_string(x.m_label));
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        if (x.m_stmt_name) {
            s.append(x.m_stmt_name);
        } else {
            s.append("()");
        }
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        self().visit_expr(*x.m_team_value);
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        s.append("[");
        for (size_t i=0; i<x.n_coarray_assoc; i++) {
            self().visit_team_attribute(*x.m_coarray_assoc[i]);
            if (i < x.n_coarray_assoc-1) {
                if (indent) s.append("\n" + indented);
                else s.append(" ");
            };
        }
        s.append("]");
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        s.append("[");
        for (size_t i=0; i<x.n_sync; i++) {
            self().visit_event_attribute(*x.m_sync[i]);
            if (i < x.n_sync-1) {
                if (indent) s.append("\n" + indented);
                else s.append(" ");
            };
        }
        s.append("]");
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        s.append("[");
        for (size_t i=0; i<x.n_body; i++) {
            self().visit_stmt(*x.m_body[i]);
            if (i < x.n_body-1) {
                if (indent) s.append("\n" + indented);
                else s.append(" ");
            };
        }
        s.append("]");
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        if (x.m_t_inside) {
            self().visit_trivia(*x.m_t_inside);
        } else {
            s.append("()");
        }
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        if (x.m_trivia) {
            self().visit_trivia(*x.m_trivia);
        } else {
            s.append("()");
        }
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        s.append("[");
        for (size_t i=0; i<x.n_sync_stat; i++) {
            self().visit_event_attribute(*x.m_sync_stat[i]);
            if (i < x.n_sync_stat-1) {
                if (indent) s.append("\n" + indented);
                else s.append(" ");
            };
        }
        s.append("]");
        if(indent) {
            dec_indent();
            s.append("\n" + indented);
        }
        s.append(")");
    }
    void visit_Critical(const Critical_t &x) {
        s.append("(");
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("Critical");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        if(indent) {
            inc_indent();
            s.append("\n" + indented);
        } else {
            s.append(" ");
        }
        s.append(std::to_string(x.m_label));
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        if (x.m_stmt_name) {
            s.append(x.m_stmt_name);
        } else {
            s.append("()");
        }
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        s.append("[");
        for (size_t i=0; i<x.n_sync_stat; i++) {
            self().visit_event_attribute(*x.m_sync_stat[i]);
            if (i < x.n_sync_stat-1) {
                if (indent) s.append("\n" + indented);
                else s.append(" ");
            };
        }
        s.append("]");
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        s.append("[");
        for (size_t i=0; i<x.n_body; i++) {
            self().visit_stmt(*x.m_body[i]);
            if (i < x.n_body-1) {
                if (indent) s.append("\n" + indented);
                else s.append(" ");
            };
        }
        s.append("]");
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        if (x.m_t_inside) {
            self().visit_trivia(*x.m_t_inside);
        } else {
            s.append("()");
        }
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        if (x.m_trivia) {
            self().visit_trivia(*x.m_trivia);
        } else {
            s.append("()");
        }
        if(indent) {
            dec_indent();
            s.append("\n" + indented);
        }
        s.append(")");
    }
    void visit_DoConcurrentLoop(const DoConcurrentLoop_t &x) {
        s.append("(");
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("DoConcurrentLoop");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        if(indent) {
            inc_indent();
            s.append("\n" + indented);
        } else {
            s.append(" ");
        }
        s.append(std::to_string(x.m_label));
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        if (x.m_stmt_name) {
            s.append(x.m_stmt_name);
        } else {
            s.append("()");
        }
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        s.append("[");
        for (size_t i=0; i<x.n_control; i++) {
            self().visit_concurrent_control(*x.m_control[i]);
            if (i < x.n_control-1) {
                if (indent) s.append("\n" + indented);
                else s.append(" ");
            };
        }
        s.append("]");
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        if (x.m_mask) {
            self().visit_expr(*x.m_mask);
        } else {
            s.append("()");
        }
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        s.append("[");
        for (size_t i=0; i<x.n_locality; i++) {
            self().visit_concurrent_locality(*x.m_locality[i]);
            if (i < x.n_locality-1) {
                if (indent) s.append("\n" + indented);
                else s.append(" ");
            };
        }
        s.append("]");
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        s.append("[");
        for (size_t i=0; i<x.n_body; i++) {
            self().visit_stmt(*x.m_body[i]);
            if (i < x.n_body-1) {
                if (indent) s.append("\n" + indented);
                else s.append(" ");
            };
        }
        s.append("]");
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        if (x.m_t_inside) {
            self().visit_trivia(*x.m_t_inside);
        } else {
            s.append("()");
        }
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        if (x.m_trivia) {
            self().visit_trivia(*x.m_trivia);
        } else {
            s.append("()");
        }
        if(indent) {
            dec_indent();
            s.append("\n" + indented);
        }
        s.append(")");
    }
    void visit_DoLoop(const DoLoop_t &x) {
        s.append("(");
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("DoLoop");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        if(indent) {
            inc_indent();
            s.append("\n" + indented);
        } else {
            s.append(" ");
        }
        s.append(std::to_string(x.m_label));
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        if (x.m_stmt_name) {
            s.append(x.m_stmt_name);
        } else {
            s.append("()");
        }
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        s.append(std::to_string(x.m_do_label));
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        if (x.m_var) {
            s.append(x.m_var);
        } else {
            s.append("()");
        }
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        if (x.m_start) {
            self().visit_expr(*x.m_start);
        } else {
            s.append("()");
        }
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        if (x.m_end) {
            self().visit_expr(*x.m_end);
        } else {
            s.append("()");
        }
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        if (x.m_increment) {
            self().visit_expr(*x.m_increment);
        } else {
            s.append("()");
        }
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        s.append("[");
        for (size_t i=0; i<x.n_body; i++) {
            self().visit_stmt(*x.m_body[i]);
            if (i < x.n_body-1) {
                if (indent) s.append("\n" + indented);
                else s.append(" ");
            };
        }
        s.append("]");
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        if (x.m_t_inside) {
            self().visit_trivia(*x.m_t_inside);
        } else {
            s.append("()");
        }
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        if (x.m_trivia) {
            self().visit_trivia(*x.m_trivia);
        } else {
            s.append("()");
        }
        if(indent) {
            dec_indent();
            s.append("\n" + indented);
        }
        s.append(")");
    }
    void visit_ForAll(const ForAll_t &x) {
        s.append("(");
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("ForAll");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        if(indent) {
            inc_indent();
            s.append("\n" + indented);
        } else {
            s.append(" ");
        }
        s.append(std::to_string(x.m_label));
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        if (x.m_stmt_name) {
            s.append(x.m_stmt_name);
        } else {
            s.append("()");
        }
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        s.append("[");
        for (size_t i=0; i<x.n_control; i++) {
            self().visit_concurrent_control(*x.m_control[i]);
            if (i < x.n_control-1) {
                if (indent) s.append("\n" + indented);
                else s.append(" ");
            };
        }
        s.append("]");
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        if (x.m_mask) {
            self().visit_expr(*x.m_mask);
        } else {
            s.append("()");
        }
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        s.append("[");
        for (size_t i=0; i<x.n_locality; i++) {
            self().visit_concurrent_locality(*x.m_locality[i]);
            if (i < x.n_locality-1) {
                if (indent) s.append("\n" + indented);
                else s.append(" ");
            };
        }
        s.append("]");
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        s.append("[");
        for (size_t i=0; i<x.n_body; i++) {
            self().visit_stmt(*x.m_body[i]);
            if (i < x.n_body-1) {
                if (indent) s.append("\n" + indented);
                else s.append(" ");
            };
        }
        s.append("]");
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        if (x.m_t_inside) {
            self().visit_trivia(*x.m_t_inside);
        } else {
            s.append("()");
        }
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        if (x.m_trivia) {
            self().visit_trivia(*x.m_trivia);
        } else {
            s.append("()");
        }
        if(indent) {
            dec_indent();
            s.append("\n" + indented);
        }
        s.append(")");
    }
    void visit_If(const If_t &x) {
        s.append("(");
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("If");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        if(indent) {
            inc_indent();
            s.append("\n" + indented);
        } else {
            s.append(" ");
        }
        s.append(std::to_string(x.m_label));
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        if (x.m_stmt_name) {
            s.append(x.m_stmt_name);
        } else {
            s.append("()");
        }
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        self().visit_expr(*x.m_test);
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        s.append("[");
        for (size_t i=0; i<x.n_body; i++) {
            self().visit_stmt(*x.m_body[i]);
            if (i < x.n_body-1) {
                if (indent) s.append("\n" + indented);
                else s.append(" ");
            };
        }
        s.append("]");
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        s.append("[");
        for (size_t i=0; i<x.n_orelse; i++) {
            self().visit_stmt(*x.m_orelse[i]);
            if (i < x.n_orelse-1) {
                if (indent) s.append("\n" + indented);
                else s.append(" ");
            };
        }
        s.append("]");
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        if (x.m_if_trivia) {
            self().visit_trivia(*x.m_if_trivia);
        } else {
            s.append("()");
        }
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        if (x.m_else_trivia) {
            self().visit_trivia(*x.m_else_trivia);
        } else {
            s.append("()");
        }
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        if (x.m_trivia) {
            self().visit_trivia(*x.m_trivia);
        } else {
            s.append("()");
        }
        if(indent) {
            dec_indent();
            s.append("\n" + indented);
        }
        s.append(")");
    }
    void visit_IfArithmetic(const IfArithmetic_t &x) {
        s.append("(");
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("IfArithmetic");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        if(indent) {
            inc_indent();
            s.append("\n" + indented);
        } else {
            s.append(" ");
        }
        s.append(std::to_string(x.m_label));
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        if (x.m_stmt_name) {
            s.append(x.m_stmt_name);
        } else {
            s.append("()");
        }
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        self().visit_expr(*x.m_test);
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        s.append(std::to_string(x.m_lt_label));
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        s.append(std::to_string(x.m_eq_label));
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        s.append(std::to_string(x.m_gt_label));
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        if (x.m_trivia) {
            self().visit_trivia(*x.m_trivia);
        } else {
            s.append("()");
        }
        if(indent) {
            dec_indent();
            s.append("\n" + indented);
        }
        s.append(")");
    }
    void visit_Select(const Select_t &x) {
        s.append("(");
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("Select");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        if(indent) {
            inc_indent();
            s.append("\n" + indented);
        } else {
            s.append(" ");
        }
        s.append(std::to_string(x.m_label));
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        if (x.m_stmt_name) {
            s.append(x.m_stmt_name);
        } else {
            s.append("()");
        }
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        self().visit_expr(*x.m_test);
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        s.append("[");
        for (size_t i=0; i<x.n_body; i++) {
            self().visit_case_stmt(*x.m_body[i]);
            if (i < x.n_body-1) {
                if (indent) s.append("\n" + indented);
                else s.append(" ");
            };
        }
        s.append("]");
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        if (x.m_t_inside) {
            self().visit_trivia(*x.m_t_inside);
        } else {
            s.append("()");
        }
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        if (x.m_trivia) {
            self().visit_trivia(*x.m_trivia);
        } else {
            s.append("()");
        }
        if(indent) {
            dec_indent();
            s.append("\n" + indented);
        }
        s.append(")");
    }
    void visit_SelectRank(const SelectRank_t &x) {
        s.append("(");
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("SelectRank");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        if(indent) {
            inc_indent();
            s.append("\n" + indented);
        } else {
            s.append(" ");
        }
        s.append(std::to_string(x.m_label));
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        if (x.m_stmt_name) {
            s.append(x.m_stmt_name);
        } else {
            s.append("()");
        }
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        if (x.m_assoc_name) {
            s.append(x.m_assoc_name);
        } else {
            s.append("()");
        }
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        self().visit_expr(*x.m_selector);
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        s.append("[");
        for (size_t i=0; i<x.n_body; i++) {
            self().visit_rank_stmt(*x.m_body[i]);
            if (i < x.n_body-1) {
                if (indent) s.append("\n" + indented);
                else s.append(" ");
            };
        }
        s.append("]");
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        if (x.m_t_inside) {
            self().visit_trivia(*x.m_t_inside);
        } else {
            s.append("()");
        }
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        if (x.m_trivia) {
            self().visit_trivia(*x.m_trivia);
        } else {
            s.append("()");
        }
        if(indent) {
            dec_indent();
            s.append("\n" + indented);
        }
        s.append(")");
    }
    void visit_SelectType(const SelectType_t &x) {
        s.append("(");
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("SelectType");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        if(indent) {
            inc_indent();
            s.append("\n" + indented);
        } else {
            s.append(" ");
        }
        s.append(std::to_string(x.m_label));
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        if (x.m_stmt_name) {
            s.append(x.m_stmt_name);
        } else {
            s.append("()");
        }
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        if (x.m_assoc_name) {
            s.append(x.m_assoc_name);
        } else {
            s.append("()");
        }
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        self().visit_expr(*x.m_selector);
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        s.append("[");
        for (size_t i=0; i<x.n_body; i++) {
            self().visit_type_stmt(*x.m_body[i]);
            if (i < x.n_body-1) {
                if (indent) s.append("\n" + indented);
                else s.append(" ");
            };
        }
        s.append("]");
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        if (x.m_t_inside) {
            self().visit_trivia(*x.m_t_inside);
        } else {
            s.append("()");
        }
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        if (x.m_trivia) {
            self().visit_trivia(*x.m_trivia);
        } else {
            s.append("()");
        }
        if(indent) {
            dec_indent();
            s.append("\n" + indented);
        }
        s.append(")");
    }
    void visit_Where(const Where_t &x) {
        s.append("(");
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("Where");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        if(indent) {
            inc_indent();
            s.append("\n" + indented);
        } else {
            s.append(" ");
        }
        s.append(std::to_string(x.m_label));
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        if (x.m_stmt_name) {
            s.append(x.m_stmt_name);
        } else {
            s.append("()");
        }
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        self().visit_expr(*x.m_test);
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        s.append("[");
        for (size_t i=0; i<x.n_body; i++) {
            self().visit_stmt(*x.m_body[i]);
            if (i < x.n_body-1) {
                if (indent) s.append("\n" + indented);
                else s.append(" ");
            };
        }
        s.append("]");
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        s.append("[");
        for (size_t i=0; i<x.n_orelse; i++) {
            self().visit_stmt(*x.m_orelse[i]);
            if (i < x.n_orelse-1) {
                if (indent) s.append("\n" + indented);
                else s.append(" ");
            };
        }
        s.append("]");
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        if (x.m_t_inside) {
            self().visit_trivia(*x.m_t_inside);
        } else {
            s.append("()");
        }
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        if (x.m_trivia) {
            self().visit_trivia(*x.m_trivia);
        } else {
            s.append("()");
        }
        if(indent) {
            dec_indent();
            s.append("\n" + indented);
        }
        s.append(")");
    }
    void visit_WhileLoop(const WhileLoop_t &x) {
        s.append("(");
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("WhileLoop");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        if(indent) {
            inc_indent();
            s.append("\n" + indented);
        } else {
            s.append(" ");
        }
        s.append(std::to_string(x.m_label));
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        if (x.m_stmt_name) {
            s.append(x.m_stmt_name);
        } else {
            s.append("()");
        }
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        self().visit_expr(*x.m_test);
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        s.append("[");
        for (size_t i=0; i<x.n_body; i++) {
            self().visit_stmt(*x.m_body[i]);
            if (i < x.n_body-1) {
                if (indent) s.append("\n" + indented);
                else s.append(" ");
            };
        }
        s.append("]");
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        if (x.m_t_inside) {
            self().visit_trivia(*x.m_t_inside);
        } else {
            s.append("()");
        }
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        if (x.m_trivia) {
            self().visit_trivia(*x.m_trivia);
        } else {
            s.append("()");
        }
        if(indent) {
            dec_indent();
            s.append("\n" + indented);
        }
        s.append(")");
    }
    void visit_BoolOp(const BoolOp_t &x) {
        s.append("(");
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("BoolOp");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        if(indent) {
            inc_indent();
            s.append("\n" + indented);
        } else {
            s.append(" ");
        }
        self().visit_expr(*x.m_left);
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        visit_boolopType(x.m_op);
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        self().visit_expr(*x.m_right);
        if(indent) {
            dec_indent();
            s.append("\n" + indented);
        }
        s.append(")");
    }
    void visit_BinOp(const BinOp_t &x) {
        s.append("(");
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("BinOp");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        if(indent) {
            inc_indent();
            s.append("\n" + indented);
        } else {
            s.append(" ");
        }
        self().visit_expr(*x.m_left);
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        visit_operatorType(x.m_op);
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        self().visit_expr(*x.m_right);
        if(indent) {
            dec_indent();
            s.append("\n" + indented);
        }
        s.append(")");
    }
    void visit_DefBinOp(const DefBinOp_t &x) {
        s.append("(");
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("DefBinOp");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        if(indent) {
            inc_indent();
            s.append("\n" + indented);
        } else {
            s.append(" ");
        }
        self().visit_expr(*x.m_left);
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        s.append("\"" + str_escape_c(x.m_op) + "\"");
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        self().visit_expr(*x.m_right);
        if(indent) {
            dec_indent();
            s.append("\n" + indented);
        }
        s.append(")");
    }
    void visit_StrOp(const StrOp_t &x) {
        s.append("(");
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("StrOp");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        if(indent) {
            inc_indent();
            s.append("\n" + indented);
        } else {
            s.append(" ");
        }
        self().visit_expr(*x.m_left);
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        visit_stroperatorType(x.m_op);
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        self().visit_expr(*x.m_right);
        if(indent) {
            dec_indent();
            s.append("\n" + indented);
        }
        s.append(")");
    }
    void visit_UnaryOp(const UnaryOp_t &x) {
        s.append("(");
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("UnaryOp");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        if(indent) {
            inc_indent();
            s.append("\n" + indented);
        } else {
            s.append(" ");
        }
        visit_unaryopType(x.m_op);
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        self().visit_expr(*x.m_operand);
        if(indent) {
            dec_indent();
            s.append("\n" + indented);
        }
        s.append(")");
    }
    void visit_DefUnaryOp(const DefUnaryOp_t &x) {
        s.append("(");
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("DefUnaryOp");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        if(indent) {
            inc_indent();
            s.append("\n" + indented);
        } else {
            s.append(" ");
        }
        s.append("\"" + str_escape_c(x.m_op) + "\"");
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        self().visit_expr(*x.m_operand);
        if(indent) {
            dec_indent();
            s.append("\n" + indented);
        }
        s.append(")");
    }
    void visit_Compare(const Compare_t &x) {
        s.append("(");
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("Compare");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        if(indent) {
            inc_indent();
            s.append("\n" + indented);
        } else {
            s.append(" ");
        }
        self().visit_expr(*x.m_left);
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        visit_cmpopType(x.m_op);
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        self().visit_expr(*x.m_right);
        if(indent) {
            dec_indent();
            s.append("\n" + indented);
        }
        s.append(")");
    }
    void visit_FuncCallOrArray(const FuncCallOrArray_t &x) {
        s.append("(");
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("FuncCallOrArray");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        if(indent) {
            inc_indent();
            s.append("\n" + indented);
        } else {
            s.append(" ");
        }
        s.append(x.m_func);
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        s.append("[");
        for (size_t i=0; i<x.n_member; i++) {
            self().visit_struct_member(x.m_member[i]);
            if (i < x.n_member-1) {
                if (indent) s.append("\n" + indented);
                else s.append(" ");
            };
        }
        s.append("]");
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        s.append("[");
        for (size_t i=0; i<x.n_args; i++) {
            self().visit_fnarg(x.m_args[i]);
            if (i < x.n_args-1) {
                if (indent) s.append("\n" + indented);
                else s.append(" ");
            };
        }
        s.append("]");
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        s.append("[");
        for (size_t i=0; i<x.n_keywords; i++) {
            self().visit_keyword(x.m_keywords[i]);
            if (i < x.n_keywords-1) {
                if (indent) s.append("\n" + indented);
                else s.append(" ");
            };
        }
        s.append("]");
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        s.append("[");
        for (size_t i=0; i<x.n_subargs; i++) {
            self().visit_fnarg(x.m_subargs[i]);
            if (i < x.n_subargs-1) {
                if (indent) s.append("\n" + indented);
                else s.append(" ");
            };
        }
        s.append("]");
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        s.append("[");
        for (size_t i=0; i<x.n_temp_args; i++) {
            self().visit_decl_attribute(*x.m_temp_args[i]);
            if (i < x.n_temp_args-1) {
                if (indent) s.append("\n" + indented);
                else s.append(" ");
            };
        }
        s.append("]");
        if(indent) {
            dec_indent();
            s.append("\n" + indented);
        }
        s.append(")");
    }
    void visit_CoarrayRef(const CoarrayRef_t &x) {
        s.append("(");
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("CoarrayRef");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        if(indent) {
            inc_indent();
            s.append("\n" + indented);
        } else {
            s.append(" ");
        }
        s.append(x.m_name);
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        s.append("[");
        for (size_t i=0; i<x.n_member; i++) {
            self().visit_struct_member(x.m_member[i]);
            if (i < x.n_member-1) {
                if (indent) s.append("\n" + indented);
                else s.append(" ");
            };
        }
        s.append("]");
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        s.append("[");
        for (size_t i=0; i<x.n_args; i++) {
            self().visit_fnarg(x.m_args[i]);
            if (i < x.n_args-1) {
                if (indent) s.append("\n" + indented);
                else s.append(" ");
            };
        }
        s.append("]");
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        s.append("[");
        for (size_t i=0; i<x.n_fnkw; i++) {
            self().visit_keyword(x.m_fnkw[i]);
            if (i < x.n_fnkw-1) {
                if (indent) s.append("\n" + indented);
                else s.append(" ");
            };
        }
        s.append("]");
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        s.append("[");
        for (size_t i=0; i<x.n_coargs; i++) {
            self().visit_coarrayarg(x.m_coargs[i]);
            if (i < x.n_coargs-1) {
                if (indent) s.append("\n" + indented);
                else s.append(" ");
            };
        }
        s.append("]");
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        s.append("[");
        for (size_t i=0; i<x.n_cokw; i++) {
            self().visit_keyword(x.m_cokw[i]);
            if (i < x.n_cokw-1) {
                if (indent) s.append("\n" + indented);
                else s.append(" ");
            };
        }
        s.append("]");
        if(indent) {
            dec_indent();
            s.append("\n" + indented);
        }
        s.append(")");
    }
    void visit_ArrayInitializer(const ArrayInitializer_t &x) {
        s.append("(");
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("ArrayInitializer");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        if(indent) {
            inc_indent();
            s.append("\n" + indented);
        } else {
            s.append(" ");
        }
        if (x.m_vartype) {
            self().visit_decl_attribute(*x.m_vartype);
        } else {
            s.append("()");
        }
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        if (x.m_classtype) {
            s.append(x.m_classtype);
        } else {
            s.append("()");
        }
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        s.append("[");
        for (size_t i=0; i<x.n_args; i++) {
            self().visit_expr(*x.m_args[i]);
            if (i < x.n_args-1) {
                if (indent) s.append("\n" + indented);
                else s.append(" ");
            };
        }
        s.append("]");
        if(indent) {
            dec_indent();
            s.append("\n" + indented);
        }
        s.append(")");
    }
    void visit_ImpliedDoLoop(const ImpliedDoLoop_t &x) {
        s.append("(");
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("ImpliedDoLoop");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        if(indent) {
            inc_indent();
            s.append("\n" + indented);
        } else {
            s.append(" ");
        }
        s.append("[");
        for (size_t i=0; i<x.n_values; i++) {
            self().visit_expr(*x.m_values[i]);
            if (i < x.n_values-1) {
                if (indent) s.append("\n" + indented);
                else s.append(" ");
            };
        }
        s.append("]");
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        s.append(x.m_var);
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        self().visit_expr(*x.m_start);
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        self().visit_expr(*x.m_end);
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        if (x.m_increment) {
            self().visit_expr(*x.m_increment);
        } else {
            s.append("()");
        }
        if(indent) {
            dec_indent();
            s.append("\n" + indented);
        }
        s.append(")");
    }
    void visit_Num(const Num_t &x) {
        s.append("(");
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("Num");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        if(indent) {
            inc_indent();
            s.append("\n" + indented);
        } else {
            s.append(" ");
        }
        s.append(std::to_string(x.m_n));
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        if (x.m_kind) {
            s.append("\"" + str_escape_c(x.m_kind) + "\"");
        } else {
            s.append("()");
        }
        if(indent) {
            dec_indent();
            s.append("\n" + indented);
        }
        s.append(")");
        if ((bool&)x) { } // Suppress unused warning
    }
    void visit_Real(const Real_t &x) {
        s.append("(");
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("Real");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        s.append(" ");
        s.append("\"" + str_escape_c(x.m_n) + "\"");
        s.append(")");
        if ((bool&)x) { } // Suppress unused warning
    }
    void visit_Complex(const Complex_t &x) {
        s.append("(");
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("Complex");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        s.append(" ");
        self().visit_expr(*x.m_re);
        s.append(" ");
        self().visit_expr(*x.m_im);
        s.append(")");
    }
    void visit_String(const String_t &x) {
        s.append("(");
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("String");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        if(indent) {
            inc_indent();
            s.append("\n" + indented);
        } else {
            s.append(" ");
        }
        s.append("\"" + str_escape_c(x.m_s) + "\"");
        if(indent) {
            dec_indent();
            s.append("\n" + indented);
        }
        s.append(")");
        if ((bool&)x) { } // Suppress unused warning
    }
    void visit_Substring(const Substring_t &x) {
        s.append("(");
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("Substring");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        if(indent) {
            inc_indent();
            s.append("\n" + indented);
        } else {
            s.append(" ");
        }
        s.append("\"" + str_escape_c(x.m_s) + "\"");
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        s.append("[");
        for (size_t i=0; i<x.n_args; i++) {
            self().visit_fnarg(x.m_args[i]);
            if (i < x.n_args-1) {
                if (indent) s.append("\n" + indented);
                else s.append(" ");
            };
        }
        s.append("]");
        if(indent) {
            dec_indent();
            s.append("\n" + indented);
        }
        s.append(")");
    }
    void visit_BOZ(const BOZ_t &x) {
        s.append("(");
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("BOZ");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        if(indent) {
            inc_indent();
            s.append("\n" + indented);
        } else {
            s.append(" ");
        }
        s.append("\"" + str_escape_c(x.m_s) + "\"");
        if(indent) {
            dec_indent();
            s.append("\n" + indented);
        }
        s.append(")");
        if ((bool&)x) { } // Suppress unused warning
    }
    void visit_Name(const Name_t &x) {
        s.append("(");
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("Name");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        if(indent) {
            inc_indent();
            s.append("\n" + indented);
        } else {
            s.append(" ");
        }
        s.append(x.m_id);
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        s.append("[");
        for (size_t i=0; i<x.n_member; i++) {
            self().visit_struct_member(x.m_member[i]);
            if (i < x.n_member-1) {
                if (indent) s.append("\n" + indented);
                else s.append(" ");
            };
        }
        s.append("]");
        if(indent) {
            dec_indent();
            s.append("\n" + indented);
        }
        s.append(")");
    }
    void visit_Logical(const Logical_t &x) {
        s.append("(");
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("Logical");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        s.append(" ");
        if (x.m_value) {
            s.append(".true.");
        } else {
            s.append(".false.");
        }
        s.append(")");
        if ((bool&)x) { } // Suppress unused warning
    }
    void visit_DataImpliedDo(const DataImpliedDo_t &x) {
        s.append("(");
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("DataImpliedDo");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        if(indent) {
            inc_indent();
            s.append("\n" + indented);
        } else {
            s.append(" ");
        }
        s.append("[");
        for (size_t i=0; i<x.n_object_list; i++) {
            self().visit_expr(*x.m_object_list[i]);
            if (i < x.n_object_list-1) {
                if (indent) s.append("\n" + indented);
                else s.append(" ");
            };
        }
        s.append("]");
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        if (x.m_type) {
            self().visit_decl_attribute(*x.m_type);
        } else {
            s.append("()");
        }
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        s.append(x.m_var);
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        self().visit_expr(*x.m_start);
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        self().visit_expr(*x.m_end);
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        if (x.m_increment) {
            self().visit_expr(*x.m_increment);
        } else {
            s.append("()");
        }
        if(indent) {
            dec_indent();
            s.append("\n" + indented);
        }
        s.append(")");
    }
    void visit_Parenthesis(const Parenthesis_t &x) {
        s.append("(");
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("Parenthesis");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        if(indent) {
            inc_indent();
            s.append("\n" + indented);
        } else {
            s.append(" ");
        }
        self().visit_expr(*x.m_operand);
        if(indent) {
            dec_indent();
            s.append("\n" + indented);
        }
        s.append(")");
    }
    void visit_TriviaNode(const TriviaNode_t &x) {
        s.append("(");
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("TriviaNode");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        if(indent) {
            inc_indent();
            s.append("\n" + indented);
        } else {
            s.append(" ");
        }
        s.append("[");
        for (size_t i=0; i<x.n_inside; i++) {
            self().visit_trivia_node(*x.m_inside[i]);
            if (i < x.n_inside-1) {
                if (indent) s.append("\n" + indented);
                else s.append(" ");
            };
        }
        s.append("]");
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        s.append("[");
        for (size_t i=0; i<x.n_after; i++) {
            self().visit_trivia_node(*x.m_after[i]);
            if (i < x.n_after-1) {
                if (indent) s.append("\n" + indented);
                else s.append(" ");
            };
        }
        s.append("]");
        if(indent) {
            dec_indent();
            s.append("\n" + indented);
        }
        s.append(")");
    }
    void visit_Comment(const Comment_t &x) {
        s.append("(");
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("Comment");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        if(indent) {
            inc_indent();
            s.append("\n" + indented);
        } else {
            s.append(" ");
        }
        s.append("\"" + str_escape_c(x.m_comment) + "\"");
        if(indent) {
            dec_indent();
            s.append("\n" + indented);
        }
        s.append(")");
        if ((bool&)x) { } // Suppress unused warning
    }
    void visit_EOLComment(const EOLComment_t &x) {
        s.append("(");
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("EOLComment");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        if(indent) {
            inc_indent();
            s.append("\n" + indented);
        } else {
            s.append(" ");
        }
        s.append("\"" + str_escape_c(x.m_comment) + "\"");
        if(indent) {
            dec_indent();
            s.append("\n" + indented);
        }
        s.append(")");
        if ((bool&)x) { } // Suppress unused warning
    }
    void visit_EndOfLine(const EndOfLine_t &x) {
        s.append("(");
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("EndOfLine");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        s.append(")");
        if ((bool&)x) { } // Suppress unused warning
    }
    void visit_Semicolon(const Semicolon_t &x) {
        s.append("(");
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("Semicolon");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        s.append(")");
        if ((bool&)x) { } // Suppress unused warning
    }
    void visit_boolopType(const boolopType &x) {
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::green));
        }
        switch (x) {
            case (boolopType::And) : {
                s.append("And");
             break; }
            case (boolopType::Or) : {
                s.append("Or");
             break; }
            case (boolopType::Xor) : {
                s.append("Xor");
             break; }
            case (boolopType::Eqv) : {
                s.append("Eqv");
             break; }
            case (boolopType::NEqv) : {
                s.append("NEqv");
             break; }
        }
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
    }
    void visit_operatorType(const operatorType &x) {
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::green));
        }
        switch (x) {
            case (operatorType::Add) : {
                s.append("Add");
             break; }
            case (operatorType::Sub) : {
                s.append("Sub");
             break; }
            case (operatorType::Mul) : {
                s.append("Mul");
             break; }
            case (operatorType::Div) : {
                s.append("Div");
             break; }
            case (operatorType::Pow) : {
                s.append("Pow");
             break; }
        }
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
    }
    void visit_stroperatorType(const stroperatorType &x) {
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::green));
        }
        switch (x) {
            case (stroperatorType::Concat) : {
                s.append("Concat");
             break; }
        }
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
    }
    void visit_unaryopType(const unaryopType &x) {
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::green));
        }
        switch (x) {
            case (unaryopType::Invert) : {
                s.append("Invert");
             break; }
            case (unaryopType::Not) : {
                s.append("Not");
             break; }
            case (unaryopType::UAdd) : {
                s.append("UAdd");
             break; }
            case (unaryopType::USub) : {
                s.append("USub");
             break; }
        }
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
    }
    void visit_cmpopType(const cmpopType &x) {
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::green));
        }
        switch (x) {
            case (cmpopType::Eq) : {
                s.append("Eq");
             break; }
            case (cmpopType::NotEq) : {
                s.append("NotEq");
             break; }
            case (cmpopType::Lt) : {
                s.append("Lt");
             break; }
            case (cmpopType::LtE) : {
                s.append("LtE");
             break; }
            case (cmpopType::Gt) : {
                s.append("Gt");
             break; }
            case (cmpopType::GtE) : {
                s.append("GtE");
             break; }
        }
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
    }
    void visit_intrinsicopType(const intrinsicopType &x) {
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::green));
        }
        switch (x) {
            case (intrinsicopType::AND) : {
                s.append("AND");
             break; }
            case (intrinsicopType::OR) : {
                s.append("OR");
             break; }
            case (intrinsicopType::XOR) : {
                s.append("XOR");
             break; }
            case (intrinsicopType::EQV) : {
                s.append("EQV");
             break; }
            case (intrinsicopType::NEQV) : {
                s.append("NEQV");
             break; }
            case (intrinsicopType::PLUS) : {
                s.append("PLUS");
             break; }
            case (intrinsicopType::MINUS) : {
                s.append("MINUS");
             break; }
            case (intrinsicopType::STAR) : {
                s.append("STAR");
             break; }
            case (intrinsicopType::DIV) : {
                s.append("DIV");
             break; }
            case (intrinsicopType::POW) : {
                s.append("POW");
             break; }
            case (intrinsicopType::NOT) : {
                s.append("NOT");
             break; }
            case (intrinsicopType::EQ) : {
                s.append("EQ");
             break; }
            case (intrinsicopType::NOTEQ) : {
                s.append("NOTEQ");
             break; }
            case (intrinsicopType::LT) : {
                s.append("LT");
             break; }
            case (intrinsicopType::LTE) : {
                s.append("LTE");
             break; }
            case (intrinsicopType::GT) : {
                s.append("GT");
             break; }
            case (intrinsicopType::GTE) : {
                s.append("GTE");
             break; }
            case (intrinsicopType::CONCAT) : {
                s.append("CONCAT");
             break; }
        }
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
    }
    void visit_DerivedTypeProc(const DerivedTypeProc_t &x) {
        s.append("(");
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("DerivedTypeProc");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        if(indent) {
            inc_indent();
            s.append("\n" + indented);
        } else {
            s.append(" ");
        }
        if (x.m_name) {
            s.append(x.m_name);
        } else {
            s.append("()");
        }
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        s.append("[");
        for (size_t i=0; i<x.n_attr; i++) {
            self().visit_decl_attribute(*x.m_attr[i]);
            if (i < x.n_attr-1) {
                if (indent) s.append("\n" + indented);
                else s.append(" ");
            };
        }
        s.append("]");
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        s.append("[");
        for (size_t i=0; i<x.n_symbols; i++) {
            self().visit_use_symbol(*x.m_symbols[i]);
            if (i < x.n_symbols-1) {
                if (indent) s.append("\n" + indented);
                else s.append(" ");
            };
        }
        s.append("]");
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        if (x.m_trivia) {
            self().visit_trivia(*x.m_trivia);
        } else {
            s.append("()");
        }
        if(indent) {
            dec_indent();
            s.append("\n" + indented);
        }
        s.append(")");
    }
    void visit_GenericOperator(const GenericOperator_t &x) {
        s.append("(");
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("GenericOperator");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        if(indent) {
            inc_indent();
            s.append("\n" + indented);
        } else {
            s.append(" ");
        }
        s.append("[");
        for (size_t i=0; i<x.n_attr; i++) {
            self().visit_decl_attribute(*x.m_attr[i]);
            if (i < x.n_attr-1) {
                if (indent) s.append("\n" + indented);
                else s.append(" ");
            };
        }
        s.append("]");
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        visit_intrinsicopType(x.m_op);
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        s.append("[");
        for (size_t i=0; i<x.n_names; i++) {
            s.append(x.m_names[i]);
            if (i < x.n_names-1) {
                if (indent) s.append("\n" + indented);
                else s.append(" ");
            };
        }
        s.append("]");
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        if (x.m_trivia) {
            self().visit_trivia(*x.m_trivia);
        } else {
            s.append("()");
        }
        if(indent) {
            dec_indent();
            s.append("\n" + indented);
        }
        s.append(")");
    }
    void visit_GenericDefinedOperator(const GenericDefinedOperator_t &x) {
        s.append("(");
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("GenericDefinedOperator");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        if(indent) {
            inc_indent();
            s.append("\n" + indented);
        } else {
            s.append(" ");
        }
        s.append("[");
        for (size_t i=0; i<x.n_attr; i++) {
            self().visit_decl_attribute(*x.m_attr[i]);
            if (i < x.n_attr-1) {
                if (indent) s.append("\n" + indented);
                else s.append(" ");
            };
        }
        s.append("]");
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        s.append("\"" + str_escape_c(x.m_optype) + "\"");
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        s.append("[");
        for (size_t i=0; i<x.n_names; i++) {
            s.append(x.m_names[i]);
            if (i < x.n_names-1) {
                if (indent) s.append("\n" + indented);
                else s.append(" ");
            };
        }
        s.append("]");
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        if (x.m_trivia) {
            self().visit_trivia(*x.m_trivia);
        } else {
            s.append("()");
        }
        if(indent) {
            dec_indent();
            s.append("\n" + indented);
        }
        s.append(")");
    }
    void visit_GenericAssignment(const GenericAssignment_t &x) {
        s.append("(");
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("GenericAssignment");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        if(indent) {
            inc_indent();
            s.append("\n" + indented);
        } else {
            s.append(" ");
        }
        s.append("[");
        for (size_t i=0; i<x.n_attr; i++) {
            self().visit_decl_attribute(*x.m_attr[i]);
            if (i < x.n_attr-1) {
                if (indent) s.append("\n" + indented);
                else s.append(" ");
            };
        }
        s.append("]");
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        s.append("[");
        for (size_t i=0; i<x.n_names; i++) {
            s.append(x.m_names[i]);
            if (i < x.n_names-1) {
                if (indent) s.append("\n" + indented);
                else s.append(" ");
            };
        }
        s.append("]");
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        if (x.m_trivia) {
            self().visit_trivia(*x.m_trivia);
        } else {
            s.append("()");
        }
        if(indent) {
            dec_indent();
            s.append("\n" + indented);
        }
        s.append(")");
    }
    void visit_GenericName(const GenericName_t &x) {
        s.append("(");
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("GenericName");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        if(indent) {
            inc_indent();
            s.append("\n" + indented);
        } else {
            s.append(" ");
        }
        s.append("[");
        for (size_t i=0; i<x.n_attr; i++) {
            self().visit_decl_attribute(*x.m_attr[i]);
            if (i < x.n_attr-1) {
                if (indent) s.append("\n" + indented);
                else s.append(" ");
            };
        }
        s.append("]");
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        s.append(x.m_name);
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        s.append("[");
        for (size_t i=0; i<x.n_names; i++) {
            s.append(x.m_names[i]);
            if (i < x.n_names-1) {
                if (indent) s.append("\n" + indented);
                else s.append(" ");
            };
        }
        s.append("]");
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        if (x.m_trivia) {
            self().visit_trivia(*x.m_trivia);
        } else {
            s.append("()");
        }
        if(indent) {
            dec_indent();
            s.append("\n" + indented);
        }
        s.append(")");
    }
    void visit_GenericWrite(const GenericWrite_t &x) {
        s.append("(");
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("GenericWrite");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        if(indent) {
            inc_indent();
            s.append("\n" + indented);
        } else {
            s.append(" ");
        }
        s.append("[");
        for (size_t i=0; i<x.n_attr; i++) {
            self().visit_decl_attribute(*x.m_attr[i]);
            if (i < x.n_attr-1) {
                if (indent) s.append("\n" + indented);
                else s.append(" ");
            };
        }
        s.append("]");
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        s.append(x.m_id);
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        s.append("[");
        for (size_t i=0; i<x.n_names; i++) {
            s.append(x.m_names[i]);
            if (i < x.n_names-1) {
                if (indent) s.append("\n" + indented);
                else s.append(" ");
            };
        }
        s.append("]");
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        if (x.m_trivia) {
            self().visit_trivia(*x.m_trivia);
        } else {
            s.append("()");
        }
        if(indent) {
            dec_indent();
            s.append("\n" + indented);
        }
        s.append(")");
    }
    void visit_GenericRead(const GenericRead_t &x) {
        s.append("(");
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("GenericRead");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        if(indent) {
            inc_indent();
            s.append("\n" + indented);
        } else {
            s.append(" ");
        }
        s.append("[");
        for (size_t i=0; i<x.n_attr; i++) {
            self().visit_decl_attribute(*x.m_attr[i]);
            if (i < x.n_attr-1) {
                if (indent) s.append("\n" + indented);
                else s.append(" ");
            };
        }
        s.append("]");
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        s.append(x.m_id);
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        s.append("[");
        for (size_t i=0; i<x.n_names; i++) {
            s.append(x.m_names[i]);
            if (i < x.n_names-1) {
                if (indent) s.append("\n" + indented);
                else s.append(" ");
            };
        }
        s.append("]");
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        if (x.m_trivia) {
            self().visit_trivia(*x.m_trivia);
        } else {
            s.append("()");
        }
        if(indent) {
            dec_indent();
            s.append("\n" + indented);
        }
        s.append(")");
    }
    void visit_FinalName(const FinalName_t &x) {
        s.append("(");
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("FinalName");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        if(indent) {
            inc_indent();
            s.append("\n" + indented);
        } else {
            s.append(" ");
        }
        s.append(x.m_name);
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        if (x.m_trivia) {
            self().visit_trivia(*x.m_trivia);
        } else {
            s.append("()");
        }
        if(indent) {
            dec_indent();
            s.append("\n" + indented);
        }
        s.append(")");
    }
    void visit_Private(const Private_t &x) {
        s.append("(");
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("Private");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        if(indent) {
            inc_indent();
            s.append("\n" + indented);
        } else {
            s.append(" ");
        }
        if (x.m_trivia) {
            self().visit_trivia(*x.m_trivia);
        } else {
            s.append("()");
        }
        if(indent) {
            dec_indent();
            s.append("\n" + indented);
        }
        s.append(")");
    }
    void visit_AttrBind(const AttrBind_t &x) {
        s.append("(");
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("AttrBind");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        if(indent) {
            inc_indent();
            s.append("\n" + indented);
        } else {
            s.append(" ");
        }
        self().visit_bind(*x.m_bind);
        if(indent) {
            dec_indent();
            s.append("\n" + indented);
        }
        s.append(")");
    }
    void visit_AttrDimension(const AttrDimension_t &x) {
        s.append("(");
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("AttrDimension");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        if(indent) {
            inc_indent();
            s.append("\n" + indented);
        } else {
            s.append(" ");
        }
        s.append("[");
        for (size_t i=0; i<x.n_dim; i++) {
            self().visit_dimension(x.m_dim[i]);
            if (i < x.n_dim-1) {
                if (indent) s.append("\n" + indented);
                else s.append(" ");
            };
        }
        s.append("]");
        if(indent) {
            dec_indent();
            s.append("\n" + indented);
        }
        s.append(")");
    }
    void visit_AttrCodimension(const AttrCodimension_t &x) {
        s.append("(");
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("AttrCodimension");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        if(indent) {
            inc_indent();
            s.append("\n" + indented);
        } else {
            s.append(" ");
        }
        s.append("[");
        for (size_t i=0; i<x.n_codim; i++) {
            self().visit_codimension(x.m_codim[i]);
            if (i < x.n_codim-1) {
                if (indent) s.append("\n" + indented);
                else s.append(" ");
            };
        }
        s.append("]");
        if(indent) {
            dec_indent();
            s.append("\n" + indented);
        }
        s.append(")");
    }
    void visit_AttrEquivalence(const AttrEquivalence_t &x) {
        s.append("(");
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("AttrEquivalence");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        if(indent) {
            inc_indent();
            s.append("\n" + indented);
        } else {
            s.append(" ");
        }
        s.append("[");
        for (size_t i=0; i<x.n_args; i++) {
            self().visit_equi(x.m_args[i]);
            if (i < x.n_args-1) {
                if (indent) s.append("\n" + indented);
                else s.append(" ");
            };
        }
        s.append("]");
        if(indent) {
            dec_indent();
            s.append("\n" + indented);
        }
        s.append(")");
    }
    void visit_AttrExtends(const AttrExtends_t &x) {
        s.append("(");
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("AttrExtends");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        if(indent) {
            inc_indent();
            s.append("\n" + indented);
        } else {
            s.append(" ");
        }
        s.append(x.m_name);
        if(indent) {
            dec_indent();
            s.append("\n" + indented);
        }
        s.append(")");
        if ((bool&)x) { } // Suppress unused warning
    }
    void visit_AttrIntent(const AttrIntent_t &x) {
        s.append("(");
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("AttrIntent");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        if(indent) {
            inc_indent();
            s.append("\n" + indented);
        } else {
            s.append(" ");
        }
        visit_attr_intentType(x.m_intent);
        if(indent) {
            dec_indent();
            s.append("\n" + indented);
        }
        s.append(")");
        if ((bool&)x) { } // Suppress unused warning
    }
    void visit_AttrNamelist(const AttrNamelist_t &x) {
        s.append("(");
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("AttrNamelist");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        if(indent) {
            inc_indent();
            s.append("\n" + indented);
        } else {
            s.append(" ");
        }
        s.append(x.m_name);
        if(indent) {
            dec_indent();
            s.append("\n" + indented);
        }
        s.append(")");
        if ((bool&)x) { } // Suppress unused warning
    }
    void visit_AttrPass(const AttrPass_t &x) {
        s.append("(");
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("AttrPass");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        if(indent) {
            inc_indent();
            s.append("\n" + indented);
        } else {
            s.append(" ");
        }
        if (x.m_name) {
            s.append(x.m_name);
        } else {
            s.append("()");
        }
        if(indent) {
            dec_indent();
            s.append("\n" + indented);
        }
        s.append(")");
        if ((bool&)x) { } // Suppress unused warning
    }
    void visit_SimpleAttribute(const SimpleAttribute_t &x) {
        s.append("(");
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("SimpleAttribute");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        if(indent) {
            inc_indent();
            s.append("\n" + indented);
        } else {
            s.append(" ");
        }
        visit_simple_attributeType(x.m_attr);
        if(indent) {
            dec_indent();
            s.append("\n" + indented);
        }
        s.append(")");
        if ((bool&)x) { } // Suppress unused warning
    }
    void visit_AttrType(const AttrType_t &x) {
        s.append("(");
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("AttrType");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        if(indent) {
            inc_indent();
            s.append("\n" + indented);
        } else {
            s.append(" ");
        }
        visit_decl_typeType(x.m_type);
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        s.append("[");
        for (size_t i=0; i<x.n_kind; i++) {
            self().visit_kind_item(x.m_kind[i]);
            if (i < x.n_kind-1) {
                if (indent) s.append("\n" + indented);
                else s.append(" ");
            };
        }
        s.append("]");
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        if (x.m_attr) {
            self().visit_decl_attribute(*x.m_attr);
        } else {
            s.append("()");
        }
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        if (x.m_name) {
            s.append(x.m_name);
        } else {
            s.append("()");
        }
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        visit_symbolType(x.m_sym);
        if(indent) {
            dec_indent();
            s.append("\n" + indented);
        }
        s.append(")");
    }
    void visit_AttrAssignment(const AttrAssignment_t &x) {
        s.append("(");
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("AttrAssignment");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        s.append(")");
        if ((bool&)x) { } // Suppress unused warning
    }
    void visit_AttrIntrinsicOperator(const AttrIntrinsicOperator_t &x) {
        s.append("(");
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("AttrIntrinsicOperator");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        if(indent) {
            inc_indent();
            s.append("\n" + indented);
        } else {
            s.append(" ");
        }
        visit_intrinsicopType(x.m_op);
        if(indent) {
            dec_indent();
            s.append("\n" + indented);
        }
        s.append(")");
        if ((bool&)x) { } // Suppress unused warning
    }
    void visit_AttrDefinedOperator(const AttrDefinedOperator_t &x) {
        s.append("(");
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("AttrDefinedOperator");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        if(indent) {
            inc_indent();
            s.append("\n" + indented);
        } else {
            s.append(" ");
        }
        s.append("\"" + str_escape_c(x.m_op_name) + "\"");
        if(indent) {
            dec_indent();
            s.append("\n" + indented);
        }
        s.append(")");
        if ((bool&)x) { } // Suppress unused warning
    }
    void visit_simple_attributeType(const simple_attributeType &x) {
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::green));
        }
        switch (x) {
            case (simple_attributeType::AttrAbstract) : {
                s.append("AttrAbstract");
             break; }
            case (simple_attributeType::AttrAllocatable) : {
                s.append("AttrAllocatable");
             break; }
            case (simple_attributeType::AttrAsynchronous) : {
                s.append("AttrAsynchronous");
             break; }
            case (simple_attributeType::AttrCommon) : {
                s.append("AttrCommon");
             break; }
            case (simple_attributeType::AttrContiguous) : {
                s.append("AttrContiguous");
             break; }
            case (simple_attributeType::AttrDeferred) : {
                s.append("AttrDeferred");
             break; }
            case (simple_attributeType::AttrElemental) : {
                s.append("AttrElemental");
             break; }
            case (simple_attributeType::AttrEnumerator) : {
                s.append("AttrEnumerator");
             break; }
            case (simple_attributeType::AttrExternal) : {
                s.append("AttrExternal");
             break; }
            case (simple_attributeType::AttrImpure) : {
                s.append("AttrImpure");
             break; }
            case (simple_attributeType::AttrIntrinsic) : {
                s.append("AttrIntrinsic");
             break; }
            case (simple_attributeType::AttrKind) : {
                s.append("AttrKind");
             break; }
            case (simple_attributeType::AttrLen) : {
                s.append("AttrLen");
             break; }
            case (simple_attributeType::AttrModule) : {
                s.append("AttrModule");
             break; }
            case (simple_attributeType::AttrNoPass) : {
                s.append("AttrNoPass");
             break; }
            case (simple_attributeType::AttrNonDeferred) : {
                s.append("AttrNonDeferred");
             break; }
            case (simple_attributeType::AttrNon_Intrinsic) : {
                s.append("AttrNon_Intrinsic");
             break; }
            case (simple_attributeType::AttrOptional) : {
                s.append("AttrOptional");
             break; }
            case (simple_attributeType::AttrParameter) : {
                s.append("AttrParameter");
             break; }
            case (simple_attributeType::AttrPointer) : {
                s.append("AttrPointer");
             break; }
            case (simple_attributeType::AttrPrivate) : {
                s.append("AttrPrivate");
             break; }
            case (simple_attributeType::AttrProtected) : {
                s.append("AttrProtected");
             break; }
            case (simple_attributeType::AttrPublic) : {
                s.append("AttrPublic");
             break; }
            case (simple_attributeType::AttrPure) : {
                s.append("AttrPure");
             break; }
            case (simple_attributeType::AttrRecursive) : {
                s.append("AttrRecursive");
             break; }
            case (simple_attributeType::AttrSave) : {
                s.append("AttrSave");
             break; }
            case (simple_attributeType::AttrSequence) : {
                s.append("AttrSequence");
             break; }
            case (simple_attributeType::AttrTarget) : {
                s.append("AttrTarget");
             break; }
            case (simple_attributeType::AttrValue) : {
                s.append("AttrValue");
             break; }
            case (simple_attributeType::AttrVolatile) : {
                s.append("AttrVolatile");
             break; }
        }
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
    }
    void visit_attr_intentType(const attr_intentType &x) {
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::green));
        }
        switch (x) {
            case (attr_intentType::In) : {
                s.append("In");
             break; }
            case (attr_intentType::Out) : {
                s.append("Out");
             break; }
            case (attr_intentType::InOut) : {
                s.append("InOut");
             break; }
        }
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
    }
    void visit_decl_typeType(const decl_typeType &x) {
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::green));
        }
        switch (x) {
            case (decl_typeType::TypeClass) : {
                s.append("TypeClass");
             break; }
            case (decl_typeType::TypeCharacter) : {
                s.append("TypeCharacter");
             break; }
            case (decl_typeType::TypeComplex) : {
                s.append("TypeComplex");
             break; }
            case (decl_typeType::TypeDoublePrecision) : {
                s.append("TypeDoublePrecision");
             break; }
            case (decl_typeType::TypeDoubleComplex) : {
                s.append("TypeDoubleComplex");
             break; }
            case (decl_typeType::TypeInteger) : {
                s.append("TypeInteger");
             break; }
            case (decl_typeType::TypeLogical) : {
                s.append("TypeLogical");
             break; }
            case (decl_typeType::TypeProcedure) : {
                s.append("TypeProcedure");
             break; }
            case (decl_typeType::TypeReal) : {
                s.append("TypeReal");
             break; }
            case (decl_typeType::TypeType) : {
                s.append("TypeType");
             break; }
        }
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
    }
    void visit_AttrStat(const AttrStat_t &x) {
        s.append("(");
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("AttrStat");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        if(indent) {
            inc_indent();
            s.append("\n" + indented);
        } else {
            s.append(" ");
        }
        s.append(x.m_variable);
        if(indent) {
            dec_indent();
            s.append("\n" + indented);
        }
        s.append(")");
        if ((bool&)x) { } // Suppress unused warning
    }
    void visit_AttrErrmsg(const AttrErrmsg_t &x) {
        s.append("(");
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("AttrErrmsg");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        if(indent) {
            inc_indent();
            s.append("\n" + indented);
        } else {
            s.append(" ");
        }
        s.append(x.m_variable);
        if(indent) {
            dec_indent();
            s.append("\n" + indented);
        }
        s.append(")");
        if ((bool&)x) { } // Suppress unused warning
    }
    void visit_AttrNewIndex(const AttrNewIndex_t &x) {
        s.append("(");
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("AttrNewIndex");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        if(indent) {
            inc_indent();
            s.append("\n" + indented);
        } else {
            s.append(" ");
        }
        self().visit_expr(*x.m_value);
        if(indent) {
            dec_indent();
            s.append("\n" + indented);
        }
        s.append(")");
    }
    void visit_AttrEventWaitKwArg(const AttrEventWaitKwArg_t &x) {
        s.append("(");
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("AttrEventWaitKwArg");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        if(indent) {
            inc_indent();
            s.append("\n" + indented);
        } else {
            s.append(" ");
        }
        s.append(x.m_id);
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        self().visit_expr(*x.m_value);
        if(indent) {
            dec_indent();
            s.append("\n" + indented);
        }
        s.append(")");
    }
    void visit_CoarrayAssociation(const CoarrayAssociation_t &x) {
        s.append("(");
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("CoarrayAssociation");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        if(indent) {
            inc_indent();
            s.append("\n" + indented);
        } else {
            s.append(" ");
        }
        self().visit_expr(*x.m_coarray);
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        self().visit_expr(*x.m_selector);
        if(indent) {
            dec_indent();
            s.append("\n" + indented);
        }
        s.append(")");
    }
    void visit_var_sym(const var_sym_t &x) {
        s.append("(");
        if (x.m_name) {
            s.append(x.m_name);
        } else {
            s.append("()");
        }
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        s.append("[");
        for (size_t i=0; i<x.n_dim; i++) {
            self().visit_dimension(x.m_dim[i]);
            if (i < x.n_dim-1) {
                if (indent) s.append("\n" + indented);
                else s.append(" ");
            };
        }
        s.append("]");
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        s.append("[");
        for (size_t i=0; i<x.n_codim; i++) {
            self().visit_codimension(x.m_codim[i]);
            if (i < x.n_codim-1) {
                if (indent) s.append("\n" + indented);
                else s.append(" ");
            };
        }
        s.append("]");
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        if (x.m_length) {
            self().visit_expr(*x.m_length);
        } else {
            s.append("()");
        }
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        if (x.m_initializer) {
            self().visit_expr(*x.m_initializer);
        } else {
            s.append("()");
        }
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        visit_symbolType(x.m_sym);
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        if (x.m_spec) {
            self().visit_decl_attribute(*x.m_spec);
        } else {
            s.append("()");
        }
        s.append(")");
    }
    void visit_kind_item(const kind_item_t &x) {
        s.append("(");
        if (x.m_id) {
            s.append(x.m_id);
        } else {
            s.append("()");
        }
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        if (x.m_value) {
            self().visit_expr(*x.m_value);
        } else {
            s.append("()");
        }
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        visit_kind_item_typeType(x.m_type);
        s.append(")");
    }
    void visit_kind_item_typeType(const kind_item_typeType &x) {
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::green));
        }
        switch (x) {
            case (kind_item_typeType::Star) : {
                s.append("Star");
             break; }
            case (kind_item_typeType::Colon) : {
                s.append("Colon");
             break; }
            case (kind_item_typeType::Value) : {
                s.append("Value");
             break; }
        }
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
    }
    void visit_dimension(const dimension_t &x) {
        s.append("(");
        if (x.m_start) {
            self().visit_expr(*x.m_start);
        } else {
            s.append("()");
        }
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        if (x.m_end) {
            self().visit_expr(*x.m_end);
        } else {
            s.append("()");
        }
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        visit_dimension_typeType(x.m_end_star);
        s.append(")");
    }
    void visit_dimension_typeType(const dimension_typeType &x) {
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::green));
        }
        switch (x) {
            case (dimension_typeType::DimensionExpr) : {
                s.append("DimensionExpr");
             break; }
            case (dimension_typeType::DimensionStar) : {
                s.append("DimensionStar");
             break; }
            case (dimension_typeType::AssumedRank) : {
                s.append("AssumedRank");
             break; }
        }
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
    }
    void visit_codimension(const codimension_t &x) {
        s.append("(");
        if (x.m_start) {
            self().visit_expr(*x.m_start);
        } else {
            s.append("()");
        }
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        if (x.m_end) {
            self().visit_expr(*x.m_end);
        } else {
            s.append("()");
        }
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        visit_codimension_typeType(x.m_end_star);
        s.append(")");
    }
    void visit_codimension_typeType(const codimension_typeType &x) {
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::green));
        }
        switch (x) {
            case (codimension_typeType::CodimensionExpr) : {
                s.append("CodimensionExpr");
             break; }
            case (codimension_typeType::CodimensionStar) : {
                s.append("CodimensionStar");
             break; }
        }
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
    }
    void visit_symbolType(const symbolType &x) {
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::green));
        }
        switch (x) {
            case (symbolType::None) : {
                s.append("None");
             break; }
            case (symbolType::Arrow) : {
                s.append("Arrow");
             break; }
            case (symbolType::Equal) : {
                s.append("Equal");
             break; }
            case (symbolType::Asterisk) : {
                s.append("Asterisk");
             break; }
            case (symbolType::DoubleAsterisk) : {
                s.append("DoubleAsterisk");
             break; }
            case (symbolType::Slash) : {
                s.append("Slash");
             break; }
        }
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
    }
    void visit_equi(const equi_t &x) {
        s.append("(");
        s.append("[");
        for (size_t i=0; i<x.n_set_list; i++) {
            self().visit_expr(*x.m_set_list[i]);
            if (i < x.n_set_list-1) {
                if (indent) s.append("\n" + indented);
                else s.append(" ");
            };
        }
        s.append("]");
        s.append(")");
    }
    void visit_kw_argstar(const kw_argstar_t &x) {
        s.append("(");
        s.append(x.m_arg);
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        if (x.m_value) {
            self().visit_expr(*x.m_value);
        } else {
            s.append("()");
        }
        s.append(")");
    }
    void visit_argstar(const argstar_t &x) {
        s.append("(");
        if (x.m_value) {
            self().visit_expr(*x.m_value);
        } else {
            s.append("()");
        }
        s.append(")");
    }
    void visit_arg(const arg_t &x) {
        s.append("(");
        if (x.m_arg) {
            s.append(x.m_arg);
        } else {
            s.append("()");
        }
        s.append(")");
        if ((bool&)x) { } // Suppress unused warning
    }
    void visit_fnarg(const fnarg_t &x) {
        s.append("(");
        if (x.m_start) {
            self().visit_expr(*x.m_start);
        } else {
            s.append("()");
        }
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        if (x.m_end) {
            self().visit_expr(*x.m_end);
        } else {
            s.append("()");
        }
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        if (x.m_step) {
            self().visit_expr(*x.m_step);
        } else {
            s.append("()");
        }
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        s.append(std::to_string(x.m_label));
        s.append(")");
    }
    void visit_coarrayarg(const coarrayarg_t &x) {
        s.append("(");
        if (x.m_start) {
            self().visit_expr(*x.m_start);
        } else {
            s.append("()");
        }
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        if (x.m_end) {
            self().visit_expr(*x.m_end);
        } else {
            s.append("()");
        }
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        if (x.m_step) {
            self().visit_expr(*x.m_step);
        } else {
            s.append("()");
        }
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        visit_codimension_typeType(x.m_star);
        s.append(")");
    }
    void visit_keyword(const keyword_t &x) {
        s.append("(");
        s.append(x.m_arg);
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        self().visit_expr(*x.m_value);
        s.append(")");
    }
    void visit_struct_member(const struct_member_t &x) {
        s.append("(");
        s.append(x.m_name);
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        s.append("[");
        for (size_t i=0; i<x.n_args; i++) {
            self().visit_fnarg(x.m_args[i]);
            if (i < x.n_args-1) {
                if (indent) s.append("\n" + indented);
                else s.append(" ");
            };
        }
        s.append("]");
        s.append(")");
    }
    void visit_Bind(const Bind_t &x) {
        s.append("(");
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("Bind");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        if(indent) {
            inc_indent();
            s.append("\n" + indented);
        } else {
            s.append(" ");
        }
        s.append("[");
        for (size_t i=0; i<x.n_args; i++) {
            self().visit_expr(*x.m_args[i]);
            if (i < x.n_args-1) {
                if (indent) s.append("\n" + indented);
                else s.append(" ");
            };
        }
        s.append("]");
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        s.append("[");
        for (size_t i=0; i<x.n_kwargs; i++) {
            self().visit_keyword(x.m_kwargs[i]);
            if (i < x.n_kwargs-1) {
                if (indent) s.append("\n" + indented);
                else s.append(" ");
            };
        }
        s.append("]");
        if(indent) {
            dec_indent();
            s.append("\n" + indented);
        }
        s.append(")");
    }
    void visit_ArrayIndex(const ArrayIndex_t &x) {
        s.append("(");
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("ArrayIndex");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        if(indent) {
            inc_indent();
            s.append("\n" + indented);
        } else {
            s.append(" ");
        }
        if (x.m_left) {
            self().visit_expr(*x.m_left);
        } else {
            s.append("()");
        }
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        if (x.m_right) {
            self().visit_expr(*x.m_right);
        } else {
            s.append("()");
        }
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        if (x.m_step) {
            self().visit_expr(*x.m_step);
        } else {
            s.append("()");
        }
        if(indent) {
            dec_indent();
            s.append("\n" + indented);
        }
        s.append(")");
    }
    void visit_CaseStmt(const CaseStmt_t &x) {
        s.append("(");
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("CaseStmt");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        if(indent) {
            inc_indent();
            s.append("\n" + indented);
        } else {
            s.append(" ");
        }
        s.append("[");
        for (size_t i=0; i<x.n_test; i++) {
            self().visit_case_cond(*x.m_test[i]);
            if (i < x.n_test-1) {
                if (indent) s.append("\n" + indented);
                else s.append(" ");
            };
        }
        s.append("]");
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        if (x.m_trivia) {
            self().visit_trivia(*x.m_trivia);
        } else {
            s.append("()");
        }
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        s.append("[");
        for (size_t i=0; i<x.n_body; i++) {
            self().visit_stmt(*x.m_body[i]);
            if (i < x.n_body-1) {
                if (indent) s.append("\n" + indented);
                else s.append(" ");
            };
        }
        s.append("]");
        if(indent) {
            dec_indent();
            s.append("\n" + indented);
        }
        s.append(")");
    }
    void visit_CaseStmt_Default(const CaseStmt_Default_t &x) {
        s.append("(");
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("CaseStmt_Default");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        if(indent) {
            inc_indent();
            s.append("\n" + indented);
        } else {
            s.append(" ");
        }
        if (x.m_trivia) {
            self().visit_trivia(*x.m_trivia);
        } else {
            s.append("()");
        }
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        s.append("[");
        for (size_t i=0; i<x.n_body; i++) {
            self().visit_stmt(*x.m_body[i]);
            if (i < x.n_body-1) {
                if (indent) s.append("\n" + indented);
                else s.append(" ");
            };
        }
        s.append("]");
        if(indent) {
            dec_indent();
            s.append("\n" + indented);
        }
        s.append(")");
    }
    void visit_CaseCondExpr(const CaseCondExpr_t &x) {
        s.append("(");
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("CaseCondExpr");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        if(indent) {
            inc_indent();
            s.append("\n" + indented);
        } else {
            s.append(" ");
        }
        self().visit_expr(*x.m_cond);
        if(indent) {
            dec_indent();
            s.append("\n" + indented);
        }
        s.append(")");
    }
    void visit_CaseCondRange(const CaseCondRange_t &x) {
        s.append("(");
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("CaseCondRange");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        if(indent) {
            inc_indent();
            s.append("\n" + indented);
        } else {
            s.append(" ");
        }
        if (x.m_start) {
            self().visit_expr(*x.m_start);
        } else {
            s.append("()");
        }
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        if (x.m_end) {
            self().visit_expr(*x.m_end);
        } else {
            s.append("()");
        }
        if(indent) {
            dec_indent();
            s.append("\n" + indented);
        }
        s.append(")");
    }
    void visit_RankExpr(const RankExpr_t &x) {
        s.append("(");
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("RankExpr");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        if(indent) {
            inc_indent();
            s.append("\n" + indented);
        } else {
            s.append(" ");
        }
        self().visit_expr(*x.m_value);
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        if (x.m_trivia) {
            self().visit_trivia(*x.m_trivia);
        } else {
            s.append("()");
        }
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        s.append("[");
        for (size_t i=0; i<x.n_body; i++) {
            self().visit_stmt(*x.m_body[i]);
            if (i < x.n_body-1) {
                if (indent) s.append("\n" + indented);
                else s.append(" ");
            };
        }
        s.append("]");
        if(indent) {
            dec_indent();
            s.append("\n" + indented);
        }
        s.append(")");
    }
    void visit_RankStar(const RankStar_t &x) {
        s.append("(");
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("RankStar");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        if(indent) {
            inc_indent();
            s.append("\n" + indented);
        } else {
            s.append(" ");
        }
        if (x.m_trivia) {
            self().visit_trivia(*x.m_trivia);
        } else {
            s.append("()");
        }
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        s.append("[");
        for (size_t i=0; i<x.n_body; i++) {
            self().visit_stmt(*x.m_body[i]);
            if (i < x.n_body-1) {
                if (indent) s.append("\n" + indented);
                else s.append(" ");
            };
        }
        s.append("]");
        if(indent) {
            dec_indent();
            s.append("\n" + indented);
        }
        s.append(")");
    }
    void visit_RankDefault(const RankDefault_t &x) {
        s.append("(");
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("RankDefault");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        if(indent) {
            inc_indent();
            s.append("\n" + indented);
        } else {
            s.append(" ");
        }
        if (x.m_trivia) {
            self().visit_trivia(*x.m_trivia);
        } else {
            s.append("()");
        }
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        s.append("[");
        for (size_t i=0; i<x.n_body; i++) {
            self().visit_stmt(*x.m_body[i]);
            if (i < x.n_body-1) {
                if (indent) s.append("\n" + indented);
                else s.append(" ");
            };
        }
        s.append("]");
        if(indent) {
            dec_indent();
            s.append("\n" + indented);
        }
        s.append(")");
    }
    void visit_TypeStmtName(const TypeStmtName_t &x) {
        s.append("(");
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("TypeStmtName");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        if(indent) {
            inc_indent();
            s.append("\n" + indented);
        } else {
            s.append(" ");
        }
        if (x.m_name) {
            s.append(x.m_name);
        } else {
            s.append("()");
        }
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        if (x.m_trivia) {
            self().visit_trivia(*x.m_trivia);
        } else {
            s.append("()");
        }
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        s.append("[");
        for (size_t i=0; i<x.n_body; i++) {
            self().visit_stmt(*x.m_body[i]);
            if (i < x.n_body-1) {
                if (indent) s.append("\n" + indented);
                else s.append(" ");
            };
        }
        s.append("]");
        if(indent) {
            dec_indent();
            s.append("\n" + indented);
        }
        s.append(")");
    }
    void visit_TypeStmtType(const TypeStmtType_t &x) {
        s.append("(");
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("TypeStmtType");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        if(indent) {
            inc_indent();
            s.append("\n" + indented);
        } else {
            s.append(" ");
        }
        if (x.m_vartype) {
            self().visit_decl_attribute(*x.m_vartype);
        } else {
            s.append("()");
        }
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        if (x.m_trivia) {
            self().visit_trivia(*x.m_trivia);
        } else {
            s.append("()");
        }
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        s.append("[");
        for (size_t i=0; i<x.n_body; i++) {
            self().visit_stmt(*x.m_body[i]);
            if (i < x.n_body-1) {
                if (indent) s.append("\n" + indented);
                else s.append(" ");
            };
        }
        s.append("]");
        if(indent) {
            dec_indent();
            s.append("\n" + indented);
        }
        s.append(")");
    }
    void visit_ClassStmt(const ClassStmt_t &x) {
        s.append("(");
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("ClassStmt");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        if(indent) {
            inc_indent();
            s.append("\n" + indented);
        } else {
            s.append(" ");
        }
        if (x.m_id) {
            s.append(x.m_id);
        } else {
            s.append("()");
        }
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        if (x.m_trivia) {
            self().visit_trivia(*x.m_trivia);
        } else {
            s.append("()");
        }
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        s.append("[");
        for (size_t i=0; i<x.n_body; i++) {
            self().visit_stmt(*x.m_body[i]);
            if (i < x.n_body-1) {
                if (indent) s.append("\n" + indented);
                else s.append(" ");
            };
        }
        s.append("]");
        if(indent) {
            dec_indent();
            s.append("\n" + indented);
        }
        s.append(")");
    }
    void visit_ClassDefault(const ClassDefault_t &x) {
        s.append("(");
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("ClassDefault");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        if(indent) {
            inc_indent();
            s.append("\n" + indented);
        } else {
            s.append(" ");
        }
        if (x.m_trivia) {
            self().visit_trivia(*x.m_trivia);
        } else {
            s.append("()");
        }
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        s.append("[");
        for (size_t i=0; i<x.n_body; i++) {
            self().visit_stmt(*x.m_body[i]);
            if (i < x.n_body-1) {
                if (indent) s.append("\n" + indented);
                else s.append(" ");
            };
        }
        s.append("]");
        if(indent) {
            dec_indent();
            s.append("\n" + indented);
        }
        s.append(")");
    }
    void visit_UseSymbol(const UseSymbol_t &x) {
        s.append("(");
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("UseSymbol");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        if(indent) {
            inc_indent();
            s.append("\n" + indented);
        } else {
            s.append(" ");
        }
        s.append(x.m_remote_sym);
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        if (x.m_local_rename) {
            s.append(x.m_local_rename);
        } else {
            s.append("()");
        }
        if(indent) {
            dec_indent();
            s.append("\n" + indented);
        }
        s.append(")");
        if ((bool&)x) { } // Suppress unused warning
    }
    void visit_UseAssignment(const UseAssignment_t &x) {
        s.append("(");
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("UseAssignment");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        s.append(")");
        if ((bool&)x) { } // Suppress unused warning
    }
    void visit_IntrinsicOperator(const IntrinsicOperator_t &x) {
        s.append("(");
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("IntrinsicOperator");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        if(indent) {
            inc_indent();
            s.append("\n" + indented);
        } else {
            s.append(" ");
        }
        visit_intrinsicopType(x.m_op);
        if(indent) {
            dec_indent();
            s.append("\n" + indented);
        }
        s.append(")");
        if ((bool&)x) { } // Suppress unused warning
    }
    void visit_DefinedOperator(const DefinedOperator_t &x) {
        s.append("(");
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("DefinedOperator");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        if(indent) {
            inc_indent();
            s.append("\n" + indented);
        } else {
            s.append(" ");
        }
        s.append("\"" + str_escape_c(x.m_opName) + "\"");
        if(indent) {
            dec_indent();
            s.append("\n" + indented);
        }
        s.append(")");
        if ((bool&)x) { } // Suppress unused warning
    }
    void visit_RenameOperator(const RenameOperator_t &x) {
        s.append("(");
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("RenameOperator");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        if(indent) {
            inc_indent();
            s.append("\n" + indented);
        } else {
            s.append(" ");
        }
        s.append("\"" + str_escape_c(x.m_local_defop) + "\"");
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        s.append("\"" + str_escape_c(x.m_use_defop) + "\"");
        if(indent) {
            dec_indent();
            s.append("\n" + indented);
        }
        s.append(")");
        if ((bool&)x) { } // Suppress unused warning
    }
    void visit_UseWrite(const UseWrite_t &x) {
        s.append("(");
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("UseWrite");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        if(indent) {
            inc_indent();
            s.append("\n" + indented);
        } else {
            s.append(" ");
        }
        s.append(x.m_id);
        if(indent) {
            dec_indent();
            s.append("\n" + indented);
        }
        s.append(")");
        if ((bool&)x) { } // Suppress unused warning
    }
    void visit_UseRead(const UseRead_t &x) {
        s.append("(");
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("UseRead");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        if(indent) {
            inc_indent();
            s.append("\n" + indented);
        } else {
            s.append(" ");
        }
        s.append(x.m_id);
        if(indent) {
            dec_indent();
            s.append("\n" + indented);
        }
        s.append(")");
        if ((bool&)x) { } // Suppress unused warning
    }
    void visit_ConcurrentControl(const ConcurrentControl_t &x) {
        s.append("(");
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("ConcurrentControl");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        if(indent) {
            inc_indent();
            s.append("\n" + indented);
        } else {
            s.append(" ");
        }
        if (x.m_var) {
            s.append(x.m_var);
        } else {
            s.append("()");
        }
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        if (x.m_start) {
            self().visit_expr(*x.m_start);
        } else {
            s.append("()");
        }
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        if (x.m_end) {
            self().visit_expr(*x.m_end);
        } else {
            s.append("()");
        }
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        if (x.m_increment) {
            self().visit_expr(*x.m_increment);
        } else {
            s.append("()");
        }
        if(indent) {
            dec_indent();
            s.append("\n" + indented);
        }
        s.append(")");
    }
    void visit_ConcurrentLocal(const ConcurrentLocal_t &x) {
        s.append("(");
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("ConcurrentLocal");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        if(indent) {
            inc_indent();
            s.append("\n" + indented);
        } else {
            s.append(" ");
        }
        s.append("[");
        for (size_t i=0; i<x.n_vars; i++) {
            s.append(x.m_vars[i]);
            if (i < x.n_vars-1) {
                if (indent) s.append("\n" + indented);
                else s.append(" ");
            };
        }
        s.append("]");
        if(indent) {
            dec_indent();
            s.append("\n" + indented);
        }
        s.append(")");
        if ((bool&)x) { } // Suppress unused warning
    }
    void visit_ConcurrentLocalInit(const ConcurrentLocalInit_t &x) {
        s.append("(");
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("ConcurrentLocalInit");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        if(indent) {
            inc_indent();
            s.append("\n" + indented);
        } else {
            s.append(" ");
        }
        s.append("[");
        for (size_t i=0; i<x.n_vars; i++) {
            s.append(x.m_vars[i]);
            if (i < x.n_vars-1) {
                if (indent) s.append("\n" + indented);
                else s.append(" ");
            };
        }
        s.append("]");
        if(indent) {
            dec_indent();
            s.append("\n" + indented);
        }
        s.append(")");
        if ((bool&)x) { } // Suppress unused warning
    }
    void visit_ConcurrentShared(const ConcurrentShared_t &x) {
        s.append("(");
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("ConcurrentShared");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        if(indent) {
            inc_indent();
            s.append("\n" + indented);
        } else {
            s.append(" ");
        }
        s.append("[");
        for (size_t i=0; i<x.n_vars; i++) {
            s.append(x.m_vars[i]);
            if (i < x.n_vars-1) {
                if (indent) s.append("\n" + indented);
                else s.append(" ");
            };
        }
        s.append("]");
        if(indent) {
            dec_indent();
            s.append("\n" + indented);
        }
        s.append(")");
        if ((bool&)x) { } // Suppress unused warning
    }
    void visit_ConcurrentDefault(const ConcurrentDefault_t &x) {
        s.append("(");
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("ConcurrentDefault");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        s.append(")");
        if ((bool&)x) { } // Suppress unused warning
    }
    void visit_ConcurrentReduce(const ConcurrentReduce_t &x) {
        s.append("(");
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("ConcurrentReduce");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        if(indent) {
            inc_indent();
            s.append("\n" + indented);
        } else {
            s.append(" ");
        }
        visit_reduce_opType(x.m_op);
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        s.append("[");
        for (size_t i=0; i<x.n_vars; i++) {
            s.append(x.m_vars[i]);
            if (i < x.n_vars-1) {
                if (indent) s.append("\n" + indented);
                else s.append(" ");
            };
        }
        s.append("]");
        if(indent) {
            dec_indent();
            s.append("\n" + indented);
        }
        s.append(")");
        if ((bool&)x) { } // Suppress unused warning
    }
    void visit_reduce_opType(const reduce_opType &x) {
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::green));
        }
        switch (x) {
            case (reduce_opType::ReduceAdd) : {
                s.append("ReduceAdd");
             break; }
            case (reduce_opType::ReduceMul) : {
                s.append("ReduceMul");
             break; }
            case (reduce_opType::ReduceMIN) : {
                s.append("ReduceMIN");
             break; }
            case (reduce_opType::ReduceMAX) : {
                s.append("ReduceMAX");
             break; }
        }
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
    }
    void visit_DataStmtSet(const DataStmtSet_t &x) {
        s.append("(");
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("DataStmtSet");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        if(indent) {
            inc_indent();
            s.append("\n" + indented);
        } else {
            s.append(" ");
        }
        s.append("[");
        for (size_t i=0; i<x.n_object; i++) {
            self().visit_expr(*x.m_object[i]);
            if (i < x.n_object-1) {
                if (indent) s.append("\n" + indented);
                else s.append(" ");
            };
        }
        s.append("]");
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        s.append("[");
        for (size_t i=0; i<x.n_value; i++) {
            self().visit_expr(*x.m_value[i]);
            if (i < x.n_value-1) {
                if (indent) s.append("\n" + indented);
                else s.append(" ");
            };
        }
        s.append("]");
        if(indent) {
            dec_indent();
            s.append("\n" + indented);
        }
        s.append(")");
    }
    void visit_pragma_typeType(const pragma_typeType &x) {
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::green));
        }
        switch (x) {
            case (pragma_typeType::LFortranPragma) : {
                s.append("LFortranPragma");
             break; }
            case (pragma_typeType::OMPPragma) : {
                s.append("OMPPragma");
             break; }
        }
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
    }
    void visit_UnitRequire(const UnitRequire_t &x) {
        s.append("(");
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("UnitRequire");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        if(indent) {
            inc_indent();
            s.append("\n" + indented);
        } else {
            s.append(" ");
        }
        s.append(x.m_name);
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        s.append("[");
        for (size_t i=0; i<x.n_namelist; i++) {
            self().visit_decl_attribute(*x.m_namelist[i]);
            if (i < x.n_namelist-1) {
                if (indent) s.append("\n" + indented);
                else s.append(" ");
            };
        }
        s.append("]");
        if(indent) {
            dec_indent();
            s.append("\n" + indented);
        }
        s.append(")");
    }
};


/******************************************************************************/
// Json Visitor base class

template <class Struct>
class JsonBaseVisitor : public BaseVisitor<Struct>
{
private:
    Struct& self() { return static_cast<Struct&>(*this); }
public:
    std::string s, indtd = "";
    bool no_loc = false;
    int indent_level = 0, indent_spaces = 4;
    LocationManager &lm;
public:
    JsonBaseVisitor(LocationManager &lmref) : lm(lmref) {
        s.reserve(100000);
    }
    void inc_indent() {
        indent_level++;
        indtd = std::string(indent_level*indent_spaces, ' ');
    }
    void dec_indent() {
        indent_level--;
        LCOMPILERS_ASSERT(indent_level >= 0);
        indtd = std::string(indent_level*indent_spaces, ' ');
    }
    void append_location(std::string &s, uint32_t first, uint32_t last) {
        if (no_loc) return;
        s.append(",\n" + indtd);
        s.append("\"loc\": {");
        inc_indent();
        s.append("\n" + indtd);
        s.append("\"first\": " + std::to_string(first));
        s.append(",\n" + indtd);
        s.append("\"last\": " + std::to_string(last));

        uint32_t first_line = 0, first_col = 0;
        std::string first_filename;
        uint32_t last_line = 0, last_col = 0;
        std::string last_filename;

        lm.pos_to_linecol(first, first_line, first_col, first_filename);
        lm.pos_to_linecol(last, last_line, last_col, last_filename);

        s.append(",\n" + indtd);
        s.append("\"first_filename\": \"" + first_filename + "\"");
        s.append(",\n" + indtd);
        s.append("\"first_line\": " + std::to_string(first_line));
        s.append(",\n" + indtd);
        s.append("\"first_column\": " + std::to_string(first_col));
        s.append(",\n" + indtd);
        s.append("\"last_filename\": \"" + last_filename + "\"");
        s.append(",\n" + indtd);
        s.append("\"last_line\": " + std::to_string(last_line));
        s.append(",\n" + indtd);
        s.append("\"last_column\": " + std::to_string(last_col));

        dec_indent();
        s.append("\n" + indtd);
        s.append("}");
    }
    void visit_TranslationUnit(const TranslationUnit_t &x) {
        s.append("{");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"node\": \"TranslationUnit\"");
        s.append(",\n" + indtd);
        s.append("\"fields\": {");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"items\": ");
        s.append("[");
        if (x.n_items > 0) {
            inc_indent(); s.append("\n" + indtd);
            for (size_t i=0; i<x.n_items; i++) {
                self().visit_ast(*x.m_items[i]);
                if (i < x.n_items-1) {
                    s.append(",\n" + indtd);
                };
            }
            dec_indent(); s.append("\n" + indtd);
        }
        s.append("]");
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        append_location(s, x.base.base.loc.first, x.base.base.loc.last);
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        if ((bool&)x) { } // Suppress unused warning
    }
    void visit_Module(const Module_t &x) {
        s.append("{");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"node\": \"Module\"");
        s.append(",\n" + indtd);
        s.append("\"fields\": {");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"name\": ");
        s.append("\"" + std::string(x.m_name) + "\"");
        s.append(",\n" + indtd);
        s.append("\"trivia\": ");
        if (x.m_trivia) {
            self().visit_trivia(*x.m_trivia);
        } else {
            s.append("[]");
        }
        s.append(",\n" + indtd);
        s.append("\"use\": ");
        s.append("[");
        if (x.n_use > 0) {
            inc_indent(); s.append("\n" + indtd);
            for (size_t i=0; i<x.n_use; i++) {
                self().visit_unit_decl1(*x.m_use[i]);
                if (i < x.n_use-1) {
                    s.append(",\n" + indtd);
                };
            }
            dec_indent(); s.append("\n" + indtd);
        }
        s.append("]");
        s.append(",\n" + indtd);
        s.append("\"implicit\": ");
        s.append("[");
        if (x.n_implicit > 0) {
            inc_indent(); s.append("\n" + indtd);
            for (size_t i=0; i<x.n_implicit; i++) {
                self().visit_implicit_statement(*x.m_implicit[i]);
                if (i < x.n_implicit-1) {
                    s.append(",\n" + indtd);
                };
            }
            dec_indent(); s.append("\n" + indtd);
        }
        s.append("]");
        s.append(",\n" + indtd);
        s.append("\"decl\": ");
        s.append("[");
        if (x.n_decl > 0) {
            inc_indent(); s.append("\n" + indtd);
            for (size_t i=0; i<x.n_decl; i++) {
                self().visit_unit_decl2(*x.m_decl[i]);
                if (i < x.n_decl-1) {
                    s.append(",\n" + indtd);
                };
            }
            dec_indent(); s.append("\n" + indtd);
        }
        s.append("]");
        s.append(",\n" + indtd);
        s.append("\"contains\": ");
        s.append("[");
        if (x.n_contains > 0) {
            inc_indent(); s.append("\n" + indtd);
            for (size_t i=0; i<x.n_contains; i++) {
                self().visit_program_unit(*x.m_contains[i]);
                if (i < x.n_contains-1) {
                    s.append(",\n" + indtd);
                };
            }
            dec_indent(); s.append("\n" + indtd);
        }
        s.append("]");
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        append_location(s, x.base.base.loc.first, x.base.base.loc.last);
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        if ((bool&)x) { } // Suppress unused warning
    }
    void visit_Submodule(const Submodule_t &x) {
        s.append("{");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"node\": \"Submodule\"");
        s.append(",\n" + indtd);
        s.append("\"fields\": {");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"id\": ");
        s.append("\"" + std::string(x.m_id) + "\"");
        s.append(",\n" + indtd);
        s.append("\"parent_name\": ");
        if (x.m_parent_name) {
            s.append("\"" + std::string(x.m_parent_name) + "\"");
        } else {
            s.append("[]");
        }
        s.append(",\n" + indtd);
        s.append("\"name\": ");
        s.append("\"" + std::string(x.m_name) + "\"");
        s.append(",\n" + indtd);
        s.append("\"trivia\": ");
        if (x.m_trivia) {
            self().visit_trivia(*x.m_trivia);
        } else {
            s.append("[]");
        }
        s.append(",\n" + indtd);
        s.append("\"use\": ");
        s.append("[");
        if (x.n_use > 0) {
            inc_indent(); s.append("\n" + indtd);
            for (size_t i=0; i<x.n_use; i++) {
                self().visit_unit_decl1(*x.m_use[i]);
                if (i < x.n_use-1) {
                    s.append(",\n" + indtd);
                };
            }
            dec_indent(); s.append("\n" + indtd);
        }
        s.append("]");
        s.append(",\n" + indtd);
        s.append("\"implicit\": ");
        s.append("[");
        if (x.n_implicit > 0) {
            inc_indent(); s.append("\n" + indtd);
            for (size_t i=0; i<x.n_implicit; i++) {
                self().visit_implicit_statement(*x.m_implicit[i]);
                if (i < x.n_implicit-1) {
                    s.append(",\n" + indtd);
                };
            }
            dec_indent(); s.append("\n" + indtd);
        }
        s.append("]");
        s.append(",\n" + indtd);
        s.append("\"decl\": ");
        s.append("[");
        if (x.n_decl > 0) {
            inc_indent(); s.append("\n" + indtd);
            for (size_t i=0; i<x.n_decl; i++) {
                self().visit_unit_decl2(*x.m_decl[i]);
                if (i < x.n_decl-1) {
                    s.append(",\n" + indtd);
                };
            }
            dec_indent(); s.append("\n" + indtd);
        }
        s.append("]");
        s.append(",\n" + indtd);
        s.append("\"contains\": ");
        s.append("[");
        if (x.n_contains > 0) {
            inc_indent(); s.append("\n" + indtd);
            for (size_t i=0; i<x.n_contains; i++) {
                self().visit_program_unit(*x.m_contains[i]);
                if (i < x.n_contains-1) {
                    s.append(",\n" + indtd);
                };
            }
            dec_indent(); s.append("\n" + indtd);
        }
        s.append("]");
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        append_location(s, x.base.base.loc.first, x.base.base.loc.last);
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        if ((bool&)x) { } // Suppress unused warning
    }
    void visit_BlockData(const BlockData_t &x) {
        s.append("{");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"node\": \"BlockData\"");
        s.append(",\n" + indtd);
        s.append("\"fields\": {");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"name\": ");
        if (x.m_name) {
            s.append("\"" + std::string(x.m_name) + "\"");
        } else {
            s.append("[]");
        }
        s.append(",\n" + indtd);
        s.append("\"trivia\": ");
        if (x.m_trivia) {
            self().visit_trivia(*x.m_trivia);
        } else {
            s.append("[]");
        }
        s.append(",\n" + indtd);
        s.append("\"use\": ");
        s.append("[");
        if (x.n_use > 0) {
            inc_indent(); s.append("\n" + indtd);
            for (size_t i=0; i<x.n_use; i++) {
                self().visit_unit_decl1(*x.m_use[i]);
                if (i < x.n_use-1) {
                    s.append(",\n" + indtd);
                };
            }
            dec_indent(); s.append("\n" + indtd);
        }
        s.append("]");
        s.append(",\n" + indtd);
        s.append("\"implicit\": ");
        s.append("[");
        if (x.n_implicit > 0) {
            inc_indent(); s.append("\n" + indtd);
            for (size_t i=0; i<x.n_implicit; i++) {
                self().visit_implicit_statement(*x.m_implicit[i]);
                if (i < x.n_implicit-1) {
                    s.append(",\n" + indtd);
                };
            }
            dec_indent(); s.append("\n" + indtd);
        }
        s.append("]");
        s.append(",\n" + indtd);
        s.append("\"decl\": ");
        s.append("[");
        if (x.n_decl > 0) {
            inc_indent(); s.append("\n" + indtd);
            for (size_t i=0; i<x.n_decl; i++) {
                self().visit_unit_decl2(*x.m_decl[i]);
                if (i < x.n_decl-1) {
                    s.append(",\n" + indtd);
                };
            }
            dec_indent(); s.append("\n" + indtd);
        }
        s.append("]");
        s.append(",\n" + indtd);
        s.append("\"body\": ");
        s.append("[");
        if (x.n_body > 0) {
            inc_indent(); s.append("\n" + indtd);
            for (size_t i=0; i<x.n_body; i++) {
                self().visit_stmt(*x.m_body[i]);
                if (i < x.n_body-1) {
                    s.append(",\n" + indtd);
                };
            }
            dec_indent(); s.append("\n" + indtd);
        }
        s.append("]");
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        append_location(s, x.base.base.loc.first, x.base.base.loc.last);
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        if ((bool&)x) { } // Suppress unused warning
    }
    void visit_Program(const Program_t &x) {
        s.append("{");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"node\": \"Program\"");
        s.append(",\n" + indtd);
        s.append("\"fields\": {");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"name\": ");
        s.append("\"" + std::string(x.m_name) + "\"");
        s.append(",\n" + indtd);
        s.append("\"trivia\": ");
        if (x.m_trivia) {
            self().visit_trivia(*x.m_trivia);
        } else {
            s.append("[]");
        }
        s.append(",\n" + indtd);
        s.append("\"use\": ");
        s.append("[");
        if (x.n_use > 0) {
            inc_indent(); s.append("\n" + indtd);
            for (size_t i=0; i<x.n_use; i++) {
                self().visit_unit_decl1(*x.m_use[i]);
                if (i < x.n_use-1) {
                    s.append(",\n" + indtd);
                };
            }
            dec_indent(); s.append("\n" + indtd);
        }
        s.append("]");
        s.append(",\n" + indtd);
        s.append("\"implicit\": ");
        s.append("[");
        if (x.n_implicit > 0) {
            inc_indent(); s.append("\n" + indtd);
            for (size_t i=0; i<x.n_implicit; i++) {
                self().visit_implicit_statement(*x.m_implicit[i]);
                if (i < x.n_implicit-1) {
                    s.append(",\n" + indtd);
                };
            }
            dec_indent(); s.append("\n" + indtd);
        }
        s.append("]");
        s.append(",\n" + indtd);
        s.append("\"decl\": ");
        s.append("[");
        if (x.n_decl > 0) {
            inc_indent(); s.append("\n" + indtd);
            for (size_t i=0; i<x.n_decl; i++) {
                self().visit_unit_decl2(*x.m_decl[i]);
                if (i < x.n_decl-1) {
                    s.append(",\n" + indtd);
                };
            }
            dec_indent(); s.append("\n" + indtd);
        }
        s.append("]");
        s.append(",\n" + indtd);
        s.append("\"body\": ");
        s.append("[");
        if (x.n_body > 0) {
            inc_indent(); s.append("\n" + indtd);
            for (size_t i=0; i<x.n_body; i++) {
                self().visit_stmt(*x.m_body[i]);
                if (i < x.n_body-1) {
                    s.append(",\n" + indtd);
                };
            }
            dec_indent(); s.append("\n" + indtd);
        }
        s.append("]");
        s.append(",\n" + indtd);
        s.append("\"contains\": ");
        s.append("[");
        if (x.n_contains > 0) {
            inc_indent(); s.append("\n" + indtd);
            for (size_t i=0; i<x.n_contains; i++) {
                self().visit_program_unit(*x.m_contains[i]);
                if (i < x.n_contains-1) {
                    s.append(",\n" + indtd);
                };
            }
            dec_indent(); s.append("\n" + indtd);
        }
        s.append("]");
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        append_location(s, x.base.base.loc.first, x.base.base.loc.last);
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        if ((bool&)x) { } // Suppress unused warning
    }
    void visit_Subroutine(const Subroutine_t &x) {
        s.append("{");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"node\": \"Subroutine\"");
        s.append(",\n" + indtd);
        s.append("\"fields\": {");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"name\": ");
        s.append("\"" + std::string(x.m_name) + "\"");
        s.append(",\n" + indtd);
        s.append("\"args\": ");
        s.append("[");
        if (x.n_args > 0) {
            inc_indent(); s.append("\n" + indtd);
            for (size_t i=0; i<x.n_args; i++) {
                self().visit_arg(x.m_args[i]);
                if (i < x.n_args-1) {
                    s.append(",\n" + indtd);
                };
            }
            dec_indent(); s.append("\n" + indtd);
        }
        s.append("]");
        s.append(",\n" + indtd);
        s.append("\"attributes\": ");
        s.append("[");
        if (x.n_attributes > 0) {
            inc_indent(); s.append("\n" + indtd);
            for (size_t i=0; i<x.n_attributes; i++) {
                self().visit_decl_attribute(*x.m_attributes[i]);
                if (i < x.n_attributes-1) {
                    s.append(",\n" + indtd);
                };
            }
            dec_indent(); s.append("\n" + indtd);
        }
        s.append("]");
        s.append(",\n" + indtd);
        s.append("\"bind\": ");
        if (x.m_bind) {
            self().visit_bind(*x.m_bind);
        } else {
            s.append("[]");
        }
        s.append(",\n" + indtd);
        s.append("\"trivia\": ");
        if (x.m_trivia) {
            self().visit_trivia(*x.m_trivia);
        } else {
            s.append("[]");
        }
        s.append(",\n" + indtd);
        s.append("\"use\": ");
        s.append("[");
        if (x.n_use > 0) {
            inc_indent(); s.append("\n" + indtd);
            for (size_t i=0; i<x.n_use; i++) {
                self().visit_unit_decl1(*x.m_use[i]);
                if (i < x.n_use-1) {
                    s.append(",\n" + indtd);
                };
            }
            dec_indent(); s.append("\n" + indtd);
        }
        s.append("]");
        s.append(",\n" + indtd);
        s.append("\"import\": ");
        s.append("[");
        if (x.n_import > 0) {
            inc_indent(); s.append("\n" + indtd);
            for (size_t i=0; i<x.n_import; i++) {
                self().visit_import_statement(*x.m_import[i]);
                if (i < x.n_import-1) {
                    s.append(",\n" + indtd);
                };
            }
            dec_indent(); s.append("\n" + indtd);
        }
        s.append("]");
        s.append(",\n" + indtd);
        s.append("\"implicit\": ");
        s.append("[");
        if (x.n_implicit > 0) {
            inc_indent(); s.append("\n" + indtd);
            for (size_t i=0; i<x.n_implicit; i++) {
                self().visit_implicit_statement(*x.m_implicit[i]);
                if (i < x.n_implicit-1) {
                    s.append(",\n" + indtd);
                };
            }
            dec_indent(); s.append("\n" + indtd);
        }
        s.append("]");
        s.append(",\n" + indtd);
        s.append("\"decl\": ");
        s.append("[");
        if (x.n_decl > 0) {
            inc_indent(); s.append("\n" + indtd);
            for (size_t i=0; i<x.n_decl; i++) {
                self().visit_unit_decl2(*x.m_decl[i]);
                if (i < x.n_decl-1) {
                    s.append(",\n" + indtd);
                };
            }
            dec_indent(); s.append("\n" + indtd);
        }
        s.append("]");
        s.append(",\n" + indtd);
        s.append("\"body\": ");
        s.append("[");
        if (x.n_body > 0) {
            inc_indent(); s.append("\n" + indtd);
            for (size_t i=0; i<x.n_body; i++) {
                self().visit_stmt(*x.m_body[i]);
                if (i < x.n_body-1) {
                    s.append(",\n" + indtd);
                };
            }
            dec_indent(); s.append("\n" + indtd);
        }
        s.append("]");
        s.append(",\n" + indtd);
        s.append("\"contains\": ");
        s.append("[");
        if (x.n_contains > 0) {
            inc_indent(); s.append("\n" + indtd);
            for (size_t i=0; i<x.n_contains; i++) {
                self().visit_program_unit(*x.m_contains[i]);
                if (i < x.n_contains-1) {
                    s.append(",\n" + indtd);
                };
            }
            dec_indent(); s.append("\n" + indtd);
        }
        s.append("]");
        s.append(",\n" + indtd);
        s.append("\"temp_args\": ");
        s.append("[");
        if (x.n_temp_args > 0) {
            inc_indent(); s.append("\n" + indtd);
            for (size_t i=0; i<x.n_temp_args; i++) {
                s.append("\"" + std::string(x.m_temp_args[i]) + "\"");
                if (i < x.n_temp_args-1) {
                    s.append(",\n" + indtd);
                };
            }
            dec_indent(); s.append("\n" + indtd);
        }
        s.append("]");
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        append_location(s, x.base.base.loc.first, x.base.base.loc.last);
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        if ((bool&)x) { } // Suppress unused warning
    }
    void visit_Procedure(const Procedure_t &x) {
        s.append("{");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"node\": \"Procedure\"");
        s.append(",\n" + indtd);
        s.append("\"fields\": {");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"name\": ");
        s.append("\"" + std::string(x.m_name) + "\"");
        s.append(",\n" + indtd);
        s.append("\"args\": ");
        s.append("[");
        if (x.n_args > 0) {
            inc_indent(); s.append("\n" + indtd);
            for (size_t i=0; i<x.n_args; i++) {
                self().visit_arg(x.m_args[i]);
                if (i < x.n_args-1) {
                    s.append(",\n" + indtd);
                };
            }
            dec_indent(); s.append("\n" + indtd);
        }
        s.append("]");
        s.append(",\n" + indtd);
        s.append("\"attributes\": ");
        s.append("[");
        if (x.n_attributes > 0) {
            inc_indent(); s.append("\n" + indtd);
            for (size_t i=0; i<x.n_attributes; i++) {
                self().visit_decl_attribute(*x.m_attributes[i]);
                if (i < x.n_attributes-1) {
                    s.append(",\n" + indtd);
                };
            }
            dec_indent(); s.append("\n" + indtd);
        }
        s.append("]");
        s.append(",\n" + indtd);
        s.append("\"trivia\": ");
        if (x.m_trivia) {
            self().visit_trivia(*x.m_trivia);
        } else {
            s.append("[]");
        }
        s.append(",\n" + indtd);
        s.append("\"use\": ");
        s.append("[");
        if (x.n_use > 0) {
            inc_indent(); s.append("\n" + indtd);
            for (size_t i=0; i<x.n_use; i++) {
                self().visit_unit_decl1(*x.m_use[i]);
                if (i < x.n_use-1) {
                    s.append(",\n" + indtd);
                };
            }
            dec_indent(); s.append("\n" + indtd);
        }
        s.append("]");
        s.append(",\n" + indtd);
        s.append("\"import\": ");
        s.append("[");
        if (x.n_import > 0) {
            inc_indent(); s.append("\n" + indtd);
            for (size_t i=0; i<x.n_import; i++) {
                self().visit_import_statement(*x.m_import[i]);
                if (i < x.n_import-1) {
                    s.append(",\n" + indtd);
                };
            }
            dec_indent(); s.append("\n" + indtd);
        }
        s.append("]");
        s.append(",\n" + indtd);
        s.append("\"implicit\": ");
        s.append("[");
        if (x.n_implicit > 0) {
            inc_indent(); s.append("\n" + indtd);
            for (size_t i=0; i<x.n_implicit; i++) {
                self().visit_implicit_statement(*x.m_implicit[i]);
                if (i < x.n_implicit-1) {
                    s.append(",\n" + indtd);
                };
            }
            dec_indent(); s.append("\n" + indtd);
        }
        s.append("]");
        s.append(",\n" + indtd);
        s.append("\"decl\": ");
        s.append("[");
        if (x.n_decl > 0) {
            inc_indent(); s.append("\n" + indtd);
            for (size_t i=0; i<x.n_decl; i++) {
                self().visit_unit_decl2(*x.m_decl[i]);
                if (i < x.n_decl-1) {
                    s.append(",\n" + indtd);
                };
            }
            dec_indent(); s.append("\n" + indtd);
        }
        s.append("]");
        s.append(",\n" + indtd);
        s.append("\"body\": ");
        s.append("[");
        if (x.n_body > 0) {
            inc_indent(); s.append("\n" + indtd);
            for (size_t i=0; i<x.n_body; i++) {
                self().visit_stmt(*x.m_body[i]);
                if (i < x.n_body-1) {
                    s.append(",\n" + indtd);
                };
            }
            dec_indent(); s.append("\n" + indtd);
        }
        s.append("]");
        s.append(",\n" + indtd);
        s.append("\"contains\": ");
        s.append("[");
        if (x.n_contains > 0) {
            inc_indent(); s.append("\n" + indtd);
            for (size_t i=0; i<x.n_contains; i++) {
                self().visit_program_unit(*x.m_contains[i]);
                if (i < x.n_contains-1) {
                    s.append(",\n" + indtd);
                };
            }
            dec_indent(); s.append("\n" + indtd);
        }
        s.append("]");
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        append_location(s, x.base.base.loc.first, x.base.base.loc.last);
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        if ((bool&)x) { } // Suppress unused warning
    }
    void visit_Function(const Function_t &x) {
        s.append("{");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"node\": \"Function\"");
        s.append(",\n" + indtd);
        s.append("\"fields\": {");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"name\": ");
        s.append("\"" + std::string(x.m_name) + "\"");
        s.append(",\n" + indtd);
        s.append("\"args\": ");
        s.append("[");
        if (x.n_args > 0) {
            inc_indent(); s.append("\n" + indtd);
            for (size_t i=0; i<x.n_args; i++) {
                self().visit_arg(x.m_args[i]);
                if (i < x.n_args-1) {
                    s.append(",\n" + indtd);
                };
            }
            dec_indent(); s.append("\n" + indtd);
        }
        s.append("]");
        s.append(",\n" + indtd);
        s.append("\"attributes\": ");
        s.append("[");
        if (x.n_attributes > 0) {
            inc_indent(); s.append("\n" + indtd);
            for (size_t i=0; i<x.n_attributes; i++) {
                self().visit_decl_attribute(*x.m_attributes[i]);
                if (i < x.n_attributes-1) {
                    s.append(",\n" + indtd);
                };
            }
            dec_indent(); s.append("\n" + indtd);
        }
        s.append("]");
        s.append(",\n" + indtd);
        s.append("\"return_var\": ");
        if (x.m_return_var) {
            self().visit_expr(*x.m_return_var);
        } else {
            s.append("[]");
        }
        s.append(",\n" + indtd);
        s.append("\"bind\": ");
        if (x.m_bind) {
            self().visit_bind(*x.m_bind);
        } else {
            s.append("[]");
        }
        s.append(",\n" + indtd);
        s.append("\"trivia\": ");
        if (x.m_trivia) {
            self().visit_trivia(*x.m_trivia);
        } else {
            s.append("[]");
        }
        s.append(",\n" + indtd);
        s.append("\"use\": ");
        s.append("[");
        if (x.n_use > 0) {
            inc_indent(); s.append("\n" + indtd);
            for (size_t i=0; i<x.n_use; i++) {
                self().visit_unit_decl1(*x.m_use[i]);
                if (i < x.n_use-1) {
                    s.append(",\n" + indtd);
                };
            }
            dec_indent(); s.append("\n" + indtd);
        }
        s.append("]");
        s.append(",\n" + indtd);
        s.append("\"import\": ");
        s.append("[");
        if (x.n_import > 0) {
            inc_indent(); s.append("\n" + indtd);
            for (size_t i=0; i<x.n_import; i++) {
                self().visit_import_statement(*x.m_import[i]);
                if (i < x.n_import-1) {
                    s.append(",\n" + indtd);
                };
            }
            dec_indent(); s.append("\n" + indtd);
        }
        s.append("]");
        s.append(",\n" + indtd);
        s.append("\"implicit\": ");
        s.append("[");
        if (x.n_implicit > 0) {
            inc_indent(); s.append("\n" + indtd);
            for (size_t i=0; i<x.n_implicit; i++) {
                self().visit_implicit_statement(*x.m_implicit[i]);
                if (i < x.n_implicit-1) {
                    s.append(",\n" + indtd);
                };
            }
            dec_indent(); s.append("\n" + indtd);
        }
        s.append("]");
        s.append(",\n" + indtd);
        s.append("\"decl\": ");
        s.append("[");
        if (x.n_decl > 0) {
            inc_indent(); s.append("\n" + indtd);
            for (size_t i=0; i<x.n_decl; i++) {
                self().visit_unit_decl2(*x.m_decl[i]);
                if (i < x.n_decl-1) {
                    s.append(",\n" + indtd);
                };
            }
            dec_indent(); s.append("\n" + indtd);
        }
        s.append("]");
        s.append(",\n" + indtd);
        s.append("\"body\": ");
        s.append("[");
        if (x.n_body > 0) {
            inc_indent(); s.append("\n" + indtd);
            for (size_t i=0; i<x.n_body; i++) {
                self().visit_stmt(*x.m_body[i]);
                if (i < x.n_body-1) {
                    s.append(",\n" + indtd);
                };
            }
            dec_indent(); s.append("\n" + indtd);
        }
        s.append("]");
        s.append(",\n" + indtd);
        s.append("\"contains\": ");
        s.append("[");
        if (x.n_contains > 0) {
            inc_indent(); s.append("\n" + indtd);
            for (size_t i=0; i<x.n_contains; i++) {
                self().visit_program_unit(*x.m_contains[i]);
                if (i < x.n_contains-1) {
                    s.append(",\n" + indtd);
                };
            }
            dec_indent(); s.append("\n" + indtd);
        }
        s.append("]");
        s.append(",\n" + indtd);
        s.append("\"temp_args\": ");
        s.append("[");
        if (x.n_temp_args > 0) {
            inc_indent(); s.append("\n" + indtd);
            for (size_t i=0; i<x.n_temp_args; i++) {
                s.append("\"" + std::string(x.m_temp_args[i]) + "\"");
                if (i < x.n_temp_args-1) {
                    s.append(",\n" + indtd);
                };
            }
            dec_indent(); s.append("\n" + indtd);
        }
        s.append("]");
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        append_location(s, x.base.base.loc.first, x.base.base.loc.last);
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        if ((bool&)x) { } // Suppress unused warning
    }
    void visit_Use(const Use_t &x) {
        s.append("{");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"node\": \"Use\"");
        s.append(",\n" + indtd);
        s.append("\"fields\": {");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"nature\": ");
        s.append("[");
        if (x.n_nature > 0) {
            inc_indent(); s.append("\n" + indtd);
            for (size_t i=0; i<x.n_nature; i++) {
                self().visit_decl_attribute(*x.m_nature[i]);
                if (i < x.n_nature-1) {
                    s.append(",\n" + indtd);
                };
            }
            dec_indent(); s.append("\n" + indtd);
        }
        s.append("]");
        s.append(",\n" + indtd);
        s.append("\"module\": ");
        s.append("\"" + std::string(x.m_module) + "\"");
        s.append(",\n" + indtd);
        s.append("\"symbols\": ");
        s.append("[");
        if (x.n_symbols > 0) {
            inc_indent(); s.append("\n" + indtd);
            for (size_t i=0; i<x.n_symbols; i++) {
                self().visit_use_symbol(*x.m_symbols[i]);
                if (i < x.n_symbols-1) {
                    s.append(",\n" + indtd);
                };
            }
            dec_indent(); s.append("\n" + indtd);
        }
        s.append("]");
        s.append(",\n" + indtd);
        s.append("\"only_present\": ");
        if (x.m_only_present) {
            s.append("true");
        } else {
            s.append("false");
        }
        s.append(",\n" + indtd);
        s.append("\"trivia\": ");
        if (x.m_trivia) {
            self().visit_trivia(*x.m_trivia);
        } else {
            s.append("[]");
        }
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        append_location(s, x.base.base.loc.first, x.base.base.loc.last);
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        if ((bool&)x) { } // Suppress unused warning
    }
    void visit_Declaration(const Declaration_t &x) {
        s.append("{");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"node\": \"Declaration\"");
        s.append(",\n" + indtd);
        s.append("\"fields\": {");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"vartype\": ");
        if (x.m_vartype) {
            self().visit_decl_attribute(*x.m_vartype);
        } else {
            s.append("[]");
        }
        s.append(",\n" + indtd);
        s.append("\"attributes\": ");
        s.append("[");
        if (x.n_attributes > 0) {
            inc_indent(); s.append("\n" + indtd);
            for (size_t i=0; i<x.n_attributes; i++) {
                self().visit_decl_attribute(*x.m_attributes[i]);
                if (i < x.n_attributes-1) {
                    s.append(",\n" + indtd);
                };
            }
            dec_indent(); s.append("\n" + indtd);
        }
        s.append("]");
        s.append(",\n" + indtd);
        s.append("\"syms\": ");
        s.append("[");
        if (x.n_syms > 0) {
            inc_indent(); s.append("\n" + indtd);
            for (size_t i=0; i<x.n_syms; i++) {
                self().visit_var_sym(x.m_syms[i]);
                if (i < x.n_syms-1) {
                    s.append(",\n" + indtd);
                };
            }
            dec_indent(); s.append("\n" + indtd);
        }
        s.append("]");
        s.append(",\n" + indtd);
        s.append("\"trivia\": ");
        if (x.m_trivia) {
            self().visit_trivia(*x.m_trivia);
        } else {
            s.append("[]");
        }
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        append_location(s, x.base.base.loc.first, x.base.base.loc.last);
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        if ((bool&)x) { } // Suppress unused warning
    }
    void visit_DeclarationPragma(const DeclarationPragma_t &x) {
        s.append("{");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"node\": \"DeclarationPragma\"");
        s.append(",\n" + indtd);
        s.append("\"fields\": {");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"type\": ");
        visit_pragma_typeType(x.m_type);
        s.append(",\n" + indtd);
        s.append("\"text\": ");
        s.append("\"" + str_escape_c(x.m_text) + "\"");
        s.append(",\n" + indtd);
        s.append("\"trivia\": ");
        if (x.m_trivia) {
            self().visit_trivia(*x.m_trivia);
        } else {
            s.append("[]");
        }
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        append_location(s, x.base.base.loc.first, x.base.base.loc.last);
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        if ((bool&)x) { } // Suppress unused warning
    }
    void visit_Interface(const Interface_t &x) {
        s.append("{");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"node\": \"Interface\"");
        s.append(",\n" + indtd);
        s.append("\"fields\": {");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"header\": ");
        self().visit_interface_header(*x.m_header);
        s.append(",\n" + indtd);
        s.append("\"trivia\": ");
        if (x.m_trivia) {
            self().visit_trivia(*x.m_trivia);
        } else {
            s.append("[]");
        }
        s.append(",\n" + indtd);
        s.append("\"items\": ");
        s.append("[");
        if (x.n_items > 0) {
            inc_indent(); s.append("\n" + indtd);
            for (size_t i=0; i<x.n_items; i++) {
                self().visit_interface_item(*x.m_items[i]);
                if (i < x.n_items-1) {
                    s.append(",\n" + indtd);
                };
            }
            dec_indent(); s.append("\n" + indtd);
        }
        s.append("]");
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        append_location(s, x.base.base.loc.first, x.base.base.loc.last);
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        if ((bool&)x) { } // Suppress unused warning
    }
    void visit_DerivedType(const DerivedType_t &x) {
        s.append("{");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"node\": \"DerivedType\"");
        s.append(",\n" + indtd);
        s.append("\"fields\": {");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"name\": ");
        s.append("\"" + std::string(x.m_name) + "\"");
        s.append(",\n" + indtd);
        s.append("\"namelist\": ");
        s.append("[");
        if (x.n_namelist > 0) {
            inc_indent(); s.append("\n" + indtd);
            for (size_t i=0; i<x.n_namelist; i++) {
                s.append("\"" + std::string(x.m_namelist[i]) + "\"");
                if (i < x.n_namelist-1) {
                    s.append(",\n" + indtd);
                };
            }
            dec_indent(); s.append("\n" + indtd);
        }
        s.append("]");
        s.append(",\n" + indtd);
        s.append("\"trivia\": ");
        if (x.m_trivia) {
            self().visit_trivia(*x.m_trivia);
        } else {
            s.append("[]");
        }
        s.append(",\n" + indtd);
        s.append("\"attrtype\": ");
        s.append("[");
        if (x.n_attrtype > 0) {
            inc_indent(); s.append("\n" + indtd);
            for (size_t i=0; i<x.n_attrtype; i++) {
                self().visit_decl_attribute(*x.m_attrtype[i]);
                if (i < x.n_attrtype-1) {
                    s.append(",\n" + indtd);
                };
            }
            dec_indent(); s.append("\n" + indtd);
        }
        s.append("]");
        s.append(",\n" + indtd);
        s.append("\"items\": ");
        s.append("[");
        if (x.n_items > 0) {
            inc_indent(); s.append("\n" + indtd);
            for (size_t i=0; i<x.n_items; i++) {
                self().visit_unit_decl2(*x.m_items[i]);
                if (i < x.n_items-1) {
                    s.append(",\n" + indtd);
                };
            }
            dec_indent(); s.append("\n" + indtd);
        }
        s.append("]");
        s.append(",\n" + indtd);
        s.append("\"contains\": ");
        s.append("[");
        if (x.n_contains > 0) {
            inc_indent(); s.append("\n" + indtd);
            for (size_t i=0; i<x.n_contains; i++) {
                self().visit_procedure_decl(*x.m_contains[i]);
                if (i < x.n_contains-1) {
                    s.append(",\n" + indtd);
                };
            }
            dec_indent(); s.append("\n" + indtd);
        }
        s.append("]");
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        append_location(s, x.base.base.loc.first, x.base.base.loc.last);
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        if ((bool&)x) { } // Suppress unused warning
    }
    void visit_Template(const Template_t &x) {
        s.append("{");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"node\": \"Template\"");
        s.append(",\n" + indtd);
        s.append("\"fields\": {");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"name\": ");
        s.append("\"" + std::string(x.m_name) + "\"");
        s.append(",\n" + indtd);
        s.append("\"namelist\": ");
        s.append("[");
        if (x.n_namelist > 0) {
            inc_indent(); s.append("\n" + indtd);
            for (size_t i=0; i<x.n_namelist; i++) {
                s.append("\"" + std::string(x.m_namelist[i]) + "\"");
                if (i < x.n_namelist-1) {
                    s.append(",\n" + indtd);
                };
            }
            dec_indent(); s.append("\n" + indtd);
        }
        s.append("]");
        s.append(",\n" + indtd);
        s.append("\"decl\": ");
        s.append("[");
        if (x.n_decl > 0) {
            inc_indent(); s.append("\n" + indtd);
            for (size_t i=0; i<x.n_decl; i++) {
                self().visit_unit_decl2(*x.m_decl[i]);
                if (i < x.n_decl-1) {
                    s.append(",\n" + indtd);
                };
            }
            dec_indent(); s.append("\n" + indtd);
        }
        s.append("]");
        s.append(",\n" + indtd);
        s.append("\"contains\": ");
        s.append("[");
        if (x.n_contains > 0) {
            inc_indent(); s.append("\n" + indtd);
            for (size_t i=0; i<x.n_contains; i++) {
                self().visit_program_unit(*x.m_contains[i]);
                if (i < x.n_contains-1) {
                    s.append(",\n" + indtd);
                };
            }
            dec_indent(); s.append("\n" + indtd);
        }
        s.append("]");
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        append_location(s, x.base.base.loc.first, x.base.base.loc.last);
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        if ((bool&)x) { } // Suppress unused warning
    }
    void visit_Enum(const Enum_t &x) {
        s.append("{");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"node\": \"Enum\"");
        s.append(",\n" + indtd);
        s.append("\"fields\": {");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"attr\": ");
        s.append("[");
        if (x.n_attr > 0) {
            inc_indent(); s.append("\n" + indtd);
            for (size_t i=0; i<x.n_attr; i++) {
                self().visit_decl_attribute(*x.m_attr[i]);
                if (i < x.n_attr-1) {
                    s.append(",\n" + indtd);
                };
            }
            dec_indent(); s.append("\n" + indtd);
        }
        s.append("]");
        s.append(",\n" + indtd);
        s.append("\"trivia\": ");
        if (x.m_trivia) {
            self().visit_trivia(*x.m_trivia);
        } else {
            s.append("[]");
        }
        s.append(",\n" + indtd);
        s.append("\"items\": ");
        s.append("[");
        if (x.n_items > 0) {
            inc_indent(); s.append("\n" + indtd);
            for (size_t i=0; i<x.n_items; i++) {
                self().visit_unit_decl2(*x.m_items[i]);
                if (i < x.n_items-1) {
                    s.append(",\n" + indtd);
                };
            }
            dec_indent(); s.append("\n" + indtd);
        }
        s.append("]");
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        append_location(s, x.base.base.loc.first, x.base.base.loc.last);
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        if ((bool&)x) { } // Suppress unused warning
    }
    void visit_Instantiate(const Instantiate_t &x) {
        s.append("{");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"node\": \"Instantiate\"");
        s.append(",\n" + indtd);
        s.append("\"fields\": {");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"name\": ");
        s.append("\"" + std::string(x.m_name) + "\"");
        s.append(",\n" + indtd);
        s.append("\"args\": ");
        s.append("[");
        if (x.n_args > 0) {
            inc_indent(); s.append("\n" + indtd);
            for (size_t i=0; i<x.n_args; i++) {
                self().visit_decl_attribute(*x.m_args[i]);
                if (i < x.n_args-1) {
                    s.append(",\n" + indtd);
                };
            }
            dec_indent(); s.append("\n" + indtd);
        }
        s.append("]");
        s.append(",\n" + indtd);
        s.append("\"symbols\": ");
        s.append("[");
        if (x.n_symbols > 0) {
            inc_indent(); s.append("\n" + indtd);
            for (size_t i=0; i<x.n_symbols; i++) {
                self().visit_use_symbol(*x.m_symbols[i]);
                if (i < x.n_symbols-1) {
                    s.append(",\n" + indtd);
                };
            }
            dec_indent(); s.append("\n" + indtd);
        }
        s.append("]");
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        append_location(s, x.base.base.loc.first, x.base.base.loc.last);
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        if ((bool&)x) { } // Suppress unused warning
    }
    void visit_Requirement(const Requirement_t &x) {
        s.append("{");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"node\": \"Requirement\"");
        s.append(",\n" + indtd);
        s.append("\"fields\": {");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"name\": ");
        s.append("\"" + std::string(x.m_name) + "\"");
        s.append(",\n" + indtd);
        s.append("\"namelist\": ");
        s.append("[");
        if (x.n_namelist > 0) {
            inc_indent(); s.append("\n" + indtd);
            for (size_t i=0; i<x.n_namelist; i++) {
                s.append("\"" + std::string(x.m_namelist[i]) + "\"");
                if (i < x.n_namelist-1) {
                    s.append(",\n" + indtd);
                };
            }
            dec_indent(); s.append("\n" + indtd);
        }
        s.append("]");
        s.append(",\n" + indtd);
        s.append("\"decl\": ");
        s.append("[");
        if (x.n_decl > 0) {
            inc_indent(); s.append("\n" + indtd);
            for (size_t i=0; i<x.n_decl; i++) {
                self().visit_unit_decl2(*x.m_decl[i]);
                if (i < x.n_decl-1) {
                    s.append(",\n" + indtd);
                };
            }
            dec_indent(); s.append("\n" + indtd);
        }
        s.append("]");
        s.append(",\n" + indtd);
        s.append("\"funcs\": ");
        s.append("[");
        if (x.n_funcs > 0) {
            inc_indent(); s.append("\n" + indtd);
            for (size_t i=0; i<x.n_funcs; i++) {
                self().visit_program_unit(*x.m_funcs[i]);
                if (i < x.n_funcs-1) {
                    s.append(",\n" + indtd);
                };
            }
            dec_indent(); s.append("\n" + indtd);
        }
        s.append("]");
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        append_location(s, x.base.base.loc.first, x.base.base.loc.last);
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        if ((bool&)x) { } // Suppress unused warning
    }
    void visit_Require(const Require_t &x) {
        s.append("{");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"node\": \"Require\"");
        s.append(",\n" + indtd);
        s.append("\"fields\": {");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"reqs\": ");
        s.append("[");
        if (x.n_reqs > 0) {
            inc_indent(); s.append("\n" + indtd);
            for (size_t i=0; i<x.n_reqs; i++) {
                self().visit_unit_require(*x.m_reqs[i]);
                if (i < x.n_reqs-1) {
                    s.append(",\n" + indtd);
                };
            }
            dec_indent(); s.append("\n" + indtd);
        }
        s.append("]");
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        append_location(s, x.base.base.loc.first, x.base.base.loc.last);
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        if ((bool&)x) { } // Suppress unused warning
    }
    void visit_InterfaceHeader(const InterfaceHeader_t &x) {
        s.append("{");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"node\": \"InterfaceHeader\"");
        s.append(",\n" + indtd);
        s.append("\"fields\": {");
        s.append("}");
        append_location(s, x.base.base.loc.first, x.base.base.loc.last);
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        if ((bool&)x) { } // Suppress unused warning
    }
    void visit_InterfaceHeaderName(const InterfaceHeaderName_t &x) {
        s.append("{");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"node\": \"InterfaceHeaderName\"");
        s.append(",\n" + indtd);
        s.append("\"fields\": {");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"name\": ");
        s.append("\"" + std::string(x.m_name) + "\"");
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        append_location(s, x.base.base.loc.first, x.base.base.loc.last);
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        if ((bool&)x) { } // Suppress unused warning
    }
    void visit_InterfaceHeaderAssignment(const InterfaceHeaderAssignment_t &x) {
        s.append("{");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"node\": \"InterfaceHeaderAssignment\"");
        s.append(",\n" + indtd);
        s.append("\"fields\": {");
        s.append("}");
        append_location(s, x.base.base.loc.first, x.base.base.loc.last);
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        if ((bool&)x) { } // Suppress unused warning
    }
    void visit_InterfaceHeaderOperator(const InterfaceHeaderOperator_t &x) {
        s.append("{");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"node\": \"InterfaceHeaderOperator\"");
        s.append(",\n" + indtd);
        s.append("\"fields\": {");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"op\": ");
        visit_intrinsicopType(x.m_op);
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        append_location(s, x.base.base.loc.first, x.base.base.loc.last);
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        if ((bool&)x) { } // Suppress unused warning
    }
    void visit_InterfaceHeaderDefinedOperator(const InterfaceHeaderDefinedOperator_t &x) {
        s.append("{");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"node\": \"InterfaceHeaderDefinedOperator\"");
        s.append(",\n" + indtd);
        s.append("\"fields\": {");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"operator_name\": ");
        s.append("\"" + str_escape_c(x.m_operator_name) + "\"");
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        append_location(s, x.base.base.loc.first, x.base.base.loc.last);
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        if ((bool&)x) { } // Suppress unused warning
    }
    void visit_AbstractInterfaceHeader(const AbstractInterfaceHeader_t &x) {
        s.append("{");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"node\": \"AbstractInterfaceHeader\"");
        s.append(",\n" + indtd);
        s.append("\"fields\": {");
        s.append("}");
        append_location(s, x.base.base.loc.first, x.base.base.loc.last);
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        if ((bool&)x) { } // Suppress unused warning
    }
    void visit_InterfaceHeaderWrite(const InterfaceHeaderWrite_t &x) {
        s.append("{");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"node\": \"InterfaceHeaderWrite\"");
        s.append(",\n" + indtd);
        s.append("\"fields\": {");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"id\": ");
        s.append("\"" + std::string(x.m_id) + "\"");
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        append_location(s, x.base.base.loc.first, x.base.base.loc.last);
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        if ((bool&)x) { } // Suppress unused warning
    }
    void visit_InterfaceHeaderRead(const InterfaceHeaderRead_t &x) {
        s.append("{");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"node\": \"InterfaceHeaderRead\"");
        s.append(",\n" + indtd);
        s.append("\"fields\": {");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"id\": ");
        s.append("\"" + std::string(x.m_id) + "\"");
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        append_location(s, x.base.base.loc.first, x.base.base.loc.last);
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        if ((bool&)x) { } // Suppress unused warning
    }
    void visit_InterfaceProc(const InterfaceProc_t &x) {
        s.append("{");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"node\": \"InterfaceProc\"");
        s.append(",\n" + indtd);
        s.append("\"fields\": {");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"proc\": ");
        self().visit_program_unit(*x.m_proc);
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        append_location(s, x.base.base.loc.first, x.base.base.loc.last);
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        if ((bool&)x) { } // Suppress unused warning
    }
    void visit_InterfaceModuleProcedure(const InterfaceModuleProcedure_t &x) {
        s.append("{");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"node\": \"InterfaceModuleProcedure\"");
        s.append(",\n" + indtd);
        s.append("\"fields\": {");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"names\": ");
        s.append("[");
        if (x.n_names > 0) {
            inc_indent(); s.append("\n" + indtd);
            for (size_t i=0; i<x.n_names; i++) {
                s.append("\"" + std::string(x.m_names[i]) + "\"");
                if (i < x.n_names-1) {
                    s.append(",\n" + indtd);
                };
            }
            dec_indent(); s.append("\n" + indtd);
        }
        s.append("]");
        s.append(",\n" + indtd);
        s.append("\"attributes\": ");
        s.append("[");
        if (x.n_attributes > 0) {
            inc_indent(); s.append("\n" + indtd);
            for (size_t i=0; i<x.n_attributes; i++) {
                self().visit_decl_attribute(*x.m_attributes[i]);
                if (i < x.n_attributes-1) {
                    s.append(",\n" + indtd);
                };
            }
            dec_indent(); s.append("\n" + indtd);
        }
        s.append("]");
        s.append(",\n" + indtd);
        s.append("\"trivia\": ");
        if (x.m_trivia) {
            self().visit_trivia(*x.m_trivia);
        } else {
            s.append("[]");
        }
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        append_location(s, x.base.base.loc.first, x.base.base.loc.last);
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        if ((bool&)x) { } // Suppress unused warning
    }
    void visit_Import(const Import_t &x) {
        s.append("{");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"node\": \"Import\"");
        s.append(",\n" + indtd);
        s.append("\"fields\": {");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"symbols\": ");
        s.append("[");
        if (x.n_symbols > 0) {
            inc_indent(); s.append("\n" + indtd);
            for (size_t i=0; i<x.n_symbols; i++) {
                s.append("\"" + std::string(x.m_symbols[i]) + "\"");
                if (i < x.n_symbols-1) {
                    s.append(",\n" + indtd);
                };
            }
            dec_indent(); s.append("\n" + indtd);
        }
        s.append("]");
        s.append(",\n" + indtd);
        s.append("\"mod\": ");
        visit_import_modifierType(x.m_mod);
        s.append(",\n" + indtd);
        s.append("\"trivia\": ");
        if (x.m_trivia) {
            self().visit_trivia(*x.m_trivia);
        } else {
            s.append("[]");
        }
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        append_location(s, x.base.base.loc.first, x.base.base.loc.last);
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        if ((bool&)x) { } // Suppress unused warning
    }
    void visit_import_modifierType(const import_modifierType &x) {
        switch (x) {
            case (import_modifierType::ImportDefault) : {
                s.append("\"ImportDefault\"");
             break; }
            case (import_modifierType::ImportOnly) : {
                s.append("\"ImportOnly\"");
             break; }
            case (import_modifierType::ImportNone) : {
                s.append("\"ImportNone\"");
             break; }
            case (import_modifierType::ImportAll) : {
                s.append("\"ImportAll\"");
             break; }
        }
    }
    void visit_ImplicitNone(const ImplicitNone_t &x) {
        s.append("{");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"node\": \"ImplicitNone\"");
        s.append(",\n" + indtd);
        s.append("\"fields\": {");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"specs\": ");
        s.append("[");
        if (x.n_specs > 0) {
            inc_indent(); s.append("\n" + indtd);
            for (size_t i=0; i<x.n_specs; i++) {
                self().visit_implicit_none_spec(*x.m_specs[i]);
                if (i < x.n_specs-1) {
                    s.append(",\n" + indtd);
                };
            }
            dec_indent(); s.append("\n" + indtd);
        }
        s.append("]");
        s.append(",\n" + indtd);
        s.append("\"trivia\": ");
        if (x.m_trivia) {
            self().visit_trivia(*x.m_trivia);
        } else {
            s.append("[]");
        }
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        append_location(s, x.base.base.loc.first, x.base.base.loc.last);
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        if ((bool&)x) { } // Suppress unused warning
    }
    void visit_Implicit(const Implicit_t &x) {
        s.append("{");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"node\": \"Implicit\"");
        s.append(",\n" + indtd);
        s.append("\"fields\": {");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"type\": ");
        self().visit_decl_attribute(*x.m_type);
        s.append(",\n" + indtd);
        s.append("\"kind\": ");
        s.append("[");
        if (x.n_kind > 0) {
            inc_indent(); s.append("\n" + indtd);
            for (size_t i=0; i<x.n_kind; i++) {
                self().visit_letter_spec(*x.m_kind[i]);
                if (i < x.n_kind-1) {
                    s.append(",\n" + indtd);
                };
            }
            dec_indent(); s.append("\n" + indtd);
        }
        s.append("]");
        s.append(",\n" + indtd);
        s.append("\"specs\": ");
        s.append("[");
        if (x.n_specs > 0) {
            inc_indent(); s.append("\n" + indtd);
            for (size_t i=0; i<x.n_specs; i++) {
                self().visit_letter_spec(*x.m_specs[i]);
                if (i < x.n_specs-1) {
                    s.append(",\n" + indtd);
                };
            }
            dec_indent(); s.append("\n" + indtd);
        }
        s.append("]");
        s.append(",\n" + indtd);
        s.append("\"trivia\": ");
        if (x.m_trivia) {
            self().visit_trivia(*x.m_trivia);
        } else {
            s.append("[]");
        }
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        append_location(s, x.base.base.loc.first, x.base.base.loc.last);
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        if ((bool&)x) { } // Suppress unused warning
    }
    void visit_ImplicitNoneExternal(const ImplicitNoneExternal_t &x) {
        s.append("{");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"node\": \"ImplicitNoneExternal\"");
        s.append(",\n" + indtd);
        s.append("\"fields\": {");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"dummy\": ");
        s.append(std::to_string(x.m_dummy));
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        append_location(s, x.base.base.loc.first, x.base.base.loc.last);
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        if ((bool&)x) { } // Suppress unused warning
    }
    void visit_ImplicitNoneType(const ImplicitNoneType_t &x) {
        s.append("{");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"node\": \"ImplicitNoneType\"");
        s.append(",\n" + indtd);
        s.append("\"fields\": {");
        s.append("}");
        append_location(s, x.base.base.loc.first, x.base.base.loc.last);
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        if ((bool&)x) { } // Suppress unused warning
    }
    void visit_LetterSpec(const LetterSpec_t &x) {
        s.append("{");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"node\": \"LetterSpec\"");
        s.append(",\n" + indtd);
        s.append("\"fields\": {");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"start\": ");
        if (x.m_start) {
            s.append("\"" + std::string(x.m_start) + "\"");
        } else {
            s.append("[]");
        }
        s.append(",\n" + indtd);
        s.append("\"end\": ");
        s.append("\"" + std::string(x.m_end) + "\"");
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        append_location(s, x.base.base.loc.first, x.base.base.loc.last);
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        if ((bool&)x) { } // Suppress unused warning
    }
    void visit_Allocate(const Allocate_t &x) {
        s.append("{");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"node\": \"Allocate\"");
        s.append(",\n" + indtd);
        s.append("\"fields\": {");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"label\": ");
        s.append(std::to_string(x.m_label));
        s.append(",\n" + indtd);
        s.append("\"args\": ");
        s.append("[");
        if (x.n_args > 0) {
            inc_indent(); s.append("\n" + indtd);
            for (size_t i=0; i<x.n_args; i++) {
                self().visit_fnarg(x.m_args[i]);
                if (i < x.n_args-1) {
                    s.append(",\n" + indtd);
                };
            }
            dec_indent(); s.append("\n" + indtd);
        }
        s.append("]");
        s.append(",\n" + indtd);
        s.append("\"keywords\": ");
        s.append("[");
        if (x.n_keywords > 0) {
            inc_indent(); s.append("\n" + indtd);
            for (size_t i=0; i<x.n_keywords; i++) {
                self().visit_keyword(x.m_keywords[i]);
                if (i < x.n_keywords-1) {
                    s.append(",\n" + indtd);
                };
            }
            dec_indent(); s.append("\n" + indtd);
        }
        s.append("]");
        s.append(",\n" + indtd);
        s.append("\"trivia\": ");
        if (x.m_trivia) {
            self().visit_trivia(*x.m_trivia);
        } else {
            s.append("[]");
        }
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        append_location(s, x.base.base.loc.first, x.base.base.loc.last);
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        if ((bool&)x) { } // Suppress unused warning
    }
    void visit_Assign(const Assign_t &x) {
        s.append("{");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"node\": \"Assign\"");
        s.append(",\n" + indtd);
        s.append("\"fields\": {");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"label\": ");
        s.append(std::to_string(x.m_label));
        s.append(",\n" + indtd);
        s.append("\"assign_label\": ");
        s.append(std::to_string(x.m_assign_label));
        s.append(",\n" + indtd);
        s.append("\"variable\": ");
        s.append("\"" + std::string(x.m_variable) + "\"");
        s.append(",\n" + indtd);
        s.append("\"trivia\": ");
        if (x.m_trivia) {
            self().visit_trivia(*x.m_trivia);
        } else {
            s.append("[]");
        }
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        append_location(s, x.base.base.loc.first, x.base.base.loc.last);
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        if ((bool&)x) { } // Suppress unused warning
    }
    void visit_Assignment(const Assignment_t &x) {
        s.append("{");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"node\": \"Assignment\"");
        s.append(",\n" + indtd);
        s.append("\"fields\": {");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"label\": ");
        s.append(std::to_string(x.m_label));
        s.append(",\n" + indtd);
        s.append("\"target\": ");
        self().visit_expr(*x.m_target);
        s.append(",\n" + indtd);
        s.append("\"value\": ");
        self().visit_expr(*x.m_value);
        s.append(",\n" + indtd);
        s.append("\"trivia\": ");
        if (x.m_trivia) {
            self().visit_trivia(*x.m_trivia);
        } else {
            s.append("[]");
        }
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        append_location(s, x.base.base.loc.first, x.base.base.loc.last);
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        if ((bool&)x) { } // Suppress unused warning
    }
    void visit_Associate(const Associate_t &x) {
        s.append("{");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"node\": \"Associate\"");
        s.append(",\n" + indtd);
        s.append("\"fields\": {");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"label\": ");
        s.append(std::to_string(x.m_label));
        s.append(",\n" + indtd);
        s.append("\"target\": ");
        self().visit_expr(*x.m_target);
        s.append(",\n" + indtd);
        s.append("\"value\": ");
        self().visit_expr(*x.m_value);
        s.append(",\n" + indtd);
        s.append("\"trivia\": ");
        if (x.m_trivia) {
            self().visit_trivia(*x.m_trivia);
        } else {
            s.append("[]");
        }
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        append_location(s, x.base.base.loc.first, x.base.base.loc.last);
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        if ((bool&)x) { } // Suppress unused warning
    }
    void visit_Backspace(const Backspace_t &x) {
        s.append("{");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"node\": \"Backspace\"");
        s.append(",\n" + indtd);
        s.append("\"fields\": {");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"label\": ");
        s.append(std::to_string(x.m_label));
        s.append(",\n" + indtd);
        s.append("\"args\": ");
        s.append("[");
        if (x.n_args > 0) {
            inc_indent(); s.append("\n" + indtd);
            for (size_t i=0; i<x.n_args; i++) {
                self().visit_expr(*x.m_args[i]);
                if (i < x.n_args-1) {
                    s.append(",\n" + indtd);
                };
            }
            dec_indent(); s.append("\n" + indtd);
        }
        s.append("]");
        s.append(",\n" + indtd);
        s.append("\"kwargs\": ");
        s.append("[");
        if (x.n_kwargs > 0) {
            inc_indent(); s.append("\n" + indtd);
            for (size_t i=0; i<x.n_kwargs; i++) {
                self().visit_keyword(x.m_kwargs[i]);
                if (i < x.n_kwargs-1) {
                    s.append(",\n" + indtd);
                };
            }
            dec_indent(); s.append("\n" + indtd);
        }
        s.append("]");
        s.append(",\n" + indtd);
        s.append("\"trivia\": ");
        if (x.m_trivia) {
            self().visit_trivia(*x.m_trivia);
        } else {
            s.append("[]");
        }
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        append_location(s, x.base.base.loc.first, x.base.base.loc.last);
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        if ((bool&)x) { } // Suppress unused warning
    }
    void visit_Close(const Close_t &x) {
        s.append("{");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"node\": \"Close\"");
        s.append(",\n" + indtd);
        s.append("\"fields\": {");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"label\": ");
        s.append(std::to_string(x.m_label));
        s.append(",\n" + indtd);
        s.append("\"args\": ");
        s.append("[");
        if (x.n_args > 0) {
            inc_indent(); s.append("\n" + indtd);
            for (size_t i=0; i<x.n_args; i++) {
                self().visit_expr(*x.m_args[i]);
                if (i < x.n_args-1) {
                    s.append(",\n" + indtd);
                };
            }
            dec_indent(); s.append("\n" + indtd);
        }
        s.append("]");
        s.append(",\n" + indtd);
        s.append("\"kwargs\": ");
        s.append("[");
        if (x.n_kwargs > 0) {
            inc_indent(); s.append("\n" + indtd);
            for (size_t i=0; i<x.n_kwargs; i++) {
                self().visit_keyword(x.m_kwargs[i]);
                if (i < x.n_kwargs-1) {
                    s.append(",\n" + indtd);
                };
            }
            dec_indent(); s.append("\n" + indtd);
        }
        s.append("]");
        s.append(",\n" + indtd);
        s.append("\"trivia\": ");
        if (x.m_trivia) {
            self().visit_trivia(*x.m_trivia);
        } else {
            s.append("[]");
        }
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        append_location(s, x.base.base.loc.first, x.base.base.loc.last);
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        if ((bool&)x) { } // Suppress unused warning
    }
    void visit_Continue(const Continue_t &x) {
        s.append("{");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"node\": \"Continue\"");
        s.append(",\n" + indtd);
        s.append("\"fields\": {");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"label\": ");
        s.append(std::to_string(x.m_label));
        s.append(",\n" + indtd);
        s.append("\"trivia\": ");
        if (x.m_trivia) {
            self().visit_trivia(*x.m_trivia);
        } else {
            s.append("[]");
        }
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        append_location(s, x.base.base.loc.first, x.base.base.loc.last);
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        if ((bool&)x) { } // Suppress unused warning
    }
    void visit_Cycle(const Cycle_t &x) {
        s.append("{");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"node\": \"Cycle\"");
        s.append(",\n" + indtd);
        s.append("\"fields\": {");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"label\": ");
        s.append(std::to_string(x.m_label));
        s.append(",\n" + indtd);
        s.append("\"stmt_name\": ");
        if (x.m_stmt_name) {
            s.append("\"" + std::string(x.m_stmt_name) + "\"");
        } else {
            s.append("[]");
        }
        s.append(",\n" + indtd);
        s.append("\"trivia\": ");
        if (x.m_trivia) {
            self().visit_trivia(*x.m_trivia);
        } else {
            s.append("[]");
        }
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        append_location(s, x.base.base.loc.first, x.base.base.loc.last);
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        if ((bool&)x) { } // Suppress unused warning
    }
    void visit_Deallocate(const Deallocate_t &x) {
        s.append("{");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"node\": \"Deallocate\"");
        s.append(",\n" + indtd);
        s.append("\"fields\": {");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"label\": ");
        s.append(std::to_string(x.m_label));
        s.append(",\n" + indtd);
        s.append("\"args\": ");
        s.append("[");
        if (x.n_args > 0) {
            inc_indent(); s.append("\n" + indtd);
            for (size_t i=0; i<x.n_args; i++) {
                self().visit_fnarg(x.m_args[i]);
                if (i < x.n_args-1) {
                    s.append(",\n" + indtd);
                };
            }
            dec_indent(); s.append("\n" + indtd);
        }
        s.append("]");
        s.append(",\n" + indtd);
        s.append("\"keywords\": ");
        s.append("[");
        if (x.n_keywords > 0) {
            inc_indent(); s.append("\n" + indtd);
            for (size_t i=0; i<x.n_keywords; i++) {
                self().visit_keyword(x.m_keywords[i]);
                if (i < x.n_keywords-1) {
                    s.append(",\n" + indtd);
                };
            }
            dec_indent(); s.append("\n" + indtd);
        }
        s.append("]");
        s.append(",\n" + indtd);
        s.append("\"trivia\": ");
        if (x.m_trivia) {
            self().visit_trivia(*x.m_trivia);
        } else {
            s.append("[]");
        }
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        append_location(s, x.base.base.loc.first, x.base.base.loc.last);
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        if ((bool&)x) { } // Suppress unused warning
    }
    void visit_Endfile(const Endfile_t &x) {
        s.append("{");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"node\": \"Endfile\"");
        s.append(",\n" + indtd);
        s.append("\"fields\": {");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"label\": ");
        s.append(std::to_string(x.m_label));
        s.append(",\n" + indtd);
        s.append("\"args\": ");
        s.append("[");
        if (x.n_args > 0) {
            inc_indent(); s.append("\n" + indtd);
            for (size_t i=0; i<x.n_args; i++) {
                self().visit_expr(*x.m_args[i]);
                if (i < x.n_args-1) {
                    s.append(",\n" + indtd);
                };
            }
            dec_indent(); s.append("\n" + indtd);
        }
        s.append("]");
        s.append(",\n" + indtd);
        s.append("\"kwargs\": ");
        s.append("[");
        if (x.n_kwargs > 0) {
            inc_indent(); s.append("\n" + indtd);
            for (size_t i=0; i<x.n_kwargs; i++) {
                self().visit_keyword(x.m_kwargs[i]);
                if (i < x.n_kwargs-1) {
                    s.append(",\n" + indtd);
                };
            }
            dec_indent(); s.append("\n" + indtd);
        }
        s.append("]");
        s.append(",\n" + indtd);
        s.append("\"trivia\": ");
        if (x.m_trivia) {
            self().visit_trivia(*x.m_trivia);
        } else {
            s.append("[]");
        }
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        append_location(s, x.base.base.loc.first, x.base.base.loc.last);
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        if ((bool&)x) { } // Suppress unused warning
    }
    void visit_Entry(const Entry_t &x) {
        s.append("{");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"node\": \"Entry\"");
        s.append(",\n" + indtd);
        s.append("\"fields\": {");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"label\": ");
        s.append(std::to_string(x.m_label));
        s.append(",\n" + indtd);
        s.append("\"name\": ");
        s.append("\"" + std::string(x.m_name) + "\"");
        s.append(",\n" + indtd);
        s.append("\"args\": ");
        s.append("[");
        if (x.n_args > 0) {
            inc_indent(); s.append("\n" + indtd);
            for (size_t i=0; i<x.n_args; i++) {
                self().visit_arg(x.m_args[i]);
                if (i < x.n_args-1) {
                    s.append(",\n" + indtd);
                };
            }
            dec_indent(); s.append("\n" + indtd);
        }
        s.append("]");
        s.append(",\n" + indtd);
        s.append("\"return_var\": ");
        if (x.m_return_var) {
            self().visit_expr(*x.m_return_var);
        } else {
            s.append("[]");
        }
        s.append(",\n" + indtd);
        s.append("\"bind\": ");
        if (x.m_bind) {
            self().visit_bind(*x.m_bind);
        } else {
            s.append("[]");
        }
        s.append(",\n" + indtd);
        s.append("\"trivia\": ");
        if (x.m_trivia) {
            self().visit_trivia(*x.m_trivia);
        } else {
            s.append("[]");
        }
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        append_location(s, x.base.base.loc.first, x.base.base.loc.last);
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        if ((bool&)x) { } // Suppress unused warning
    }
    void visit_ErrorStop(const ErrorStop_t &x) {
        s.append("{");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"node\": \"ErrorStop\"");
        s.append(",\n" + indtd);
        s.append("\"fields\": {");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"label\": ");
        s.append(std::to_string(x.m_label));
        s.append(",\n" + indtd);
        s.append("\"code\": ");
        if (x.m_code) {
            self().visit_expr(*x.m_code);
        } else {
            s.append("[]");
        }
        s.append(",\n" + indtd);
        s.append("\"quiet\": ");
        if (x.m_quiet) {
            self().visit_expr(*x.m_quiet);
        } else {
            s.append("[]");
        }
        s.append(",\n" + indtd);
        s.append("\"trivia\": ");
        if (x.m_trivia) {
            self().visit_trivia(*x.m_trivia);
        } else {
            s.append("[]");
        }
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        append_location(s, x.base.base.loc.first, x.base.base.loc.last);
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        if ((bool&)x) { } // Suppress unused warning
    }
    void visit_EventPost(const EventPost_t &x) {
        s.append("{");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"node\": \"EventPost\"");
        s.append(",\n" + indtd);
        s.append("\"fields\": {");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"label\": ");
        s.append(std::to_string(x.m_label));
        s.append(",\n" + indtd);
        s.append("\"variable\": ");
        self().visit_expr(*x.m_variable);
        s.append(",\n" + indtd);
        s.append("\"stat\": ");
        s.append("[");
        if (x.n_stat > 0) {
            inc_indent(); s.append("\n" + indtd);
            for (size_t i=0; i<x.n_stat; i++) {
                self().visit_event_attribute(*x.m_stat[i]);
                if (i < x.n_stat-1) {
                    s.append(",\n" + indtd);
                };
            }
            dec_indent(); s.append("\n" + indtd);
        }
        s.append("]");
        s.append(",\n" + indtd);
        s.append("\"trivia\": ");
        if (x.m_trivia) {
            self().visit_trivia(*x.m_trivia);
        } else {
            s.append("[]");
        }
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        append_location(s, x.base.base.loc.first, x.base.base.loc.last);
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        if ((bool&)x) { } // Suppress unused warning
    }
    void visit_EventWait(const EventWait_t &x) {
        s.append("{");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"node\": \"EventWait\"");
        s.append(",\n" + indtd);
        s.append("\"fields\": {");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"label\": ");
        s.append(std::to_string(x.m_label));
        s.append(",\n" + indtd);
        s.append("\"variable\": ");
        self().visit_expr(*x.m_variable);
        s.append(",\n" + indtd);
        s.append("\"spec\": ");
        s.append("[");
        if (x.n_spec > 0) {
            inc_indent(); s.append("\n" + indtd);
            for (size_t i=0; i<x.n_spec; i++) {
                self().visit_event_attribute(*x.m_spec[i]);
                if (i < x.n_spec-1) {
                    s.append(",\n" + indtd);
                };
            }
            dec_indent(); s.append("\n" + indtd);
        }
        s.append("]");
        s.append(",\n" + indtd);
        s.append("\"trivia\": ");
        if (x.m_trivia) {
            self().visit_trivia(*x.m_trivia);
        } else {
            s.append("[]");
        }
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        append_location(s, x.base.base.loc.first, x.base.base.loc.last);
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        if ((bool&)x) { } // Suppress unused warning
    }
    void visit_Exit(const Exit_t &x) {
        s.append("{");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"node\": \"Exit\"");
        s.append(",\n" + indtd);
        s.append("\"fields\": {");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"label\": ");
        s.append(std::to_string(x.m_label));
        s.append(",\n" + indtd);
        s.append("\"stmt_name\": ");
        if (x.m_stmt_name) {
            s.append("\"" + std::string(x.m_stmt_name) + "\"");
        } else {
            s.append("[]");
        }
        s.append(",\n" + indtd);
        s.append("\"trivia\": ");
        if (x.m_trivia) {
            self().visit_trivia(*x.m_trivia);
        } else {
            s.append("[]");
        }
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        append_location(s, x.base.base.loc.first, x.base.base.loc.last);
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        if ((bool&)x) { } // Suppress unused warning
    }
    void visit_Flush(const Flush_t &x) {
        s.append("{");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"node\": \"Flush\"");
        s.append(",\n" + indtd);
        s.append("\"fields\": {");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"label\": ");
        s.append(std::to_string(x.m_label));
        s.append(",\n" + indtd);
        s.append("\"args\": ");
        s.append("[");
        if (x.n_args > 0) {
            inc_indent(); s.append("\n" + indtd);
            for (size_t i=0; i<x.n_args; i++) {
                self().visit_expr(*x.m_args[i]);
                if (i < x.n_args-1) {
                    s.append(",\n" + indtd);
                };
            }
            dec_indent(); s.append("\n" + indtd);
        }
        s.append("]");
        s.append(",\n" + indtd);
        s.append("\"kwargs\": ");
        s.append("[");
        if (x.n_kwargs > 0) {
            inc_indent(); s.append("\n" + indtd);
            for (size_t i=0; i<x.n_kwargs; i++) {
                self().visit_keyword(x.m_kwargs[i]);
                if (i < x.n_kwargs-1) {
                    s.append(",\n" + indtd);
                };
            }
            dec_indent(); s.append("\n" + indtd);
        }
        s.append("]");
        s.append(",\n" + indtd);
        s.append("\"trivia\": ");
        if (x.m_trivia) {
            self().visit_trivia(*x.m_trivia);
        } else {
            s.append("[]");
        }
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        append_location(s, x.base.base.loc.first, x.base.base.loc.last);
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        if ((bool&)x) { } // Suppress unused warning
    }
    void visit_ForAllSingle(const ForAllSingle_t &x) {
        s.append("{");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"node\": \"ForAllSingle\"");
        s.append(",\n" + indtd);
        s.append("\"fields\": {");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"label\": ");
        s.append(std::to_string(x.m_label));
        s.append(",\n" + indtd);
        s.append("\"stmt_name\": ");
        if (x.m_stmt_name) {
            s.append("\"" + std::string(x.m_stmt_name) + "\"");
        } else {
            s.append("[]");
        }
        s.append(",\n" + indtd);
        s.append("\"control\": ");
        s.append("[");
        if (x.n_control > 0) {
            inc_indent(); s.append("\n" + indtd);
            for (size_t i=0; i<x.n_control; i++) {
                self().visit_concurrent_control(*x.m_control[i]);
                if (i < x.n_control-1) {
                    s.append(",\n" + indtd);
                };
            }
            dec_indent(); s.append("\n" + indtd);
        }
        s.append("]");
        s.append(",\n" + indtd);
        s.append("\"mask\": ");
        if (x.m_mask) {
            self().visit_expr(*x.m_mask);
        } else {
            s.append("[]");
        }
        s.append(",\n" + indtd);
        s.append("\"assign\": ");
        self().visit_stmt(*x.m_assign);
        s.append(",\n" + indtd);
        s.append("\"trivia\": ");
        if (x.m_trivia) {
            self().visit_trivia(*x.m_trivia);
        } else {
            s.append("[]");
        }
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        append_location(s, x.base.base.loc.first, x.base.base.loc.last);
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        if ((bool&)x) { } // Suppress unused warning
    }
    void visit_Format(const Format_t &x) {
        s.append("{");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"node\": \"Format\"");
        s.append(",\n" + indtd);
        s.append("\"fields\": {");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"label\": ");
        s.append(std::to_string(x.m_label));
        s.append(",\n" + indtd);
        s.append("\"fmt\": ");
        s.append("\"" + str_escape_c(x.m_fmt) + "\"");
        s.append(",\n" + indtd);
        s.append("\"trivia\": ");
        if (x.m_trivia) {
            self().visit_trivia(*x.m_trivia);
        } else {
            s.append("[]");
        }
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        append_location(s, x.base.base.loc.first, x.base.base.loc.last);
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        if ((bool&)x) { } // Suppress unused warning
    }
    void visit_DataStmt(const DataStmt_t &x) {
        s.append("{");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"node\": \"DataStmt\"");
        s.append(",\n" + indtd);
        s.append("\"fields\": {");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"label\": ");
        s.append(std::to_string(x.m_label));
        s.append(",\n" + indtd);
        s.append("\"items\": ");
        s.append("[");
        if (x.n_items > 0) {
            inc_indent(); s.append("\n" + indtd);
            for (size_t i=0; i<x.n_items; i++) {
                self().visit_data_stmt_set(*x.m_items[i]);
                if (i < x.n_items-1) {
                    s.append(",\n" + indtd);
                };
            }
            dec_indent(); s.append("\n" + indtd);
        }
        s.append("]");
        s.append(",\n" + indtd);
        s.append("\"trivia\": ");
        if (x.m_trivia) {
            self().visit_trivia(*x.m_trivia);
        } else {
            s.append("[]");
        }
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        append_location(s, x.base.base.loc.first, x.base.base.loc.last);
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        if ((bool&)x) { } // Suppress unused warning
    }
    void visit_FormTeam(const FormTeam_t &x) {
        s.append("{");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"node\": \"FormTeam\"");
        s.append(",\n" + indtd);
        s.append("\"fields\": {");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"label\": ");
        s.append(std::to_string(x.m_label));
        s.append(",\n" + indtd);
        s.append("\"team_number\": ");
        self().visit_expr(*x.m_team_number);
        s.append(",\n" + indtd);
        s.append("\"team_var\": ");
        s.append("\"" + std::string(x.m_team_var) + "\"");
        s.append(",\n" + indtd);
        s.append("\"sync_stat\": ");
        s.append("[");
        if (x.n_sync_stat > 0) {
            inc_indent(); s.append("\n" + indtd);
            for (size_t i=0; i<x.n_sync_stat; i++) {
                self().visit_event_attribute(*x.m_sync_stat[i]);
                if (i < x.n_sync_stat-1) {
                    s.append(",\n" + indtd);
                };
            }
            dec_indent(); s.append("\n" + indtd);
        }
        s.append("]");
        s.append(",\n" + indtd);
        s.append("\"trivia\": ");
        if (x.m_trivia) {
            self().visit_trivia(*x.m_trivia);
        } else {
            s.append("[]");
        }
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        append_location(s, x.base.base.loc.first, x.base.base.loc.last);
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        if ((bool&)x) { } // Suppress unused warning
    }
    void visit_GoTo(const GoTo_t &x) {
        s.append("{");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"node\": \"GoTo\"");
        s.append(",\n" + indtd);
        s.append("\"fields\": {");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"label\": ");
        s.append(std::to_string(x.m_label));
        s.append(",\n" + indtd);
        s.append("\"int_var\": ");
        if (x.m_int_var) {
            s.append("\"" + std::string(x.m_int_var) + "\"");
        } else {
            s.append("[]");
        }
        s.append(",\n" + indtd);
        s.append("\"goto_label\": ");
        if (x.m_goto_label) {
            self().visit_expr(*x.m_goto_label);
        } else {
            s.append("[]");
        }
        s.append(",\n" + indtd);
        s.append("\"labels\": ");
        s.append("[");
        if (x.n_labels > 0) {
            inc_indent(); s.append("\n" + indtd);
            for (size_t i=0; i<x.n_labels; i++) {
                self().visit_expr(*x.m_labels[i]);
                if (i < x.n_labels-1) {
                    s.append(",\n" + indtd);
                };
            }
            dec_indent(); s.append("\n" + indtd);
        }
        s.append("]");
        s.append(",\n" + indtd);
        s.append("\"trivia\": ");
        if (x.m_trivia) {
            self().visit_trivia(*x.m_trivia);
        } else {
            s.append("[]");
        }
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        append_location(s, x.base.base.loc.first, x.base.base.loc.last);
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        if ((bool&)x) { } // Suppress unused warning
    }
    void visit_Include(const Include_t &x) {
        s.append("{");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"node\": \"Include\"");
        s.append(",\n" + indtd);
        s.append("\"fields\": {");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"label\": ");
        s.append(std::to_string(x.m_label));
        s.append(",\n" + indtd);
        s.append("\"filename\": ");
        s.append("\"" + str_escape_c(x.m_filename) + "\"");
        s.append(",\n" + indtd);
        s.append("\"trivia\": ");
        if (x.m_trivia) {
            self().visit_trivia(*x.m_trivia);
        } else {
            s.append("[]");
        }
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        append_location(s, x.base.base.loc.first, x.base.base.loc.last);
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        if ((bool&)x) { } // Suppress unused warning
    }
    void visit_Inquire(const Inquire_t &x) {
        s.append("{");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"node\": \"Inquire\"");
        s.append(",\n" + indtd);
        s.append("\"fields\": {");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"label\": ");
        s.append(std::to_string(x.m_label));
        s.append(",\n" + indtd);
        s.append("\"args\": ");
        s.append("[");
        if (x.n_args > 0) {
            inc_indent(); s.append("\n" + indtd);
            for (size_t i=0; i<x.n_args; i++) {
                self().visit_expr(*x.m_args[i]);
                if (i < x.n_args-1) {
                    s.append(",\n" + indtd);
                };
            }
            dec_indent(); s.append("\n" + indtd);
        }
        s.append("]");
        s.append(",\n" + indtd);
        s.append("\"kwargs\": ");
        s.append("[");
        if (x.n_kwargs > 0) {
            inc_indent(); s.append("\n" + indtd);
            for (size_t i=0; i<x.n_kwargs; i++) {
                self().visit_keyword(x.m_kwargs[i]);
                if (i < x.n_kwargs-1) {
                    s.append(",\n" + indtd);
                };
            }
            dec_indent(); s.append("\n" + indtd);
        }
        s.append("]");
        s.append(",\n" + indtd);
        s.append("\"values\": ");
        s.append("[");
        if (x.n_values > 0) {
            inc_indent(); s.append("\n" + indtd);
            for (size_t i=0; i<x.n_values; i++) {
                self().visit_expr(*x.m_values[i]);
                if (i < x.n_values-1) {
                    s.append(",\n" + indtd);
                };
            }
            dec_indent(); s.append("\n" + indtd);
        }
        s.append("]");
        s.append(",\n" + indtd);
        s.append("\"trivia\": ");
        if (x.m_trivia) {
            self().visit_trivia(*x.m_trivia);
        } else {
            s.append("[]");
        }
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        append_location(s, x.base.base.loc.first, x.base.base.loc.last);
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        if ((bool&)x) { } // Suppress unused warning
    }
    void visit_Nullify(const Nullify_t &x) {
        s.append("{");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"node\": \"Nullify\"");
        s.append(",\n" + indtd);
        s.append("\"fields\": {");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"label\": ");
        s.append(std::to_string(x.m_label));
        s.append(",\n" + indtd);
        s.append("\"args\": ");
        s.append("[");
        if (x.n_args > 0) {
            inc_indent(); s.append("\n" + indtd);
            for (size_t i=0; i<x.n_args; i++) {
                self().visit_expr(*x.m_args[i]);
                if (i < x.n_args-1) {
                    s.append(",\n" + indtd);
                };
            }
            dec_indent(); s.append("\n" + indtd);
        }
        s.append("]");
        s.append(",\n" + indtd);
        s.append("\"kwargs\": ");
        s.append("[");
        if (x.n_kwargs > 0) {
            inc_indent(); s.append("\n" + indtd);
            for (size_t i=0; i<x.n_kwargs; i++) {
                self().visit_keyword(x.m_kwargs[i]);
                if (i < x.n_kwargs-1) {
                    s.append(",\n" + indtd);
                };
            }
            dec_indent(); s.append("\n" + indtd);
        }
        s.append("]");
        s.append(",\n" + indtd);
        s.append("\"trivia\": ");
        if (x.m_trivia) {
            self().visit_trivia(*x.m_trivia);
        } else {
            s.append("[]");
        }
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        append_location(s, x.base.base.loc.first, x.base.base.loc.last);
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        if ((bool&)x) { } // Suppress unused warning
    }
    void visit_Open(const Open_t &x) {
        s.append("{");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"node\": \"Open\"");
        s.append(",\n" + indtd);
        s.append("\"fields\": {");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"label\": ");
        s.append(std::to_string(x.m_label));
        s.append(",\n" + indtd);
        s.append("\"args\": ");
        s.append("[");
        if (x.n_args > 0) {
            inc_indent(); s.append("\n" + indtd);
            for (size_t i=0; i<x.n_args; i++) {
                self().visit_expr(*x.m_args[i]);
                if (i < x.n_args-1) {
                    s.append(",\n" + indtd);
                };
            }
            dec_indent(); s.append("\n" + indtd);
        }
        s.append("]");
        s.append(",\n" + indtd);
        s.append("\"kwargs\": ");
        s.append("[");
        if (x.n_kwargs > 0) {
            inc_indent(); s.append("\n" + indtd);
            for (size_t i=0; i<x.n_kwargs; i++) {
                self().visit_keyword(x.m_kwargs[i]);
                if (i < x.n_kwargs-1) {
                    s.append(",\n" + indtd);
                };
            }
            dec_indent(); s.append("\n" + indtd);
        }
        s.append("]");
        s.append(",\n" + indtd);
        s.append("\"trivia\": ");
        if (x.m_trivia) {
            self().visit_trivia(*x.m_trivia);
        } else {
            s.append("[]");
        }
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        append_location(s, x.base.base.loc.first, x.base.base.loc.last);
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        if ((bool&)x) { } // Suppress unused warning
    }
    void visit_Return(const Return_t &x) {
        s.append("{");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"node\": \"Return\"");
        s.append(",\n" + indtd);
        s.append("\"fields\": {");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"label\": ");
        s.append(std::to_string(x.m_label));
        s.append(",\n" + indtd);
        s.append("\"value\": ");
        if (x.m_value) {
            self().visit_expr(*x.m_value);
        } else {
            s.append("[]");
        }
        s.append(",\n" + indtd);
        s.append("\"trivia\": ");
        if (x.m_trivia) {
            self().visit_trivia(*x.m_trivia);
        } else {
            s.append("[]");
        }
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        append_location(s, x.base.base.loc.first, x.base.base.loc.last);
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        if ((bool&)x) { } // Suppress unused warning
    }
    void visit_Pragma(const Pragma_t &x) {
        s.append("{");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"node\": \"Pragma\"");
        s.append(",\n" + indtd);
        s.append("\"fields\": {");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"label\": ");
        s.append(std::to_string(x.m_label));
        s.append(",\n" + indtd);
        s.append("\"type\": ");
        visit_pragma_typeType(x.m_type);
        s.append(",\n" + indtd);
        s.append("\"end\": ");
        if (x.m_end) {
            s.append("true");
        } else {
            s.append("false");
        }
        s.append(",\n" + indtd);
        s.append("\"construct_name\": ");
        s.append("\"" + str_escape_c(x.m_construct_name) + "\"");
        s.append(",\n" + indtd);
        s.append("\"clauses\": ");
        s.append("[");
        if (x.n_clauses > 0) {
            inc_indent(); s.append("\n" + indtd);
            for (size_t i=0; i<x.n_clauses; i++) {
                self().visit_expr(*x.m_clauses[i]);
                if (i < x.n_clauses-1) {
                    s.append(",\n" + indtd);
                };
            }
            dec_indent(); s.append("\n" + indtd);
        }
        s.append("]");
        s.append(",\n" + indtd);
        s.append("\"trivia\": ");
        if (x.m_trivia) {
            self().visit_trivia(*x.m_trivia);
        } else {
            s.append("[]");
        }
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        append_location(s, x.base.base.loc.first, x.base.base.loc.last);
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        if ((bool&)x) { } // Suppress unused warning
    }
    void visit_Print(const Print_t &x) {
        s.append("{");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"node\": \"Print\"");
        s.append(",\n" + indtd);
        s.append("\"fields\": {");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"label\": ");
        s.append(std::to_string(x.m_label));
        s.append(",\n" + indtd);
        s.append("\"fmt\": ");
        if (x.m_fmt) {
            self().visit_expr(*x.m_fmt);
        } else {
            s.append("[]");
        }
        s.append(",\n" + indtd);
        s.append("\"values\": ");
        s.append("[");
        if (x.n_values > 0) {
            inc_indent(); s.append("\n" + indtd);
            for (size_t i=0; i<x.n_values; i++) {
                self().visit_expr(*x.m_values[i]);
                if (i < x.n_values-1) {
                    s.append(",\n" + indtd);
                };
            }
            dec_indent(); s.append("\n" + indtd);
        }
        s.append("]");
        s.append(",\n" + indtd);
        s.append("\"trivia\": ");
        if (x.m_trivia) {
            self().visit_trivia(*x.m_trivia);
        } else {
            s.append("[]");
        }
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        append_location(s, x.base.base.loc.first, x.base.base.loc.last);
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        if ((bool&)x) { } // Suppress unused warning
    }
    void visit_Read(const Read_t &x) {
        s.append("{");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"node\": \"Read\"");
        s.append(",\n" + indtd);
        s.append("\"fields\": {");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"label\": ");
        s.append(std::to_string(x.m_label));
        s.append(",\n" + indtd);
        s.append("\"format\": ");
        if (x.m_format) {
            self().visit_expr(*x.m_format);
        } else {
            s.append("[]");
        }
        s.append(",\n" + indtd);
        s.append("\"args\": ");
        s.append("[");
        if (x.n_args > 0) {
            inc_indent(); s.append("\n" + indtd);
            for (size_t i=0; i<x.n_args; i++) {
                self().visit_argstar(x.m_args[i]);
                if (i < x.n_args-1) {
                    s.append(",\n" + indtd);
                };
            }
            dec_indent(); s.append("\n" + indtd);
        }
        s.append("]");
        s.append(",\n" + indtd);
        s.append("\"kwargs\": ");
        s.append("[");
        if (x.n_kwargs > 0) {
            inc_indent(); s.append("\n" + indtd);
            for (size_t i=0; i<x.n_kwargs; i++) {
                self().visit_kw_argstar(x.m_kwargs[i]);
                if (i < x.n_kwargs-1) {
                    s.append(",\n" + indtd);
                };
            }
            dec_indent(); s.append("\n" + indtd);
        }
        s.append("]");
        s.append(",\n" + indtd);
        s.append("\"values\": ");
        s.append("[");
        if (x.n_values > 0) {
            inc_indent(); s.append("\n" + indtd);
            for (size_t i=0; i<x.n_values; i++) {
                self().visit_expr(*x.m_values[i]);
                if (i < x.n_values-1) {
                    s.append(",\n" + indtd);
                };
            }
            dec_indent(); s.append("\n" + indtd);
        }
        s.append("]");
        s.append(",\n" + indtd);
        s.append("\"trivia\": ");
        if (x.m_trivia) {
            self().visit_trivia(*x.m_trivia);
        } else {
            s.append("[]");
        }
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        append_location(s, x.base.base.loc.first, x.base.base.loc.last);
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        if ((bool&)x) { } // Suppress unused warning
    }
    void visit_Rewind(const Rewind_t &x) {
        s.append("{");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"node\": \"Rewind\"");
        s.append(",\n" + indtd);
        s.append("\"fields\": {");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"label\": ");
        s.append(std::to_string(x.m_label));
        s.append(",\n" + indtd);
        s.append("\"args\": ");
        s.append("[");
        if (x.n_args > 0) {
            inc_indent(); s.append("\n" + indtd);
            for (size_t i=0; i<x.n_args; i++) {
                self().visit_expr(*x.m_args[i]);
                if (i < x.n_args-1) {
                    s.append(",\n" + indtd);
                };
            }
            dec_indent(); s.append("\n" + indtd);
        }
        s.append("]");
        s.append(",\n" + indtd);
        s.append("\"kwargs\": ");
        s.append("[");
        if (x.n_kwargs > 0) {
            inc_indent(); s.append("\n" + indtd);
            for (size_t i=0; i<x.n_kwargs; i++) {
                self().visit_keyword(x.m_kwargs[i]);
                if (i < x.n_kwargs-1) {
                    s.append(",\n" + indtd);
                };
            }
            dec_indent(); s.append("\n" + indtd);
        }
        s.append("]");
        s.append(",\n" + indtd);
        s.append("\"trivia\": ");
        if (x.m_trivia) {
            self().visit_trivia(*x.m_trivia);
        } else {
            s.append("[]");
        }
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        append_location(s, x.base.base.loc.first, x.base.base.loc.last);
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        if ((bool&)x) { } // Suppress unused warning
    }
    void visit_Stop(const Stop_t &x) {
        s.append("{");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"node\": \"Stop\"");
        s.append(",\n" + indtd);
        s.append("\"fields\": {");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"label\": ");
        s.append(std::to_string(x.m_label));
        s.append(",\n" + indtd);
        s.append("\"code\": ");
        if (x.m_code) {
            self().visit_expr(*x.m_code);
        } else {
            s.append("[]");
        }
        s.append(",\n" + indtd);
        s.append("\"quiet\": ");
        if (x.m_quiet) {
            self().visit_expr(*x.m_quiet);
        } else {
            s.append("[]");
        }
        s.append(",\n" + indtd);
        s.append("\"trivia\": ");
        if (x.m_trivia) {
            self().visit_trivia(*x.m_trivia);
        } else {
            s.append("[]");
        }
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        append_location(s, x.base.base.loc.first, x.base.base.loc.last);
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        if ((bool&)x) { } // Suppress unused warning
    }
    void visit_SubroutineCall(const SubroutineCall_t &x) {
        s.append("{");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"node\": \"SubroutineCall\"");
        s.append(",\n" + indtd);
        s.append("\"fields\": {");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"label\": ");
        s.append(std::to_string(x.m_label));
        s.append(",\n" + indtd);
        s.append("\"name\": ");
        s.append("\"" + std::string(x.m_name) + "\"");
        s.append(",\n" + indtd);
        s.append("\"member\": ");
        s.append("[");
        if (x.n_member > 0) {
            inc_indent(); s.append("\n" + indtd);
            for (size_t i=0; i<x.n_member; i++) {
                self().visit_struct_member(x.m_member[i]);
                if (i < x.n_member-1) {
                    s.append(",\n" + indtd);
                };
            }
            dec_indent(); s.append("\n" + indtd);
        }
        s.append("]");
        s.append(",\n" + indtd);
        s.append("\"args\": ");
        s.append("[");
        if (x.n_args > 0) {
            inc_indent(); s.append("\n" + indtd);
            for (size_t i=0; i<x.n_args; i++) {
                self().visit_fnarg(x.m_args[i]);
                if (i < x.n_args-1) {
                    s.append(",\n" + indtd);
                };
            }
            dec_indent(); s.append("\n" + indtd);
        }
        s.append("]");
        s.append(",\n" + indtd);
        s.append("\"keywords\": ");
        s.append("[");
        if (x.n_keywords > 0) {
            inc_indent(); s.append("\n" + indtd);
            for (size_t i=0; i<x.n_keywords; i++) {
                self().visit_keyword(x.m_keywords[i]);
                if (i < x.n_keywords-1) {
                    s.append(",\n" + indtd);
                };
            }
            dec_indent(); s.append("\n" + indtd);
        }
        s.append("]");
        s.append(",\n" + indtd);
        s.append("\"temp_args\": ");
        s.append("[");
        if (x.n_temp_args > 0) {
            inc_indent(); s.append("\n" + indtd);
            for (size_t i=0; i<x.n_temp_args; i++) {
                self().visit_decl_attribute(*x.m_temp_args[i]);
                if (i < x.n_temp_args-1) {
                    s.append(",\n" + indtd);
                };
            }
            dec_indent(); s.append("\n" + indtd);
        }
        s.append("]");
        s.append(",\n" + indtd);
        s.append("\"trivia\": ");
        if (x.m_trivia) {
            self().visit_trivia(*x.m_trivia);
        } else {
            s.append("[]");
        }
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        append_location(s, x.base.base.loc.first, x.base.base.loc.last);
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        if ((bool&)x) { } // Suppress unused warning
    }
    void visit_SyncAll(const SyncAll_t &x) {
        s.append("{");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"node\": \"SyncAll\"");
        s.append(",\n" + indtd);
        s.append("\"fields\": {");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"label\": ");
        s.append(std::to_string(x.m_label));
        s.append(",\n" + indtd);
        s.append("\"stat\": ");
        s.append("[");
        if (x.n_stat > 0) {
            inc_indent(); s.append("\n" + indtd);
            for (size_t i=0; i<x.n_stat; i++) {
                self().visit_event_attribute(*x.m_stat[i]);
                if (i < x.n_stat-1) {
                    s.append(",\n" + indtd);
                };
            }
            dec_indent(); s.append("\n" + indtd);
        }
        s.append("]");
        s.append(",\n" + indtd);
        s.append("\"trivia\": ");
        if (x.m_trivia) {
            self().visit_trivia(*x.m_trivia);
        } else {
            s.append("[]");
        }
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        append_location(s, x.base.base.loc.first, x.base.base.loc.last);
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        if ((bool&)x) { } // Suppress unused warning
    }
    void visit_SyncImages(const SyncImages_t &x) {
        s.append("{");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"node\": \"SyncImages\"");
        s.append(",\n" + indtd);
        s.append("\"fields\": {");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"label\": ");
        s.append(std::to_string(x.m_label));
        s.append(",\n" + indtd);
        s.append("\"image_set\": ");
        if (x.m_image_set) {
            self().visit_expr(*x.m_image_set);
        } else {
            s.append("[]");
        }
        s.append(",\n" + indtd);
        s.append("\"sym\": ");
        visit_symbolType(x.m_sym);
        s.append(",\n" + indtd);
        s.append("\"stat\": ");
        s.append("[");
        if (x.n_stat > 0) {
            inc_indent(); s.append("\n" + indtd);
            for (size_t i=0; i<x.n_stat; i++) {
                self().visit_event_attribute(*x.m_stat[i]);
                if (i < x.n_stat-1) {
                    s.append(",\n" + indtd);
                };
            }
            dec_indent(); s.append("\n" + indtd);
        }
        s.append("]");
        s.append(",\n" + indtd);
        s.append("\"trivia\": ");
        if (x.m_trivia) {
            self().visit_trivia(*x.m_trivia);
        } else {
            s.append("[]");
        }
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        append_location(s, x.base.base.loc.first, x.base.base.loc.last);
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        if ((bool&)x) { } // Suppress unused warning
    }
    void visit_SyncMemory(const SyncMemory_t &x) {
        s.append("{");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"node\": \"SyncMemory\"");
        s.append(",\n" + indtd);
        s.append("\"fields\": {");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"label\": ");
        s.append(std::to_string(x.m_label));
        s.append(",\n" + indtd);
        s.append("\"stat\": ");
        s.append("[");
        if (x.n_stat > 0) {
            inc_indent(); s.append("\n" + indtd);
            for (size_t i=0; i<x.n_stat; i++) {
                self().visit_event_attribute(*x.m_stat[i]);
                if (i < x.n_stat-1) {
                    s.append(",\n" + indtd);
                };
            }
            dec_indent(); s.append("\n" + indtd);
        }
        s.append("]");
        s.append(",\n" + indtd);
        s.append("\"trivia\": ");
        if (x.m_trivia) {
            self().visit_trivia(*x.m_trivia);
        } else {
            s.append("[]");
        }
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        append_location(s, x.base.base.loc.first, x.base.base.loc.last);
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        if ((bool&)x) { } // Suppress unused warning
    }
    void visit_SyncTeam(const SyncTeam_t &x) {
        s.append("{");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"node\": \"SyncTeam\"");
        s.append(",\n" + indtd);
        s.append("\"fields\": {");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"label\": ");
        s.append(std::to_string(x.m_label));
        s.append(",\n" + indtd);
        s.append("\"value\": ");
        self().visit_expr(*x.m_value);
        s.append(",\n" + indtd);
        s.append("\"stat\": ");
        s.append("[");
        if (x.n_stat > 0) {
            inc_indent(); s.append("\n" + indtd);
            for (size_t i=0; i<x.n_stat; i++) {
                self().visit_event_attribute(*x.m_stat[i]);
                if (i < x.n_stat-1) {
                    s.append(",\n" + indtd);
                };
            }
            dec_indent(); s.append("\n" + indtd);
        }
        s.append("]");
        s.append(",\n" + indtd);
        s.append("\"trivia\": ");
        if (x.m_trivia) {
            self().visit_trivia(*x.m_trivia);
        } else {
            s.append("[]");
        }
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        append_location(s, x.base.base.loc.first, x.base.base.loc.last);
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        if ((bool&)x) { } // Suppress unused warning
    }
    void visit_Write(const Write_t &x) {
        s.append("{");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"node\": \"Write\"");
        s.append(",\n" + indtd);
        s.append("\"fields\": {");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"label\": ");
        s.append(std::to_string(x.m_label));
        s.append(",\n" + indtd);
        s.append("\"args\": ");
        s.append("[");
        if (x.n_args > 0) {
            inc_indent(); s.append("\n" + indtd);
            for (size_t i=0; i<x.n_args; i++) {
                self().visit_argstar(x.m_args[i]);
                if (i < x.n_args-1) {
                    s.append(",\n" + indtd);
                };
            }
            dec_indent(); s.append("\n" + indtd);
        }
        s.append("]");
        s.append(",\n" + indtd);
        s.append("\"kwargs\": ");
        s.append("[");
        if (x.n_kwargs > 0) {
            inc_indent(); s.append("\n" + indtd);
            for (size_t i=0; i<x.n_kwargs; i++) {
                self().visit_kw_argstar(x.m_kwargs[i]);
                if (i < x.n_kwargs-1) {
                    s.append(",\n" + indtd);
                };
            }
            dec_indent(); s.append("\n" + indtd);
        }
        s.append("]");
        s.append(",\n" + indtd);
        s.append("\"values\": ");
        s.append("[");
        if (x.n_values > 0) {
            inc_indent(); s.append("\n" + indtd);
            for (size_t i=0; i<x.n_values; i++) {
                self().visit_expr(*x.m_values[i]);
                if (i < x.n_values-1) {
                    s.append(",\n" + indtd);
                };
            }
            dec_indent(); s.append("\n" + indtd);
        }
        s.append("]");
        s.append(",\n" + indtd);
        s.append("\"trivia\": ");
        if (x.m_trivia) {
            self().visit_trivia(*x.m_trivia);
        } else {
            s.append("[]");
        }
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        append_location(s, x.base.base.loc.first, x.base.base.loc.last);
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        if ((bool&)x) { } // Suppress unused warning
    }
    void visit_AssociateBlock(const AssociateBlock_t &x) {
        s.append("{");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"node\": \"AssociateBlock\"");
        s.append(",\n" + indtd);
        s.append("\"fields\": {");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"label\": ");
        s.append(std::to_string(x.m_label));
        s.append(",\n" + indtd);
        s.append("\"stmt_name\": ");
        if (x.m_stmt_name) {
            s.append("\"" + std::string(x.m_stmt_name) + "\"");
        } else {
            s.append("[]");
        }
        s.append(",\n" + indtd);
        s.append("\"syms\": ");
        s.append("[");
        if (x.n_syms > 0) {
            inc_indent(); s.append("\n" + indtd);
            for (size_t i=0; i<x.n_syms; i++) {
                self().visit_var_sym(x.m_syms[i]);
                if (i < x.n_syms-1) {
                    s.append(",\n" + indtd);
                };
            }
            dec_indent(); s.append("\n" + indtd);
        }
        s.append("]");
        s.append(",\n" + indtd);
        s.append("\"body\": ");
        s.append("[");
        if (x.n_body > 0) {
            inc_indent(); s.append("\n" + indtd);
            for (size_t i=0; i<x.n_body; i++) {
                self().visit_stmt(*x.m_body[i]);
                if (i < x.n_body-1) {
                    s.append(",\n" + indtd);
                };
            }
            dec_indent(); s.append("\n" + indtd);
        }
        s.append("]");
        s.append(",\n" + indtd);
        s.append("\"t_inside\": ");
        if (x.m_t_inside) {
            self().visit_trivia(*x.m_t_inside);
        } else {
            s.append("[]");
        }
        s.append(",\n" + indtd);
        s.append("\"trivia\": ");
        if (x.m_trivia) {
            self().visit_trivia(*x.m_trivia);
        } else {
            s.append("[]");
        }
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        append_location(s, x.base.base.loc.first, x.base.base.loc.last);
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        if ((bool&)x) { } // Suppress unused warning
    }
    void visit_Block(const Block_t &x) {
        s.append("{");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"node\": \"Block\"");
        s.append(",\n" + indtd);
        s.append("\"fields\": {");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"label\": ");
        s.append(std::to_string(x.m_label));
        s.append(",\n" + indtd);
        s.append("\"stmt_name\": ");
        if (x.m_stmt_name) {
            s.append("\"" + std::string(x.m_stmt_name) + "\"");
        } else {
            s.append("[]");
        }
        s.append(",\n" + indtd);
        s.append("\"use\": ");
        s.append("[");
        if (x.n_use > 0) {
            inc_indent(); s.append("\n" + indtd);
            for (size_t i=0; i<x.n_use; i++) {
                self().visit_unit_decl1(*x.m_use[i]);
                if (i < x.n_use-1) {
                    s.append(",\n" + indtd);
                };
            }
            dec_indent(); s.append("\n" + indtd);
        }
        s.append("]");
        s.append(",\n" + indtd);
        s.append("\"import\": ");
        s.append("[");
        if (x.n_import > 0) {
            inc_indent(); s.append("\n" + indtd);
            for (size_t i=0; i<x.n_import; i++) {
                self().visit_import_statement(*x.m_import[i]);
                if (i < x.n_import-1) {
                    s.append(",\n" + indtd);
                };
            }
            dec_indent(); s.append("\n" + indtd);
        }
        s.append("]");
        s.append(",\n" + indtd);
        s.append("\"decl\": ");
        s.append("[");
        if (x.n_decl > 0) {
            inc_indent(); s.append("\n" + indtd);
            for (size_t i=0; i<x.n_decl; i++) {
                self().visit_unit_decl2(*x.m_decl[i]);
                if (i < x.n_decl-1) {
                    s.append(",\n" + indtd);
                };
            }
            dec_indent(); s.append("\n" + indtd);
        }
        s.append("]");
        s.append(",\n" + indtd);
        s.append("\"body\": ");
        s.append("[");
        if (x.n_body > 0) {
            inc_indent(); s.append("\n" + indtd);
            for (size_t i=0; i<x.n_body; i++) {
                self().visit_stmt(*x.m_body[i]);
                if (i < x.n_body-1) {
                    s.append(",\n" + indtd);
                };
            }
            dec_indent(); s.append("\n" + indtd);
        }
        s.append("]");
        s.append(",\n" + indtd);
        s.append("\"t_inside\": ");
        if (x.m_t_inside) {
            self().visit_trivia(*x.m_t_inside);
        } else {
            s.append("[]");
        }
        s.append(",\n" + indtd);
        s.append("\"trivia\": ");
        if (x.m_trivia) {
            self().visit_trivia(*x.m_trivia);
        } else {
            s.append("[]");
        }
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        append_location(s, x.base.base.loc.first, x.base.base.loc.last);
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        if ((bool&)x) { } // Suppress unused warning
    }
    void visit_ChangeTeam(const ChangeTeam_t &x) {
        s.append("{");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"node\": \"ChangeTeam\"");
        s.append(",\n" + indtd);
        s.append("\"fields\": {");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"label\": ");
        s.append(std::to_string(x.m_label));
        s.append(",\n" + indtd);
        s.append("\"stmt_name\": ");
        if (x.m_stmt_name) {
            s.append("\"" + std::string(x.m_stmt_name) + "\"");
        } else {
            s.append("[]");
        }
        s.append(",\n" + indtd);
        s.append("\"team_value\": ");
        self().visit_expr(*x.m_team_value);
        s.append(",\n" + indtd);
        s.append("\"coarray_assoc\": ");
        s.append("[");
        if (x.n_coarray_assoc > 0) {
            inc_indent(); s.append("\n" + indtd);
            for (size_t i=0; i<x.n_coarray_assoc; i++) {
                self().visit_team_attribute(*x.m_coarray_assoc[i]);
                if (i < x.n_coarray_assoc-1) {
                    s.append(",\n" + indtd);
                };
            }
            dec_indent(); s.append("\n" + indtd);
        }
        s.append("]");
        s.append(",\n" + indtd);
        s.append("\"sync\": ");
        s.append("[");
        if (x.n_sync > 0) {
            inc_indent(); s.append("\n" + indtd);
            for (size_t i=0; i<x.n_sync; i++) {
                self().visit_event_attribute(*x.m_sync[i]);
                if (i < x.n_sync-1) {
                    s.append(",\n" + indtd);
                };
            }
            dec_indent(); s.append("\n" + indtd);
        }
        s.append("]");
        s.append(",\n" + indtd);
        s.append("\"body\": ");
        s.append("[");
        if (x.n_body > 0) {
            inc_indent(); s.append("\n" + indtd);
            for (size_t i=0; i<x.n_body; i++) {
                self().visit_stmt(*x.m_body[i]);
                if (i < x.n_body-1) {
                    s.append(",\n" + indtd);
                };
            }
            dec_indent(); s.append("\n" + indtd);
        }
        s.append("]");
        s.append(",\n" + indtd);
        s.append("\"t_inside\": ");
        if (x.m_t_inside) {
            self().visit_trivia(*x.m_t_inside);
        } else {
            s.append("[]");
        }
        s.append(",\n" + indtd);
        s.append("\"trivia\": ");
        if (x.m_trivia) {
            self().visit_trivia(*x.m_trivia);
        } else {
            s.append("[]");
        }
        s.append(",\n" + indtd);
        s.append("\"sync_stat\": ");
        s.append("[");
        if (x.n_sync_stat > 0) {
            inc_indent(); s.append("\n" + indtd);
            for (size_t i=0; i<x.n_sync_stat; i++) {
                self().visit_event_attribute(*x.m_sync_stat[i]);
                if (i < x.n_sync_stat-1) {
                    s.append(",\n" + indtd);
                };
            }
            dec_indent(); s.append("\n" + indtd);
        }
        s.append("]");
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        append_location(s, x.base.base.loc.first, x.base.base.loc.last);
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        if ((bool&)x) { } // Suppress unused warning
    }
    void visit_Critical(const Critical_t &x) {
        s.append("{");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"node\": \"Critical\"");
        s.append(",\n" + indtd);
        s.append("\"fields\": {");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"label\": ");
        s.append(std::to_string(x.m_label));
        s.append(",\n" + indtd);
        s.append("\"stmt_name\": ");
        if (x.m_stmt_name) {
            s.append("\"" + std::string(x.m_stmt_name) + "\"");
        } else {
            s.append("[]");
        }
        s.append(",\n" + indtd);
        s.append("\"sync_stat\": ");
        s.append("[");
        if (x.n_sync_stat > 0) {
            inc_indent(); s.append("\n" + indtd);
            for (size_t i=0; i<x.n_sync_stat; i++) {
                self().visit_event_attribute(*x.m_sync_stat[i]);
                if (i < x.n_sync_stat-1) {
                    s.append(",\n" + indtd);
                };
            }
            dec_indent(); s.append("\n" + indtd);
        }
        s.append("]");
        s.append(",\n" + indtd);
        s.append("\"body\": ");
        s.append("[");
        if (x.n_body > 0) {
            inc_indent(); s.append("\n" + indtd);
            for (size_t i=0; i<x.n_body; i++) {
                self().visit_stmt(*x.m_body[i]);
                if (i < x.n_body-1) {
                    s.append(",\n" + indtd);
                };
            }
            dec_indent(); s.append("\n" + indtd);
        }
        s.append("]");
        s.append(",\n" + indtd);
        s.append("\"t_inside\": ");
        if (x.m_t_inside) {
            self().visit_trivia(*x.m_t_inside);
        } else {
            s.append("[]");
        }
        s.append(",\n" + indtd);
        s.append("\"trivia\": ");
        if (x.m_trivia) {
            self().visit_trivia(*x.m_trivia);
        } else {
            s.append("[]");
        }
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        append_location(s, x.base.base.loc.first, x.base.base.loc.last);
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        if ((bool&)x) { } // Suppress unused warning
    }
    void visit_DoConcurrentLoop(const DoConcurrentLoop_t &x) {
        s.append("{");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"node\": \"DoConcurrentLoop\"");
        s.append(",\n" + indtd);
        s.append("\"fields\": {");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"label\": ");
        s.append(std::to_string(x.m_label));
        s.append(",\n" + indtd);
        s.append("\"stmt_name\": ");
        if (x.m_stmt_name) {
            s.append("\"" + std::string(x.m_stmt_name) + "\"");
        } else {
            s.append("[]");
        }
        s.append(",\n" + indtd);
        s.append("\"control\": ");
        s.append("[");
        if (x.n_control > 0) {
            inc_indent(); s.append("\n" + indtd);
            for (size_t i=0; i<x.n_control; i++) {
                self().visit_concurrent_control(*x.m_control[i]);
                if (i < x.n_control-1) {
                    s.append(",\n" + indtd);
                };
            }
            dec_indent(); s.append("\n" + indtd);
        }
        s.append("]");
        s.append(",\n" + indtd);
        s.append("\"mask\": ");
        if (x.m_mask) {
            self().visit_expr(*x.m_mask);
        } else {
            s.append("[]");
        }
        s.append(",\n" + indtd);
        s.append("\"locality\": ");
        s.append("[");
        if (x.n_locality > 0) {
            inc_indent(); s.append("\n" + indtd);
            for (size_t i=0; i<x.n_locality; i++) {
                self().visit_concurrent_locality(*x.m_locality[i]);
                if (i < x.n_locality-1) {
                    s.append(",\n" + indtd);
                };
            }
            dec_indent(); s.append("\n" + indtd);
        }
        s.append("]");
        s.append(",\n" + indtd);
        s.append("\"body\": ");
        s.append("[");
        if (x.n_body > 0) {
            inc_indent(); s.append("\n" + indtd);
            for (size_t i=0; i<x.n_body; i++) {
                self().visit_stmt(*x.m_body[i]);
                if (i < x.n_body-1) {
                    s.append(",\n" + indtd);
                };
            }
            dec_indent(); s.append("\n" + indtd);
        }
        s.append("]");
        s.append(",\n" + indtd);
        s.append("\"t_inside\": ");
        if (x.m_t_inside) {
            self().visit_trivia(*x.m_t_inside);
        } else {
            s.append("[]");
        }
        s.append(",\n" + indtd);
        s.append("\"trivia\": ");
        if (x.m_trivia) {
            self().visit_trivia(*x.m_trivia);
        } else {
            s.append("[]");
        }
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        append_location(s, x.base.base.loc.first, x.base.base.loc.last);
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        if ((bool&)x) { } // Suppress unused warning
    }
    void visit_DoLoop(const DoLoop_t &x) {
        s.append("{");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"node\": \"DoLoop\"");
        s.append(",\n" + indtd);
        s.append("\"fields\": {");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"label\": ");
        s.append(std::to_string(x.m_label));
        s.append(",\n" + indtd);
        s.append("\"stmt_name\": ");
        if (x.m_stmt_name) {
            s.append("\"" + std::string(x.m_stmt_name) + "\"");
        } else {
            s.append("[]");
        }
        s.append(",\n" + indtd);
        s.append("\"do_label\": ");
        s.append(std::to_string(x.m_do_label));
        s.append(",\n" + indtd);
        s.append("\"var\": ");
        if (x.m_var) {
            s.append("\"" + std::string(x.m_var) + "\"");
        } else {
            s.append("[]");
        }
        s.append(",\n" + indtd);
        s.append("\"start\": ");
        if (x.m_start) {
            self().visit_expr(*x.m_start);
        } else {
            s.append("[]");
        }
        s.append(",\n" + indtd);
        s.append("\"end\": ");
        if (x.m_end) {
            self().visit_expr(*x.m_end);
        } else {
            s.append("[]");
        }
        s.append(",\n" + indtd);
        s.append("\"increment\": ");
        if (x.m_increment) {
            self().visit_expr(*x.m_increment);
        } else {
            s.append("[]");
        }
        s.append(",\n" + indtd);
        s.append("\"body\": ");
        s.append("[");
        if (x.n_body > 0) {
            inc_indent(); s.append("\n" + indtd);
            for (size_t i=0; i<x.n_body; i++) {
                self().visit_stmt(*x.m_body[i]);
                if (i < x.n_body-1) {
                    s.append(",\n" + indtd);
                };
            }
            dec_indent(); s.append("\n" + indtd);
        }
        s.append("]");
        s.append(",\n" + indtd);
        s.append("\"t_inside\": ");
        if (x.m_t_inside) {
            self().visit_trivia(*x.m_t_inside);
        } else {
            s.append("[]");
        }
        s.append(",\n" + indtd);
        s.append("\"trivia\": ");
        if (x.m_trivia) {
            self().visit_trivia(*x.m_trivia);
        } else {
            s.append("[]");
        }
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        append_location(s, x.base.base.loc.first, x.base.base.loc.last);
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        if ((bool&)x) { } // Suppress unused warning
    }
    void visit_ForAll(const ForAll_t &x) {
        s.append("{");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"node\": \"ForAll\"");
        s.append(",\n" + indtd);
        s.append("\"fields\": {");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"label\": ");
        s.append(std::to_string(x.m_label));
        s.append(",\n" + indtd);
        s.append("\"stmt_name\": ");
        if (x.m_stmt_name) {
            s.append("\"" + std::string(x.m_stmt_name) + "\"");
        } else {
            s.append("[]");
        }
        s.append(",\n" + indtd);
        s.append("\"control\": ");
        s.append("[");
        if (x.n_control > 0) {
            inc_indent(); s.append("\n" + indtd);
            for (size_t i=0; i<x.n_control; i++) {
                self().visit_concurrent_control(*x.m_control[i]);
                if (i < x.n_control-1) {
                    s.append(",\n" + indtd);
                };
            }
            dec_indent(); s.append("\n" + indtd);
        }
        s.append("]");
        s.append(",\n" + indtd);
        s.append("\"mask\": ");
        if (x.m_mask) {
            self().visit_expr(*x.m_mask);
        } else {
            s.append("[]");
        }
        s.append(",\n" + indtd);
        s.append("\"locality\": ");
        s.append("[");
        if (x.n_locality > 0) {
            inc_indent(); s.append("\n" + indtd);
            for (size_t i=0; i<x.n_locality; i++) {
                self().visit_concurrent_locality(*x.m_locality[i]);
                if (i < x.n_locality-1) {
                    s.append(",\n" + indtd);
                };
            }
            dec_indent(); s.append("\n" + indtd);
        }
        s.append("]");
        s.append(",\n" + indtd);
        s.append("\"body\": ");
        s.append("[");
        if (x.n_body > 0) {
            inc_indent(); s.append("\n" + indtd);
            for (size_t i=0; i<x.n_body; i++) {
                self().visit_stmt(*x.m_body[i]);
                if (i < x.n_body-1) {
                    s.append(",\n" + indtd);
                };
            }
            dec_indent(); s.append("\n" + indtd);
        }
        s.append("]");
        s.append(",\n" + indtd);
        s.append("\"t_inside\": ");
        if (x.m_t_inside) {
            self().visit_trivia(*x.m_t_inside);
        } else {
            s.append("[]");
        }
        s.append(",\n" + indtd);
        s.append("\"trivia\": ");
        if (x.m_trivia) {
            self().visit_trivia(*x.m_trivia);
        } else {
            s.append("[]");
        }
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        append_location(s, x.base.base.loc.first, x.base.base.loc.last);
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        if ((bool&)x) { } // Suppress unused warning
    }
    void visit_If(const If_t &x) {
        s.append("{");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"node\": \"If\"");
        s.append(",\n" + indtd);
        s.append("\"fields\": {");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"label\": ");
        s.append(std::to_string(x.m_label));
        s.append(",\n" + indtd);
        s.append("\"stmt_name\": ");
        if (x.m_stmt_name) {
            s.append("\"" + std::string(x.m_stmt_name) + "\"");
        } else {
            s.append("[]");
        }
        s.append(",\n" + indtd);
        s.append("\"test\": ");
        self().visit_expr(*x.m_test);
        s.append(",\n" + indtd);
        s.append("\"body\": ");
        s.append("[");
        if (x.n_body > 0) {
            inc_indent(); s.append("\n" + indtd);
            for (size_t i=0; i<x.n_body; i++) {
                self().visit_stmt(*x.m_body[i]);
                if (i < x.n_body-1) {
                    s.append(",\n" + indtd);
                };
            }
            dec_indent(); s.append("\n" + indtd);
        }
        s.append("]");
        s.append(",\n" + indtd);
        s.append("\"orelse\": ");
        s.append("[");
        if (x.n_orelse > 0) {
            inc_indent(); s.append("\n" + indtd);
            for (size_t i=0; i<x.n_orelse; i++) {
                self().visit_stmt(*x.m_orelse[i]);
                if (i < x.n_orelse-1) {
                    s.append(",\n" + indtd);
                };
            }
            dec_indent(); s.append("\n" + indtd);
        }
        s.append("]");
        s.append(",\n" + indtd);
        s.append("\"if_trivia\": ");
        if (x.m_if_trivia) {
            self().visit_trivia(*x.m_if_trivia);
        } else {
            s.append("[]");
        }
        s.append(",\n" + indtd);
        s.append("\"else_trivia\": ");
        if (x.m_else_trivia) {
            self().visit_trivia(*x.m_else_trivia);
        } else {
            s.append("[]");
        }
        s.append(",\n" + indtd);
        s.append("\"trivia\": ");
        if (x.m_trivia) {
            self().visit_trivia(*x.m_trivia);
        } else {
            s.append("[]");
        }
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        append_location(s, x.base.base.loc.first, x.base.base.loc.last);
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        if ((bool&)x) { } // Suppress unused warning
    }
    void visit_IfArithmetic(const IfArithmetic_t &x) {
        s.append("{");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"node\": \"IfArithmetic\"");
        s.append(",\n" + indtd);
        s.append("\"fields\": {");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"label\": ");
        s.append(std::to_string(x.m_label));
        s.append(",\n" + indtd);
        s.append("\"stmt_name\": ");
        if (x.m_stmt_name) {
            s.append("\"" + std::string(x.m_stmt_name) + "\"");
        } else {
            s.append("[]");
        }
        s.append(",\n" + indtd);
        s.append("\"test\": ");
        self().visit_expr(*x.m_test);
        s.append(",\n" + indtd);
        s.append("\"lt_label\": ");
        s.append(std::to_string(x.m_lt_label));
        s.append(",\n" + indtd);
        s.append("\"eq_label\": ");
        s.append(std::to_string(x.m_eq_label));
        s.append(",\n" + indtd);
        s.append("\"gt_label\": ");
        s.append(std::to_string(x.m_gt_label));
        s.append(",\n" + indtd);
        s.append("\"trivia\": ");
        if (x.m_trivia) {
            self().visit_trivia(*x.m_trivia);
        } else {
            s.append("[]");
        }
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        append_location(s, x.base.base.loc.first, x.base.base.loc.last);
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        if ((bool&)x) { } // Suppress unused warning
    }
    void visit_Select(const Select_t &x) {
        s.append("{");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"node\": \"Select\"");
        s.append(",\n" + indtd);
        s.append("\"fields\": {");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"label\": ");
        s.append(std::to_string(x.m_label));
        s.append(",\n" + indtd);
        s.append("\"stmt_name\": ");
        if (x.m_stmt_name) {
            s.append("\"" + std::string(x.m_stmt_name) + "\"");
        } else {
            s.append("[]");
        }
        s.append(",\n" + indtd);
        s.append("\"test\": ");
        self().visit_expr(*x.m_test);
        s.append(",\n" + indtd);
        s.append("\"body\": ");
        s.append("[");
        if (x.n_body > 0) {
            inc_indent(); s.append("\n" + indtd);
            for (size_t i=0; i<x.n_body; i++) {
                self().visit_case_stmt(*x.m_body[i]);
                if (i < x.n_body-1) {
                    s.append(",\n" + indtd);
                };
            }
            dec_indent(); s.append("\n" + indtd);
        }
        s.append("]");
        s.append(",\n" + indtd);
        s.append("\"t_inside\": ");
        if (x.m_t_inside) {
            self().visit_trivia(*x.m_t_inside);
        } else {
            s.append("[]");
        }
        s.append(",\n" + indtd);
        s.append("\"trivia\": ");
        if (x.m_trivia) {
            self().visit_trivia(*x.m_trivia);
        } else {
            s.append("[]");
        }
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        append_location(s, x.base.base.loc.first, x.base.base.loc.last);
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        if ((bool&)x) { } // Suppress unused warning
    }
    void visit_SelectRank(const SelectRank_t &x) {
        s.append("{");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"node\": \"SelectRank\"");
        s.append(",\n" + indtd);
        s.append("\"fields\": {");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"label\": ");
        s.append(std::to_string(x.m_label));
        s.append(",\n" + indtd);
        s.append("\"stmt_name\": ");
        if (x.m_stmt_name) {
            s.append("\"" + std::string(x.m_stmt_name) + "\"");
        } else {
            s.append("[]");
        }
        s.append(",\n" + indtd);
        s.append("\"assoc_name\": ");
        if (x.m_assoc_name) {
            s.append("\"" + std::string(x.m_assoc_name) + "\"");
        } else {
            s.append("[]");
        }
        s.append(",\n" + indtd);
        s.append("\"selector\": ");
        self().visit_expr(*x.m_selector);
        s.append(",\n" + indtd);
        s.append("\"body\": ");
        s.append("[");
        if (x.n_body > 0) {
            inc_indent(); s.append("\n" + indtd);
            for (size_t i=0; i<x.n_body; i++) {
                self().visit_rank_stmt(*x.m_body[i]);
                if (i < x.n_body-1) {
                    s.append(",\n" + indtd);
                };
            }
            dec_indent(); s.append("\n" + indtd);
        }
        s.append("]");
        s.append(",\n" + indtd);
        s.append("\"t_inside\": ");
        if (x.m_t_inside) {
            self().visit_trivia(*x.m_t_inside);
        } else {
            s.append("[]");
        }
        s.append(",\n" + indtd);
        s.append("\"trivia\": ");
        if (x.m_trivia) {
            self().visit_trivia(*x.m_trivia);
        } else {
            s.append("[]");
        }
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        append_location(s, x.base.base.loc.first, x.base.base.loc.last);
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        if ((bool&)x) { } // Suppress unused warning
    }
    void visit_SelectType(const SelectType_t &x) {
        s.append("{");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"node\": \"SelectType\"");
        s.append(",\n" + indtd);
        s.append("\"fields\": {");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"label\": ");
        s.append(std::to_string(x.m_label));
        s.append(",\n" + indtd);
        s.append("\"stmt_name\": ");
        if (x.m_stmt_name) {
            s.append("\"" + std::string(x.m_stmt_name) + "\"");
        } else {
            s.append("[]");
        }
        s.append(",\n" + indtd);
        s.append("\"assoc_name\": ");
        if (x.m_assoc_name) {
            s.append("\"" + std::string(x.m_assoc_name) + "\"");
        } else {
            s.append("[]");
        }
        s.append(",\n" + indtd);
        s.append("\"selector\": ");
        self().visit_expr(*x.m_selector);
        s.append(",\n" + indtd);
        s.append("\"body\": ");
        s.append("[");
        if (x.n_body > 0) {
            inc_indent(); s.append("\n" + indtd);
            for (size_t i=0; i<x.n_body; i++) {
                self().visit_type_stmt(*x.m_body[i]);
                if (i < x.n_body-1) {
                    s.append(",\n" + indtd);
                };
            }
            dec_indent(); s.append("\n" + indtd);
        }
        s.append("]");
        s.append(",\n" + indtd);
        s.append("\"t_inside\": ");
        if (x.m_t_inside) {
            self().visit_trivia(*x.m_t_inside);
        } else {
            s.append("[]");
        }
        s.append(",\n" + indtd);
        s.append("\"trivia\": ");
        if (x.m_trivia) {
            self().visit_trivia(*x.m_trivia);
        } else {
            s.append("[]");
        }
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        append_location(s, x.base.base.loc.first, x.base.base.loc.last);
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        if ((bool&)x) { } // Suppress unused warning
    }
    void visit_Where(const Where_t &x) {
        s.append("{");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"node\": \"Where\"");
        s.append(",\n" + indtd);
        s.append("\"fields\": {");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"label\": ");
        s.append(std::to_string(x.m_label));
        s.append(",\n" + indtd);
        s.append("\"stmt_name\": ");
        if (x.m_stmt_name) {
            s.append("\"" + std::string(x.m_stmt_name) + "\"");
        } else {
            s.append("[]");
        }
        s.append(",\n" + indtd);
        s.append("\"test\": ");
        self().visit_expr(*x.m_test);
        s.append(",\n" + indtd);
        s.append("\"body\": ");
        s.append("[");
        if (x.n_body > 0) {
            inc_indent(); s.append("\n" + indtd);
            for (size_t i=0; i<x.n_body; i++) {
                self().visit_stmt(*x.m_body[i]);
                if (i < x.n_body-1) {
                    s.append(",\n" + indtd);
                };
            }
            dec_indent(); s.append("\n" + indtd);
        }
        s.append("]");
        s.append(",\n" + indtd);
        s.append("\"orelse\": ");
        s.append("[");
        if (x.n_orelse > 0) {
            inc_indent(); s.append("\n" + indtd);
            for (size_t i=0; i<x.n_orelse; i++) {
                self().visit_stmt(*x.m_orelse[i]);
                if (i < x.n_orelse-1) {
                    s.append(",\n" + indtd);
                };
            }
            dec_indent(); s.append("\n" + indtd);
        }
        s.append("]");
        s.append(",\n" + indtd);
        s.append("\"t_inside\": ");
        if (x.m_t_inside) {
            self().visit_trivia(*x.m_t_inside);
        } else {
            s.append("[]");
        }
        s.append(",\n" + indtd);
        s.append("\"trivia\": ");
        if (x.m_trivia) {
            self().visit_trivia(*x.m_trivia);
        } else {
            s.append("[]");
        }
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        append_location(s, x.base.base.loc.first, x.base.base.loc.last);
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        if ((bool&)x) { } // Suppress unused warning
    }
    void visit_WhileLoop(const WhileLoop_t &x) {
        s.append("{");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"node\": \"WhileLoop\"");
        s.append(",\n" + indtd);
        s.append("\"fields\": {");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"label\": ");
        s.append(std::to_string(x.m_label));
        s.append(",\n" + indtd);
        s.append("\"stmt_name\": ");
        if (x.m_stmt_name) {
            s.append("\"" + std::string(x.m_stmt_name) + "\"");
        } else {
            s.append("[]");
        }
        s.append(",\n" + indtd);
        s.append("\"test\": ");
        self().visit_expr(*x.m_test);
        s.append(",\n" + indtd);
        s.append("\"body\": ");
        s.append("[");
        if (x.n_body > 0) {
            inc_indent(); s.append("\n" + indtd);
            for (size_t i=0; i<x.n_body; i++) {
                self().visit_stmt(*x.m_body[i]);
                if (i < x.n_body-1) {
                    s.append(",\n" + indtd);
                };
            }
            dec_indent(); s.append("\n" + indtd);
        }
        s.append("]");
        s.append(",\n" + indtd);
        s.append("\"t_inside\": ");
        if (x.m_t_inside) {
            self().visit_trivia(*x.m_t_inside);
        } else {
            s.append("[]");
        }
        s.append(",\n" + indtd);
        s.append("\"trivia\": ");
        if (x.m_trivia) {
            self().visit_trivia(*x.m_trivia);
        } else {
            s.append("[]");
        }
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        append_location(s, x.base.base.loc.first, x.base.base.loc.last);
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        if ((bool&)x) { } // Suppress unused warning
    }
    void visit_BoolOp(const BoolOp_t &x) {
        s.append("{");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"node\": \"BoolOp\"");
        s.append(",\n" + indtd);
        s.append("\"fields\": {");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"left\": ");
        self().visit_expr(*x.m_left);
        s.append(",\n" + indtd);
        s.append("\"op\": ");
        visit_boolopType(x.m_op);
        s.append(",\n" + indtd);
        s.append("\"right\": ");
        self().visit_expr(*x.m_right);
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        append_location(s, x.base.base.loc.first, x.base.base.loc.last);
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        if ((bool&)x) { } // Suppress unused warning
    }
    void visit_BinOp(const BinOp_t &x) {
        s.append("{");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"node\": \"BinOp\"");
        s.append(",\n" + indtd);
        s.append("\"fields\": {");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"left\": ");
        self().visit_expr(*x.m_left);
        s.append(",\n" + indtd);
        s.append("\"op\": ");
        visit_operatorType(x.m_op);
        s.append(",\n" + indtd);
        s.append("\"right\": ");
        self().visit_expr(*x.m_right);
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        append_location(s, x.base.base.loc.first, x.base.base.loc.last);
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        if ((bool&)x) { } // Suppress unused warning
    }
    void visit_DefBinOp(const DefBinOp_t &x) {
        s.append("{");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"node\": \"DefBinOp\"");
        s.append(",\n" + indtd);
        s.append("\"fields\": {");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"left\": ");
        self().visit_expr(*x.m_left);
        s.append(",\n" + indtd);
        s.append("\"op\": ");
        s.append("\"" + str_escape_c(x.m_op) + "\"");
        s.append(",\n" + indtd);
        s.append("\"right\": ");
        self().visit_expr(*x.m_right);
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        append_location(s, x.base.base.loc.first, x.base.base.loc.last);
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        if ((bool&)x) { } // Suppress unused warning
    }
    void visit_StrOp(const StrOp_t &x) {
        s.append("{");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"node\": \"StrOp\"");
        s.append(",\n" + indtd);
        s.append("\"fields\": {");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"left\": ");
        self().visit_expr(*x.m_left);
        s.append(",\n" + indtd);
        s.append("\"op\": ");
        visit_stroperatorType(x.m_op);
        s.append(",\n" + indtd);
        s.append("\"right\": ");
        self().visit_expr(*x.m_right);
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        append_location(s, x.base.base.loc.first, x.base.base.loc.last);
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        if ((bool&)x) { } // Suppress unused warning
    }
    void visit_UnaryOp(const UnaryOp_t &x) {
        s.append("{");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"node\": \"UnaryOp\"");
        s.append(",\n" + indtd);
        s.append("\"fields\": {");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"op\": ");
        visit_unaryopType(x.m_op);
        s.append(",\n" + indtd);
        s.append("\"operand\": ");
        self().visit_expr(*x.m_operand);
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        append_location(s, x.base.base.loc.first, x.base.base.loc.last);
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        if ((bool&)x) { } // Suppress unused warning
    }
    void visit_DefUnaryOp(const DefUnaryOp_t &x) {
        s.append("{");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"node\": \"DefUnaryOp\"");
        s.append(",\n" + indtd);
        s.append("\"fields\": {");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"op\": ");
        s.append("\"" + str_escape_c(x.m_op) + "\"");
        s.append(",\n" + indtd);
        s.append("\"operand\": ");
        self().visit_expr(*x.m_operand);
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        append_location(s, x.base.base.loc.first, x.base.base.loc.last);
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        if ((bool&)x) { } // Suppress unused warning
    }
    void visit_Compare(const Compare_t &x) {
        s.append("{");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"node\": \"Compare\"");
        s.append(",\n" + indtd);
        s.append("\"fields\": {");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"left\": ");
        self().visit_expr(*x.m_left);
        s.append(",\n" + indtd);
        s.append("\"op\": ");
        visit_cmpopType(x.m_op);
        s.append(",\n" + indtd);
        s.append("\"right\": ");
        self().visit_expr(*x.m_right);
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        append_location(s, x.base.base.loc.first, x.base.base.loc.last);
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        if ((bool&)x) { } // Suppress unused warning
    }
    void visit_FuncCallOrArray(const FuncCallOrArray_t &x) {
        s.append("{");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"node\": \"FuncCallOrArray\"");
        s.append(",\n" + indtd);
        s.append("\"fields\": {");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"func\": ");
        s.append("\"" + std::string(x.m_func) + "\"");
        s.append(",\n" + indtd);
        s.append("\"member\": ");
        s.append("[");
        if (x.n_member > 0) {
            inc_indent(); s.append("\n" + indtd);
            for (size_t i=0; i<x.n_member; i++) {
                self().visit_struct_member(x.m_member[i]);
                if (i < x.n_member-1) {
                    s.append(",\n" + indtd);
                };
            }
            dec_indent(); s.append("\n" + indtd);
        }
        s.append("]");
        s.append(",\n" + indtd);
        s.append("\"args\": ");
        s.append("[");
        if (x.n_args > 0) {
            inc_indent(); s.append("\n" + indtd);
            for (size_t i=0; i<x.n_args; i++) {
                self().visit_fnarg(x.m_args[i]);
                if (i < x.n_args-1) {
                    s.append(",\n" + indtd);
                };
            }
            dec_indent(); s.append("\n" + indtd);
        }
        s.append("]");
        s.append(",\n" + indtd);
        s.append("\"keywords\": ");
        s.append("[");
        if (x.n_keywords > 0) {
            inc_indent(); s.append("\n" + indtd);
            for (size_t i=0; i<x.n_keywords; i++) {
                self().visit_keyword(x.m_keywords[i]);
                if (i < x.n_keywords-1) {
                    s.append(",\n" + indtd);
                };
            }
            dec_indent(); s.append("\n" + indtd);
        }
        s.append("]");
        s.append(",\n" + indtd);
        s.append("\"subargs\": ");
        s.append("[");
        if (x.n_subargs > 0) {
            inc_indent(); s.append("\n" + indtd);
            for (size_t i=0; i<x.n_subargs; i++) {
                self().visit_fnarg(x.m_subargs[i]);
                if (i < x.n_subargs-1) {
                    s.append(",\n" + indtd);
                };
            }
            dec_indent(); s.append("\n" + indtd);
        }
        s.append("]");
        s.append(",\n" + indtd);
        s.append("\"temp_args\": ");
        s.append("[");
        if (x.n_temp_args > 0) {
            inc_indent(); s.append("\n" + indtd);
            for (size_t i=0; i<x.n_temp_args; i++) {
                self().visit_decl_attribute(*x.m_temp_args[i]);
                if (i < x.n_temp_args-1) {
                    s.append(",\n" + indtd);
                };
            }
            dec_indent(); s.append("\n" + indtd);
        }
        s.append("]");
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        append_location(s, x.base.base.loc.first, x.base.base.loc.last);
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        if ((bool&)x) { } // Suppress unused warning
    }
    void visit_CoarrayRef(const CoarrayRef_t &x) {
        s.append("{");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"node\": \"CoarrayRef\"");
        s.append(",\n" + indtd);
        s.append("\"fields\": {");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"name\": ");
        s.append("\"" + std::string(x.m_name) + "\"");
        s.append(",\n" + indtd);
        s.append("\"member\": ");
        s.append("[");
        if (x.n_member > 0) {
            inc_indent(); s.append("\n" + indtd);
            for (size_t i=0; i<x.n_member; i++) {
                self().visit_struct_member(x.m_member[i]);
                if (i < x.n_member-1) {
                    s.append(",\n" + indtd);
                };
            }
            dec_indent(); s.append("\n" + indtd);
        }
        s.append("]");
        s.append(",\n" + indtd);
        s.append("\"args\": ");
        s.append("[");
        if (x.n_args > 0) {
            inc_indent(); s.append("\n" + indtd);
            for (size_t i=0; i<x.n_args; i++) {
                self().visit_fnarg(x.m_args[i]);
                if (i < x.n_args-1) {
                    s.append(",\n" + indtd);
                };
            }
            dec_indent(); s.append("\n" + indtd);
        }
        s.append("]");
        s.append(",\n" + indtd);
        s.append("\"fnkw\": ");
        s.append("[");
        if (x.n_fnkw > 0) {
            inc_indent(); s.append("\n" + indtd);
            for (size_t i=0; i<x.n_fnkw; i++) {
                self().visit_keyword(x.m_fnkw[i]);
                if (i < x.n_fnkw-1) {
                    s.append(",\n" + indtd);
                };
            }
            dec_indent(); s.append("\n" + indtd);
        }
        s.append("]");
        s.append(",\n" + indtd);
        s.append("\"coargs\": ");
        s.append("[");
        if (x.n_coargs > 0) {
            inc_indent(); s.append("\n" + indtd);
            for (size_t i=0; i<x.n_coargs; i++) {
                self().visit_coarrayarg(x.m_coargs[i]);
                if (i < x.n_coargs-1) {
                    s.append(",\n" + indtd);
                };
            }
            dec_indent(); s.append("\n" + indtd);
        }
        s.append("]");
        s.append(",\n" + indtd);
        s.append("\"cokw\": ");
        s.append("[");
        if (x.n_cokw > 0) {
            inc_indent(); s.append("\n" + indtd);
            for (size_t i=0; i<x.n_cokw; i++) {
                self().visit_keyword(x.m_cokw[i]);
                if (i < x.n_cokw-1) {
                    s.append(",\n" + indtd);
                };
            }
            dec_indent(); s.append("\n" + indtd);
        }
        s.append("]");
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        append_location(s, x.base.base.loc.first, x.base.base.loc.last);
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        if ((bool&)x) { } // Suppress unused warning
    }
    void visit_ArrayInitializer(const ArrayInitializer_t &x) {
        s.append("{");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"node\": \"ArrayInitializer\"");
        s.append(",\n" + indtd);
        s.append("\"fields\": {");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"vartype\": ");
        if (x.m_vartype) {
            self().visit_decl_attribute(*x.m_vartype);
        } else {
            s.append("[]");
        }
        s.append(",\n" + indtd);
        s.append("\"classtype\": ");
        if (x.m_classtype) {
            s.append("\"" + std::string(x.m_classtype) + "\"");
        } else {
            s.append("[]");
        }
        s.append(",\n" + indtd);
        s.append("\"args\": ");
        s.append("[");
        if (x.n_args > 0) {
            inc_indent(); s.append("\n" + indtd);
            for (size_t i=0; i<x.n_args; i++) {
                self().visit_expr(*x.m_args[i]);
                if (i < x.n_args-1) {
                    s.append(",\n" + indtd);
                };
            }
            dec_indent(); s.append("\n" + indtd);
        }
        s.append("]");
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        append_location(s, x.base.base.loc.first, x.base.base.loc.last);
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        if ((bool&)x) { } // Suppress unused warning
    }
    void visit_ImpliedDoLoop(const ImpliedDoLoop_t &x) {
        s.append("{");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"node\": \"ImpliedDoLoop\"");
        s.append(",\n" + indtd);
        s.append("\"fields\": {");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"values\": ");
        s.append("[");
        if (x.n_values > 0) {
            inc_indent(); s.append("\n" + indtd);
            for (size_t i=0; i<x.n_values; i++) {
                self().visit_expr(*x.m_values[i]);
                if (i < x.n_values-1) {
                    s.append(",\n" + indtd);
                };
            }
            dec_indent(); s.append("\n" + indtd);
        }
        s.append("]");
        s.append(",\n" + indtd);
        s.append("\"var\": ");
        s.append("\"" + std::string(x.m_var) + "\"");
        s.append(",\n" + indtd);
        s.append("\"start\": ");
        self().visit_expr(*x.m_start);
        s.append(",\n" + indtd);
        s.append("\"end\": ");
        self().visit_expr(*x.m_end);
        s.append(",\n" + indtd);
        s.append("\"increment\": ");
        if (x.m_increment) {
            self().visit_expr(*x.m_increment);
        } else {
            s.append("[]");
        }
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        append_location(s, x.base.base.loc.first, x.base.base.loc.last);
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        if ((bool&)x) { } // Suppress unused warning
    }
    void visit_Num(const Num_t &x) {
        s.append("{");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"node\": \"Num\"");
        s.append(",\n" + indtd);
        s.append("\"fields\": {");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"n\": ");
        s.append(std::to_string(x.m_n));
        s.append(",\n" + indtd);
        s.append("\"kind\": ");
        if (x.m_kind) {
            s.append("\"" + str_escape_c(x.m_kind) + "\"");
        } else {
            s.append("[]");
        }
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        append_location(s, x.base.base.loc.first, x.base.base.loc.last);
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        if ((bool&)x) { } // Suppress unused warning
    }
    void visit_Real(const Real_t &x) {
        s.append("{");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"node\": \"Real\"");
        s.append(",\n" + indtd);
        s.append("\"fields\": {");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"n\": ");
        s.append("\"" + str_escape_c(x.m_n) + "\"");
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        append_location(s, x.base.base.loc.first, x.base.base.loc.last);
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        if ((bool&)x) { } // Suppress unused warning
    }
    void visit_Complex(const Complex_t &x) {
        s.append("{");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"node\": \"Complex\"");
        s.append(",\n" + indtd);
        s.append("\"fields\": {");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"re\": ");
        self().visit_expr(*x.m_re);
        s.append(",\n" + indtd);
        s.append("\"im\": ");
        self().visit_expr(*x.m_im);
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        append_location(s, x.base.base.loc.first, x.base.base.loc.last);
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        if ((bool&)x) { } // Suppress unused warning
    }
    void visit_String(const String_t &x) {
        s.append("{");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"node\": \"String\"");
        s.append(",\n" + indtd);
        s.append("\"fields\": {");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"s\": ");
        s.append("\"" + str_escape_c(x.m_s) + "\"");
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        append_location(s, x.base.base.loc.first, x.base.base.loc.last);
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        if ((bool&)x) { } // Suppress unused warning
    }
    void visit_Substring(const Substring_t &x) {
        s.append("{");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"node\": \"Substring\"");
        s.append(",\n" + indtd);
        s.append("\"fields\": {");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"s\": ");
        s.append("\"" + str_escape_c(x.m_s) + "\"");
        s.append(",\n" + indtd);
        s.append("\"args\": ");
        s.append("[");
        if (x.n_args > 0) {
            inc_indent(); s.append("\n" + indtd);
            for (size_t i=0; i<x.n_args; i++) {
                self().visit_fnarg(x.m_args[i]);
                if (i < x.n_args-1) {
                    s.append(",\n" + indtd);
                };
            }
            dec_indent(); s.append("\n" + indtd);
        }
        s.append("]");
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        append_location(s, x.base.base.loc.first, x.base.base.loc.last);
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        if ((bool&)x) { } // Suppress unused warning
    }
    void visit_BOZ(const BOZ_t &x) {
        s.append("{");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"node\": \"BOZ\"");
        s.append(",\n" + indtd);
        s.append("\"fields\": {");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"s\": ");
        s.append("\"" + str_escape_c(x.m_s) + "\"");
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        append_location(s, x.base.base.loc.first, x.base.base.loc.last);
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        if ((bool&)x) { } // Suppress unused warning
    }
    void visit_Name(const Name_t &x) {
        s.append("{");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"node\": \"Name\"");
        s.append(",\n" + indtd);
        s.append("\"fields\": {");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"id\": ");
        s.append("\"" + std::string(x.m_id) + "\"");
        s.append(",\n" + indtd);
        s.append("\"member\": ");
        s.append("[");
        if (x.n_member > 0) {
            inc_indent(); s.append("\n" + indtd);
            for (size_t i=0; i<x.n_member; i++) {
                self().visit_struct_member(x.m_member[i]);
                if (i < x.n_member-1) {
                    s.append(",\n" + indtd);
                };
            }
            dec_indent(); s.append("\n" + indtd);
        }
        s.append("]");
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        append_location(s, x.base.base.loc.first, x.base.base.loc.last);
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        if ((bool&)x) { } // Suppress unused warning
    }
    void visit_Logical(const Logical_t &x) {
        s.append("{");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"node\": \"Logical\"");
        s.append(",\n" + indtd);
        s.append("\"fields\": {");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"value\": ");
        if (x.m_value) {
            s.append("true");
        } else {
            s.append("false");
        }
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        append_location(s, x.base.base.loc.first, x.base.base.loc.last);
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        if ((bool&)x) { } // Suppress unused warning
    }
    void visit_DataImpliedDo(const DataImpliedDo_t &x) {
        s.append("{");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"node\": \"DataImpliedDo\"");
        s.append(",\n" + indtd);
        s.append("\"fields\": {");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"object_list\": ");
        s.append("[");
        if (x.n_object_list > 0) {
            inc_indent(); s.append("\n" + indtd);
            for (size_t i=0; i<x.n_object_list; i++) {
                self().visit_expr(*x.m_object_list[i]);
                if (i < x.n_object_list-1) {
                    s.append(",\n" + indtd);
                };
            }
            dec_indent(); s.append("\n" + indtd);
        }
        s.append("]");
        s.append(",\n" + indtd);
        s.append("\"type\": ");
        if (x.m_type) {
            self().visit_decl_attribute(*x.m_type);
        } else {
            s.append("[]");
        }
        s.append(",\n" + indtd);
        s.append("\"var\": ");
        s.append("\"" + std::string(x.m_var) + "\"");
        s.append(",\n" + indtd);
        s.append("\"start\": ");
        self().visit_expr(*x.m_start);
        s.append(",\n" + indtd);
        s.append("\"end\": ");
        self().visit_expr(*x.m_end);
        s.append(",\n" + indtd);
        s.append("\"increment\": ");
        if (x.m_increment) {
            self().visit_expr(*x.m_increment);
        } else {
            s.append("[]");
        }
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        append_location(s, x.base.base.loc.first, x.base.base.loc.last);
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        if ((bool&)x) { } // Suppress unused warning
    }
    void visit_Parenthesis(const Parenthesis_t &x) {
        s.append("{");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"node\": \"Parenthesis\"");
        s.append(",\n" + indtd);
        s.append("\"fields\": {");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"operand\": ");
        self().visit_expr(*x.m_operand);
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        append_location(s, x.base.base.loc.first, x.base.base.loc.last);
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        if ((bool&)x) { } // Suppress unused warning
    }
    void visit_TriviaNode(const TriviaNode_t &x) {
        s.append("{");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"node\": \"TriviaNode\"");
        s.append(",\n" + indtd);
        s.append("\"fields\": {");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"inside\": ");
        s.append("[");
        if (x.n_inside > 0) {
            inc_indent(); s.append("\n" + indtd);
            for (size_t i=0; i<x.n_inside; i++) {
                self().visit_trivia_node(*x.m_inside[i]);
                if (i < x.n_inside-1) {
                    s.append(",\n" + indtd);
                };
            }
            dec_indent(); s.append("\n" + indtd);
        }
        s.append("]");
        s.append(",\n" + indtd);
        s.append("\"after\": ");
        s.append("[");
        if (x.n_after > 0) {
            inc_indent(); s.append("\n" + indtd);
            for (size_t i=0; i<x.n_after; i++) {
                self().visit_trivia_node(*x.m_after[i]);
                if (i < x.n_after-1) {
                    s.append(",\n" + indtd);
                };
            }
            dec_indent(); s.append("\n" + indtd);
        }
        s.append("]");
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        append_location(s, x.base.base.loc.first, x.base.base.loc.last);
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        if ((bool&)x) { } // Suppress unused warning
    }
    void visit_Comment(const Comment_t &x) {
        s.append("{");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"node\": \"Comment\"");
        s.append(",\n" + indtd);
        s.append("\"fields\": {");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"comment\": ");
        s.append("\"" + str_escape_c(x.m_comment) + "\"");
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        append_location(s, x.base.base.loc.first, x.base.base.loc.last);
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        if ((bool&)x) { } // Suppress unused warning
    }
    void visit_EOLComment(const EOLComment_t &x) {
        s.append("{");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"node\": \"EOLComment\"");
        s.append(",\n" + indtd);
        s.append("\"fields\": {");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"comment\": ");
        s.append("\"" + str_escape_c(x.m_comment) + "\"");
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        append_location(s, x.base.base.loc.first, x.base.base.loc.last);
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        if ((bool&)x) { } // Suppress unused warning
    }
    void visit_EndOfLine(const EndOfLine_t &x) {
        s.append("{");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"node\": \"EndOfLine\"");
        s.append(",\n" + indtd);
        s.append("\"fields\": {");
        s.append("}");
        append_location(s, x.base.base.loc.first, x.base.base.loc.last);
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        if ((bool&)x) { } // Suppress unused warning
    }
    void visit_Semicolon(const Semicolon_t &x) {
        s.append("{");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"node\": \"Semicolon\"");
        s.append(",\n" + indtd);
        s.append("\"fields\": {");
        s.append("}");
        append_location(s, x.base.base.loc.first, x.base.base.loc.last);
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        if ((bool&)x) { } // Suppress unused warning
    }
    void visit_boolopType(const boolopType &x) {
        switch (x) {
            case (boolopType::And) : {
                s.append("\"And\"");
             break; }
            case (boolopType::Or) : {
                s.append("\"Or\"");
             break; }
            case (boolopType::Xor) : {
                s.append("\"Xor\"");
             break; }
            case (boolopType::Eqv) : {
                s.append("\"Eqv\"");
             break; }
            case (boolopType::NEqv) : {
                s.append("\"NEqv\"");
             break; }
        }
    }
    void visit_operatorType(const operatorType &x) {
        switch (x) {
            case (operatorType::Add) : {
                s.append("\"Add\"");
             break; }
            case (operatorType::Sub) : {
                s.append("\"Sub\"");
             break; }
            case (operatorType::Mul) : {
                s.append("\"Mul\"");
             break; }
            case (operatorType::Div) : {
                s.append("\"Div\"");
             break; }
            case (operatorType::Pow) : {
                s.append("\"Pow\"");
             break; }
        }
    }
    void visit_stroperatorType(const stroperatorType &x) {
        switch (x) {
            case (stroperatorType::Concat) : {
                s.append("\"Concat\"");
             break; }
        }
    }
    void visit_unaryopType(const unaryopType &x) {
        switch (x) {
            case (unaryopType::Invert) : {
                s.append("\"Invert\"");
             break; }
            case (unaryopType::Not) : {
                s.append("\"Not\"");
             break; }
            case (unaryopType::UAdd) : {
                s.append("\"UAdd\"");
             break; }
            case (unaryopType::USub) : {
                s.append("\"USub\"");
             break; }
        }
    }
    void visit_cmpopType(const cmpopType &x) {
        switch (x) {
            case (cmpopType::Eq) : {
                s.append("\"Eq\"");
             break; }
            case (cmpopType::NotEq) : {
                s.append("\"NotEq\"");
             break; }
            case (cmpopType::Lt) : {
                s.append("\"Lt\"");
             break; }
            case (cmpopType::LtE) : {
                s.append("\"LtE\"");
             break; }
            case (cmpopType::Gt) : {
                s.append("\"Gt\"");
             break; }
            case (cmpopType::GtE) : {
                s.append("\"GtE\"");
             break; }
        }
    }
    void visit_intrinsicopType(const intrinsicopType &x) {
        switch (x) {
            case (intrinsicopType::AND) : {
                s.append("\"AND\"");
             break; }
            case (intrinsicopType::OR) : {
                s.append("\"OR\"");
             break; }
            case (intrinsicopType::XOR) : {
                s.append("\"XOR\"");
             break; }
            case (intrinsicopType::EQV) : {
                s.append("\"EQV\"");
             break; }
            case (intrinsicopType::NEQV) : {
                s.append("\"NEQV\"");
             break; }
            case (intrinsicopType::PLUS) : {
                s.append("\"PLUS\"");
             break; }
            case (intrinsicopType::MINUS) : {
                s.append("\"MINUS\"");
             break; }
            case (intrinsicopType::STAR) : {
                s.append("\"STAR\"");
             break; }
            case (intrinsicopType::DIV) : {
                s.append("\"DIV\"");
             break; }
            case (intrinsicopType::POW) : {
                s.append("\"POW\"");
             break; }
            case (intrinsicopType::NOT) : {
                s.append("\"NOT\"");
             break; }
            case (intrinsicopType::EQ) : {
                s.append("\"EQ\"");
             break; }
            case (intrinsicopType::NOTEQ) : {
                s.append("\"NOTEQ\"");
             break; }
            case (intrinsicopType::LT) : {
                s.append("\"LT\"");
             break; }
            case (intrinsicopType::LTE) : {
                s.append("\"LTE\"");
             break; }
            case (intrinsicopType::GT) : {
                s.append("\"GT\"");
             break; }
            case (intrinsicopType::GTE) : {
                s.append("\"GTE\"");
             break; }
            case (intrinsicopType::CONCAT) : {
                s.append("\"CONCAT\"");
             break; }
        }
    }
    void visit_DerivedTypeProc(const DerivedTypeProc_t &x) {
        s.append("{");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"node\": \"DerivedTypeProc\"");
        s.append(",\n" + indtd);
        s.append("\"fields\": {");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"name\": ");
        if (x.m_name) {
            s.append("\"" + std::string(x.m_name) + "\"");
        } else {
            s.append("[]");
        }
        s.append(",\n" + indtd);
        s.append("\"attr\": ");
        s.append("[");
        if (x.n_attr > 0) {
            inc_indent(); s.append("\n" + indtd);
            for (size_t i=0; i<x.n_attr; i++) {
                self().visit_decl_attribute(*x.m_attr[i]);
                if (i < x.n_attr-1) {
                    s.append(",\n" + indtd);
                };
            }
            dec_indent(); s.append("\n" + indtd);
        }
        s.append("]");
        s.append(",\n" + indtd);
        s.append("\"symbols\": ");
        s.append("[");
        if (x.n_symbols > 0) {
            inc_indent(); s.append("\n" + indtd);
            for (size_t i=0; i<x.n_symbols; i++) {
                self().visit_use_symbol(*x.m_symbols[i]);
                if (i < x.n_symbols-1) {
                    s.append(",\n" + indtd);
                };
            }
            dec_indent(); s.append("\n" + indtd);
        }
        s.append("]");
        s.append(",\n" + indtd);
        s.append("\"trivia\": ");
        if (x.m_trivia) {
            self().visit_trivia(*x.m_trivia);
        } else {
            s.append("[]");
        }
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        append_location(s, x.base.base.loc.first, x.base.base.loc.last);
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        if ((bool&)x) { } // Suppress unused warning
    }
    void visit_GenericOperator(const GenericOperator_t &x) {
        s.append("{");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"node\": \"GenericOperator\"");
        s.append(",\n" + indtd);
        s.append("\"fields\": {");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"attr\": ");
        s.append("[");
        if (x.n_attr > 0) {
            inc_indent(); s.append("\n" + indtd);
            for (size_t i=0; i<x.n_attr; i++) {
                self().visit_decl_attribute(*x.m_attr[i]);
                if (i < x.n_attr-1) {
                    s.append(",\n" + indtd);
                };
            }
            dec_indent(); s.append("\n" + indtd);
        }
        s.append("]");
        s.append(",\n" + indtd);
        s.append("\"op\": ");
        visit_intrinsicopType(x.m_op);
        s.append(",\n" + indtd);
        s.append("\"names\": ");
        s.append("[");
        if (x.n_names > 0) {
            inc_indent(); s.append("\n" + indtd);
            for (size_t i=0; i<x.n_names; i++) {
                s.append("\"" + std::string(x.m_names[i]) + "\"");
                if (i < x.n_names-1) {
                    s.append(",\n" + indtd);
                };
            }
            dec_indent(); s.append("\n" + indtd);
        }
        s.append("]");
        s.append(",\n" + indtd);
        s.append("\"trivia\": ");
        if (x.m_trivia) {
            self().visit_trivia(*x.m_trivia);
        } else {
            s.append("[]");
        }
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        append_location(s, x.base.base.loc.first, x.base.base.loc.last);
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        if ((bool&)x) { } // Suppress unused warning
    }
    void visit_GenericDefinedOperator(const GenericDefinedOperator_t &x) {
        s.append("{");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"node\": \"GenericDefinedOperator\"");
        s.append(",\n" + indtd);
        s.append("\"fields\": {");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"attr\": ");
        s.append("[");
        if (x.n_attr > 0) {
            inc_indent(); s.append("\n" + indtd);
            for (size_t i=0; i<x.n_attr; i++) {
                self().visit_decl_attribute(*x.m_attr[i]);
                if (i < x.n_attr-1) {
                    s.append(",\n" + indtd);
                };
            }
            dec_indent(); s.append("\n" + indtd);
        }
        s.append("]");
        s.append(",\n" + indtd);
        s.append("\"optype\": ");
        s.append("\"" + str_escape_c(x.m_optype) + "\"");
        s.append(",\n" + indtd);
        s.append("\"names\": ");
        s.append("[");
        if (x.n_names > 0) {
            inc_indent(); s.append("\n" + indtd);
            for (size_t i=0; i<x.n_names; i++) {
                s.append("\"" + std::string(x.m_names[i]) + "\"");
                if (i < x.n_names-1) {
                    s.append(",\n" + indtd);
                };
            }
            dec_indent(); s.append("\n" + indtd);
        }
        s.append("]");
        s.append(",\n" + indtd);
        s.append("\"trivia\": ");
        if (x.m_trivia) {
            self().visit_trivia(*x.m_trivia);
        } else {
            s.append("[]");
        }
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        append_location(s, x.base.base.loc.first, x.base.base.loc.last);
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        if ((bool&)x) { } // Suppress unused warning
    }
    void visit_GenericAssignment(const GenericAssignment_t &x) {
        s.append("{");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"node\": \"GenericAssignment\"");
        s.append(",\n" + indtd);
        s.append("\"fields\": {");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"attr\": ");
        s.append("[");
        if (x.n_attr > 0) {
            inc_indent(); s.append("\n" + indtd);
            for (size_t i=0; i<x.n_attr; i++) {
                self().visit_decl_attribute(*x.m_attr[i]);
                if (i < x.n_attr-1) {
                    s.append(",\n" + indtd);
                };
            }
            dec_indent(); s.append("\n" + indtd);
        }
        s.append("]");
        s.append(",\n" + indtd);
        s.append("\"names\": ");
        s.append("[");
        if (x.n_names > 0) {
            inc_indent(); s.append("\n" + indtd);
            for (size_t i=0; i<x.n_names; i++) {
                s.append("\"" + std::string(x.m_names[i]) + "\"");
                if (i < x.n_names-1) {
                    s.append(",\n" + indtd);
                };
            }
            dec_indent(); s.append("\n" + indtd);
        }
        s.append("]");
        s.append(",\n" + indtd);
        s.append("\"trivia\": ");
        if (x.m_trivia) {
            self().visit_trivia(*x.m_trivia);
        } else {
            s.append("[]");
        }
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        append_location(s, x.base.base.loc.first, x.base.base.loc.last);
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        if ((bool&)x) { } // Suppress unused warning
    }
    void visit_GenericName(const GenericName_t &x) {
        s.append("{");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"node\": \"GenericName\"");
        s.append(",\n" + indtd);
        s.append("\"fields\": {");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"attr\": ");
        s.append("[");
        if (x.n_attr > 0) {
            inc_indent(); s.append("\n" + indtd);
            for (size_t i=0; i<x.n_attr; i++) {
                self().visit_decl_attribute(*x.m_attr[i]);
                if (i < x.n_attr-1) {
                    s.append(",\n" + indtd);
                };
            }
            dec_indent(); s.append("\n" + indtd);
        }
        s.append("]");
        s.append(",\n" + indtd);
        s.append("\"name\": ");
        s.append("\"" + std::string(x.m_name) + "\"");
        s.append(",\n" + indtd);
        s.append("\"names\": ");
        s.append("[");
        if (x.n_names > 0) {
            inc_indent(); s.append("\n" + indtd);
            for (size_t i=0; i<x.n_names; i++) {
                s.append("\"" + std::string(x.m_names[i]) + "\"");
                if (i < x.n_names-1) {
                    s.append(",\n" + indtd);
                };
            }
            dec_indent(); s.append("\n" + indtd);
        }
        s.append("]");
        s.append(",\n" + indtd);
        s.append("\"trivia\": ");
        if (x.m_trivia) {
            self().visit_trivia(*x.m_trivia);
        } else {
            s.append("[]");
        }
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        append_location(s, x.base.base.loc.first, x.base.base.loc.last);
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        if ((bool&)x) { } // Suppress unused warning
    }
    void visit_GenericWrite(const GenericWrite_t &x) {
        s.append("{");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"node\": \"GenericWrite\"");
        s.append(",\n" + indtd);
        s.append("\"fields\": {");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"attr\": ");
        s.append("[");
        if (x.n_attr > 0) {
            inc_indent(); s.append("\n" + indtd);
            for (size_t i=0; i<x.n_attr; i++) {
                self().visit_decl_attribute(*x.m_attr[i]);
                if (i < x.n_attr-1) {
                    s.append(",\n" + indtd);
                };
            }
            dec_indent(); s.append("\n" + indtd);
        }
        s.append("]");
        s.append(",\n" + indtd);
        s.append("\"id\": ");
        s.append("\"" + std::string(x.m_id) + "\"");
        s.append(",\n" + indtd);
        s.append("\"names\": ");
        s.append("[");
        if (x.n_names > 0) {
            inc_indent(); s.append("\n" + indtd);
            for (size_t i=0; i<x.n_names; i++) {
                s.append("\"" + std::string(x.m_names[i]) + "\"");
                if (i < x.n_names-1) {
                    s.append(",\n" + indtd);
                };
            }
            dec_indent(); s.append("\n" + indtd);
        }
        s.append("]");
        s.append(",\n" + indtd);
        s.append("\"trivia\": ");
        if (x.m_trivia) {
            self().visit_trivia(*x.m_trivia);
        } else {
            s.append("[]");
        }
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        append_location(s, x.base.base.loc.first, x.base.base.loc.last);
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        if ((bool&)x) { } // Suppress unused warning
    }
    void visit_GenericRead(const GenericRead_t &x) {
        s.append("{");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"node\": \"GenericRead\"");
        s.append(",\n" + indtd);
        s.append("\"fields\": {");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"attr\": ");
        s.append("[");
        if (x.n_attr > 0) {
            inc_indent(); s.append("\n" + indtd);
            for (size_t i=0; i<x.n_attr; i++) {
                self().visit_decl_attribute(*x.m_attr[i]);
                if (i < x.n_attr-1) {
                    s.append(",\n" + indtd);
                };
            }
            dec_indent(); s.append("\n" + indtd);
        }
        s.append("]");
        s.append(",\n" + indtd);
        s.append("\"id\": ");
        s.append("\"" + std::string(x.m_id) + "\"");
        s.append(",\n" + indtd);
        s.append("\"names\": ");
        s.append("[");
        if (x.n_names > 0) {
            inc_indent(); s.append("\n" + indtd);
            for (size_t i=0; i<x.n_names; i++) {
                s.append("\"" + std::string(x.m_names[i]) + "\"");
                if (i < x.n_names-1) {
                    s.append(",\n" + indtd);
                };
            }
            dec_indent(); s.append("\n" + indtd);
        }
        s.append("]");
        s.append(",\n" + indtd);
        s.append("\"trivia\": ");
        if (x.m_trivia) {
            self().visit_trivia(*x.m_trivia);
        } else {
            s.append("[]");
        }
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        append_location(s, x.base.base.loc.first, x.base.base.loc.last);
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        if ((bool&)x) { } // Suppress unused warning
    }
    void visit_FinalName(const FinalName_t &x) {
        s.append("{");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"node\": \"FinalName\"");
        s.append(",\n" + indtd);
        s.append("\"fields\": {");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"name\": ");
        s.append("\"" + std::string(x.m_name) + "\"");
        s.append(",\n" + indtd);
        s.append("\"trivia\": ");
        if (x.m_trivia) {
            self().visit_trivia(*x.m_trivia);
        } else {
            s.append("[]");
        }
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        append_location(s, x.base.base.loc.first, x.base.base.loc.last);
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        if ((bool&)x) { } // Suppress unused warning
    }
    void visit_Private(const Private_t &x) {
        s.append("{");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"node\": \"Private\"");
        s.append(",\n" + indtd);
        s.append("\"fields\": {");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"trivia\": ");
        if (x.m_trivia) {
            self().visit_trivia(*x.m_trivia);
        } else {
            s.append("[]");
        }
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        append_location(s, x.base.base.loc.first, x.base.base.loc.last);
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        if ((bool&)x) { } // Suppress unused warning
    }
    void visit_AttrBind(const AttrBind_t &x) {
        s.append("{");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"node\": \"AttrBind\"");
        s.append(",\n" + indtd);
        s.append("\"fields\": {");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"bind\": ");
        self().visit_bind(*x.m_bind);
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        append_location(s, x.base.base.loc.first, x.base.base.loc.last);
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        if ((bool&)x) { } // Suppress unused warning
    }
    void visit_AttrDimension(const AttrDimension_t &x) {
        s.append("{");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"node\": \"AttrDimension\"");
        s.append(",\n" + indtd);
        s.append("\"fields\": {");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"dim\": ");
        s.append("[");
        if (x.n_dim > 0) {
            inc_indent(); s.append("\n" + indtd);
            for (size_t i=0; i<x.n_dim; i++) {
                self().visit_dimension(x.m_dim[i]);
                if (i < x.n_dim-1) {
                    s.append(",\n" + indtd);
                };
            }
            dec_indent(); s.append("\n" + indtd);
        }
        s.append("]");
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        append_location(s, x.base.base.loc.first, x.base.base.loc.last);
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        if ((bool&)x) { } // Suppress unused warning
    }
    void visit_AttrCodimension(const AttrCodimension_t &x) {
        s.append("{");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"node\": \"AttrCodimension\"");
        s.append(",\n" + indtd);
        s.append("\"fields\": {");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"codim\": ");
        s.append("[");
        if (x.n_codim > 0) {
            inc_indent(); s.append("\n" + indtd);
            for (size_t i=0; i<x.n_codim; i++) {
                self().visit_codimension(x.m_codim[i]);
                if (i < x.n_codim-1) {
                    s.append(",\n" + indtd);
                };
            }
            dec_indent(); s.append("\n" + indtd);
        }
        s.append("]");
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        append_location(s, x.base.base.loc.first, x.base.base.loc.last);
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        if ((bool&)x) { } // Suppress unused warning
    }
    void visit_AttrEquivalence(const AttrEquivalence_t &x) {
        s.append("{");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"node\": \"AttrEquivalence\"");
        s.append(",\n" + indtd);
        s.append("\"fields\": {");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"args\": ");
        s.append("[");
        if (x.n_args > 0) {
            inc_indent(); s.append("\n" + indtd);
            for (size_t i=0; i<x.n_args; i++) {
                self().visit_equi(x.m_args[i]);
                if (i < x.n_args-1) {
                    s.append(",\n" + indtd);
                };
            }
            dec_indent(); s.append("\n" + indtd);
        }
        s.append("]");
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        append_location(s, x.base.base.loc.first, x.base.base.loc.last);
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        if ((bool&)x) { } // Suppress unused warning
    }
    void visit_AttrExtends(const AttrExtends_t &x) {
        s.append("{");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"node\": \"AttrExtends\"");
        s.append(",\n" + indtd);
        s.append("\"fields\": {");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"name\": ");
        s.append("\"" + std::string(x.m_name) + "\"");
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        append_location(s, x.base.base.loc.first, x.base.base.loc.last);
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        if ((bool&)x) { } // Suppress unused warning
    }
    void visit_AttrIntent(const AttrIntent_t &x) {
        s.append("{");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"node\": \"AttrIntent\"");
        s.append(",\n" + indtd);
        s.append("\"fields\": {");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"intent\": ");
        visit_attr_intentType(x.m_intent);
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        append_location(s, x.base.base.loc.first, x.base.base.loc.last);
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        if ((bool&)x) { } // Suppress unused warning
    }
    void visit_AttrNamelist(const AttrNamelist_t &x) {
        s.append("{");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"node\": \"AttrNamelist\"");
        s.append(",\n" + indtd);
        s.append("\"fields\": {");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"name\": ");
        s.append("\"" + std::string(x.m_name) + "\"");
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        append_location(s, x.base.base.loc.first, x.base.base.loc.last);
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        if ((bool&)x) { } // Suppress unused warning
    }
    void visit_AttrPass(const AttrPass_t &x) {
        s.append("{");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"node\": \"AttrPass\"");
        s.append(",\n" + indtd);
        s.append("\"fields\": {");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"name\": ");
        if (x.m_name) {
            s.append("\"" + std::string(x.m_name) + "\"");
        } else {
            s.append("[]");
        }
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        append_location(s, x.base.base.loc.first, x.base.base.loc.last);
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        if ((bool&)x) { } // Suppress unused warning
    }
    void visit_SimpleAttribute(const SimpleAttribute_t &x) {
        s.append("{");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"node\": \"SimpleAttribute\"");
        s.append(",\n" + indtd);
        s.append("\"fields\": {");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"attr\": ");
        visit_simple_attributeType(x.m_attr);
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        append_location(s, x.base.base.loc.first, x.base.base.loc.last);
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        if ((bool&)x) { } // Suppress unused warning
    }
    void visit_AttrType(const AttrType_t &x) {
        s.append("{");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"node\": \"AttrType\"");
        s.append(",\n" + indtd);
        s.append("\"fields\": {");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"type\": ");
        visit_decl_typeType(x.m_type);
        s.append(",\n" + indtd);
        s.append("\"kind\": ");
        s.append("[");
        if (x.n_kind > 0) {
            inc_indent(); s.append("\n" + indtd);
            for (size_t i=0; i<x.n_kind; i++) {
                self().visit_kind_item(x.m_kind[i]);
                if (i < x.n_kind-1) {
                    s.append(",\n" + indtd);
                };
            }
            dec_indent(); s.append("\n" + indtd);
        }
        s.append("]");
        s.append(",\n" + indtd);
        s.append("\"attr\": ");
        if (x.m_attr) {
            self().visit_decl_attribute(*x.m_attr);
        } else {
            s.append("[]");
        }
        s.append(",\n" + indtd);
        s.append("\"name\": ");
        if (x.m_name) {
            s.append("\"" + std::string(x.m_name) + "\"");
        } else {
            s.append("[]");
        }
        s.append(",\n" + indtd);
        s.append("\"sym\": ");
        visit_symbolType(x.m_sym);
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        append_location(s, x.base.base.loc.first, x.base.base.loc.last);
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        if ((bool&)x) { } // Suppress unused warning
    }
    void visit_AttrAssignment(const AttrAssignment_t &x) {
        s.append("{");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"node\": \"AttrAssignment\"");
        s.append(",\n" + indtd);
        s.append("\"fields\": {");
        s.append("}");
        append_location(s, x.base.base.loc.first, x.base.base.loc.last);
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        if ((bool&)x) { } // Suppress unused warning
    }
    void visit_AttrIntrinsicOperator(const AttrIntrinsicOperator_t &x) {
        s.append("{");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"node\": \"AttrIntrinsicOperator\"");
        s.append(",\n" + indtd);
        s.append("\"fields\": {");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"op\": ");
        visit_intrinsicopType(x.m_op);
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        append_location(s, x.base.base.loc.first, x.base.base.loc.last);
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        if ((bool&)x) { } // Suppress unused warning
    }
    void visit_AttrDefinedOperator(const AttrDefinedOperator_t &x) {
        s.append("{");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"node\": \"AttrDefinedOperator\"");
        s.append(",\n" + indtd);
        s.append("\"fields\": {");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"op_name\": ");
        s.append("\"" + str_escape_c(x.m_op_name) + "\"");
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        append_location(s, x.base.base.loc.first, x.base.base.loc.last);
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        if ((bool&)x) { } // Suppress unused warning
    }
    void visit_simple_attributeType(const simple_attributeType &x) {
        switch (x) {
            case (simple_attributeType::AttrAbstract) : {
                s.append("\"AttrAbstract\"");
             break; }
            case (simple_attributeType::AttrAllocatable) : {
                s.append("\"AttrAllocatable\"");
             break; }
            case (simple_attributeType::AttrAsynchronous) : {
                s.append("\"AttrAsynchronous\"");
             break; }
            case (simple_attributeType::AttrCommon) : {
                s.append("\"AttrCommon\"");
             break; }
            case (simple_attributeType::AttrContiguous) : {
                s.append("\"AttrContiguous\"");
             break; }
            case (simple_attributeType::AttrDeferred) : {
                s.append("\"AttrDeferred\"");
             break; }
            case (simple_attributeType::AttrElemental) : {
                s.append("\"AttrElemental\"");
             break; }
            case (simple_attributeType::AttrEnumerator) : {
                s.append("\"AttrEnumerator\"");
             break; }
            case (simple_attributeType::AttrExternal) : {
                s.append("\"AttrExternal\"");
             break; }
            case (simple_attributeType::AttrImpure) : {
                s.append("\"AttrImpure\"");
             break; }
            case (simple_attributeType::AttrIntrinsic) : {
                s.append("\"AttrIntrinsic\"");
             break; }
            case (simple_attributeType::AttrKind) : {
                s.append("\"AttrKind\"");
             break; }
            case (simple_attributeType::AttrLen) : {
                s.append("\"AttrLen\"");
             break; }
            case (simple_attributeType::AttrModule) : {
                s.append("\"AttrModule\"");
             break; }
            case (simple_attributeType::AttrNoPass) : {
                s.append("\"AttrNoPass\"");
             break; }
            case (simple_attributeType::AttrNonDeferred) : {
                s.append("\"AttrNonDeferred\"");
             break; }
            case (simple_attributeType::AttrNon_Intrinsic) : {
                s.append("\"AttrNon_Intrinsic\"");
             break; }
            case (simple_attributeType::AttrOptional) : {
                s.append("\"AttrOptional\"");
             break; }
            case (simple_attributeType::AttrParameter) : {
                s.append("\"AttrParameter\"");
             break; }
            case (simple_attributeType::AttrPointer) : {
                s.append("\"AttrPointer\"");
             break; }
            case (simple_attributeType::AttrPrivate) : {
                s.append("\"AttrPrivate\"");
             break; }
            case (simple_attributeType::AttrProtected) : {
                s.append("\"AttrProtected\"");
             break; }
            case (simple_attributeType::AttrPublic) : {
                s.append("\"AttrPublic\"");
             break; }
            case (simple_attributeType::AttrPure) : {
                s.append("\"AttrPure\"");
             break; }
            case (simple_attributeType::AttrRecursive) : {
                s.append("\"AttrRecursive\"");
             break; }
            case (simple_attributeType::AttrSave) : {
                s.append("\"AttrSave\"");
             break; }
            case (simple_attributeType::AttrSequence) : {
                s.append("\"AttrSequence\"");
             break; }
            case (simple_attributeType::AttrTarget) : {
                s.append("\"AttrTarget\"");
             break; }
            case (simple_attributeType::AttrValue) : {
                s.append("\"AttrValue\"");
             break; }
            case (simple_attributeType::AttrVolatile) : {
                s.append("\"AttrVolatile\"");
             break; }
        }
    }
    void visit_attr_intentType(const attr_intentType &x) {
        switch (x) {
            case (attr_intentType::In) : {
                s.append("\"In\"");
             break; }
            case (attr_intentType::Out) : {
                s.append("\"Out\"");
             break; }
            case (attr_intentType::InOut) : {
                s.append("\"InOut\"");
             break; }
        }
    }
    void visit_decl_typeType(const decl_typeType &x) {
        switch (x) {
            case (decl_typeType::TypeClass) : {
                s.append("\"TypeClass\"");
             break; }
            case (decl_typeType::TypeCharacter) : {
                s.append("\"TypeCharacter\"");
             break; }
            case (decl_typeType::TypeComplex) : {
                s.append("\"TypeComplex\"");
             break; }
            case (decl_typeType::TypeDoublePrecision) : {
                s.append("\"TypeDoublePrecision\"");
             break; }
            case (decl_typeType::TypeDoubleComplex) : {
                s.append("\"TypeDoubleComplex\"");
             break; }
            case (decl_typeType::TypeInteger) : {
                s.append("\"TypeInteger\"");
             break; }
            case (decl_typeType::TypeLogical) : {
                s.append("\"TypeLogical\"");
             break; }
            case (decl_typeType::TypeProcedure) : {
                s.append("\"TypeProcedure\"");
             break; }
            case (decl_typeType::TypeReal) : {
                s.append("\"TypeReal\"");
             break; }
            case (decl_typeType::TypeType) : {
                s.append("\"TypeType\"");
             break; }
        }
    }
    void visit_AttrStat(const AttrStat_t &x) {
        s.append("{");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"node\": \"AttrStat\"");
        s.append(",\n" + indtd);
        s.append("\"fields\": {");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"variable\": ");
        s.append("\"" + std::string(x.m_variable) + "\"");
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        append_location(s, x.base.base.loc.first, x.base.base.loc.last);
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        if ((bool&)x) { } // Suppress unused warning
    }
    void visit_AttrErrmsg(const AttrErrmsg_t &x) {
        s.append("{");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"node\": \"AttrErrmsg\"");
        s.append(",\n" + indtd);
        s.append("\"fields\": {");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"variable\": ");
        s.append("\"" + std::string(x.m_variable) + "\"");
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        append_location(s, x.base.base.loc.first, x.base.base.loc.last);
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        if ((bool&)x) { } // Suppress unused warning
    }
    void visit_AttrNewIndex(const AttrNewIndex_t &x) {
        s.append("{");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"node\": \"AttrNewIndex\"");
        s.append(",\n" + indtd);
        s.append("\"fields\": {");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"value\": ");
        self().visit_expr(*x.m_value);
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        append_location(s, x.base.base.loc.first, x.base.base.loc.last);
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        if ((bool&)x) { } // Suppress unused warning
    }
    void visit_AttrEventWaitKwArg(const AttrEventWaitKwArg_t &x) {
        s.append("{");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"node\": \"AttrEventWaitKwArg\"");
        s.append(",\n" + indtd);
        s.append("\"fields\": {");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"id\": ");
        s.append("\"" + std::string(x.m_id) + "\"");
        s.append(",\n" + indtd);
        s.append("\"value\": ");
        self().visit_expr(*x.m_value);
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        append_location(s, x.base.base.loc.first, x.base.base.loc.last);
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        if ((bool&)x) { } // Suppress unused warning
    }
    void visit_CoarrayAssociation(const CoarrayAssociation_t &x) {
        s.append("{");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"node\": \"CoarrayAssociation\"");
        s.append(",\n" + indtd);
        s.append("\"fields\": {");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"coarray\": ");
        self().visit_expr(*x.m_coarray);
        s.append(",\n" + indtd);
        s.append("\"selector\": ");
        self().visit_expr(*x.m_selector);
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        append_location(s, x.base.base.loc.first, x.base.base.loc.last);
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        if ((bool&)x) { } // Suppress unused warning
    }
    void visit_var_sym(const var_sym_t &x) {
        s.append("{");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"node\": \"var_sym\"");
        s.append(",\n" + indtd);
        s.append("\"fields\": {");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"name\": ");
        if (x.m_name) {
            s.append("\"" + std::string(x.m_name) + "\"");
        } else {
            s.append("[]");
        }
        s.append(",\n" + indtd);
        s.append("\"dim\": ");
        s.append("[");
        if (x.n_dim > 0) {
            inc_indent(); s.append("\n" + indtd);
            for (size_t i=0; i<x.n_dim; i++) {
                self().visit_dimension(x.m_dim[i]);
                if (i < x.n_dim-1) {
                    s.append(",\n" + indtd);
                };
            }
            dec_indent(); s.append("\n" + indtd);
        }
        s.append("]");
        s.append(",\n" + indtd);
        s.append("\"codim\": ");
        s.append("[");
        if (x.n_codim > 0) {
            inc_indent(); s.append("\n" + indtd);
            for (size_t i=0; i<x.n_codim; i++) {
                self().visit_codimension(x.m_codim[i]);
                if (i < x.n_codim-1) {
                    s.append(",\n" + indtd);
                };
            }
            dec_indent(); s.append("\n" + indtd);
        }
        s.append("]");
        s.append(",\n" + indtd);
        s.append("\"length\": ");
        if (x.m_length) {
            self().visit_expr(*x.m_length);
        } else {
            s.append("[]");
        }
        s.append(",\n" + indtd);
        s.append("\"initializer\": ");
        if (x.m_initializer) {
            self().visit_expr(*x.m_initializer);
        } else {
            s.append("[]");
        }
        s.append(",\n" + indtd);
        s.append("\"sym\": ");
        visit_symbolType(x.m_sym);
        s.append(",\n" + indtd);
        s.append("\"spec\": ");
        if (x.m_spec) {
            self().visit_decl_attribute(*x.m_spec);
        } else {
            s.append("[]");
        }
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        append_location(s, x.loc.first, x.loc.last);
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        if ((bool&)x) { } // Suppress unused warning
    }
    void visit_kind_item(const kind_item_t &x) {
        s.append("{");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"node\": \"kind_item\"");
        s.append(",\n" + indtd);
        s.append("\"fields\": {");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"id\": ");
        if (x.m_id) {
            s.append("\"" + std::string(x.m_id) + "\"");
        } else {
            s.append("[]");
        }
        s.append(",\n" + indtd);
        s.append("\"value\": ");
        if (x.m_value) {
            self().visit_expr(*x.m_value);
        } else {
            s.append("[]");
        }
        s.append(",\n" + indtd);
        s.append("\"type\": ");
        visit_kind_item_typeType(x.m_type);
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        append_location(s, x.loc.first, x.loc.last);
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        if ((bool&)x) { } // Suppress unused warning
    }
    void visit_kind_item_typeType(const kind_item_typeType &x) {
        switch (x) {
            case (kind_item_typeType::Star) : {
                s.append("\"Star\"");
             break; }
            case (kind_item_typeType::Colon) : {
                s.append("\"Colon\"");
             break; }
            case (kind_item_typeType::Value) : {
                s.append("\"Value\"");
             break; }
        }
    }
    void visit_dimension(const dimension_t &x) {
        s.append("{");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"node\": \"dimension\"");
        s.append(",\n" + indtd);
        s.append("\"fields\": {");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"start\": ");
        if (x.m_start) {
            self().visit_expr(*x.m_start);
        } else {
            s.append("[]");
        }
        s.append(",\n" + indtd);
        s.append("\"end\": ");
        if (x.m_end) {
            self().visit_expr(*x.m_end);
        } else {
            s.append("[]");
        }
        s.append(",\n" + indtd);
        s.append("\"end_star\": ");
        visit_dimension_typeType(x.m_end_star);
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        append_location(s, x.loc.first, x.loc.last);
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        if ((bool&)x) { } // Suppress unused warning
    }
    void visit_dimension_typeType(const dimension_typeType &x) {
        switch (x) {
            case (dimension_typeType::DimensionExpr) : {
                s.append("\"DimensionExpr\"");
             break; }
            case (dimension_typeType::DimensionStar) : {
                s.append("\"DimensionStar\"");
             break; }
            case (dimension_typeType::AssumedRank) : {
                s.append("\"AssumedRank\"");
             break; }
        }
    }
    void visit_codimension(const codimension_t &x) {
        s.append("{");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"node\": \"codimension\"");
        s.append(",\n" + indtd);
        s.append("\"fields\": {");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"start\": ");
        if (x.m_start) {
            self().visit_expr(*x.m_start);
        } else {
            s.append("[]");
        }
        s.append(",\n" + indtd);
        s.append("\"end\": ");
        if (x.m_end) {
            self().visit_expr(*x.m_end);
        } else {
            s.append("[]");
        }
        s.append(",\n" + indtd);
        s.append("\"end_star\": ");
        visit_codimension_typeType(x.m_end_star);
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        append_location(s, x.loc.first, x.loc.last);
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        if ((bool&)x) { } // Suppress unused warning
    }
    void visit_codimension_typeType(const codimension_typeType &x) {
        switch (x) {
            case (codimension_typeType::CodimensionExpr) : {
                s.append("\"CodimensionExpr\"");
             break; }
            case (codimension_typeType::CodimensionStar) : {
                s.append("\"CodimensionStar\"");
             break; }
        }
    }
    void visit_symbolType(const symbolType &x) {
        switch (x) {
            case (symbolType::None) : {
                s.append("\"None\"");
             break; }
            case (symbolType::Arrow) : {
                s.append("\"Arrow\"");
             break; }
            case (symbolType::Equal) : {
                s.append("\"Equal\"");
             break; }
            case (symbolType::Asterisk) : {
                s.append("\"Asterisk\"");
             break; }
            case (symbolType::DoubleAsterisk) : {
                s.append("\"DoubleAsterisk\"");
             break; }
            case (symbolType::Slash) : {
                s.append("\"Slash\"");
             break; }
        }
    }
    void visit_equi(const equi_t &x) {
        s.append("{");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"node\": \"equi\"");
        s.append(",\n" + indtd);
        s.append("\"fields\": {");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"set_list\": ");
        s.append("[");
        if (x.n_set_list > 0) {
            inc_indent(); s.append("\n" + indtd);
            for (size_t i=0; i<x.n_set_list; i++) {
                self().visit_expr(*x.m_set_list[i]);
                if (i < x.n_set_list-1) {
                    s.append(",\n" + indtd);
                };
            }
            dec_indent(); s.append("\n" + indtd);
        }
        s.append("]");
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        append_location(s, x.loc.first, x.loc.last);
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        if ((bool&)x) { } // Suppress unused warning
    }
    void visit_kw_argstar(const kw_argstar_t &x) {
        s.append("{");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"node\": \"kw_argstar\"");
        s.append(",\n" + indtd);
        s.append("\"fields\": {");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"arg\": ");
        s.append("\"" + std::string(x.m_arg) + "\"");
        s.append(",\n" + indtd);
        s.append("\"value\": ");
        if (x.m_value) {
            self().visit_expr(*x.m_value);
        } else {
            s.append("[]");
        }
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        append_location(s, x.loc.first, x.loc.last);
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        if ((bool&)x) { } // Suppress unused warning
    }
    void visit_argstar(const argstar_t &x) {
        s.append("{");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"node\": \"argstar\"");
        s.append(",\n" + indtd);
        s.append("\"fields\": {");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"value\": ");
        if (x.m_value) {
            self().visit_expr(*x.m_value);
        } else {
            s.append("[]");
        }
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        append_location(s, x.loc.first, x.loc.last);
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        if ((bool&)x) { } // Suppress unused warning
    }
    void visit_arg(const arg_t &x) {
        s.append("{");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"node\": \"arg\"");
        s.append(",\n" + indtd);
        s.append("\"fields\": {");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"arg\": ");
        if (x.m_arg) {
            s.append("\"" + std::string(x.m_arg) + "\"");
        } else {
            s.append("[]");
        }
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        append_location(s, x.loc.first, x.loc.last);
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        if ((bool&)x) { } // Suppress unused warning
    }
    void visit_fnarg(const fnarg_t &x) {
        s.append("{");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"node\": \"fnarg\"");
        s.append(",\n" + indtd);
        s.append("\"fields\": {");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"start\": ");
        if (x.m_start) {
            self().visit_expr(*x.m_start);
        } else {
            s.append("[]");
        }
        s.append(",\n" + indtd);
        s.append("\"end\": ");
        if (x.m_end) {
            self().visit_expr(*x.m_end);
        } else {
            s.append("[]");
        }
        s.append(",\n" + indtd);
        s.append("\"step\": ");
        if (x.m_step) {
            self().visit_expr(*x.m_step);
        } else {
            s.append("[]");
        }
        s.append(",\n" + indtd);
        s.append("\"label\": ");
        s.append(std::to_string(x.m_label));
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        append_location(s, x.loc.first, x.loc.last);
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        if ((bool&)x) { } // Suppress unused warning
    }
    void visit_coarrayarg(const coarrayarg_t &x) {
        s.append("{");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"node\": \"coarrayarg\"");
        s.append(",\n" + indtd);
        s.append("\"fields\": {");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"start\": ");
        if (x.m_start) {
            self().visit_expr(*x.m_start);
        } else {
            s.append("[]");
        }
        s.append(",\n" + indtd);
        s.append("\"end\": ");
        if (x.m_end) {
            self().visit_expr(*x.m_end);
        } else {
            s.append("[]");
        }
        s.append(",\n" + indtd);
        s.append("\"step\": ");
        if (x.m_step) {
            self().visit_expr(*x.m_step);
        } else {
            s.append("[]");
        }
        s.append(",\n" + indtd);
        s.append("\"star\": ");
        visit_codimension_typeType(x.m_star);
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        append_location(s, x.loc.first, x.loc.last);
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        if ((bool&)x) { } // Suppress unused warning
    }
    void visit_keyword(const keyword_t &x) {
        s.append("{");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"node\": \"keyword\"");
        s.append(",\n" + indtd);
        s.append("\"fields\": {");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"arg\": ");
        s.append("\"" + std::string(x.m_arg) + "\"");
        s.append(",\n" + indtd);
        s.append("\"value\": ");
        self().visit_expr(*x.m_value);
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        append_location(s, x.loc.first, x.loc.last);
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        if ((bool&)x) { } // Suppress unused warning
    }
    void visit_struct_member(const struct_member_t &x) {
        s.append("{");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"node\": \"struct_member\"");
        s.append(",\n" + indtd);
        s.append("\"fields\": {");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"name\": ");
        s.append("\"" + std::string(x.m_name) + "\"");
        s.append(",\n" + indtd);
        s.append("\"args\": ");
        s.append("[");
        if (x.n_args > 0) {
            inc_indent(); s.append("\n" + indtd);
            for (size_t i=0; i<x.n_args; i++) {
                self().visit_fnarg(x.m_args[i]);
                if (i < x.n_args-1) {
                    s.append(",\n" + indtd);
                };
            }
            dec_indent(); s.append("\n" + indtd);
        }
        s.append("]");
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        append_location(s, x.loc.first, x.loc.last);
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        if ((bool&)x) { } // Suppress unused warning
    }
    void visit_Bind(const Bind_t &x) {
        s.append("{");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"node\": \"Bind\"");
        s.append(",\n" + indtd);
        s.append("\"fields\": {");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"args\": ");
        s.append("[");
        if (x.n_args > 0) {
            inc_indent(); s.append("\n" + indtd);
            for (size_t i=0; i<x.n_args; i++) {
                self().visit_expr(*x.m_args[i]);
                if (i < x.n_args-1) {
                    s.append(",\n" + indtd);
                };
            }
            dec_indent(); s.append("\n" + indtd);
        }
        s.append("]");
        s.append(",\n" + indtd);
        s.append("\"kwargs\": ");
        s.append("[");
        if (x.n_kwargs > 0) {
            inc_indent(); s.append("\n" + indtd);
            for (size_t i=0; i<x.n_kwargs; i++) {
                self().visit_keyword(x.m_kwargs[i]);
                if (i < x.n_kwargs-1) {
                    s.append(",\n" + indtd);
                };
            }
            dec_indent(); s.append("\n" + indtd);
        }
        s.append("]");
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        append_location(s, x.base.base.loc.first, x.base.base.loc.last);
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        if ((bool&)x) { } // Suppress unused warning
    }
    void visit_ArrayIndex(const ArrayIndex_t &x) {
        s.append("{");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"node\": \"ArrayIndex\"");
        s.append(",\n" + indtd);
        s.append("\"fields\": {");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"left\": ");
        if (x.m_left) {
            self().visit_expr(*x.m_left);
        } else {
            s.append("[]");
        }
        s.append(",\n" + indtd);
        s.append("\"right\": ");
        if (x.m_right) {
            self().visit_expr(*x.m_right);
        } else {
            s.append("[]");
        }
        s.append(",\n" + indtd);
        s.append("\"step\": ");
        if (x.m_step) {
            self().visit_expr(*x.m_step);
        } else {
            s.append("[]");
        }
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        append_location(s, x.base.base.loc.first, x.base.base.loc.last);
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        if ((bool&)x) { } // Suppress unused warning
    }
    void visit_CaseStmt(const CaseStmt_t &x) {
        s.append("{");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"node\": \"CaseStmt\"");
        s.append(",\n" + indtd);
        s.append("\"fields\": {");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"test\": ");
        s.append("[");
        if (x.n_test > 0) {
            inc_indent(); s.append("\n" + indtd);
            for (size_t i=0; i<x.n_test; i++) {
                self().visit_case_cond(*x.m_test[i]);
                if (i < x.n_test-1) {
                    s.append(",\n" + indtd);
                };
            }
            dec_indent(); s.append("\n" + indtd);
        }
        s.append("]");
        s.append(",\n" + indtd);
        s.append("\"trivia\": ");
        if (x.m_trivia) {
            self().visit_trivia(*x.m_trivia);
        } else {
            s.append("[]");
        }
        s.append(",\n" + indtd);
        s.append("\"body\": ");
        s.append("[");
        if (x.n_body > 0) {
            inc_indent(); s.append("\n" + indtd);
            for (size_t i=0; i<x.n_body; i++) {
                self().visit_stmt(*x.m_body[i]);
                if (i < x.n_body-1) {
                    s.append(",\n" + indtd);
                };
            }
            dec_indent(); s.append("\n" + indtd);
        }
        s.append("]");
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        append_location(s, x.base.base.loc.first, x.base.base.loc.last);
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        if ((bool&)x) { } // Suppress unused warning
    }
    void visit_CaseStmt_Default(const CaseStmt_Default_t &x) {
        s.append("{");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"node\": \"CaseStmt_Default\"");
        s.append(",\n" + indtd);
        s.append("\"fields\": {");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"trivia\": ");
        if (x.m_trivia) {
            self().visit_trivia(*x.m_trivia);
        } else {
            s.append("[]");
        }
        s.append(",\n" + indtd);
        s.append("\"body\": ");
        s.append("[");
        if (x.n_body > 0) {
            inc_indent(); s.append("\n" + indtd);
            for (size_t i=0; i<x.n_body; i++) {
                self().visit_stmt(*x.m_body[i]);
                if (i < x.n_body-1) {
                    s.append(",\n" + indtd);
                };
            }
            dec_indent(); s.append("\n" + indtd);
        }
        s.append("]");
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        append_location(s, x.base.base.loc.first, x.base.base.loc.last);
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        if ((bool&)x) { } // Suppress unused warning
    }
    void visit_CaseCondExpr(const CaseCondExpr_t &x) {
        s.append("{");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"node\": \"CaseCondExpr\"");
        s.append(",\n" + indtd);
        s.append("\"fields\": {");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"cond\": ");
        self().visit_expr(*x.m_cond);
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        append_location(s, x.base.base.loc.first, x.base.base.loc.last);
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        if ((bool&)x) { } // Suppress unused warning
    }
    void visit_CaseCondRange(const CaseCondRange_t &x) {
        s.append("{");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"node\": \"CaseCondRange\"");
        s.append(",\n" + indtd);
        s.append("\"fields\": {");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"start\": ");
        if (x.m_start) {
            self().visit_expr(*x.m_start);
        } else {
            s.append("[]");
        }
        s.append(",\n" + indtd);
        s.append("\"end\": ");
        if (x.m_end) {
            self().visit_expr(*x.m_end);
        } else {
            s.append("[]");
        }
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        append_location(s, x.base.base.loc.first, x.base.base.loc.last);
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        if ((bool&)x) { } // Suppress unused warning
    }
    void visit_RankExpr(const RankExpr_t &x) {
        s.append("{");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"node\": \"RankExpr\"");
        s.append(",\n" + indtd);
        s.append("\"fields\": {");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"value\": ");
        self().visit_expr(*x.m_value);
        s.append(",\n" + indtd);
        s.append("\"trivia\": ");
        if (x.m_trivia) {
            self().visit_trivia(*x.m_trivia);
        } else {
            s.append("[]");
        }
        s.append(",\n" + indtd);
        s.append("\"body\": ");
        s.append("[");
        if (x.n_body > 0) {
            inc_indent(); s.append("\n" + indtd);
            for (size_t i=0; i<x.n_body; i++) {
                self().visit_stmt(*x.m_body[i]);
                if (i < x.n_body-1) {
                    s.append(",\n" + indtd);
                };
            }
            dec_indent(); s.append("\n" + indtd);
        }
        s.append("]");
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        append_location(s, x.base.base.loc.first, x.base.base.loc.last);
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        if ((bool&)x) { } // Suppress unused warning
    }
    void visit_RankStar(const RankStar_t &x) {
        s.append("{");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"node\": \"RankStar\"");
        s.append(",\n" + indtd);
        s.append("\"fields\": {");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"trivia\": ");
        if (x.m_trivia) {
            self().visit_trivia(*x.m_trivia);
        } else {
            s.append("[]");
        }
        s.append(",\n" + indtd);
        s.append("\"body\": ");
        s.append("[");
        if (x.n_body > 0) {
            inc_indent(); s.append("\n" + indtd);
            for (size_t i=0; i<x.n_body; i++) {
                self().visit_stmt(*x.m_body[i]);
                if (i < x.n_body-1) {
                    s.append(",\n" + indtd);
                };
            }
            dec_indent(); s.append("\n" + indtd);
        }
        s.append("]");
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        append_location(s, x.base.base.loc.first, x.base.base.loc.last);
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        if ((bool&)x) { } // Suppress unused warning
    }
    void visit_RankDefault(const RankDefault_t &x) {
        s.append("{");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"node\": \"RankDefault\"");
        s.append(",\n" + indtd);
        s.append("\"fields\": {");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"trivia\": ");
        if (x.m_trivia) {
            self().visit_trivia(*x.m_trivia);
        } else {
            s.append("[]");
        }
        s.append(",\n" + indtd);
        s.append("\"body\": ");
        s.append("[");
        if (x.n_body > 0) {
            inc_indent(); s.append("\n" + indtd);
            for (size_t i=0; i<x.n_body; i++) {
                self().visit_stmt(*x.m_body[i]);
                if (i < x.n_body-1) {
                    s.append(",\n" + indtd);
                };
            }
            dec_indent(); s.append("\n" + indtd);
        }
        s.append("]");
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        append_location(s, x.base.base.loc.first, x.base.base.loc.last);
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        if ((bool&)x) { } // Suppress unused warning
    }
    void visit_TypeStmtName(const TypeStmtName_t &x) {
        s.append("{");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"node\": \"TypeStmtName\"");
        s.append(",\n" + indtd);
        s.append("\"fields\": {");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"name\": ");
        if (x.m_name) {
            s.append("\"" + std::string(x.m_name) + "\"");
        } else {
            s.append("[]");
        }
        s.append(",\n" + indtd);
        s.append("\"trivia\": ");
        if (x.m_trivia) {
            self().visit_trivia(*x.m_trivia);
        } else {
            s.append("[]");
        }
        s.append(",\n" + indtd);
        s.append("\"body\": ");
        s.append("[");
        if (x.n_body > 0) {
            inc_indent(); s.append("\n" + indtd);
            for (size_t i=0; i<x.n_body; i++) {
                self().visit_stmt(*x.m_body[i]);
                if (i < x.n_body-1) {
                    s.append(",\n" + indtd);
                };
            }
            dec_indent(); s.append("\n" + indtd);
        }
        s.append("]");
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        append_location(s, x.base.base.loc.first, x.base.base.loc.last);
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        if ((bool&)x) { } // Suppress unused warning
    }
    void visit_TypeStmtType(const TypeStmtType_t &x) {
        s.append("{");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"node\": \"TypeStmtType\"");
        s.append(",\n" + indtd);
        s.append("\"fields\": {");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"vartype\": ");
        if (x.m_vartype) {
            self().visit_decl_attribute(*x.m_vartype);
        } else {
            s.append("[]");
        }
        s.append(",\n" + indtd);
        s.append("\"trivia\": ");
        if (x.m_trivia) {
            self().visit_trivia(*x.m_trivia);
        } else {
            s.append("[]");
        }
        s.append(",\n" + indtd);
        s.append("\"body\": ");
        s.append("[");
        if (x.n_body > 0) {
            inc_indent(); s.append("\n" + indtd);
            for (size_t i=0; i<x.n_body; i++) {
                self().visit_stmt(*x.m_body[i]);
                if (i < x.n_body-1) {
                    s.append(",\n" + indtd);
                };
            }
            dec_indent(); s.append("\n" + indtd);
        }
        s.append("]");
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        append_location(s, x.base.base.loc.first, x.base.base.loc.last);
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        if ((bool&)x) { } // Suppress unused warning
    }
    void visit_ClassStmt(const ClassStmt_t &x) {
        s.append("{");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"node\": \"ClassStmt\"");
        s.append(",\n" + indtd);
        s.append("\"fields\": {");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"id\": ");
        if (x.m_id) {
            s.append("\"" + std::string(x.m_id) + "\"");
        } else {
            s.append("[]");
        }
        s.append(",\n" + indtd);
        s.append("\"trivia\": ");
        if (x.m_trivia) {
            self().visit_trivia(*x.m_trivia);
        } else {
            s.append("[]");
        }
        s.append(",\n" + indtd);
        s.append("\"body\": ");
        s.append("[");
        if (x.n_body > 0) {
            inc_indent(); s.append("\n" + indtd);
            for (size_t i=0; i<x.n_body; i++) {
                self().visit_stmt(*x.m_body[i]);
                if (i < x.n_body-1) {
                    s.append(",\n" + indtd);
                };
            }
            dec_indent(); s.append("\n" + indtd);
        }
        s.append("]");
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        append_location(s, x.base.base.loc.first, x.base.base.loc.last);
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        if ((bool&)x) { } // Suppress unused warning
    }
    void visit_ClassDefault(const ClassDefault_t &x) {
        s.append("{");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"node\": \"ClassDefault\"");
        s.append(",\n" + indtd);
        s.append("\"fields\": {");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"trivia\": ");
        if (x.m_trivia) {
            self().visit_trivia(*x.m_trivia);
        } else {
            s.append("[]");
        }
        s.append(",\n" + indtd);
        s.append("\"body\": ");
        s.append("[");
        if (x.n_body > 0) {
            inc_indent(); s.append("\n" + indtd);
            for (size_t i=0; i<x.n_body; i++) {
                self().visit_stmt(*x.m_body[i]);
                if (i < x.n_body-1) {
                    s.append(",\n" + indtd);
                };
            }
            dec_indent(); s.append("\n" + indtd);
        }
        s.append("]");
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        append_location(s, x.base.base.loc.first, x.base.base.loc.last);
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        if ((bool&)x) { } // Suppress unused warning
    }
    void visit_UseSymbol(const UseSymbol_t &x) {
        s.append("{");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"node\": \"UseSymbol\"");
        s.append(",\n" + indtd);
        s.append("\"fields\": {");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"remote_sym\": ");
        s.append("\"" + std::string(x.m_remote_sym) + "\"");
        s.append(",\n" + indtd);
        s.append("\"local_rename\": ");
        if (x.m_local_rename) {
            s.append("\"" + std::string(x.m_local_rename) + "\"");
        } else {
            s.append("[]");
        }
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        append_location(s, x.base.base.loc.first, x.base.base.loc.last);
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        if ((bool&)x) { } // Suppress unused warning
    }
    void visit_UseAssignment(const UseAssignment_t &x) {
        s.append("{");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"node\": \"UseAssignment\"");
        s.append(",\n" + indtd);
        s.append("\"fields\": {");
        s.append("}");
        append_location(s, x.base.base.loc.first, x.base.base.loc.last);
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        if ((bool&)x) { } // Suppress unused warning
    }
    void visit_IntrinsicOperator(const IntrinsicOperator_t &x) {
        s.append("{");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"node\": \"IntrinsicOperator\"");
        s.append(",\n" + indtd);
        s.append("\"fields\": {");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"op\": ");
        visit_intrinsicopType(x.m_op);
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        append_location(s, x.base.base.loc.first, x.base.base.loc.last);
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        if ((bool&)x) { } // Suppress unused warning
    }
    void visit_DefinedOperator(const DefinedOperator_t &x) {
        s.append("{");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"node\": \"DefinedOperator\"");
        s.append(",\n" + indtd);
        s.append("\"fields\": {");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"opName\": ");
        s.append("\"" + str_escape_c(x.m_opName) + "\"");
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        append_location(s, x.base.base.loc.first, x.base.base.loc.last);
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        if ((bool&)x) { } // Suppress unused warning
    }
    void visit_RenameOperator(const RenameOperator_t &x) {
        s.append("{");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"node\": \"RenameOperator\"");
        s.append(",\n" + indtd);
        s.append("\"fields\": {");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"local_defop\": ");
        s.append("\"" + str_escape_c(x.m_local_defop) + "\"");
        s.append(",\n" + indtd);
        s.append("\"use_defop\": ");
        s.append("\"" + str_escape_c(x.m_use_defop) + "\"");
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        append_location(s, x.base.base.loc.first, x.base.base.loc.last);
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        if ((bool&)x) { } // Suppress unused warning
    }
    void visit_UseWrite(const UseWrite_t &x) {
        s.append("{");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"node\": \"UseWrite\"");
        s.append(",\n" + indtd);
        s.append("\"fields\": {");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"id\": ");
        s.append("\"" + std::string(x.m_id) + "\"");
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        append_location(s, x.base.base.loc.first, x.base.base.loc.last);
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        if ((bool&)x) { } // Suppress unused warning
    }
    void visit_UseRead(const UseRead_t &x) {
        s.append("{");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"node\": \"UseRead\"");
        s.append(",\n" + indtd);
        s.append("\"fields\": {");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"id\": ");
        s.append("\"" + std::string(x.m_id) + "\"");
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        append_location(s, x.base.base.loc.first, x.base.base.loc.last);
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        if ((bool&)x) { } // Suppress unused warning
    }
    void visit_ConcurrentControl(const ConcurrentControl_t &x) {
        s.append("{");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"node\": \"ConcurrentControl\"");
        s.append(",\n" + indtd);
        s.append("\"fields\": {");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"var\": ");
        if (x.m_var) {
            s.append("\"" + std::string(x.m_var) + "\"");
        } else {
            s.append("[]");
        }
        s.append(",\n" + indtd);
        s.append("\"start\": ");
        if (x.m_start) {
            self().visit_expr(*x.m_start);
        } else {
            s.append("[]");
        }
        s.append(",\n" + indtd);
        s.append("\"end\": ");
        if (x.m_end) {
            self().visit_expr(*x.m_end);
        } else {
            s.append("[]");
        }
        s.append(",\n" + indtd);
        s.append("\"increment\": ");
        if (x.m_increment) {
            self().visit_expr(*x.m_increment);
        } else {
            s.append("[]");
        }
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        append_location(s, x.base.base.loc.first, x.base.base.loc.last);
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        if ((bool&)x) { } // Suppress unused warning
    }
    void visit_ConcurrentLocal(const ConcurrentLocal_t &x) {
        s.append("{");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"node\": \"ConcurrentLocal\"");
        s.append(",\n" + indtd);
        s.append("\"fields\": {");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"vars\": ");
        s.append("[");
        if (x.n_vars > 0) {
            inc_indent(); s.append("\n" + indtd);
            for (size_t i=0; i<x.n_vars; i++) {
                s.append("\"" + std::string(x.m_vars[i]) + "\"");
                if (i < x.n_vars-1) {
                    s.append(",\n" + indtd);
                };
            }
            dec_indent(); s.append("\n" + indtd);
        }
        s.append("]");
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        append_location(s, x.base.base.loc.first, x.base.base.loc.last);
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        if ((bool&)x) { } // Suppress unused warning
    }
    void visit_ConcurrentLocalInit(const ConcurrentLocalInit_t &x) {
        s.append("{");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"node\": \"ConcurrentLocalInit\"");
        s.append(",\n" + indtd);
        s.append("\"fields\": {");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"vars\": ");
        s.append("[");
        if (x.n_vars > 0) {
            inc_indent(); s.append("\n" + indtd);
            for (size_t i=0; i<x.n_vars; i++) {
                s.append("\"" + std::string(x.m_vars[i]) + "\"");
                if (i < x.n_vars-1) {
                    s.append(",\n" + indtd);
             