;;; Lepton EDA Symbol Checker
;;; Scheme API
;;; Copyright (C) 2017-2020 Lepton EDA Contributors
;;;
;;; This program is free software; you can redistribute it and/or modify
;;; it under the terms of the GNU General Public License as published by
;;; the Free Software Foundation; either version 2 of the License, or
;;; (at your option) any later version.
;;;
;;; This program is distributed in the hope that it will be useful,
;;; but WITHOUT ANY WARRANTY; without even the implied warranty of
;;; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
;;; GNU General Public License for more details.
;;;
;;; You should have received a copy of the GNU General Public License
;;; along with this program; if not, write to the Free Software
;;; Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.

(define-module (symbol check line)
  #:use-module (lepton core gettext)
  #:use-module (lepton object)
  #:use-module (symbol blame)

  #:export (check-line-size
            check-line))

(define (check-line-size object)
  "Checks if line OBJECT (line, net, or bus) has zero length."
  (let ((start (line-start object))
        (end (line-end object)))
    (when (equal? start end)
      (blame-object object
                    'error
                    (format #f
                            (_ "Zero length ~A at ~A")
                            (object-type object)
                            start)))))

(define (check-line object)
  "Checks line OBJECT:
  * Checks if it has zero length."
  (check-line-size object))
