#include "lc_global.h"
#include <string.h>
#include "texfont.h"
#include "lc_context.h"

static const unsigned char TextureData[2048] =
{
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x30, 0x00, 0x00, 0x60, 0x00, 0xe0, 0x00, 0x18, 0x60, 0x66, 0xc0, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x30, 0x00, 0x00, 0x60, 0x00, 0x30, 0x00, 0x18, 0x60, 0x66, 0xc0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x30, 0x00, 0x00, 0x60, 0x00, 0x30, 0x00, 0x18, 0x00, 0x60, 0xc0, 0x00, 0x00, 0x00, 0x00,
	0xf8, 0xb1, 0x03, 0x0f, 0x6e, 0x78, 0xfc, 0xb8, 0xd9, 0x61, 0x66, 0xcc, 0xec, 0x1c, 0x3b, 0x00, 0x0c, 0x73, 0x86, 0x19, 0x73, 0xcc, 0x30, 0xcc, 0x39, 0x63, 0x66, 0xc6, 0x9c, 0x33, 0x67, 0x00,
	0x00, 0x33, 0xcc, 0x90, 0x61, 0x86, 0x31, 0x86, 0x19, 0x66, 0x66, 0xc3, 0x8c, 0x31, 0xc3, 0x00, 0xe0, 0x33, 0xcc, 0x80, 0x61, 0x86, 0x31, 0x86, 0x19, 0x66, 0xe6, 0xc1, 0x8c, 0x31, 0xc3, 0x00,
	0x38, 0x33, 0xcc, 0x80, 0x61, 0xfe, 0x31, 0x86, 0x19, 0x66, 0xe6, 0xc1, 0x8c, 0x31, 0xc3, 0x00, 0x0c, 0x33, 0xcc, 0x80, 0x61, 0x06, 0x30, 0x86, 0x19, 0x66, 0x66, 0xc3, 0x8c, 0x31, 0xc3, 0x00,
	0x0c, 0x33, 0xcc, 0x90, 0x61, 0x06, 0x30, 0x86, 0x19, 0x66, 0x66, 0xc6, 0x8c, 0x31, 0xc3, 0x00, 0x0c, 0x73, 0x86, 0x19, 0x73, 0x8c, 0x31, 0xcc, 0x19, 0x66, 0x66, 0xcc, 0x8c, 0x31, 0xc3, 0x00,
	0xf8, 0xb6, 0x03, 0x0f, 0x6e, 0xf8, 0x30, 0xb8, 0x19, 0x66, 0x66, 0xd8, 0x8c, 0x31, 0xc3, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x80, 0x01, 0x00, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x80, 0x01, 0x00, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xc6, 0x00, 0x00, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7c, 0x00, 0x00, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x36, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x63, 0x00, 0xf0, 0xb0, 0x03, 0x37, 0x3b, 0x9f, 0xdf, 0xb0, 0xc1, 0x03, 0xf0, 0xf0, 0x60, 0x3f, 0x63, 0x00,
	0x98, 0x71, 0x86, 0x39, 0x8f, 0x31, 0xc6, 0xb0, 0xc1, 0xc3, 0xf0, 0xf0, 0x60, 0x30, 0x63, 0x00, 0x0c, 0x33, 0xcc, 0x30, 0x87, 0x01, 0xc6, 0x30, 0x63, 0xc6, 0x98, 0x99, 0x31, 0x18, 0x63, 0x00,
	0x0c, 0x33, 0xcc, 0x30, 0x83, 0x03, 0xc6, 0x30, 0x63, 0xe6, 0x19, 0x8f, 0x31, 0x18, 0x63, 0x00, 0x0c, 0x33, 0xcc, 0x30, 0x03, 0x1f, 0xc6, 0x30, 0x63, 0xe6, 0x19, 0x86, 0x31, 0x0c, 0x63, 0x00,
	0x0c, 0x33, 0xcc, 0x30, 0x03, 0x38, 0xc6, 0x30, 0x36, 0x2c, 0x0d, 0x0f, 0x1b, 0x06, 0x63, 0x00, 0x0c, 0x33, 0xcc, 0x30, 0x03, 0x30, 0xc6, 0x30, 0x36, 0x3c, 0x8f, 0x19, 0x1b, 0x06, 0x63, 0x00,
	0x98, 0x71, 0x86, 0x39, 0x83, 0x31, 0x86, 0x39, 0x1c, 0x18, 0xc6, 0x30, 0x0e, 0x03, 0x36, 0x00, 0xf0, 0xb0, 0x03, 0x37, 0x03, 0x1f, 0x1c, 0x37, 0x1c, 0x18, 0xc6, 0x30, 0x0e, 0x3f, 0x1c, 0x00,
	0x00, 0x30, 0x00, 0x30, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x06, 0x00, 0x00, 0x00, 0x00, 0x30, 0x00, 0x30, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x06, 0x00, 0x00, 0x00,
	0x00, 0x30, 0x00, 0x30, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x03, 0x00, 0x00, 0x00, 0x00, 0x30, 0x00, 0x30, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x80, 0x01, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x60, 0xf0, 0xe1, 0x03, 0xc6, 0x1f, 0x1e, 0x7f, 0x7c, 0xf8, 0x00, 0x01, 0x7f, 0x80, 0x0f, 0x00,
	0x78, 0x18, 0x33, 0x06, 0xc6, 0x00, 0x03, 0x60, 0xc6, 0x8c, 0x81, 0x03, 0xc3, 0xc0, 0x18, 0x00, 0x60, 0x08, 0x13, 0x06, 0xc7, 0x80, 0x01, 0x60, 0xc6, 0x8c, 0x81, 0x03, 0x83, 0x61, 0x30, 0x00,
	0x60, 0x00, 0x03, 0x06, 0xc7, 0x80, 0x01, 0x30, 0xc6, 0x8c, 0xc1, 0x06, 0x83, 0x61, 0x30, 0x00, 0x60, 0x00, 0x03, 0x86, 0xc7, 0x8f, 0x01, 0x30, 0xc6, 0x8c, 0xc1, 0x06, 0xc3, 0x30, 0x00, 0x00,
	0x60, 0x80, 0xc1, 0xc3, 0xc6, 0x98, 0x1f, 0x18, 0x7c, 0x8c, 0x61, 0x0c, 0x7f, 0x30, 0x00, 0x00, 0x60, 0xc0, 0x00, 0xc6, 0x06, 0x98, 0x31, 0x18, 0xc6, 0xf8, 0x61, 0x0c, 0xc3, 0x30, 0x00, 0x00,
	0x60, 0x60, 0x00, 0x66, 0x06, 0x98, 0x31, 0x18, 0xc6, 0x80, 0x31, 0x18, 0x83, 0x31, 0x00, 0x00, 0x60, 0x30, 0x00, 0xe6, 0x0f, 0x98, 0x31, 0x0c, 0xc6, 0x80, 0xf1, 0x1f, 0x83, 0x61, 0x30, 0x00,
	0x60, 0x18, 0x10, 0x06, 0x46, 0x98, 0x31, 0x0c, 0xc6, 0x80, 0x19, 0x30, 0x83, 0x61, 0x30, 0x00, 0x60, 0x18, 0x30, 0x06, 0xc6, 0x98, 0x31, 0x0c, 0xc6, 0xc0, 0x18, 0x30, 0xc3, 0xc0, 0x18, 0x00,
	0x60, 0xf8, 0xe3, 0x03, 0x86, 0x0f, 0x1f, 0x0c, 0x7c, 0x78, 0x18, 0x30, 0x7f, 0x80, 0x0f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0xf8, 0x81, 0x7f, 0xfc, 0x83, 0x0f, 0x06, 0x63, 0xc0, 0x18, 0xc6, 0x00, 0x03, 0xc6, 0x60, 0x00, 0x18, 0x83, 0x01, 0x0c, 0xc0, 0x18, 0x06, 0x63, 0xc0, 0x18, 0xc3, 0x00, 0x03, 0xc6, 0x60, 0x00,
	0x18, 0x86, 0x01, 0x0c, 0x60, 0x30, 0x06, 0x63, 0xc0, 0x98, 0xc1, 0x00, 0x07, 0xc7, 0x61, 0x00, 0x18, 0x86, 0x01, 0x0c, 0x60, 0x30, 0x06, 0x63, 0xc0, 0xd8, 0xc0, 0x00, 0x07, 0xc7, 0x63, 0x00,
	0x18, 0x8c, 0x01, 0x0c, 0x30, 0x00, 0x06, 0x63, 0xc0, 0x78, 0xc0, 0x00, 0x8f, 0xc7, 0x67, 0x00, 0x18, 0x8c, 0x3f, 0xfc, 0x31, 0x00, 0xfe, 0x63, 0xc0, 0x38, 0xc0, 0x00, 0x8f, 0xc7, 0x66, 0x00,
	0x18, 0x8c, 0x01, 0x0c, 0x30, 0x3e, 0x06, 0x63, 0xc0, 0x78, 0xc0, 0x00, 0xdb, 0xc6, 0x6c, 0x00, 0x18, 0x8c, 0x01, 0x0c, 0x30, 0x30, 0x06, 0x63, 0xc0, 0xd8, 0xc0, 0x00, 0xdb, 0xc6, 0x7c, 0x00,
	0x18, 0x86, 0x01, 0x0c, 0x60, 0x30, 0x06, 0x63, 0xc6, 0x98, 0xc1, 0x00, 0x73, 0xc6, 0x78, 0x00, 0x18, 0x86, 0x01, 0x0c, 0x60, 0x38, 0x06, 0x63, 0xc6, 0x18, 0xc3, 0x00, 0x73, 0xc6, 0x70, 0x00,
	0x18, 0x83, 0x01, 0x0c, 0xc0, 0x38, 0x06, 0x63, 0x6c, 0x18, 0xc6, 0x00, 0x23, 0xc6, 0x60, 0x00, 0xf8, 0x81, 0x7f, 0x0c, 0x80, 0x2f, 0x06, 0x63, 0x38, 0x18, 0xcc, 0x3f, 0x23, 0xc6, 0x60, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xc0, 0x03, 0x7f, 0xc0, 0x03, 0x7f, 0xc0, 0xe3, 0x7f, 0x06, 0x33, 0xb0, 0x01, 0xd8, 0xc0, 0x00,
	0x60, 0x06, 0xc3, 0x60, 0x06, 0xc3, 0x60, 0x06, 0x06, 0x06, 0x33, 0xb0, 0x61, 0xd8, 0xc0, 0x00, 0x30, 0x0c, 0x83, 0x31, 0x0c, 0x83, 0x31, 0x0c, 0x06, 0x06, 0x63, 0x98, 0x61, 0x98, 0x61, 0x00,
	0x30, 0x0c, 0x83, 0x31, 0x0c, 0x83, 0x31, 0x00, 0x06, 0x06, 0x63, 0x18, 0x63, 0x0c, 0x33, 0x00, 0x18, 0x18, 0x83, 0x19, 0x18, 0x83, 0x61, 0x00, 0x06, 0x06, 0x63, 0x18, 0xf3, 0x0c, 0x1e, 0x00,
	0x18, 0x18, 0xc3, 0x18, 0x18, 0xc3, 0xc0, 0x03, 0x06, 0x06, 0xc3, 0x0c, 0xf3, 0x0c, 0x0c, 0x00, 0x18, 0x18, 0x7f, 0x18, 0x18, 0x7f, 0x00, 0x06, 0x06, 0x06, 0xc3, 0x0c, 0x96, 0x06, 0x0c, 0x00,
	0x18, 0x18, 0x03, 0x98, 0x19, 0xc3, 0x00, 0x0c, 0x06, 0x06, 0x83, 0x04, 0x9e, 0x07, 0x1e, 0x00, 0x30, 0x0c, 0x03, 0x30, 0x0f, 0x83, 0x01, 0x0c, 0x06, 0x06, 0x83, 0x07, 0x9e, 0x07, 0x33, 0x00,
	0x30, 0x0c, 0x03, 0x30, 0x0e, 0x83, 0x31, 0x0c, 0x06, 0x06, 0x83, 0x07, 0x0c, 0x83, 0x61, 0x00, 0x60, 0x06, 0x03, 0x60, 0x0e, 0x83, 0x61, 0x06, 0x06, 0x8c, 0x01, 0x03, 0x0c, 0xc3, 0xc0, 0x00,
	0xc0, 0x03, 0x03, 0xc0, 0x1b, 0x03, 0xc3, 0x03, 0x06, 0xf8, 0x00, 0x03, 0x0c, 0xc3, 0xc0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x0c, 0xec, 0x3f, 0x00, 0x03, 0x00, 0x00, 0x80, 0xf1, 0x80, 0x07, 0xf0, 0x03, 0x08, 0x1c, 0x18, 0x0c, 0x0c, 0x30, 0x00, 0x03, 0x00, 0x66, 0x80, 0x99, 0xc1, 0x0c, 0x1c, 0x0e, 0x3e, 0x36, 0x0c,
	0x18, 0x06, 0x18, 0x00, 0x03, 0x00, 0xc3, 0x80, 0x0d, 0x63, 0x18, 0x06, 0x18, 0x6b, 0x36, 0x06, 0x30, 0x03, 0x0c, 0x00, 0x33, 0x83, 0x81, 0x81, 0x01, 0x63, 0x18, 0xc6, 0x19, 0x6b, 0x36, 0x03,
	0x30, 0x03, 0x0c, 0x00, 0x33, 0xc3, 0x00, 0xc3, 0x00, 0x63, 0x18, 0x63, 0x33, 0x0b, 0x9c, 0x01, 0xe0, 0x01, 0x06, 0x00, 0x03, 0x60, 0x00, 0xc6, 0x80, 0x61, 0x18, 0x33, 0x33, 0x0b, 0xc0, 0x00,
	0xe0, 0x01, 0x03, 0x00, 0x03, 0x30, 0x00, 0xcc, 0xc0, 0x60, 0x18, 0x33, 0x33, 0x3e, 0x60, 0x00, 0xc0, 0x80, 0x01, 0x00, 0x03, 0x60, 0x00, 0xc6, 0x60, 0x30, 0x30, 0x33, 0x33, 0x68, 0x30, 0x07,
	0xc0, 0x80, 0x01, 0x00, 0x03, 0xc0, 0x00, 0x63, 0x60, 0x60, 0x18, 0x33, 0x1b, 0x68, 0x98, 0x0d, 0xc0, 0xc0, 0x00, 0x00, 0x00, 0x80, 0x81, 0x61, 0x00, 0x60, 0x18, 0xe6, 0x0e, 0x6b, 0x8c, 0x0d,
	0xc0, 0x60, 0x80, 0x19, 0x33, 0x03, 0xc3, 0x60, 0x60, 0x60, 0x18, 0x06, 0x00, 0x6b, 0x86, 0x0d, 0xc0, 0xe0, 0xbf, 0x19, 0x33, 0x03, 0x66, 0x60, 0x60, 0x60, 0x18, 0x1c, 0x00, 0x3e, 0x03, 0x07,
	0x00, 0x00, 0xc0, 0x00, 0x18, 0x00, 0x00, 0x00, 0x00, 0x60, 0x18, 0xf0, 0x03, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xc0, 0x0c, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x80, 0x07, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0xc0, 0x01, 0x00, 0x3c, 0x00, 0x00, 0x00, 0x00, 0xfc, 0x03, 0x6c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x60, 0x03, 0x00, 0x66, 0x00, 0x00, 0x00, 0x00, 0x0c, 0x03, 0x6c, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x60, 0x03, 0x00, 0x66, 0x00, 0x0c, 0x00, 0x00, 0x0c, 0x03, 0x6c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x60, 0x03, 0x33, 0xc3, 0x00, 0x0c, 0x00, 0x00, 0x0c, 0x03, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00,
	0xc0, 0x01, 0x33, 0xc3, 0x00, 0x0c, 0x7f, 0x00, 0x0c, 0x03, 0x36, 0x00, 0x00, 0x00, 0x00, 0x00, 0xc0, 0x01, 0x1e, 0xc3, 0x00, 0x0c, 0x00, 0x00, 0x0c, 0x03, 0x36, 0x00, 0x00, 0x00, 0x00, 0x00,
	0xe0, 0x81, 0x7f, 0xc3, 0x80, 0x7f, 0x00, 0x00, 0x0c, 0x03, 0x36, 0x00, 0x00, 0x00, 0x00, 0x00, 0x60, 0x1b, 0x1e, 0xc3, 0x3e, 0x0c, 0x7f, 0x00, 0x0c, 0x03, 0x36, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x30, 0x0f, 0x33, 0xc3, 0x00, 0x0c, 0x00, 0x00, 0x0c, 0x83, 0x7f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x30, 0x06, 0x33, 0xc3, 0x00, 0x0c, 0x00, 0x00, 0x0c, 0x03, 0x1b, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x30, 0x0f, 0x00, 0xc3, 0x00, 0x0c, 0x00, 0x00, 0x0c, 0x03, 0x1b, 0x00, 0x00, 0x00, 0x00, 0x00, 0xe0, 0x0d, 0x00, 0xc3, 0x00, 0x00, 0x00, 0x00, 0x0c, 0x03, 0x1b, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0xc3, 0x00, 0x00, 0x00, 0x00, 0x0c, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x66, 0x00, 0x00, 0x00, 0xff, 0x0d, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x66, 0x00, 0x00, 0x00, 0x00, 0x0c, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3c, 0x00, 0x00, 0x00, 0x00, 0xfc, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00
};

static const unsigned char GlyphData[] =
{
	0x20, 0x4b, 0x80, 0x04, 0x21, 0x1e, 0x70, 0x05, 0x23, 0x4f, 0x80, 0x09, 0x24, 0x67, 0x70, 0x09, 0x25, 0x70, 0x70, 0x0d, 0x26, 0x03, 0x80, 0x0b, 0x28, 0x17, 0x80, 0x05, 0x29, 0x1c, 0x80, 0x05,
	0x2a, 0x0e, 0x80, 0x09, 0x2b, 0x26, 0x80, 0x09, 0x2c, 0x16, 0x70, 0x04, 0x2d, 0x21, 0x80, 0x05, 0x2e, 0x1a, 0x70, 0x04, 0x2f, 0x3d, 0x70, 0x04, 0x30, 0x6f, 0x24, 0x09, 0x31, 0x01, 0x37, 0x09,
	0x32, 0x0a, 0x37, 0x09, 0x33, 0x13, 0x37, 0x09, 0x34, 0x1c, 0x37, 0x09, 0x35, 0x25, 0x37, 0x09, 0x36, 0x2e, 0x37, 0x09, 0x37, 0x37, 0x37, 0x09, 0x38, 0x40, 0x37, 0x09, 0x39, 0x49, 0x37, 0x09,
	0x3a, 0x27, 0x70, 0x04, 0x3b, 0x23, 0x70, 0x04, 0x3c, 0x2b, 0x70, 0x09, 0x3d, 0x2f, 0x80, 0x09, 0x3e, 0x34, 0x70, 0x09, 0x3f, 0x41, 0x70, 0x0a, 0x40, 0x57, 0x70, 0x10, 0x41, 0x52, 0x37, 0x0c,
	0x42, 0x5e, 0x37, 0x0c, 0x43, 0x6a, 0x37, 0x0c, 0x44, 0x01, 0x4a, 0x0c, 0x45, 0x0d, 0x4a, 0x0b, 0x46, 0x18, 0x4a, 0x0a, 0x47, 0x22, 0x4a, 0x0d, 0x48, 0x2f, 0x4a, 0x0c, 0x49, 0x3b, 0x4a, 0x05,
	0x4a, 0x40, 0x4a, 0x09, 0x4b, 0x49, 0x4a, 0x0b, 0x4c, 0x54, 0x4a, 0x0a, 0x4d, 0x5e, 0x4a, 0x0e, 0x4e, 0x6c, 0x4a, 0x0c, 0x4f, 0x01, 0x5d, 0x0d, 0x50, 0x0e, 0x5d, 0x0b, 0x51, 0x19, 0x5d, 0x0d,
	0x52, 0x26, 0x5d, 0x0c, 0x53, 0x32, 0x5d, 0x0b, 0x54, 0x3d, 0x5d, 0x0a, 0x55, 0x47, 0x5d, 0x0c, 0x56, 0x53, 0x5d, 0x0b, 0x57, 0x5e, 0x5d, 0x0f, 0x58, 0x6d, 0x5d, 0x0b, 0x59, 0x01, 0x70, 0x0b,
	0x5a, 0x0c, 0x70, 0x0a, 0x5b, 0x41, 0x80, 0x05, 0x5d, 0x46, 0x80, 0x05, 0x5f, 0x38, 0x80, 0x09, 0x61, 0x01, 0x11, 0x0a, 0x62, 0x0b, 0x11, 0x0a, 0x63, 0x15, 0x11, 0x09, 0x64, 0x1e, 0x11, 0x0a,
	0x65, 0x28, 0x11, 0x0a, 0x66, 0x32, 0x11, 0x06, 0x67, 0x38, 0x11, 0x0a, 0x68, 0x42, 0x11, 0x0a, 0x69, 0x4c, 0x11, 0x04, 0x6a, 0x50, 0x11, 0x04, 0x6b, 0x54, 0x11, 0x09, 0x6c, 0x5d, 0x11, 0x04,
	0x6d, 0x61, 0x11, 0x0e, 0x6e, 0x6f, 0x11, 0x0a, 0x6f, 0x01, 0x24, 0x0a, 0x70, 0x0b, 0x24, 0x0a, 0x71, 0x15, 0x24, 0x0a, 0x72, 0x1f, 0x24, 0x07, 0x73, 0x26, 0x24, 0x09, 0x74, 0x2f, 0x24, 0x06,
	0x75, 0x35, 0x24, 0x0a, 0x76, 0x3f, 0x24, 0x09, 0x77, 0x48, 0x24, 0x0e, 0x78, 0x56, 0x24, 0x08, 0x79, 0x5e, 0x24, 0x09, 0x7a, 0x67, 0x24, 0x08, 0x7b, 0x4b, 0x70, 0x06, 0x7d, 0x51, 0x70, 0x06,
	0x00
};

// ============================================================================

TexFont gTexFont;

TexFont::TexFont()
{
	mRefCount = 0;
	mTexture = 0;
	memset(&mGlyphs, 0, sizeof(mGlyphs));
}

TexFont::~TexFont()
{
}

bool TexFont::Load(lcContext* Context)
{
	mRefCount++;

	if (mRefCount != 1)
		return true;

	mFontHeight = 16;

	glGenTextures(1, &mTexture);
	Context->BindTexture(mTexture);
	glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_WRAP_S, GL_REPEAT);
	glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_WRAP_T, GL_REPEAT);
	glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_MIN_FILTER, GL_NEAREST);
	glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_MAG_FILTER, GL_NEAREST);
	glPixelStorei(GL_UNPACK_ALIGNMENT, 1);

	unsigned char ExpandedData[sizeof(TextureData) * 8 * 2];
	for (unsigned int TexelIdx = 0; TexelIdx < sizeof(TextureData) * 8; TexelIdx++)
	{
		unsigned char Texel = TextureData[TexelIdx / 8] & (1 << (TexelIdx % 8)) ? 255 : 0;
		ExpandedData[TexelIdx * 2] = ExpandedData[TexelIdx * 2 + 1] = Texel;
	}

	mTextureWidth = 128;
	mTextureHeight = 128;

	glTexImage2D(GL_TEXTURE_2D, 0, GL_LUMINANCE_ALPHA, mTextureWidth, mTextureHeight, 0, GL_LUMINANCE_ALPHA, GL_UNSIGNED_BYTE, ExpandedData);

	const unsigned char* Ptr = GlyphData;

	for (;;)
	{
		unsigned char Glyph = *Ptr++;

		if (!Glyph)
			break;

		mGlyphs[Glyph].left = *Ptr++;
		mGlyphs[Glyph].bottom = *Ptr++;
		mGlyphs[Glyph].width = *Ptr++;
		mGlyphs[Glyph].right = mGlyphs[Glyph].left + mGlyphs[Glyph].width;
		mGlyphs[Glyph].top = mGlyphs[Glyph].bottom - mFontHeight;

		mGlyphs[Glyph].left /= mTextureWidth;
		mGlyphs[Glyph].right /= mTextureWidth;
		mGlyphs[Glyph].top /= mTextureHeight;
		mGlyphs[Glyph].bottom /= mTextureHeight;
	}

	return true;
}

void TexFont::Release()
{
	mRefCount--;
	if (mRefCount == 0)
	{
		glDeleteTextures(1, &mTexture);
		mTexture = 0;
	}
}

void TexFont::GetStringDimensions(int* cx, int* cy, const char* Text) const
{
	*cx = 0;
	*cy = mFontHeight;

	while (*Text != 0)
	{
		*cx += mGlyphs[(int)(*Text)].width;
		Text++;
	}
}

void TexFont::PrintText(lcContext* Context, float Left, float Top, float Z, const char* Text) const
{
	size_t Length = strlen(Text);

	if (!Length)
		return;

	float* Verts = new float[6 * 5 * Length];
	float* CurVert = Verts;

	while (*Text)
	{
		int ch = *Text;

		*CurVert++ = Left;
		*CurVert++ = Top;
		*CurVert++ = Z;
		*CurVert++ = mGlyphs[ch].left;
		*CurVert++ = mGlyphs[ch].top;

		*CurVert++ = Left;
		*CurVert++ = Top - mFontHeight;
		*CurVert++ = Z;
		*CurVert++ = mGlyphs[ch].left;
		*CurVert++ = mGlyphs[ch].bottom;

		*CurVert++ = Left + mGlyphs[ch].width;
		*CurVert++ = Top - mFontHeight;
		*CurVert++ = Z;
		*CurVert++ = mGlyphs[ch].right;
		*CurVert++ = mGlyphs[ch].bottom;

		*CurVert++ = Left + mGlyphs[ch].width;
		*CurVert++ = Top - mFontHeight;
		*CurVert++ = Z;
		*CurVert++ = mGlyphs[ch].right;
		*CurVert++ = mGlyphs[ch].bottom;

		*CurVert++ = Left + mGlyphs[ch].width;
		*CurVert++ = Top;
		*CurVert++ = Z;
		*CurVert++ = mGlyphs[ch].right;
		*CurVert++ = mGlyphs[ch].top;

		*CurVert++ = Left;
		*CurVert++ = Top;
		*CurVert++ = Z;
		*CurVert++ = mGlyphs[ch].left;
		*CurVert++ = mGlyphs[ch].top;

		Left += mGlyphs[ch].width;
		Text++;
	}

	Context->SetVertexBufferPointer(Verts);
	Context->SetVertexFormat(0, 3, 0, 2, 0, false);

	Context->DrawPrimitives(GL_TRIANGLES, 0, 6 * (GLsizei)Length);

	delete[] Verts;
}

void TexFont::GetGlyphTriangles(float Left, float Top, float Z, int Glyph, float* Buffer) const
{
	Left -= mGlyphs[Glyph].width / 2.0f;
	Top += mFontHeight / 2.0f;

	*Buffer++ = Left;
	*Buffer++ = Top;
	*Buffer++ = Z;
	*Buffer++ = mGlyphs[Glyph].left;
	*Buffer++ = mGlyphs[Glyph].top;

	*Buffer++ = Left;
	*Buffer++ = Top - mFontHeight;
	*Buffer++ = Z;
	*Buffer++ = mGlyphs[Glyph].left;
	*Buffer++ = mGlyphs[Glyph].bottom;

	*Buffer++ = Left + mGlyphs[Glyph].width;
	*Buffer++ = Top - mFontHeight;
	*Buffer++ = Z;
	*Buffer++ = mGlyphs[Glyph].right;
	*Buffer++ = mGlyphs[Glyph].bottom;

	*Buffer++ = Left + mGlyphs[Glyph].width;
	*Buffer++ = Top - mFontHeight;
	*Buffer++ = Z;
	*Buffer++ = mGlyphs[Glyph].right;
	*Buffer++ = mGlyphs[Glyph].bottom;

	*Buffer++ = Left + mGlyphs[Glyph].width;
	*Buffer++ = Top;
	*Buffer++ = Z;
	*Buffer++ = mGlyphs[Glyph].right;
	*Buffer++ = mGlyphs[Glyph].top;

	*Buffer++ = Left;
	*Buffer++ = Top;
	*Buffer++ = Z;
	*Buffer++ = mGlyphs[Glyph].left;
	*Buffer++ = mGlyphs[Glyph].top;
}
