#include "lc_global.h"
#include "lc_qaboutdialog.h"
#include "ui_lc_qaboutdialog.h"
#include "lc_mainwindow.h"
#include "preview.h"
#include "lc_glextensions.h"

lcQAboutDialog::lcQAboutDialog(QWidget *parent) :
	QDialog(parent),
	ui(new Ui::lcQAboutDialog)
{
	ui->setupUi(this);

	ui->version->setText(tr("LeoCAD Version %1").arg(QString::fromLatin1(LC_VERSION_TEXT)));

	gMainWindow->mPreviewWidget->MakeCurrent();

	GLint Red, Green, Blue, Alpha, Depth, Stencil;
	GLboolean DoubleBuffer, RGBA;

	glGetIntegerv(GL_RED_BITS, &Red);
	glGetIntegerv(GL_GREEN_BITS, &Green);
	glGetIntegerv(GL_BLUE_BITS, &Blue);
	glGetIntegerv(GL_ALPHA_BITS, &Alpha);
	glGetIntegerv(GL_DEPTH_BITS, &Depth);
	glGetIntegerv(GL_STENCIL_BITS, &Stencil);
	glGetBooleanv(GL_DOUBLEBUFFER, &DoubleBuffer);
	glGetBooleanv(GL_RGBA_MODE, &RGBA);

	QString VersionFormat = tr("OpenGL Version %1 (GLSL %2)\n%3 - %4\n\n");
	QString Version = VersionFormat.arg(QString((const char*)glGetString(GL_VERSION)), QString((const char*)glGetString(GL_SHADING_LANGUAGE_VERSION)), QString((const char*)glGetString(GL_RENDERER)), QString((const char*)glGetString(GL_VENDOR)));
	QString BuffersFormat = tr("Color Buffer: %1 bits %2 %3\nDepth Buffer: %4 bits\nStencil Buffer: %5 bits\n\n");
	QString Buffers = BuffersFormat.arg(QString::number(Red + Green + Blue + Alpha), RGBA ? "RGBA" : tr("indexed"), DoubleBuffer ? tr("double buffered") : QString(), QString::number(Depth), QString::number(Stencil));

	QString ExtensionsFormat = tr("GL_ARB_vertex_buffer_object extension: %1\nGL_ARB_framebuffer_object extension: %2\nGL_EXT_framebuffer_object extension: %3\nGL_EXT_texture_filter_anisotropic extension: %4\n");
	QString VertexBufferObject = gSupportsVertexBufferObject ? tr("Supported") : tr("Not supported");
	QString FramebufferObjectARB = gSupportsFramebufferObjectARB ? tr("Supported") : tr("Not supported");
	QString FramebufferObjectEXT = gSupportsFramebufferObjectEXT ? tr("Supported") : tr("Not supported");
	QString Anisotropic = gSupportsAnisotropic ? tr("Supported (max %1)").arg(gMaxAnisotropy) : tr("Not supported");
	QString Extensions = ExtensionsFormat.arg(VertexBufferObject, FramebufferObjectARB, FramebufferObjectEXT, Anisotropic);

	ui->info->setText(Version + Buffers + Extensions);
}

lcQAboutDialog::~lcQAboutDialog()
{
	delete ui;
}
