#!/usr/bin/perl
#
# Script to parse OW2 gitlab JSON API response and convert to changelog
# Usage:
# 1/ Get a personal token
# 2/ Get Milestone id with curl --header "PRIVATE-TOKEN: xxxx" 'https://gitlab.ow2.org/api/v4/projects/lemonldap-ng%2Flemonldap-ng/milestones?state=active' | json_pp
# 3/ List issues with curl --header "PRIVATE-TOKEN: xxxx" 'https://gitlab.ow2.org/api/v4/projects/lemonldap-ng%2Flemonldap-ng/milestones/:id/issues' | perl gitlab-issues-to-changelog.pl 
# 3/ List merge requests with curl --header "PRIVATE-TOKEN: xxxx" 'https://gitlab.ow2.org/api/v4/projects/lemonldap-ng%2Flemonldap-ng/milestones/:id/merge_requests' | perl gitlab-issues-to-changelog.pl 
 
use JSON;

my $input;
while(<>) { $input .= "$_\n"; }

my $json = decode_json $input;

# Debian changelog
print "# Debian\n";
foreach my $issue (@$json) {
    print "    * #" . $issue->{iid} .": " . $issue->{title} . "\n";
}
print "\n";

# RPM changelog
print "# RPM\n";
foreach my $issue (@$json) {
    print "- #" . $issue->{iid} .": " . $issue->{title} . "\n";
}
print "\n";

# Release contributors
print "# Contributors\n";
foreach my $issue (@$json) {
    print "Author of issue #" . $issue->{iid} .": " . $issue->{author}->{name} . "\n";
}


exit 0;
