/* -*- Mode: C; indent-tabs-mode: t; c-basic-offset: 8; tab-width: 8 -*- */
/*
 * Linux Desktop Testing Project http://ldtp.freedesktop.org
 *
 * Author:
 *    Nagappan A <anagappan@gmail.com>
 *    Premkumar J <jpremkumar@novell.com>
 *
 * Copyright 2004 - 2006 Novell, Inc.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this program; if not, write to the
 * Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA 02110, USA.
 */

#ifndef __APPMAP_H__
#define __APPMAP_H__

struct obj_property {
	gboolean appmap_type; /* TRUE, remap generated appamp. FALSE, initappmap based appmap*/
	long child_index;
	gchar *str_child_index;
	gchar *parent_name;
	int class_type; /* SPI_ROLE_MENU_ITEM */
	gchar *class_name; /* menu_item */
	gchar *label;
	gchar *label_by;
	gchar *app_name;
};

struct unkn_label_property { /* Example: txt0, pnl2*/
	gboolean appmap_type; /* TRUE, remap generated appamp. FALSE, initappmap based appmap*/
	long child_index;
	gchar *str_child_index;
	gchar *parent_name;
	gchar *obj_name;
};

struct obj_info {
	gchar *key;
	gchar *parent_name;
	gboolean obj_is_window;
	GPatternSpec *pattern;
	GHashTable *ht_data_list;
};

typedef struct obj_info OBJInfo;
typedef struct obj_property OBJProperty;
typedef struct unkn_label_property UnknLabelProperty;

GHashTable *appmap_init (gchar *, FILE *);
void   ldtp_appmap_free (GHashTable* appmap);
gchar   *get_property (GHashTable *, gchar *, FILE *);
GHashTable *get_object_def (GHashTable *, gchar *, gchar *, FILE *, gboolean);
GHashTable *get_all_matching_def (GHashTable *ht, gchar *context, gboolean obj_is_window, FILE *log_fp);
void print_attributes (gchar *key, gchar *value, gchar *userdata);
void print_component (gchar *key, GHashTable *component, gchar *userdata);
void print_context (gchar *key, GHashTable *context, gchar *userdata);
void destroy_string (gpointer data);
void destroy_hashtable (gpointer data);
gboolean match_object_def (gchar *key, gchar *value, gboolean obj_is_window);
gboolean remove_context_entries (gpointer key, gpointer value, gpointer context);
gboolean remove_remapped_entry (gpointer key, gpointer value, gpointer user_data);
gboolean search_title_based (gpointer key, gpointer value, gpointer user_data);

#endif /*__APPMAP_H__*/
