/* -*- Mode: C; indent-tabs-mode: t; c-basic-offset: 8; tab-width: 8 -*- */
/*
 * Linux Desktop Testing Project http://ldtp.freedesktop.org
 *
 * Author:
 *    Shankar Ganesh <shagan.glare@gmail.com>
 *    Harishankaran <sp2hari@gmail.com>
 *    Theyagarajan <theyaga@gmail.com>
 *
 * Copyright 2004 - 2006 Novell, Inc.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */

#ifndef __LDTP_RECORD_H__
#define __LDTP_RECORD_H__

#include "ldtp.h"

typedef struct _LDTPRecord LDTPRecord;

struct _LDTPRecord {
	GTimer *timer; // Time elapsed

	/*
	  Recording file name, handler
	*/
	FILE *fp;
	gchar *filename;

	/*
	  Different callback functions
	*/
	AccessibleEventListener *text_listener;
	AccessibleEventListener *focus_listener;
	AccessibleEventListener *window_listener;
	AccessibleEventListener *generic_listener;
	AccessibleEventListener *mouseclick_listener;
	AccessibleEventListener *state_changed_listener;
	AccessibleEventListener *name_changed_listener;
	AccessibleEventListener *selection_changed_listener;
	AccessibleKeystrokeListener *key_stroke_listener;

	int window_role;
	char *text;
	char *text_area_name;
	char *text_window_name;
	char *base_name;
	char *window_name;
	char *window_type;
	char *text_role;
	char *combobox_name;
	gboolean text_changed;
	gboolean clicked;
	gboolean combobox_changed ;
};

#define CALLBACK_DELAY 1

#endif
