/*
    ldapdiff
    Copyright (C) 2000-2002 Thomas.Reith@rhoen.de

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#include <lber.h>
#include <ldap.h>

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <sys/types.h>

#include "ldapdiff.h"
#include "base64.h"

static void ldifwriteval(FILE *f,char *val,size_t val_len,teattrtype val_type){
 char   *val_temp = NULL;
 size_t  len_temp = 0;
 int     freeval  = 0;
 int     left;
 int     n;

 switch(val_type){
  case ATTRUNKNOWN: /* in doubt, write binary */
  case ATTRBIN:
       val_temp = LDALLOC(1,val_len * 4 + 1);
       if((len_temp = b64_ntop((u_char*)val,val_len,val_temp,val_len * 4 + 1)) == -1){
        fprintf(stderr,"b64_ntop failed: file: %s, line: %d\n",__FILE__,__LINE__);
        exit(-1);
       }
       freeval = 1;
       fprintf(f,": ");
       break;
  case ATTRASC:
       val_temp = val;
       len_temp = val_len;
       freeval = 0;
       fprintf(f," ");
       break;
   default:
       fprintf(stderr,"error unkonwn attribute type detected: file: %s, line: %d\n",__FILE__,__LINE__);
       exit(-1);
       break;
 }

 left  = len_temp;
 while(left > 0){
  if(left < len_temp){
   fprintf(f," ");
  }

  if(left - MAXLDIFLINELEN > 0){
   n = MAXLDIFLINELEN;
  }
  else{
   n = left;
  }

  fwrite(val_temp+len_temp-left,sizeof(char),n,f);

  fprintf(f,"\n");

  left -= n;
 }

 if(freeval != 0){
  free(val_temp);
 }
}

void ldifwrite(struct s_mod *smod,struct s_schema *sschema)
{
 FILE              *fmod; 
 FILE              *fadd; 
 struct s_mod      *psmod;
 struct s_modentry *psmodentry;

 psmod = smod;

 if((fmod = fopen(ldifgetgconf(CONFMODFILE),"w")) == NULL){
  fprintf(stderr,"fopen() of %s failed: file: %s, line: %d\n",ldifgetgconf(CONFMODFILE),__FILE__,__LINE__);
  exit(-1);
 } 

 if((fadd = fopen(ldifgetgconf(CONFADDFILE),"w")) == NULL){
  fprintf(stderr,"fopen() of %s failed: file: %s, line: %d\n",ldifgetgconf(CONFADDFILE),__FILE__,__LINE__);
  exit(-1);
 } 

 while(psmod != NULL){
  switch(psmod->modtype){
   case MODADD:
        fprintf(fadd,"%s: %s\n",psmod->dnvar,psmod->dnval);
        psmodentry = psmod->attrlist;
        while(psmodentry != NULL){
         fprintf(fadd,"%s:",psmodentry->var);
         ldifwriteval(fadd,psmodentry->val,psmodentry->val_len,psmodentry->val_type);
         psmodentry = psmodentry->next; 
        }
        fprintf(fadd,"\n");
        break;

   case MODMODIFY:
        fprintf(fmod,"%s: %s\n",psmod->dnvar,psmod->dnval);
        fprintf(fmod,"changetype: modify\n");
        psmodentry = psmod->attrlist;
        while(psmodentry != NULL){

         switch(psmodentry->modtype){
          case MODENTRYADD:
               fprintf(fmod,"add: %s\n",psmodentry->var);
               fprintf(fmod,"%s:",psmodentry->var);
               ldifwriteval(fmod,psmodentry->val,psmodentry->val_len,psmodentry->val_type);
               fprintf(fmod,"-\n");
               break;

          case MODENTRYREPLACE:
               fprintf(fmod,"replace: %s\n",psmodentry->var);
               fprintf(fmod,"%s:",psmodentry->var);
               ldifwriteval(fmod,psmodentry->val,psmodentry->val_len,psmodentry->val_type);
               fprintf(fmod,"-\n");
               break;

          case MODENTRYDELETE:
               fprintf(fmod,"delete: %s\n",psmodentry->var);
               if(ldifschemaequal(sschema,psmodentry->var) == 1){
                fprintf(fmod,"%s:",psmodentry->var);
                ldifwriteval(fmod,psmodentry->val,psmodentry->val_len,psmodentry->val_type);
               }
               fprintf(fmod,"-\n");
               break;
         }
         psmodentry = psmodentry->next; 
        }
        fprintf(fmod,"\n");
        break;

   case MODDELETE:
        fprintf(fmod,"%s: %s\n",psmod->dnvar,psmod->dnval);
        fprintf(fmod,"changetype: delete\n");
        fprintf(fmod,"\n");
        break;
  } 
  psmod = psmod->next;
 } 
 fclose(fadd);
 fclose(fmod);
}
