{-# OPTIONS_GHC -optc-D__HUGS__ #-}
{-# INCLUDE <ldap.h> #-}
{-# LINE 1 "Types.hsc" #-}
{-  -*- Mode: haskell; -*-
{-# LINE 2 "Types.hsc" #-}
Haskell LDAP Interface
Copyright (C) 2005 John Goerzen <jgoerzen@complete.org>

This code is under a 3-clause BSD license; see COPYING for details.
-}

{- |
   Module     : LDAP.Types
   Copyright  : Copyright (C) 2005 John Goerzen
   License    : BSD

   Maintainer : John Goerzen,
   Maintainer : jgoerzen@complete.org
   Stability  : provisional
   Portability: portable

Basic types for LDAP programs.

Written by John Goerzen, jgoerzen\@complete.org

See also "LDAP.Data" for types relating to return codes, option codes, etc.
-}

module LDAP.Types(-- * General
                  LDAP, LDAPInt, BERInt, BERTag, BERLen
                 )
where

import Foreign.Ptr
import Data.Word
import Data.Int
import Foreign.C.Types
import Foreign.ForeignPtr
import LDAP.TypesLL
import LDAP.Data


{-# LINE 39 "Types.hsc" #-}

{- | Main LDAP object type.

LDAP objects are automatically unbound (and memory freed) when they are
garbage-collected by Haskell. -}
type LDAP = ForeignPtr CLDAP

{- | Convenience type so we use the correct ints for the LDAP library. -}
type LDAPInt = CInt

{- | BER type tag -}
type BERTag = Word32
{-# LINE 51 "Types.hsc" #-}

{- | BER int type -}
type BERInt = Int32
{-# LINE 54 "Types.hsc" #-}

{- | BER length type -}
type BERLen = Word32
{-# LINE 57 "Types.hsc" #-}
