{-# OPTIONS_GHC -optc-D__HUGS__ #-}
{-# INCLUDE "ldap.h" #-}
{-# LINE 1 "Constants.hsc" #-}
{- -*- Mode: haskell; -*-
{-# LINE 2 "Constants.hsc" #-}
Haskell LDAP Interface
Copyright (C) 2005 John Goerzen <jgoerzen@complete.org>

This code is under a 3-clause BSD license; see COPYING for details.
-}

{- |
   Module     : LDAP.Constants
   Copyright  : Copyright (C) 2005 John Goerzen
   License    : BSD

   Maintainer : John Goerzen,
   Maintainer : jgoerzen@complete.org
   Stability  : provisional
   Portability: portable

LDAP constants for use in your programs

Written by John Goerzen, jgoerzen\@complete.org
-}

module LDAP.Constants(module LDAP.Constants)
where
import Foreign.C.Types
import LDAP.Types


{-# LINE 29 "Constants.hsc" #-}

ldapPort :: LDAPInt
ldapPort =  389
ldapsPort :: LDAPInt
ldapsPort =  636
ldapApiVersion :: LDAPInt
ldapApiVersion =  2004
ldapVendorName :: LDAPInt
ldapVendorName =  134617855
ldapApiInfoVersion :: LDAPInt
ldapApiInfoVersion =  1
ldapFeatureInfoVersion :: LDAPInt
ldapFeatureInfoVersion =  1
ldapControlValuesreturnfilter :: LDAPInt
ldapControlValuesreturnfilter =  134617912
ldapControlSubentries :: LDAPInt
ldapControlSubentries =  134617959
ldapControlNoop :: LDAPInt
ldapControlNoop =  134618001
ldapControlManagedsait :: LDAPInt
ldapControlManagedsait =  134618050
ldapControlProxyAuthz :: LDAPInt
ldapControlProxyAuthz =  134618099
ldapControlSortrequest :: LDAPInt
ldapControlSortrequest =  134618149
ldapControlSortresponse :: LDAPInt
ldapControlSortresponse =  134618198
ldapControlVlvrequest :: LDAPInt
ldapControlVlvrequest =  134618245
ldapControlVlvresponse :: LDAPInt
ldapControlVlvresponse =  134618294
ldapNoticeOfDisconnection :: LDAPInt
ldapNoticeOfDisconnection =  134618348
ldapNoticeDisconnect :: LDAPInt
ldapNoticeDisconnect =  134618348

{-# LINE 37 "Constants.hsc" #-}

ldapFilterAnd :: BERTag
ldapFilterAnd =  160
ldapFilterOr :: BERTag
ldapFilterOr =  161
ldapFilterNot :: BERTag
ldapFilterNot =  162
ldapFilterEquality :: BERTag
ldapFilterEquality =  163
ldapFilterSubstrings :: BERTag
ldapFilterSubstrings =  164
ldapFilterGe :: BERTag
ldapFilterGe =  165
ldapFilterLe :: BERTag
ldapFilterLe =  166
ldapFilterPresent :: BERTag
ldapFilterPresent =  135
ldapFilterApprox :: BERTag
ldapFilterApprox =  168
ldapFilterExt :: BERTag
ldapFilterExt =  169
ldapFilterExtOid :: BERTag
ldapFilterExtOid =  129
ldapFilterExtType :: BERTag
ldapFilterExtType =  130
ldapFilterExtValue :: BERTag
ldapFilterExtValue =  131
ldapFilterExtDnattrs :: BERTag
ldapFilterExtDnattrs =  132
ldapSubstringAny :: BERTag
ldapSubstringAny =  129
ldapSubstringFinal :: BERTag
ldapSubstringFinal =  130
ldapSubstringInitial :: BERTag
ldapSubstringInitial =  128

{-# LINE 44 "Constants.hsc" #-}

