<?php
/*
	$Id: changePassword.php,v 1.9 2008-08-10 13:33:57 roland Exp $

	This code is part of LDAP Account Manager Pro (http://www.sourceforge.net/projects/lam)
	Copyright (C) 2007 - 2008 Roland Gruber
*/

/**
* Change password page for helpdesk employees.
*
* @package lists
*
* @author Roland Gruber
*/

/** status messages */
include_once('../../lib/status.inc');
/** security functions */
include_once("../../lib/security.inc");
/** LDAP object */
include_once("../../lib/ldap.inc");


// start session
startSecureSession();

if (!checkIfPasswordChangeIsAllowed()) {
	die();
}

setlanguage();


echo $_SESSION['header'];
	echo "<link rel=\"stylesheet\" type=\"text/css\" href=\"../../style/layout.css\">\n";
	echo "<link rel=\"stylesheet\" type=\"text/css\" href=\"../../style/type_user.css\">\n";
echo "</head><body>\n";

$dn = $_GET['DN'];
$dn = str_replace("\\", '',$dn);
$dn = str_replace("'", '',$dn);

$user = readUser($dn);

$mailTemplate = dirname(__FILE__) . '/../../config/passwordMailTemplate.txt';

if (($user == null) || !is_file($mailTemplate) || !is_readable($mailTemplate)) {
	if ($user == null) {
		StatusMessage("ERROR", "", _("This user was not found!") . " (" . $dn . ")");
	}
	if (!is_file($mailTemplate) || !is_readable($mailTemplate)) {
		StatusMessage('ERROR', 'Mail template ' . $mailTemplate . ' is not readable!');
	}
	echo "<p>&nbsp;</p>";
	echo ("</body></html>\n");
	die();
}

// get user data
$uid = $user['uid'][0];

$name = '';
$firstName = '';
$lastName = '';
$cn = '';
if (isset($user['givenname'][0])) $firstName = $user['givenname'][0];
if (isset($user['sn'][0])) $lastName = $user['sn'][0];
if (isset($user['cn'][0])) $cn = $user['cn'][0];
if ($firstName != '') {
	$name = $firstName . ' ' . $lastName;
}
elseif ($lastName != '') {
	$name = $lastName;
}
else {
	$name = $cn;
}

$mail = '';
if (isset($user['mail'][0])) {
	$mail = $user['mail'][0];
}

$tel = '';
if (isset($user['telephonenumber'][0])) {
	$tel = $user['telephonenumber'][0];
}

// password specified?
if (isset($_POST['setPassword'])) {
	logNewMessage(LOG_NOTICE, "Trying to set a specified password for " . $dn);
	setSpecifiedPassword($dn, $user);
	$user = readUser($dn);
}
elseif (isset($_POST['generatePassword'])) {
	if ($_POST['genSelect'] == 'mail') {
		logNewMessage(LOG_NOTICE, "Trying to mail a random password for " . $dn);
	}
	else {
		logNewMessage(LOG_NOTICE, "Trying to set a random password for " . $dn);
	}
	generatePassword($dn, $mailTemplate, $user, $mail);
	$user = readUser($dn);
}

$objectClasses = $user['objectclass'];

$options = array();
if (in_array('sambaSamAccount', $objectClasses)) {
	$options[] = '<input type="checkbox" name="syncSambaNT" checked>' . _('Sync Samba NT password with Unix password');
	$options[] = '<input type="checkbox" name="syncSambaLM" checked>' . _('Sync Samba LM password with Unix password');
}
if (isset($user['sambaacctflags'][0]) && (strpos($user['sambaacctflags'][0], 'L') !== false)) {
	$options[] = '<input type="checkbox" name="unlockSamba" checked>' . _('Unlock Samba account');	
}

echo "<h1>" . _('Change password') . "</h1>\n<br>\n";
echo '<form enctype="multipart/form-data" action="changePassword.php?DN=' . $dn . '" method="post">';

// print user details
echo "<table cellpadding=3 width=\"100%\" class=\"userlist\">\n";
	echo "<tr class=\"userlist\">";
		echo '<th rowspan=5>&nbsp;</th>';
		echo '<th nowrap align="left" colspan=2><big>' . _('Account details') . '<br><br></big></th>';
		echo '<th rowspan=5>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;</th>';
		echo '<th nowrap align="left">';
		if (sizeof($options) > 0) {
			echo '<big>' . _('Options') . '<br><br></big>';
		}
		echo '</th>';
		echo '<th width="100%" rowspan=5>&nbsp;</th>';
	echo "</tr>\n";
	echo "<tr class=\"userlist\">\n";
		echo "<td nowrap><b>" . _('User name') . "&nbsp;&nbsp;</b></td>\n";
		echo "<td nowrap>$uid</td>";
		echo '<td nowrap>';
			if (isset($options[0])) {
				echo $options[0];
			}
		echo '</td>';
	echo "</tr>";
	echo "<tr class=\"userlist\">\n";
		echo "<td nowrap><b>" . _('Full name') . "&nbsp;&nbsp;</b></td>\n";
		echo "<td nowrap>$name</td>";
		echo '<td nowrap>';
			if (isset($options[1])) {
				echo $options[1];
			}
		echo '</td>';
	echo "</tr>";
	echo "<tr class=\"userlist\">\n";
		echo "<td nowrap><b>" . _('eMail address') . "&nbsp;&nbsp;</b></td>\n";
		echo "<td nowrap><a href=\"mailto:$mail\">$mail</a></td>";
		echo '<td nowrap>';
			if (isset($options[2])) {
				echo $options[2];
			}
		echo '</td>';
	echo "</tr>";
	echo "<tr class=\"userlist\">\n";
		echo "<td nowrap><b>" . _('Telephone number') . "&nbsp;&nbsp;<br><br></b></td>\n";
		echo "<td nowrap>$tel<br><br></td>";
		echo '<td nowrap>';
			if (isset($options[3])) {
				echo $options[3];
			}
		echo '</td>';
	echo "</tr>";
echo "</table>\n";

echo "<br>\n";

echo "<fieldset class=\"useredit\">\n";
	echo "<legend>" . _('Generate random password') . "</legend><br>\n";
	echo _('This will set a random password and display it on the screen or send it the user via mail.') . '<br><br>';
	echo _('Mode') . ': ';
	echo '<select name="genSelect">';
		echo '<option value="display">' . _('display on screen') . '</option>';
		if (isset($user['mail'])) {
			echo '<option value="mail">' . _('send via mail') . '</option>';
		}
	echo "</select>\n";
	echo '&nbsp;&nbsp;&nbsp;<input type="checkbox" name="genSure"> ' . _('I am sure');
	echo '&nbsp;&nbsp;&nbsp;';
	echo "<a href=\"../help.php?HelpNumber=520\" target=\"lamhelp\">";
		echo "<img src=\"../../graphics/help.png\" alt=\"" . _('Help') . "\" title=\"" . _('Help') . "\">";
	echo "</a>\n";
	echo '<br><br>';
	echo '<input type="submit" name="generatePassword" value="' . _('Change password') . '">';
echo "</fieldset>\n";

echo "<br>\n";

echo "<fieldset class=\"useredit\">\n";
	echo "<legend>" . _('Set specific password') . "</legend><br>\n";
	echo _('Here you can specify the new password yourself.') . '<br><br>';
	echo '<table>';
	echo '<tr>';
		echo '<td>';
			echo _('Password');
		echo '&nbsp;</td>';
		echo '<td>';
			echo "<input type=\"password\" name=\"password1\">";
		echo '</td>';
	echo '</tr>';
	echo '<tr>';
		echo '<td>';
			echo _('Repeat password');
		echo '&nbsp;</td>';
		echo '<td>';
			echo "<input type=\"password\" name=\"password2\">";
		echo '</td>';
	echo '</tr>';
	echo '</table>';
	echo '<br>';
	echo '<input type="submit" name="setPassword" value="' . _('Change password') . '">';
echo "</fieldset>\n";


/**
 * Returns the LDAP attributes of the given DN.
 *
 * @param String $dn DN
 * @return array attributes
 */
function readUser($dn) {
	$sr = ldap_read($_SESSION['ldap']->server(), $dn, '(uid=*)', array());
	if (!$sr) return null;
	$info = ldap_get_entries($_SESSION['ldap']->server(), $sr);
	if (!$info || (sizeof($info) < 2)) return null;
	$info = $info[0];
	ldap_free_result($sr);
	foreach ($info as $key => $value) {
		if (is_numeric($key)) {
			unset($info[$key]);
		}
		elseif (is_array($info[$key])) {
			unset($info[$key]['count']);
		}
	}
	unset($info['count']);
	return $info;
}

/**
 * Sets the new password.
 * 
 * @param String $dn LDAP DN
 * @param array $user user attributes
 */
function setSpecifiedPassword($dn, $user) {
	// check input
	if (!isset($_POST['password1']) || !isset($_POST['password2'])) {
		StatusMessage('ERROR', _('Empty password submitted. Please try again.'));
		return;
	}
	$pwd1 = $_POST['password1'];	
	$pwd2 = $_POST['password2'];
	if (($pwd1 == '') && ($pwd2 == '')) {
		StatusMessage('ERROR', _('Empty password submitted. Please try again.'));
		return;
	}
	if ($pwd1 !== $pwd2) {
		StatusMessage('ERROR', _('Please enter the same password in both password-fields.'));
		return;
	}
	$pwdResult = checkPasswordStrength($pwd1);
	if ($pwdResult === true) {
		// set new passwords
		setPassword($dn, $pwd1, $user);
	}
	else {
		StatusMessage('ERROR', $pwdResult);
	}
}

/**
 * Sets a generated password and displays it or sends it via mail.
 *
 * @param String $dn LDAP DN
 * @param String $template mail template file
 * @param array $user LDAP attributes of user
 * @param String $mailTo mail address
 */
function generatePassword($dn, $template, $user, $mailTo) {
	// check if user was sure
	if (!isset($_POST['genSure'])) {
		StatusMessage('ERROR', _('You have to activate the "I am sure" checkbox.'));
		return;
	}
	// set password
	$pwd = generateRandomPassword();
	$success = setPassword($dn, $pwd, $user);
	// display/send mail
	if ($success) {
		if ($_POST['genSelect'] == 'mail') {
			// read mail template
			$file = @fopen($template, "r");
			if (!$file) {
				StatusMessage('ERROR', 'Mail template ' . $template . ' is not readable!');
				return;
			}
			$lines = array();
			while (!feof($file)) {
				$lines[] = fgets($file, 1024);
			}
			fclose($file);
			$subject = array_shift($lines);
			$body = implode(PHP_EOL, $lines);
			$body = str_replace('@@newPassword@@', $pwd, $body);
			$results = array();
			$found = preg_match('/\@\@[^\@]+\@\@/', $body, $results);
			while ($found == 1) {
				$attr = str_replace('@', '', $results[0]);
				$value = '';
				if (isset($user[strtolower($attr)][0])) {
					$value = $user[strtolower($attr)][0];
				}
				$body = str_replace('@@' . $attr . '@@', $value, $body);
				$found = preg_match('/\@\@[^\@]+\@\@/', $body, $results);
			}
			$success = mail($mailTo, $subject, $body);
			if ($success) {
				StatusMessage('INFO', sprintf(_('Mail successfully sent to %s.'), $mailTo));
			}
			else {
				StatusMessage('ERROR', _('Unable to send mail!'));
			}
		}
		else {
			StatusMessage('INFO', _('The password(s) were set to:') . ' <b>' . $pwd . '</b>');
		}
	}
}

/**
 * Sets the password to LDAP.
 *
 * @param String $dn LDAP DN
 * @param String $pwd password
 * @param array $user user attributes
 * @return boolean true, if change succeeded
 */
function setPassword($dn, $pwd, $user) {
	$moduleSettings = $_SESSION['config']->get_moduleSettings();
	$attrs = array();
	// Unix password
	$attrs['userPassword'][0] = pwd_hash($pwd, true, $moduleSettings['posixAccount_pwdHash'][0]);
	if (isset($user['shadowlastchange'][0])) {
		$attrs['shadowLastChange'][0] = intval(time()/3600/24);
	}
	// Samba passwords
	if (isset($_POST['syncSambaLM'])) {
		$attrs['sambaLMPassword'][0] = lmPassword($pwd);
	}
	if (isset($_POST['syncSambaNT'])) {
		$attrs['sambaNTPassword'][0] = ntPassword($pwd);
	}
	// unlock Samba
	if (isset($_POST['unlockSamba'])) {
		$sambaFlags = $user['sambaacctflags'][0];
		$sambaFlags = str_replace('L', ' ', $sambaFlags);
		$attrs['sambaAcctFlags'][0] = $sambaFlags;
	}
	$success = @ldap_mod_replace($_SESSION['ldap']->server(), $dn, $attrs);
	if (!$success) {
		StatusMessage('ERROR', sprintf(_('Was unable to modify attributes from DN: %s.'), $dn),
			ldap_error($_SESSION['ldap']->server()));
		logNewMessage(LOG_ERR, "Was unable to modify attributes ($dn)" . ": " . ldap_error($_SESSION['ldap']->server()));
		return false;
	}
	else {
		StatusMessage('INFO', _("Account was modified successfully."));
		logNewMessage(LOG_NOTICE, "Successfully changed password of $dn");
		return true;
	}
}

?>

</form>
</body>
</html>

