/* vim: set noet ts=4:
 *
 * Copyright (c) 2002-2003 Martin A. Godisch <martin@godisch.de>.
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation; either version 2 of the License, or (at your option) any later
 * version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc., 59 Temple
 * Place, Suite 330, Boston, MA 02111-1307 USA.
 */
#ifndef _DATA_H
#define _DATA_H

#include <stdlib.h>

#define DEFAULT_RANDCOUNT   50
#define DEFAULT_WORDLIMIT 1000
#define RATE(X) ((double)(X)->correct / ((double)(X)->mistaken + 1.0))

struct word {
	char     *lang[2];
	unsigned correct;
	unsigned mistaken;
	size_t   pos;
};

extern char   *dictfile;
extern char   *wordfile;
extern size_t randcount;
extern size_t wordlimit;

int    load_wordlist(void);
int    save_wordlist(void);
size_t get_dictcount(void);
size_t get_wordcount(void);
struct word *select_word(void);
void   update_word(struct word*, int);

#endif
