/* vim: set noet ts=4:
 *
 * Copyright (c) 2002-2007 Martin A. Godisch <martin@godisch.de>.
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation; either version 2 of the License, or (at your option) any later
 * version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc., 51 Franklin
 * St, Fifth Floor, Boston, MA 02110-1301, USA.
 */
#include <memory.h>
#include <latrine.h>

/* malloc, call errmsg and exit on failure
 */
inline void *MALLOC(size_t size)
{
	void *ptr;

	if ((ptr = malloc(size)) == NULL) {
		errmsg("malloc: %m");
		exit(1);
	}
	memset(ptr, 0, size);
	return ptr;
}

/* realloc, call errmsg and exit on failure
 */
inline void *REALLOC(void *src, size_t size)
{
	void *ptr;

	if ((ptr = realloc(src, size)) == NULL) {
		errmsg("realloc: %m");
		exit(1);
	}
	return ptr;
}

/* strdup, use MALLOC above
 */
inline char *STRDUP(const char *src)
{
	char *ptr;

	if (src == NULL)
		return NULL;
	ptr = MALLOC(strlen(src) + 1);
	strcpy(ptr, src);
	return ptr;
}

/* free a non-NULL pointer, set it to NULL
 */
inline void FREE(char **ptr)
{
	if (*ptr != NULL)
		free(*ptr);
	*ptr = NULL;
}
