/* project_dialogs.c generated by valac 0.32.0.7-5c081, the Vala compiler
 * generated from project_dialogs.vala, do not modify */

/*
 * This file is part of LaTeXila.
 *
 * Copyright © 2010-2011, 2015 Sébastien Wilmet
 *
 * LaTeXila is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * LaTeXila is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with LaTeXila.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <glib.h>
#include <glib-object.h>
#include <gtk/gtk.h>
#include <glib/gi18n-lib.h>
#include <latexila.h>
#include <gio/gio.h>
#include <gtksourceview/gtksource.h>
#include <string.h>
#include <stdlib.h>
#include <gee.h>


#define TYPE_MAIN_WINDOW (main_window_get_type ())
#define MAIN_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MAIN_WINDOW, MainWindow))
#define MAIN_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MAIN_WINDOW, MainWindowClass))
#define IS_MAIN_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MAIN_WINDOW))
#define IS_MAIN_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MAIN_WINDOW))
#define MAIN_WINDOW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MAIN_WINDOW, MainWindowClass))

typedef struct _MainWindow MainWindow;
typedef struct _MainWindowClass MainWindowClass;
typedef struct _Block29Data Block29Data;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

#define TYPE_DOCUMENT (document_get_type ())
#define DOCUMENT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DOCUMENT, Document))
#define DOCUMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DOCUMENT, DocumentClass))
#define IS_DOCUMENT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DOCUMENT))
#define IS_DOCUMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DOCUMENT))
#define DOCUMENT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DOCUMENT, DocumentClass))

typedef struct _Document Document;
typedef struct _DocumentClass DocumentClass;

#define TYPE_PROJECT (project_get_type ())
typedef struct _Project Project;

#define TYPE_PROJECTS (projects_get_type ())
#define PROJECTS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PROJECTS, Projects))
#define PROJECTS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PROJECTS, ProjectsClass))
#define IS_PROJECTS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PROJECTS))
#define IS_PROJECTS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PROJECTS))
#define PROJECTS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PROJECTS, ProjectsClass))

typedef struct _Projects Projects;
typedef struct _ProjectsClass ProjectsClass;
#define _projects_unref0(var) ((var == NULL) ? NULL : (var = (projects_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _project_free0(var) ((var == NULL) ? NULL : (var = (project_free (var), NULL)))

#define PROJECT_DIALOGS_TYPE_PROJECT_COLUMN (project_dialogs_project_column_get_type ())
typedef struct _Block30Data Block30Data;

struct _Block29Data {
	int _ref_count_;
	GtkFileChooserButton* directory_chooser;
	GtkFileChooserButton* main_file_chooser;
};

struct _Project {
	GFile* directory;
	GFile* main_file;
};

typedef enum  {
	PROJECT_DIALOGS_PROJECT_COLUMN_DIRECTORY,
	PROJECT_DIALOGS_PROJECT_COLUMN_MAIN_FILE,
	PROJECT_DIALOGS_PROJECT_COLUMN_N_COLUMNS
} ProjectDialogsProjectColumn;

struct _Block30Data {
	int _ref_count_;
	GtkDialog* dialog;
	GtkListStore* store;
	GtkTreeView* treeview;
};



GType main_window_get_type (void) G_GNUC_CONST;
void project_dialogs_new_project (MainWindow* main_window);
static Block29Data* block29_data_ref (Block29Data* _data29_);
static void block29_data_unref (void * _userdata_);
static void __lambda70_ (Block29Data* _data29_);
static void ___lambda70__gtk_file_chooser_button_file_set (GtkFileChooserButton* _sender, gpointer self);
GType document_get_type (void) G_GNUC_CONST;
Document* main_window_get_active_document (MainWindow* self);
GFile* document_get_location (Document* self);
gboolean project_dialogs_main_file_is_in_directory (GtkWindow* window, GFile* main_file, GFile* directory);
GType project_get_type (void) G_GNUC_CONST;
Project* project_dup (const Project* self);
void project_free (Project* self);
void project_copy (const Project* self, Project* dest);
void project_destroy (Project* self);
gpointer projects_ref (gpointer instance);
void projects_unref (gpointer instance);
GParamSpec* param_spec_projects (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_projects (GValue* value, gpointer v_object);
void value_take_projects (GValue* value, gpointer v_object);
gpointer value_get_projects (const GValue* value);
GType projects_get_type (void) G_GNUC_CONST;
Projects* projects_get_default (void);
gboolean projects_add (Projects* self, Project* new_project, GFile** conflict_file);
gboolean project_dialogs_configure_project (GtkWindow* main_window, gint project_id);
Project* projects_get (Projects* self, gint id);
gboolean projects_change_main_file (Projects* self, gint num, GFile* new_main_file);
GType project_dialogs_project_column_get_type (void) G_GNUC_CONST;
void project_dialogs_manage_projects (MainWindow* main_window);
static Block30Data* block30_data_ref (Block30Data* _data30_);
static void block30_data_unref (void * _userdata_);
void project_dialogs_update_model (GtkListStore* model);
GtkScrolledWindow* utils_add_scrollbar (GtkWidget* child);
static void __lambda71_ (Block30Data* _data30_);
gint utils_get_selected_row (GtkTreeView* view, GtkTreeIter* iter);
static void ___lambda71__gtk_button_clicked (GtkButton* _sender, gpointer self);
static void __lambda72_ (Block30Data* _data30_);
void projects_delete (Projects* self, gint num);
static void ___lambda72__gtk_button_clicked (GtkButton* _sender, gpointer self);
static void __lambda73_ (Block30Data* _data30_);
void projects_clear_all (Projects* self);
static void ___lambda73__gtk_button_clicked (GtkButton* _sender, gpointer self);
GeeIterator* projects_iterator (Projects* self);


static Block29Data* block29_data_ref (Block29Data* _data29_) {
	g_atomic_int_inc (&_data29_->_ref_count_);
	return _data29_;
}


static void block29_data_unref (void * _userdata_) {
	Block29Data* _data29_;
	_data29_ = (Block29Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data29_->_ref_count_)) {
		_g_object_unref0 (_data29_->main_file_chooser);
		_g_object_unref0 (_data29_->directory_chooser);
		g_slice_free (Block29Data, _data29_);
	}
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static void __lambda70_ (Block29Data* _data29_) {
	GFile* dir = NULL;
	GtkFileChooserButton* _tmp0_ = NULL;
	GFile* _tmp1_ = NULL;
	GError * _inner_error_ = NULL;
	_tmp0_ = _data29_->directory_chooser;
	_tmp1_ = gtk_file_chooser_get_file ((GtkFileChooser*) _tmp0_);
	dir = _tmp1_;
	{
		GtkFileChooserButton* _tmp2_ = NULL;
		_tmp2_ = _data29_->main_file_chooser;
		gtk_file_chooser_set_current_folder_file ((GtkFileChooser*) _tmp2_, dir, &_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			goto __catch38_g_error;
		}
	}
	goto __finally38;
	__catch38_g_error:
	{
		GError* e = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		_g_error_free0 (e);
	}
	__finally38:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		_g_object_unref0 (dir);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	_g_object_unref0 (dir);
}


static void ___lambda70__gtk_file_chooser_button_file_set (GtkFileChooserButton* _sender, gpointer self) {
	__lambda70_ (self);
}


void project_dialogs_new_project (MainWindow* main_window) {
	Block29Data* _data29_;
	GtkDialog* dialog = NULL;
	GObject* _tmp0_ = NULL;
	GObject* _tmp1_ = NULL;
	GtkDialog* _tmp2_ = NULL;
	GtkDialog* _tmp3_ = NULL;
	const gchar* _tmp4_ = NULL;
	GtkDialog* _tmp5_ = NULL;
	GtkDialog* _tmp6_ = NULL;
	MainWindow* _tmp7_ = NULL;
	GtkDialog* _tmp8_ = NULL;
	const gchar* _tmp9_ = NULL;
	GtkDialog* _tmp10_ = NULL;
	const gchar* _tmp11_ = NULL;
	GtkDialog* _tmp12_ = NULL;
	GtkDialog* _tmp13_ = NULL;
	GtkBox* content_area = NULL;
	GtkDialog* _tmp14_ = NULL;
	GtkBox* _tmp15_ = NULL;
	GtkBox* _tmp16_ = NULL;
	const gchar* _tmp17_ = NULL;
	GtkFileChooserButton* _tmp18_ = NULL;
	GtkWidget* component = NULL;
	const gchar* _tmp19_ = NULL;
	GtkFileChooserButton* _tmp20_ = NULL;
	GtkWidget* _tmp21_ = NULL;
	GtkWidget* _tmp22_ = NULL;
	GtkBox* _tmp23_ = NULL;
	GtkWidget* _tmp24_ = NULL;
	const gchar* _tmp25_ = NULL;
	GtkFileChooserButton* _tmp26_ = NULL;
	const gchar* _tmp27_ = NULL;
	GtkFileChooserButton* _tmp28_ = NULL;
	GtkWidget* _tmp29_ = NULL;
	GtkWidget* _tmp30_ = NULL;
	GtkBox* _tmp31_ = NULL;
	GtkWidget* _tmp32_ = NULL;
	GtkBox* _tmp33_ = NULL;
	GtkFileChooserButton* _tmp34_ = NULL;
	Document* doc = NULL;
	MainWindow* _tmp35_ = NULL;
	Document* _tmp36_ = NULL;
	Document* _tmp37_ = NULL;
	Document* _tmp38_ = NULL;
	gboolean _tmp39_ = FALSE;
	Document* _tmp40_ = NULL;
	GtkDialog* _tmp90_ = NULL;
	GError * _inner_error_ = NULL;
	g_return_if_fail (main_window != NULL);
	_data29_ = g_slice_new0 (Block29Data);
	_data29_->_ref_count_ = 1;
	_tmp0_ = g_object_new (gtk_dialog_get_type (), "use-header-bar", TRUE, NULL, NULL);
	_tmp1_ = G_IS_INITIALLY_UNOWNED (_tmp0_) ? g_object_ref_sink (_tmp0_) : _tmp0_;
	_tmp2_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp1_, gtk_dialog_get_type ()) ? ((GtkDialog*) _tmp1_) : NULL;
	if (_tmp2_ == NULL) {
		_g_object_unref0 (_tmp1_);
	}
	dialog = _tmp2_;
	_tmp3_ = dialog;
	_tmp4_ = _ ("New Project");
	gtk_window_set_title ((GtkWindow*) _tmp3_, _tmp4_);
	_tmp5_ = dialog;
	gtk_window_set_destroy_with_parent ((GtkWindow*) _tmp5_, TRUE);
	_tmp6_ = dialog;
	_tmp7_ = main_window;
	gtk_window_set_transient_for ((GtkWindow*) _tmp6_, (GtkWindow*) _tmp7_);
	_tmp8_ = dialog;
	_tmp9_ = _ ("_Cancel");
	gtk_dialog_add_button (_tmp8_, _tmp9_, (gint) GTK_RESPONSE_CANCEL);
	_tmp10_ = dialog;
	_tmp11_ = _ ("Crea_te");
	gtk_dialog_add_button (_tmp10_, _tmp11_, (gint) GTK_RESPONSE_OK);
	_tmp12_ = dialog;
	gtk_dialog_set_default_response (_tmp12_, (gint) GTK_RESPONSE_OK);
	_tmp13_ = dialog;
	gtk_widget_set_size_request ((GtkWidget*) _tmp13_, 450, -1);
	_tmp14_ = dialog;
	_tmp15_ = (GtkBox*) gtk_dialog_get_content_area (_tmp14_);
	_tmp16_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp15_, gtk_box_get_type ()) ? ((GtkBox*) _tmp15_) : NULL);
	content_area = _tmp16_;
	_tmp17_ = _ ("Directory");
	_tmp18_ = (GtkFileChooserButton*) gtk_file_chooser_button_new (_tmp17_, GTK_FILE_CHOOSER_ACTION_SELECT_FOLDER);
	g_object_ref_sink (_tmp18_);
	_data29_->directory_chooser = _tmp18_;
	_tmp19_ = _ ("Directory");
	_tmp20_ = _data29_->directory_chooser;
	_tmp21_ = latexila_utils_get_dialog_component (_tmp19_, (GtkWidget*) _tmp20_);
	_tmp22_ = _g_object_ref0 (_tmp21_);
	component = _tmp22_;
	_tmp23_ = content_area;
	_tmp24_ = component;
	gtk_box_pack_start (_tmp23_, _tmp24_, FALSE, TRUE, (guint) 0);
	_tmp25_ = _ ("Main File");
	_tmp26_ = (GtkFileChooserButton*) gtk_file_chooser_button_new (_tmp25_, GTK_FILE_CHOOSER_ACTION_OPEN);
	g_object_ref_sink (_tmp26_);
	_data29_->main_file_chooser = _tmp26_;
	_tmp27_ = _ ("Main File");
	_tmp28_ = _data29_->main_file_chooser;
	_tmp29_ = latexila_utils_get_dialog_component (_tmp27_, (GtkWidget*) _tmp28_);
	_tmp30_ = _g_object_ref0 (_tmp29_);
	_g_object_unref0 (component);
	component = _tmp30_;
	_tmp31_ = content_area;
	_tmp32_ = component;
	gtk_box_pack_start (_tmp31_, _tmp32_, FALSE, TRUE, (guint) 0);
	_tmp33_ = content_area;
	gtk_widget_show_all ((GtkWidget*) _tmp33_);
	_tmp34_ = _data29_->directory_chooser;
	g_signal_connect_data (_tmp34_, "file-set", (GCallback) ___lambda70__gtk_file_chooser_button_file_set, block29_data_ref (_data29_), (GClosureNotify) block29_data_unref, 0);
	_tmp35_ = main_window;
	_tmp36_ = main_window_get_active_document (_tmp35_);
	_tmp37_ = _tmp36_;
	_tmp38_ = _g_object_ref0 (_tmp37_);
	doc = _tmp38_;
	_tmp40_ = doc;
	if (_tmp40_ != NULL) {
		Document* _tmp41_ = NULL;
		GFile* _tmp42_ = NULL;
		GFile* _tmp43_ = NULL;
		_tmp41_ = doc;
		_tmp42_ = document_get_location (_tmp41_);
		_tmp43_ = _tmp42_;
		_tmp39_ = _tmp43_ != NULL;
	} else {
		_tmp39_ = FALSE;
	}
	if (_tmp39_) {
		{
			GtkFileChooserButton* _tmp44_ = NULL;
			Document* _tmp45_ = NULL;
			GFile* _tmp46_ = NULL;
			GFile* _tmp47_ = NULL;
			GFile* _tmp48_ = NULL;
			GFile* _tmp49_ = NULL;
			GtkFileChooserButton* _tmp50_ = NULL;
			Document* _tmp51_ = NULL;
			GFile* _tmp52_ = NULL;
			GFile* _tmp53_ = NULL;
			_tmp44_ = _data29_->directory_chooser;
			_tmp45_ = doc;
			_tmp46_ = document_get_location (_tmp45_);
			_tmp47_ = _tmp46_;
			_tmp48_ = g_file_get_parent (_tmp47_);
			_tmp49_ = _tmp48_;
			gtk_file_chooser_set_file ((GtkFileChooser*) _tmp44_, _tmp49_, &_inner_error_);
			_g_object_unref0 (_tmp49_);
			if (G_UNLIKELY (_inner_error_ != NULL)) {
				goto __catch39_g_error;
			}
			_tmp50_ = _data29_->main_file_chooser;
			_tmp51_ = doc;
			_tmp52_ = document_get_location (_tmp51_);
			_tmp53_ = _tmp52_;
			gtk_file_chooser_set_file ((GtkFileChooser*) _tmp50_, _tmp53_, &_inner_error_);
			if (G_UNLIKELY (_inner_error_ != NULL)) {
				goto __catch39_g_error;
			}
		}
		goto __finally39;
		__catch39_g_error:
		{
			GError* e = NULL;
			e = _inner_error_;
			_inner_error_ = NULL;
			_g_error_free0 (e);
		}
		__finally39:
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			_g_object_unref0 (doc);
			_g_object_unref0 (component);
			_g_object_unref0 (content_area);
			_g_object_unref0 (dialog);
			block29_data_unref (_data29_);
			_data29_ = NULL;
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	while (TRUE) {
		GtkDialog* _tmp54_ = NULL;
		gint _tmp55_ = 0;
		GFile* directory = NULL;
		GtkFileChooserButton* _tmp56_ = NULL;
		GFile* _tmp57_ = NULL;
		GFile* main_file = NULL;
		GtkFileChooserButton* _tmp58_ = NULL;
		GFile* _tmp59_ = NULL;
		gboolean _tmp60_ = FALSE;
		GFile* _tmp61_ = NULL;
		GtkDialog* _tmp63_ = NULL;
		GFile* _tmp64_ = NULL;
		GFile* _tmp65_ = NULL;
		gboolean _tmp66_ = FALSE;
		Project project = {0};
		GFile* _tmp67_ = NULL;
		GFile* _tmp68_ = NULL;
		GFile* _tmp69_ = NULL;
		GFile* _tmp70_ = NULL;
		GFile* conflict = NULL;
		Projects* _tmp71_ = NULL;
		Projects* _tmp72_ = NULL;
		Project _tmp73_ = {0};
		GFile* _tmp74_ = NULL;
		gboolean _tmp75_ = FALSE;
		gboolean _tmp76_ = FALSE;
		GtkDialog* error_dialog = NULL;
		GtkDialog* _tmp77_ = NULL;
		const gchar* _tmp78_ = NULL;
		GFile* _tmp79_ = NULL;
		gchar* _tmp80_ = NULL;
		gchar* _tmp81_ = NULL;
		gchar* _tmp82_ = NULL;
		gchar* _tmp83_ = NULL;
		gchar* _tmp84_ = NULL;
		gchar* _tmp85_ = NULL;
		GtkMessageDialog* _tmp86_ = NULL;
		GtkDialog* _tmp87_ = NULL;
		GtkDialog* _tmp88_ = NULL;
		GtkDialog* _tmp89_ = NULL;
		_tmp54_ = dialog;
		_tmp55_ = gtk_dialog_run (_tmp54_);
		if (!(_tmp55_ == ((gint) GTK_RESPONSE_OK))) {
			break;
		}
		_tmp56_ = _data29_->directory_chooser;
		_tmp57_ = gtk_file_chooser_get_file ((GtkFileChooser*) _tmp56_);
		directory = _tmp57_;
		_tmp58_ = _data29_->main_file_chooser;
		_tmp59_ = gtk_file_chooser_get_file ((GtkFileChooser*) _tmp58_);
		main_file = _tmp59_;
		_tmp61_ = directory;
		if (_tmp61_ == NULL) {
			_tmp60_ = TRUE;
		} else {
			GFile* _tmp62_ = NULL;
			_tmp62_ = main_file;
			_tmp60_ = _tmp62_ == NULL;
		}
		if (_tmp60_) {
			_g_object_unref0 (main_file);
			_g_object_unref0 (directory);
			continue;
		}
		_tmp63_ = dialog;
		_tmp64_ = main_file;
		_tmp65_ = directory;
		_tmp66_ = project_dialogs_main_file_is_in_directory ((GtkWindow*) _tmp63_, _tmp64_, _tmp65_);
		if (!_tmp66_) {
			_g_object_unref0 (main_file);
			_g_object_unref0 (directory);
			continue;
		}
		memset (&project, 0, sizeof (Project));
		_tmp67_ = directory;
		_tmp68_ = _g_object_ref0 (_tmp67_);
		_g_object_unref0 (project.directory);
		project.directory = _tmp68_;
		_tmp69_ = main_file;
		_tmp70_ = _g_object_ref0 (_tmp69_);
		_g_object_unref0 (project.main_file);
		project.main_file = _tmp70_;
		_tmp71_ = projects_get_default ();
		_tmp72_ = _tmp71_;
		_tmp73_ = project;
		_tmp75_ = projects_add (_tmp72_, &_tmp73_, &_tmp74_);
		_g_object_unref0 (conflict);
		conflict = _tmp74_;
		_tmp76_ = _tmp75_;
		_projects_unref0 (_tmp72_);
		if (_tmp76_) {
			_g_object_unref0 (conflict);
			project_destroy (&project);
			_g_object_unref0 (main_file);
			_g_object_unref0 (directory);
			break;
		}
		_tmp77_ = dialog;
		_tmp78_ = _ ("There is a conflict with the project \"%s\".");
		_tmp79_ = conflict;
		_tmp80_ = g_file_get_parse_name (_tmp79_);
		_tmp81_ = _tmp80_;
		_tmp82_ = latexila_utils_replace_home_dir_with_tilde (_tmp81_);
		_tmp83_ = _tmp82_;
		_tmp84_ = g_strconcat (_tmp83_, "/", NULL);
		_tmp85_ = _tmp84_;
		_tmp86_ = (GtkMessageDialog*) gtk_message_dialog_new ((GtkWindow*) _tmp77_, GTK_DIALOG_DESTROY_WITH_PARENT, GTK_MESSAGE_ERROR, GTK_BUTTONS_OK, _tmp78_, _tmp85_);
		g_object_ref_sink (_tmp86_);
		_tmp87_ = (GtkDialog*) _tmp86_;
		_g_free0 (_tmp85_);
		_g_free0 (_tmp83_);
		_g_free0 (_tmp81_);
		error_dialog = _tmp87_;
		_tmp88_ = error_dialog;
		gtk_dialog_run (_tmp88_);
		_tmp89_ = error_dialog;
		gtk_widget_destroy ((GtkWidget*) _tmp89_);
		_g_object_unref0 (error_dialog);
		_g_object_unref0 (conflict);
		project_destroy (&project);
		_g_object_unref0 (main_file);
		_g_object_unref0 (directory);
	}
	_tmp90_ = dialog;
	gtk_widget_destroy ((GtkWidget*) _tmp90_);
	_g_object_unref0 (doc);
	_g_object_unref0 (component);
	_g_object_unref0 (content_area);
	_g_object_unref0 (dialog);
	block29_data_unref (_data29_);
	_data29_ = NULL;
}


gboolean project_dialogs_configure_project (GtkWindow* main_window, gint project_id) {
	gboolean result = FALSE;
	Project* project = NULL;
	Projects* _tmp0_ = NULL;
	Projects* _tmp1_ = NULL;
	gint _tmp2_ = 0;
	Project* _tmp3_ = NULL;
	Project* _tmp4_ = NULL;
	Project* _tmp5_ = NULL;
	GtkDialog* dialog = NULL;
	GObject* _tmp6_ = NULL;
	GObject* _tmp7_ = NULL;
	GtkDialog* _tmp8_ = NULL;
	GtkDialog* _tmp9_ = NULL;
	const gchar* _tmp10_ = NULL;
	GtkDialog* _tmp11_ = NULL;
	GtkDialog* _tmp12_ = NULL;
	GtkWindow* _tmp13_ = NULL;
	GtkDialog* _tmp14_ = NULL;
	const gchar* _tmp15_ = NULL;
	GtkDialog* _tmp16_ = NULL;
	const gchar* _tmp17_ = NULL;
	GtkDialog* _tmp18_ = NULL;
	GtkDialog* _tmp19_ = NULL;
	GtkBox* content_area = NULL;
	GtkDialog* _tmp20_ = NULL;
	GtkBox* _tmp21_ = NULL;
	GtkBox* _tmp22_ = NULL;
	gchar* project_dir = NULL;
	Project* _tmp23_ = NULL;
	GFile* _tmp24_ = NULL;
	gchar* _tmp25_ = NULL;
	const gchar* _tmp26_ = NULL;
	gchar* _tmp27_ = NULL;
	gchar* _tmp28_ = NULL;
	gchar* _tmp29_ = NULL;
	GtkLabel* location = NULL;
	const gchar* _tmp30_ = NULL;
	GtkLabel* _tmp31_ = NULL;
	GtkLabel* _tmp32_ = NULL;
	GtkLabel* _tmp33_ = NULL;
	GtkWidget* component = NULL;
	const gchar* _tmp34_ = NULL;
	GtkLabel* _tmp35_ = NULL;
	GtkWidget* _tmp36_ = NULL;
	GtkWidget* _tmp37_ = NULL;
	GtkBox* _tmp38_ = NULL;
	GtkWidget* _tmp39_ = NULL;
	GtkFileChooserButton* main_file_chooser = NULL;
	const gchar* _tmp40_ = NULL;
	GtkFileChooserButton* _tmp41_ = NULL;
	const gchar* _tmp42_ = NULL;
	GtkFileChooserButton* _tmp43_ = NULL;
	GtkWidget* _tmp44_ = NULL;
	GtkWidget* _tmp45_ = NULL;
	GtkBox* _tmp46_ = NULL;
	GtkWidget* _tmp47_ = NULL;
	GtkBox* _tmp48_ = NULL;
	gboolean ret = FALSE;
	GtkDialog* _tmp67_ = NULL;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (main_window != NULL, FALSE);
	_tmp0_ = projects_get_default ();
	_tmp1_ = _tmp0_;
	_tmp2_ = project_id;
	_tmp3_ = projects_get (_tmp1_, _tmp2_);
	_tmp4_ = _tmp3_;
	_projects_unref0 (_tmp1_);
	project = _tmp4_;
	_tmp5_ = project;
	g_return_val_if_fail (_tmp5_ != NULL, FALSE);
	_tmp6_ = g_object_new (gtk_dialog_get_type (), "use-header-bar", TRUE, NULL, NULL);
	_tmp7_ = G_IS_INITIALLY_UNOWNED (_tmp6_) ? g_object_ref_sink (_tmp6_) : _tmp6_;
	_tmp8_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp7_, gtk_dialog_get_type ()) ? ((GtkDialog*) _tmp7_) : NULL;
	if (_tmp8_ == NULL) {
		_g_object_unref0 (_tmp7_);
	}
	dialog = _tmp8_;
	_tmp9_ = dialog;
	_tmp10_ = _ ("Configure Project");
	gtk_window_set_title ((GtkWindow*) _tmp9_, _tmp10_);
	_tmp11_ = dialog;
	gtk_window_set_destroy_with_parent ((GtkWindow*) _tmp11_, TRUE);
	_tmp12_ = dialog;
	_tmp13_ = main_window;
	gtk_window_set_transient_for ((GtkWindow*) _tmp12_, _tmp13_);
	_tmp14_ = dialog;
	_tmp15_ = _ ("_Cancel");
	gtk_dialog_add_button (_tmp14_, _tmp15_, (gint) GTK_RESPONSE_CANCEL);
	_tmp16_ = dialog;
	_tmp17_ = _ ("_Apply");
	gtk_dialog_add_button (_tmp16_, _tmp17_, (gint) GTK_RESPONSE_APPLY);
	_tmp18_ = dialog;
	gtk_dialog_set_default_response (_tmp18_, (gint) GTK_RESPONSE_APPLY);
	_tmp19_ = dialog;
	gtk_widget_set_size_request ((GtkWidget*) _tmp19_, 450, -1);
	_tmp20_ = dialog;
	_tmp21_ = (GtkBox*) gtk_dialog_get_content_area (_tmp20_);
	_tmp22_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp21_, gtk_box_get_type ()) ? ((GtkBox*) _tmp21_) : NULL);
	content_area = _tmp22_;
	_tmp23_ = project;
	_tmp24_ = (*_tmp23_).directory;
	_tmp25_ = g_file_get_parse_name (_tmp24_);
	project_dir = _tmp25_;
	_tmp26_ = project_dir;
	_tmp27_ = latexila_utils_replace_home_dir_with_tilde (_tmp26_);
	_tmp28_ = _tmp27_;
	_tmp29_ = g_strconcat (_tmp28_, "/", NULL);
	_g_free0 (project_dir);
	project_dir = _tmp29_;
	_g_free0 (_tmp28_);
	_tmp30_ = project_dir;
	_tmp31_ = (GtkLabel*) gtk_label_new (_tmp30_);
	g_object_ref_sink (_tmp31_);
	location = _tmp31_;
	_tmp32_ = location;
	gtk_label_set_line_wrap (_tmp32_, TRUE);
	_tmp33_ = location;
	gtk_widget_set_halign ((GtkWidget*) _tmp33_, GTK_ALIGN_START);
	_tmp34_ = _ ("Location of the project");
	_tmp35_ = location;
	_tmp36_ = latexila_utils_get_dialog_component (_tmp34_, (GtkWidget*) _tmp35_);
	_tmp37_ = _g_object_ref0 (_tmp36_);
	component = _tmp37_;
	_tmp38_ = content_area;
	_tmp39_ = component;
	gtk_box_pack_start (_tmp38_, _tmp39_, FALSE, TRUE, (guint) 0);
	_tmp40_ = _ ("Main File");
	_tmp41_ = (GtkFileChooserButton*) gtk_file_chooser_button_new (_tmp40_, GTK_FILE_CHOOSER_ACTION_OPEN);
	g_object_ref_sink (_tmp41_);
	main_file_chooser = _tmp41_;
	_tmp42_ = _ ("Main File");
	_tmp43_ = main_file_chooser;
	_tmp44_ = latexila_utils_get_dialog_component (_tmp42_, (GtkWidget*) _tmp43_);
	_tmp45_ = _g_object_ref0 (_tmp44_);
	_g_object_unref0 (component);
	component = _tmp45_;
	_tmp46_ = content_area;
	_tmp47_ = component;
	gtk_box_pack_start (_tmp46_, _tmp47_, FALSE, TRUE, (guint) 0);
	_tmp48_ = content_area;
	gtk_widget_show_all ((GtkWidget*) _tmp48_);
	{
		GtkFileChooserButton* _tmp49_ = NULL;
		Project* _tmp50_ = NULL;
		GFile* _tmp51_ = NULL;
		_tmp49_ = main_file_chooser;
		_tmp50_ = project;
		_tmp51_ = (*_tmp50_).main_file;
		gtk_file_chooser_set_file ((GtkFileChooser*) _tmp49_, _tmp51_, &_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			goto __catch40_g_error;
		}
	}
	goto __finally40;
	__catch40_g_error:
	{
		GError* e = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		_g_error_free0 (e);
	}
	__finally40:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		_g_object_unref0 (main_file_chooser);
		_g_object_unref0 (component);
		_g_object_unref0 (location);
		_g_free0 (project_dir);
		_g_object_unref0 (content_area);
		_g_object_unref0 (dialog);
		_project_free0 (project);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return FALSE;
	}
	ret = FALSE;
	while (TRUE) {
		GtkDialog* _tmp52_ = NULL;
		gint _tmp53_ = 0;
		GFile* main_file = NULL;
		GtkFileChooserButton* _tmp54_ = NULL;
		GFile* _tmp55_ = NULL;
		GFile* _tmp56_ = NULL;
		GtkDialog* _tmp57_ = NULL;
		GFile* _tmp58_ = NULL;
		Project* _tmp59_ = NULL;
		GFile* _tmp60_ = NULL;
		gboolean _tmp61_ = FALSE;
		Projects* _tmp62_ = NULL;
		Projects* _tmp63_ = NULL;
		gint _tmp64_ = 0;
		GFile* _tmp65_ = NULL;
		gboolean _tmp66_ = FALSE;
		_tmp52_ = dialog;
		_tmp53_ = gtk_dialog_run (_tmp52_);
		if (!(_tmp53_ == ((gint) GTK_RESPONSE_APPLY))) {
			break;
		}
		_tmp54_ = main_file_chooser;
		_tmp55_ = gtk_file_chooser_get_file ((GtkFileChooser*) _tmp54_);
		main_file = _tmp55_;
		_tmp56_ = main_file;
		if (_tmp56_ == NULL) {
			_g_object_unref0 (main_file);
			continue;
		}
		_tmp57_ = dialog;
		_tmp58_ = main_file;
		_tmp59_ = project;
		_tmp60_ = (*_tmp59_).directory;
		_tmp61_ = project_dialogs_main_file_is_in_directory ((GtkWindow*) _tmp57_, _tmp58_, _tmp60_);
		if (!_tmp61_) {
			_g_object_unref0 (main_file);
			continue;
		}
		_tmp62_ = projects_get_default ();
		_tmp63_ = _tmp62_;
		_tmp64_ = project_id;
		_tmp65_ = main_file;
		_tmp66_ = projects_change_main_file (_tmp63_, _tmp64_, _tmp65_);
		ret = _tmp66_;
		_projects_unref0 (_tmp63_);
		_g_object_unref0 (main_file);
		break;
	}
	_tmp67_ = dialog;
	gtk_widget_destroy ((GtkWidget*) _tmp67_);
	result = ret;
	_g_object_unref0 (main_file_chooser);
	_g_object_unref0 (component);
	_g_object_unref0 (location);
	_g_free0 (project_dir);
	_g_object_unref0 (content_area);
	_g_object_unref0 (dialog);
	_project_free0 (project);
	return result;
}


GType project_dialogs_project_column_get_type (void) {
	static volatile gsize project_dialogs_project_column_type_id__volatile = 0;
	if (g_once_init_enter (&project_dialogs_project_column_type_id__volatile)) {
		static const GEnumValue values[] = {{PROJECT_DIALOGS_PROJECT_COLUMN_DIRECTORY, "PROJECT_DIALOGS_PROJECT_COLUMN_DIRECTORY", "directory"}, {PROJECT_DIALOGS_PROJECT_COLUMN_MAIN_FILE, "PROJECT_DIALOGS_PROJECT_COLUMN_MAIN_FILE", "main-file"}, {PROJECT_DIALOGS_PROJECT_COLUMN_N_COLUMNS, "PROJECT_DIALOGS_PROJECT_COLUMN_N_COLUMNS", "n-columns"}, {0, NULL, NULL}};
		GType project_dialogs_project_column_type_id;
		project_dialogs_project_column_type_id = g_enum_register_static ("ProjectDialogsProjectColumn", values);
		g_once_init_leave (&project_dialogs_project_column_type_id__volatile, project_dialogs_project_column_type_id);
	}
	return project_dialogs_project_column_type_id__volatile;
}


static Block30Data* block30_data_ref (Block30Data* _data30_) {
	g_atomic_int_inc (&_data30_->_ref_count_);
	return _data30_;
}


static void block30_data_unref (void * _userdata_) {
	Block30Data* _data30_;
	_data30_ = (Block30Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data30_->_ref_count_)) {
		_g_object_unref0 (_data30_->treeview);
		_g_object_unref0 (_data30_->store);
		_g_object_unref0 (_data30_->dialog);
		g_slice_free (Block30Data, _data30_);
	}
}


static void __lambda71_ (Block30Data* _data30_) {
	gint i = 0;
	gint _tmp0_ = 0;
	gboolean _tmp1_ = FALSE;
	gint _tmp2_ = 0;
	_tmp0_ = utils_get_selected_row (_data30_->treeview, NULL);
	i = _tmp0_;
	_tmp2_ = i;
	if (_tmp2_ != -1) {
		gint _tmp3_ = 0;
		gboolean _tmp4_ = FALSE;
		_tmp3_ = i;
		_tmp4_ = project_dialogs_configure_project ((GtkWindow*) _data30_->dialog, _tmp3_);
		_tmp1_ = _tmp4_;
	} else {
		_tmp1_ = FALSE;
	}
	if (_tmp1_) {
		project_dialogs_update_model (_data30_->store);
	}
}


static void ___lambda71__gtk_button_clicked (GtkButton* _sender, gpointer self) {
	__lambda71_ (self);
}


static void __lambda72_ (Block30Data* _data30_) {
	GtkTreeIter iter = {0};
	gint i = 0;
	GtkTreeIter _tmp0_ = {0};
	gint _tmp1_ = 0;
	gint _tmp2_ = 0;
	gchar* directory = NULL;
	GtkTreeModel* model = NULL;
	GtkTreeModel* _tmp3_ = NULL;
	GtkTreeModel* _tmp4_ = NULL;
	GtkTreeIter _tmp5_ = {0};
	GtkDialog* delete_dialog = NULL;
	const gchar* _tmp6_ = NULL;
	const gchar* _tmp7_ = NULL;
	GtkMessageDialog* _tmp8_ = NULL;
	GtkDialog* _tmp9_ = NULL;
	const gchar* _tmp10_ = NULL;
	const gchar* _tmp11_ = NULL;
	GtkDialog* _tmp12_ = NULL;
	gint _tmp13_ = 0;
	GtkDialog* _tmp18_ = NULL;
	_tmp1_ = utils_get_selected_row (_data30_->treeview, &_tmp0_);
	iter = _tmp0_;
	i = _tmp1_;
	_tmp2_ = i;
	if (_tmp2_ == -1) {
		return;
	}
	_tmp3_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_data30_->store, GTK_TYPE_TREE_MODEL, GtkTreeModel));
	model = _tmp3_;
	_tmp4_ = model;
	_tmp5_ = iter;
	gtk_tree_model_get (_tmp4_, &_tmp5_, PROJECT_DIALOGS_PROJECT_COLUMN_DIRECTORY, &directory, -1, -1);
	_tmp6_ = _ ("Do you really want to delete the project \"%s\"?");
	_tmp7_ = directory;
	_tmp8_ = (GtkMessageDialog*) gtk_message_dialog_new ((GtkWindow*) _data30_->dialog, GTK_DIALOG_DESTROY_WITH_PARENT, GTK_MESSAGE_QUESTION, GTK_BUTTONS_NONE, _tmp6_, _tmp7_);
	g_object_ref_sink (_tmp8_);
	delete_dialog = (GtkDialog*) _tmp8_;
	_tmp9_ = delete_dialog;
	_tmp10_ = _ ("_Cancel");
	_tmp11_ = _ ("_Delete");
	gtk_dialog_add_buttons (_tmp9_, _tmp10_, GTK_RESPONSE_CANCEL, _tmp11_, GTK_RESPONSE_YES, NULL);
	_tmp12_ = delete_dialog;
	_tmp13_ = gtk_dialog_run (_tmp12_);
	if (_tmp13_ == ((gint) GTK_RESPONSE_YES)) {
		GtkTreeIter _tmp14_ = {0};
		Projects* _tmp15_ = NULL;
		Projects* _tmp16_ = NULL;
		gint _tmp17_ = 0;
		_tmp14_ = iter;
		gtk_list_store_remove (_data30_->store, &_tmp14_);
		_tmp15_ = projects_get_default ();
		_tmp16_ = _tmp15_;
		_tmp17_ = i;
		projects_delete (_tmp16_, _tmp17_);
		_projects_unref0 (_tmp16_);
	}
	_tmp18_ = delete_dialog;
	gtk_widget_destroy ((GtkWidget*) _tmp18_);
	_g_object_unref0 (delete_dialog);
	_g_object_unref0 (model);
	_g_free0 (directory);
}


static void ___lambda72__gtk_button_clicked (GtkButton* _sender, gpointer self) {
	__lambda72_ (self);
}


static void __lambda73_ (Block30Data* _data30_) {
	GtkDialog* clear_dialog = NULL;
	const gchar* _tmp0_ = NULL;
	GtkMessageDialog* _tmp1_ = NULL;
	GtkDialog* _tmp2_ = NULL;
	const gchar* _tmp3_ = NULL;
	GtkDialog* _tmp4_ = NULL;
	const gchar* _tmp5_ = NULL;
	GtkDialog* _tmp6_ = NULL;
	gint _tmp7_ = 0;
	GtkDialog* _tmp10_ = NULL;
	_tmp0_ = _ ("Do you really want to clear all projects?");
	_tmp1_ = (GtkMessageDialog*) gtk_message_dialog_new ((GtkWindow*) _data30_->dialog, GTK_DIALOG_DESTROY_WITH_PARENT, GTK_MESSAGE_QUESTION, GTK_BUTTONS_NONE, "%s", _tmp0_);
	g_object_ref_sink (_tmp1_);
	clear_dialog = (GtkDialog*) _tmp1_;
	_tmp2_ = clear_dialog;
	_tmp3_ = _ ("_Cancel");
	gtk_dialog_add_button (_tmp2_, _tmp3_, (gint) GTK_RESPONSE_CANCEL);
	_tmp4_ = clear_dialog;
	_tmp5_ = _ ("Clear _All");
	gtk_dialog_add_button (_tmp4_, _tmp5_, (gint) GTK_RESPONSE_YES);
	_tmp6_ = clear_dialog;
	_tmp7_ = gtk_dialog_run (_tmp6_);
	if (_tmp7_ == ((gint) GTK_RESPONSE_YES)) {
		Projects* _tmp8_ = NULL;
		Projects* _tmp9_ = NULL;
		_tmp8_ = projects_get_default ();
		_tmp9_ = _tmp8_;
		projects_clear_all (_tmp9_);
		_projects_unref0 (_tmp9_);
		gtk_list_store_clear (_data30_->store);
	}
	_tmp10_ = clear_dialog;
	gtk_widget_destroy ((GtkWidget*) _tmp10_);
	_g_object_unref0 (clear_dialog);
}


static void ___lambda73__gtk_button_clicked (GtkButton* _sender, gpointer self) {
	__lambda73_ (self);
}


void project_dialogs_manage_projects (MainWindow* main_window) {
	Block30Data* _data30_;
	GObject* _tmp0_ = NULL;
	GObject* _tmp1_ = NULL;
	GtkDialog* _tmp2_ = NULL;
	const gchar* _tmp3_ = NULL;
	MainWindow* _tmp4_ = NULL;
	GtkBox* content_area = NULL;
	GtkBox* _tmp5_ = NULL;
	GtkBox* _tmp6_ = NULL;
	GtkListStore* _tmp7_ = NULL;
	GtkTreeView* _tmp8_ = NULL;
	GtkTreeViewColumn* column = NULL;
	GtkTreeViewColumn* _tmp9_ = NULL;
	GtkTreeViewColumn* _tmp10_ = NULL;
	GtkTreeViewColumn* _tmp11_ = NULL;
	const gchar* _tmp12_ = NULL;
	GtkCellRendererPixbuf* pixbuf_renderer = NULL;
	GtkCellRendererPixbuf* _tmp13_ = NULL;
	GtkCellRendererPixbuf* _tmp14_ = NULL;
	GtkTreeViewColumn* _tmp15_ = NULL;
	GtkCellRendererPixbuf* _tmp16_ = NULL;
	GtkCellRendererText* text_renderer = NULL;
	GtkCellRendererText* _tmp17_ = NULL;
	GtkTreeViewColumn* _tmp18_ = NULL;
	GtkCellRendererText* _tmp19_ = NULL;
	GtkTreeViewColumn* _tmp20_ = NULL;
	GtkCellRendererText* _tmp21_ = NULL;
	GtkTreeViewColumn* _tmp22_ = NULL;
	GtkTreeViewColumn* _tmp23_ = NULL;
	GtkTreeViewColumn* _tmp24_ = NULL;
	const gchar* _tmp25_ = NULL;
	GtkCellRendererPixbuf* _tmp26_ = NULL;
	GtkCellRendererPixbuf* _tmp27_ = NULL;
	GtkTreeViewColumn* _tmp28_ = NULL;
	GtkCellRendererPixbuf* _tmp29_ = NULL;
	GtkCellRendererText* _tmp30_ = NULL;
	GtkTreeViewColumn* _tmp31_ = NULL;
	GtkCellRendererText* _tmp32_ = NULL;
	GtkTreeViewColumn* _tmp33_ = NULL;
	GtkCellRendererText* _tmp34_ = NULL;
	GtkTreeSelection* select = NULL;
	GtkTreeSelection* _tmp35_ = NULL;
	GtkTreeSelection* _tmp36_ = NULL;
	GtkScrolledWindow* sw = NULL;
	GtkScrolledWindow* _tmp37_ = NULL;
	GtkGrid* grid = NULL;
	GtkGrid* _tmp38_ = NULL;
	GtkButton* edit_button = NULL;
	const gchar* _tmp39_ = NULL;
	GtkButton* _tmp40_ = NULL;
	GtkButton* delete_button = NULL;
	const gchar* _tmp41_ = NULL;
	GtkButton* _tmp42_ = NULL;
	GtkButton* clear_all_button = NULL;
	const gchar* _tmp43_ = NULL;
	GtkButton* _tmp44_ = NULL;
	g_return_if_fail (main_window != NULL);
	_data30_ = g_slice_new0 (Block30Data);
	_data30_->_ref_count_ = 1;
	_tmp0_ = g_object_new (gtk_dialog_get_type (), "use-header-bar", TRUE, NULL, NULL);
	_tmp1_ = G_IS_INITIALLY_UNOWNED (_tmp0_) ? g_object_ref_sink (_tmp0_) : _tmp0_;
	_tmp2_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp1_, gtk_dialog_get_type ()) ? ((GtkDialog*) _tmp1_) : NULL;
	if (_tmp2_ == NULL) {
		_g_object_unref0 (_tmp1_);
	}
	_data30_->dialog = _tmp2_;
	_tmp3_ = _ ("Manage Projects");
	gtk_window_set_title ((GtkWindow*) _data30_->dialog, _tmp3_);
	gtk_window_set_destroy_with_parent ((GtkWindow*) _data30_->dialog, TRUE);
	_tmp4_ = main_window;
	gtk_window_set_transient_for ((GtkWindow*) _data30_->dialog, (GtkWindow*) _tmp4_);
	_tmp5_ = (GtkBox*) gtk_dialog_get_content_area (_data30_->dialog);
	_tmp6_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp5_, gtk_box_get_type ()) ? ((GtkBox*) _tmp5_) : NULL);
	content_area = _tmp6_;
	gtk_widget_set_size_request ((GtkWidget*) content_area, 450, 250);
	_tmp7_ = gtk_list_store_new ((gint) PROJECT_DIALOGS_PROJECT_COLUMN_N_COLUMNS, G_TYPE_STRING, G_TYPE_STRING, -1);
	_data30_->store = _tmp7_;
	project_dialogs_update_model (_data30_->store);
	_tmp8_ = (GtkTreeView*) gtk_tree_view_new_with_model ((GtkTreeModel*) _data30_->store);
	g_object_ref_sink (_tmp8_);
	_data30_->treeview = _tmp8_;
	_tmp9_ = gtk_tree_view_column_new ();
	g_object_ref_sink (_tmp9_);
	column = _tmp9_;
	_tmp10_ = column;
	gtk_tree_view_append_column (_data30_->treeview, _tmp10_);
	_tmp11_ = column;
	_tmp12_ = _ ("Directory");
	gtk_tree_view_column_set_title (_tmp11_, _tmp12_);
	_tmp13_ = (GtkCellRendererPixbuf*) gtk_cell_renderer_pixbuf_new ();
	g_object_ref_sink (_tmp13_);
	pixbuf_renderer = _tmp13_;
	_tmp14_ = pixbuf_renderer;
	g_object_set (_tmp14_, "icon-name", "folder", NULL);
	_tmp15_ = column;
	_tmp16_ = pixbuf_renderer;
	gtk_cell_layout_pack_start ((GtkCellLayout*) _tmp15_, (GtkCellRenderer*) _tmp16_, FALSE);
	_tmp17_ = (GtkCellRendererText*) gtk_cell_renderer_text_new ();
	g_object_ref_sink (_tmp17_);
	text_renderer = _tmp17_;
	_tmp18_ = column;
	_tmp19_ = text_renderer;
	gtk_cell_layout_pack_start ((GtkCellLayout*) _tmp18_, (GtkCellRenderer*) _tmp19_, TRUE);
	_tmp20_ = column;
	_tmp21_ = text_renderer;
	gtk_tree_view_column_set_attributes (_tmp20_, (GtkCellRenderer*) _tmp21_, "text", PROJECT_DIALOGS_PROJECT_COLUMN_DIRECTORY, NULL, NULL);
	_tmp22_ = gtk_tree_view_column_new ();
	g_object_ref_sink (_tmp22_);
	_g_object_unref0 (column);
	column = _tmp22_;
	_tmp23_ = column;
	gtk_tree_view_append_column (_data30_->treeview, _tmp23_);
	_tmp24_ = column;
	_tmp25_ = _ ("Main File");
	gtk_tree_view_column_set_title (_tmp24_, _tmp25_);
	_tmp26_ = (GtkCellRendererPixbuf*) gtk_cell_renderer_pixbuf_new ();
	g_object_ref_sink (_tmp26_);
	_g_object_unref0 (pixbuf_renderer);
	pixbuf_renderer = _tmp26_;
	_tmp27_ = pixbuf_renderer;
	g_object_set (_tmp27_, "icon-name", "text-x-generic", NULL);
	_tmp28_ = column;
	_tmp29_ = pixbuf_renderer;
	gtk_cell_layout_pack_start ((GtkCellLayout*) _tmp28_, (GtkCellRenderer*) _tmp29_, FALSE);
	_tmp30_ = (GtkCellRendererText*) gtk_cell_renderer_text_new ();
	g_object_ref_sink (_tmp30_);
	_g_object_unref0 (text_renderer);
	text_renderer = _tmp30_;
	_tmp31_ = column;
	_tmp32_ = text_renderer;
	gtk_cell_layout_pack_start ((GtkCellLayout*) _tmp31_, (GtkCellRenderer*) _tmp32_, TRUE);
	_tmp33_ = column;
	_tmp34_ = text_renderer;
	gtk_tree_view_column_set_attributes (_tmp33_, (GtkCellRenderer*) _tmp34_, "text", PROJECT_DIALOGS_PROJECT_COLUMN_MAIN_FILE, NULL, NULL);
	_tmp35_ = gtk_tree_view_get_selection (_data30_->treeview);
	_tmp36_ = _g_object_ref0 (_tmp35_);
	select = _tmp36_;
	gtk_tree_selection_set_mode (select, GTK_SELECTION_SINGLE);
	_tmp37_ = utils_add_scrollbar ((GtkWidget*) _data30_->treeview);
	sw = _tmp37_;
	gtk_box_pack_start (content_area, (GtkWidget*) sw, TRUE, TRUE, (guint) 0);
	_tmp38_ = (GtkGrid*) gtk_grid_new ();
	g_object_ref_sink (_tmp38_);
	grid = _tmp38_;
	gtk_orientable_set_orientation ((GtkOrientable*) grid, GTK_ORIENTATION_HORIZONTAL);
	gtk_grid_set_column_spacing (grid, (guint) 5);
	gtk_box_pack_start (content_area, (GtkWidget*) grid, FALSE, FALSE, (guint) 5);
	_tmp39_ = _ ("_Properties");
	_tmp40_ = (GtkButton*) gtk_button_new_with_mnemonic (_tmp39_);
	g_object_ref_sink (_tmp40_);
	edit_button = _tmp40_;
	_tmp41_ = _ ("_Delete");
	_tmp42_ = (GtkButton*) gtk_button_new_with_mnemonic (_tmp41_);
	g_object_ref_sink (_tmp42_);
	delete_button = _tmp42_;
	_tmp43_ = _ ("_Clear All");
	_tmp44_ = (GtkButton*) gtk_button_new_with_mnemonic (_tmp43_);
	g_object_ref_sink (_tmp44_);
	clear_all_button = _tmp44_;
	gtk_container_add ((GtkContainer*) grid, (GtkWidget*) edit_button);
	gtk_container_add ((GtkContainer*) grid, (GtkWidget*) delete_button);
	gtk_container_add ((GtkContainer*) grid, (GtkWidget*) clear_all_button);
	gtk_widget_show_all ((GtkWidget*) content_area);
	g_signal_connect_data (edit_button, "clicked", (GCallback) ___lambda71__gtk_button_clicked, block30_data_ref (_data30_), (GClosureNotify) block30_data_unref, 0);
	g_signal_connect_data (delete_button, "clicked", (GCallback) ___lambda72__gtk_button_clicked, block30_data_ref (_data30_), (GClosureNotify) block30_data_unref, 0);
	g_signal_connect_data (clear_all_button, "clicked", (GCallback) ___lambda73__gtk_button_clicked, block30_data_ref (_data30_), (GClosureNotify) block30_data_unref, 0);
	gtk_dialog_run (_data30_->dialog);
	gtk_widget_destroy ((GtkWidget*) _data30_->dialog);
	_g_object_unref0 (clear_all_button);
	_g_object_unref0 (delete_button);
	_g_object_unref0 (edit_button);
	_g_object_unref0 (grid);
	_g_object_unref0 (sw);
	_g_object_unref0 (select);
	_g_object_unref0 (text_renderer);
	_g_object_unref0 (pixbuf_renderer);
	_g_object_unref0 (column);
	_g_object_unref0 (content_area);
	block30_data_unref (_data30_);
	_data30_ = NULL;
}


gboolean project_dialogs_main_file_is_in_directory (GtkWindow* window, GFile* main_file, GFile* directory) {
	gboolean result = FALSE;
	GFile* _tmp0_ = NULL;
	GFile* _tmp1_ = NULL;
	gboolean _tmp2_ = FALSE;
	GtkDialog* error_dialog = NULL;
	GtkWindow* _tmp3_ = NULL;
	const gchar* _tmp4_ = NULL;
	GtkMessageDialog* _tmp5_ = NULL;
	GtkDialog* _tmp6_ = NULL;
	GtkDialog* _tmp7_ = NULL;
	g_return_val_if_fail (window != NULL, FALSE);
	g_return_val_if_fail (main_file != NULL, FALSE);
	g_return_val_if_fail (directory != NULL, FALSE);
	_tmp0_ = main_file;
	_tmp1_ = directory;
	_tmp2_ = g_file_has_prefix (_tmp0_, _tmp1_);
	if (_tmp2_) {
		result = TRUE;
		return result;
	}
	_tmp3_ = window;
	_tmp4_ = _ ("The Main File is not in the directory.");
	_tmp5_ = (GtkMessageDialog*) gtk_message_dialog_new (_tmp3_, GTK_DIALOG_DESTROY_WITH_PARENT, GTK_MESSAGE_ERROR, GTK_BUTTONS_OK, "%s", _tmp4_);
	g_object_ref_sink (_tmp5_);
	error_dialog = (GtkDialog*) _tmp5_;
	_tmp6_ = error_dialog;
	gtk_dialog_run (_tmp6_);
	_tmp7_ = error_dialog;
	gtk_widget_destroy ((GtkWidget*) _tmp7_);
	result = FALSE;
	_g_object_unref0 (error_dialog);
	return result;
}


static gchar* string_slice (const gchar* self, glong start, glong end) {
	gchar* result = NULL;
	glong string_length = 0L;
	gint _tmp0_ = 0;
	gint _tmp1_ = 0;
	glong _tmp2_ = 0L;
	glong _tmp5_ = 0L;
	gboolean _tmp8_ = FALSE;
	glong _tmp9_ = 0L;
	gboolean _tmp12_ = FALSE;
	glong _tmp13_ = 0L;
	glong _tmp16_ = 0L;
	glong _tmp17_ = 0L;
	glong _tmp18_ = 0L;
	glong _tmp19_ = 0L;
	glong _tmp20_ = 0L;
	gchar* _tmp21_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = strlen (self);
	_tmp1_ = _tmp0_;
	string_length = (glong) _tmp1_;
	_tmp2_ = start;
	if (_tmp2_ < ((glong) 0)) {
		glong _tmp3_ = 0L;
		glong _tmp4_ = 0L;
		_tmp3_ = string_length;
		_tmp4_ = start;
		start = _tmp3_ + _tmp4_;
	}
	_tmp5_ = end;
	if (_tmp5_ < ((glong) 0)) {
		glong _tmp6_ = 0L;
		glong _tmp7_ = 0L;
		_tmp6_ = string_length;
		_tmp7_ = end;
		end = _tmp6_ + _tmp7_;
	}
	_tmp9_ = start;
	if (_tmp9_ >= ((glong) 0)) {
		glong _tmp10_ = 0L;
		glong _tmp11_ = 0L;
		_tmp10_ = start;
		_tmp11_ = string_length;
		_tmp8_ = _tmp10_ <= _tmp11_;
	} else {
		_tmp8_ = FALSE;
	}
	g_return_val_if_fail (_tmp8_, NULL);
	_tmp13_ = end;
	if (_tmp13_ >= ((glong) 0)) {
		glong _tmp14_ = 0L;
		glong _tmp15_ = 0L;
		_tmp14_ = end;
		_tmp15_ = string_length;
		_tmp12_ = _tmp14_ <= _tmp15_;
	} else {
		_tmp12_ = FALSE;
	}
	g_return_val_if_fail (_tmp12_, NULL);
	_tmp16_ = start;
	_tmp17_ = end;
	g_return_val_if_fail (_tmp16_ <= _tmp17_, NULL);
	_tmp18_ = start;
	_tmp19_ = end;
	_tmp20_ = start;
	_tmp21_ = g_strndup (((gchar*) self) + _tmp18_, (gsize) (_tmp19_ - _tmp20_));
	result = _tmp21_;
	return result;
}


void project_dialogs_update_model (GtkListStore* model) {
	GtkListStore* _tmp0_ = NULL;
	g_return_if_fail (model != NULL);
	_tmp0_ = model;
	gtk_list_store_clear (_tmp0_);
	{
		GeeIterator* _project_it = NULL;
		Projects* _tmp1_ = NULL;
		Projects* _tmp2_ = NULL;
		GeeIterator* _tmp3_ = NULL;
		GeeIterator* _tmp4_ = NULL;
		_tmp1_ = projects_get_default ();
		_tmp2_ = _tmp1_;
		_tmp3_ = projects_iterator (_tmp2_);
		_tmp4_ = _tmp3_;
		_projects_unref0 (_tmp2_);
		_project_it = _tmp4_;
		while (TRUE) {
			GeeIterator* _tmp5_ = NULL;
			gboolean _tmp6_ = FALSE;
			Project project = {0};
			GeeIterator* _tmp7_ = NULL;
			gpointer _tmp8_ = NULL;
			Project* _tmp9_ = NULL;
			Project _tmp10_ = {0};
			Project _tmp11_ = {0};
			gchar* uri_directory = NULL;
			Project _tmp12_ = {0};
			GFile* _tmp13_ = NULL;
			gchar* _tmp14_ = NULL;
			gchar* uri_main_file = NULL;
			Project _tmp15_ = {0};
			GFile* _tmp16_ = NULL;
			gchar* _tmp17_ = NULL;
			gchar* dir = NULL;
			const gchar* _tmp18_ = NULL;
			gchar* _tmp19_ = NULL;
			gchar* _tmp20_ = NULL;
			gchar* _tmp21_ = NULL;
			gchar* _tmp22_ = NULL;
			gchar* main_file = NULL;
			const gchar* _tmp23_ = NULL;
			const gchar* _tmp24_ = NULL;
			gint _tmp25_ = 0;
			gint _tmp26_ = 0;
			const gchar* _tmp27_ = NULL;
			gint _tmp28_ = 0;
			gint _tmp29_ = 0;
			gchar* _tmp30_ = NULL;
			GtkTreeIter iter = {0};
			GtkListStore* _tmp31_ = NULL;
			GtkTreeIter _tmp32_ = {0};
			GtkListStore* _tmp33_ = NULL;
			GtkTreeIter _tmp34_ = {0};
			const gchar* _tmp35_ = NULL;
			const gchar* _tmp36_ = NULL;
			_tmp5_ = _project_it;
			_tmp6_ = gee_iterator_next (_tmp5_);
			if (!_tmp6_) {
				break;
			}
			_tmp7_ = _project_it;
			_tmp8_ = gee_iterator_get (_tmp7_);
			_tmp9_ = (Project*) _tmp8_;
			project_copy (_tmp9_, &_tmp10_);
			_tmp11_ = _tmp10_;
			_project_free0 (_tmp9_);
			project = _tmp11_;
			_tmp12_ = project;
			_tmp13_ = _tmp12_.directory;
			_tmp14_ = g_file_get_parse_name (_tmp13_);
			uri_directory = _tmp14_;
			_tmp15_ = project;
			_tmp16_ = _tmp15_.main_file;
			_tmp17_ = g_file_get_parse_name (_tmp16_);
			uri_main_file = _tmp17_;
			_tmp18_ = uri_directory;
			_tmp19_ = latexila_utils_replace_home_dir_with_tilde (_tmp18_);
			_tmp20_ = _tmp19_;
			_tmp21_ = g_strconcat (_tmp20_, "/", NULL);
			_tmp22_ = _tmp21_;
			_g_free0 (_tmp20_);
			dir = _tmp22_;
			_tmp23_ = uri_main_file;
			_tmp24_ = uri_directory;
			_tmp25_ = strlen (_tmp24_);
			_tmp26_ = _tmp25_;
			_tmp27_ = uri_main_file;
			_tmp28_ = strlen (_tmp27_);
			_tmp29_ = _tmp28_;
			_tmp30_ = string_slice (_tmp23_, (glong) (_tmp26_ + 1), (glong) _tmp29_);
			main_file = _tmp30_;
			_tmp31_ = model;
			gtk_list_store_append (_tmp31_, &_tmp32_);
			iter = _tmp32_;
			_tmp33_ = model;
			_tmp34_ = iter;
			_tmp35_ = dir;
			_tmp36_ = main_file;
			gtk_list_store_set (_tmp33_, &_tmp34_, PROJECT_DIALOGS_PROJECT_COLUMN_DIRECTORY, _tmp35_, PROJECT_DIALOGS_PROJECT_COLUMN_MAIN_FILE, _tmp36_, -1, -1);
			_g_free0 (main_file);
			_g_free0 (dir);
			_g_free0 (uri_main_file);
			_g_free0 (uri_directory);
			project_destroy (&project);
		}
		_g_object_unref0 (_project_it);
	}
}



